/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.beans;

import java.awt.*;
import java.awt.event.*;
import org.freebuilder.system.ideengine.*;
import com.sun.java.swing.*;


/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
public class GotoLineNumberDialog extends Dialog implements ActionListener {
  private static final int Inset = 4;

  private String OK_CMD     = "OK";
  private String CANCEL_CMD = "Cancel";
  private boolean Confirmed;

  private Button OKButton     = new Button(OK_CMD);
  private Button CancelButton = new Button(CANCEL_CMD);
  private BPanel LineNumberPanel = new BPanel ("Line Number :");

  private JTextField LineNumber = new JTextField();

  private BPanel ButtonsPanel = new BPanel();

  public GotoLineNumberDialog () {
    super (Globals.IdeMainFrame, "Goto Line Nuber", true);

    ButtonsPanel.setLayout (new GridLayout (1, 2, 5, 5));
    ButtonsPanel.add (OKButton);
    ButtonsPanel.add (CancelButton);

    LineNumberPanel.setLayout (new BorderLayout());
    LineNumberPanel.add       (LineNumber);

    setLayout (new BorderLayout());
    Insets I = getInsets ();
    I.top    += Inset;
    I.left   += Inset;
    I.right  += Inset;
    I.bottom += Inset;
    add (LineNumberPanel, BorderLayout.NORTH);
    add (ButtonsPanel, BorderLayout.SOUTH);
    OKButton    .addActionListener (this);
    CancelButton.addActionListener (this);
    pack();
    Misc.hardCenter (this);
  }

  public void actionPerformed (ActionEvent e) {
    if (e.getSource().equals (OKButton))
      Confirmed = true;
    else
      Confirmed = false;
    setVisible (false);
  }

  public boolean isConfirmed () {
    return Confirmed;
  }

  public int getLineNumber () {
    int Ret;
    try {
      Ret = (new Integer(LineNumber.getText())).intValue();
    } catch (Exception e) {Ret = 0;}
    return Ret;
  }
}

