/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.beans;

import java.io.*;
import java.awt.*;
import java.util.*;
import java.awt.event.*;

import com.sun.java.swing.*;
import com.sun.java.swing.tree.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.plaf.basic.*;

import org.freebuilder.system.ideengine.*;
import org.freebuilder.system.packages.*;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
  * @version 0.7, 07-01-98
*/
class MyTreeNode implements TreeNode {
  private Vector Children = null;
  private MyTreeNode MyParent;
  private String Name = "";
  private File CurrentDir;
  private DirectoryChooser TheDialog;

  public MyTreeNode (DirectoryChooser TheBoss, MyTreeNode Parent, File CurrentDir) {
    int i;
    MyParent = Parent;
    TheDialog = TheBoss;
    Name = CurrentDir.getName();
    if (Name.compareTo(".") == 0) {
      Name = CurrentDir.getAbsolutePath();
      Name = Name.substring (0, Name.length()-1);
    }
    if (Name.length() == 0) 
      Name = CurrentDir.getAbsolutePath();

    this.CurrentDir = CurrentDir;
  }

  public String toString () {
    return Name;
  }

  public Enumeration children() {
    if (Children == null)
      getChildCount();
    return Children.elements();
  }

  public boolean getAllowsChildren() {
    return true;
  }

  public TreeNode getChildAt (int Index) {
    if (Children == null)
      getChildCount();
    return (MyTreeNode) Children.elementAt(Index);
  }

  public int getChildCount(boolean All) {
    int i;
    Children = new Vector();
    String [] TypedFiles = CurrentDir.list();
    if (TypedFiles == null)
      return 0;

    TheDialog.setCursor (new Cursor(Cursor.WAIT_CURSOR));
    for (i = 0; i < TypedFiles.length; i++) {
      File F = new File (CurrentDir , TypedFiles[i]);
      if (F.isDirectory()) {
        MyTreeNode AChild = new MyTreeNode (TheDialog, this, F);
        Children.addElement (AChild);
        if (!All) {
          TheDialog.setCursor (new Cursor(Cursor.DEFAULT_CURSOR));
          return 1;
        }
      }
    }
    TheDialog.setCursor (new Cursor(Cursor.DEFAULT_CURSOR));
    return Children.size();
  }

  public int getChildCount() {
    return getChildCount (true);
  }

  public int getIndex(TreeNode Child) {
    if (Children == null)
      getChildCount();
    return Children.indexOf (Child);
  }

  public TreeNode getParent() {
    return MyParent;
  }

  public boolean isLeaf() {
    if (Children == null)
      getChildCount(false);
    return (Children.size() == 0);
  }

  public TreePath getPathToNode (String [] ThePath, int CurrentPos) {
    String CurrentName = ThePath[CurrentPos];

    if (Name.compareTo (CurrentName) != 0)
      return null;

    if (CurrentPos == ThePath.length - 1) {
      Object [] TheRetPath = new Object [ThePath.length];
      int i = CurrentPos;
      TreeNode CurrentItem = this;
      do {
        TheRetPath[i] = CurrentItem;
        i--;
        CurrentItem = CurrentItem.getParent();
      } while (i >= 0);
      TreePath Ret = new TreePath (TheRetPath);
      return Ret;
    }

    int i;
    int Count = getChildCount();
    for (i = 0; i < Count; i++) {
      MyTreeNode CurrentChild = (MyTreeNode) getChildAt(i);
      TreePath PathToNode = CurrentChild.getPathToNode(ThePath, CurrentPos+1);
      if (PathToNode != null) {
        return PathToNode;
      }
    }
    return null;
  }
}

/**
  *  @author	Peter Radkov <wreck@nat.bg>
  *  @version 0.7, 07-01-98
*/
class InitTreeThread extends Thread {
  private DirectoryChooser Parent;
  public InitTreeThread (DirectoryChooser TheDialog) {
    Parent = TheDialog;
  }

  public void run () {
    JTree TheTree = Parent.getTree();
    if (TheTree == null) {
      Parent.setCursor (new Cursor(Cursor.WAIT_CURSOR));
      TheTree = Parent.prepareFilesTree();
      Parent.setTree(TheTree);
      Parent.setCursor (new Cursor(Cursor.DEFAULT_CURSOR));
    }
    stop();
  }
}

/**
  *  @author	Peter Radkov <wreck@nat.bg>
  *  @version 0.7, 07-01-98
*/
public class DirectoryChooser extends JDialog implements TreeSelectionListener, KeyListener, ActionListener {

  private static String OK_CMD     = "OK";
  private static String CANCEL_CMD = "Cancel";

  private BPanel ButtonsPanel       = new BPanel ();
  private BPanel MainPanel          = new BPanel ("Directories");
  private BPanel OuterPanel         = new BPanel ();
  private Button OKButton           = new Button (OK_CMD);
  private Button CancelButton       = new Button (CANCEL_CMD);
  private JScrollPane TheScrollPane = new JScrollPane ();
  private JPanel ScrollBuffer       = new JPanel();
  private JPanel TreeBuffer         = new JPanel();
  private TreeNode TheRoot;
  private Rectangle PrevSelPathBounds;

  protected String Directory;
  protected JTree TheTree;
  protected JTextField TheFile      = new JTextField ();

  public DirectoryChooser (Frame Parent) {
    super (Parent);

    setTitle ("Choose a directory");
    setModal (true);
    getContentPane().setLayout (new BorderLayout());
    getContentPane().add (OuterPanel, BorderLayout.CENTER);

    OuterPanel.setInner       (BPanel.NONE);
    OuterPanel.setOuter       (BPanel.NONE);
    OuterPanel.setBorderWidth (3);

    OuterPanel.setLayout (new BorderLayout());
    OuterPanel.add (ButtonsPanel, BorderLayout.SOUTH);
    OuterPanel.add (MainPanel,    BorderLayout.CENTER);
    OuterPanel.add (TheFile,      BorderLayout.NORTH);

    MainPanel.setLayout (new BorderLayout());
    ScrollBuffer.setLayout (new BorderLayout());
    ScrollBuffer.add(TheScrollPane);
    MainPanel.add (ScrollBuffer, BorderLayout.CENTER);
    TreeBuffer.setLayout (new BorderLayout());

    ButtonsPanel.setLayout (new GridLayout(1, 2, 5, 5));
    ButtonsPanel.add (OKButton);
    ButtonsPanel.add (CancelButton);
    TheFile.addKeyListener (this);

    OKButton    .addActionListener (this);
    CancelButton.addActionListener (this);

    Dimension ScreenSize = getToolkit().getScreenSize();
    setSize (ScreenSize.width * 2 / 5, ScreenSize.height * 2 / 5);
    Misc.hardCenter (this);
    initTree();
  }

  public JTree getTree () {
    return TheTree;
  }

  protected void adjustTree () {
    TheTree.addTreeSelectionListener (this);
    BasicTreeCellRenderer TheRenderer = (BasicTreeCellRenderer)(TheTree.getCellRenderer());
    TheRenderer.setLeafIcon(TheRenderer.getClosedIcon());
    if (TreeBuffer.getComponentCount() > 0)
      TreeBuffer.removeAll();
    TreeBuffer.add (TheTree, BorderLayout.CENTER);
    TheScrollPane.getViewport().setView (TreeBuffer);
    TreeBuffer.invalidate();
    MainPanel.validate();
  }

  public void setTree (JTree NewTree) {
    TheTree = NewTree;
    adjustTree();
  }

  private String [] getPath (String AbsPath) {
    Vector Dirs = new Vector ();
    int i;
    String CurrentDir;

    while (AbsPath.length () != 0) {
      int j = AbsPath.indexOf (Globals.FileSeparator);
      if (j == -1)
        j=AbsPath.length();
      CurrentDir = AbsPath.substring (0, j);
      if (CurrentDir.endsWith (":"))
        CurrentDir += Globals.FileSeparator;
      Dirs.addElement (CurrentDir);
      if (j == AbsPath.length())
        break;
      AbsPath = AbsPath.substring (j+1, AbsPath.length());
    }
    String [] Ret = new String [Dirs.size()];
    Dirs.copyInto(Ret);
    return Ret;
  }

  private void initTree () {
    if (TheTree == null) {
      InitTreeThread Filler = new InitTreeThread (this);
      Filler.start();
    }
  }

  public void keyPressed  (KeyEvent e) {
    if (e.getKeyCode() == e.VK_ENTER) {
      File F = new File (TheFile.getText(), ".");
      if (F.isDirectory()) {
        File F1 = new File (F, ".");
        while (F1.getParent() != null)
          F1 = new File (F1.getParent());

        TheRoot = new MyTreeNode (this, null, new File (F1, "."));
        TheTree.removeTreeSelectionListener (this);
        setTree (new JTree (TheRoot));

        String [] TypedPath = getPath (F.getAbsolutePath());
        TreePath ThePath = ((MyTreeNode) TheRoot).getPathToNode (TypedPath, 0);
        if (ThePath != null)
          TheTree.setSelectionPath (ThePath);
      }
    }
  }
  public void keyReleased (KeyEvent e) {}
  public void keyTyped    (KeyEvent e) {}

  protected void onExit() {}

  public void actionPerformed (ActionEvent e) {
    String CMD = e.getActionCommand ();
    if (CMD == OK_CMD) {
      if (TheFile.getText().length() == 0)
        return;
      Directory = TheFile.getText();
      onExit();
    }

    if (CMD == CANCEL_CMD)
      Directory = null;

    setVisible (false);
  }

  protected void setText (Object [] Path) {
    String S = "";
    for (int i = 0; i < Path.length; i++) {
      S += Path[i];
      if ((!S.endsWith (Globals.FileSeparator)) &&
          (i < Path.length-1))
        S += Globals.FileSeparator;
    }
    TheFile.setText (S);
  }

  public void valueChanged (TreeSelectionEvent e) {
    Object[] Path;
    if (TheTree.getSelectionPath() != null)
      Path = TheTree.getSelectionPath().getPath();
    else
      return;
    setText(Path);
    Rectangle ToRepaint = TheTree.getPathBounds (TheTree.getSelectionPath());
    if (PrevSelPathBounds != null)
      TreeBuffer.repaint (PrevSelPathBounds.x, PrevSelPathBounds.y,
                          PrevSelPathBounds.width, PrevSelPathBounds.height);
    TreeBuffer.repaint (ToRepaint.x, ToRepaint.y, ToRepaint.width, ToRepaint.height);
    PrevSelPathBounds = ToRepaint;
  }

  public String getDirectory () {
    return Directory;
  }

  public JTree prepareFilesTree () {
    File Dirs = new File (Globals.HomeDirectory);
    while (Dirs.getParent() != null)
      Dirs = new File (Dirs.getParent());
    TheRoot = new MyTreeNode (this, null, new File (Dirs, "."));
    JTree Ret = new JTree (TheRoot);
    return Ret;
  }
}



