/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui;
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;

import org.freebuilder.system.classes.options.manager.*;
import org.freebuilder.system.classes.events.engine.*;
import org.freebuilder.system.classes.*;
import org.freebuilder.system.ideengine.*;

import org.freebuilder.gui.xysaveframe.*;
import org.freebuilder.gui.idemenu.*;

import org.freebuilder.gui.ideoptions.abstr.*;
import org.freebuilder.gui.ideoptions.*;
import org.freebuilder.gui.ide.*;
import org.freebuilder.gui.beans.*;

/** <code>IdeTitleFrame</code>  This is the FreeBuilder's main frame
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
  * @version 0.7, 07-01-98
*/

public class IdeTitleFrame extends XySaveFrame {
  IdeMainMenu     MMenu   = null;
  // ---------------------------------------------------------
    IdeBeansPalette BeansPalette;
    SpeedPanel      TitleSpeedPanel;
    JPanel           pnlTitle;
  // ---------------------------------------------------------

  public IdeTitleFrame(String AOptionsName) {
    super(AOptionsName);
    InitFrame();
    InitConfig();
    setDefaultCloseOperation (DO_NOTHING_ON_CLOSE);
  }

  protected void AssignOptionsToFrame(XyFrameOptions AOptions) {
    super.AssignOptionsToFrame(AOptions);
    if (! isVisible())
      setVisible(true);
  }


  protected void InitFrame() {
    try {
      Init();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  // From WindowListener interface -------------------------------------------------
  public void windowClosing    (WindowEvent e) {
    Globals.EventsEngine.PostEvent (new MainMenuEvent(IdeMainMenu.msgmiFileExit, this));
  }
  //-------------------------------------------------------------------------------

  IdeBeansPalette CreateBeansPalette() {
    IdeBeansPalette BeansPalette = new IdeBeansPalette();
    // BeansPalette.MakeDemoConfiguration();
    return BeansPalette;
  }

  public void InitGui() {
    BeansPalette    = CreateBeansPalette();
    TitleSpeedPanel = new SpeedPanel();
    pnlTitle        = new JPanel();

    pnlTitle.setLayout (new BorderLayout(2,2));

    pnlTitle.add (BeansPalette,    BorderLayout.CENTER);
    pnlTitle.add (TitleSpeedPanel, BorderLayout.WEST);

    getContentPane().add (pnlTitle , BorderLayout.NORTH);
  }

  public void CreateDefaultSizeLocation() {
    Dimension screenSize       = Toolkit.getDefaultToolkit().getScreenSize();
    setSize(screenSize.width, screenSize.height * 4 / 5);
    setLocation(0,0);
  }

  public void Init() throws Exception{
    // ----------------------------------------------------------------------------
    MMenu = Globals.IEngine.getMainMenu();
//    MMenu.setFont(new Font("TimesRoman", 0, 26));
/*
    for (int i = 0; i < MMenu.getMenuCount(); i++) {
      JPopupMenu CurrentPopup = MMenu.getMenu(i).getPopupMenu();
      CurrentPopup.setLightWeightPopupEnabled (false);
    }
*/
    setJMenuBar(MMenu);
    Globals.IEngine.AddMainMenuAdapter(IdeMainMenu.msgmiHelpAbout, this, "OnHelpAbout");
    // ----------------------------------------------------------------------------
    InitGui();
    setIconImage (Globals.ResourceMngr.loadImage (Globals.IconsDir + "Icon.gif"));
    setTitle ("Free Builder");
  }

  public void showAboutWindow () {
    if (!AboutWindow.IsVisible) {
      AboutWindow About = new AboutWindow (this, "AboutFreeBuilder.gif");
      About.setVisible (true);
    }
  }

  public void OnHelpAbout (IdeSuperEvent AEvent) {
    AboutDialog AboutD = new AboutDialog();
    AboutD.setVisible (true);
  }
}

