unit X_const;

(*
    Global equates and variables


    ****** XLIB - Mode X graphics library                ****************
    ******                                               ****************
    ****** Written By Themie Gouthas ( C-Version )       ****************
    ****** Converted By Christian Harms in TP            ****************

    Gouthas : egg@dstos3.dsto.gov.au or teg@bart.dsto.gov.au
    Harms   : harms@minnie.informatik.uni-stuttgart.de

    Terminology & notes:
           VRAM ==   Video RAM
           SRAM ==   System RAM
           X coordinates are in pixels unless explicitly stated
*)

interface

const AC_INDEX        = $03c0;  (* Attribute controller index register    *)
      MISC_OUTPUT     = $03c2;  (* Miscellaneous Output register          *)
      SC_INDEX        = $03c4;  (* Sqence Controller Index                *)
      GC_INDEX        = $03ce;  (*  Graphics controller Index             *)
      CRTC_INDEX      = $03d4;  (* CRT Controller Index                   *)
      DAC_READ_INDEX  = $03c7;
      DAC_WRITE_INDEX = $03c8;
      DAC_DATA	      = $03c9;
      INPUT_STATUS_0  = $03da;  (* Input status 0 register                *)


      SCREEN_SEG    =   $A000;  (* segment of display memory in mode X    *)

      MAP_MASK      =   $02;    (* index in SC of Map Mask register       *)
      READ_MAP      =   $04;    (* index in GC of the Read Map register   *)
      BIT_MASK      =   $08;    (* index in GC of Bit Mask register       *)

      OVERFLOW      =   $07;    (*  CRTC overflow register index          *)
      MAX_SCAN_LINE =   $09;    (*  CRTC maximum scan line register index *)
      ADDR_HIGH     =   $0c;    (* Index of Start Address High reg in CRTC*)
      ADDR_LOW      =   $0d;    (*                        Low             *)
      CRTC_OFFSET   =   $13;    (*  CRTC offset register index            *)
      UNDERLINE     =   $14;    (*  CRTC underline location register index*)
      MODE_CONTROL  =   $17;    (*  CRTC mode control register index      *)
      LINE_COMPARE  =   $18;    (*  CRTC line compare reg. index (bits 0-7
			            of split screen scan line             *)

      AC_MODE_CONTROL = $10;    (*  Index of Mode COntrol register in AC  *)
      PEL_PANNING     = $13;    (*  Pel panning register index in AC      *)

      PATTERN_BUFFER  = $0fffc; (* offset in screen memory of pattern buffer *)

      OK              = 0;
      ERROR           = 1;
      GetMaxColor     = 255;

      X_MODE_320x200  =  0;
      X_MODE_320x240  =  1;
      X_MODE_360x200  =  2;
      X_MODE_360x240  =  3;
      X_MODE_376x282  =  4;
      X_MODE_320x400  =  5;
      X_MODE_320x480  =  6;
      X_MODE_360x400  =  7;
      X_MODE_360x480  =  8;
      X_MODE_360x360  =  9;
      X_MODE_376x308  = 10;
      X_MODE_376x564  = 11;
      X_MODE_256x200  = 12;
      X_MODE_256x240  = 13;


      X_BACKWARD      = 0;
      X_FORWARD       = 1;

      X_MODE_INVALID  = -1;


type  Palette = Array[0..255,0..2] of Byte;

(* ---------------------------------------------------------------------- *)
(* Global variables - XMAIN exports                                       *)

var InGraphics             :Boolean;(* non zero if in X graphics mode      *)
    CurrXMode              :word;  (* contains current X graphics mode id *)
    ScrnPhysicalByteWidth  :word;  (* Physical screen width in bytes      *)
    ScrnPhysicalPixelWidth :word;  (* Physical screen width in pixels     *)
    ScrnPhysicalHeight     :word;  (* Physical screen height in pixels    *)
    ErrorValue             :byte;  (* Error return value                  *)
    GetMaxX                :Word absolute ScrnPhysicalPixelWidth;
    GetMaxY                :Word absolute ScrnPhysicalHeight;

    SplitScrnOffs          :word;  (* Offset in VRAM  of split screen     *)
    SplitScrnScanLine      :word;  (* Scan line split screen starts at    *)
				   (* initially. Resizing the split scrn  *)
				   (* using the other functions does not  *)
				   (* change this value                   *)
    SplitScrnVisibleHeight :word;  (* Height of the visible portion of the*)
				   (* split screen.                       *)
    SplitScrnActive        :Boolean;
    Page0_Offs             :word;  (* Offset in VRAM of main virt. screen *)
    Page1_Offs             :word;  (* Offset in VRAM of 2nd virt. screen  *)
    Page2_Offs             :Word;
    ScrnLogicalByteWidth   :word;  (* Virtual screen width in bytes       *)
    ScrnLogicalPixelWidth  :word;  (* Virtual screen width in pixels      *)
    ScrnLogicalHeight      :word;  (* Virtual screen height in pixels     *)

    MaxScrollX             :word;  (* Max X position of physical screen   *)
                                   (*  within virtual screen              *)
    MaxScrollY             :word;  (* Max Y position of physical screen   *)
                                   (*  within virtual screen              *)
    DoubleBufferActive     :word;  (* Indicates whether double buffering  *)
                                   (* is active                           *)
    VisiblePageIdx         :word;  (* Index number of visible page 0 or 1 *)
    VisiblePageOffs        :word;  (* Offset of Hidden Pg | only valid    *)
    ScreenOfs              :word absolute VisiblePageOffs;
    HiddenPageOffs         :word;  (* Offset of Visible Pg| for D.B. mode *)
    NonVisual_Offs         :word;  (* Offset of first non-visible VRAM    *)
    BGSaveOffs             :Word;

    TopClip                :word;  (* Clipping rectangle                  *)
    BottomClip             :word;
    LeftClip               :word;
    RightClip              :word;

    PhysicalStartPixelX    :word;  (* Coordinates of physical (visible)   *)
    PhysicalStartByteX     :word;  (* screen relative to the virtual      *)
    PhysicalStartY         :word;  (* screen's U.L. corner                *)

    Active_StartX          :Word;  (* absolute pos. U.L. corner of active *)
    Active_StartY          :Word;  (* page.                               *)
    Gray0,Gray1,Gray2,Gray3,Gray4,Gray5:Byte;

procedure WaitVsyncStart;
procedure WaitVsyncEnd;

implementation

(* --------------------------------------------------------------------- *)
(* Procedure to wait for the vertical retrace leading edge               *)

procedure WaitVsyncStart; assembler;
asm;
	mov     dx,INPUT_STATUS_0
@WaitNotVsync:
	in      al,dx
	test    al,08h
	jnz     @WaitNotVsync
@WaitVsync:
	in      al,dx
	test    al,08h
	jz      @WaitVsync
end;

(* --------------------------------------------------------------------  *)
(* Procedure to wait for the vertical retrace trailing edge              *)

procedure WaitVsyncEnd;  assembler;
asm;
	mov     dx,INPUT_STATUS_0
@WaitVsync2:
	in      al,dx
	test    al,08h
	jz     @WaitVsync2
@WaitNotVsync2:
	in      al,dx
	test    al,08h
	jnz    @WaitNotVsync2
end;

begin;
  InGraphics := False;
  BGSaveOffs := $FFFF;
  Gray0      :=   0;
  Gray1      := 252;
  Gray2      := 253;           (* included from set_RGB_pal in unit X_Lib, *)
  Gray3      := 153;           (* Add_ButtonGray in X_Button ...           *)
  Gray4      := 202;
  Gray5      := 255;
end.