unit X_Break;
(*
    procedures to break a program and return to dos.

    ****** XLIB - Mode X graphics library                ****************
    ******                                               ****************
    ****** Written By Christian Harms                    ****************

    Harms   : harms@minnie.informatik.uni-stuttgart.de

*)

interface
{$F+}
type BreakProc = Procedure;
{$F-}
(* Leitet Ctrl+Break auf eigene Procedure P um. P mu mit {$F+} als eine   *)
(* far-Procedure deklariert worden sein.                                   *)
(* Init the Ctrl+Break-interrupt to your procedure. P have to far, this    *)
(* means enclosed by {$F+} and {$F-}.                                      *)
procedure InitBreak(P:BreakProc);

(* Fr InitBreak eine Default-Procedure, um ein Programm zu beenden.       *)
(* default Break-procedure to end your programm.                           *)
procedure MyDummy;

(* Setzt den alten Ctrl+Break-Vektor wieder her. (Auch in INTR-Proc. drin) *)
(* Set the old Ctrl+Break.                                                 *)
procedure RestoreBreak;


implementation

var OldBreakInt : LongInt;
    MyBreak     : BreakProc;

(* Nach InitBreak(MyDummy); wird das aktuelle Programm nach Ctrl+Break ein- *)
(* fach beendet.                                                            *)
{$F+}
procedure MyDummy;
begin;
  Halt;      (* Hier knnte zustzlich noch z.B.: MyMouseDestroy;  stehen.  *)
end;
{$F-}

procedure RestoreBreak;    assembler;
asm
       xor  ax,ax
       cmp  [offset OldBreakInt],ax
       je  @raus
       cmp  [offset OldBreakInt+2],ax
       je  @raus

       push ds
       mov  ax,[offset OldBreakInt  ]
       mov  ds,ax
       mov  dx,[offset OldBreakInt+2]
       mov  ax,$251B
       int  21h
       pop  ds
@raus:
end;

procedure MyInt; interrupt;
begin;
  RestoreBreak;
  MyBreak;
end;

procedure InitBreak(P:BreakProc);
begin;
  asm
       mov  ax,$351B       (* Get int 1B interrupt vector           *)
       int  21h            (* Call dos                              *)
       mov  [offset OldBreakInt  ],es
       mov  [offset OldBreakInt+2],bx

       push ds
       mov  ax,SEG MyInt
       mov  ds,ax
       mov  dx,OFFSet MyInt
       mov  ax,$251B
       int  21h
       pop  ds
  end;
  MyBreak:=P;
end;

begin;
  OldBreakInt := 0;
  MyBreak     := MyDummy;
end.
