(*

Mark:
Here's a Pascal version of the test procedure InitGraphics
I used for "mode X" in 640x400x256 mode. If people could try these
procedures out and e-mail me of the results I'll post the summery. Don't
forget to tell me what video card you are using.


Cheers, Mark

email : u914097@student.canberra.edu.au

*)


uses crt,x_const,x_bitmap,x_pal,x_main,x_mouse,x_Keys,x_text;

procedure InitGraphics;
begin
  asm
    { Set graphics mode }
    mov ax, $5E
    int $10
  end;

  { Bit 4 of graphics mode register off }
  Port[$3CE] := 5;
  Port[$3CF] := Port[$3CF] and 239;

  { Bit 1 of misc register off }
  Port[$3CE] := 6;
  Port[$3CF] := Port[$3CF] and 253;

  { Bit 3 of memory mode register off }
  Port[$3C4] := 4;
  Port[$3C5] := Port[$3C5] and 247;

  { Bit 6 of underline reg register off }
  Port[$3D4] := $14;
  Port[$3D5] := Port[$3D5] and 191;

  { Bit 6 of mode control register on }
  Port[$3D4] := $17;
  Port[$3D5] := Port[$3D5] or 64;

  ScrnLogicalByteWidth:=160;
  GetMaxX:=640;
  GetMaxY:=400;
  ScrnLogicalPixelWidth:=640;
  ScrnLogicalHeight:=409

end;

var i:Word;
    ok:Boolean;
    error:Integer;
begin;
  x_set_mode(0,300);  (* to reset all variable *)
  InitGraphics;

  x_set_rgb_pal;
  X_ClearAll;


  x_load_put_pbm(400,1,'odie.pbm');

  x_circle(100,100,50,20);

  for i:=1 to 100 do PutPixel(i*2,i*2,i);

  MyMouseInit;
  DefineMouseCursor(MyMouseForm,Gray5);
  SetMouseWindow(0,0,GetMaxX+4,getMaxY+4);
  OldMouseTyp   := true;

  x_text_init;
  x_set_font(0);
  E_Write(1,GetMaxY-30,Gray5,Gray3,'Press Return to Exit.');

  Wait_Key(#13);

  HideMouse;
  MyMouseDestroy;

  x_text_mode;
end.
