unit X_Keys;

(*
    Procedures to manipulate keybuffer (emulation)

    ****** XLIB - Mode X graphics library                ****************
    ******                                               ****************
    ****** Written By Christian Harms in TP              ****************

    Harms   : harms@minnie.informatik.uni-stuttgart.de

    documentation in german and english
*)

interface

uses crt;

const NULL      = #0 ;
      BackSpace = #8 ;
      Back      = #8 ;
      TAB       = #9 ;
      Enter     = #13;
      Return    = #13;
      ESC       = #27;
      Space     = #32;
(* vor alle nchsten Codes kommt immer ein "NULL"-Zeichen ( #0 ) !        *)
(* The next key-Codes are first a chr(0), following the code !            *)
      Shift_TAB = #15;
      F1        = ';';
      F2        = '<';
      F3        = '=';
      F4        = '>';
      F5        = '?';
      F6        = '@';
      F7        = 'A';
      F8        = 'B';
      F9        = 'C';
      F10       = 'D';
      links     = 'K';       left   = links;
      rechts    = 'M';       right  = rechts;
      runter    = 'P';       down   = runter;
      hoch      = 'H';       up     = hoch;
      Ende      = 'O';
      Home      = 'G';
      PgUp      = 'I';
      PgDown    = 'Q';
      Ins       = 'R';
      Del       = 'S';


(* Liest Tasten ein und bergibt diese.                                     *)
(* Get a character, if pressed or in Buffer.                                *)
function ReadKeys:Char;

(* Gibt true zurck, wenn Readkeys einen Wert bereit hlt.                  *)
(* true, if key pressed or key from Set_Key_Makro in Buffer (see keypressed)*)
function keysPressed:Boolean;

(* Wartet so lange, bis die entsprechende Taste gedckt wurde .             *)
(* Wait, until key a is pressed.                                            *)
procedure Wait_Key(A:Char);

(* Simuliert Tastenbettigung (in der Reihenfolge des Strings)              *)
(* Emutaled key-pressing                                                    *)
procedure Set_Key_Makro(S:String);

(* Clear the Set_Key_Makro-Buffer .                                         *)
procedure Clear_Buffer;



implementation

var
    TastenBuffer : Array[1..256] of Char;
    Keys_Pointer : Byte;

function ReadKeys:Char;
var a:Char;
begin;
  if Keys_Pointer>0 then begin;
                           a:=TastenBuffer[Keys_Pointer];
                           Dec(Keys_Pointer);
                         end
                    else begin;
                           a:=ReadKey;
                         end;
  ReadKeys:=a;
end;

function KeysPressed:Boolean;
begin;
  KeysPressed:=KeyPressed or (Keys_Pointer>0);
end;

procedure Wait_Key(A:Char);
begin;
  repeat;
  until ReadKeys=a;
end;

procedure Set_Key_Makro(S:String);
var i:Byte;
begin;
  if  ord(s[0])+Keys_Pointer>255 then s[0]:=chr(255-Keys_Pointer);

  for i:=ord(s[0]) downto 1 do TastenBuffer[i+Keys_Pointer]:=s[ord(s[0])-i+1];

  Keys_Pointer:=Keys_Pointer+ord(s[0]);
end;

procedure Clear_Buffer;
var a:Char;
begin;
  while keyspressed do a:=ReadKeys;
end;

begin;
  Keys_Pointer:=0;
end.



