Unit X_Button;
(*

    Ok, here is the Unit, who can manages Mouse Buttons and so on.

    ****** XLIB - Mode X graphics library                ****************
    ******                                               ****************
    ****** Written By Christian Harms in TP              ****************

    Harms   : harms@minnie.informatik.uni-stuttgart.de

    comments in german and english

*)

interface
uses X_Const;

const left     = 1;     (* MouseButton - Mask *)
      right    = 2;
      both     = left or right;

      PickUp   = $80;   (* Button Click and UnClick over the Button     *)
      RunOver  = $40;   (* Pressed MouseButton can leave the Button Area*)
                        (* => Activated Button  *)
      Click    = $20;   (* Only Click. Good for Counters                *)

      All      = left + right + PickUp + RunOver;

type  ID_Typ   = Word;

(* Dieser Variablen kann eine eigende Procedure zugewiesen werden, die  *)
(* auf einen Klick auerhalb aller Button reakiert. (z.B.:Warnton)      *)
(* You can declare in this variable your own sound-procedure. And every *)
(* time, if the user click not on a button, it will be started.         *)
var  NotButton_Proc : procedure;
     Wait           : Boolean;

(* Anfrage, ob ein Button mit der ID schon da ist.                      *)
(* returns true, if exist a button with this ID.                        *)
function  exist_in_ButtonList(ID:ID_Typ):Boolean;

(* Alle aktuellen Button werden aus der Liste gelscht.                 *)
(* All button will removed, but not on the screen.                      *)
procedure Kill_ButtonList_All;

(* Add. ein Button in die Liste und stellt diesen dar.                  *)
(* Allocate and show new Button.                                        *)
function  Add_Button(ID                : ID_Typ;
                     x,y               : Word;
                     C1,C2,C3,high,low,        (* Box,,,Font,, - Farben *)
                     Mask              : Byte; (* MouseButton - Mask    *)
                     S                 : String  ) : Boolean;

(* The same like Add_Button, but a Integer is the Name .                *)
function Add_ButtonInt(ID:ID_Typ;x,y:Word;C1,C2,C3,high,low,Mask:Byte;I:LongInt):Boolean;

(* s. Add_Button, alle Farben mit den Grau-Werten von x_Set_RGB_Pal.    *)
(* The same, but the colors are Gray0 to Gray5 from X_Const, set by     *)
(* x_set_rgb_pal from X_Pal.                                            *)
function Add_Button_Gray(ID:ID_Typ;x,y:Word;Mask:Byte;S:String):Boolean;
function Add_ButtonInt_Gray(ID:ID_Typ;x,y:Word;Mask:Byte;I:LongInt):Boolean;

(* Lscht Button aus Liste .                                            *)
(* Remove one Button.                                                   *)
function  Kill_Button(ID:ID_Typ):Boolean;

(* Schaltet Button in Hintergrund.                                      *)
(* Inactivated Button, button hold in the list, can`t selected.         *)
procedure Sleep_Button(ID:ID_Typ);

(* Schaltet Button wieder aktiv, nach Sleep_Button.                     *)
(* Activate Button.                                                     *)
procedure wake_up_Button(ID:ID_Typ);

(* Gibt ID zurck, wenn grad in dem Moment etwas aktiviert wurde,sonst 0*)
(* returns ID of the activated button in this moment, other 0           *)
function  Get_Pressed_Button :ID_Typ;
(* Wartet solange, bis ein Button aktiviert wurde.                      *)
(* Wait, until one Button is activated.                                 *)
function  Wait_Pressed_Button:ID_Typ;


implementation

uses crt,X_Main,X_Text,X_Mouse,X_Rect;

type ButtonTyp = record
       ID                : ID_Typ;
       x1,y1,x2,y2       : Word;
       C1,C2,C3,high,low : Byte;   (* Colors: ShadowBox,Font            *)
       PressMask         : Byte;   (* (left, rigth, .. or ..) +         *)
                                   (* (PickUp,RunOver ...               *)
       Sleep             : Boolean;
       S                 : ^String;
     end;

     PButtonList = ^ButtonList;

     ButtonList = record
       next : PButtonList;
       key  : ButtonTyp;
     end;

var Root        : Pointer;

{$F+}procedure Kein_Warnton;begin;end;{$F-}

function exist_in_ButtonList(ID:ID_Typ):Boolean;
var Run:PButtonList;
begin;
  if Root=NIL then exist_in_ButtonList:=False
              else
  begin;
    Run:=Root;
    while (Run^.key.ID<>ID)and(Run<>NIL) do Run:=Run^.next;
    if Run<>NIL then Exist_in_ButtonList:=True
                else Exist_in_ButtonList:=false;
  end;
end;



procedure Add_ButtonList(B:ButtonTyp);
var Run,P:PButtonList;
begin;
  if Root=NIL then
  begin;
    New(P);
    Root    :=P;
    P^.next :=NIL;
    P^.key  :=B;
  end         else
  begin;
    Run:=Root;
    while (Run^.next<>NIL) do Run:=Run^.next;
    New(P);
    P^.next  :=NIL;
    P^.key   :=B;
    Run^.next:=P;
  end;
end;

function Kill_ButtonList(ID:ID_Typ):Boolean;
var Run,P:PButtonList;
begin;
  if Root=NIL then begin;Kill_ButtonList:=False;exit;end;
  Run:=Root;
  if Run^.key.ID=ID then
  begin;
    P:=Run;
    Root:=Run^.next;
    FreeMEM(P^.key.S,length(P^.key.s^)+1);
    Dispose(P);
    Exit;
  end;

  while (Run^.next<>NIL)and(Run^.next^.key.ID<>ID) do Run:=Run^.Next;
  if Run^.next<>NIL then
  begin;
    P:=Run^.next;
    Run^.next:=P^.next;
    FreeMEM(P^.key.S,length(P^.key.s^)+1);
    Dispose(P);
    Kill_ButtonList:=True;
  end
                    else Kill_ButtonList:=False;
end;

procedure Kill_ButtonList_All;
var Run,P:PButtonList;
begin;
  If Root=Nil then Exit;
  Run:=Root;
  while (Run^.next<>NIL) do
  begin;
    P:=Run^.next;
    Run^.next:=P^.next;
    FreeMEM(P^.key.S,length(P^.key.s^)+1);
    Dispose(P);
  end;
  FreeMEM(Run^.key.S,length(Run^.key.s^)+1);
  Dispose(Run);
  Root:=NIL;
end;

procedure Test_List;
var Run:PButtonList;
begin;
  if Root<>NIL then
  begin;
    Run:=Root;
    while (Run<>NIL) do begin;WriteLn(Run^.key.ID);Run:=Run^.Next;end;
  end;
end;

procedure Show_Button(B:ButtonTyp;Z:Boolean);
begin;
  if Wait then WaitVsyncStart;
  if Z then No_Button_Write(B.x1,B.y1,B.C1,B.C3,B.C2,B.High,B.low,B.S^)
       else Press_Button_Write(B.x1,B.y1,B.C1,B.C3,B.C2,B.High,B.low,B.S^)
end;

procedure GetButton(ID:ID_Typ;var B:ButtonTyp);
var Run:PButtonList;
begin;
  if not exist_in_ButtonList(ID) then exit;

  Run:=Root;

  while (Run<>NIL)and(Run^.key.id<>ID) do Run:=Run^.next;

  if Run<>NIL then B:=Run^.key;

end;

procedure SetButton(ID:ID_Typ;var B:ButtonTyp);
var Run:PButtonList;
begin;
  if not exist_in_ButtonList(ID) then exit;

  Run:=Root;

  while (Run<>NIL)and(Run^.key.id<>ID) do Run:=Run^.next;

  if Run<>NIL then Run^.key:=B;

end;

function Add_Button( ID                : ID_Typ;
                     x,y               : Word;
                     C1,C2,C3,high,low,        (* Box,,,Font,, - Farben *)
                     Mask              : Byte; (* MouseButton - Mask    *)
                     S                 : String  ) : Boolean;
var B:ButtonTyp;
begin;

  if exist_in_ButtonList(ID) then GetButton(ID,B);

  B.ID    := ID;
  B.x1    := x;
  B.y1    := y;
  B.x2    := x+x_length(s)+2;
  B.y2    := y+x_font_Height+1;
  B.C1    := C1;
  B.C2    := C2;
  B.C3    := C3;
  B.high  := high;
  B.low   := low;
  B.PressMask := Mask;
  B.Sleep := False;

  if exist_in_ButtonList(ID) then
  begin;
    FreeMEM(B.S,length(B.S^)+1);
    GetMEM(B.S,length(S)+1);
    B.S^    := S;
    SetButton(ID,B);
  end                        else
  begin;
    GetMEM(B.S,length(S)+1);
    B.S^    := S;
    Add_ButtonList(B);
  end;

  Show_Button(B,true);
end;

function Add_ButtonInt(ID:ID_Typ;x,y:Word;C1,C2,C3,high,low,Mask:Byte;I:LongInt):Boolean;
var S:String;
begin;
  Add_ButtonInt:=Add_Button(ID,x,y,C1,C2,C3,high,low,Mask,Str(i));
end;

function Add_Button_Gray(ID:ID_Typ;x,y:Word;Mask:Byte;S:String):Boolean;
begin;
  Add_Button_Gray:=Add_Button(ID,x,y,Gray5,Gray4,Gray3,Gray0,Gray2,Mask,S);
end;

function Add_ButtonInt_Gray(ID:ID_Typ;x,y:Word;Mask:Byte;I:LongInt):Boolean;
var S:String;
begin;{str(i,s);}Add_ButtonInt_Gray:=Add_Button_Gray(ID,x,y,Mask,Str(i));
end;

function Kill_Button(ID:ID_Typ):Boolean;
var Dummy:Boolean;
    B    :ButtonTyp;
begin;
  if not exist_in_ButtonList(ID) then begin;Kill_Button:=false;exit;end;

  (* Restore BackGround *)
  GetButton(ID,B);
  Box(B.x1-1,B.y1-1,B.x2+1,B.y2+1,B.C2);

  Dummy:=Kill_ButtonList(ID);
end;

procedure Sleep_Button(ID:ID_Typ);
var B:ButtonTyp;
begin;
  if not exist_in_ButtonList(ID) then exit;
  GetButton(ID,B);
  B.Sleep:=True;
  SetButton(ID,B);
  if Wait then WaitVsyncStart;
  No_Button_Write(B.x1,B.y1,B.C1,B.C3,B.C2,B.low,B.low,B.S^);
end;

procedure wake_up_Button(ID:ID_Typ);
var B:ButtonTyp;
begin;
  if not exist_in_ButtonList(ID) then exit;
  GetButton(ID,B);
  B.Sleep:=False;
  SetButton(ID,B);
  Show_Button(B,true);
end;


(* If 0, none MouseButton pressed or none Button clicked *)
function Get_Pressed_Button:ID_Typ;
var Status: Byte;
    Run   : PButtonList;
    Ok    : Boolean;
begin;
  if (ButtonStatus=0)or(Root=NIL)or(IsMouseHidden) then
                                        begin;Get_Pressed_Button:=0;Exit;end;

  Status:=ButtonStatus;

  Run:=Root;
  while (Run<>NIL) do
  begin;
    if (Run^.key.PressMask and Status)<>0 then
      if not(Run^.key.Sleep) and
         InBox(Run^.key.x1,Run^.key.y1,Run^.key.x2,Run^.key.y2) then
      begin;
        HideMouse;
        Show_Button(Run^.key,false);
        ShowMouse;
        Ok:=False;
        delay(10);
        repeat
          if (Run^.key.PressMask and PickUp )<>0 then Ok:=ButtonStatus=0;
          if not OK then If (Run^.key.PressMask and RunOver)<>0 then
             Ok:=not InBox(Run^.key.x1,Run^.key.y1,Run^.key.x2,Run^.key.y2);
          if not Ok and ((Run^.key.PressMask and Click )<>0) then Ok:=True;
        until Ok;
        HideMouse;
        Show_Button(Run^.key,true);
        ShowMouse;
        Get_Pressed_Button:=Run^.key.ID;
        exit;
      end;
    Run:=Run^.next;
  end;
  if Status<>0 then begin;NotButton_Proc;delay(100);end;
  Get_Pressed_Button:=0;
end;

function Wait_Pressed_Button:ID_Typ;
begin;
  repeat until ButtonStatus<>0;
  Wait_Pressed_Button:=Get_Pressed_Button;
end;

procedure Reset_ButtonList;
begin;
  Root:=NIL
end;

begin;
  Reset_ButtonList;
  NotButton_Proc:=Kein_Warnton;
  Wait:=False;
end.
