{ *******************************************************************
  *			    This file is part of the WMFH package				*
  ******************************************************************* }


{

	 	Wnd_unit.pas	A Turbo Pascal unit for window management


			 Copyright (c) 1997   Gianfranco Boggio-Togna                              *

							C.P. 14021                                   
					  I-20140 Milano (Italy)                             

					 e-mail: gbt@computer.org                                                     *


    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

}

{
						ACKNOWLEDGEMENTS

  The WND_input function is based, with modifications, on

  > Version 1.5 of...
  > Yet Another, Quite General Input Routine (YA-QGIR, pronounced YA-QJUGEER)
  > --------------------------------------------------------------------------
  > This one is (C)1993,1994 Eddy Jansson, P.I - No Rights Reserved.
  > The following routines may be used in your own programs, as long as
  > you promise to modify them to meet your own needs. 

  from the SWAG library.

}


{$R+}
{$S+}
{$UNDEF   Blink}       { UNDEF allows use of palette numbers > 7
						as background colors }

UNIT   WND_Unit ;

{ ************************************************************************
  *																		 *
  *				        U N I T    I N T E R F A C E  					 *
  *																		 *
  ************************************************************************ }

INTERFACE

USES  	Dos, Crt, KB_unit, MS_Unit ;

TYPE
		WND_shadow_type = ( WND_no_shadow,
						    WND_transparent_shadow,
							WND_solid_shadow,
							WND_narrow_shadow ) ;

		WND_frame_type =  ( WND_no_frame,
							WND_single_frame,
							WND_double_frame ) ;

VAR
		WND_transparent_shadow_palette_number:	Byte ;


{ =========================================================================== 
					C U R S O R   C O N T R O L
  =========================================================================== }

PROCEDURE WND_save_cursor (show: Boolean) ;
PROCEDURE WND_restore_cursor ;



{ =========================================================================== 
							 I N P U T  
  =========================================================================== }

FUNCTION  WND_input ( Y, X: Byte ;            
					  StartStr,               
					  BackG,                  
					  PassChar:  String ;
					  MaxLen,           
					  StartPos:  Integer ;
					  Ins: Boolean ;
					  VAR InputStatus: Word ;
					  VAR MouseStatus: Integer
				    ): String ;  {Version 1.5}

{
Y,X         Where on screen to put the input.
StartStr    Default input string.
BackG       Background Character, eg ' ' or '' etc.
PassChar    If defined this character will be displyed instead of the input
MaxLen      MaxLen of Input.
StartPos    Where in input string to place the cursor, -1 = End of StartStr
Ins         Begin in INSERT or OVERWRITE mode (Boolean)
InputStatus Upon exit from the input routine this variable will hold:
			the keyboard scan code for the last key pressed.
}



{ =========================================================================== 
							 W I N D O W S      
  =========================================================================== }


{ -------------
  Open a window
  ------------- }

PROCEDURE  WND_open_window ( Y1, X1, Y2, X2:  Integer ;
							 FGCol, BGCol:    Byte ;
							 Shadow:          WND_shadow_type ;
							 Frame:           WND_frame_type ;
							 Title:           String ;
							 VAR Save_id:     Integer
						   ) ;

{ Y1, X1, Y2, X2        window corners coordinates (top left corner = 1,1)
  FGCol, BGCol          window Foreground / Background color
  Shadow                shadow type
  Frame                 frame type
  Title                 first line title
  Save_id               if not zero on entry, the screen area overlaid by
						the window is saved and a non-zero value is returned,
						to be used as a parameter to Close_Window.

  It is possible to change colors within the title string by using
  escape sequences.  The sequence '\n' (where 'n' is a hexadecimal
  digits) select the palette register 'n' for the text color; '\x'
  restores the previous color.
}


{ ---------------------------------------------------------------
  Close a window restoring the screen area overlaid by the window
  --------------------------------------------------------------- }

PROCEDURE  WND_close_window (save_id: Integer) ;

{ save_id               value returned by Open_Window.  If Open_Window
						returned 0, Close_Window must not be used.
}

PROCEDURE  WND_move_window (new_Y, new_X:  Integer;  Save_id: Integer) ; 


{ =========================================================================== 
					  M O U S E    S C R O L L    B A R S   
  =========================================================================== }

{ ------------------------ 
	 Define a scroll bar
  ------------------------ }

FUNCTION  WND_new_scroll_bar ( background_color,
							   button_background_color,
							   button_foreground_color,
							   depth: Byte ) : Integer ;

{ background_color
  button_background_color      for buttons        
  button_foreground_color    
  depth

  WND_new_scroll_bar           an integer identifying the scroll bar
}


{ ------------------
  Display a scroll bar
  ------------------ }

PROCEDURE   WND_show_scroll_bar  (scroll_bar: Integer;
								  y, x, entries, top: Integer) ;

{ scroll_bar            the integer identifying the scroll bar
  y, x                  top left bar coordinates
  entries               the total number of entries 
  top                   the number of the entry currently at the top 
}


{ ------------------------------------------
  Check whether scroll bar has been activated
  ------------------------------------------ }

FUNCTION  WND_check_scroll_bar (scroll_bar: Integer; VAR move: Integer): Boolean ;

{ scroll_bar            the integer identifying the scroll bar
  move                  on exit, how many lines to move (<0 = up)

}


{ ************************************************************************
  *																		 *
  *					 U N I T	I M P L E M E N T A T I O N				 *
  *																		 *
  ************************************************************************ }

IMPLEMENTATION

CONST
		Copyright:	String =
					'WMFH 1.0 - Copyright 1997 Gianfranco Boggio-Togna' ;


TYPE

		Buffer_type     = Array[0..3999] of Byte ; { screen size      }
		Buffer_ptr_type = ^Buffer_type ;           { For dynamic use  }

		Scroll_bar_ptr  = ^ Scroll_bar ;

		Scroll_bar =  RECORD
						bg_color:               Byte ;
						b_bg_color:             Byte ;
						b_fg_color:             Byte ;
						y_coord:                Byte ;
						x_coord:                Byte ;
						size:                   Byte ;
						n_entries:              Integer ;
						position:               Integer ;
						steps:                  ARRAY [1..23] OF Integer ;
					END ;


CONST
		max_saved_win    = 10 ;
		max_scroll_bars  = 10 ;
		max_saved_cursor = 20 ;
VAR
		scroll_bar_table: ARRAY [1..max_scroll_bars] OF Scroll_bar_ptr ;    
		last_scroll_bar : Integer ;

		saved_win_table: ARRAY [1..max_saved_win] OF Buffer_ptr_type ;
		last_saved_win : Integer ;

		saved_cursor_table: ARRAY [1..max_saved_cursor] OF Word ;
		last_saved_cursor : Integer ;

		video_buffer:  Word ;

		regs: 	 Registers ;


{ =========================================================================== 
					C U R S O R   C O N T R O L
  =========================================================================== }


PROCEDURE  WND_save_cursor (show: Boolean) ;
VAR
	showing: Boolean ;
BEGIN
	regs.ah := $03 ;      
	regs.bh := $00 ;      
	Intr ($10, regs) ;           { get cursor size and position }
	showing :=  regs.ch < $20  ;      
	Inc (last_saved_cursor) ;		
	IF last_saved_cursor > last_saved_cursor  THEN
		Halt ;
	saved_cursor_table [last_saved_cursor] := regs.dl + regs.dh shl 8 ; 
	IF  showing  THEN
		Inc (saved_cursor_table [last_saved_cursor], 1 shl 15) ;			
	IF  showing <> show  THEN
	  BEGIN
		IF  show  THEN
			regs.cx := $0506 
     	ELSE
			regs.cx := $2007 ;
		regs.ah := $01 ;      
		Intr ($10, regs) ;           { show / hide cursor }
	 END ;
END ;

PROCEDURE WND_restore_cursor ;
VAR
	showing, show: Boolean ;
	w:		 	   Word ;
BEGIN
	IF last_saved_cursor <= 0  THEN
		Halt ;
	regs.ah := $03 ;      
	regs.bh := $00 ;      
	Intr ($10, regs) ;           { get cursor size and position }
	showing :=  regs.ch < $20  ;      

	w := saved_cursor_table [last_saved_cursor] ;			
	Dec (last_saved_cursor) ;		

	regs.ah := $02 ;      
	regs.bh := $00 ;      
	regs.dl := Lo(w) ;      
	regs.dh := Hi(w) AND  $7F ;      
	Intr ($10, regs) ;           { set cursor  position }

	show := (Hi(w) AND $80) = $80 ;
	IF  showing <> show  THEN
	  BEGIN
		IF  show  THEN
			regs.cx := $0506 
     	ELSE
			regs.cx := $2007 ;
		regs.ah := $01 ;      
		Intr ($10, regs) ;           { show / hide cursor }
	 END ;
END ;


{ ------------------------------------------------------------------
		Service procedures and functions
  ------------------------------------------------------------------ }

PROCEDURE  set_border (color: Byte) ;
BEGIN
  regs.ax := $1001 ;
  regs.bh := color ;
  intr($10, regs) ;
END ;


FUNCTION  get_border: Byte ;         
BEGIN
  regs.ax := $1008 ;
  intr($10, regs) ;
  get_border := regs.bh ;
END ;

{$IFNDEF Blink}

PROCEDURE disable_blinking ;
BEGIN
  regs.ah := $03 ;
  regs.bx := $0000 ;
  intr($10, regs) ;
END ;

{$ENDIF}


{ YA-QGIR begin  ***   YA-QGIR begin  ***   YA-QGIR begin  ***   YA-QGIR begin }
{ YA-QGIR begin  ***   YA-QGIR begin  ***   YA-QGIR begin  ***   YA-QGIR begin }
{ YA-QGIR begin  ***   YA-QGIR begin  ***   YA-QGIR begin  ***   YA-QGIR begin }

{

  Version 1.5 of...
  Yet Another, Quite General Input Routine (YA-QGIR, pronounced YA-QJUGEER)
  --------------------------------------------------------------------------
  This one is (C)1993,1994 Eddy Jansson, P.I - No Rights Reserved.
  The following routines may be used in your own programs, as long as
  you promise to modify them to meet your own needs. 

  Of course I take *NO* responsability for any injuries inflicted on man
  or animal or cause of dataloss from these routines. These routines
  may NOT be used in whole, or in part, in any life supporting, nuclear
  or weapon related systems.

 //  Eddy Jansson    FidoNet: 2:206/406
				     InterNet: eddy.jansson@haricot.ct.se


 //  Modified (1997) by Gianfranco Boggio-Togna (gbt@computer.org).
	 - added mouse support 
	 - made several small changes to integrate it better within the unit
	 - improved (?) layout


}

VAR
		S      :String[80] ;
		IS     :Byte ;

FUNCTION  WND_input ( Y, X: Byte ;            
					  StartStr,               
					  BackG,                  
					  PassChar:  String ;
					  MaxLen,           
					  StartPos:  Integer ;
					  Ins: Boolean ;
					  VAR InputStatus: Word ;
					  VAR MouseStatus: Integer
				    ): String ;  {Version 1.5}

{

Y,X         Where on screen to put the input.
StartStr    Default input string.
BackG       Background Character, eg ' ' or '' etc.
PassChar    If defined this character will be displayed instead of the input
			stream.
MaxLen      MaxLen of Input.
StartPos    Where in input string to place the cursor, -1 = End of StartStr
Ins         Begin in INSERT or OVERWRITE mode (Boolean)
InputStatus Upon exit from the input routine this variable will hold
			the keyboard scan code for the last key pressed.
MouseStatus If non-zero on entry, the mouse is supported (left button =
			Enter; right button = Escape).  If non-zero on return, the
			function was terminated by a click on a mouse button.
}


VAR
		P:         Byte ;
		Exit:      Boolean ;
		key:       Word ;
		ch:        Char ;       
		s:         String ;
		t:         String[1] ;
		NewStatus: Integer ;

{ ------ START OF GENERAL ROUTINES ------ }

FUNCTION Left (s: String; nr: byte): String ;
BEGIN
		Delete (s, nr+1, length(s)) ;
		Left := s ;
END ;

FUNCTION Mid (s: String; nr,nr2: byte) : String ;
BEGIN
		Delete (s, 1, nr-1) ;
		Delete (s, nr2+1, length(s)) ;
		Mid := s ;
END ;

PROCEDURE WriteXY (x,y: Byte; s: String) ;
VAR
		loop:   Word ;
BEGIN (* This can be _highly_ optimized *)
		FOR loop := x TO x + length(s) - 1 DO
				Mem[video_buffer: (loop-1)*2+ (y-1)*160] := Ord (s[loop-x+1]) ;
END ;

FUNCTION RepeatChar (s: String ;antal: byte): String ;
VAR
		temp: String ;
BEGIN
		temp := s[1] ;
		WHILE Length(temp) < Antal DO
				Insert (s[1],temp,1) ;
		RepeatChar := Temp ;
END ;

PROCEDURE NormalCursor ;
BEGIN
  regs.ah := $01 ;
  regs.cx := $0607 ;
  intr($10, regs) ;
END ;

PROCEDURE BlockCursor ; 
BEGIN
  regs.ah := $01 ;
  regs.cx := $0007 ;
  intr($10, regs) ;
END ;

{ ------ END OF GENERAL ROUTINES ------ }


BEGIN
		IF  MouseStatus <> 0  THEN
				MS_Hide ;  

		NewStatus := 0 ;
		Exit := False ;                         { Don't quit on me yet! }
		IF Length(PassChar)> 1 THEN 
				PassChar := PassChar[1] ;       { Just in Case... ;-) }
		IF Length(BackG) > 1 THEN
				BackG := BackG[1] ;
		IF Length(BackG) = 0 THEN
				BackG := ' ' ;
		IF Length(StartStr) > MaxLen THEN
				StartStr := Left (StartStr, MaxLen) ;
		IF StartPos > Length(StartStr) THEN
				StartPos := Length(StartStr) ;
		IF StartPos = -1 THEN
				StartPos := Length(StartStr) ;
		IF StartPos >= MaxLen THEN
				StartPos := MaxLen - 1 ;

		s := StartStr ;                       { Put StartStr into Edit Buffer }
		WriteXY (X, Y, RepeatChar(BackG, MaxLen)) ;

		IF StartStr <> '' THEN
		  BEGIN
			IF passchar = '' THEN
				WriteXY (X, Y, StartStr)
			ELSE
				WriteXY (X, Y, RepeatChar(PassChar, Length(StartStr))) ;
		  END ;

		IF  MouseStatus <> 0  THEN
		  BEGIN
				MS_Show ;  
				MS_GotoXY (X+MaxLen-1,Y) ;
		  END ;
		p := StartPos ;
		GotoXY (X+StartPos, Y) ;

		REPEAT
				IF Ins THEN 
						NormalCursor
				ELSE 
						BlockCursor ;

				IF  MouseStatus = 0  THEN
				  BEGIN
						REPEAT UNTIL KeyPressed ;
						key := KB_read ;
				  END
				ELSE
				  BEGIN
					REPEAT UNTIL KeyPressed OR  MS_LeftPressed OR MS_RightPressed ;
					IF  MS_LeftPressed  THEN
					   BEGIN
						 IF  (MS_WhereY <> Y)  OR (MS_WhereX < X)   OR
							 (MS_WhereX > X+MaxLen) THEN
						   BEGIN
							 key := KB_Esc ;
							 NewStatus := 1 ;
						   END
						 ELSE
						   key := KB_Enter ;
						 REPEAT UNTIL NOT MS_LeftDown ;
					   END
					ELSE
					  IF  MS_RightPressed  THEN
						BEGIN
						  key := KB_Esc ;
						  REPEAT UNTIL NOT MS_RightDown ;
						END
					  ELSE
						key := KB_read ;
				  END ;

				IF key = KB_Esc THEN
				  BEGIN
						InputStatus := KB_Esc ;
						Exit := True ;
				  END ;

				ch := Chr(Lo(key)) ;

				{   (ch<#255) and (ch>#31) }

				IF ch > #31 THEN
				  BEGIN   { Welcome to the jungle...}
					t := ch ;
					IF (p = length(s)) AND (Length(s) < MaxLen) THEN
					  BEGIN
						s := s+t ;
						IF  PassChar = '' THEN
						  WriteXY (X+P,Y,T)
						ELSE
						  WriteXY (X+P,Y,PassChar) ;
						Inc (p) ;
					  END
					ELSE
					  IF length(s) < MaxLen  THEN
						BEGIN
						  IF  Ins  THEN
							Insert (T,S,P+1)
						  ELSE
							s[p+1] := ch ;
						  IF  PassChar = ''  THEN
							WriteXY (X+P,Y,Copy (S,P+1,Length (S)))
						  ELSE
							WriteXY (X+Length (S)-1,Y,PassChar) ;
						  Inc (p) ;
						END
					  ELSE
						IF (Length(s) = MaxLen) AND (not Ins) THEN
						  BEGIN
							s[p+1] := ch ;
							IF  PassChar = '' THEN
							  WriteXY (X+P,Y,T) 
							ELSE
							  WriteXY (X+P,Y,PassChar) ;
							Inc (p) ;
						  END ;
						IF  p > MaxLen-1  THEN
						  p := MaxLen-1 ;
						GotoXY (X+P,Y) ;
				  END
				ELSE
				  BEGIN
					CASE key OF

					

					KB_BackSpace:
							   IF  P > 0 THEN
								 BEGIN
								   IF (p+1 = MaxLen) AND (p < length(s)) THEN
									  key := KB_Del 
								   ELSE
									  BEGIN
										Delete (S,P,1) ;
										Dec (P) ;
										GotoXY (X+P,Y) ;
										IF PassChar = ''  THEN
										  WriteXY (X+P, Y,
											  Copy (S, P+1, Length(s))+BackG)
										ELSE
										  IF  P > 0 THEN
											WriteXY (X+Length(s)-1, Y,
													 PassChar+BackG)
										  ELSE
											WriteXY (X+Length (s),Y,BackG) ;
									  END ;
								   END ;                                

					{ Exit on TAB }
					KB_Tab:    BEGIN 
								 InputStatus := KB_Tab ;
								 Exit := True ;
							   END ;

					KB_ShiftTab:
							   BEGIN 
								 InputStatus := KB_ShiftTab ;
								 Exit := True ;
							   END ;

					KB_Enter:  BEGIN
								 InputStatus := KB_Enter ;
								 Exit := True ;
							   END ;

					KB_Left:   IF p > 0  THEN
								 BEGIN
								   Dec (P) ;
								   GotoXY (X+P,Y) ;
								 END ;

					 KB_Right: IF (P < Length (s))  AND  (P+1 < MaxLen) THEN
								 BEGIN
								   Inc (P) ;
								   GotoXY (X+P,Y) ;
								 END ;

					 KB_Ins:   Ins := Not (Ins) ; 

					 KB_Del:   IF  p < Length(s)  THEN
								 BEGIN
								   Delete (S, P+1, 1) ;
								   IF  PassChar = '' THEN 
									 WriteXY (X+P, Y, 
											  Copy (S,P+1,Length (s))+BackG)
								   ELSE
									 IF p > 0  THEN 
									   WriteXY (X+Length(s)-1,Y,PassChar+BackG)
									 ELSE
									   WriteXY (X+Length(s), Y, BackG) ;
								 END ;

					 KB_Home:  BEGIN
								 p := 0 ;
								 GotoXY (X+P,Y) ;
							   END ;

					 KB_End:   BEGIN
								 p := Length(s) ;
								 IF p >= MaxLen  THEN
								   p := MaxLen - 1 ;
								 GotoXY (X+P, Y) ;
							   END ;
					 ELSE ;

					 END ; {Case}
				  END ; { IF not normal char }

		UNTIL Exit ;
		WND_input := S ;
		MouseStatus := NewStatus ;
END ;

{ YA-QGIR end  ***   YA-QGIR end  ***   YA-QGIR end  ***   YA-QGIR end }
{ YA-QGIR end  ***   YA-QGIR end  ***   YA-QGIR end  ***   YA-QGIR end }
{ YA-QGIR end  ***   YA-QGIR end  ***   YA-QGIR end  ***   YA-QGIR end }


{ -----------------------------------------------------------------------
							W I N D O W S
  ----------------------------------------------------------------------- }

FUNCTION  save_area (y1, x1, y2, x2: Byte) : Buffer_ptr_type ;
VAR
  Poff, Soff:		  Integer ;
  y:				  Integer ;
  width, depth, size: Integer ;
  Buf_ptr: 			  Buffer_ptr_type ;
BEGIN
  width := x2 - x1 + 1 ;   
  depth := y2 - y1 + 1 ;   
  size := (width*2 ) * depth + sizeof(Byte) * 5 ; 
  GetMem (Buf_ptr, size) ; 
  Buf_ptr^[0] := y1 ;
  Buf_ptr^[1] := x1 ;
  Buf_ptr^[2] := y2 ;
  Buf_ptr^[3] := x2 ;
  Buf_ptr^[4] := get_border ;
  FOR y := 1 TO depth DO   
	BEGIN
	  Soff := ( ((y1-1) + (y-1)) * 160) + ( (x1-1)*2) ;
	  Poff := ( (width * 2) * (y-1)) + sizeof (Byte)*5 ;
	  Move (Ptr(video_buffer,Soff)^, Buf_ptr^[Poff], (width * 2)) ; { Write to buffer }
	END ;
  save_area := Buf_ptr ;
END ;


PROCEDURE restore_area (Buf_ptr: Buffer_ptr_type) ;
VAR
  Poff, Soff:		  Integer ;
  y:				  Integer ;
  width, depth, size: Integer ;
  y1, x1, y2, x2: 	  Integer ;
BEGIN
	  y1 := Buf_ptr^[0] ;
	  x1 := Buf_ptr^[1] ;
	  y2 := Buf_ptr^[2] ;
	  x2 := Buf_ptr^[3] ;
	  IF  (x1 = 1)  AND  (y1 = 1)  AND  (x2 = 80)  AND  (y2 = 25)  THEN
		set_border (Buf_ptr^[4])  ;

	  width := x2 - x1 + 1 ; 
	  depth := y2 - y1 + 1 ; 
	  size := (width * 2) * depth + sizeof(Byte) * 5 ; { memory size to deallocate }
	  FOR y := 1 TO depth DO  
		BEGIN
		  Soff := ( ( (y1-1) + (y-1)) * 160) + ( (x1-1)*2) ;
		  Poff := ( (width*2) * (y-1)) + sizeof (Byte)*5 ;
		  Move (Buf_ptr^[Poff], Ptr(video_buffer,Soff)^,  (width*2)) ;
		END ;
	  FreeMem (Buf_ptr, size) ;
END ;


PROCEDURE WND_close_window (save_id: Integer) ;
VAR
  Buf_ptr: Buffer_ptr_type ;
BEGIN
  MS_Hide ;   
  IF  (save_id > last_saved_win)  OR  (save_id < 1)  THEN
	BEGIN
		writeln ('save_id ', save_id) ;
		Runerror(20) ;
	END ;
  IF  (save_id <= last_saved_win)  AND  (saved_win_table[save_id] <> Nil)  THEN
	BEGIN
	  Buf_ptr := saved_win_table[save_id] ;
	  saved_win_table[save_id] := Nil ;
	  restore_area (Buf_ptr) ;
	END ;
   MS_Show ; 
END ;



PROCEDURE  WND_open_window (  Y1, X1, Y2, X2:  Integer ;
							  FGCol, BGCol:    Byte ;
							  Shadow:          WND_shadow_type ;
							  Frame:           WND_frame_type ;
							  Title:           String ;
							  VAR Save_id:     Integer 
						   ) ;

CONST
		Top_left      : array [0..2]  of Char = ' ' ; 
		Top           : array [0..2]  of Char = ' ' ; 
		Top_right     : array [0..2]  of Char = ' ' ; 
		Left_side     : array [0..2]  of Char = ' ' ; 
		Right_side    : array [0..2]  of Char = ' ' ; 
		Bottom_left   : array [0..2]  of Char = ' ' ; 
		Bottom        : array [0..2]  of Char = ' ' ; 
		Bottom_right  : array [0..2]  of Char = ' ټ' ; 
		Title_left    : array [0..2]  of Char = ' ' ; 
		Title_right   : array [0..2]  of Char = ' ' ; 
TYPE
		video_location = RECORD
							video_data      : char ;
							video_attribute : byte ;
						END ;

VAR
		i, j, k, f, n : Integer ;
		t_length: Integer ;
		video_pointer : ^video_location ;


PROCEDURE make_shadow ;

{ Makes a "shadow" of the specified type under a screen region }

VAR
	x_start, x_end,
	y_start, y_end,
	x, y   			: Integer ;
	attribute    	: byte ;       
BEGIN

  IF shadow = WND_narrow_shadow THEN
	BEGIN
	  x_start := X1 + 1 ;
	  x_end   := X2 + 1 ; 
	  y_start := Y1 ;
	  y_end   := Y2 + 1 ;
	END 
  ELSE
	BEGIN
	  x_start := X1 + 2 ;
	  x_end   := X2 + 2 ; 
	  y_start := Y1 + 1 ;
	  y_end   := Y2 + 1 ;
	END  ;

  attribute := Black ;

{$IFNDEF Blink}

  y := y_start ;
  WHILE (y <= y_end) AND (y <= 25) AND (attribute = Black) DO
  BEGIN

	IF y > Y2 THEN
	  x := x_start
	ELSE
	  x := X2 + 1 ;
	video_pointer := ptr (video_buffer, 2 * (80 * (y - 1) + (x - 1))) ;
	WHILE (x <= x_end) AND (x <= 80) DO
	  BEGIN
		IF  (video_pointer^.video_attribute AND $f0) = 0  THEN  
			attribute := WND_transparent_shadow_palette_number  ;
	    Inc (x) ;
	    Inc (video_pointer) ;
	END ;
	Inc (y) ;
  END ;
{$ENDIF}

  y := y_start ;
  WHILE (y <= y_end) AND (y <= 25) DO
  BEGIN

	IF y > Y2 THEN
	  x := x_start
	ELSE
	  x := X2 + 1 ;
	video_pointer := ptr (video_buffer, 2 * (80 * (y - 1) + (x - 1))) ;
	WHILE (x <= x_end) AND (x <= 80) DO
	  BEGIN

	  CASE  shadow  OF

	  WND_transparent_shadow: 
		  video_pointer^.video_attribute :=
		  		(video_pointer^.video_attribute AND $0f) OR (attribute shl 4) ;

	  WND_solid_shadow:            
		BEGIN
		  video_pointer^.video_attribute :=
		  		(video_pointer^.video_attribute AND $f0) OR attribute ; 
		  video_pointer^.video_data := '' ; 
		END ;

	  WND_narrow_shadow:
		BEGIN
		  video_pointer^.video_attribute := 
		  		(video_pointer^.video_attribute AND $f0) OR attribute ;
		  IF y = Y1  THEN
			video_pointer^.video_data := '' 
		  ELSE
			IF y = Y2+1  THEN
			  video_pointer^.video_data := '' 
			ELSE
			  video_pointer^.video_data := '' ; 
		END ;
	  END ;

	  Inc (x) ;
	  Inc (video_pointer) ;
	END ;
	Inc (y) ;
  END ;
END ;


BEGIN
		WND_save_cursor (False) ;
		MS_Hide ;  

		IF (Y2 = Y1)  AND (shadow <> WND_no_shadow)  THEN { force appropriate shadow type}
			shadow := WND_narrow_shadow ;

		IF  save_id <> 0  THEN
		BEGIN
		  k := 1 ;
		  WHILE  (k <= last_saved_win)  AND  (saved_win_table[k] <> Nil)  DO  
			Inc(k) ;
		  IF  k > last_saved_win  THEN
			IF last_saved_win < max_saved_win  THEN
			  BEGIN
				Inc(last_saved_win) ;
				k := last_saved_win ;
			  END
			ELSE
			  k := 0 ;
		  IF  k <> 0  THEN
			BEGIN
			  i := 0 ;
			  j := 0 ;
			  IF  shadow <> WND_no_shadow  THEN
				IF  shadow = WND_narrow_shadow  THEN
				  BEGIN
					i := 1 ;
					j := 1 ;
				  END
				ELSE
				  BEGIN
					i := 2 ;
					j := 1 ;
				  END ;
			  saved_win_table[k] := save_area (Y1, X1, Y2+j, X2+i) ;
			END ;
		  save_id := k ;
		END ;


		f := Ord (Frame) ;
		TextColor (FGCol) ;
		TextBackGround (BGCol) ;

		{ Top row }

		GotoXY (X1, Y1) ;
		Write (Top_left[f]) ;
		FOR i := X1+1 TO X2-1 DO 
			   Write (Top[f]) ;
		Write (Top_right[f]) ;

		IF  Length (Title) <> 0  THEN
		BEGIN
		  t_length := 0 ;
		  i := 1 ;
		  WHILE  i <=  Length (Title)  DO
			BEGIN
			  IF  Title[i] = '\'  THEN
				BEGIN
				  Inc (i) ;
				  IF  (i > Length (Title))  OR  (Title[i] = '\')  THEN
					Inc (t_length) ;
				END 
			  ELSE
				Inc (t_length) ;
			  Inc (i) ;
			END ;

			i := 0 ;
			IF  Frame <> WND_no_frame  THEN
			  i := 4 ;
		
			GotoXY ( X1 + (X2 - X1 + 1 - t_length -i) DIV 2, Y1) ;

			IF  Frame <> WND_no_frame  THEN
			  Write (Title_left[f], ' ') ;

			i := 1 ;
			WHILE  i <=  Length (Title)  DO
			  BEGIN
				IF  Title[i] = '\'  THEN
				  BEGIN
					Inc (i) ;
					IF  (i > Length (Title))  OR  (Title[i] = '\')  THEN
					  Write ('\') 
					ELSE
					  BEGIN
						IF  (Title[i] >= '0') AND (Title[i] <= '9')  THEN
						  n := Ord (Title[i]) - Ord ('0') 
						ELSE
						  IF  (Title[i] >= 'a') AND (Title[i] <= 'f')  THEN
							n := Ord (Title[i]) - Ord ('a') + 10 
						  ELSE
							IF  (Title[i] >= 'A') AND (Title[i] <= 'F') THEN
							  n := Ord (Title[i]) - Ord ('A') + 10 
							ELSE
							  n := 16 ;
						IF  n = 16  THEN
						  TextColor (FGCol) 
						ELSE        
						  TextColor (n) ;
					  END
				  END 
				ELSE
				  Write (Title[i]) ;
				  Inc (i) ;
			  END ;

			  IF  Frame <> WND_no_frame  THEN
				Write (' ', Title_right[f]) ;

		END ;

		{ Intermediate rows }
	
		TextColor (FGCol) ;
		FOR i := Y1+1 TO Y2-1 DO BEGIN
			TextBackGround (BGCol) ;
			GotoXy (X1, i) ;
			Write (Left_side[f]) ;
			FOR j := X1+1 TO X2-1 DO 
					Write (' ') ;
			GotoXy (X2, i) ;
			Write (Right_side[f]) ;
		END ;

		{ Bottom row }

		IF  Y2 > Y1  THEN
		BEGIN
			  GotoXY (X1, Y2) ;
			  TextColor (FGCol) ;
			  TextBackGround (BGCol) ;

			  Write (Bottom_left[f])         ;
			  FOR i := X1+1 TO X2-1 DO 
					Write (Bottom[f]) ;
			  IF (X2 = 80)  AND  (Y2 = 25)  THEN
				BEGIN
				  video_pointer := ptr (video_buffer, 3998) ;
				  video_pointer^.video_data := Bottom_right[f] ;
				  video_pointer^.video_attribute := (BGCol SHL 4) + FGCol ;
				  IF (X1 = 1)  AND  (Y1 = 1)  THEN
						  set_border (BGCOl) ;
				END
			  ELSE
				Write (Bottom_right[f]) ;
		 END ;

		{ Shadow }

		IF  shadow <> WND_no_shadow  THEN
		  make_shadow ;
		MS_Show ;    
		WND_restore_cursor ;	
END ;

PROCEDURE  WND_move_window ( new_Y, new_X:  Integer ;  Save_id: Integer) ; 
VAR
  Buf_ptr:  Buffer_ptr_type ;
  y1, x1, y2, x2: Byte ;
BEGIN
  IF  (save_id <= last_saved_win)  AND  (saved_win_table[save_id] <> Nil)  THEN
	BEGIN
	  Buf_ptr := saved_win_table[save_id] ;
	  y1 := Buf_ptr^[0] ;
	  x1 := Buf_ptr^[1] ;
	  y2 := Buf_ptr^[2] ;
	  x2 := Buf_ptr^[3] ;
	  Buf_ptr := save_area (y1, x1, y2, x2) ;
	  WND_close_window (save_id) ;
	  y2 := new_Y + (y2 - y1) ; 
	  x2 := new_X + (x2 - x1) ; 
	  y1 := new_Y ;
	  x1 := new_X ;
	  saved_win_table[save_id] :=  save_area (y1, x1, y2, x2) ;
	  Buf_ptr^[2] := y2 ;        
	  Buf_ptr^[3] := x2 ;        
	  Buf_ptr^[0] := y1 ;
	  Buf_ptr^[1] := x1 ;
	  restore_area (Buf_ptr) ;
	END ;
END ;


{ -----------------------------------------------------------------------
						 S C R O L L   B A R S 
  ----------------------------------------------------------------------- }


FUNCTION  WND_new_scroll_bar ( background_color,
							   button_background_color,
							   button_foreground_color,
							   depth: Byte ) : Integer ;
BEGIN
		Inc(last_scroll_bar) ;
		new (scroll_bar_table [last_scroll_bar]) ;
		WITH  scroll_bar_table [last_scroll_bar]^  DO
		  BEGIN
				bg_color :=  background_color ; 
				b_bg_color :=  button_background_color ;        
				b_fg_color :=  button_foreground_color ;        
				size     :=  depth ;
				n_entries := 0 ;
				position := 0 ;
		  END ; 
		WND_new_scroll_bar := last_scroll_bar ;
END ;


PROCEDURE   WND_show_scroll_bar  (scroll_bar: Integer;
								  y, x, entries, top: Integer) ;
VAR
		i, slots, step,	n, remainder: Integer ;
		sp:  Scroll_bar_ptr ;
BEGIN
		MS_Hide ;
		IF  (scroll_bar > 0)  AND  (scroll_bar <= last_scroll_bar)  THEN
		  BEGIN
			sp := scroll_bar_table [scroll_bar] ;         
			WITH  sp^  DO
			  BEGIN
				TextColor (b_fg_color) ;
				TextBackground (b_bg_color) ;
				gotoXY (x, y) ;
				write ('') ;
				gotoXY (x, y + size - 1) ;
				write ('') ;

				TextColor (bg_color) ;
				TextBackground (bg_color) ;
				FOR  i := y+1  TO  y + size - 2 DO
				  BEGIN
					gotoXY (x, i) ;
					write (' ') ;
				  END ;

				TextColor (b_fg_color) ;
				TextBackground (b_bg_color) ;

				IF  entries <> n_entries  THEN
				  BEGIN
					n_entries := entries ;
					slots := size - 2 ;
					steps [1] := 1 ;
					IF  entries <= size   THEN
					  BEGIN
						FOR  i := 2  TO  slots  DO
						  steps [i] := 1 ;
						steps [slots+1] := entries + 1 ;
					  END 
					ELSE
					  BEGIN
						steps [slots] := entries - size + 1 ;
						steps [slots+1] := entries + 1 ;
						entries := entries - size - 1 ;
						steps [2] := 2 ;
						IF  entries < slots - 2  THEN
						  BEGIN
							FOR i := 2  TO  slots - 1  DO
							  steps [i] := 1 ;
						  END
						ELSE
						  BEGIN
							step := entries  DIV (slots - 2) ;
							remainder := entries  MOD (slots - 2) ;
							FOR i := 3  TO  slots - 1  DO
							  BEGIN
								steps [i] := steps [i-1] + step ;
								IF  remainder > 0  THEN
								  BEGIN
									Inc (steps[i]) ;
									Dec (remainder) ;
								  END ;
							  END ; 
						  END ;
					  END ;
				  END ;

				i := 1 ;
				IF  top > 1  THEN
				  BEGIN
					WHILE  top >= steps[i]  DO
					  Inc(i) ;
					Dec(i) ;
				  END ;

				gotoXY (x, y + i);
				write ('') ;

				x_coord := x ;
				y_coord := y ;
				n_entries := entries ;
				position := i ;
			  END ;
		  END ;
		MS_Show ;
END ;


FUNCTION  WND_check_scroll_bar (scroll_bar: Integer; VAR move: Integer): Boolean ;
VAR
		x, y:   Integer ;
		sp:     Scroll_bar_ptr ;
BEGIN
		WND_check_scroll_bar := False ;

		IF  (scroll_bar > 0)  AND  (scroll_bar <= last_scroll_bar)  THEN
		  BEGIN
			x := MS_WhereX ;
			y := MS_WhereY ;
			sp := scroll_bar_table [scroll_bar] ;         
			WITH  sp^  DO
			  BEGIN
				IF  (x >= (x_coord-1))  AND  (x <= (x_coord+1))  AND
					(y >= y_coord)  AND	 (y <= y_coord + size -1)   THEN
				  BEGIN
					WND_check_scroll_bar := True ;
					IF  (y = y_coord)  THEN
					  move := -1 
					ELSE
					  IF  (y = y_coord + size - 1)  THEN
						move := -2  { actually +1} 
					  ELSE
						move := steps[y-y_coord] ;
				  END ;
			  END ;
		  END ;
END ;



{ -----------------------------------------------------------------------
					U N I T    I N I T I A L I Z A T I O N           
  ----------------------------------------------------------------------- }


BEGIN
		IF lastmode = 7  THEN		 { monochrome }
		  video_buffer := $b000
		ELSE
		  video_buffer := $b800 ;

		regs.ah := $0f ;      
		Intr ($10, regs) ;           { get current video status }

		Inc (video_buffer, regs.bh * $1000) ;   { bh = page number }   

		last_scroll_bar   := 0 ;
		last_saved_win    := 0 ;
		last_saved_cursor := 0 ;

		WND_transparent_shadow_palette_number := DarkGray ;

{$IFNDEF Blink}
		disable_blinking ;
{$ENDIF}

END.
