PROGRAM VesaDemo;

USES
	VGraph,Crt;

VAR
  MaxX, MaxY  : word;     { The maximum resolution of the screen }
  MaxPage	  : BYTE;	  { Number of pages -1 }
  ErrorCode   : integer;  { Reports any graphics errors }
  MaxColor    : LONGINT;  { The maximum color value available }
  OldExitProc : Pointer;  { Saves exit procedure address }
  Mode		  : WORD;

{$F+}
procedure MyExitProc;
begin
	ExitProc := OldExitProc; { Restore exit procedure address }
	CloseVesa;               { Shut down the graphics system }
end; { MyExitProc }
{$F-}

procedure Initialize;
{ Initialize graphics and report any errors that may occur }
VAR
	pal	: PaletteType;
begin
  { when using Crt and graphics, turn off Crt's memory-mapped writes }
  DirectVideo := False;
  OldExitProc := ExitProc;                { save previous exit proc }
  ExitProc := @MyExitProc;                { insert our exit proc in chain }
  InitVesa(mode);
  NewPal(pal);
  SetRGBPal(0,0,0,0);
  SetRGBPal(255,63,63,63);
  ErrorCode := GraphResult;             { preserve error return }
  if ErrorCode <> grOK then             { error? }
    begin
      Writeln('Graphics error: ', GraphErrorMsg(ErrorCode));
      Halt(1);                          { Some other error: terminate }
	 end;
  Randomize;                { init random number generator }
  MaxColor := GetMaxColor;  { Get the maximum allowable drawing color }
  MaxX := GetMaxX;          { Get screen resolution values }
  MaxY := GetMaxY;
  MaxPage := GetMaxPage;
end; { Initialize }

FUNCTION RandColor:LONGINT;
BEGIN
	IF MaxColor > $ffff THEN
   	RandColor := RGB(Random($ff),Random($ff),Random($ff))
   ELSE
		RandColor := Random($ffff);
END;

procedure DefaultColors;
{ Select the maximum color in the Palette for the drawing color }
begin
  SetColor(MaxColor);
end; { DefaultColors }

procedure DrawBorder;
{ Draw a border around the current view port }
var
  ViewPort : ViewPortType;
begin
  DefaultColors;
  SetLineStyle(SolidLn, 0, NormWidth);
  GetViewSettings(ViewPort);
  with ViewPort do
    Rectangle(0, 0, x2-x1, y2-y1);
end; { DrawBorder }

procedure FullPort;
{ Set the view port to the entire screen }
begin
  SetViewPort(0, 0, MaxX, MaxY, ClipOn);
end; { FullPort }

procedure MainWindow(Header : string);
{ Make a default window and view port for demos }
begin
  DefaultColors;                           { Reset the colors }
  ClearDevice;                             { Clear the screen }
  SetTextStyle(DefaultFont, HorizDir, 1);  { Default text font }
  SetTextJustify(CenterText, TopText);     { Left justify text }
  FullPort;                                { Full screen view port }
  OutTextXY(MaxX div 2, 2, Header);        { Draw the header }
  { Draw main window }
  SetViewPort(0, TextHeight('M')+4, MaxX, MaxY-(TextHeight('M')+4), ClipOn);
  DrawBorder;                              { Put a border around it }
  { Move the edges in 1 pixel on all sides so border isn't in the view port }
  SetViewPort(1, TextHeight('M')+5, MaxX-1, MaxY-(TextHeight('M')+5), ClipOn);
end; { MainWindow }

procedure StatusLine(Msg : string);
{ Display a status line at the bottom of the screen }
begin
  FullPort;
  DefaultColors;
  SetTextStyle(DefaultFont, HorizDir, 1);
  SetTextJustify(CenterText, TopText);
  SetLineStyle(SolidLn, 0, NormWidth);
  SetFillStyle(EmptyFill, 0);
  Bar(0, MaxY-(TextHeight('M')+4), MaxX, MaxY);      { Erase old status line }
  Rectangle(0, MaxY-(TextHeight('M')+4), MaxX, MaxY);
  OutTextXY(MaxX div 2, MaxY-(TextHeight('M')+2), Msg);
  { Go back to the main window }
  SetViewPort(1, TextHeight('M')+5, MaxX-1, MaxY-(TextHeight('M')+5), ClipOn);
end; { StatusLine }

procedure WaitToGo;
{ Wait for the user to abort the program or continue }
const
  Esc = #27;
var
  Ch : char;
begin
  StatusLine('Esc aborts or press a key...');
  repeat until KeyPressed;
  Ch := ReadKey;
  if ch = #0 then ch := readkey;      { trap function keys }
  if Ch = Esc then
    Halt(0)                           { terminate program }
  else
    ClearDevice;                      { clear screen, go on with demo }
end; { WaitToGo }


PROCEDURE SplittDemo;
LABEL
	Ende;
VAR
	i,x,y		: Word;
	s			: String;
   th			: WORD;
BEGIN
	SetTextJustify(LeftText,TopText);
	SetTextStyle(DefaultFont,HorizDir,1);
   th := TextHeight('M');
	FullPort;
	ClearDevice;
	FOR x := 0 TO (MaxX DIV 64) DO
		FOR y := 0 TO (MaxY DIV (3*th)) DO
			IF Odd(x+y) THEN BEGIN
				SetFillStyle(SolidFill,(x+y) mod 4 +1);
				Bar(x*64,y*3*th,x*64+63,y*3*th+3*th);
			END;
	SetActivePage(1);
	ClearDevice;
	FOR x := 0 TO (MaxX DIV 32) DO
		FOR y := 0 TO (MaxY DIV (3*th)) DO
			IF Odd(x+y) THEN BEGIN
				SetFillStyle(SolidFill,(x+y) mod 4);
				Bar(x*32,y*3*th,x*32+31,y*3*th+3*th);
			END;
	FOR y := 0 TO (MaxY DIV TextHeight('M')) DO BEGIN
		SetActivePage(0);
		Str(y:2,s);
		SetColor(15);
		OutTextXY(0,y*th,s + ' ');
      SetColor(11);
		OutTextXY(y*8+160,y*th,' P A G E 1 ');

		SetActivePage(1);
		SetColor(15);
		OutTextXY(0,y*th,s + ' ');
		SetColor(14);
		OutTextXY(y*8+160,y*th,' P A G E 2 ');
	END;
	SetActivePage(0);
	ScrollUp;     			(* Durch Softscrolling 2. Bildseite einblenden *)
	REPEAT
		FOR y := MaxY DOWNTO 0 DO BEGIN
			(* 1. Bildseite komplett ber die 2. schieben *)
			Split(y);
			IF KeyPressed THEN Goto Ende;
		END;
		FOR y := 0 TO ((MaxY+1)-190) DO BEGIN
			(* 1. Bildseite ein Stck nach unten schieben *)
			Split(y);
			IF KeyPressed THEN Goto Ende;
		END;
		(* 2. Bildseite durch Softscrolling rauf und runter *)
		FOR i := 0 TO 190 DO
			scroll(0,1);
		IF KeyPressed THEN Goto Ende;
		FOR i := 0 TO 190 DO
			scroll(0,-1);
		FOR y := ((MaxY+1)-190) TO MaxY DO BEGIN
			(* 1. Bildseite komplett nach unten verschwinden lassen *)
			Split(y);
			IF KeyPressed THEN Goto Ende;
		END;
	UNTIL KeyPressed;
Ende:
	ReadKey;
	{ Restore all }
	SetActivePage(0);
	ResetScroll;
END;


PROCEDURE PanDemo;
VAR
  i, Time,Hoehe,Grenze     : WORD;
  xx,yy							: WORD;
  Ch                 		: CHAR;

  FUNCTION GetData (Time:WORD):REAL;
	VAR
		dummy : REAL;
	BEGIN
		dummy := (Time MOD 360) * pi / 360;
{		GetData := cos(3*dummy)*0.5*sin(dummy); }
		GetData := sin(dummy)-0.5;
	END;

	PROCEDURE ShowData(VAR Time : WORD;Hoehe,Grenze : WORD);
	CONST
	{ Change this value if the picture is flickering,e.g. 2 or 8 }
		breite = 4;
	VAR
		data 	: REAL;
		x		: WORD;
	BEGIN
		scroll(breite,0);
		Inc(xx,breite);
		xx := xx MOD (MaxX+1);

		SetColor(0);
		Bar(xx+MaxX-breite+1,yy,xx+MaxX,MaxY);

		FOR x :=MaxX-breite+1 TO MaxX DO BEGIN
			data := GetData(time)*Hoehe/3;
			PutPixel (xx+X,yy+Hoehe DIV 2 + Trunc(data),100);
			SetColor(20);
			PutPixel2 (xx+x,yy+Hoehe DIV 2);		{ Nullinie }
			IF (Time mod 100)=0 THEN
				LineV(xx+x,yy+100,xx+x,MaxY-100);
			IF (Time mod 200)=0 THEN
				LineV(xx+x,yy+50,xx+x,MaxY-50);
			INC (Time);
		END;
	END;

BEGIN
	SetViewPort(0,0,MaxX*2,MaxY,ClipOff);
	ClearDevice;
	xx := 0;
	yy := 0;
	Grenze := 80;
	Hoehe := MaxY-Grenze;
	Time:=0;
	SetFillStyle(SolidFill,50);
	Bar(0,0,MaxX,Grenze-1);
	SetColor(200);
	OutTextXY(20,10,'VesaGraphDemo');
	OutTextXY(200,10,'Bewegung:');
	OutTextXY(300,10,'Space ... Stop');
	OutTextXY(300,30,'Return .. Weiter');
	OutTextXY(300,50,'ESC ..... Abbruch');
	Split(Hoehe);								{ Bildschirm teilen }
	scroll(0,Grenze);
	yy := Grenze;

	SetColor(0);
	SetFillStyle(SolidFill,0);
	Bar(0,yy,MaxX,MaxY);
	ch := #13;
	REPEAT
		CASE ch OF
			#13 : REPEAT
				ShowData(time,hoehe,grenze);
			Until KeyPressed;
			#32 : ShowData(time,hoehe,grenze);
		END;
      ch := ReadKey;
	UNTIL (Ch = #27);
   { Restore Screen }
	ResetScroll;
END;

PROCEDURE circledemo;
Type
	KreisTyp = Record
		X,Y     : Integer;         {Position}
		DX,DY   : Integer;         {Geschwindigkeit}
		FARBE   : LONGINT;         {Farbe}
		R       : Integer;         {Radius}
	End;
Const
	Anzahl_Kreise = 15;
Var
	Kreis 				: Array [1..Anzahl_Kreise] of KreisTyp;
	I, XNEU, YNEU    	: Integer;
	ViewPort				: ViewPortType;
BEGIN
	MainWindow('Circle demonstration');
	StatusLine('Esc aborts or press a key');
	GetViewSettings(ViewPort);
	{Kreise initialisieren}
	For i:= 1 To Anzahl_Kreise do Begin
		Kreis[i].X := Random(ViewPort.Y2-100)+50;
		Kreis[i].Y := Random(ViewPort.Y2-100)+50;
		Kreis[i].DX := Random (5);
		Kreis[i].DX := Kreis[i].DX - 2;
		Kreis[i].DY := Random (5);
		Kreis[i].DY := Kreis[i].DY - 2;
		Kreis[i].Farbe := RandColor;
		Kreis[i].R := Random (20) + 10;
	End;
	FOR i := 1 TO Anzahl_Kreise DO BEGIN
		WITH kreis[i] DO BEGIN
			SetColor(farbe);
			Circle (X,Y,R);
		END;
	END;
	REPEAT
		For i := 1 to Anzahl_Kreise Do Begin
			WITH kreis[i] DO BEGIN
				XNEU := X + DX;       {Neue X- und Y-Pos}
				YNEU := Y + DY;
				{Umrandung berschritten ?}
				If (XNEU+R > (Viewport.X2-Viewport.X1 - 1)) THEN BEGIN
					XNEU := (Viewport.X2-Viewport.X1-R);
					DX := -DX;
				END;
				IF (XNEU-R < 1) then Begin
					XNEU := Viewport.X1+R;
					DX := -DX;
				End;
				If (YNEU+R > ( Viewport.Y2-Viewport.Y1 - 1)) THEN BEGIN
					YNEU := Viewport.Y2-Viewport.Y1-R;
					DY := -DY-1;
				END;
				IF (YNEU-R < 1) then Begin
					YNEU := Viewport.Y1+R;
					DY := -DY+1;
				End;
				SetColor(0);
				Circle (X,Y,R);			{ Lschen }
				X:=XNEU ;
				Y:= YNEU;
				SetColor(Farbe);
				Circle (X,Y,R);
				DY := DY+1;
			END;
		End;
	UNTIL KeyPressed;
	WaitToGo;
END;

PROCEDURE FadeDemo;
VAR
	ViewInfo : ViewPortType;
	i		 : WORD;
	pal	 : PaletteType;
begin
  	MainWindow('FadeDemo');
  	StatusLine('Press any key to quit...');
  	GetViewSettings(ViewInfo);
  	SetTextStyle(DefaultFont, HorizDir, 3);
  	SetTextJustify(CenterText, CenterText);
  	GetPal(pal);
	FOR i := 1 TO (ViewInfo.Y2-ViewInfo.Y1) DIV 35 DO BEGIN
		SetColor(RandColor);
		with ViewInfo do
			OutTextXY((x2-x1) div 2, i*35 ,'Fading down');
	END;
	FadeDown(50,pal);
	ClearViewport;
	FOR i := 1 TO (ViewInfo.Y2-ViewInfo.Y1) DIV 35 DO BEGIN
		SetColor(RandColor);
		with ViewInfo do
			OutTextXY((x2-x1) div 2, I*35, 'Fading up');
	END;
  	FadeUp(50,pal);
	WaitToGo;
END;

PROCEDURE SayGoodByeDemo;
VAR
	t	: ARRAY[1..30] OF STRING;
	i	: WORD;
BEGIN
	
	t[1] := 'VESA Graphic Library';
	t[2] := '';
	t[3] := 'was brought to YOU by';
	t[4] := 'Mark Stehr';
	t[5] := '';
	t[6] := 'Thanks to:';
	t[7] := 'Mr. Bresenham, Barry, Logi, Jrgen Petsch, Thorsten Barth,';
	t[8] := 'Matthias Uphoff, Tahar the Dragon and Astrid';
	t[9] := '';
	t[10] := 'The latest version can be received via ftp:';
	t[11] := 'ftp.uni-erlangen.de';
	t[12] := '';
	t[13] := 'Erlangen, April 1994';
	FOR i := 14 TO 30 DO
		t[i] := '';
	{ Clear the whole memory }
	FOR i := 0 TO GetMaxPage DO BEGIN
		SetActivePage(i);
		ClearDevice;
	END;
	FullPort;
	SetActivePage(0);
	SetTextJustify(CenterText,CenterText);
	SetTextStyle(DefaultFont,HorizDir,4);
	SetColor(MaxColor);
	OutTextXY(MaxX DIV 2,MaxY DIV 2,'THE END');
	SetTextStyle(DefaultFont,HorizDir,1);
	SetActivePage(1);
	ClearDevice;
	SetColor(MaxColor);
	FOR I := 1 TO 30 DO
		OuttextXY(MaxX DIV 2,i*16,t[i]);
	ScrollUp;
	ScrollUp;
	SetActivePage(0);
   ClearDevice;
   SetVisualPage(0);
END;

procedure PaletteDemo;
{ Demonstrate the use of the SetPalette command }
const
  XBars = 15;
  YBars = 10;
var
  I, J     : word;
  X, Y     : word;
  Color    : LONGINT;
  ViewInfo : ViewPortType;
  Width    : word;
  Height   : word;
  OldPal   : PaletteType;
  Pal	  	  : PaletteType;
  r,g,b		: BYTE;
begin
  GetPal(OldPal);
  NewPal(Pal);
  MainWindow('Palette demonstration');
  StatusLine('Press any key...');
  GetViewSettings(ViewInfo);
  with ViewInfo do
  begin
	 Width := (x2-x1) div XBars - 1;
	 Height := (y2-y1) div YBars - 1;
  end;
  X := 0; Y := 0;
  Color := 0;
  for J := 1 to YBars do
  begin
    for I := 1 to XBars do
    begin
		SetFillStyle(SolidFill, Color);
		Bar(X, Y, X+Width, Y+Height);
		Inc(X, Width+1);
		Inc(Color);
		Color := Color mod (MaxColor+1);
	 end;
	 X := 0;
	 Inc(Y, Height+1);
  end;
  GetRGBPal(MaxColor,r,g,b);
  repeat
		PushPal(Pal);
		SetRGBPal(MaxColor,r,g,b);
  until KeyPressed;
  SetPal(OldPal);
  WaitToGo;
end; { PalettePlay }

procedure ColorDemo;
{ Display all of the colors available for the current driver and mode }
var
  Color    : LONGINT;
  Width    : word;
  Height   : word;
  X, Y     : word;
  I, J     : word;
  ViewInfo : ViewPortType;

procedure DrawBox(X, Y : word);
begin
  SetFillStyle(SolidFill, Color);
  with ViewInfo do
	 Bar(X, Y, X+Width, Y+Height);
  Color := Succ(Color); { mod (MaxColor + 1); }
end; { DrawBox }

begin
  MainWindow('Color demonstration');
  Color := 0;
  GetViewSettings(ViewInfo);
  with ViewInfo do
  begin
	Width := (x2-x1) DIV 16;
	Height := (y2-y1) DIV 16;
  end;
  y := 0;
  FOR j := 1 TO 16 DO BEGIN
	x := 0;
	FOR i := 1 TO 16 DO BEGIN
		DrawBox(x,y);
		Inc(x,Width);
	END;
	Inc(y,Height);
  END;
  WaitToGo;
end; { ColorPlay }

procedure StartDemo;
{ Demonstration some of the new features}
VAR
	Viewinfo			: ViewportType;
	centerx,centery : INTEGER;
   Pal,OldPal		: PaletteType;

	PROCEDURE key;
	BEGIN
		IF ReadKey = #27 THEN Halt(0)
		ELSE
			ClearViewport;
	END;

begin
  MainWindow('Advanced feature demo');
  StatusLine('Esc aborts or press a key');
  SetTextJustify(CenterText,CenterText);
  SetTextStyle(SansSerifFont,HorizDir,4);
  GetViewSettings(ViewInfo);
  with ViewInfo do begin
	CenterX := (x2-x1) DIV 2;
	CenterY := (y2-y1) DIV 2;
	IF MaxY > 200 THEN BEGIN
		GetPal(OldPal);
		OuttextXY(CenterX,CenterY,'Let''s start with a .PCX !!');
		Key;
		LoadPCX((x2-x1-320) DIV 2,(y2-y1-200) DIV 2,'apfel.pcx');
      LoadPCX((x2-x1-320) DIV 2,(y2-y1-200) DIV 2,'doc\apfel.pcx');
      GetPal(pal);
		SetRGBPal(0,0,0,0);
      SetRGBPal(255,63,63,63);
		ReadKey;
      REPEAT
      	PushPal(pal);
         SetRGBPal(0,0,0,0);
      	SetRGBPal(255,63,63,63);
      UNTIL KeyPressed;
      ReadKey;
		grayscale;
		Key;
		SetPal(OldPal);								{ Restore DAC }
	END;
	OuttextXY(CenterX,CenterY,'And now let''s DESTROY your screen !!');
	key;
	turnoff;
	key;
	turnon;
	OuttextXY(CenterX,CenterY,'Hehe ;-)');
  END;

  WaitToGo;
end;

PROCEDURE VirtualDesktopDemo;
VAR
	Pal,OldPal	: PaletteType;
	VMaxX,VMaxY : WORD;
	x,y			: INTEGER;
	taste			: CHAR;
BEGIN
	SetTextJustify(LeftText,TopText);
	GetPal(OldPal);

	NewPal(pal);
	SetRGBPal(0,0,0,0);
	SetRGBPal(255,255,255,255);

	SetVirtualWidth(1024);
	ClearDevice;
	VMaxX := GetVMaxX;
	VMaxY := GetVMaxY;
	SetColor(GetMaxColor);

	{ Border }
	Rectangle(0,0,VMaxX,VMaxY);

	FOR x := 0 TO VMaxX DIV 100 DO BEGIN
		Line(x*100,0,x*100,5);
		OuttextXY(5+x*100,5,st(x*100));
	END;
	FOR y := 0 TO VMaxY DIV 100 DO BEGIN
		Line(0,y*100,5,y*100);
		OuttextXY(5,5+y*100,st(y*100));
	END;

	FOR x := 30 TO VMaxX DIV 2 DO BEGIN
		SetColor(x);
		Line(x,30,x,VMaxY-30);
	END;
	FOR y := 30 TO VMaxY-30 DO BEGIN
		SetColor(y);
		Line(VMaxX DIV 2,y,VMaxX-30,y);
	END;

	OutTextXY(100,100,'Use the cursor keys to navigate...');

	REPEAT
		taste := ReadKey;
		CASE taste OF
			#77 : scroll(10,0);
			#75 : scroll(-10,0);
			#72 : scroll(0,-10);
			#80 : scroll(0,10);
		END;
	UNTIL taste IN [#27,' '];

	SetVirtualWidth(0);
END;

PROCEDURE TrueColorDemo;
VAR
	r,g,b,x,y,radius,xr,xg,xb,yr,yg,yb	: WORD;
	faktorr,faktorg,faktorb,dist 			: REAL;
   farbe		: LONGINT;
BEGIN
	MainWindow('Advanced feature demo');
	StatusLine('Please wait a while ! Esc aborts or press a key');

	radius := 100;
	x := MaxX DIV 2;
	y := MaxY DIV 2;

	xr := x;
	yr := Trunc(y-radius+20);
	xg := Trunc(x - 0.866*radius);
	yg := Trunc(y + 0.5*radius);
	xb := Trunc(x + 0.866*radius);
	yb := Trunc(y + 0.5*radius);

	radius := 150;
	faktorr := (GetMaxRed+1) / radius;
	faktorg := (GetMaxGreen+1) / radius;
	faktorb := (GetMaxBlue+1) / radius;

	FOR y := 0 TO MaxY DO BEGIN
		FOR x := 0 TO MaxX DO BEGIN

			r := 0;
			g := 0;
			b := 0;

			IF (x>(xr-Radius)) AND (x<(xr+radius)) AND
			(y>(yr-Radius)) AND (y<(yr+Radius)) THEN BEGIN
				dist := (xr-x)*(xr-x)+(yr-y)*(yr-y);
				dist := Sqrt(dist);
				IF dist<radius THEN
					r := Trunc(dist*faktorr);
			END;

			IF (x>(xg-Radius)) AND (x<(xg+radius)) AND
			(y>(yg-Radius)) AND (y<(yg+Radius)) THEN BEGIN
				dist := (xg-x)*(xg-x)+(yg-y)*(yg-y);
				dist := Sqrt(dist);
				IF dist<radius THEN
					g := Trunc(dist*faktorg);
			END;

			IF (x>(xb-Radius)) AND (x<(xb+radius)) AND
			(y>(yb-Radius)) AND (y<(yb+Radius)) THEN BEGIN
				dist := (xb-x)*(xb-x)+(yb-y)*(yb-y);
				dist := Sqrt(dist);
				IF dist<radius THEN
					b := Trunc(dist*faktorb);
			END;
			putpixel(x,y,rgb(r,g,b));

			IF KeyPressed THEN BEGIN
				WaitToGo;
				Exit;
         END;
		END;
	END;
END;

PROCEDURE SelectMode;
VAR
	choice1,choice2 	: CHAR;
   xsize,ysize			: WORD;
BEGIN
	(* Let's select a mode *)
	ClrScr;
	WriteLn('VESADEMO:');
	WriteLn('1. 256 colors');
	WriteLn('2. 32768 colors');
	WriteLn('3. 65536 colors');
	WriteLn('4. 16777216 colors');
	WriteLn('Q uit');
	WriteLn;
	Write('Your choice: ');
	REPEAT
		ReadLn(choice1);
	UNTIL choice1 IN ['1'..'4','q'];
	IF choice1 = 'q' THEN Halt;

	WriteLn;
	WriteLn;
	WriteLn('a. 320x200');
	WriteLn('b. 640x480');
	WriteLn('c. 800x600');
	WriteLn('d. 1024x768');
	WriteLn('e. 1280x1024');
	WriteLn('Q uit');
	WriteLn;
	Write('Your choice: ');
	REPEAT
		ReadLn(choice2);
	UNTIL choice2 IN ['a'..'e','q'];
	IF choice2 = 'q' THEN Halt;

	CASE choice2 OF
		'a' : BEGIN
			xsize := 320;
			ysize := 200;
		END;
		'b' : BEGIN
			xsize := 640;
			ysize := 480;
		END;
		'c' : BEGIN
			xsize := 800;
			ysize := 600;
		END;
		'd' : BEGIN
			xsize := 1024;
			ysize := 768;
		END;
		'e' : BEGIN
			xsize := 1280;
			ysize := 1024;
		END;
	END;
	CASE choice1 OF
		'1' : mode := FindVesaMode(xsize,ysize,8);
		'2' : mode := FindVesaMode(xsize,ysize,15);
		'3' : mode := FindVesaMode(xsize,ysize,16);
		'4' : BEGIN
			mode := FindVesaMode(xsize,ysize,24);
			IF mode = 0 THEN
				mode := FindVesaMode(xsize,ysize,32);
			END;
	END;
	IF mode = 0 THEN BEGIN
		WriteLn('No such mode could be found !');
		WriteLn('Switching to to 320x200x256');
		ReadKey;
		mode := V320x200x256;
	END;
END;

BEGIN
	SelectMode;
	Initialize;

	IF MaxColor = 255 THEN BEGIN
		StartDemo;
		PaletteDemo;
		IF (MaxY >= 400) AND (MaxPage>=1) THEN
			SplittDemo;
		IF (MaxY >= 400) AND (MaxPage>=1) THEN
			PanDemo;
		FadeDemo;
		IF (MaxPage>=1) THEN
			VirtualDesktopDemo;
		IF MaxPage>=2 THEN
			SayGoodByeDemo;
	END
	ELSE
		IF MaxY > 400 THEN
			TrueColorDemo;

	CircleDemo;
	ColorDemo;

   CloseVesa;
END.