{---
  TURBO PASCAL - Frequently Asked Questions / Routines
               - Yleisimmin kysytyt kysymykset ja rutiinit

  RUUDUN TILAN VAIHTO - SCREEN MODE
  PISTEEN PIIRTO RUUDULLE - PUTPIXEL
  PYSTY VIRKISTYS - VERTICAL RETRACE
  RUUDUN TYHJYS - CLEAR SCREEN
  PALETTI - PALETTE
   VRIN ASETUS - SET COLOR
   VRIN LUKEMINEN - GET COLOR
   PALETIN VRIN LUKEMINEN - GETPALETTE
  TEKSTIRUUDULLE KIRJOITUS - WRITECHAR
  GRAFIIKKARUUDULLE KIRJOITUS - GFXWRITE

  NOPEUSEROISTA - ERILAISET PISTEEN PIIRTO RUTIINIT

  Jussi Josefsson 1996
  "Oh, Pascal"
  "Turbo Pascal ohjelmointi 2. painos"
  "486-ohjelmointi", Gunvald Hedemalm. Pagina ISBN 951-8938-52-0
  "Opi oikein Pascal", Jaakko Koskinen
  "Suppea johdatus Pascal-kieleen"

  TPSWAG -- 1992 - 1996
  TUT01-TUT19 -- Grant Smith
  VGA tutor -- Fred Nietzche
  PCGPE 1.0
  HELPPC
 ---}

RUUDUN TILAN VAIHTO - SCREEN MODE

         Kaikkein trkein ksky grafiikan ohjelmoinnissa on itse ruudun tilan
         vaihto, jolla pstn tilaan, jossa grafiikka pystytn yleens
         edes kyttmn. Yleisimpi tiloja ohjelmoinnissa on tila $13 (eli
         19 desimaalijrjestelmss), joka tarkoittaa VGA/MCGA tilaa jossa
         on 320 pistett vaakatasossa, 200 rivi ja kytss 256 (eri) vri.
         Tilasta kytetn lyhyemp muotoa 320x200x256. Hyvi puolia tss
         tilassa on nopeus, joka johtuu lineaarisesta nyttmuistista, eli
         muisti on suoraviivainen taulukko, alkaen osoitteesta $A000:0.
         Eli ruudulle piirtoa varten ei tarvitse huolehtia pankkien vaihdosta,
         tarkistuksista tai vastaavista SVGA:n ohjelmoinnissa tyypillisist
         ongelmista.

         Yksinkertaisimmillaan ruudun tilan saa vaihdettua asettamalla
         "akkuun" (rekisteri ax) halutun tilan ja kutsumalla DOSsin
         keskeytyst numero $10. Ruudun palauttamiseksi perustekstitilaan
         eli tilaan numero $3, asetat vastaavasti akkuun tilan numeron ja
         kutsut keskeytyst.

           Asm
             MOV  AX, 13h
             INT  10h
           end;

         Huomaa, ett itseasiassa ylhll "pitisi" lukea
           MOV  AH, 00h
           MOV  AL, 13h
         mutta koska luku 13h(eksa) on sama kuin 0013h, emme tarvitse turhia
         rivej. Muista vain omassa, kokonaisessa rutiinissa (kuten alla on
         esimerkeinkin ilmaistu) laittaa muuttuja Tila:n tyypiksi WORD, tai
         jos kytt "oikeaoppista", kahden rivin versiota, laita Tila-muuttuja
         Regs.AL -rekisteriin ennen keskeytyst ja muista ett tllin Tila
         pit olla tyyppi BYTE.

         Vanhemmissa versioissa (5.0+), joissa ei ole sisnrakennettua
         assembleria, voidaan kytt hyvksi REGISTER -muuttujaa joka
         tarvitsee mys kirjaston DOS.

         Uses DOS;
         Procedure SetMode (Tila : word);
           Var Regs : registers;
           Begin
             Regs.AX := Tila;
             Intr ($10,regs);
           End;

         Sama aliohjelma olisi assemblerilla tehtyn esim. seuraavan
         nkinen.

         Procedure SetMode (Mode : word); assembler;
           Asm
             Mov   AX, Mode
             INT   10h
           End;

         Mielenkiintoinen asia on mys se, ett jos list nytntilan
         arvoon luvun $80, ruutua ei tyhjt tilaa vaihdettaessa. Tll
         tiedonjyvsell saadaan aikaan esimerkiksi efekti, jossa
         "tekstitila" himmenee kokonaan mustaksi ohjelmaa kynnistettess.
         Tm siis onnistuu vaihtamalla ruuduntilaksi $13+$80 eli $93 ja
         sitten paletti tulee himment kokonaan mustaksi.

PISTEEN PIIRTO RUUDULLE - PUTPIXEL

         Piirtksesi pisteen ruudulle, tarvitaan ensiksikin grafiikkatila,
         kuten esimerkiksi edellmainittu VGA/MCGA tila, eli tila $13.
         Tmn lisksi tarvitset tietysti pisteen mihin piirt, eli pisteen
         X ja Y koordinaatit. Kohta 0,0 (X,Y) on ruudun vasen ylkulma ja
         X koordinaatti jatkuu tst oikealle ja Y koordinaatti alaspin.
         Kohta 319,199 on siis oikea alakulma.
               0,0           319,0
                +###############+
                #    160,100    #
                #       +       #
                #               #
                +###############+
               0,199         319,199

         Ruudun piirrossa voidaan kytt hyvksi Turbo Pascalin sisist
         MEM - taulukkoa, jossa voidaan kahden WORD - tyyppisen muuttujan
         avulla osoittaa suoraan muistiin. MEM - taulukossa jokainen taulun
         sisltm luku on tyyppi BYTE. Tarvitsemme siis kaksi lukua, eli
         segmentin ja offsetin, eli yhdess osoitteen ("80486-ohjelmointi",
         s.60). VGA/MCGA ruudulla segmentti on aina $A000 ja offset (siirros)
         muodostuu X ja Y koordinaateista. Koska videomuisti on lineaarinen,
         Y - koordinaattiin perustuen lasketaan rivin numero kertomalla Y:n
         arvo luvulla 320, eli ruudun leveydell. Videomuistissa on luvut
         riveittin, eli ensimminen rivi vasemmalta oikealle on taulukon
         kohdissa 0..319, toinen rivi vasemmalta oikealle on taulukon
         kohdissa 320..638 ja niin edelleen.

         Niinp pisteenmuodostuksen "kaava" MEM taulukkoa kytettess on:

           Mem [$A000: X_arvo + (Y_arvo * 320) ] := Vari;

         Taulukko sislt vrin numeron eli paletissa olevan vrin.
         Esim. oletuspaletissa vri numero 0 on musta. Jos haluttaisiin
         asettaa kohdassa 7 (X=7) rivill 10 (Y=10) oleva piste mustaksi,
         asetettaisiin kohtaan 7,10 paletin vri numero 0 seuraavasti:

           Mem [$A000: 7 + (10 * 320) ] := 0;

         Nopeuttaaksesi laskutoimitusta, joka esimerkiksi silmukoissa on
         hitain tekij, voit kytt joko assembleria tai nopeuttaa itse
         laskutoimitusta esimerkiksi laskemalla Y:n eri arvot (0*320, 1*320
         2*320 jne) taulukkoon, tai kyttmll ainakin vanhemmissa koneissa
         laskua nopeuttavaa tapaa siirt bittej kertomisen sijasta.
         Alla esimerkki taulukon kytst:
         (var Y_taulukko : Array [0..199] of word;
          for I := 0 to 199 do Y_Taulukko[I]:=320*I;)

           Mem [$A000: 7 + Y_taulukko[10]] := 0;

         Ja esimerkki bittien siirrosta:

           Mem [$A000: 7 + 10 SHL 8 + 10 SHL 6] := 0;

         10 SHL 8 on sama kuin 10 * 256 ja 10 SHL 6 on sama kuin 10 * 64.
         Alla kokonainen aliohjelma jossa kytetn MEM-taulukkoa, joka on
         "tarpeeksi" nopea suurimpaan osaan ohjelmista. Huomaa ett MEM
         -taulukko on Pascalissa erittin nopea, koska jokaista ASM ksky
         ennen ohjelma tallentaa rekisterit, jota ei suoraa MEM-osoitusta
         kytettess tapahdu.

         Procedure MemPutPixel (X, Y : Integer; Vari : Byte);
           Begin
             Mem [$A000: X + Y SHL 8 + Y SHL 6] := Vari;
           End; { MEM PutPixel }

         Assemlerilla tehty aliohjelma on itseasiassa samankaltainen kuin
         yllolevalla bittisiirrolla tehty Mem-taulukon muokkaus.

         Procedure PutPixel (X, Y : Integer; Vari : Byte); Assembler;
           Asm
             MOV   AX, $A000
             MOV   ES, AX
             MOV   BX, [X]
             MOV   DX, [Y]
             MOV   DI, BX
             MOV   BX, DX
             SHL   DX, 8
             SHL   BX, 6
             ADD   DX, BX
             ADD   DI, DX
             MOV   AL, [Vari]
             STOSB
           End; { PutPixel }

PYSTY VIRKISTYS - VERTICAL RETRACE

         Tarkistaaksesi onko meneilln pysty- tai vaakavirkistys, sinun
         tulee testata porttia  $3DA  ja katsoa onko siell oleva
         virkistyslippu pll. Jos lippu on poissa, odota kunnes lippu
         asetetaan. Tmn jlkeen testaat, kunnes lippu asetetaan pois plt
         jolloin elektronisde on juuri siirtymss ruudun vasempaan
         ylreunaan, eli voit pivitt ruutua ilman hiritsev vlkynt.
         Testauksessa tulee kytt AND operaattoria ja lukua $08, eli
         binrin 1111.
         Vertical retrace tapahtuu 18.2 kertaa sekunnissa.
         Huomaa ett jos ruudun muokkauksesi kest enemmn kuin yhden
         virkistyksen, joudut testaamaan uutta virkistyst ja rutiini voi
         hidastua "puoleen".

         Procedure WaitScreen;
           Begin
             Repeat Until (Port[$3DA] and $08) = 0;
             Repeat Until (Port[$3DA] and $08) <> 0;
           End; { WaitScreen }

         Sama TP:n assemlerilla esitettyn (itseasiassa varmaankin selkempi
         esitys)

         Procedure VertRetrace; Assembler;
           Asm
             MOV  DX, 03DAh
           @KUNNES_NOLLA:
             IN   AL , DX
             TEST AL, 8
             JNZ  @KUNNES_NOLLA
           @MUU_KUIN_NOLLA:
             IN   AL, DX
             TEST AL, 8
             JZ   @MUU_KUIN_NOLLA
           End; { Vertical Retrace }

         Jos tahdot testata onko kynniss vaakavirkistys, kyt luvun $08
         sijasta lukua $01, jolloin testaat onko portin viimeinen bitti
         asetettu, eli onko kynniss vaakavirkistys. Huomaa ett vaaka-
         virkistys tapahtuu 18.2 * 200 kertaa sekunnissa ja on turhan lyhyt
         mihinkn radikaaliin ruudun muokkaukseen.

RUUDUN TYHJYS - CLEAR SCREEN

         Tyhjtksesi 320x200x256 tilassa olevan ruudun, voit pisteill
         tytn lisksi ruudun muistipaikat suoraan kyttmll FILLCHAR
         ksky tyttmn halutut muistipaikat halutulla tavulla tai
         merkill. Grafiikkamuistin osoite on $A000.

         FillChar (Mem [$A000: 0], 64000, 0);

         Huomaa ett vaihtamalla viimeist numeroa, saat vaihdettua vri,
         joksi ruutu vaihdetaan. Laittamalla pystyvirkistyksen ruudun
         tyhjyksen (tai tytn) edelle, poistat inhottavan vilkkumisen.

         PROCEDURE FillScr (Vari : Byte);
           Begin
             Waitscreen;
             FillChar (Mem [$A000: 0], 64000, VARI);
           End;

         Tyhjtksesi tekstitilassa olevan ruudun mustaksi:

         FillChar (Mem [$B800: 0], 4000, 0);

         Huomaa yll ett kyse on vrinytst, mustavalkonytll ruudun
         osoite alkaa kohdasta  $B000  !!

PALETTI - PALETTE

         Voidaksesi piirt omia kuvia, kuvioita tai tehd vriliukuja tai
         hivytyksi, joudut muuttamaan nytn vrej. Koska VGA/MCGA
         ruudulla on 256 vri, mys paletti koostuu 256 (eri) vrin
         komponenteista. Monitori "tekee" pisteen piirtmll kolme eri
         vrin osaa halutulla voimakkuudella. Jos kaikki vrin komponentit
         ovat arvoa 0, vri on musta (eli ei vri) ja jos kaikki kolme osaa
         ovat arvoa 63 (kirkkain) on vri valkoinen, jolloin kaikki kolme
         vri pistett ovat tysin kirkkaina. Koska nm kolme vrin arvoa
         ovat punainen, vihre ja sininen, on jrjestelmn nimi RGB, joka
         tulee vrien englanninkielisist nimist Red, Green ja Blue.

VRIN ASETUS - SET COLOR

         Vrien muuttamiseksi asetetaan (kirjoitetaan) portteja
         hyvksikytten porttiin $3C8 vrin numero, eli mit paletin 256
         eri vrisvyst halutaan muuttaa. Tmn jlkeen kirjoitetaan
         porttiin $3C9 vrin puna-arvo ja samaan porttiin kirjoitetaan
         mys vrin viher- ja sinisyysarvo. Jos siis haluamme vaihtaa vrin
         numero 0 eli paletin ensimmisen vrin (norm. musta) valkoiseksi,
         asetamme porttiin $3C8 arvon nolla vriksi jota haluamme muokata.
         Tmn jlkeen kirjoitamme porttiin $3C9 luvun 63 kolme kertaa
         (valkoisen RGB arvot ovat 63,63,63). Alla oleva esimerkki valaisnee
         asiaa.

         Port [$3C8] := 0;  { vrin numero }
         Port [$3C9] := 63; { punainen / Red }
         Port [$3C9] := 63; { vihre / Green }
         Port [$3C9] := 63; { sininen / blue }

         Tst voimme muodostaa seuraavan nkisen aliohjelman. Huomaa ett
         RGB-arvot tulee olla muotoa BYTE, kuten vrin numerokin.

         Procedure SetColor ( Vari, Red, Green, Blue : Byte );
           Begin
             Port [$3C8] := Vari;
             Port [$3C9] := Red;
             Port [$3C9] := Green;
             Port [$3C9] := Blue;
           End; { SetColor }

         Jotkut ohjelmat (DeluxePaint, Windows) kyttvt vrien mritykseen
         lukuja 1..256. Jos haluat kytt tllist vri, jonka olet esim.
         katsonut jostain ohjelmasta, joudut jakamaan jokaisen arvon neljll.
         Tsskin on pieni oikotie, eli jo pisteen piirron yhteydess
         mainittu bittien siirtely, joka vastaa kahden potensseissa
         kertomista tai kahdella jakamista. Neljll jakaminen on mys sama
         kuin siirtisi luvun kaikkia bittej kaksi bitti oikealle (eli
         Paletin_arvo := Paletin_arvo SHR 2;)

VRIN LUKEMINEN - GET COLOR

         Pisteen X,Y vrin lukeminen on tysin identtinen toimenpide pisteen
         kirjoittamisen kanssa. Ainoa mit vrin lukeminen tuottaa on luku
         0..255, eli paletin vrin numero. Eli muuttujaan asetetaan vrin
         numero seuraavasti kytten MEM taulukkoa jlleen hyvksi:

          Vari := Mem [$A000: X + Y SHL 8 + Y SHL 6];

         Ja tmkin voidaan laittaa omaksi aliohjelmaksi aivan MEMPUTPIXELin
         tavoin. MEMGETPIXEL lienee sopiva nimi. Alla mys erittin selke
         assembler rutiini, joka on muutamaa ksky vaihtamalla tysin
         identtinen vastaavan PutPixel-rutiinin kanssa.

         Function GetPixel (X, Y : Integer): Byte; Assembler;
           Asm
             MOV  AX, $A000
             MOV  ES, AX
             MOV  BX, [X]
             MOV  DX, [Y]
             MOV  DI, BX
             MOV  BX, DX
             SHL  DX, 8
             SHL  BX, 6
             ADD  DX, BX
             ADD  DI, DX
             LODSB
           End; { GetPixel }

PALETIN VRIN LUKEMINEN - GETPALETTE

         Jos ruudun piste pystytn lukemaan yllolevin rutiinein, lienee
         syyt selvitt mys keino lukea mit pisteen vrien RGB-arvot
         ovat. Eli jos haluamme tiet todelliset vriarvot, meidn on
         luettava ne asettamalla porttiin $3C7 halutun vrin arvo ja luettava
         R, G ja B -arvot perkkin portista $3C9, aivan kuin kirjoittaessakin
         tehdn. Jos haluaisimme lukea vrin 0 RGB-arvot, olisi toimenpide
         seuraavan nkinen:

         (Var Red, Green, Blue : BYTE;)
         Port [$3C7] := 0;
         Red   := Port [$3C9];
         Green := Port [$3C9];
         Blue  := Port [$3C9];

         Ja tm voidaan muuttaa aliohjelmaksi, joka lukee halutun vrin
         arvot haluttuihin muuttujiin (huomaa siis parametreiss olevat
         VAR lausekkeet, jotka kertovat ett funktio laittaa arvot
         muuttujiin).

         Procedure GetColor ( Vari : BYTE; VAR Red, Green, Blue : Byte );
           Begin
             Port [$3C7] := Vari;
             Red := Port [$3C9];
             Green := Port [$3C9];
             Blue := Port [$3C9];
           End; { GetColor }

         Tmn jlkeen voidaan luettuja muuttujia muutella, esimerkiksi
         himmennyst varten, joka hoituu vaikkapa normaaleja toistolauseita
         ja pystyvirkistyst kytten melko helposti.

TEKSTIRUUDULLE KIRJOITUS - WRITECHAR

         Tekstitilassa ruudulle on helppo kirjoittaa, kytten vaikka perus-
         kskyj, kuten WRITE/WRITELN, mutta jos halutaan kirjoittaa nopeasti
         ja omia kskyj kytten, voidaan kytt vaikkapa seuraavanlaista
         MEM rutiinia, jolla saavutetaan peruskirjaston rutiineja nopeampi
         kirjoitus (ja voidaan tietysti jatkaa MEM-taulukon hyvksikytt):

         procedure WriteChar (X, Y, Attr : Byte; Ch : Char);
           Var
             LocationCode : Integer;
           Begin
             LocationCode := (X - 1) * 2 + (Y - 1) * 160;
             Mem[$B800 : Locationcode] := Ord(Ch);
             Mem[$B800 : Locationcode + 1] := Attr;
           End;

         Yllolevasta ruudun segmentist pit muistaa ett mustavalkonytll
         segmentti josta kirjoitus aloitetaan on eri kuin vrinytll.
         Vrinytn osoite on yllolevan mukainen $B800, mutta mustavalko-
         nytn kanssa toimitaan segmentiss $B000. Mist sitten tiet onko
         kyttjll mustavalko- vai vrinytt? Jlleen hieman omituiselta
         tuntuvia MEM-taulukon kohtia ja pystymme tallettamaan ruudun
         osoitteen muuttujaan. Tmn jlkeen voidaan segmentti korvata LongInt
         tyypin muuttujalla RuudunSeg, kunhan ohjelman alussa kydn
         katsomassa onko vrinytt olemassa.

           (var RuudunSeg : Longint;)
           if (Mem[0000:1040] and 48) <> 48 then
             RuudunSeg := $B800
           else
             RuudunSeg := $B000;

         Huomaa miten lopullinen offset eli muuttuja "Locationcode" lasketaan!
         Monimutkaisuus johtuu tekstitilan videomuistin jrjestyksest, jossa
         80 merkki 25 rivill vie 2000 tavua muistia (80*25=2000). Mutta
         koska tekstitilassa on mukana vrit ja attribuutit, on jokaisen
         merkin perss BYTE kokoinen (tai char kokoinen, arvot kuitenkin
         vlilt 0..255) attribuutti-tavu, joka mr miten ja mill vrill
         merkki kirjoitetaan. Tmn vuoksi joudutaan kyttmn aliohjelmassa
         olevaa kerrointa kaksi (2) ja lisksi koska tllin mys yksi 80
         merkkinen rivi vie 160 merkki (tai tavua), joudutaan aivan kuten
         grafiikkatilassakin laskemaan lopullinen osoite hivenen hankalasti
         kertoilemalla. Muista mys ett mustavalkonytll videoruudun
         osoite on $B000 eik $B800!
         Attr puolestaan tarkoittaa attribuuttia, eli yhteenlaskettua
         vri-, taustavri- ja vilkuntalukua. Voi kuulostaa sekavalta, mutta
         seuraava taulukko selventnee asiaa:

           Black       = $00;      DarkGray       = $08;
           Blue        = $01;      LightBlue      = $09;
           Green       = $02;      LightGreen     = $0A;
           Cyan        = $03;      LightCyan      = $0B;
           Red         = $04;      LightRed       = $0C;
           Magenta     = $05;      LightMagenta   = $0D;
           Brown       = $06;      Yellow         = $0E;
           LightGray   = $07;      White          = $0F;

         Eli ylhll on kaikkien mahdollisten tekstin edustavrien koodit.
         Miksi luvut ovat sitten heksadesimaalimuodossa? Perus Turbo Pascalhan
         ilmoittaa tysin samat luvut yhdest kuuteentoista (vrikoodit
         lytyvt TP:n on-line helpist vaikkapa haku-sanalla BLACK).
         Tss ne ovat selvyyden vuoksi heksoina, jotta taustavrin
         yhdistminen olisi helpompaa. Seuraavana nimittin taustavrit:

           BlackBG     = $00; { 0   }
           BlueBG      = $10; { 16  }
           GreenBG     = $20; { 32  }
           CyanBG      = $30; { 48  }
           RedBG       = $40; { 64  }
           MagentaBG   = $50; { 80  }
           BrownBG     = $60; { 96  }
           LightGrayBG = $70; { 112 }

         Eli taustavri ja edustavri mrytyvt laskemalla niden vastaavat
         heksaluvut yhteen. Jos haluat esimerkiksi valkoisen merkin sinisell
         taustalla, olisi luku $1F ($10 (BlueBG) + $0F (White)).
         Mutta ei laskemisen tarvitse olla vaikeata, koska TP sislt samat
         arvot valmiiden vakioiden muodossa. Eli kaikki yllolevat vrit
         lytyvt oikeilla nimilln helpist. Taustavrit tosin joudut
         lunttaamaan tai pttelemn yllolevista.
         Lisksi tekstitilassa on olemassa erillinen attribuutti BLINK,
         joka on heksana $80. Eli jos haluat vilkkuvan sinisen tekstin
         mustalla taustalla, olisi kokonainen luku $90 ($0+$10+$80).
         Huomion arvoinen seikka lienee ett jos kytt seuraavaa rutiinia,
         saat kyttsi 16 edustavri ja 16 TAUSTAVRI:

           (Var Regs : REGISTERS; { uses DOS })

           FillChar(Regs,SizeOf(Regs),0);
           Regs.AH := $10;
           Regs.AL := $03;
           Regs.BL := $00;
           Intr($10,Regs);

         Vaihtamalla viimeisess "Regs.BL" kohdassa olevan luvun $00 luvuksi
         $01 pset takaisin arkisempaan 80x25 tilaan, jossa on 16 edusta-
         vri, 8 taustavri ja vilkuntatila. Ja ei liene mahdotonta
         ptell aikaisempien esimerkkien perusteella miten kskyist
         muodostetaan kokonainen aliohjelma tai miten kyseinen ptk
         kirjoitetaan assemblerilla. Tss oli sitpaitsi kyse vain yhden
         merkin kirjoituksesta, mutta ei liene ylivoimaista muodostaa
         kskyist kokonaisen merkkijonon (string) kirjoittava versio.

GRAFIIKKARUUDULLE KIRJOITUS - GFXWRITE

         Kun edellisess kappaleessa ksiteltiin kyllstymiseen asti tekstin
         kirjoitusta ruudulle, lienee syyt ksitell myskin grafiikka-
         ruudulle kirjoitus, koska vaikka tapa on samankaltainen, rutiini
         on erilainen:

         Procedure BIOSWrite(Teksti : String; Vari : Byte); Assembler;
           Asm
             les  di, Teksti
             mov  cl, es:[di]
             inc  di
             xor  ch, ch
             mov  bl, Vari
             jcxz @PoistuBW
           @SeuraavaBW:
             mov  ah, 0eh
             mov  al, es:[di]
             int  10h
             inc  di
             loop @SeuraavaBW
           @PoistuBW:
           End;

         Eli aluksi katsotaan mist osoitteesta tekstin merkit lytyvt jonka
         jlkeen kirjain kerrallaan kirjoitetaan BIOSin keskeytyst numero
         $10 kyttmll kirjaimet ruutuun. Huomaa kirosanat: kirjain
         kerrallaan sek BIOSin keskeytys. Ja tss vaiheessa tulisi nhd
         punaista (Red ;), sill vaikka tuolla tavalla saadaan merkkijono
         ruutuun jos esim. kysytn kyttjn palautetta, niin tuolla tavalla
         ei kyll mitn nopeusenntyksi rikota, saati sitten toteuteta
         hienoja scrolleja tai tehd sulavia tekstinksittelyrutiineja. Mutta
         ylloleva rutiini on helppo ja toimiva (joka koneessa).

         Toimiva, nopeampi rutiini saa joskus varauksetonta kannustusta,
         joten ehk on syyt selitt tapa jolla sellaisen saa melko vhll
         vaivalla tehty. Ensiksikin, tilanviennin minimoimiseksi kannattaa
         kytt valmista fonttia, joka lytyy kaikista koneista. Se sijaitsee
         BIOSissa ja sen kyttmiseen ei vaadita monimutkaisia rutiineja,
         tarvitsee vain tiet miten kuvaruudulla nkyv kirjain muodostetaan
         tai oikeastaan MIST se muodostuu.

         Normaali fontti muodostuu 8x8 bitin (tavu kanttiinsa) taulukosta, eli
         jokaisen kirjaimen yhden rivin voi ilmaista yhdell tavulla tai
         merkill. Katso allaolevaa esimerkki kirjaimesta "A":
         07 06 05 04 03 02 01 00     Koska vasemmalla olevassa esimerkiss
         :: :: ## ## ## :: :: ::     ensimmisell rivill on paikoissa
         :: ## ## :: ## ## :: ::     5, 4 ja 3 jotain, on niden kohtien
         ## ## :: :: :: ## ## ::     bitti asetettu, eli koko ensimminen rivi
         ## ## ## ## ## ## ## ::     on binrimuodossa:
         ## ## ## ## ## ## ## ::     00111000 eli desimaalilukuna 56 ($38).
         ## ## :: :: :: ## ## ::
         ## ## :: :: :: ## ## ::
         :: :: :: :: :: :: :: ::

         Jos haluamme siis tiet onko esim. "A" kirjaimen jokin bitti
         asetettu, eli piirrmmek ruudulle juuri siihen kohtaan pisteen,
         vai jtmmek sen tyhjksi (tai piirrmmek sen muulla vrill
         tekstin korostamiseksi), kytmme AND operaattoria, jolla voimme
         nhd "onko totta ett x bitti on pll".
         Oletetaan ett haluamme tiet, onko A-kirjaimen ensimmisen rivin
         ensimminen bitti asetettu. Kymme katsomassa osoitteesta
         MEM [$0F000:$0FA6E], jossa sijaitsee koko merkist riveittin
         talletettuna lineaariseen (suoraviivaiseen) taulukkoon.
         Eli muistipaikoissa on aluksi merkki numero 01:n ensimminen rivi,
         sitten ASCII-merkki numero 02:n ensimminen rivi, kukin ilmoitettuna
         yhdell tavulla (BYTE) ja taulukko jatkuu kunnes tulee vastaan
         merkki numero 255 (jonka rivin numero on muuten 00, koska merkki on
         "tyhj"), jonka jlkeen tulee ensimmisen merkin toinen rivi jne.
         Jos siis haluamme ksiimme tuon A-kirjaimen ensimmisen rivin merkin
         meidn tulee katsoa muistipaikasta:
          MEM [$0F000:$0FA6E+Ord (A) * 8]
         Eli tmn jlkeen voimme katsoa onko jokin bitti asetettu kyseisess
         muistipaikassa (tai muuttujassa, jos halutaan ottaa sislt
         muuttujaan) ANDaamalla, eli ensimminen bitti saadaan selville
         kyttmll lukua 128, toinen lukua 64, kolmas lukua 32, neljs
         kyttmll lukua 16, viides lukua 8, kuudes lukua 4, seitsems
         lukua 2 ja viimeisen saa selville luvulla 1. Huomaat varmaan jlleen
         ett kyseess on kahden potenssit. Eli itseasiassa sammutamme kaikki
         muut bitit ja jos haluamamme j "palamaan", kyseinen bitti on
         asetettu.
         Eli yllolevaan hlinn perustuen, A kirjaimen ensimmisen rivin
         ensimminen bitti tulee selville
          If mem [$0F000:$0FA6E+(Ord ('A')* 8)] And 128
         Jos haluaisimme saada koko rivin selville, tulee siis kyd lpi
         ANDaamalla koko muistipaikka. Eli kannattaa joko tehd silmukka,
         jossa otetaan taulukosta tarvittava luku. Eli silmukka 0..7 ja
         sitten luetaan BITMASK [Silmukka]. BITMASK taulukkoon
         tallennetaan luvut 128,64,32,16,8,4,2,1 ja tss jrjestyksess.

           Const Bitmask : array [0..7] of byte = (128,64,32,16,8,4,2,1);

           For LoopX:=0 to 7 do
             For LoopY := 0 to 7 do
               If MEM [$0F000:$0FA6E + (Ord ('A') * 8) + LoopY]
                 And Bits [LoopX]<>0
               Then MEM [$A000: LoopY * 320 + LoopX] := 15;

         Yllolevassa rutiinissa piirretn kirjain 'A' ruudulle, joten pient
         mielikuvitusta kyttmll saadaan tuon 'A' kirjaimen tilalle
         esimerkiksi muuttuja, tai osa muuttujasta (osa esim. Length (Teksti)
         funktiota kyttmll joka palauttaa koko string muuttujan vaatiman
         tilan. Huomaa ett luku 15 on vri joksi fontti asetetaan, kyseess
         voisi olla mys muuttuja (esim. Vari) tai esimerkiksi laskutoimitus
         LoopY SHL 1, jolloin tapahtuu "liukuvrjys". Hyv keino on mys
         laittaa IF..THEN..ELSE silmukka, jos halutaan kirjaimien nkyvn,
         eli kytnnss tehd kirjaimien taustavri:
           Then MEM [$A000: LoopY * 320 + LoopX] := Edusta_Vari
             ELSE MEM [$A000: LoopY * 320 + LoopX] := Tausta_Vari;

         Jos tekee silmukan, joka hinkkaa lpi koko string muuttujan
         merkki kerrallaan, voi kytt viel yht FOR lausetta ilmaisemaan
         kulloisenkin merkin eli kymn lpi string-muuttujaa kirjain
         kerrallaan. Ja sitten vain if lauseeseen
           Ord (Teksti [Kulloinen_merkki])
         ja meill on tekstinkirjoitusrutiini olemassa.

             Omia fontteja tai kirjaisimia voit tehd suhteellisen helposti
         samoin keinoin kuin BIOSin fontit; tallenna tuotoksesi taulukkoon,
         josta katsot kirjaimen sislln.  Tai voit tehd suoraan taulukon
         jossa merkit ovat BYTE-tyyppisin lukuina, eli suorina vriarvoina.
         Esimerkiksi 'A'-kirjaimen ensimminen rivi voisi olla tllin
         seuraavanlainen:
         (:: :: ## ## ## :: :: ::)
          00,00,01,02,01,00,00,00

         Jos haluat tehd omia fontteja tai omia fontinpiirtimi, helppo
         tapa laskea kirjaimen rivej on muistaa yllksitelty tapa, eli
         ensimminen merkki on 128, toinen 64 jne.  Lismll jokainen
         bitti erikseen saadaan loppusummaksi luku, jota rivi vastaa.
         Esimerkiksi A-kirjaimen rivi muodostuu seuraavasti:
         Binrimuoto:  0 0  1  1 1 0 0 0
         Desimaalimuoto:0+0+32+16+8+0+0+0 = 56

         Jos kaikki bitit on asetettu, eli luku on 255, on rivi siis tmn
         nkinen:
         Binrimuoto:     1  1  1  1 1 1 1 1
         Desimaalimuoto: 128+64+32+16+8+4+2+1 = 255

NOPEUSEROISTA - ERILAISET PISTEEN PIIRTO RUTIINIT

         Tmn tekstin viimeiseksi olen sstnyt pienen arvion ja testin
         eri pisteenpiirtotapojen eroista. Aina valitellaan ett pisteen-
         piirtorutiini on liian hidas ja ett "minulla on nopeampi".

         Ensin haluaisin selvitt hivenen testialiohjelmia, eli itse
         rutiineja.
         Kaikki rutiinit oli upotettu itse ohjelmaan (ei esim. kirjastoihin
         tai ulkoisiin tiedostoihin), kaikkia rutiineja testattiin samassa
         silmukassa, kovalevyn cache-ohjelma oli poissa plt.  Testin kone
         oli 386/25.
         PutPixel tarkoittaa PISTEEN PIIRTO RUUDULLE - PUTPIXEL kappaleessa
         esitelty assembler-rutiinia.
         MemPutPixel tarkoittaa samassa kappaleessa esitelty tapaa piirt
         piste suoraan muistiin kyttmll MEM-taulukkoa.
         PutPixx tarkoittaa seuraavaa rutiinia, jossa laitetaan piste
         suoraan paikkaan ES:DI.  Jotkut kehuivat tapaa todella nopeaksi ja
         elegantiksi.
         PutPixell viittaa rutiiniin, jossa kytetn suoraa osoitusta ja
         ennaltalaskettua taulukkoa Y:n arvoista. Asphyxia TUT17.ZIP sislt
         tt rutiinia hydyntvn GFX3.TPU:n.
         Rutiini vaatii vhintn 286 prosessorin, eli ohjelman alkuun
         tulee laittaa ksky {$G+} tai Options|Compiler|286-instructions
         tulee laittaa plle.


         PROCEDURE PutPixx(x,y:word;c:byte); assembler;
           Asm
             MOV  DI,0A000h
             MOV  ES,DI
             MOV  DI, Word PTR [Y]
             MOV  AX,DI
             SHL  DI,2
             ADD  DI,AX
             SHL  DI,6   { DI = 320*Y }
             ADD  DI, Word PTR [X]
             MOV  AL, Byte PTR [C]
             MOV  Byte PTR [ES:DI],AL
           End;

         BIOSPutPixel tarkoittaa itse BIOSin kautta keskeytyksin tehtv
         pisteenpiirtoa joka on "oikea" tapa ja jota kaikki haukkuvat
         todella hitaaksi.
                         Silmukka 1  Silmukka 2  Silmukka 3
         (Vertailu:         34.60        6.04        3.52)
         PutPixel           38.39        9.83        4.40
         MemPutPixel        38.01        9.61        4.01
         PutPixx            43.83        9.07        3.79
         PutPixell          38.01        9.50        4.01
         BIOSPutPixel      109.30       81.18       11.09

         Vertailun vuoksi mukana on mukavasti kikkailtu rutiini, joka
         osoittautui nopeimmaksi ja osoittaa sen mihin asti pstn kun
         asiaan paneudutaan. Mutta kotikonsteinkin erot melko pieni jos
         BIOSin kutsuja ei laske mukaan. Ja on otettava huomioon koneen
         nopeus, eli 386/25 masiinanalla 38.39 sekunnin looppi kesti
         vastaavasti 486/66 koneella tasan 0.66 sekunttia.

         Silmukka 1 on yksinkertainen ohjelmanptk, jossa siirryttiin
         grafiikkatilaan, otettiin kellonaika muistiin, piirrettiin miljoona
         pistett satunnaisiin paikkoihin satunnaisin vrein tyyliin
           FOR Looppi := 1 to 1000000 DO
             Piirto_Rutiini (Random(320),Random(200),Random(256));
         Rutiinin ajon jlkeen otettiin aika talteen, laskettiin kulunut
         aika ja palattiin tekstitilaan ja nytettiin tulokset.
         Silmukka 2 oli miljoonan pisteen piirto yhteen kohtaan ruudulla
         yhdell ja samalla vrill.
         Silmukka 3 oli sadantuhannen pisteen piirto satunnaiseen paikkaan
         satunnaisin vrein, aivan kuten silmukka ykksess.
         Testit eivt ole mitenkn virallisia tai ptevi, osoittavatpa
         vain eri rutiinien eroja eri tilanteissa. Lhdekoodin saa tekijlt.

TEKIJ   Jussi Josefsson (C) 1996
         Rutiinit ovat tarkoitettu kaikille tahoille julkiseen kyttn ja
         kytettviksi omiin ohjelmiin, mit tahansa ne sitten ovatkin.
         Rutiinit on testattu kahdella eri koneella ja ne ovat toimineet
         tekijn kytss.
         Otan mielellni vastaan korjauksia, parannusehdotuksia, kommentteja
         ja palautetta kaikilta lukijoilta.
         Keskustelua ja kysymyksi voi esitt MBnetin
         PC-ohjelmointialueella (8) Jani Tiaiselle tai
         Yksityisposti-alueelle (99) samalle nimelle.


