{       SBDSP is Copyright 1994 by Ethan Brodsky.  All rights reserved.      }
{$M 16384, 0, 419430   Give some memory to the DOS shell.  If you are not}
{going to shell to DOS, you can remove this line and let your program use}
{all available memory for the heap.}
program PlayVOCDirect;
    uses
        CRT,
        DOS,
        Mem,
        SBDSP,
        VOC;
    const
        IRQ        = 5;
        BaseIO     = $220;
        DMAChannel = 1;
        DefaultVOC = 'C:\MUSIC\ESCAPE2.VOC';
         {Put the name of the VOC file to play here}
         {or pass it as a parameter to the program.}
    var
        VOCFileName : string;
        SoundSize   : LongInt;
        Sound       : PSound;
        Chr         : char;
        OldMarkerProc : pointer;
    function GetHexWordStr(w: word): string;
        const
            HexChars: array [0..$F] of Char = '0123456789ABCDEF';
        begin
            GetHexWordStr := HexChars[Hi(w) shr 4] + HexChars[Hi(w) and $F] +
                             HexChars[Lo(w) shr 4] + HexChars[Lo(w) and $F];
        end;
    procedure DisplayMarker; far;
        var
            Hour, Minute, Second, Sec100: word;
        begin
            GetTime(Hour, Minute, Second, Sec100);
            writeln('Reached marker ', LastMarker,
                    ' at ', Hour, ':', Minute, ':', Second, '.', Sec100);
            if (OldMarkerProc <> nil) then Proc(OldMarkerProc);
              {If another handler is installed, call it}
        end;
    procedure WriteInstructions;
        begin
            writeln('Begining output of sound file');
            writeln('Press <B> to break loop');
            writeln('Press <P> to pause output');
            writeln('Press <C> to continue output');
            writeln('Press <D> to shell to DOS');
            writeln('Press <X> to stop output and exit');
        end;
    begin
        writeln; writeln;

        if EnvironmentSet
            then
                begin
                    if InitSBFromEnv
                        then
                            begin
                                writeln('Sound card initialized correctly using the BLASTER environment variable!');
                                writeln('DSP version ', GetDSPVersion);
                            end
                        else
                            begin
                                writeln('Error initializing sound card!');
                                Halt(255);
                            end;
                end
            else
                begin
                    writeln('BLASTER environment variable not set, using default settings');
                    writeln('IRQ = ', IRQ, '    Base IO = $', GetHexWordStr(BaseIO), '    DMA Channel = ', DMAChannel );
                    if InitSB(IRQ, BaseIO, DMAChannel)
                        then
                            begin
                                writeln('Sound card initialized correctly!');
                                writeln('DSP version ', GetDSPVersion);
                            end
                        else
                            begin
                                writeln('Error initializing sound card!');
                                Halt(255);
                            end;
                end;

        if ParamCount = 0
            then VOCFileName := DefaultVOC
            else VOCFileName := ParamStr(1);
        SoundSize := LoadVOCfile(VOCFileName, Sound);  writeln('Sound file loaded');
        if SoundSize = 0
            then
                begin
                    writeln('Error loading VOC file.  Probably because:');
                    writeln('    1.  There is no VOC file by name ', VOCFileName, '.');
                    writeln('    2.  There is not enough memory to load it.');
                    writeln('        Largest available block:  ', MaxAvail, ' bytes');
                    Halt;
                end;

        GetMarkerProc(OldMarkerProc);
        SetMarkerProc(@DisplayMarker);

        TurnSpeakerOn;
        WriteInstructions;
        PlaySound(Sound);
        repeat
            if KeyPressed
                then
                    begin
                        Chr := UpCase(ReadKey);
                        case Chr
                            of
                                'B':
                                    begin
                                        BreakLoop;
                                        writeln('Broke out of loop');
                                    end;

                                'P':
                                    begin
                                        PauseSound;
                                        writeln('Sound output paused');
                                    end;
                                'C':
                                    begin
                                        ContinueSound;
                                        writeln('Sound output continued');
                                    end;
                                'D':
                                    begin
                                        SwapVectors;
                                        Exec(GetEnv('COMSPEC'), '');
                                        if DOSError <> 0
                                            then
                                                begin
                                                    writeln('Error running COMMAND.COM!');
                                                    Halt(255);
                                                end;
                                        SwapVectors;
                                        WriteInstructions;
                                    end;
                                'X':
                                    begin
                                        PauseSound;
                                        writeln('Sound output stopped!');
                                        Exit;
                                    end;
                            end;
                    end;
            if UnknownBlock
                then
                    begin
                        writeln('An unknown VOC block was reached.  It is probably');
                        writeln('block 8, which I didn''t implement because it is');
                        writeln('useless. (At least for this library it is)');
                        UnknownBlock := false;
                    end;
            if UnplayedBlock
               then
                   begin
                       writeln('A 16-bit or stereo block was reached.  This library');
                       writeln('doesn''t support either of these.');
                       UnplayedBlock := false;
                   end;
        until (SoundPlaying = false);
        TurnSpeakerOff;

        SetMarkerProc(OldMarkerProc); {Not really necessary}
        FreeBuffer(pointer(Sound), SoundSize);
        ShutDownSB;
    end.