{

                                                      ͻ
                                                         Special Key    
                                                         Defines Unit   
                                                          Rev. 1.00     
                                                      ͼ

}

{$F-} {$O-} {$A+} {$G-}
{$V-} {$B-} {$X-} {$N+} {$E+}

{$I FINAL.PAS}

{$IFDEF FINAL}
  {$I-} {$R-}
  {$D-} {$L-} {$S-}
{$ENDIF}

Unit KeyDef;

Interface

Const
  Key_Alt      = #249;
  Key_Shift    = #248;
  Key_Ctrl     = #247;
  Key_Up       = #246;
  Key_Down     = #245;
  Key_Left     = #244;
  Key_Right    = #243;
  Key_Home     = #242;
  Key_PgUp     = #241;
  Key_PgDn     = #240;
  Key_End      = #239;
  Key_Ins      = #238;
  Key_Del      = #237;
  Key_Tab      = #236;
  Key_Enter    = #235;
  Key_Esc      = #234;
  Key_F12      = #233;
  Key_F11      = #232;
  Key_F10      = #231;
  Key_F9       = #230;
  Key_F8       = #229;
  Key_F7       = #228;
  Key_F6       = #227;
  Key_F5       = #226;
  Key_F4       = #225;
  Key_F3       = #224;
  Key_F2       = #223;
  Key_F1       = #222;
  Key_Back     = #221;
  Key_None     = #220;

  Mouse_Only            = #200;
  Mouse_SlideBarVert    = #199;
  Mouse_SlideButtonVert = #198;
  Mouse_SlideBarHorz    = #197;
  Mouse_SlideButtonHorz = #196;

Function SpecialCode (HeldKey, MainKey:Char):Boolean;
Function KeyCode     (HeldKey, MainKey:Char):Char;

Implementation

Function SpecialCode(HeldKey, MainKey:Char):Boolean;

Var
  Temp:Boolean;

Begin
  Temp:=False;

  If HeldKey = Mouse_Only Then Temp:=True;
  If HeldKey = Key_Alt Then Temp:=True;
  If (HeldKey = Key_Ctrl) Then
    If (MainKey in ['A'..'Z','6','-','\',Key_Back]) Then
      Temp:=False
    Else
      Temp:=True;
  If MainKey in [Key_F1..Key_F10, Key_Del..Key_Up] Then Temp:=True;

  SpecialCode:=Temp;
End;

Function KeyCode(HeldKey, MainKey:Char):Char;

Var
  Temp:Char;

Begin
  Temp:=#255;
  If HeldKey=Key_None Then
  Begin
    Case MainKey Of
      Key_Tab   :Temp:=#9;
      Key_Enter :Temp:=#13;
      Key_Esc   :Temp:=#27;
      ' '..'`'  :Temp:=MainKey;
      Key_Ins   :Temp:='R';
      Key_Del   :Temp:='S';
      Key_Home  :Temp:='G';
      Key_Up    :Temp:='H';
      Key_PgUp  :Temp:='I';
      Key_Left  :Temp:='K';
      Key_Right :Temp:='M';
      Key_End   :Temp:='O';
      Key_Down  :Temp:='P';
      Key_PgDn  :Temp:='Q';
      Key_F1..
        Key_F10 :Temp:=Chr(Ord(MainKey)-Ord(Key_F1)+59);
    End;
  End
  Else
  If HeldKey=Key_Ctrl Then
  Begin
    Case MainKey Of
      'Q'       :Temp:=#17;
      'W'       :Temp:=#23;
      'E'       :Temp:=#5;
      'R'       :Temp:=#18;
      'T'       :Temp:=#20;
      'Y'       :Temp:=#25;
      'U'       :Temp:=#21;
      'I'       :Temp:=#9;
      'O'       :Temp:=#15;
      'P'       :Temp:=#16;
      '['       :Temp:=#27;
      ']'       :Temp:=#29;
      'A'       :Temp:=#1;
      'S'       :Temp:=#19;
      'D'       :Temp:=#4;
      'F'       :Temp:=#6;
      'G'       :Temp:=#7;
      'H'       :Temp:=#8;
      'J'       :Temp:=#10;
      'K'       :Temp:=#11;
      'L'       :Temp:=#12;
      'Z'       :Temp:=#26;
      'X'       :Temp:=#24;
      'C'       :Temp:=#3;
      'V'       :Temp:=#22;
      'B'       :Temp:=#2;
      'N'       :Temp:=#14;
      'M'       :Temp:=#13;
      '2'       :Temp:=#3;
      '6'       :Temp:=#30;
      '-'       :Temp:=#31;
      '\'       :Temp:=#28;
      Key_Back  :Temp:=#127;

      Key_F1..
        Key_F10 :Temp:=Chr(Ord(MainKey)-Ord(Key_F1)+94);

      Key_Ins   :Temp:=#4;
      Key_Del   :Temp:=#6;
      Key_Home  :Temp:=#119;
      Key_PgUp  :Temp:=#132;
      Key_Left  :Temp:=#115;
      Key_Right :Temp:=#116;
      Key_End   :Temp:=#117;
      Key_PgDn  :Temp:=#118;
    End;
  End
  Else
  If HeldKey=Key_Alt  Then
  Begin
    Case MainKey Of
      'Q'       :Temp:=#16;
      'W'       :Temp:=#17;
      'E'       :Temp:=#18;
      'R'       :Temp:=#19;
      'T'       :Temp:=#20;
      'Y'       :Temp:=#21;
      'U'       :Temp:=#22;
      'I'       :Temp:=#23;
      'O'       :Temp:=#24;
      'P'       :Temp:=#25;
      'A'       :Temp:=#30;
      'S'       :Temp:=#31;
      'D'       :Temp:=#32;
      'F'       :Temp:=#33;
      'G'       :Temp:=#34;
      'H'       :Temp:=#35;
      'J'       :Temp:=#36;
      'K'       :Temp:=#37;
      'L'       :Temp:=#38;
      'Z'       :Temp:=#44;
      'X'       :Temp:=#45;
      'C'       :Temp:=#46;
      'V'       :Temp:=#47;
      'B'       :Temp:=#48;
      'N'       :Temp:=#49;
      'M'       :Temp:=#50;
      '1'..'9'  :Temp:=Chr(Ord(MainKey)-Ord('1')+120);
      '0'       :Temp:=#129;
      '-'       :Temp:=#130;
      '='       :Temp:=#131;
      Key_F1..
        Key_F10 :Temp:=Chr(Ord(MainKey)-Ord(Key_F1)+104);
    End;
  End
  Else
  If HeldKey=Mouse_Only Then
  Begin
    Case MainKey Of
      Mouse_SlideBarVert     :Temp:=#249;
      Mouse_SlideButtonVert  :Temp:=#248;
      Mouse_SlideBarHorz     :Temp:=#247;
      Mouse_SlideButtonHorz  :Temp:=#246;
    End;
  End;

  KeyCode:=Temp;
End;

End.

{ Copyright 1993, Michael Gallias }
