
PROGRAM StarsDemo;
USES
  driver,graph,graph3d;

CONST
  NumStars = 100;
  Speed = 2;
TYPE StarPos = ARRAY[0..NumStars] OF TPoint3D;

VAR
  Stars : StarPos;

{----------------------------------------------------------------------------}

PROCEDURE Init;

VAR
  I : byte;

BEGIN
  randomize;                                              { Initialize stars }
  FOR I := 0 TO NumStars DO BEGIN
    Stars[I].X := random(100)-50;
    Stars[I].Y := random(100)-50;
    Stars[I].Z := random(200);
  END;
 FOR i:=0 TO 63 DO
  BEGIN
   SetPaletteRGB(I,2*I,2*I,2*I);
  END;
END;

{----------------------------------------------------------------------------}

PROCEDURE DoStars;

VAR
  x,y:integer;
  I,Color : byte;
PROCEDURE NewStar(Num : byte);

VAR
  x,y:integer;

BEGIN
 putpixel3d(Stars[Num].x,Stars[Num].y,Stars[Num].Z,0);
  Stars[Num].X := random(100)-50;
  Stars[Num].Y := random(100)-50;
  IF speed>0
   THEN
    Stars[Num].Z := 0
     ELSE
      Stars[Num].Z := 200;
END;
VAR ch:char;
    x1,y1,x2,y2:integer;
BEGIN
 SetOrigin3D(160,100,200);
  REPEAT
    retrace;
    FOR I := 0 TO NumStars DO
     BEGIN                                  { Stars }
      Putpixel3d(Stars[I].x,Stars[I].y,stars[I].z,0);
      inc(Stars[I].z,Speed);
      Putpixel3d(Stars[I].x,Stars[I].y,stars[I].Z,(Stars[i].z DIV 10));
      IF ((speed>0) AND (Stars[I].z>=200)) OR ((speed<0) AND (Stars[I].z<=0))
         THEN NewStar(I);
    END;
  UNTIL Keypressed;
END;

{----------------------------------------------------------------------------}

BEGIN
 IF testCard(VGA)
  THEN
   BEGIN
    SetMode(20);
    Init;
    DoStars;
    SetMode(3);
   END
    ELSE
     writeln('You need a VGA card to run this program');
END.
