USES crt,general,driver,graph;
(***************************************************************************)
(*    Guide lines FOR a that will be executing IN the backGround using the *)
(*  BackGroundLink PROCEDURE.                                              *)
(*                                                                         *)
(*     1. the PROCEDURE must be declared FAR                               *)
(*     2. the PROCEDURE must perform a number OF quick tasks               *)
(*         AND THEN it must return controls TO the running PROGRAM         *)
(*     3. any variable whos values you want TO maintain must be declared   *)
(*         global                                                          *)
(*     4. Graphs internal buffer should NOT be used by the PROCEDURE       *)
(*     5. any variables that might be used by the running PROGRAM. Such as *)
(*        the CP pointer OR the Colors IN SetColor, etc. should be the     *)
(*        the same after the PROCEDURE is executed                         *)
(*     6. also some routines such as FillPolygon should NOT be called from *)
(*        the PROCEDURE because they use the internal buffer, AND will     *)
(*        erase any information store by any other routine running IN the  *)
(*        foreground that makes OF the buffer.                             *)
(***************************************************************************)

CONST Msg:STRING = ' ..... All activities are executing in the background .....';
PROCEDURE Init;
VAR font:pointer;
BEGIN
 randomize;

 SetViewPort(10,10,300,200);
 SetBkColor(Random(GetMaxColor+1));
 ClearViewPort;
 SetColor(GetMaxColor-GetBkColor);
 Frame(0,0,300-10,200-10);

 SetViewPort(320,90,600,300);
 SetBkColor(Random(GetMaxColor+1));
 ClearViewPort;
 SetColor(GetMaxColor-GetBkColor);
 Frame(0,0,600-320,300-90);

 SetViewPort(1,205,290,310);
 SetBkColor(Random(GetMaxColor+1));
 ClearViewPort;
 SetColor(GetMaxColor-GetBkColor);
 Frame(0,0,290-1,310-205);

 SetViewPort(7,GetMaxY-19,GetMaxX-6,GetMaxY-1);
 SetBkColor(8);
 ClearViewPort;
 SetColor(GetMaxColor-GetBkColor);
 Frame(0,0,GetMaxX-14,18);
 LoadFont('c:\pabulum\library\system16.pff', font);
 useFont(font);
 OutText(60,2,Msg);
 Freefont(font);
END;

PROCEDURE Lines; FAR;
VAR T:TRect;
BEGIN
 GetViewPort(T);
 SetViewPort(11,11,299,199);
 SetColor(Random(GetMaxColor+1));
 Line(Random(290),Random(190),random(290),random(190));
 WITH T DO
  SetViewPort(A.x,a.y,b.x,b.y);
END;
(****************************    Moving ball      *************************)
CONST X:WORD = 70;
      Y:WORD = 81;
      dx:integer = 1;
      dy:integer = 1;

PROCEDURE Ball; FAR;
VAR T:TRect;
BEGIN
 GetViewPort(T);
 SetViewPort(321,91,599,299);
 SetColor(Random(GetMaxColor+1));
 FillCircle(x,y,10);
 inc(x,dx*5);
 inc(y,dy*5);
 IF (y>299-91-10) OR (y<10) THEN dy:=-dy;
 IF (x>599-321-10) OR (x<10) THEN dx:=-dx;
 WITH T DO
  SetViewPort(A.x,a.y,b.x,b.y);
END;

PROCEDURE Circles; FAR;
VAR T:TRect;
BEGIN
 GetViewPort(T);
 SetViewPort(2,206,289,309);

 SetColor(Random(GetMaxColor+1));
 Circle(Random(289-2),Random(309-206),Random(20));

 WITH T DO
  SetViewPort(A.x,a.y,b.x,b.y);
END;
BEGIN
 SetMode(16);
 Fillpage(15);
 init;
 BackGroundLink(@Lines);
 BackGroundLink(@ball);
 BackGroundLink(@Circles);
 SetColor(7); (* display text MSg IN color 7 *)
 REPEAT
  (* PROCEDURE executing IN the back ground DO NOT restore the Original *)
  (* color that was SET by the running PROGRAM (color 7). So the color  *)
  (* OF any part OF the text being displayed can be modefied.           *)
  outtext(60,2,Msg);
 UNTIL keypressed;
 BackGroundRemove(@Circles);
 BackGroundRemove(@ball);
 BackGroundRemove(@Lines);
 ClearKeyBoard;
 SetMode(3);
END.