(*********************************************)
(*                                           *)
(*  Talks to your modem. Called by TERM.PAS  *)
(*                                           *)
(*  This program is donated to the Public    *)
(*  Domain by MarshallSoft Computing, Inc.   *)
(*  It is provided as an example of the use  *)
(*  of the Personal Communications Library.  *)
(*                                           *)
(*********************************************)

unit Modem_IO;

interface

type
  String80 = String[80];

procedure SendTo( Port:Integer; TheString:String80);
function  WaitFor(Port:Integer; TheString:String80; WaitTics:Integer):Boolean;
function  DialPhone(Port:Integer; TheString:String80): Boolean;

implementation

uses PCL4P;

function BreakTest : Boolean;
begin
  if SioBrkKey then
    begin
      WriteLn('User BREAK');
      BreakTest := TRUE
    end
  else BreakTest := FALSE;
end;


procedure SendTo( Port: Integer; TheString:String80);
const CR = 13;
var
   rc : Integer;
   i  : Integer;
   c  : Char;
begin
   rc := SioRxFlush(Port);
   rc := SioDelay(4);
   for i := 1 to Length(TheString) do
      begin
         c := UpCase(TheString[i]);
         case c of
            '!' : c := chr(CR);
            '~' : begin
                     (* delay 1/2 second *)
                     rc := SioDelay(9);
                     c := ' '
                  end;
             ' ': rc := SioDelay(3);
         end;
         (* transmit as 7 bit char *)
         rc := SioPutc(Port, chr(ord(c) and $7f));
         (* wait 3/18th of a second *)
         rc := SioDelay(3);
         (* wait 1 second for echo *)
         rc := SioGetc(Port,18);
         if rc > 0 then Write(chr(rc));
      end (* for *)
end; (* SendTo *)

function WaitFor(Port:Integer; TheString:String80; WaitTics:Integer): Boolean;
label WaitForExit;
const
  CR = 13;
  LF = 10;
var
  Code : Integer;
  c : Char;
  i : Integer;
  rc: Integer;

function GetModemChar(Port:Integer; Tics:Integer): Integer;
var Code : integer;
begin
  repeat
    if BreakTest then exit;
    (* get next incoming character *)
    Code := SioGetc(Port,Tics);
  until (Code>=0) and (Code <> CR) and (Code <> LF);
  GetModemChar := Code;
end; (* GetModemChar *)

begin (* WaitFor *)
  Write( chr(CR) );
  Write( chr(LF) );
  for i:= 1 to Length(TheString) do
    begin
       (* control-BREAK ? *)
       if BreakTest then exit;
       (* c is expected character *)
       c := UpCase( TheString[i] );
       (* wait for next character *)
       if i = 1 then Code := GetModemChar(Port,WaitTics)
       else Code := GetModemChar(Port,18);
       (* echo character from modem *)
       Write(chr(Code));
       (* character must match *)
       if (Code=-1) or (chr(Code) <> c) then
          begin
             writeln('Expecting ',c,' not ',chr(Code),'[',Code,']');
             WaitFor := FALSE;
             goto WaitForExit;
          end
    end; (* for i *)
  (* all characters match *)
  WaitFor := TRUE;
WaitForExit: end; (* WaitFor *)

function DialPhone(Port:Integer; TheString:String80): Boolean;
const CR = 13;
var
  Code : Integer;
  Temp : String80;
begin
  Write('...DIALING ');
  WriteLn(TheString);
  Temp := '!!ATDT' + TheString + '!';
  SendTo(Port,Temp);
  (* wait up to 60 seconds for CONNECT *)
  if WaitFor(Port,'CONNECT',60*18) then
    begin
      Code := SioPutc(Port, chr(CR));
      DialPhone := TRUE;
    end;
  DialPhone := FALSE;
end; (* DialPhone *)
end.