  PROGRAM DataCreation;              { Choose any suitable name. }

  {~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}
  { Appropriate comment and explanation, contained within braces. }
  { At any point in the program comments can be inserted to help  }
  { the user understand the program, provided they are in braces. }
  {                                                               }
  { Words fully in capitals are Reserved words in Turbo Pascal.   }
  {                                                               }
  { STRUCT.PAS  ->  .EXE   R Shaw     7.5.93                      }
  {_______________________________________________________________}

  USES Crt;                  { A list of all units employed by the        }
                             { program, in this case just the Crt unit.   }

  LABEL Continue, Finish;    { Only used occasionally, as GOTO statements }
                             { are not needed in a structured language.   }
                             { Not used in this demonstration program.    }

  CONST                                             { Global constants.   }
     Max = 10;                                      { A numeric constant. }
     Str = 'Press any key to continue: ';           { A string constant.  }

  TYPE                                              { Global types.       }
     LinePointer   = ^LineOfNumbers;                { A pointer type, not }
                                                    { used in this program}
     LineOfNumbers = String[79];               { A string of fixed length.}

  VAR                                              { Global variables.    }
     Line : LineOfNumbers;                         { Specific instances of}
     Ptr  : Array[1..Max] of LinePointer;          { user-defined types,  }
                                                   { but Ptr not actually }
                                                   { used in this program.}
     j    : Integer;                               { Instance of Integer  }
                                                   { type.                }

  PROCEDURE CreateData;                        { Choose a meaningful name. }

       { Local Labels, Constants and Types may be declared here. }

  VAR                                     { Local variables, as necessary. }
     i  : Integer;                        { Used as counter in a FOR loop. }
     n  : Array[0..79] of char;           { An array of 80 character types.}

  BEGIN
     Line := '';                          { Initialise Line to be empty.   }
     FOR i := 0 TO 79 DO                  { A FOR loop repeated 80 times.  }
        BEGIN
           n[i] := Chr(Random(9) + 48);   { Use of Chr & Random functions, }
                                          { to generate ASCII characters   }
                                          { from 48 (=0) to 57 (=9).       }
           Line := Line + n[i];           { Add all the characters to form }
                                          { line of 80 characters.         }
        END;
  END;

  FUNCTION ReturnZero : Integer;        { A trivial example of a function.} 
  BEGIN 
     ReturnZero := 0; 
  END; 


  { Main part of program. } 

  BEGIN 
     ClrScr;              { Procedure from Crt unit to clear the screen.  } 
     FOR j := 0 TO Max DO   
       BEGIN 
         CreateData;                   { Call to procedure declared above.} 
         Writeln(Line);                { Call to system procedure Writeln.} 
       END;
    Writeln;
    Writeln('Function return value = ',ReturnZero);
    Writeln;
    Write(Str);               { Call to procedure Write for constant Str  }
    REPEAT UNTIL KeyPressed;  { Function KeyPressed returns True if a key }
                              { has been pressed, ensuring that nothing   }
                              { happens until a key is pressed.           }
  END.


