{************************************************}
{   GrDriver.pas                                 }
{   Graph Vision unit                            }
{   Vesa16.bgi support                           }
{   Sergey E. Levov, Moscow,1992-1993            }
{************************************************}

unit GrDriver;

{$X+,I-,S-,P-,D+}

interface
uses Graph;

type
   BiosFontParams = record
      Width : word;
      Height : word;
      BytesPerChar : word;
      case TwoPart : boolean of
      false : (ImageTable : pointer);
      true :  (Base,Top : pointer);
   end;

{$IFDEF DPMI}
  TRealRegs = record
    RealEDI: Longint;
    RealESI: Longint;
    RealEBP: Longint;
    Reserved: Longint;
    RealEBX: Longint;
    RealEDX: Longint;
    RealECX: Longint;
    RealEAX: Longint;
    RealFlags: Word;
    RealES: Word;
    RealDS: Word;
    RealFS: Word;
    RealGS: Word;
    RealIP: Word;
    RealCS: Word;
    RealSP: Word;
    RealSS: Word;
  end;

{$ENDIF}

const

   Planes = 4;
   BitPerPlane = 1;
   DefaultSysFont : integer = 2;   {default font for EGA/VGA}
   FontNames : Array[1..3] of String = ('8x8 BIOS font',
                                        '8x14 BIOS font',
                                        '8x16 BIOS font');
   Mode : integer = 0;              {write mode for text drawing}
   FillBackground : boolean = true; {draw background pixels if true}

var
   ViewPort : ViewPortType;      {used internally with character generator}
   TextSettings : TextSettingsType;
   FillSettings : FillSettingsType;
   BytesPerLine : integer;

procedure GraphDriver;
function ValidMode(Driver,Mode : integer) : boolean;

{ procedures for support ROM-based fonts }

function GetMaxFont : integer;
procedure GetFontParams(Font : integer; var Params : BiosFontParams);
function GetFontName(Font : integer) : String;

{ character generator routines }

procedure SetController(Mode : word);
procedure ResetController;
procedure OutCharPrim(X,Y : Integer; Width,Height : word; Image : pointer);

procedure SetWriteMode(WriteMode : integer);

implementation
{$IFDEF DPMI}
uses Objects,WinApi;
{$ELSE}
uses Objects;
{$ENDIF}

type
  TVesaInfo = record
    VESASignature: array[0..3] of Byte;  {'VESA'}
    VESAVersion  : Word;                 {version number}
    OEMStringPtr : Pointer;              {ptr to manufacturer name}
    Capabilities : array[0..3] of Byte;  {capabilities (not used)}
    VideoModePtr : Pointer;              {ptr to list of supported videomodes}
    TotalMemory  : word;                 {number of 64k videomemory blocks}
    Filler       : array[1..238] of byte;
  end;

 TVesaMode=Record
   Attr     : Word;         { Mode Attributes                   }
   WinA     : Byte;         { Window A attributes               }
   WinB     : Byte;         { Window B attributes               }
   Gran     : Word;         { Window granularity in K bytes     }
   WinSiz   : Word;         { Size of window in K bytes         }
   SegA     : Word;         { Segment address of window A       }
   SegB     : Word;         { Segment address of window B       }
   WinFunc  : Procedure;    { Windows positioning function      }
   Bytes    : Word;         { Number of bytes per line          }
   Width    : Word;         { Number of horizontal pixels       }
   Height   : Word;         { Number of vertical pixels         }
   CharW    : Byte;         { Width of character cell           }
   CharH    : Byte;         { Height of character cell          }
   Planes   : Byte;         { Number of memory planes           }
   Bits     : Byte;         { Number of bits per pixel          }
   nBanks   : Byte;         { Number of banks        (not used) }
   Model    : Byte;         { Memory model type                 }
   Banks    : Byte;         { Size of bank           (not used) }
   Pages    : Byte;         { Number of image pages             }
   Reserved : Byte; { The following are for 15,16,24,32 bit colour modes }
   RedMaskSize   : Byte;    { Size of Red mask in bits          }
   RedFieldPos   : Byte;    { Bit position of LSB of Red mask   }
   GreenMaskSize : Byte;    { Size of Green mask in bits        }
   GreenFieldPos : Byte;    { Bit position of LSB of Green mask }
   BlueMaskSize  : Byte;    { Size of Blue mask in bits         }
   BlueFieldPos  : Byte;    { Bit position of LSB of Blue mask  }
   RsvdMaskSize  : Byte;    { Size of Reserved mask in bits     }
   RsvdFieldPos  : Byte;    { Bit pos. of LSB of Reserved mask  }
   DirColModeInf : Byte;    { Direct Colour mode attributes     }
   Filler   : Array[0..215] Of Byte; { Not used - filler        }
 End;

const
  VESA16Modes: array[0..2] of Word =
    ($0102, $0104, $0106);

   Font8x8 = 1;
   Font8x14 = 2;
   Font8x16 = 3;

var
   VesaMode : TVesaMode;
   VesaInfo : TVesaInfo;

procedure GraphDriver; external;

{$L Vesa16.obj}

procedure SetBank(NewBank : word); assembler;
asm
   mov   ax, NewBank
   mov   cx, 64
   mul   cx
   mov   cx,VesaMode.Gran
   div   cx
   mov   dx, ax
   mov   ax, $4F05
   push  ax
   push  dx
   xor   bx, bx
   int   10h
   pop   dx
   pop   ax
   inc   bx
   int   10h
end;

function GetBank : word; assembler;
asm
   mov   ax, $4F05
   mov   bx, $100
   int   10h
   mov   ax, dx
end;

{ Scan the supported mode table for the highest mode this card
  will provide
}

function GetHighestCap(Table: Pointer; Modes: Word; Size: Integer): Integer;
  near; assembler;
asm
        XOR     AX,AX
        LES     DI, Table
@@1:
        MOV     SI, Modes
        ADD     SI, Size
        ADD     SI, Size
        MOV     BX, ES:[DI]
        CMP     BX, 0FFFFH
        JE      @@4
        INC     DI
        INC     DI
        MOV     CX,Size
@@2:
        CMP     BX,[SI]
        JZ      @@3
        DEC     SI
        DEC     SI
        LOOP    @@2
@@3:
        CMP     AX,CX
        JA      @@1
        MOV     AX,CX
        JMP     @@1
@@4:
end;

{$IFDEF DPMI}
function DetectVesa16: Integer; far; assembler;
var
  Segment, Selector, VesaCap: Word;
asm
{$IFOPT G+}
        PUSH    0000H
        PUSH    0100H
{$ELSE}
        XOR     AX,AX
        PUSH    AX
        INC     AH
        PUSH    AX
{$ENDIF}
        CALL    GlobalDosAlloc
        MOV     Segment,DX
        MOV     Selector,AX
        MOV     DI,OFFSET RealModeRegs
        MOV     WORD PTR [DI].TRealRegs.RealSP, 0
        MOV     WORD PTR [DI].TRealRegs.RealSS, 0
        MOV     WORD PTR [DI].TRealRegs.RealEAX, 4F00H
        MOV     WORD PTR [DI].TRealRegs.RealES, DX
        MOV     WORD PTR [DI].TRealRegs.RealEDI, 0
        MOV     AX,DS
        MOV     ES,AX
        MOV     AX,0300H
        MOV     BX,0010H
        XOR     CX,CX
        INT     31H
        MOV     DI,OFFSET RealModeRegs
        MOV     AX,grError
        PUSH    AX
        CMP     WORD PTR [DI].TRealRegs.RealEAX,004FH
        JNZ     @@Exit
        POP     AX
        MOV     ES,Selector
        XOR     DI,DI
        CMP     ES:[DI].TVesaInfo.VESASignature.Word[0], 'EV'
        JNZ     @@Exit
        CMP     ES:[DI].TVesaInfo.VESASignature.Word[2], 'AS'
        JNZ     @@Exit
        MOV     AX,0000
        MOV     CX,1
        INT     31H
        MOV     VesaCap,AX
        MOV     DX,ES:[DI].TVesaInfo.VideoModePtr.Word[2]
        MOV     CX,4
        XOR     AX,AX
@@Convert:
        SHL     DX,1
        RCL     AX,1
        LOOP    @@Convert
        ADD     DX,ES:[DI].TVesaInfo.VideoModePtr.Word[0]
        ADC     AX,0
        MOV     CX,AX
        MOV     BX,VesaCap
        MOV     AX,0007H
        INT     31H
        INC     AX
        XOR     CX,CX
        MOV     DX,0FFFFH
        INT     31H
        MOV     ES,BX
        PUSH    ES
        PUSH    DI
{$IFOPT G+}
        PUSH    OFFSET Vesa16Modes
        PUSH    0003H
{$ELSE}
        MOV     SI, OFFSET Vesa16Modes
        PUSH    SI
        MOV     AX, 5
        PUSH    AX
{$ENDIF}
        CALL    GetHighestCap
        PUSH    AX
        MOV     BX,VesaCap
        MOV     AX,0001H
        INT     31H
{                                      }
        MOV     DI,OFFSET RealModeRegs
        mov     dx, Segment
        pop     ax
        push    ax
        mov     si,ax
        shl     si,1
        mov     cx, Vesa16Modes.word[si]
        MOV     WORD PTR [DI].TRealRegs.RealSP, 0
        MOV     WORD PTR [DI].TRealRegs.RealSS, 0
        MOV     WORD PTR [DI].TRealRegs.RealEAX, 4F01H
        mov     word ptr [di].TrealRegs.RealECX, cx
        MOV     WORD PTR [DI].TRealRegs.RealES, DX
        MOV     WORD PTR [DI].TRealRegs.RealEDI, 0
        MOV     AX,DS
        MOV     ES,AX
        MOV     AX,0300H
        MOV     BX,0010H
        XOR     CX,CX
        INT     31H
        mov     cx, $100
        lea     di, VesaMode
        push    ds
        pop     es
        mov     dx, ds
        mov     ds, Selector
        xor     si,si
        cld
        rep     movsb
        mov     ds, dx
{                                      }
@@Exit:
        PUSH    Selector
        CALL    GlobalDosFree
        POP     AX
end;
{$ELSE}
function DetectVesa16: Integer; far; assembler;
asm
        LEA     di,VesaInfo
        mov     ax, ds
        mov     es, ax
        MOV     AX,4F00H
        INT     10H
        CMP     AX,004FH
        MOV     AX,grError
        JNZ     @@Exit
        CMP     ES:[DI].TVesaInfo.VESASignature.Word[0], 'EV'
        JNZ     @@Exit
        CMP     ES:[DI].TVesaInfo.VESASignature.Word[2], 'AS'
        JNZ     @@Exit
        LES     DI,ES:[DI].TVesaInfo.VideoModePtr
        PUSH    ES
        PUSH    DI
        MOV     AX, OFFSET Vesa16Modes
        PUSH    AX
        MOV     AX,3
        PUSH    AX
        CALL    GetHighestCap
        dec     ax        {}
        push    ax
        mov     si,ax
        shl     si,1
        mov     cx, Vesa16Modes.word[si]
        lea     di, VesaMode
        mov     ax, ds
        mov     es, ax
        mov     ax, $4F01
        Int     10h
        pop     ax
@@Exit:
end;
{$ENDIF}

function ValidMode(Driver,Mode : integer) : boolean;
begin
   ValidMode := true;
end;

function GetMaxFont : integer;
begin
   GetMaxFont := 3;
end;

procedure GetFontParams(Font : integer; var Params : BiosFontParams);
var
   H : word;
   B : byte absolute $40:$85;
   T : byte;
   P : Pointer;
   R : PByteArray absolute P;

{$IFDEF DPMI}
   CallBack : TRealRegs;
{$ENDIF}

function GetBytePerChar : byte; assembler;
asm
	MOV	ES,Seg0040
	MOV	AL,ES:B
end;

begin
{$IFDEF DPMI}
   FillChar(CallBack,SizeOf(CallBack),#0);
{$ENDIF}
   if Font > GetMaxFont then
   with Params do begin
      ImageTable := nil;
      Width := 0;
      Height := 0;
      BytesPerChar := 0;
   end else
   begin
     case Font of
        Font8x8 : T := $23;
        Font8x14 : T := $22;
        Font8x16 : T := $24;
     end;
     asm
        push    bp
        push    ds
        mov     ah,$11
        mov     bl,2
        mov     al,T
        int     $10
        pop     ds
        pop     bp
     end;
     Params.BytesPerChar := GetBytePerChar;
     Params.Width := 8;
     case Font of
        Font8x8 : T := 3;
        Font8x14 : T := 2;
        Font8x16 : T := 6;
     end;
     asm
{$IFNDEF DPMI}
        mov     ax,$1130
        mov     bh,T
        push    bp
        int     $10
        mov     ax,bp
        pop     bp
        mov     H,cx
        mov     P.word[0],ax
        mov     P.word[2],es
{$ELSE}
        mov     CallBack.RealEAX.word[0],$1130
        mov     bh,T
        mov     CallBack.RealEBX.word[0],bx
        lea     di,CallBack
        push    es
        push    ss
        pop     es
        mov     ax,$300;
        mov     bx,$10
        xor     cx,cx
        int     $31
        pop     es
        mov     ax,CallBack.RealECX.word[0]
        mov     H,ax
        mov     bx,CallBack.RealES
        mov     ax,0002
        int     $31
        mov     P.word[2],ax
        mov     ax,CallBack.RealEBP.word[0]
        mov     P.word[0],ax
{$ENDIF}
      end;
     Params.Height := H;
     if Font <> Font8x8 then begin
        Params.TwoPart := false;
        Params.ImageTable := P
     end else begin
        Params.TwoPart := true;
        Params.Base := P;
        inc(T);
        asm
{$IFNDEF DPMI}
           mov     ax,$1130
           mov     bh,T
           push    bp
           int     $10
           mov     ax,bp
           pop     bp
           mov     P.word[0],ax
           mov     P.word[2],es
{$ELSE}
           mov     CallBack.RealEAX.word[0],$1130
           mov     bh,T
           mov     CallBack.RealEBX.word[0],bx
           lea     di,CallBack
           push    es
           push    ss
           pop     es
           mov     ax,$300;
           mov     bx,$10
           xor     cx,cx
           int     $31
           pop     es
           mov     bx,CallBack.RealES
           mov     ax,0002
           int     $31
           mov     P.word[2],ax
           mov     ax,CallBack.RealEBP.word[0]
           mov     P.word[0],ax
{$ENDIF}
        end;
        Params.Top := P;
     end;
   end;
end;

function GetFontName(Font : integer) : String;
begin
   GetFontName := FontNames[Font];
end;

procedure SetController(Mode : word); assembler;
asm
   mov  dx,$3CE
   mov  ax,$0A05
   out  dx,ax
   mov  ah,byte ptr Mode
   mov  al,3
   mov  cl,al
   shl  ah,cl
   out  dx,ax
   mov  ax,7
   out  dx,ax
end;


procedure ResetController; assembler;
asm
   mov  dx,$3CE
   mov  ax,$FF08
   out  dx,ax
   mov  ax,5
   out  dx,ax
   mov  ax,3
   out  dx,ax
   mov  ax,$0F07
   out  dx,ax
end;

procedure OutCharPrim(X,Y : Integer; Width,Height : word; Image : pointer);
var
   Work : array[0..255] of byte;
   Mask : array[0..255] of byte;
   ImagePtr : PByteArray absolute Image;
   i,j,l,First,Last,Count,ImageWidth : integer;
   Shift,Shift1,Extra : integer;
   StartByte,EndByte,ClipByte : integer;
   VideoPtr : PByteArray;
   Fore : WordRec;
   R : WordRec;
   Mask1,ExtraMask : byte;
   OldBank,CurBank : word;
begin
   if ((X + Width) > ViewPort.X1) and (X <= ViewPort.X2) then begin
      word(Fore) := GetColor;
      asm
         mov       ax,Width
         mov       cx,ax
         shr       ax,1
         shr       ax,1
         shr       ax,1
         mov       dx,ax
         and       cx,7
         or        cx,cx
         jz        @@1
         mov       ax,$FF00
         shr       ax,cl
         mov       byte ptr ExtraMask,al
         inc       dx
   @@1:  mov       Count,dx
         mov       ImageWidth,dx
         mov       Extra,cx
      end;
      if X >= 0 then Shift := X mod 8
      else Shift := 8-Abs(X) mod 8;
      asm
         lea      di,Mask
         push     ss
         pop      es
         mov      cx,Count
         cld
         xor      al,al
         not      al
         cld
         push     di
         rep stosb
         pop      di
         mov      ax,Shift
         or       ax,ax
         jnz      @@3
         mov      cx,Extra
         or       cx,cx
         jz       @@2
         dec      di
         mov      dl,byte ptr ExtraMask
         mov      es:[di],dl
   @@2:  jmp      @@7
   @@3:  mov      cx,ax
         xor      ax,ax
         not      ah
         shr      ax,cl
         mov      es:[di],ah
         mov      dx,Count
         mov      bx,dx
         add      bx,di
         mov      es:[bx],al
         inc      dx
         mov      Count,dx
         mov      cx,Extra
         or       cx,cx
         jz       @@7
         mov      ax,cx
         add      ax,dx
         mov      cl,3
         shr      ax,cl
         or       ax,ax
         jz       @@4
         mov      ah,byte ptr ExtraMask
         xor      al,al
         jmp      @@5
   @@4:  mov      al,byte ptr ExtraMask
         xor      ah,ah
         not      ah
         dec      dx
   @@5:  mov      cx,Shift
         shr      ax,cl
         add      di,dx
         dec      di
         mov      es:[di],al
         mov      Count,dx
   @@7:
      end;
      StartByte := X div 8;
      if X < 0 then if Shift <> 0 then dec(StartByte);
      First := 0;
      ClipByte := ViewPort.X1 div 8;
      if ClipByte >= StartByte then begin
         First := ClipByte - StartByte;
         StartByte := ClipByte;
         Shift1 := ViewPort.X1 mod 8;
         if Shift1 <> 0 then Mask[First] := Mask[First] and ($FF shr Shift1);
      end;
      Last := Count-1;
      ClipByte := ViewPort.X2 div 8;
      EndByte := StartByte + Last-First;
      if ClipByte <= EndByte then begin
         EndByte := ClipByte;
         Last := First + (EndByte - StartByte);
         Shift1 := ViewPort.X2 mod 8;
         inc(Shift1);
         word(R) := $FF00 shr Shift1;
         Mask[Last] := Mask[Last] and R.Lo;
      end;
      OldBank := GetBank;
      CurBank := OldBank;
      for i := 0 to Height-1 do begin
         if ((i+Y) >= ViewPort.Y1) and ((i+Y) <= ViewPort.Y2) then begin
            Mask1 := 0;
            for j := 0 to ImageWidth-1 do begin
               if Shift <> 0 then
               asm
                  xor   ax, ax
                  mov   bx, ax
                  mov   bx, j
                  les   di, ImagePtr
                  mov   ah, es:[di+bx]
                  mov   cx, Shift
                  shr   ax, cl
                  or    ah, Mask1
                  mov   si, bx
                  mov   byte ptr Work[si],ah
                  mov   Mask1, al
               end else Work[j] := ImagePtr^[j];
            end;
            if Shift <> 0 then Work[ImageWidth] := Mask1;
            asm
              mov   ax, SegA000
              mov   VideoPtr.word[2], ax
              mov   ax, BytesPerLine
              mov   di, Y
              add   di, i
              mul   di
              add   ax, StartByte
              adc   dx,0
              mov   VideoPtr.word[0],ax
              cmp   dx, CurBank
              je    @@1
              push  dx
              mov   CurBank, dx
              call  SetBank
       @@1:
            end;
            asm
               mov   di, First
               les   si, VideoPtr
               mov   cl, FillBackground
               mov   dx, $3CE
               mov   al, 8
        @@1:   mov   ah, Work.byte[di]
               and   ah, Mask.byte[di]
               out   dx, ax
               mov   bl, es:[si]
               and   bl, Fore.Lo
               mov   es:[si], bl
               or    cl, cl
               jz    @@2
               xor   ah, Mask.byte[di]
               out   dx, ax
               mov   bl, es:[si]
               and   bl, FillSettings.Color.byte
               mov   es:[si], bl
        @@2:   inc   di
               inc   si
               cmp   di, Last
               jle   @@1
            end;
         end;
         inc(LongInt(ImagePtr),ImageWidth);
      end;
      if CurBank <> OldBank then SetBank(OldBank);
   end;
end;

procedure SetWriteMode(WriteMode : integer);
begin
   Mode := WriteMode;
   Graph.SetWriteMode(WriteMode);
end;

begin
   InstallUserDriver('VESA16',@DetectVesa16);
end.
