UNIT GloblCTV;
  {Global constants, types, and variables for Fumiko}


INTERFACE


  CONST

    board_size = 19;

    board_size_squared = board_size * board_size;

    maximum_search_depth = 4;

    search_breadth = 3;

    max_groups = 180;


  TYPE

    direction_type = (north, south, east, west, nw, sw, se, ne);

    color_type = (black_stone, white_stone, empty, off_board);  {'black' and 'white' are used by the CRT unit}

    location_type = record
                      x, y: byte
                    end;

    location_list = ^location_list_node;

    location_list_node = record
                           value: integer;
                           location: location_type;
                           next: location_list
                         end;

    boolean_board = array [1..board_size, 1..board_size] of boolean;

    integer_board = array [1..board_size, 1..board_size] of integer;

    point_interpretation = record
                             too_distant, member, adjacent, connected: boolean;
                             distance: byte
                           end;

    board_interpretation = array [1..board_size, 1..board_size] of point_interpretation;

    group_pointer = ^group_type;

    group_type = record
                   size, liberties, aliveness, room: byte;
                   last_update: integer;
                   owner: color_type;
                   interpretation: board_interpretation;
                   to_kill, to_save: location_type
                 end;

    board_space = record
                    color: color_type;
                    group: byte
                  end;

    board_type = record
                   data: array [1..board_size, 1..board_size] of board_space;  {0, 0 is an off_board space}
                   ko: location_type;
                   passes: byte;
                   turn: integer;
                   groups: array [1..max_groups] of group_pointer
                 end;

    board_file_type = file of board_type;

    group_file_type = file of group_type;


  VAR
    physical_board: board_type;
    neighbors: array [0..board_size, 0..board_size, direction_type] of location_type;
    false_board: boolean_board;
    board_index_line: string;
    board_number: longint;
    my_color: color_type;
    zero_board, terrain: integer_board;
    total_time, time_left: word;
    last_board_filename, drive_name, trickle_filename: string;
    next_player: color_type;


IMPLEMENTATION

END.  {GloblCTV}

