UNIT Butler;
  {Setup and cleanup procedures for Fumiko}


INTERFACE


  USES
    Dos, Crt, GloblCTV, Arcana;


  PROCEDURE Initialize;
    {Initializes all of the variables at the beginning of a run}


IMPLEMENTATION


  USES
    BrdHndlr;


  PROCEDURE Find_Neighbor_Coordinates (var x, y: byte; var direction: direction_type; var neighbor: location_type);
    {Finds the coordinates of a point's neighbor in the specified direction,}
    {and returns (0, 0) if the result is off the board.  LOCAL}
    Begin  {Find Neighbor Coordinates}
      neighbor.x := x;
      neighbor.y := y;
      Case direction of
        north: neighbor.y := y + 1;
        south: neighbor.y := y - 1;
        east: neighbor.x := x + 1;
        west: neighbor.x := x - 1;
        nw: Begin
              neighbor.x := x - 1;
              neighbor.y := y + 1
            End;
        sw: Begin
              neighbor.x := x - 1;
              neighbor.y := y - 1
            End;
        se: Begin
              neighbor.x := x + 1;
              neighbor.y := y - 1
            End;
        ne: Begin
              neighbor.x := x + 1;
              neighbor.y := y + 1
            End
      End;
      If not on_board (neighbor.x, neighbor.y)
        Then Begin
               neighbor.x := 0;
               neighbor.y := 0
             End
    End;  {Find Neighbor Coordinates}


  PROCEDURE Build_Neighbor_Array;
    {Builds the neighboring-coordinates array.  LOCAL}
    Var
      x, y: byte;
      direction: direction_type;
    Begin  {Build Neighbor Array}
      For x := 1 to board_size do
        For y := 1 to board_size do
          For direction := north to ne do
            Begin
              Find_Neighbor_Coordinates (x, y, direction, neighbors [x, y, direction]);
              If not on_board (neighbors [x, y, direction].x, neighbors [x, y, direction].y)
                Then Begin
                       neighbors [x, y, direction].x := 0;
                       neighbors [x, y, direction].y := 0
                     End
            End;
      For direction := north to ne do
        Begin
          neighbors [0, 0, direction].x := 0;
          neighbors [0, 0, direction].y := 0
        End
    End;  {Build Neighbor Array}


  PROCEDURE Clear_Off (var board: board_type);
    {Sets all board points to empty, group pointers to nil.  LOCAL}
    Var
      x, y: byte;
    Begin  {Clear Off}
      With board do
        Begin
          For x := 1 to board_size do
            For y := 1 to board_size do
              With data [x, y] do
                Begin
                  color := empty;
                  group := 0;
                End;
          For x := 1 to max_groups do
            Begin
              New (groups [x]);
              groups [x]^.size := 0;
              groups [x]^.to_kill.x := 0;
              groups [x]^.to_kill.y := 0;
              groups [x]^.to_save.x := 0;
              groups [x]^.to_save.y := 0
            End;
          ko.x := 0;
          ko.y := 0;
          passes := 0;
          turn := 1
        End
    End;  {Clear Off}


  PROCEDURE Set_Terrain (var terrain: integer_board);
    Var
      x, y: byte;
    Begin  {Set Terrain}
      terrain := zero_board;
      For x := 1 to board_size do
        For y := 1 to board_size do
          Begin
            Case line (x) of
              2, 8..board_size: Inc (terrain [x, y], 1000);
              3, 4: Inc (terrain [x, y], 5000);
              5..7: Inc (terrain [x, y], 5000 - (1000 * (line (x) - 4)))
            End;
            Case line (y) of
              2, 8..board_size: Inc (terrain [x, y], 1000);
              3, 4: Inc (terrain [x, y], 5000);
              5..7: Inc (terrain [x, y], 5000 - (1000 * (line (y) - 4)))
            End;
          End
    End;  {Set Terrain}


  PROCEDURE Load_Trickle_File (var board: board_type);
    {Tournament kludge--loads and plays saved moves}
    Var
      trickle: text;
      x, y: byte;
      move_number: integer;
      player: color_type;
    Begin  {Load Trickle File}
      Assign (trickle, trickle_filename);
      Reset (trickle);
      While not eof (trickle) do
        Begin
          ReadLn (trickle, move_number);
          ReadLn (trickle, x);
          ReadLn (trickle, y);
          If odd (move_number)
            Then player := black_stone
            Else player := white_stone;
          Play_At (x, y, player, board, maximum_search_depth)
        End;
      Close (trickle)
    End;  {Load Trickle File}


  PROCEDURE Initialize;
    {Initializes all of the variables at the beginning of a run}
    Var
      x, y: byte;
      answer: string;
      trickle: text;
    Begin  {Initialize}
      ClrScr;
      WriteLn ('FUMIKO -- An artificially intelligent Go program');
      WriteLn;
      WriteLn;
      WriteLn ('"A path is formed by walking on it."');
      WriteLn ('                          -Chuang Tsu');
      WriteLn;
      WriteLn;
      Write ('How many minutes will each player get? ');
      ReadLn (total_time);
      total_time := total_time * 60;
      time_left := total_time;
      Build_Neighbor_Array;
      Clear_Off (physical_board);
      board_index_line := '   ';
      For x := 1 to board_size do
        If x < 9
          Then board_index_line := board_index_line + Chr (x + Ord ('A') - 1) + ' '
          Else board_index_line := board_index_line + Chr (x + Ord ('A')) + ' ';
      For x := 1 to board_size do
        For y := 1 to board_size do
          Begin
            false_board [x, y] := false;
            zero_board [x, y] := 0
          End;
      Set_Terrain (terrain);
      Write ('Enter name of board drive (for example, "e:"): ');
      ReadLn (drive_name);
      last_board_filename := drive_name + 'PHYSICAL';
      trickle_filename := drive_name + 'TRICKLE.FUM';
      board_number := 1;
      WriteLN ('New game, saved board, or trickle (n/s/t)? ');
      ReadLn (answer);
      Case upcase (answer [1]) of
        'N': Begin
               Assign (trickle, trickle_filename);
               Rewrite (trickle);
               Close (trickle)
             End;
        'S': Load_Board (physical_board, last_board_filename);
        'T': Load_Trickle_File (physical_board);
      End;
      Write ('What color should I play (b/w)? ');
      ReadLn (answer);
      If upcase (answer [1]) = 'W'
        Then my_color := white_stone
        Else my_color := black_stone;
      If not odd (physical_board.turn)
        Then next_player := white_stone
        Else next_player := black_stone;
      Draw_Board (physical_board)
    End;  {Initialize}


END.  {Butler}

