UNIT Arcana;
  {Silly but necessary routines for Fumiko}


INTERFACE


  USES
    Dos, GloblCTV;


  CONST
    point_interpretation_size = sizeof (point_interpretation);


  FUNCTION Plenty_Of_Time (var turn: integer): boolean;
    {Returns true if the game is running on or ahead of schedule}


  FUNCTION On_Board (var x, y: byte): boolean;
    {Returns true if the coordinates name a point on the board}


  FUNCTION Screen_Char (var point: color_type): char;
    {Returns the character to be printed in the board diagram for the point}


  FUNCTION Opposite (var point: color_type): color_type;
    {Black_stone and white_stone are opposites}


  FUNCTION On_Edge (var x: byte): boolean;
    {Returns true if the coordinate is at the edge of the board}


  FUNCTION Line (var x: byte): byte;
    {Returns the distance to the nearest edge}


  FUNCTION Equal (var a, b; size: word): boolean;
    {Compares two records.  From TP60 Programmer's Guide, p. 107}


  PROCEDURE Compress (var removed: byte; var board: board_type);
    {Puts the last item in the list into the hole}


  PROCEDURE Find_Member (var group: group_type; var member: location_type);
    {Sets member to the coordinates of a member of the group}


  FUNCTION Highest_Rated (var rating: integer_board): location_list;
    {Generates a list of the search_breadth highest rated locations, with}
    {the highest-rated ones at the bottom}


  PROCEDURE Clean_Out_Location_List (var list: location_list);
    {Deallocates the list}


  FUNCTION Count_Groups (var board: board_type): byte;
    {Debugging function--count the number of groups}


IMPLEMENTATION


  TYPE
    bytes = array [0..maxint] of byte;  {Used in equal}


  FUNCTION Plenty_Of_Time (var turn: integer): boolean;
    {Returns true if the game is running on or ahead of schedule}
    Begin  {Plenty Of Time}
      plenty_of_time := (100 * (125 - (turn div 2)) div time_left) < (12500 div total_time)
    End;  {Plenty Of Time}


  FUNCTION On_Board (var x, y: byte): boolean;
    {Returns true if the coordinates name a point on the board}
    Begin  {On Board}
      on_board := (x > 0) and (x <= board_size) and (y > 0) and (y <= board_size)
    End;  {On Board}


  FUNCTION Screen_Char (var point: color_type): char;
    {Returns the character to be printed in the board diagram for the point}
    Begin  {Screen Char}
      Case point of
        black_stone: screen_char := #1;
        white_stone: screen_char := #2;
        empty: screen_char := #250;
        off_board: screen_char := '?'
      End
    End;  {Screen Char}


  FUNCTION Opposite (var point: color_type): color_type;
    {black_stone and white_stone are opposites}
    Begin  {Opposite}
      If point = black_stone
        Then opposite := white_stone
        Else opposite := black_stone
    End;  {Opposite}


  FUNCTION On_Edge (var x: byte): boolean;
    {Returns true if the coordinate is at the edge of the board}
    Begin  {On Edge}
      on_edge := (x = 1) or (x = board_size)
    End;  {On Edge}


  FUNCTION Line (var x: byte): byte;
    {Returns the distance to the nearest edge}
    Begin  {Line}
      If x > (board_size + 1 - x)
        Then line := board_size + 1 - x
        Else line := x
    End;  {Line}


  FUNCTION Equal (var a, b; size: word): boolean;
    {Compares two records.  From TP60 Programmer's Guide, p. 107}
    Var
      n: integer;
    Begin  {Equal}
      n := 0;
      While (n < size) and (bytes (a) [n] = bytes (b) [n]) do
        inc (n);
      equal := n = size
    End;  {Equal}


  PROCEDURE Compress (var removed: byte; var board: board_type);
    {Puts the last item in the list into the hole}
    Var
      last_group, x, y: byte;
      buffer: group_pointer;
    Begin  {Compress}
      last_group := removed;
      While board.groups [last_group + 1]^.size <> 0 do
        Inc (last_group);
      If last_group <> removed
        Then Begin
               For x := 1 to board_size do
                 For y := 1 to board_size do
                   With board.groups [last_group]^.interpretation [x, y] do
                     If member
                       Then board.data [x, y].group := removed;
               buffer := board.groups [removed];
               board.groups [removed] := board.groups [last_group];
               board.groups [last_group] := buffer;
               board.groups [last_group]^.size := 0
             End
        Else board.groups [removed]^.size := 0
    End;  {Compress}


  PROCEDURE Find_Member (var group: group_type; var member: location_type);
    {Sets member to the coordinates of a member of the group}
    Var
      x, y: byte;
    Begin  {Find Member}
      x := 1;
      y := 1;
      member.x := 0;
      Repeat
        If group.interpretation [x, y].member
          Then Begin
                 member.x := x;
                 member.y := y
               End;
        Inc (x);
        If x > board_size
          Then Begin
                 x := 1;
                 Inc (y)
               End
      Until member.x <> 0
    End;  {Find Member}


  PROCEDURE Swap_Values (var node_1, node_2: location_list);
    {Swaps the location and value fields of the two nodes.  LOCAL}
    Var
      location_buffer: location_type;
      value_buffer: integer;
    Begin  {Swap Values}
      location_buffer := node_1^.location;
      value_buffer := node_1^.value;
      node_1^.location := node_2^.location;
      node_1^.value := node_2^.value;
      node_2^.location := location_buffer;
      node_2^.value := value_buffer
    End;  {Swap Values}


  PROCEDURE Filter_Down (var list: location_list; var x, y: byte; var value: integer);
    {The ugly part of highest_rated.  Moves the new item along the list}
    {until it meets a higher-value item.  LOCAL}
    Var
      this, that: location_list;
      swapped: boolean;
    Begin  {Filter Down}
      New (this);
      this^.location.x := x;
      this^.location.y := y;
      this^.value := value;
      this^.next := nil;
      that := list;
      Repeat
        If this^.value > that^.value
          Then Begin
                 Swap_Values (this, that);
                 If this^.next = nil
                   Then Dispose (this);
                 this := that;
                 that := that^.next;
                 swapped := true
               End
          Else swapped := false
      Until (that = nil) or (not swapped);
      If that = list  {The new item did not make the list}
        Then Dispose (this)
    End;  {Filter Down}


  FUNCTION Highest_Rated (var rating: integer_board): location_list;
    {Generates a list of the search_breadth highest rated locations, with}
    {the highest-rated ones at the bottom}
    Var
      x, y: byte;
      best_moves, this_move, next_move: location_list;
    Begin  {Highest Rated}
      best_moves := nil;
      For x := 1 to search_breadth do
        Begin
          New (this_move);
          this_move^.value := 0;
          this_move^.next := best_moves;
          best_moves := this_move
        End;
      For x := 1 to board_size do
        For y := 1 to board_size do
          If rating [x, y] > 0
            Then Filter_Down (best_moves, x, y, rating [x, y]);
      this_move := best_moves;  {Get rid of any leftover empty moves}
      While best_moves^.value = 0 do
        best_moves := best_moves^.next;
      While this_move <> best_moves do
        Begin
          next_move := this_move^.next;
          Dispose (this_move);
          this_move := next_move
        End;
      highest_rated := best_moves
    End;  {Highest Rated}


  PROCEDURE Clean_Out_Location_List (var list: location_list);
    {Deallocates the list}
    Var
      next: location_list;
    Begin  {Clean Out Location List}
      While list <> nil do
        Begin
          next := list^.next;
          Dispose (list);
          list := next
        End
    End;  {Clean Out Location List}


  FUNCTION Count_Groups (var board: board_type): byte;
    {Debugging function--count the number of groups}
    Var
      tally: byte;
    Begin  {Count Groups}
      tally := 0;
      While board.groups [tally + 1]^.size <> 0 do
        Inc (tally);
      count_groups := tally
    End;  {Count Groups}


END.  {Arcana}

