{****************************************************************************asign


                   Copyright (c) 1993,96 by Florian Klaempfl

 ****************************************************************************}

{ Unit System fr DOS-Extender von DJ Delorie }
{$define DOS}
{ no stack check in system }
{$S-}
unit system;

  interface

    { die betriebssystemunabhangigen Deklarationen einfuegen: }

    {$I SYSTEMH.INC}

    {$I HEAPH.INC}

  implementation

    { die betriebssystemunabhngigen Implementationen einfuegen: }

    {$I SYSTEM.INC}

    type
       plongint = ^longint;

    const carryflag = 1;

    function tb : longint;
    begin
    tb := go32_info_block.linear_address_of_transfer_buffer;
    {   asm
       leal __go32_info_block,%ebx
       movl 12(%ebx),%eax
       leave
       ret
       end ['EAX','EBX'];}
    end;

    function tb_size : longint;
    begin
    tb_size := go32_info_block.size_of_transfer_buffer;
{       asm
       leal __go32_info_block,%ebx
       movl 16(%ebx),%eax
       leave
       ret
       end ['EAX','EBX'];}
    end;

    function dos_selector : word;
    begin
       dos_selector:=go32_info_block.selector_for_linear_memory;
{       asm
       leal __go32_info_block,%ebx
       movw 26(%ebx),%ax
       movw %ax,__RESULT
       end ['EAX','EBX'];}
    end;

    function get_ds : word;

      begin
         asm
            movw %ds,%ax
            movw %ax,__RESULT;
         end;
      end;


    procedure sysseg_move(sseg : word;source : longint;dseg : word;dest : longint;count : longint);

      begin
         if count=0 then
           exit;
         if (sseg<>dseg) or ((sseg=dseg) and (source>dest)) then
           asm
              pushw %es
              pushw %ds
              cld
              movl count,%ecx
              movl source,%esi
              movl dest,%edi
              movw dseg,%ax
              movw %ax,%es
              movw sseg,%ax
              movw %ax,%ds
              movl %ecx,%eax
              shrl $2,%ecx
              rep
              movsl
              movl %eax,%ecx
              andl $3,%ecx
              rep
              movsb
              popw %ds
              popw %es
           end ['ESI','EDI','ECX','EAX']
         else if (source<dest) then
           { copy backward for overlapping }
           asm
              pushw %es
              pushw %ds
              std
              movl count,%ecx
              movl source,%esi
              movl dest,%edi
              movw dseg,%ax
              movw %ax,%es
              movw sseg,%ax
              movw %ax,%ds
              addl %ecx,%esi
              addl %ecx,%edi
              movl %ecx,%eax
              andl $3,%ecx
              orl %ecx,%ecx
              jz LSEG_MOVE1
              
              { calculate esi and edi}
              decl %esi
              decl %edi
              rep
              movsb
              incl %esi
              incl %edi
           LSEG_MOVE1:
              subl $4,%esi
              subl $4,%edi
              movl %eax,%ecx
              shrl $2,%ecx
              rep
              movsl
              cld
              popw %ds
              popw %es
           end ['ESI','EDI','ECX'];
      end;


{$I sargs.inc }

     procedure syscopytodos(addr : longint; len : longint);
     begin
        if len > tb_size then runerror(200);
        sysseg_move(get_ds,addr,dos_selector,tb,len);
     end;

     procedure syscopyfromdos(addr : longint; len : longint);
     begin
        if len > tb_size then runerror(200);
        sysseg_move(dos_selector,tb,get_ds,addr,len);
     end;

    procedure sysrealintr(intnr : word;var regs : trealregs);

      begin
         regs.realsp:=0;
         regs.realss:=0;
         asm
            movw  intnr,%bx
            xorl  %ecx,%ecx
            movl  regs,%edi

            // es is always equal ds
            movw  $0x300,%ax
            int   $0x31
         end;
      end;

    procedure halt;
    var regs : trealregs;
      begin
         {regs.realeax:=$4c00;
         sysrealintr($21,regs);  }
         asm
         pushw $0
         call  ___exit
         end;
         {call ___exit frees all dpmi memory !!}
      end;

    procedure halt(errnum : byte);

    var regs : trealregs;
      begin
         do_exit;
         {regs.realeax:=$4c00+errnum;
         sysrealintr($21,regs);}
         asm
         movzbw errnum,%ax
         pushw  %ax
         call   ___exit
         {call ___exit frees all dpmi memory !!}
         end;
      end;

    function paramcount : longint;

      begin
      paramcount := argc - 1;
      {   asm
            movl _argc,%eax
            decl %eax
            leave
            ret
         end ['EAX'];}
      end;

    function paramstr(l : longint) : string;

{      function args : pointer;

        begin
           asm
              movl _args,%eax
              leave
              ret
           end ['EAX'];
        end;}

      var
         p : ^pchar;

      begin
         if (l>=0) and (l<=paramcount) then
           begin
              p:=args;
              paramstr:=strpas(p[l]);
           end
         else paramstr:='';
      end;

    procedure randomize;

      var
         hl : longint;
         regs : trealregs;

      begin
         regs.realeax:=$2c00;
         sysrealintr($21,regs);
         hl:=regs.realedx and $ffff;
         randseed:=hl*$10000+ (regs.realecx and $ffff);
      end;

{ use standard heap management }
{$I HEAP.INC}

{****************************************************************************
                    Unterprogramme zu Dateiverwaltung
 ****************************************************************************}

    procedure do_close(h : longint);

      var
         regs : trealregs;
      begin
         regs.realebx:=h;
         regs.realeax:=$3e00;
         sysrealintr($21,regs);
      end;

    procedure fileclosefunc(var t : textrec);

      begin
         do_close(t.handle);
      end;

    function open(f : pchar;flags : longint) : longint;

{      begin
         asm
            movw $0xff02,%ax
	    movl 8(%ebp),%ebx
            movl 12(%ebp),%ecx
            int $0x21
            jnc LOPEN1
            movw %ax,U_SYSTEM_INOUTRES;
            xorl %eax,%eax
         LOPEN1:
            // Returnwert ist in EAX
            leave
            ret $8
         end;
      end;                     }
      var
         regs : trealregs;
      begin
         syscopytodos(longint(f),strlen(f)+1);
         regs.realedx:=tb mod 16;
         regs.realds:=tb div 16;
         regs.realeax := flags and $ffff;
         regs.realecx:=0;
         sysrealintr($21,regs);
         if (regs.realflags and carryflag) <> 0 then
           begin
           InOutRes:=lo(regs.realeax);
           open:=-1;
           exit;
           end else
           open:=regs.realeax;
         if flags = $13D00 then
           begin
              regs.realebx:=regs.realeax;
              regs.realecx:=0;
              regs.realedx:=0;
              regs.realeax:=$4202; { set at end }
              sysrealintr($21,regs);
              if (regs.realflags and carryflag) <> 0 then
                InOutRes:=lo(regs.realeax);
           end;
      end;

    procedure doserase(p : pchar);

      var
         regs : trealregs;
      begin
         syscopytodos(longint(p),strlen(p)+1);
         regs.realedx:=tb mod 16;
         regs.realds:=tb div 16;
         regs.realeax:=$4100;
         sysrealintr($21,regs);
         if (regs.realflags and carryflag) <> 0 then
           InOutRes:=lo(regs.realeax);
      end;

    procedure dosrename(p1,p2 : pchar);

      var
         regs : trealregs;
      begin
         if strlen(p1)+strlen(p2)+3 > tb_size then RunError(200);
         sysseg_move(get_ds,longint(@p2),dos_selector,tb,strlen(p2)+1);
         regs.realedi:=tb mod 16;
         sysseg_move(get_ds,longint(@p1),dos_selector,tb+strlen(p2)+2,strlen(p1));
         regs.realedx:=tb mod 16 + strlen(p2)+2;
         regs.reales:=tb div 16;
         regs.realds:=tb div 16;
         regs.realeax:=$5600;
         sysrealintr($21,regs);
         if (regs.realflags and carryflag) <> 0 then
           InOutRes:=lo(regs.realeax);
      end;

    procedure doswrite(h,addr,len : longint);

      var
         regs : trealregs;
         size,writesize : longint;
      begin
      writesize:=0;
      while len > 0 do
        begin
           if len>tb_size then size:=tb_size
                         else size:=len;
           syscopytodos(addr+writesize,size);
           regs.realecx:=size;
           regs.realedx:=tb mod 16;
           regs.realds:=tb div 16;
           regs.realebx:=h;
           regs.realeax:=$4000;
           sysrealintr($21,regs);
           if (regs.realflags and carryflag) <> 0 then
             begin
                InOutRes:=lo(regs.realeax);
                exit;
             end;
           len:=len-size;
           writesize:=writesize+size;
        end;
      end;

    function dosread(h,addr,len : longint) : longint;

      var
         regs : trealregs;
         size,readsize : longint;
      begin
      readsize:=0;
      while len > 0 do
        begin
           if len>tb_size then size:=tb_size
                         else size:=len;
         regs.realecx:=size;
         regs.realedx:=tb mod 16;
         regs.realds:=tb div 16;
         regs.realebx:=h;
         regs.realeax:=$3f00;
         sysrealintr($21,regs);
         if (regs.realflags and carryflag) <> 0 then
           begin
              InOutRes:=lo(regs.realeax);
              dosread:=0;
              exit;
           end else
           if regs.realeax<size then
             begin
                syscopyfromdos(addr+readsize,regs.realeax);
                dosread:=readsize+regs.realeax;
                exit;
             end;
         syscopyfromdos(addr+readsize,regs.realeax);
         readsize:=readsize+regs.realeax;
         len:=len-regs.realeax;
         end;
         dosread:=readsize;
      end;

    function dosfilepos(handle : longint) : longint;

      var
         regs : trealregs;
      begin
         regs.realebx:=handle;
         regs.realecx:=0;
         regs.realedx:=0;
         regs.realeax:=$4201;
         sysrealintr($21,regs);
         if (regs.realflags and carryflag) <> 0 then
           Begin
           InOutRes:=lo(regs.realeax);
           dosfilepos:=0;
           end else
           dosfilepos:=lo(regs.realedx)*$10000+lo(regs.realeax);
      end;

    procedure dosseek(handle : longint;pos : longint);

      var
         regs : trealregs;
      begin
         regs.realebx:=handle;
         regs.realecx:=pos div $10000;
         regs.realedx:=pos and $ffff;
         regs.realeax:=$4200;
         sysrealintr($21,regs);
         if (regs.realflags and carryflag) <> 0 then
           InOutRes:=lo(regs.realeax);
      end;

    function dosfilesize(handle : longint) : longint;

      function set_at_end(handle : longint) : longint;

      var
         regs : trealregs;
      begin
         regs.realebx:=handle;
         regs.realecx:=0;
         regs.realedx:=0;
         regs.realeax:=$4202;
         sysrealintr($21,regs);
         if (regs.realflags and carryflag) <> 0 then
           Begin
           InOutRes:=lo(regs.realeax);
           set_at_end:=0;
           end else
           set_at_end:=lo(regs.realedx)*$10000+lo(regs.realeax);
      end;

      var
         tempfilesize : longint;
         aktfilepos : longint;

      begin
         aktfilepos:=dosfilepos(handle);
         tempfilesize:=set_at_end(handle);
         dosseek(handle,aktfilepos);
         dosfilesize:=tempfilesize;
      end;

    procedure fileopenfunc(var f : textrec);

      var
         b : array[0..255] of char;

      begin
         move(f.name[1],b,length(f.name));
         b[length(f.name)]:=#0;
         f.inoutfunc:=@fileinoutfunc;
         f.flushfunc:=@fileinoutfunc;
         f.closefunc:=@fileclosefunc;
         case f.mode of
            fminput : f.handle:=open(b,$3D00);
            fmoutput : f.handle:=open(b,$3C00);
            fmappend : begin
                          f.handle:=open(b,$13D00);
                          f.mode:=fmoutput;
                       end;
         end;
      end;

    function eof(var t : text) : boolean;[iocheck];

      begin
         eof:=dosfilesize(textrec(t).handle)<=dosfilepos(textrec(t).handle);
         if eof then
           eof:=textrec(t).bufend<=textrec(t).bufpos;
      end;

    procedure rewrite(var f : file;l : word);[iocheck];

      var
         b : array[0..255] of char;

      begin
         filerec(f).mode:=fmoutput;
         move(filerec(f).name[1],b,length(filerec(f).name));
         b[length(filerec(f).name)]:=#0;
  	 filerec(f).handle:=open(b,$3C00);
  	 filerec(f).recsize:=l;
      end;

    procedure reset(var f : file;l : word);[iocheck];

      var
         b : array[0..255] of char;

      begin
         move(filerec(f).name[1],b,length(filerec(f).name));
         b[length(filerec(f).name)]:=#0;
         {
           filerec(f).mode:=fminput;
           filerec(f).handle:=open(b,$3D00);
         }
         case filemode of
            0 : begin
                   filerec(f).mode:=fminput;
                   filerec(f).handle:=open(b,$3D00);
                end;
            1 : begin
                   filerec(f).mode:=fmoutput;
                   filerec(f).handle:=open(b,$3C00);
                end;
            2 : begin
                   filerec(f).mode:=fminout;
                   filerec(f).handle:=open(b,$3D02);
                end;
         end;
  	 filerec(f).recsize:=l;
      end;

    { will not be called any more !!!  }
    procedure rewrite(var f : file);[iocheck];

       begin
          rewrite(f,128);
       end;

    procedure reset(var f : file);[iocheck];

       begin
          reset(f,128);
       end;

{$ifdef typedfile }
    type untypedfile = file;

    procedure rewrite(var f : typedfile);[iocheck];

       begin
          rewrite(untypedfile(f),128);
       end;

    procedure reset(var f : typedfile);[iocheck];

       begin
          reset(untypedfile(f),128);
       end;

    procedure typedwrite(typesize : longint;var f : typedfile;var buf);[iocheck, public, alias : 'TYPED_WRITE'];

       var
          size : longint;

        begin
        {   if typesize > 0 then }
             doswrite(filerec(f).handle,longint(@buf),typesize);
        end;

    procedure typedread(typesize : longint;var f : typedfile;var buf);[iocheck, public, alias : 'TYPED_READ'];
      var
         result : longint;

      begin
         { if typesize > 0 then }
           result:=dosread(filerec(f).handle,longint(@buf),typesize);
      end;

{    procedure close(var f : typedfile);

      begin
         close(untypedfile(f));
      end;

    function filepos(var f : typedfile) : longint;
      begin
        filepos:=filepos(untypedfile(f));
      end;

    function filesize(var f : typedfile) : longint;
      begin
        filesize:=filesize(untypedfile(f));
      end;

    procedure seek(var f : typedfile;pos : longint);
      begin
         seek(untypedfile(f),pos);
      end;

    procedure erase(var f : typedfile);
      begin
         erase(untypedfile(f));
      end;

    procedure rename(var f : typedfile;const s : string);
      begin
         rename(untypedfile(f),s);
      end;

    function eof(var f : typedfile) : boolean;
      begin
        eof:=eof(untypedfile(f));
      end; }

{$endif typedfile }

    procedure blockwrite(var f : file;var buf;count : longint);[iocheck];

       var
          p : pointer;
          size : longint;

        begin
           p:=@buf;
           doswrite(filerec(f).handle,longint(p),count*filerec(f).recsize);
        end;

    procedure blockread(var f : file;var buf;count : longint;var result : longint);[iocheck];

      begin
         result:=dosread(filerec(f).handle,longint(@buf),
           count*filerec(f).recsize) div filerec(f).recsize;
      end;

    procedure blockread(var f : file;var buf;count : longint);[iocheck];
      var
         result : longint;

      begin
         blockread(f,buf,count,result);
      end;

    function filepos(var f : file) : longint;[iocheck];

      begin
         filepos:=dosfilepos(filerec(f).handle) div filerec(f).recsize;
      end;

    function filesize(var f : file) : longint;[iocheck];

      begin
         filesize:=dosfilesize(filerec(f).handle) div filerec(f).recsize;
      end;

    function eof(var f : file) : boolean;[iocheck];

      begin
         eof:=filesize(f)<=filepos(f);
      end;

    procedure seek(var f : file;pos : longint);[iocheck];

      begin
         dosseek(filerec(f).handle,pos*filerec(f).recsize);
      end;

    procedure close(var f : file);[iocheck];

      begin
         if (filerec(f).mode<>fmclosed) then
           begin
              filerec(f).mode:=fmclosed;
              do_close(filerec(f).handle);
           end;
      end;

    procedure dos_dirs(func : byte;name : pchar);

       var
         regs : trealregs;
      begin
         syscopytodos(longint(name),strlen(name)+1);
         regs.realedx:=tb mod 16;
         regs.realds:=tb div 16;
         regs.realeax:=func*$100;
         sysrealintr($21,regs);
         if (regs.realflags and carryflag) <> 0 then
           InOutRes:=lo(regs.realeax);
      end;

    procedure _dir(func : byte;const s : string);
    
      var
         buffer : array[0..255] of char;

      begin
         move(s[1],buffer,length(s));
         buffer[length(s)]:=#0;
         dos_dirs(func,buffer);
      end;

    procedure mkdir(const s : string);

      begin
         _dir($39,s);
      end;

    procedure rmdir(const s : string);

      begin
         _dir($3a,s);
      end;

    procedure chdir(const s : string);

      begin
         _dir($3b,s);
      end;

    { thanks to Michael Van Canneyt <michael@tfdec1.fys.kuleuven.ac.be>, }
    { who writes this code                                               }
    procedure getdir(drivenr : byte;var dir : string);

      var
         temp : string;
         sof : pointer;
         i : byte;
      var
         regs : trealregs;

      begin
         sof:=@dir[4];

         { dir[1..3] will contain '[drivenr]:\', but is not }
         { supplied by DOS, so we let dos string start at   }
         { dir[4]                                           }

         { Get dir from drivenr : 0=default, 1=A etc... }
         regs.realedx:=drivenr;
            { put (previously saved) offset in si }
         regs.realesi:=tb mod 16;
         regs.realds:=tb div 16;
            { call msdos function 47H : Get dir }
         regs.realeax:=$4700;
         sysrealintr($21,regs);
         if (regs.realflags and carryflag) <> 0 then
           Begin
           InOutRes:=lo(regs.realeax);
           end else
           syscopyfromdos(longint(@dir[4]),251);
         { Now Dir should be filled with directory in ASCIIZ, }
         { starting from dir[4]                               }
         dir[0]:=#3;
         dir[2]:=':';
         dir[3]:='\';

         i:=4;

         { conversation to Pascal string }
         while (dir[i]<>#0) do
           begin
              { convert path name to DOS }
              if dir[i]='/' then
                dir[i]:='\';
              dir[0]:=chr(i);
              inc(i);
           end;
         { upcase the string (FPKPascal function) }
         dir:=upcase(dir);
         if drivenr<>0 then   { Drive was supplied. We know it }
           dir[1]:=chr(65+drivenr-1)
         else
           begin
              { We need to get the current drive from DOS function 19H  }
              { because the drive was the default, which can be unknown }
              regs.realeax:=$1900;
              sysrealintr($21,regs);
              i:= (regs.realeax and $ff) + ord('A');
              dir[1]:=chr(i);
           end;
      end;

  var
     i : longint;

begin
   exitproc:=nil;
   { Heapmanagement initialisieren }
   {
   for i:=1 to 32 do
     blocks[i]:=nil;
   }
   heaporg:=getheapstart;
   heapptr:=heaporg;
   _memavail:=getheapsize;
   heapend:=heaporg+_memavail;
   curheap := @baseheap;
   otherheap := @tempheap;
   { heaperror:=nil;}
   heaperror:=@growheap;
   _heapsize:=longint(heapend)-longint(heaporg);
   freelist:=nil;
   { to test stack depth }
   loweststack:=maxlongint;
   { Standartinput initialisieren }
   assign(input,'');
   textrec(input).handle:=0;
   textrec(input).mode:=fminput;
   textrec(input).inoutfunc:=@fileinoutfunc;
   textrec(input).flushfunc:=@fileinoutfunc;
   { Standartoutput initialisieren }
   assign(output,'');
   textrec(output).handle:=1;
   textrec(output).mode:=fmoutput;
   textrec(output).inoutfunc:=@fileinoutfunc;
   textrec(output).flushfunc:=@fileinoutfunc;
   textrec(input).mode:=fminput;
   setup_environment;
   setup_arguments;
   { kein Ein- Ausgabefehler }
   inoutres:=0;
end.
