{****************************************************************************

                   Copyright (c) 1994,96 by Florian Klaempfl

 ****************************************************************************}
 
{****************************************************************************
               functions for heap management in the data segment
 ****************************************************************************}

    type pheapinfo = ^theapinfo;
         theapinfo : record
         heaporg,heapptr,heapend,freelist : pointer;
         end;

    var baseheap,tempheap : theapinfo;

    const curheap : pheapinfo = @baseheap;
          otherheap : pheapinfo = @tempheap;
          heap_split : boolean = false;
          special : boolean =true;

    procedure split_heap;
    begin
    if not heap_split then
      begin
      baseheap.heaporg:=heaporg;
      baseheap.heapptr:=heapptr;
      baseheap.freelist:=freelist;
      baseheap.heapend:=((heapend+heapptr) div 16)*8;
      tempheap.heaporg:=((heapend+heapptr) div 16)*8;
      tempheap.freelist:=nil;
      tempheap.heapend:=heapend;
      heapend:=baseheap.heapend;
      curheap:=@baseheap;
      heap_split:=true;
      end;
    end;

    procedure switch_to_base_heap;
    begin
      heaporg:=tempheap.heaporg;
      heapptr:=tempheap.heapptr;
      freelist:=tempheap.freelist;
      heapend:=tempheap.heapend;
      curheap:=@tempheap;
    end;

    procedure switch_to_temp_heap;
    begin
      heaporg:=baseheap.heaporg;
      heapptr:=baseheap.heapptr;
      freelist:=baseheap.freelist;
      heapend:=baseheap.heapend;
      curheap:=@baseheap;
    end;

    procedure switch_heap;
    begin
    if curheap = @tempheap then
      switch _to_base_heap
      else
      switch_to_temp_heap;
    end;

    procedure releasetempheap;
    begin
    switch_to_temp_heap;
    release(heaporg);
    unsplit_heap;
    split_heap;
    end;

    procedure gettempmem(var p : pointer;size : longint);
    begin
    split_heap;
    switch_to_temp_heap;
    special:=true;
    getmem(p,size);
    special:=false;
    end;
    var
       { blocks : array[1..32] of pointer; }
       _memavail : longint;

    function memavail : longint;

      begin
         memavail:=_memavail;
      end;

    type
       pfreerecord = ^tfreerecord;

       tfreerecord = record
          next : pfreerecord;
          size : longint;
       end;

    procedure unsplit_heap;
    var hp,hp2,thp : pfreerecord;
    begin
    {heapend can be modified by HeapError }
    if baseheap.heapend = tempheap.heaporg then
      begin
      switch_to_base_heap;
      hp:=pfreerecord(freelist);
      if assigned(hp) then
        while assigned(hp^.next) do hp:=hp^.next;
      hp^.next:=tempheap.freelist;
      hp^.size:=heapend-heapptr;
      heapend:=tempheap.heapend;
      heapptr:=tempheap.heapptr;
      cal_memavail;
      heap_split:=false;
      end else
      begin
      hp:=pfreerecord(baseheap.freelist);
      hp2:=pfreerecord(tempheap.freelist);
      while assigned(hp) and assigned(hp2) do
        begin
        if hp=hp2 then break;
        if hp>hp2 then
          begin
          thp:=hp2;
          hp2:=hp;
          hp:=thp;
          end;
        while assigned(hp^.next) and hp^.next<hp2 do
            hp:=hp^.next;
        if assigned(hp^.next) then
            begin
            thp:=hp^.next;
            hp^.next:=hp2;
            hp:=thp;
            end else
            begin
            hp^.next:=hp2;
            hp:=nil;
            end;
          end ;
      if heapend < tempheap.heapend then
        heapend:=tempheap.heapend;
      if heapptr < tempheap.heapptr then
        heapptr:=tempheap.heapptr;
      cal_memavail;
      heap_split:=false;
      end;
    end;

    function maxavail : longint;

      var
         hp : pfreerecord;

      begin
         maxavail:=heapend-heapptr;
         hp:=freelist;
         while assigned(hp) do
           begin
              if hp^.size>maxavail then
                maxavail:=hp^.size;
              hp:=hp^.next;
           end;
      end;

    procedure cal_memavail;

      var
         hp : pfreerecord;

      begin
         _memavail:=heapend-heapptr;
         hp:=freelist;
         while assigned(hp) do
           begin
              _memavail:=_memavail+hp^.size;
              hp:=hp^.next;
           end;
      end;

    procedure getmem(var p : pointer;size : longint);[public,alias: 'GETMEM'];


      function call_heaperror(size : longint) : integer;
{$ifdef DOS}
        begin
           asm
              pushl 12(%ebp)
	{ movl HEAPERROR,%eax doesn't work !!}
              leal U_SYSTEM_HEAPERROR,%eax
              call (%eax)
              leave
              ret $8
           end;
        end;
{$endif}
{$ifdef LINUX}
        begin
           asm
              pushl 12(%ebp)
              movl U_SYSLINUX_HEAPERROR,%eax
              call (%eax)
              leave
              ret $8
           end;
        end;
{$endif}

      var
         last,hp : pfreerecord;
         nochmal : boolean;

      begin
         if size=0 then
           begin
              p:=heapend;
              exit;
           end;
         { Auf Vielfaches von 8 Byte umrechnen }
         if (size mod 8)<>0 then
           size:=size+(8-(size mod 8));
         dec(_memavail,size);
         repeat
           nochmal:=false;
           { nun ist die freelist dran: }
           if assigned(freelist) then
             begin
                last:=nil;
                hp:=freelist;
                while assigned(hp) do
                  begin
                     { erster passender Block wird genommen }
                     if hp^.size>=size then
                       begin
                          p:=hp;
                          { wird der ganze Block bentigt ? }
                          if hp^.size>size then
                            begin
                               (hp+size)^.size:=hp^.size-size;
                               (hp+size)^.next:=hp^.next;
                               if assigned(last) then
                                 last^.next:=hp+size
                               else
                                 freelist:=hp+size;
                            end
                          else
                            begin
                               if assigned(last) then
                                 last^.next:=hp^.next
                               else
                                 freelist:=nil;
                            end;
                          exit;
                       end;
                     last:=hp;
                     hp:=hp^.next;
                  end;
             end;
           { zuletzt wird an der Heapspitze nachgeschaut, ob }
           { noch Speicher frei ist                          }
           if heapend-heapptr<size then
             begin
                if assigned(heaperror) then
                  begin
                     case call_heaperror(size) of
                        0 : runerror(203);
                        1 : p:=nil;
                        2 : nochmal:=true;
                     end;
                  end
                else
                  runerror(203);
             end
           else
             begin
                p:=heapptr;
                heapptr:=heapptr+size;
             end;
         until not nochmal;
      end;

    procedure freemem(var p : pointer;size : longint);[public,alias: 'FREEMEM'];

      var
         hp : pfreerecord;

      begin
         if heap_split then
           begin
           if (@p < otherheap^.heapend) and
              (@p > otherheap^.heaporg) then
             begin
             writeln('warning : p and @p are in different heaps !');
             if (p<heaporg) or (p>heapptr) then
               begin
                  writeln('pointer doesn''t points to the heap');
                  runerror(203);
               end;
             end;
           end else
         if (p<heaporg) or (p>heapptr) then
           begin
              writeln('pointer doesn''t points to the heap');
              runerror(203);
           end;
         { Auf Vielfaches von 8 Byte umrechnen }
         if (size mod 8)<>0 then
           size:=size+(8-(size mod 8));
         inc(_memavail,size);
         if p+size>=heapptr then
           heapptr:=p
         else
           begin
              { size can be allways set }
              pfreerecord(p)^.size:=size;

              { if there is no free list }
              if not assigned(freelist) then
                begin
                   { then generate one }
                   freelist:=p;
                   pfreerecord(p)^.next:=nil;
                   p:=nil;
                   { we are ready }
                   exit;
                end;
              if p+size<freelist then
                begin
                pfreerecord(p)^.next:=freelist;
                freelist:=p;
                p:=nil;
                exit;
                end
              else
              if p+size=freelist then
                begin
                inc(pfreerecord(p)^.size,pfreerecord(freelist)^.size);
                pfreerecord(p)^.next:=pfreerecord(freelist)^.next;
                freelist:=p;
                p:=nil;
                exit;
                end;
              { an welcher Position der freelist einfgen? }
              hp:=freelist;
              while assigned(hp) do
                begin
                   if p<hp+hp^.size then
                      begin
                      writeln('pointer to dispose has already been disposed');
                      runerror(203);
                      end;
                   { conneting two blocks ? }
                   if hp+hp^.size=p then
                      begin
                         inc(hp^.size,size);
                         break;
                      end
                   { if the end is reached, then concat }
                   else if hp^.next=nil then
                     begin
                        hp^.next:=p;
                        pfreerecord(p)^.next:=nil;
                        break;
                     end
                   { falls der nchste Zeiger grer ist, dann }
                   { Einhngen                                 }
                   else if hp^.next>p then
                     begin
                        { vielleicht zwei Blcke zusammenfassen ? }
                        if p+size=hp^.next then
                          begin
                             pfreerecord(p)^.next:=hp^.next^.next;
                             inc(pfreerecord(p)^.size,hp^.next^.size);
                          end
                        else
                          begin
                             pfreerecord(p)^.next:=hp^.next;
                             hp^.next:=p;
                          end;
                        break;
                     end;
                   hp:=hp^.next;
                end;
           end;
         p:=nil;
      end;

    function getheapstart : pointer;

      begin
         asm
            leal HEAP,%eax
            leave
            ret
         end ['EAX'];
      end;

    function getheapsize : longint;

      begin
         asm
            movl HEAPSIZE,%eax
            leave
            ret
         end ['EAX'];
      end;

    procedure release(var p : pointer);

      begin
         heapptr:=p;
         freelist:=nil;
         cal_memavail;
      end;

    procedure mark(var p : pointer);

      begin
         p:=heapptr;
      end;

    procedure markheap(var oldfreelist,oldheapptr : pointer);

      begin
         oldheapptr:=heapptr;
         oldfreelist:=freelist;
         freelist:=nil;
         cal_memavail;
      end;

    procedure releaseheap(oldfreelist,oldheapptr : pointer);

      begin
         heapptr:=oldheapptr;
         if longint(freelist) < longint(heapptr) then
           begin
           {here we should reget the freed blocks}
           end;
         freelist:=oldfreelist;
         cal_memavail;
      end;
