{/* Copyright (C) 1996 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 1995 DJ Delorie, see COPYING.DJ for details */}

{static int
far_strlen(int selector, int linear_addr)}
{
  int save=linear_addr;
  _farsetsel(selector);
  while (_farnspeekb(linear_addr))
    linear_addr++;
  return linear_addr - save;
}
{$IfDef Dummy_args}
{Const __PROXY = ' !proxy';
      __PROXY_LEN = 7;}


var argc : longint;
    doscmd : string[128];
    args : ^pchar;

procedure setup_arguments;
var psp : word;
    i,j : byte;
    quote : char;
    largs : array[0..127] of pchar;
begin
 asm
 movl __stubinfo,%eax
 movl 26(%eax),psp
 end;
argc := 0;
sysseg_move(psp, 128, get_ds, longint(@doscmd), 128);
j := 1;
quote := #0;
for i:=1 to length(doscmd) do
  Begin
  if doscmd[i] = quote then
    begin
    quote := #0;
    continue;
    end;
  if doscmd[i] in ['''','"'] then
    begin
    quote := doscmd[i];
    continue;
    end;
  if (quote = #0) and ((doscmd[i] = ' ')
    or (doscmd[i] = #9) or (doscmd[i] = #10) or
    (doscmd[i] = #12) or (doscmd[i] = #9) or (i = length(doscmd)) then
    begin
    doscmd[i]:=#0;
    largs[argc]:=@doscmd[j];
    inc(argc);
    j := i+1;
    end;
  end;
getmem(args,argc*SizeOf(pchar));
for i := 0 to argc - 1 do
   args^[i] := largs[i];
end;

{$Else  Dummy_args}
type  PArg   = ^Arg;
      PargArray  =  Array[0..0] of PArg;
      PPArg = ^PargArray;
      PArgList = ^ArgList;
      Arg  = Record
             arg : pchar;
             arg_file : PArgList;
             was_quoted : boolean;
             next : PArg;
             end;

             ArgList = Record
             argc : integer;
             argv : PPArg;
             end;

function atohex(s : pchar) : longint;
var rv : longint;
    v : byte;
begin
  rv := 0;
  while (s^ <> #0) do
    begin
    v := ord(s^ )- ord('0');
    if (v > 9) then
      v := v - 7;
    v := v and $F; { in case it's lower case }
    rv := rv*16 + v;
    inc(longint(s));
    end;
  atohex := rv;
end;

function new_arg : PArg;
var p : parg;
Begin
  getmem(p,sizeof(Arg));
  fillchar(p^, sizeof(Arg), #0);
  new_arg := p;
End;

Procedure delete_arglist(al : PArgList);forward;

Procedure delete_arg(a : PArg);
Begin
  if (a^.arg)<> nil then freemem(a^.arg,strlen(a^.arg)+1);
  if (a^.arg_file) <> nil then
    delete_arglist(a^.arg_file);
dispose(a);
End;

function new_arglist(count : longint) : PArglist;
var al : PArglist;
Begin
  new(al);
  al^.argc := count;
  getmem(al^.argv,(count+1)*sizeof(PArg));
  fillchar(al^.argv^, (count+1)*sizeof(PArg),#0);
  new_arglist := al;
end;

procedure delete_arglist(al : PArgList);
var i : integer;
Begin
  for i:=0 to al^.argc do
    delete_arg(al^.argv^.arg[i]);
  freemem(al^.argv,(al^.argc+1)*SizeOf(PArg));
  dispose(al);
End;


function localisspace (s : char)  : boolean;
begin
  localisspace := (s=' ') or (s=#9) or (s=#10) or (s=#12) or (s=#13);
End;

Function parse_arg(bp,last : pchar;var len : longint; var was_quoted : boolean) : pchar;
Var ep, epp : pchar;
    quote : char;
Begin
  ep := bp;
  epp := bp;
  quote:=#0;

  while ((quote<>#0) or not localisspace(ep^)) and (ep < last) do
    begin
    if ((quote<>#0) and (ep^ = quote)) then
      begin
      quote := #0;
      was_quoted := true;
      inc(longint(ep));
      end
    else if ( (quote=#0) and  ((ep^= '''') or (ep^ = '"'))) then
      begin
      quote := ep^;
      inc(longint(ep));
      end
    else if ((ep^ = '\') and ((ep[1] = '"') or (ep[1]='''')) and (ep < last-1)) then
      begin
      inc(longint(ep),2);
      epp:=ep+1;
     end;
     inc(longint(ep));
     epp:= ep;
     inc(longint(epp));
   end;

  len := epp - bp;
  parse_arg := ep;
end;

Function parse_bytes(bytes : pchar;length : longint) : PArglist;
Var    largc, i : longint;
   a, afirst : PArg;
   al : PArgList;
   bp,ep,last : pchar;
   arg_len : longint;
Begin

  bp:=bytes;
  last:=bytes+length;
  afirst := nil;
  largc := 0;
  while (bp<last) do
    begin
    while (localisspace(bp^) and (bp < last)) do inc (longint(bp));
    if (bp = last) then
      break;
    if afirst = nil then
      begin
      afirst := new_arg;
      a := afirst;
      end else
      begin
      a^.next := new_arg;
      a := a^.next;
      end;
    ep := parse_arg(bp, last, arg_len,a^.was_quoted);
    inc(largc);
    getmem(a^.arg,arg_len+1);
    strlcopy(a^.arg, bp, arg_len);
    a^.arg[arg_len] := #0;
    bp := ep+1;
    end;
  al := new_arglist(largc);
  a := afirst;
  for i:=0 to largc do
    begin
    al^.argv^[i] := a;
    a := a^.next;
    end;
parse_bytes:= al;
end;

function count_args(al : PArgList) : longint;
Var   i, r : longint;
Begin
  r := 0;
  for i:=0 to al^.argc do
    begin
    if (al^.argv^[i]^.arg_file <> nil) then
          r := r + count_args(al^.argv^[i]^.arg_file)
       else inc(r);
    end;
count_args := r;
end;

function fill_args(var largv  : pparg;al : PArgList) : pparg;
var i : longint;
begin
  for i:=0 to al^.argc do
    if (al^.argv^[i]^.arg_file <> nil) then
      largv := fill_args(largv, al^.argv^[i]^.arg_file)
      else
      begin
        largv^[0]^.arg := al^.argv^[i]^.arg;
        inc(longint(largv),SizeOf(pchar));
        al^.argv^[i]^.arg := nil;
      end;
fill_args := largv;
end;

procedure expand_response_files(al : PArgList );

var    i,filesize : longint;
       f : file;
       filename : string;
       srec : searchrec;
       bytes : pchar;
Begin
  for i:=0 to al^.argc do
    begin
    if (not al^.argv^[i]^.was_quoted and (al^.argv^[i]^.arg[0] = '@')) then
      begin
      filename := strpas(al^.argv^[i]^.arg+1);
      assign(f,filename);
      reset(f);
      if ioresult = 0 then
        begin
        findfirst(filename,AnyFile,SRec);
        filesize := srec.size;
        getmem(bytes,filesize);
        blockread(f, bytes, filesize);
        close(f);
        al^.argv^.arg[i]^.arg_file := parse_bytes(bytes, filesize);
        expand_response_files(al^.argv^.arg[i]^.arg_file);
        end;
      end;
    end;
end;


{extern char __PROXY[]; /* defined on crt0/crt1.c */
extern size_t __PROXY_LEN;}
Const __PROXY = ' !proxy';
      __PROXY_LEN = 7;

var argc : longint;
    args : ^pchar;

procedure setup_arguments;
var    doscmd : string[128];
       proxy_line : array  [0..49] of char;
       plen : longint;
       prepend_argv0 : boolean;
       argv0 : pchar;
       proxy_v : string;
begin
prepend_argv0 := false;

{
  ArgList *arglist;
  char *argv0;
  int prepend_argv0 = 1;
  int should_expand_wildcards = 1;
  char *proxy_v = 0;

  /*
  ** first, figure out what to pass for argv[0]
  */
  {
    int i;
    char *ap, *ls, *fc;
/*    char newbase[14]; */

    if (_crt0_startup_flags & _CRT0_FLAG_DROP_DRIVE_SPECIFIER)
      if (__dos_argv0[1] == ':')
        __dos_argv0 += 2;

    ls = __dos_argv0;
    for (ap=__dos_argv0; *ap; ap++)
      if (*ap == ':' || *ap == '\\' || *ap == '/')
        ls = ap + 1;
    fc = ls;
#if 0
    /* We never do this!  Only the stub uses this field */
    if (_stubinfo^.basename[0])
    {
      for (i=0; i<8 && _stubinfo^.basename[i]; i++)
	newbase[i] = _stubinfo^.basename[i];
      newbase[i++] = '.';
      newbase[i++] = 'E';
      newbase[i++] = 'X';
      newbase[i++] = 'E';
      newbase[i++] = 0;
      fc = newbase;
    }
#endif
    if (_stubinfo^.argv0[0])
    {
      fc = _stubinfo^.argv0;
    }
    argv0 = (char * )calloc(1, ls-__dos_argv0+strlen(fc)+1);
    if (ls == __dos_argv0)
      strncpy(argv0, fc, 16);
    else
    {
      strncpy(argv0, __dos_argv0, ls-__dos_argv0);
      strncat(argv0, fc, 16);
    }
    for (i=0; (fc == _stubinfo^.argv0)?(i<ls-__dos_argv0):(argv0[i]); i++)
    {
      if (!(_crt0_startup_flags & _CRT0_FLAG_USE_DOS_SLASHES))
        if (argv0[i] == '\\')
          argv0[i] = '/';
    }
    if (_crt0_startup_flags & _CRT0_FLAG_DROP_EXE_SUFFIX)
    {
      char *sp = argv0 + strlen(argv0) - 4;
      if (sp[0] == '.'
	  && (sp[1] == 'e' || sp[1] == 'E')
	  && (sp[2] == 'x' || sp[2] == 'X')
	  && (sp[3] == 'e' || sp[3] == 'E'))
        *sp = 0;
    }
  }

  /*
  ** Next, scan dos's command line.
  */    *) }

    sysseg_move(_stubinfo^.psp_selector, 128, get_ds, longint(@doscmd), 128);
    arglist := parse_bytes(pchar(@doscmd+1), doscmd[0] & 0x7f);


  {/*
  ** Check for !proxy.
  **
  ** If there is " !proxy" (note the leading blank!) in the environ,
  ** use it instead of what DOS command line tells.  This is the method
  ** v2.01 and later uses to pass long command lines from `system';
  ** these should be passed through wildcard expansion unless quoted.
  */  }
  proxy_v := getenv(__PROXY);
  if (proxy_v <> '') then
    begin
{    char proxy_line[50];	/* need only 34 */}
    plen := strlen(proxy_v);
    strlcopy(proxy_line, __PROXY, __PROXY_LEN + 1); {/* copy " !proxy" */ }
    proxy_line[__PROXY_LEN] = ' ';
    strlcopy(proxy_line + __PROXY_LEN+1, proxy_v, plen+1); { /* copy value */}
    delete_arglist(arglist);
    arglist := parse_bytes(proxy_line, plen+__PROXY_LEN+1);
    end;
{$IfDef Handle_proxy }
  if (arglist^.argc > 3 && strcmp(arglist^.argv[0]^.arg, __PROXY+1) == 0)
  {
    int argv_seg, argv_ofs, i;
    unsigned short *rm_argv;
    __crt0_argc = atohex(arglist^.argv[1]^.arg);
    argv_seg = atohex(arglist^.argv[2]^.arg);
    argv_ofs = atohex(arglist^.argv[3]^.arg);
    delete_arglist(arglist);

    rm_argv = (unsigned short *)alloca(__crt0_argc*sizeof(unsigned short));
    movedata(_dos_ds, argv_seg*16+argv_ofs, ds, (int)rm_argv, __crt0_argc*sizeof(unsigned short));

    arglist = new_arglist(__crt0_argc);
    if (proxy_v)
      should_expand_wildcards = 1;
    else
      should_expand_wildcards = 0;


    for (i=0; i<__crt0_argc; i++)
    {
      int al = far_strlen(_dos_ds, argv_seg*16 + rm_argv[i]);
      arglist^.argv[i] = new_arg();
      arglist^.argv[i]^.arg = (char *)malloc(al+1);
      movedata(_dos_ds, argv_seg*16 + rm_argv[i], ds, (int)(arglist^.argv[i]^.arg), al+1);
      if (proxy_v)
      {
	size_t ln;
	char *lastc = arglist^.argv[i]^.arg + al;
	parse_arg(arglist^.argv[i]^.arg, lastc,
		  &ln, &(arglist^.argv[i]^.was_quoted));
	arglist^.argv[i]^.arg[ln] = '\0';
      }
    }
    prepend_argv0 = 0;
  }

{$EndIf Handle_proxy}

{  /*
  **  Now, expand response files
  */}
  if ((_crt0_startup_flags and _CRT0_FLAG_DISALLOW_RESPONSE_FILES) = 0) then
    expand_response_files(arglist);

{  /*
  **  Now, expand wildcards
  */

  if (should_expand_wildcards)
    expand_wildcards(arglist);}

  argc := prepend_argv0 + count_args(arglist);
  getmem(argv,(argc+1) * sizeof(pchar));
  if (prepend_argv0) then
    argv[0] = argv0;
  fill_args(__crt0_argv+prepend_argv0, arglist)^ := nil;
  end;
end;
{$Endif  Dummy_args}

