{****************************************************************************

                     Copyright (c) 1993,97 by Florian Klaempfl

                  Parts by Copyright (c) 1996,97 by Pierre Muller

 ****************************************************************************}
{$I-}
unit symtable;

{
  this unit handles the symbol tables

  + feature added
  - removed
  * bug fixed or changed

  History (started with version 0.9.0):
       7th december 1996:
         * the call offset is now saved in call_offset and not in name
      26th december 1996:
         + new PPU file handling
      26th february 1997:
         + fixed comma numbers
}
  interface

    uses
       objects,cobjects,verbose,errors,systems,globals,dos,strings,aasm,files
{$ifdef i386}
       ,i386
{$endif}
{$ifdef alpha}
       ,alpha
{$endif}
{$ifdef GDB}
       ,gdb
{$endif}
       ;

    const
       { possible types of symtables }
       localsymtable = $8000;
       parasymtable = $4000;
       locallevel = $3fff;
       withsymtable = 1;
       staticsymtable = 2;
       globalsymtable = 3;
       unitsymtable = 4;
       objectsymtable = 5;
       recordsymtable = 6;
       macrosymtable = 7;

       { options of subroutines }
       poexceptions = $1;
       povirtualmethod = $2;
       poclearstack = $4;
       poconstructor = $8;
       podestructor = $10;
       pointernproc = $20;
       poexports = $40;
       poiocheck = $80;
       poabstractmethod = $100;
       pointerrupt = $200;
       poinline = $400;
       poassembler = $800;

       hasharraysize = 97;

       { last operator which can be overloaded }
       last_overloaded = PLUS;

       { options for objects and classes }
       oois_abstract = $1;
       oois_class = $2;
{$ifdef GDB}
       oo_hasvirtual = $4;
{$endif * GDB *}

    type
       pword = ^word;

       { "forward" pointer }
       pformaldef = ^tformaldef;
       pfiledef = ^tfiledef;
       pobjectdef = ^tobjectdef;
       precdef = ^trecdef;
       parraydef = ^tarraydef;
       ppointerdef = ^tpointerdef;
       pstringdef = ^tstringdef;
       paufzaehldef = ^taufzaehldef;
       porddef = ^torddef;
       pfloatdef = ^tfloatdef;
       pprocdef = ^tprocdef;
       perrordef = ^terrordef;
       psetdef = ^tsetdef;
       psymtable = ^tsymtable;
       pdef = ^tdef;
       pprocvardef = ^tprocvardef;
       pabstractprocdef = ^tabstractprocdef;
       psym = ^tsym;
       plabelsym = ^tlabelsym;

       { base types }
       tbasetype = (uauto,u8bit,s32bit,uvoid,bool8bit,uchar,
                    s8bit,s16bit,u16bit,u32bit);

       tfloattype = (f32bit,s32real,s64real,
                     s80real
{$ifdef i386}
                     { for the i386, this is an real, because the FPU
                       does the calculations
                     }
                     ,s64bit
{$endif}
                     );

       { possible types for symtable entries }
       tsymtyp = (abstractsym,varsym,typesym,procsym,unitsym,programsym,
                  constsym,aufzaehlsym,typedconstsym,errorsym,syssym,
                  labelsym,absolutesym);

       { this object is the base for all symbol objects }
       tsym = object
          typ : tsymtyp;
          _name : pchar;
          left : psym;
          right : psym;
          speedvalue : longint;
          forwarddef : boolean;
          owner : psymtable;
{$ifdef GDB}
          isstabwritten : boolean;
          line_no : longint;
{$endif * GDB *}
          constructor init(const n : string);
          constructor load;
          destructor done;virtual;
          procedure write;virtual;
          procedure deref;virtual;
          function name : string;
          function mangledname : string;virtual;
          procedure setname(const s : string);
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif * GDB *}
       end;

       tlabelsym = object(tsym)
          number : longint;
          defined : boolean;
          constructor init(const n : string;l : longint);
          destructor done;virtual;
          function mangledname : string;virtual;
          procedure write;virtual;
       end;

       punitsym = ^tunitsym;

       tunitsym = object(tsym)
          unitsymtable : psymtable;
          constructor init(const n : string;ref : psymtable);
          procedure write;virtual;
{$ifdef GDB}
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif * GDB *}
       end;

       pmacrosym = ^tmacrosym;

       tmacrosym = object(tsym)
          defined : boolean;
          buftext : pchar;
          buflen : longint;
          { macros aren't written to PPU files ! }
          constructor init(const n : string);
          destructor done;virtual;
       end;

       perrorsym = ^terrorsym;

       terrorsym = object(tsym)
          constructor init;
       end;

       pprocsym = ^tprocsym;

       tprocsym = object(tsym)
          definition : pprocdef;
{$ifdef GDB}
          is_global : boolean;{necessary for stab}
{$endif * GDB *}
          constructor init(const n : string);
          constructor load;
          destructor done;virtual;
          function mangledname : string;virtual;
          { tests, if all procedures definitions are defined and not }
          { only forward                                             }
          procedure check_forward;
          procedure write;virtual;
          procedure deref;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif * GDB *}
       end;

       ptypesym = ^ttypesym;

       ttypesym = object(tsym)
          definition : pdef;
          forwardpointer : ppointerdef;
{$ifdef GDB}
          isusedinstab : boolean;
{$endif * GDB *}
          constructor init(const n : string;d : pdef);
          constructor load;
          destructor done;virtual;
          procedure write;virtual;
          procedure deref;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif * GDB *}
       end;

       tvarspez = (vs_value,vs_const,vs_var);

       pvarsym = ^tvarsym;

       tvarsym = object(tsym)
          adresse : longint;
          definition : pdef;
          refs : longint;
          regable : boolean;

          { if reg<>R_NO, then the variable is an register variable }
          reg : tregister;

          { sets the type of access }
          varspez : tvarspez;
          is_valid : boolean;
          constructor init(const n : string;p : pdef);
          constructor load;
          function mangledname : string;virtual;
          function getsize : longint;
          procedure write;virtual;
          procedure deref;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
{$endif * GDB *}
       end;

       pabsolutesym = ^tabsolutesym;

       tabsolutesym = object(tvarsym)
          ref : psym;
          { this creates a problem in gen_vmt !!!!!
          because the pdef is not resolved yet !!
          we should fix this }
          {constructor init(const s : string;p : pdef;newref : psym);}
{$ifdef GDB}
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif * GDB *}
       end;

       ptypedconstsym = ^ttypedconstsym;

       ttypedconstsym = object(tsym)
          prefix : pstring;
          definition : pdef;
          constructor init(const n : string;p : pdef);
          constructor load;
          destructor done;virtual;
          function mangledname : string;virtual;
          procedure write;virtual;
          procedure deref;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
{$endif * GDB *}
       end;

       tconsttype = (constord,conststring,constreal,constbool,constint,
                     constchar);

       pconstsym = ^tconstsym;

       tconstsym = object(tsym)
          definition : pdef;
          consttype : tconsttype;
          value : longint;
          constructor init(const n : string;t : tconsttype;v : longint;def : pdef);
          constructor load;
          function mangledname : string;virtual;
{$ifdef GDB}
          destructor done;virtual;
{$endif * GDB *}
          procedure deref;virtual;
          procedure write;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif * GDB *}
       end;

       paufzaehlsym = ^taufzaehlsym;

       taufzaehlsym = object(tsym)
          value : longint;
          definition : paufzaehldef;
{$ifdef GDB}
          next : paufzaehlsym;
{$endif * GDB *}
          constructor init(const n : string;def : paufzaehldef;v : longint);
          constructor load;
          procedure write;virtual;
          procedure deref;virtual;
{$ifdef GDB}
          procedure order;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif * GDB *}
       end;

       pprogramsym = ^tprogramsym;

       tprogramsym = object(tsym)
          constructor init(const n : string);
       end;

       psyssym = ^tsyssym;

       tsyssym = object(tsym)
          number : longint;
          constructor init(const n : string;l : longint);
          procedure write;virtual;
{$ifdef GDB}
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif * GDB *}
       end;

       tcallback = procedure(p : psym);

       tsymtablehasharray = array[0..hasharraysize-1] of psym;

       psymtablehasharray = ^tsymtablehasharray;

       tsymtable = object
          name : pstring;
          datasize : longint;
          wurzel : psym;
	  hasharray : psymtablehasharray;
          next : psymtable;
{$ifdef GDB}
          defowner : pdef; {for records and objects}
{$endif * GDB *}
          { only used for parameter symtable to determine the offset relative }
          { to the frame pointer                                              }
          call_offset : longint;

          { this saves all definition to allow a proper clean up }
          wurzeldef : pdef;
          symtabletype : word;

          { each symtable gets a number }
          unitid : word;

          constructor init(t : word);
          constructor load;
          constructor loadasstruct(typ : word);
          destructor done;virtual;
          procedure check_forwards;
          procedure insert(sym : psym);
          function search(const s : stringid) : psym;
          procedure clear;
          procedure registerdef(p : pdef);
          procedure foreach(proc2call : tcallback);
          procedure allsymbolsused;
          procedure write;
          procedure number_units;
          procedure number_defs;
          procedure writeasstruct;
          function getdefnr(l : word) : pdef;
{$ifdef GDB}
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif * GDB *}
          function getnewtypecount : word; virtual;
       end;

       punitsymtable = ^tunitsymtable;

       tunitsymtable = object(tsymtable)
          checksum,maschstart : longint;
          dbx_count : longint;
          is_stab_written : boolean;
          prev_dbx_counter : plongint;
          dbx_count_ok : boolean;
          unittypecount  : word;
          constructor init(t : word;const n : string);
          constructor load(const n : string);
          procedure writeasunit;
{$ifdef GDB}
          procedure orderdefs;
          procedure concattypestabto(asmlist : paasmoutput);
{$endif * GDB *}
          function getnewtypecount : word; virtual;
       end;


       { defintion contains the informations about a type }
       tdeftype = (abstractdef,arraydef,recorddef,pointerdef,orddef,
                   stringdef,aufzaehldef,procdef,objectdef,errordef,
                   filedef,formaldef,setdef,procvardef,floatdef);

       tdef = object
          savesize : longint;
          owner : psymtable;
          { this allows to determine by which type the defintion was generated }
          sym : ptypesym;
          next : pdef;
{$ifdef GDB}
          globalnb : word;
          nextglobal : pdef;
          {StabType : word;}
          isstabwritten : boolean;
{$endif * GDB *}
          number : word;
          deftype : tdeftype;

          function size : longint;virtual;
{$ifdef GDB}
          function NumberString : string;
{$endif * GDB *}
          constructor init;
{$ifdef GDB}
          constructor load;
          procedure set_globalnb;
{$endif * GDB *}
          destructor done;virtual;
          procedure write;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          function allstabstring : pchar;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif * GDB *}
          procedure deref;virtual;
       end;

       tfiletype = (ft_text,ft_typed,ft_untyped);

       tfiledef = object(tdef)
          public
             filetype : tfiletype;
             typed_as : pdef;
             constructor init(ft : tfiletype;tas : pdef);
             constructor load;
             procedure write;virtual;
{$ifdef GDB}
             function stabstring : pchar;virtual;
             procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif * GDB *}
             procedure deref;virtual;
          private
             procedure setsize;
       end;

       tformaldef = object(tdef)
          constructor init;
          constructor load;
          procedure write;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif * GDB *}
       end;

       terrordef = object(tdef)
          constructor init;
{$ifdef GDB}
          function stabstring : pchar;virtual;
{$endif * GDB *}
       end;

       tpointerdef = object(tdef)
          definition : pdef;
          defsym : ptypesym;
          constructor init(def : pdef);
          constructor load;
          procedure write;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif * GDB *}
          procedure deref;virtual;
       end;

       tarraydef = object(tdef)
          lowrange : longint;
          highrange : longint;
          rangenr : longint;
          definition : pdef;
          rangedef : pdef;
          function elesize : longint;
          constructor init(l,h : longint;rd : pdef);
          constructor load;
          procedure write;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif * GDB *}
          procedure deref;virtual;
          function size : longint;virtual;

          { generates the ranges needed by the asm instruction BOUND }
          procedure genrangecheck;
       end;

       trecdef = object(tdef)
          symtable : psymtable;
          constructor init(p : psymtable);
          constructor load;
          destructor done;virtual;
          procedure write;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif * GDB *}
          procedure deref;virtual;
       end;

       torddef = object(tdef)
          von : longint;
          bis : longint;
          rangenr : longint;
          typ : tbasetype;
          constructor init(t : tbasetype;v,b : longint);
          constructor load;
          procedure write;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
{$endif * GDB *}
          procedure setsize;

          { generates the ranges needed by the asm instruction BOUND }
          procedure genrangecheck;
       end;

       tfloatdef = object(tdef)
          typ : tfloattype;
          constructor init(t : tfloattype);
          constructor load;
          procedure write;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
{$endif * GDB *}
          procedure setsize;
       end;

       pdefcoll = ^tdefcoll;

       tdefcoll = record
          data : pdef;
          next : pdefcoll;
          paratyp : tvarspez;
       end;

       tabstractprocdef = object(tdef)
          { saves a definition to the return type }
          retdef : pdef;
          { save the procedure options }
          options : word;
          para1 : pdefcoll;
          constructor init;
          constructor load;
          destructor done;virtual;
          procedure concatdef(p : pdef;vsp : tvarspez);
          procedure deref;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif * GDB *}
          procedure write;virtual;
       end;

       tprocvardef = object(tabstractprocdef)
          constructor init;
          constructor load;
          procedure write;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput); virtual;
{$endif * GDB *}
       end;

       tprocdef = object(tabstractprocdef)

          extnumber : longint;
          nextoverloaded : pprocdef;
          { pointer to the local symbol table }
          localst : psymtable;
          { pointer to the parameter symbol table }
          parast : psymtable;


          _class : pobjectdef;
          _mangledname : pchar;

          { it's a tree, but this not easy to handle }
          { with the interfaces of units             }
          code : pointer;

          { true, if the procedure is only declared }
          { (forward procedure) }
          forwarddef : boolean;

          { set which contains the modified registers }
{$ifdef i386}
          usedregisters : byte;
{$endif}
{$ifdef alpha}
          usedregisters_int : longint;
          usedregisters_fpu : longint;
{$endif}
          constructor init;
          destructor done;virtual;
          constructor load;
          procedure write;virtual;
{$ifdef GDB}
          function cplusplusmangledname : string;
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif * GDB *}
          procedure deref;virtual;
          function mangledname : string;
          procedure setmangledname(const s : string);
       end;

       tstringdef = object(tdef)
          len : byte;
          constructor init(l : byte);
          constructor load;
          procedure write;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif * GDB *}
       end;

       taufzaehldef = object(tdef)
          max : longint;
{$ifdef GDB}
          first : paufzaehlsym;
{$endif * GDB *}
          constructor init;
          constructor load;
{$ifdef GDB}
          destructor done;virtual;
{$endif * GDB *}
          procedure write;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
{$endif * GDB *}
       end;

       tobjectdef = object(tdef)
          childof : pobjectdef;
          name : pstring;
{          privatesyms : psymtable;
          protectedsyms : psymtable; }
          publicsyms : psymtable;
          options : word;
          constructor init(const n : string;c : pobjectdef);
          destructor done;virtual;
          procedure check_forwards;
          function isrelated(d : pobjectdef) : boolean;
          function size : longint;virtual;
          constructor load;
          procedure write;virtual;
          function vmt_mangledname : string;
{$ifdef GDB}
          function stabstring : pchar;virtual;
{$endif * GDB *}
          procedure deref;virtual;
       end;

       tsettype = (normset,smallset,varset);

       tsetdef = object(tdef)
          setof : pdef;
          settype : tsettype;
          constructor init(s : pdef;high : longint);
          constructor load;
          procedure write;virtual;
{$ifdef GDB}
          function stabstring : pchar;virtual;
          procedure concatstabto(asmlist : paasmoutput);virtual;
{$endif * GDB *}
          procedure deref;virtual;
       end;

    { inits the symbol table administration }
    procedure init_symtable;
    procedure done_symtable;
    procedure reset_gdb_info;

    procedure getsym(const s : stringid;notfounderror : boolean);
    procedure getsymonlyin(p : psymtable;const s : stringid);

    { writes an unit with the given name, }
    { returns the filesize                }
    function writeunitas(const s : string;unitsymtable : punitsymtable) : longint;

    { deletes a symbol table from the symbol table stack }
    procedure dellexlevel;

    { saves a forward pointer defintion .... }
    procedure save_forward(ppd : ppointerdef;typesym : ptypesym);

    { .... resolves this forward definitions }
    procedure resolve_forwards;

    var
       { for STAB debugging }
       globaltypecount : word;
       pglobaltypecount : pword;

       registerdef : boolean;      { true, wenn Definitionen           }
                                   { registriert werden sollen         }

       symtablestack : psymtable;  { Wurzel der verketteten Liste von  }
                                   { Symboltabellen                    }

       srsym : psym;               { enthlt das Ergebnis der letzten  }
       srsymtable : psymtable;     { Suche nach einem Symbol           }

       forwardsallowed : boolean;  { true, wenn Pointertypen "forward" }
                                   { eingefgt werden drfen           }

       constsymtable : psymtable;  { Symboltabelle in die die          }
                                   { Konstanten von z.B. Aufzhlungs-  }
                                   { typen eingefgt werden            }

       voiddef : porddef;          { Zeiger auf eine void-Definition   }
                                   { wird von quelltext initialisiert  }
                                   { (ist resulttype einer Procedure)  }
       voidpointerdef : ppointerdef;
                                   { Zeiger auf "void"-Pointerdef      }

       s32bitdef : porddef;        { Zeiger fr resulttype von         }
                                   { intconstn                         }

       u8bitdef : porddef;         { Pointer auf 8-Bit unsigned        }
       u16bitdef : porddef;        { Pointer auf 8-Bit unsigned        }

       c64floatdef : pfloatdef;    { Zeiger fr resulttype von         }
                                   { realconstn                        }

       s80floatdef : pfloatdef;    { pointer to type of temp. floats   }

       s32fixeddef : pfloatdef;    { pointer to type of temp. fixed    }

       cstringdef : pstringdef;    { Zeiger fr resulttype von         }
                                   { stringconstn                      }

       cchardef : porddef;       { Zeiger fr resulttype von         }
                                   { charconstn                        }

       { uses for stabs }
       firstglobaldef, lastglobaldef : pdef;

       class_tobject : pobjectdef; { pointer to the anchestor of all   }
                                   { clases                            }

       booldef : porddef;        { pointer to boolean type           }

       aktprocsym : pprocsym;      { Zeiger auf den Symboltablellen-   }
                                   { eintrag der momentan geparseten   }
                                   { procedure                         }

       procprefix : string;        { eindeutige Namen bei geschachtel- }
                                   { ten Unterprogrammen erzeugen      }

       lexlevel : word;            { Stufen von verschachtelten        }
                                   { Unterprogrammen                   }

       macros : psymtable;         { Zeiger auf die Symboltabelle mit  }
                                   { Makros                            }

       read_member : boolean;      { true, wenn Members aus einer PPU-  }
                                   { Datei gelesen werden, d.h. ein     }
                                   { varsym seine Adresse einlesen soll }

       generrorsym : psym;         { Jokersymbol, wenn das richtige    }
                                   { Symbol nicht gefunden wird        }

       generrordef : pdef;         { Jokersymbol fr eine fehlerhafte  }
                                   { Typdefinition                     }

       commandlinedefines : tlinkedlist;  { this list contains the defines      }
                                          { from the command line, this defines }
       {
         !!!! overloaded_operators : array[PLUS..last_overloaded] of pprocsym;
       }
       overloaded_operators : array[0..0] of pprocsym;


{$ifdef GDB}
    const
       use_gsym : boolean = false;
    function typeglobalnumber(const s : string) : string;
{$endif * GDB *}

    function globaldef(const s : string) : pdef;

       { pointer to the system unit, if the system unit is loaded }
   const systemunit : psymtable = nil;
       use_dbx : boolean = false;


implementation

    var
       aktrecordsymtable : psymtable; { zeigt auf die Symboltabelle des }
                                      { Records, das momentan aus einer }
                                      { PPU-Datei gelesen wird          }


   {to dispose the global symtable of a unit }
const
   dispose_global: boolean =false;
    tagtypes : Set of tdeftype =
      [recorddef,aufzaehldef,
      {$IfNDef GDBKnowsStrings}
      stringdef,
      {$EndIf not GDBKnowsStrings}
      {$IfNDef GDBKnowsFiles}
      filedef,
      {$EndIf not GDBKnowsFiles}
      objectdef];


    var
       { this is for a faster execution }
       ppufile : tbufferedfile;

    procedure writebyte(b : byte);

      begin
         ppufile.write_data(b,1);
      end;

    procedure writelong(l : longint);

      begin
         ppufile.write_data(l,4);
      end;

    procedure writedouble(d : double);

      begin
         ppufile.write_data(d,8);
      end;

    procedure writeword(w : word);

      begin
         ppufile.write_data(w,2);
      end;

    procedure writestring(s : string);

      begin
         ppufile.write_data(s,length(s)+1);
      end;

    procedure writedefref(p : pdef);

      begin
         if p=nil then
           writelong($ffffffff)
         else
           begin
              if (p^.owner^.symtabletype=recordsymtable) or
                 (p^.owner^.symtabletype=objectsymtable) then
                writeword($ffff)
              else writeword(p^.owner^.unitid);
              writeword(p^.number);
           end;
      end;

    function writeunitas(const s : string;unitsymtable : punitsymtable) : longint;

      var
         l : longint;

      begin
         comment(v_used,'Writing '+s);

         ppufile.init(s,32768);
         ppufile.rewrite;
         if ioresult<>0 then
           fatalerror(cannot_write_unitfile);

         unitheader[8]:=char(byte(target_info.target));
         if use_dbx then
           current_module^.flags:= current_module^.flags or uf_uses_dbx;
         unitheader[9]:=char(current_module^.flags);

         ppufile.write_data(unitheader,sizeof(unitheader));
         ppufile.clear_crc;
         ppufile.do_crc:=true;
         unitsymtable^.writeasunit;
         ppufile.flush;

         ppufile.do_crc:=false;

         { writes the checksum }
         ppufile.seek(10);
         l:=ppufile.getcrc;
         ppufile.write_data(l,4);

         { set new crc }
         current_module^.crc:=l;

         ppufile.flush;

         {
         writeunitas:=filesize(unitfile);
         }
         ppufile.done;
      end;

    function readbyte : byte;

      var
         count : longint;
         b : byte;

      begin
         current_module^.ppufile^.read_data(b,1,count);
         readbyte:=b;
         if count<>1 then
           fatalerror(error_reading_unit);
      end;

    function readword : word;

      var
         count : longint;
         w : word;

      begin
         current_module^.ppufile^.read_data(w,2,count);
         readword:=w;
         if count<>2 then
           fatalerror(error_reading_unit);
      end;

    function readlong : longint;

      var
         count,l : longint;

      begin
         current_module^.ppufile^.read_data(l,4,count);
         readlong:=l;
         if count<>4 then
           fatalerror(error_reading_unit);
      end;

    function readdouble : double;

      var
         count : longint;
         d : double;

      begin
         current_module^.ppufile^.read_data(d,8,count);
         readdouble:=d;
         if count<>8 then
           fatalerror(error_reading_unit);
      end;

    function readstring : string;

      var
         s : string;
         count : longint;

      begin
         s[0]:=char(readbyte);
         current_module^.ppufile^.read_data(s[1],ord(s[0]),count);
         if count<>ord(s[0]) then
           fatalerror(error_reading_unit);
         readstring:=s;
      end;

    function readdefref : pdef;

      var
         hd : pdef;

      begin
         longint(hd):=readword;
         longint(hd):=longint(hd) or (longint(readword) shl 16);
         readdefref:=hd;
      end;

    procedure resolvedef(var d : pdef);

      begin
         if longint(d)=$ffffffff then
           d:=nil
         else
           begin
              if (longint(d) and $ffff)=$ffff then
                d:=aktrecordsymtable^.getdefnr(longint(d) shr 16)
              else
                d:=psymtable(current_module^.map^[longint(d) and $ffff])^.getdefnr(longint(d) shr 16);
           end;
      end;

{$I+}
    procedure getsym(const s : stringid;notfounderror : boolean);

      begin
         srsymtable:=symtablestack;
         while assigned(srsymtable) do
           begin
              srsym:=srsymtable^.search(s);
              if assigned(srsym) then exit
               else srsymtable:=srsymtable^.next;
           end;
         if forwardsallowed then
           begin
              srsymtable:=symtablestack;
              srsym:=new(ptypesym,init(s,nil));
              srsym^.forwarddef:=true;
              srsymtable^.insert(srsym);
           end
         else if notfounderror then
           begin
              exterror:=strpnew(s);
              error(id_not_found);
              srsym:=generrorsym;
           end
         else srsym:=nil;
      end;

    procedure getsymonlyin(p : psymtable;const s : stringid);

      begin
         srsymtable:=p;
         srsym:=srsymtable^.search(s);
         if assigned(srsym) then exit
         else fatalerror(id_not_found);
      end;

    procedure dellexlevel;

      var
         p : psymtable;

      begin
         p:=symtablestack;
         symtablestack:=p^.next;

         { symbol tables of unit interfaces are never disposed }
         { this is handle by the unit unitm                    }
         if ((p^.symtabletype<>unitsymtable) and
           (p^.symtabletype<>globalsymtable)) or
           dispose_global then
           dispose(p,done);
      end;

    constructor tprocsym.init(const n : string);

      begin
         tsym.init(n);
         typ:=procsym;
         definition:=nil;
{$ifdef GDB}
         is_global := false;
{$endif GDB}
      end;

    constructor tprocsym.load;

      begin
         tsym.load;
         typ:=procsym;
         definition:=pprocdef(readdefref);
{$ifdef GDB}
         is_global := false;
{$endif GDB}
      end;

    destructor tprocsym.done;

      begin
         check_forward;
         tsym.done;
      end;

    function tprocsym.mangledname : string;
      begin
         mangledname:=definition^.mangledname;
      end;

    procedure tprocsym.check_forward;

      var
         pd : pprocdef;

      begin
         pd:=definition;
         while assigned(pd) do
           begin
              if pd^.forwarddef then
                begin
{$ifdef GDB}
                   if assigned(pd^._class) then
                     exterror := strpnew(pd^._class^.name^+'.'+name)
                     else
{$endif GDB}
                     exterror:=strpnew(name);
                   error(forward_not_resolved);
                end;
              pd:=pd^.nextoverloaded;
           end;
      end;

    procedure tprocsym.deref;

      begin
         resolvedef(pdef(definition));
      end;

    constructor tprogramsym.init(const n : string);

      begin
         tsym.init(n);
         typ:=programsym;
      end;

    constructor tsymtable.init(t : word);

      var
         w : word;

      begin
         symtabletype:=t;
         wurzel:=nil;
{$ifdef GDB}
         defowner:=nil;
         unitid:=0;
{$endif GDB}
         next:=nil;
         name:=nil;
         call_offset:=0;
         if symtabletype=objectsymtable then
           datasize:=4
         else
           datasize:=0;
         wurzeldef:=nil;
         hasharray:=nil;
      end;

    constructor tunitsymtable.init(t : word; const n : string);

      var
         w : word;

      begin
         tsymtable.init(t);
         name:=stringdup(n);
{$ifdef GDB}
         if t = globalsymtable then
           begin
              prev_dbx_counter := dbx_counter;
              dbx_counter := @dbx_count;
           end;
         dbx_count := 0;
         unitid:=0;
{$endif GDB}
         new(hasharray);
         for w:=0 to hasharraysize-1 do
           hasharray^[w]:=nil;
         is_stab_written:=false;
{$ifdef GDB}
        if use_dbx then
          begin
             if (symtabletype=globalsymtable) then
               pglobaltypecount := @unittypecount;
             debuglist^.concat(new(pai_stabs,init(strpnew('"'+name^+'",'
                  +tostr(N_BINCL)+',0,0,0'))));
             unitid:=current_module^.unitcount;
             inc(current_module^.unitcount);
             debuglist^.concat(new(pai_direct,init(strpnew('# Global '+name^+' has index '+
                  +tostr(unitid)))));
          end;
{$endif GDB}
      end;

    constructor tsymtable.load;

      var
         hp : pdef;
         b : byte;
         counter : word;
         sym : psym;
{$ifndef GDB}

{$else * GDB *}
         {to know where the unit is }
         dir : string;
{$endif * GDB *}
      begin
         current_module^.map^[0]:=@self;

         symtabletype:=unitsymtable;

         { unused for units }
         call_offset:=0;

         { reset hash array }
         new(hasharray);
         for counter:=0 to hasharraysize-1 do
            hasharray^[counter]:=nil;

         datasize:=0;
         wurzel:=nil;
         next:=nil;
         wurzeldef:=nil;

{$ifdef GDB}
         unitid:=0;
         defowner:=nil;
{$endif GDB}

         { read the definitions }
         counter:=0;
         repeat
           b:=readbyte;
           case b of
              ibpointerdef : hp:=new(ppointerdef,load);
              ibarraydef : hp:=new(parraydef,load);
              iborddef : hp:=new(porddef,load);
              ibfloatdef : hp:=new(pfloatdef,load);
              ibprocdef : hp:=new(pprocdef,load);
              ibstringdef : hp:=new(pstringdef,load);
              ibrecorddef : hp:=new(precdef,load);
              ibobjectdef : begin
                               hp:=new(pobjectdef,load);
                               { defines the VMT external                }
                               { owner isn't set in the constructor load }
                               externals^.concat(new(pai_external,init('VMT_'+name^+'$_'+pobjectdef(hp)^.name^)));
                            end;
              ibfiledef : hp:=new(pfiledef,load);
              ibformaldef : hp:=new(pformaldef,load);
              ibaufzaehldef : hp:=new(paufzaehldef,load);
              { ibinitunit : usedunits^.insert(readstring); }
              iblinkofile : linkofiles.insert(readstring);
              ibsetdef : hp:=new(psetdef,load);
              ibprocvardef : hp:=new(pprocvardef,load);
              ibend : break;
              else fatalerror(malformed_unit);
           end;

           if (b<>ibloadunit) and (b<>ibinitunit) and (b<>iblinkofile) then
             begin
                { each definition get a number }
                hp^.number:=counter;
                inc(counter);

                hp^.next:=wurzeldef;
                wurzeldef:=hp;
             end;
         until false;

         { solve the references of the symbols }
         hp:=wurzeldef;

         { for each definition }
         while assigned(hp) do
           begin
              hp^.deref;

              { insert also the owner }
              hp^.owner:=@self;

              hp:=hp^.next;
           end;

         { read the symbols }
         repeat
           b:=readbyte;
           case b of
              ibtypesym : sym:=new(ptypesym,load);
              ibprocsym : sym:=new(pprocsym,load);
              ibconstsym : sym:=new(pconstsym,load);
              ibvarsym : sym:=new(pvarsym,load);
              ibaufzaehlsym : sym:=new(paufzaehlsym,load);
              ibtypedconstsym : sym:=new(ptypedconstsym,load);
              ibend : break;
              else fatalerror(malformed_unit);
           end;
           sym^.deref;
           insert(sym);
         until false;
      end;

    constructor tunitsymtable.load(const n : string);

      var storeGlobalTypeCount : pword;
          b : byte;
      begin
         name:=stringdup(n);
         unitid:=0;
         dbx_count := 0;
         if (current_module^.flags and uf_uses_dbx)<>0 then
           begin
              storeGlobalTypeCount:=PGlobalTypeCount;
              PglobalTypeCount:=@UnitTypeCount;
           end;
         inherited load;
         if (current_module^.flags and uf_uses_dbx)<>0 then
           begin
              b := readbyte;
              if b <> ibdbxcount then
                begin
                   exterror:=strpnew('DBX count problem');
                   fatalerror(malformed_unit);
                end
              else
                begin
                   dbx_count := readlong;
                end;
              writeln('Unit ',name^,' has dbx count = ',dbx_count);
              dbx_count_ok := true;
              b := readbyte;
              if b <> ibend then
                fatalerror(malformed_unit);
              PGlobalTypeCount:=storeGlobalTypeCount;
           end;
         is_stab_written:=false;
      end;

    constructor tsymtable.loadasstruct(typ : word);

      var
         hp : pdef;
         b : byte;
         counter : word;
         sym : psym;

      begin
         symtabletype:=typ;
         hasharray:=nil;
         aktrecordsymtable:=@self;
         name:=nil;
         if symtabletype=objectsymtable then
           datasize:=4
         else
           datasize:=0;
         { isn't used there }
         call_offset := 0;
         wurzel:=nil;
         next:=nil;
         wurzeldef:=nil;
         { also unused }
         unitid:=0;

         { read definitions }
         counter:=0;
         repeat
           b:=readbyte;
           case b of
              ibpointerdef : hp:=new(ppointerdef,load);
              ibarraydef : hp:=new(parraydef,load);
              iborddef : hp:=new(porddef,load);
              ibfloatdef : hp:=new(pfloatdef,load);
              ibprocdef : hp:=new(pprocdef,load);
              ibstringdef : hp:=new(pstringdef,load);
              ibrecorddef : hp:=new(precdef,load);
              ibobjectdef : hp:=new(pobjectdef,load);
              ibaufzaehldef : hp:=new(paufzaehldef,load);
              ibsetdef : hp:=new(psetdef,load);
              ibprocvardef : hp:=new(pprocvardef,load);
              ibfiledef : hp:=new(pfiledef,load);
              ibformaldef : hp:=new(pformaldef,load);
              ibend : break;
              else fatalerror(malformed_unit);
           end;

           { each def gets a number }
           hp^.number:=counter;
           inc(counter);
           hp^.next:=wurzeldef;
           wurzeldef:=hp;
         until false;
         { dereferenziert wird erst in trecdef^.deref }
         { nun Symbole einlesen }
         repeat
           b:=readbyte;
           case b of
              ibtypesym : sym:=new(ptypesym,load);
              ibprocsym : sym:=new(pprocsym,load);
              ibconstsym : sym:=new(pconstsym,load);
              ibvarsym : sym:=new(pvarsym,load);
              ibaufzaehlsym : sym:=new(paufzaehlsym,load);
              ibtypedconstsym : sym:=new(ptypedconstsym,load);
              ibend : break;
              else fatalerror(malformed_unit);
           end;
           insert(sym);
         until false;
      end;

    destructor tsymtable.done;

      var
         hp : pdef;
{$ifdef GDB}
         last : pdef;
{$endif * GDB *}
      begin
         { erst die Eintrge loeschen, da procsym's noch ihre Definitionen }
         { auf unaufgelste "forwards" ueberpruefen                        }
         clear;
{$ifdef GDB}
         stringdispose(name);
{$endif * GDB *}
         hp:=wurzeldef;
{$ifdef GDB}
         last := Nil;
{$endif * GDB *}
         while assigned(hp) do
           begin
{$ifdef GDB}
              if hp^.owner=@self then
                begin
                if assigned(last) then last^.next := hp^.next;
{$endif * GDB *}
              wurzeldef:=hp^.next;
              dispose(hp,done);
{$ifdef GDB}
                end else
                begin
                last := hp;
                wurzeldef:=hp^.next;
                end;
{$endif * GDB *}
              hp:=wurzeldef;
           end;

      end;

   function tsymtable.getnewtypecount : word;
      begin
         getnewtypecount:=pglobaltypecount^;
         inc(pglobaltypecount^);
      end;

   function tunitsymtable.getnewtypecount : word;

      begin
         if symtabletype = staticsymtable then
           getnewtypecount:=tsymtable.getnewtypecount
         else
           begin
              getnewtypecount:=unittypecount;
              inc(unittypecount);
           end;
      end;

    procedure check_procsym_forward(sym : psym);far;

      begin
         if sym^.typ=procsym then
           pprocsym(sym)^.check_forward
         { check also object method table             }
         { we needn't to test the def list            }
         { because each object has to have a type sym }
         else if (sym^.typ=typesym) and
           (ptypesym(sym)^.definition^.deftype=objectdef) then
           pobjectdef(ptypesym(sym)^.definition)^.check_forwards;
      end;

    { checks, if all procsyms }
    { and methods are defined }
    procedure tsymtable.check_forwards;

      begin
{$ifdef tp}
         foreach(check_procsym_forward);
{$else}
         foreach(@check_procsym_forward);
{$endif}
      end;

    function tsymtable.getdefnr(l : word) : pdef;

      var
         hp : pdef;

      begin
         hp:=wurzeldef;
         while (assigned(hp)) and (hp^.number<>l) do
           hp:=hp^.next;
         getdefnr:=hp;
      end;

    procedure tsymtable.registerdef(p : pdef);

      begin
         p^.next:=wurzeldef;
         wurzeldef:=p;
         p^.owner:=@self;
      end;

    procedure tsymtable.clear;

      var
         w : integer;

      begin
         { remove all entry from a symbol table }
         if assigned(wurzel) then
           dispose(wurzel,done);
         if assigned(hasharray) then
           begin
              for w:=0 to hasharraysize-1 do
                if assigned(hasharray^[w]) then
                  dispose(hasharray^[w],done);
              dispose(hasharray);
           end;
      end;

    function getspeedvalue(const s : string) : longint;

      var
         l : longint;
         w : word;

      begin
         l:=0;
         for w:=1 to length(s) do
           l:=l+ord(s[w]);
         getspeedvalue:=l;
      end;

    procedure tsymtable.insert(sym : psym);

      procedure _insert(var osym : psym);

        begin
           if osym=nil then
                osym:=sym
           { speedvalue is used, to allow a fast insert }
           else if osym^.speedvalue>sym^.speedvalue then _insert(osym^.right)
           else if osym^.speedvalue<sym^.speedvalue then _insert(osym^.left)
           else
             begin
                if osym^.name>sym^.name then _insert(osym^.right)
                else if osym^.name<sym^.name then _insert(osym^.left)
                else
                  begin
                     if (osym^.typ=typesym) and osym^.forwarddef then
                       begin
                          if (sym^.typ<>typesym) then fatalerror(id_already_type);
                          if (ptypesym(sym)^.definition^.deftype<>recorddef) and
                             (ptypesym(sym)^.definition^.deftype<>objectdef) then
                             fatalerror(type_must_be_rec_or_class);
                          ptypesym(osym)^.definition:=ptypesym(sym)^.definition;
                          osym^.forwarddef:=false;
                          { resolve the definition right now !! }
                          ptypesym(osym)^.forwardpointer^.definition:=ptypesym(osym)^.definition;
{$ifndef GDB}
                          dispose(sym);
{$else * GDB *}
                          if ptypesym(osym)^.definition^.sym = ptypesym(sym) then
                            ptypesym(osym)^.definition^.sym := ptypesym(osym);
                         ptypesym(osym)^.isusedinstab := true;
                         if (cs_debuginfo in aktswitches) and assigned(debuglist) then
                            osym^.concatstabto(debuglist);
                          dispose(sym,done);
{$endif * GDB *}
                       end
                     else
                       begin
                          exterror:=strpnew(sym^.name);
                          error(dupid);
                       end;
                  end;
             end;
      end;

      var
         l : longint;
         hp : psymtable;
         hsym : psym;

      begin
         { bei Symbolen fr Variablen die Adresse eintragen, }
         { und Gre der Symboltabellendaten berechnen       }
{$ifdef GDB}
         sym^.owner:=@self;
{$endif * GDB *}
         if (sym^.typ=varsym) and not(read_member) then
           begin
              { check for instance of an abstract object or class }
              if (pvarsym(sym)^.definition^.deftype=objectdef) and
                ((pobjectdef(pvarsym(sym)^.definition)^.options and oois_abstract)<>0) then
                error(no_instance_of_abstract_object);

              { bei einer lokalen Symboltabelle erst! erhhen, da der }
              { Wert in codegen.secondload dann mit minus verwendet   }
              { wird                                                  }
              l:=pvarsym(sym)^.getsize;
              if (symtabletype and localsymtable)=localsymtable then
                begin
                   pvarsym(sym)^.is_valid := false;
                   inc(datasize,l);
                   if (l>=4) and ((datasize and 3)<>0) then
                     inc(datasize,4-(datasize and 3))
                   else if (l>=2) and ((datasize and 1)<>0) then
                     inc(datasize,2-(datasize and 1));

                   pvarsym(sym)^.adresse:=datasize;
                end
              else if (symtabletype and $3fff)=staticsymtable then
                begin
{$ifdef GDB}
                   if cs_debuginfo in aktswitches then
                     begin
                        sym^.concatstabto(bsssegment);
                     end;
{$endif * GDB *}
                   bsssegment^.concat(new(pai_datablock,init(sym^.mangledname,l)));
                   inc(datasize,l);

                   { this symbol can't be loaded to a register }
                   pvarsym(sym)^.regable:=false;
                end
              else if (symtabletype and $3fff)=globalsymtable then
                begin
{$ifdef GDB}
                   if cs_debuginfo in aktswitches then
                     begin
                        sym^.concatstabto(bsssegment);
                        { this has to be added so that the debugger knows where to find
                          the global variable
                          Doesn't work !!
                        }
                        bsssegment^.concat(new(pai_symbol,init('_'+sym^.name)));
                     end;
{$endif * GDB *}
                   bsssegment^.concat(new(pai_datablock,init_global(
                     sym^.mangledname,l)));
                   inc(datasize,l);

                   { this symbol can't be loaded to a register }
                   pvarsym(sym)^.regable:=false;
                end
              else if ((symtabletype and $3fff)=recordsymtable) or
                      ((symtabletype and $3fff)=objectsymtable) then
                begin
                   { align record and object fields }
                   if aktpackrecords=2 then
                     begin
                        { align to word }
                        if (l>=2) and ((datasize and 1)<>0) then
                          inc(datasize);
                     end
                   else if aktpackrecords=4 then
                     begin
                        { align to dword }
                        if (l>=3) and ((datasize and 3)<>0) then
                          inc(datasize,4-(datasize and 3))
                        { or word }
                        else if (l=2) and ((datasize and 1)<>0) then
                          inc(datasize)
                     end;
                   pvarsym(sym)^.adresse:=datasize;
                   inc(datasize,l);

                   { this symbol can't be loaded to a register }
                   pvarsym(sym)^.regable:=false;
                end
              else if (symtabletype and parasymtable)=parasymtable then
                begin
                   pvarsym(sym)^.adresse:=datasize;

                   { intel processors don't know a byte push, }
                   { so is always a word pushed               }
                   if l=1 then
                     l:=2;
                   inc(datasize,l);
                end
              else
                begin
                   if (l>=4) and ((datasize and 3)<>0) then
                     inc(datasize,4-(datasize and 3))
                   else if (l>=2) and ((datasize and 1)<>0) then
                     inc(datasize,2-(datasize and 1));
                   pvarsym(sym)^.adresse:=datasize;
                   inc(datasize,l);
                end;
           end
         else if sym^.typ=typedconstsym then
             begin
                if (symtabletype and $3fff)=globalsymtable then
                  begin
{$ifdef GDB}
                     if cs_debuginfo in aktswitches then
                       sym^.concatstabto(datasegment);
{$endif * GDB *}
                     datasegment^.concat(new(pai_symbol,init_global(sym^.mangledname)));
                  end
                else if not((symtabletype and $3fff)=unitsymtable) then
                  begin
{$ifdef GDB}
                     if cs_debuginfo in aktswitches then
                       sym^.concatstabto(datasegment);
{$endif * GDB *}
                     datasegment^.concat(new(pai_symbol,init(sym^.mangledname)));
                  end;
             end;
         if (symtabletype=staticsymtable) or
            (symtabletype=globalsymtable) then
           begin
              hp:=symtablestack;
              while assigned(hp) do
                begin
                   if (hp^.symtabletype and $3fff=staticsymtable) or
                      (hp^.symtabletype and $3fff=globalsymtable) then
                        begin
                           hsym:=hp^.search(sym^.name);
                           if (assigned(hsym)) and
                              not(hsym^.forwarddef) then
                              begin
                                 exterror:=strpnew(sym^.name);
                                 error(dupid);
                              end;
                        end;
                      hp:=hp^.next;
                end;
           end;
         if sym^.typ = typesym then
           if assigned(ptypesym(sym)^.definition) then
             begin
             if not assigned(ptypesym(sym)^.definition^.owner) then
              registerdef(ptypesym(sym)^.definition);
{$ifdef GDB}
             if (cs_debuginfo in aktswitches) and assigned(debuglist)
                and (symtabletype <> unitsymtable) then
                   begin
                   ptypesym(sym)^.isusedinstab := true;
                   sym^.concatstabto(debuglist);
                   end;
{$endif * GDB *}
             end;
         sym^.speedvalue:=getspeedvalue(sym^.name);
         if assigned(hasharray) then
           _insert(hasharray^[sym^.speedvalue mod hasharraysize])
         else
           _insert(wurzel);
      end;

    procedure varsymbolused(p : psym);far;

      begin
         if p^.typ=varsym then
           { unused symbol should be reported only if no }
           { error is reported                           }
           if (pvarsym(p)^.refs=0) and (errorcount=0) then
             begin
                exterror:=strpnew(p^.name);
                warning(symbol_not_used);
             end;
      end;

    procedure tsymtable.allsymbolsused;

      begin
{$ifdef tp}
         foreach(varsymbolused);
{$else}
         foreach(@varsymbolused);
{$endif}
      end;

{$ifdef GDB}

      var l : paasmoutput;

      procedure concatstab(p : psym);far;
      begin
      if p^.typ <> procsym then
        p^.concatstabto(l);
      end;

      procedure concattypestab(p : psym);far;
      begin
      if p^.typ = typesym then
        begin
        p^.isstabwritten:=false;
        p^.concatstabto(l);
        end;
      end;

      procedure tsymtable.concatstabto(asmlist : paasmoutput);
      begin
      l := asmlist;
{$ifdef tp}
      foreach(concatstab);
{$else}
      foreach(@concatstab);
{$endif}
      end;

      procedure tunitsymtable.concattypestabto(asmlist : paasmoutput);
        var def : pdef;
          prev_dbx_count : plongint;
        begin
           if is_stab_written then exit;
           if not assigned(name) then name := stringdup('Main_program');
           if symtabletype = unitsymtable then
             begin
                unitid:=current_module^.unitcount;
                inc(current_module^.unitcount);
             end;
           asmlist^.concat(new(pai_direct,init(strpnew('# Begin unit '+name^
                  +' has index '+tostr(unitid)))));
           if use_dbx then
             begin
                if dbx_count_ok then
                  begin
                     asmlist^.insert(new(pai_direct,init(strpnew('# "repeated" unit '+name^
                              +' has index '+tostr(unitid)))));
                     do_count_dbx:=true;
                     asmlist^.concat(new(pai_stabs,init(strpnew('"'+name^+'",'
                       +tostr(N_EXCL)+',0,0,'+tostr(dbx_count)))));
                     exit;
                  end;
                prev_dbx_count := dbx_counter;
                dbx_counter := nil;
                if symtabletype = unitsymtable then
                  asmlist^.concat(new(pai_stabs,init(strpnew('"'+name^+'",'
                    +tostr(N_BINCL)+',0,0,0'))));
                dbx_counter := @dbx_count;
             end;
           l:=asmlist;
{$ifdef tp}
           foreach(concattypestab);
{$else}
           foreach(@concattypestab);
{$endif}
           if use_dbx then
             begin
                dbx_counter := prev_dbx_count;
                do_count_dbx:=true;
                asmlist^.concat(new(pai_stabs,init(strpnew('"'+name^+'",'
                  +tostr(N_EINCL)+',0,0,0'))));
                dbx_count_ok := true;
             end;
           asmlist^.concat(new(pai_direct,init(strpnew('# End unit '+name^
                  +' has index '+tostr(unitid)))));
           is_stab_written:=true;
        end;

    procedure forcestabto(asmlist : paasmoutput; pd : pdef);
    begin
    if not pd^.isstabwritten then
      begin
      if assigned(pd^.sym) then
        pd^.sym^.isusedinstab := true;
      pd^.concatstabto(asmlist);
      end;
    end;

{$endif GDB}

    function tsymtable.search(const s : stringid) : psym;

      var
         hp : psym;
         w : word;
         speedvalue : longint;

      begin
         speedvalue:=getspeedvalue(s);
         if assigned(hasharray) then
           hp:=hasharray^[speedvalue mod hasharraysize]
         else
           hp:=wurzel;
         while assigned(hp) do
           begin
              if speedvalue>hp^.speedvalue then hp:=hp^.left
              else if speedvalue<hp^.speedvalue then hp:=hp^.right
              else
                begin
                   if hp^.name=s then
                     begin
                        search:=hp;
                        exit;
                     end
                  else if s>hp^.name then hp:=hp^.left
                  else hp:=hp^.right;
                end;
           end;
         search:=nil;
      end;

    procedure tsymtable.foreach(proc2call : tcallback);

      procedure a(p : psym);

        { must be preorder, because it's used by reading in }
        { a PPU file                                        }
        begin
           proc2call(p);
           if assigned(p^.left) then a(p^.left);
           if assigned(p^.right) then a(p^.right);
        end;

      var
         i : integer;

      begin
         if hasharray<>nil then
           begin
              for i:=0 to hasharraysize-1 do
                if assigned(hasharray^[i]) then
                  a(hasharray^[i]);
           end
         else
           if assigned(wurzel) then
             a(wurzel);
      end;

    { write one symbol, is only used as call back procedure }
    procedure writesym(p : psym);far;

      begin
         p^.write;
      end;

    procedure tsymtable.number_units;

      var
         counter : word;
         p : psymtable;

     begin
         unitid:=0;

         { zuerst alle im Interface-Abschnitt aufgefhrten Units }
         { in die Datei schreiben und numerieren }
         p:=next;
         counter:=1;

         { im Implementationsteil aufgefuehrte Units ueberspringen }
         if symtabletype<>globalsymtable then
           begin
              while (p^.symtabletype<>globalsymtable) do
                p:=p^.next;
              p:=p^.next;
           end;
         while assigned(p) do
           begin
              if p^.symtabletype=unitsymtable then
                begin
                   p^.unitid:=counter;
                   inc(counter);
                end;
              p:=p^.next;
           end;

      end;

    procedure tsymtable.number_defs;

      var
         pd,ppd : pdef;
         counter : longint;

      begin
         counter:=0;
         pd:=wurzeldef;
         while assigned(pd) do
           begin
              pd^.number:=counter;
              inc(counter);
              pd:=pd^.next;
           end;
      end;

{$ifdef GDB }
    procedure tunitsymtable.orderdefs;
      var
         first, last, nonum, pd, cur, prev, lnext : pdef;

      begin
         pd:=wurzeldef;
         first:=nil;
         last:=nil;
         nonum:=nil;
         while assigned(pd) do
           begin
              lnext:=pd^.next;
              if pd^.globalnb > 0 then
                if first = nil then
                  begin
                     first:=pd;
                     last:=pd;
                     last^.next:=nil;
                  end
                else
                  begin
                     cur:=first;
                     prev:=nil;
                     while assigned(cur) and
                           (prev <> last) and
                           (cur^.globalnb>0) and
                           (cur^.globalnb<pd^.globalnb) do
                       begin
                          prev:=cur;
                          cur:=cur^.next;
                       end;
                     if cur = first then
                       begin
                          pd^.next:=first;
                          first:=pd;
                       end
                     else
                     if prev = last then
                       begin
                          pd^.next:=nil;
                          last^.next:=pd;
                          last:=pd;
                       end
                     else
                       begin
                          pd^.next:=cur;
                          prev^.next:=pd;
                       end;
                  end
                else  { without number }
                  begin
                     pd^.next:=nonum;
                     nonum:=pd;
                  end;
              pd:=lnext;
           end;
         if assigned(first) then
           begin
              wurzeldef:=first;
              last^.next:=nonum;
           end else
           wurzeldef:=nonum;
      end;
{$endif GDB }

    procedure tunitsymtable.writeasunit;

      var
         counter : word;
         hp : pused_unit;
         hp2 : pextfile;
         s : string;

      begin
         { first write the used source files }
         hp2:=current_module^.sourcefiles.files;
         while assigned(hp2) do
           begin
              writebyte(ibsourcefile);

              { only name and extension }
              writestring(hp2^.name^+hp2^.ext^);
              hp2:=hp2^._next;
           end;

         writebyte(ibend);

         unitid:=0;

         { each used unit gets a number }
         counter:=1;

         { ... and write interface units with their number and checksum }
         hp:=pused_unit(current_module^.used_units.first);
         while assigned(hp) do
           begin
              if hp^.in_interface then
                begin
                  psymtable(hp^.u^.symtable)^.unitid:=counter;
                  inc(counter);
                  writebyte(ibloadunit);
                  writestring(psymtable(hp^.u^.symtable)^.name^);
                  writelong(hp^.u^.crc);
                end;
              hp:=pused_unit(hp^.next);
           end;

         writebyte(ibend);

         { writes the names of the units which should be init'ed
         s:=usedunits^.get;
         while s<>'' do
           begin
              writebyte(ibinitunit);
              writestring(s);
              s:=usedunits^.get;
           end;
         }
         s:=linkofiles.get;
         while s<>'' do
           begin
              writebyte(iblinkofile);
              writestring(s);
              s:=linkofiles.get;
           end;
         tsymtable.write;
         if use_dbx then
           begin
              writebyte(ibdbxcount);
              writelong(dbx_count);
{$IfDef EXTDEBUG}
              writeln('Writing dbx_count ',dbx_count,' in unit ',name^,'.ppu');
{$ENDIF EXTDEBUG}
              writebyte(ibend);
           end;
         { ... and write implementation units with their number and checksum }
         hp:=pused_unit(current_module^.used_units.first);
         while assigned(hp) do
           begin
              if not hp^.in_interface then
                begin
                  psymtable(hp^.u^.symtable)^.unitid:=counter;
                  inc(counter);
                  writebyte(ibloadunit);
                  writestring(psymtable(hp^.u^.symtable)^.name^);
                  {this remains a problem : the crc is not calculted yet ! }
                  writelong(hp^.u^.crc);
                end;
              hp:=pused_unit(hp^.next);
           end;

         writebyte(ibend);

      end;

    procedure tsymtable.writeasstruct;

      begin
         tsymtable.write;
      end;

    procedure tsymtable.write;

      var
         pd : pdef;

      begin
         { each definition get a number ... }
         number_defs;
         { ...now write the definition }
         pd:=wurzeldef;
         while assigned(pd) do
           begin
              pd^.write;
              pd:=pd^.next;
           end;

         { the next part are the symbols }
         writebyte(ibend);

         { foreach is used to write all symbols }

         { FPKPascal needs a little bit other syntax }
{$ifdef tp}
         foreach(writesym);
{$else}
         foreach(@writesym);
{$endif}
         { end of symbols }
         writebyte(ibend);
      end;

{**************************************
              "forward"-pointer
 **************************************}

    type
       presolvelist = ^tresolvelist;

       tresolvelist = record
          p : ppointerdef;
          typ : ptypesym;
          next : presolvelist;
       end;

    var
       swurzel : presolvelist;

{$ifdef GDB}
    procedure clear_forwards;

      var
         p : presolvelist;

      begin
         p:=swurzel;
         while assigned(p) do
         begin
              swurzel:=p^.next;
            dispose(p);
            p := swurzel;
         end;
      end;

{$endif * GDB *}
    procedure save_forward(ppd : ppointerdef;typesym : ptypesym);

      var
         p : presolvelist;

      begin
         new(p);
         p^.next:=swurzel;
         p^.p:=ppd;
         ppd^.defsym := typesym;
         p^.typ:=typesym;
         swurzel:=p;
      end;

    procedure resolve_forwards;

      var
         p : presolvelist;

      begin
         p:=swurzel;
         while p<>nil do
           begin
              swurzel:=swurzel^.next;
              p^.p^.definition:=p^.typ^.definition;
              dispose(p);
              p:=swurzel;
           end;
      end;

    constructor tsym.init(const n : string);

      begin
         left:=nil;
         right:=nil;
         setname(n);
         typ:=abstractsym;
         forwarddef:=false;
{$ifdef GDB}
         isstabwritten := false;
         if assigned(current_module) and assigned(current_module^.current_inputfile) then
           line_no:=current_module^.current_inputfile^.line_no
         else
           line_no:=0;
{$endif * GDB *}
      end;

    constructor tsym.load;

      begin
         left:=nil;
         right:=nil;
         setname(readstring);
         typ:=abstractsym;
         forwarddef:=false;
{$ifdef GDB}
         isstabwritten := false;
         line_no:=0;
{$endif * GDB *}
      end;

    destructor tsym.done;

      begin
{$ifdef tp}
         if not(use_big) then
{$endif tp}
           strdispose(_name);
         if assigned(left) then dispose(left,done);
         if assigned(right) then dispose(right,done);
      end;

    procedure tsym.write;

      begin
         writestring(name);
      end;

    procedure tsym.deref;

      begin
      end;

    function tsym.name : string;

      var
         s : string;
         b : byte;

      begin
{$ifdef tp}
         if use_big then
           begin
              symbolstream.seek(longint(_name));
              symbolstream.read(b,1);
              symbolstream.read(s[1],b);
              s[0]:=chr(b);
              name:=s;
           end
         else
{$endif}
           begin
              name:=strpas(_name);
           end;
      end;

    function tsym.mangledname : string;

      begin
         mangledname:=name;
      end;

    procedure tsym.setname(const s : string);

      begin
         setstring(_name,s);
      end;

{$ifdef GDB}
    function tsym.stabstring : pchar;

      begin
         stabstring:=strpnew('"'+name+'",'+tostr(N_LSYM)+',0,'+tostr(line_no)+',0');
      end;

    procedure tsym.concatstabto(asmlist : paasmoutput);

    var stab_str : pchar;
      begin
         if not isstabwritten then
           begin
              stab_str := stabstring;
              if asmlist = debuglist then do_count_dbx := true;
              { count_dbx(stab_str); moved to GDB.PAS }
              asmlist^.concat(new(pai_stabs,init(stab_str)));
              isstabwritten:=true;
          end;
    end;
{$endif * GDB *}

{**************************************
               TLABELSYM
 **************************************}

    constructor tlabelsym.init(const n : string;l : longint);

      begin
         inherited init(n);
         typ:=labelsym;
         number:=l;
         defined:=false;
      end;

    destructor tlabelsym.done;

      begin
         if not(defined) then
           begin
              exterror:=strpnew(name);
              error(label_not_defined);
           end;
         inherited done;
      end;

    function tlabelsym.mangledname : string;

      begin
         mangledname:=target_info.labelprefix+tostr(number);
      end;

    procedure tlabelsym.write;

      begin
         error(ill_label_pos);
      end;

{**************************************
               TUNITSYM
 **************************************}

    constructor tunitsym.init(const n : string;ref : psymtable);

      begin
         tsym.init(n);
         typ:=unitsym;
         unitsymtable:=ref;
      end;

    procedure tunitsym.write;

      begin
      end;

{$ifdef GDB}
    procedure tunitsym.concatstabto(asmlist : paasmoutput);
      begin
      {Nothing to write to stabs !}
      end;

{$endif * GDB *}

{**************************************
               TERRORSYM
 **************************************}

    constructor terrorsym.init;

      begin
         tsym.init('');
         typ:=errorsym;
      end;

{**************************************
               TABSOLUTESYM
 **************************************}

{   constructor tabsolutesym.init(const s : string;p : pdef;newref : psym);
     begin
        inherited init(s,p);
        ref:=newref;
        typ:=absolutesym;
     end; }

{$ifdef GDB}
    procedure tabsolutesym.concatstabto(asmlist : paasmoutput);

      begin
      { I don't know how to handle this !! }
      end;

{$endif * GDB *}
{**************************************
               TVARSYM
 **************************************}

    constructor tvarsym.init(const n : string;p : pdef);

      begin
         tsym.init(n);
         typ:=varsym;
         definition:=p;
         varspez:=vs_value;
         adresse:=0;
         refs:=0;
         is_valid := true;
         { can we load the value into a register ? }
         case p^.deftype of
            pointerdef,aufzaehldef,procvardef : regable:=true;
            orddef : case porddef(p)^.typ of
                          u8bit,s32bit,bool8bit,uchar,
                          s8bit,s16bit,u16bit,u32bit : regable:=true;
                          else regable:=false;
                       end;
            else regable:=false;
         end;
         reg:=R_NO;
      end;

    constructor tvarsym.load;

      begin
         tsym.load;
         typ:=varsym;
         varspez:=tvarspez(readbyte);
         if read_member then
           adresse:=readlong
         else adresse:=0;
         definition:=readdefref;
         refs := 0;
         is_valid := true;
         { symbols which are load are never candidates for a register }
         regable:=false;
         reg:=R_NO;
      end;

    procedure tvarsym.deref;

      begin
         resolvedef(definition);
      end;

    procedure tvarsym.write;

      begin
         writebyte(ibvarsym);
         tsym.write;
         writebyte(byte(varspez));

         if read_member then
           writelong(adresse);

         writedefref(definition);
      end;

    function tvarsym.mangledname : string;

      var prefix : string;
      begin
         case owner^.symtabletype of
           staticsymtable : prefix:='_';
           unitsymtable,globalsymtable : prefix:='U_'+owner^.name^+'_';
           else
             begin
                exterror:=strpnew('invalid call to tvarsym.mangledname');
                error(user_defined);
             end;
           end;
         mangledname:=prefix+name;
      end;

{$ifdef GDB}
    function tvarsym.stabstring : pchar;
    var st : char;
    begin
    {case varspez of}
    if owner^.symtabletype = globalsymtable then
      begin
      {Here we used S instead of G
      because with G GDB doesn't look at the address field
      but searches the same name or with a leading underscore
      but these names don't exist in pascal !}
      if use_gsym then st := 'G' else st := 'S';
      stabstring := strpnew('"'+name+':'+st
               +definition^.numberstring+'",'+
               tostr(N_LCSYM)+',0,'+tostr(line_no)+','+mangledname);
      end else
    if owner^.symtabletype = staticsymtable then
      begin
      stabstring := strpnew('"'+name+':S'
               +definition^.numberstring+'",'+
               tostr(N_LCSYM)+',0,'+tostr(line_no)+','+mangledname);
      end else
      if (owner^.symtabletype and parasymtable)<>0 then
        begin
        case varspez of
         vs_value : st := 'p';
         vs_var   : st := 'v';
         vs_const : st := 'v';{ should be 'i' but 'i' doesn't work }
         end;
        stabstring := strpnew('"'+name+':'+st
               +definition^.numberstring+'",'+
               tostr(N_PSYM)+',0,'+tostr(line_no)+','+tostr(adresse+owner^.call_offset))
               {offset to ebp}
      end else
      if (owner^.symtabletype and localsymtable)<>0 then
        stabstring := strpnew('"'+name+':'
               +definition^.numberstring+'",'+
               tostr(N_LSYM)+',0,'+tostr(line_no)+',-'+tostr(adresse))
      else
      if owner^.symtabletype = unitsymtable then
        begin
      {Here we used S instead of G
      because with G GDB doesn't look at the address field
      but searches the same name or with a leading underscore
      but these names don't exist in pascal !}
        if use_gsym then st := 'G' else st := 'S';
        stabstring := strpnew('"'+name+':'+st+
               +definition^.numberstring+'",'+
               tostr(N_LCSYM)+',0,'+tostr(line_no)+','+mangledname)
      end else
      stabstring := inherited stabstring;
    end;

{$endif * GDB *}
    function tvarsym.getsize : longint;

      begin
         { only if the definition is set, we could determine the   }
         { size, this is if an error occurs while reading the type }
         if assigned(definition) then
           begin
              case varspez of
                 vs_value : getsize:=definition^.size;
                 vs_var : getsize:=4;
                 vs_const : begin
                               if (definition^.deftype=stringdef) or
                                  (definition^.deftype=arraydef) or
                                  (definition^.deftype=recorddef) or
                                  (definition^.deftype=objectdef) or
                                  (definition^.deftype=setdef) then
                                  getsize:=4
                                else
                                  getsize:=definition^.size;
                            end;
              end;
           end;
      end;

{**************************************
               TTYPEDCONSTSYM
 **************************************}

    constructor ttypedconstsym.init(const n : string;p : pdef);

      begin
         tsym.init(n);
         typ:=typedconstsym;
         definition:=p;
         prefix:=stringdup(procprefix);
      end;

    constructor ttypedconstsym.load;

      begin
         tsym.load;
         typ:=typedconstsym;
         definition:=readdefref;
         prefix:=stringdup(readstring);
      end;

    destructor ttypedconstsym.done;

      begin
         stringdispose(prefix);
         tsym.done;
      end;

    function ttypedconstsym.mangledname : string;

      begin
         mangledname:='TC_'+prefix^+'_'+name;
      end;

    procedure ttypedconstsym.deref;

      begin
         resolvedef(definition);
      end;

    procedure ttypedconstsym.write;

      begin
         writebyte(ibtypedconstsym);
         tsym.write;
         writedefref(definition);
         writestring(prefix^);
      end;

{$ifdef GDB}
    function ttypedconstsym.stabstring : pchar;
    var st : char;
    begin
    if use_gsym and ((owner^.symtabletype = unitsymtable)
      or (owner^.symtabletype = globalsymtable)) then
       st := 'G' else st := 'S';
    stabstring := strpnew('"'+name+':'+st
            +definition^.numberstring+'",'+tostr(n_STSYM)+',0,'+tostr(line_no)+','+mangledname);
    end;
{$endif * GDB *}

{**************************************
               TCONSTSYM
 **************************************}

    constructor tconstsym.init(const n : string;t : tconsttype;v : longint;def : pdef);

      begin
         tsym.init(n);
         typ:=constsym;
         definition:=def;
         consttype:=t;
         value:=v;
      end;

    constructor tconstsym.load;

      var
         pd : pdouble;

      begin
         tsym.load;
         typ:=constsym;
         consttype:=tconsttype(readbyte);
         case consttype of
            constint,
            constbool,
            constchar : value:=readlong;
            constord : begin
                          definition:=readdefref;
                          value:=readlong;
                       end;
            conststring : value:=longint(stringdup(readstring));
            constreal : begin
                           new(pd);
                           pd^:=readdouble;
                           value:=longint(pd);
                        end;
         else fatalerror(malformed_unit);
         end;
      end;

{$ifdef GDB}
    destructor tconstsym.done;
      begin
      if consttype = conststring then stringdispose(pstring(value));
      inherited done;
      end;

{$endif * GDB *}
    function tconstsym.mangledname : string;

      begin
         exterror:=strpnew('invalid call to tconstsym.mangledname');
         error(user_defined);
         mangledname:=name;
      end;

    procedure tconstsym.deref;

      begin
         if consttype=constord then
           resolvedef(pdef(definition));
      end;

    procedure tconstsym.write;

      begin
         writebyte(ibconstsym);
         tsym.write;
         writebyte(byte(consttype));
         case consttype of
            constint,
            constbool,
            constchar : writelong(value);
            constord : begin
                          writedefref(definition);
                          writelong(value);
                       end;
            conststring : writestring(pstring(value)^);
            constreal : writedouble(pdouble(value)^);
            else internalerror(13);
         end;
      end;

{$ifdef GDB}
    function tconstsym.stabstring : pchar;
    var st : string;
    begin
         {even GDB v4.16 only now 'i' 'r' and 'e' !!!}
         case consttype of
            conststring : begin
                          { I had to remove ibm2ascii !! }
                          st := pstring(value)^;
                          {st := ibm2ascii(pstring(value)^);}
                          st := 's'''+st+'''';
                          end;
            constbool, constint, constord, constchar : st := 'i'+tostr(value);
            constreal : begin
                        system.str(pdouble(value)^,st);
                        st := 'r'+st;
                        end;
	    end;
    stabstring := strpnew('"'+name+':c='+st+'",'+tostr(N_function)+',0,'+tostr(line_no)+',0');
    end;

    procedure tconstsym.concatstabto(asmlist : paasmoutput);

    begin
       if consttype <> conststring then inherited concatstabto(asmlist);
    end;

{$endif * GDB *}

{**************************************
               TAUFZAEHLSYM
 **************************************}

    constructor taufzaehlsym.init(const n : string;def : paufzaehldef;v : longint);
      begin
         tsym.init(n);
         typ:=aufzaehlsym;
         definition:=def;
         value:=v;
{$ifdef GDB}
         order;
{$endif GDB}
      end;

    constructor taufzaehlsym.load;

      begin
         tsym.load;
         typ:=aufzaehlsym;
         definition:=paufzaehldef(readdefref);
         value:=readlong;
{$ifdef GDB}
         next := Nil;
{$endif * GDB *}
      end;

    procedure taufzaehlsym.deref;
      var sym : paufzaehlsym;
      begin
         resolvedef(pdef(definition));
{$ifdef GDB}
         order;
{$endif}
      end;

{$ifdef GDB}
         procedure taufzaehlsym.order;
         var sym : paufzaehlsym;
         begin
         sym := definition^.first;
         if sym = nil then
           begin
           definition^.first := @self;
           next := nil;
           exit;
           end;
         {reorder the symbols in increasing value }
         if value < sym^.value then
           begin
           next := sym;
           definition^.first := @self;
           end else
           begin
           while (sym^.value <= value) and assigned(sym^.next) do
             sym := sym^.next;
           next := sym^.next;
           sym^.next := @self;
           end;
         end;
{$endif * GDB *}

    procedure taufzaehlsym.write;

      begin
         writebyte(ibaufzaehlsym);
         tsym.write;
         writedefref(definition);
         writelong(value);
      end;

{$ifdef GDB}
    procedure taufzaehlsym.concatstabto(asmlist : paasmoutput);
    begin
    {enum elements have no stab !}
    end;
{$EndIf GDB}

{**************************************
               TTYPESYM
 **************************************}

    constructor ttypesym.init(const n : string;d : pdef);

      begin
         tsym.init(n);
         typ:=typesym;
         definition:=d;
         forwardpointer:=nil;
         { this allows to link definitions with the type with declares }
         { them                                                        }
         if assigned(definition) then
           if definition^.sym=nil then
             definition^.sym:=@self;
      end;

    constructor ttypesym.load;

      begin
         tsym.load;
         typ:=typesym;
         forwardpointer:=nil;
         definition:=readdefref;
      end;

    destructor ttypesym.done;

      begin
         if assigned(definition) then
           if definition^.sym=@self then
             definition^.sym:=nil;
         inherited done;
      end;

    procedure ttypesym.deref;

      begin
         resolvedef(definition);
         if assigned(definition) then
           if definition^.sym=nil then
             definition^.sym:=@self;
      end;

    procedure ttypesym.write;

      begin
         writebyte(ibtypesym);
         tsym.write;
         writedefref(definition);
      end;

{$ifdef GDB}
    function ttypesym.stabstring : pchar;
    var stabchar : string[2];
        short : string;
    begin
      if definition^.deftype in tagtypes then
        stabchar := 'Tt'
        else stabchar := 't';
    short := '"'+name+':'+stabchar+definition^.numberstring
               +'",'+tostr(N_LSYM)+',0,'+tostr(line_no)+',0';
    stabstring := strpnew(short);
    end;

    procedure ttypesym.concatstabto(asmlist : paasmoutput);
      begin
      {not stabs for forward defs }
      if assigned(definition) then
        if (definition^.sym = @self) then
        definition^.concatstabto(asmlist)
        else
        begin
        inherited concatstabto(asmlist);
        end;
      end;

{$endif * GDB *}

{**************************************
               TPROCSYM
 **************************************}

    procedure tprocsym.write;

      begin
         writebyte(ibprocsym);
         tsym.write;
         writedefref(pdef(definition));
      end;

{$ifdef GDB}
    function tprocsym.stabstring : pchar;
     Var RetType : Char;
         Obj,Info : String;
    begin
    if is_global then RetType := 'F'
                else RetType := 'f';
    if owner^.symtabletype = objectsymtable then
       begin
       obj := owner^.name^+'__'+name;
       { obj := definition^.cplusplusmangledname;}
       end else obj := name;
    if ((owner^.symtabletype and localsymtable) <> 0) and
       assigned(owner^.name) then
       info := ','+name+','+owner^.name^
       else info := '';
    stabstring :=strpnew('"'+obj+':'+RetType
           +definition^.retdef^.numberstring+info+'",'+tostr(n_function)
           +',0,'+tostr(current_module^.current_inputfile^.line_no)
           +','+definition^.mangledname);
    end;

    procedure tprocsym.concatstabto(asmlist : paasmoutput);
    begin
    if (definition^.options and pointernproc) <> 0 then exit;
    if not isstabwritten then
      asmlist^.concat(new(pai_stabs,init(stabstring)));
    isstabwritten := true;
    if assigned(definition^.parast) then
      definition^.parast^.concatstabto(asmlist);
    if assigned(definition^.localst) then
      definition^.localst^.concatstabto(asmlist);
    definition^.isstabwritten := true;
    end;

{$endif * GDB *}
{**************************************
               TSYSSYM
 **************************************}

    constructor tsyssym.init(const n : string;l : longint);

      begin
         inherited init(n);
         typ:=syssym;
         number:=l;
      end;

    procedure tsyssym.write;

      begin
      end;

{$ifdef GDB}
    procedure tsyssym.concatstabto(asmlist : paasmoutput);

      begin
      end;

{$endif * GDB *}
{**************************************
               TMACROSYM
 **************************************}

    constructor tmacrosym.init(const n : string);

      begin
         inherited init(n);
         defined:=true;
         buftext:=nil;
         buflen:=0;
      end;

    destructor tmacrosym.done;

      begin
         if assigned(buftext) then
           freemem(buftext,buflen);
         inherited done;
      end;

    function globaldef(const s : string) : pdef;

      var st : string;
          symt : psymtable;
      begin
         srsym := nil;
         if pos('.',s) > 0 then
           begin
           st := copy(s,1,pos('.',s)-1);
           getsym(st,false);
           st := copy(s,pos('.',s)+1,255);
           if assigned(srsym) then
             begin
             if srsym^.typ = unitsym then
               begin
               symt := punitsym(srsym)^.unitsymtable;
               srsym := symt^.search(st);
               end else srsym := nil;
             end;
           end else st := s;
         if srsym = nil then getsym(st,false);
         if srsym = nil then
           getsymonlyin(systemunit,st);
         if srsym^.typ<>typesym then
           begin
           error(type_id_expect);
           exit;
           end;
         globaldef := ptypesym(srsym)^.definition;
      end;

{$ifdef GDB}
    function typeglobalnumber(const s : string) : string;

      var st : string;
          symt : psymtable;
      begin
         typeglobalnumber := '0';
         srsym := nil;
         if pos('.',s) > 0 then
           begin
           st := copy(s,1,pos('.',s)-1);
           getsym(st,false);
           st := copy(s,pos('.',s)+1,255);
           if assigned(srsym) then
             begin
             if srsym^.typ = unitsym then
               begin
               symt := punitsym(srsym)^.unitsymtable;
               srsym := symt^.search(st);
               end else srsym := nil;
             end;
           end else st := s;
         if srsym = nil then getsym(st,true);
         if srsym^.typ<>typesym then
           begin
           error(type_id_expect);
           exit;
           end;
         typeglobalnumber := ptypesym(srsym)^.definition^.numberstring;
      end;
{$endif GDB}

{**************************************
                  TDEF
 **************************************}


{ Das braucht der Compiler um die Typendefinitionen zu verwalten }

    constructor tdef.init;

      begin
         deftype:=abstractdef;
{$ifdef GDB}
         owner := nil;
	 next := nil;
         number := 0;
         globalnb := 0;
{$endif * GDB *}
         if registerdef then symtablestack^.registerdef(@self);
{$ifdef GDB}
         isstabwritten := false;
         if assigned(lastglobaldef) then
           lastglobaldef^.nextglobal := @self
           else firstglobaldef := @self;
         lastglobaldef := @self;
         nextglobal := nil;
         sym := nil;
{$endif * GDB *}
      end;

{$ifdef GDB}
    constructor tdef.load;
      begin
         deftype:=abstractdef;
         isstabwritten := false;
         number := 0;
         if assigned(lastglobaldef) then
           lastglobaldef^.nextglobal := @self
           else firstglobaldef := @self;
         lastglobaldef := @self;
         nextglobal := nil;
         sym := nil;
         owner := nil;
	 next := nil;
      end;

   procedure tdef.set_globalnb;
     begin
         globalnb :=PGlobalTypeCount^;
         inc(PglobalTypeCount^);
     end;
{$endif * GDB *}
    function tdef.size : longint;

      begin
         size:=savesize;
      end;

    procedure tdef.write;

      begin
{$ifdef GDB }
      if globalnb = 0 then
        begin
        if assigned(owner) then
          globalnb := owner^.getnewtypecount
        else
          begin
          globalnb := PGlobalTypeCount^;
          Inc(PGlobalTypeCount^);
          end;
        end;
{$endif GDB }
      end;

{$ifdef GDB}
    function tdef.stabstring : pchar;

      begin
      stabstring := strpnew('t'+numberstring+';');
      end;

    function tdef.numberstring : string;
      var table : psymtable;
      begin
      {formal def have no type !}
      if deftype = formaldef then
        begin
        numberstring := voiddef^.numberstring;
        exit;
        end;
      if not assigned(sym) or not(sym^.isusedinstab) then
        begin
        {set even if debuglist is not defined}
        if assigned(sym) then
          sym^.isusedinstab := true;
        if assigned(debuglist) and not isstabwritten then
          concatstabto(debuglist);
        end;
      if not use_dbx then
        begin
           if globalnb = 0 then
             set_globalnb;
           numberstring := tostr(globalnb);
        end
      else
        begin
           if globalnb = 0 then
             begin
                if assigned(owner) then
                  globalnb := owner^.getnewtypecount
                else
                  begin
                     globalnb := PGlobalTypeCount^;
                     Inc(PGlobalTypeCount^);
                  end;
             end;
           if assigned(sym) then
             begin
                table := sym^.owner;
                if table^.unitid > 0 then
                  numberstring := '('+tostr(table^.unitid)+','+tostr(sym^.definition^.globalnb)+')'
                else
                  numberstring := tostr(globalnb);
                exit;
             end;
           numberstring := tostr(globalnb);
        end;
      end;

    function tdef.allstabstring : pchar;
    var stabchar : string[2];
        ss,st : pchar;
        name : string;
        sym_line_no : longint;
      begin
      ss := stabstring;
      getmem(st,strlen(ss)+512);
      stabchar := 't';
      if deftype in tagtypes then
        stabchar := 'Tt';
      if assigned(sym) then
        begin
           name := sym^.name;
           sym_line_no:=sym^.line_no;
        end
      else
        begin
           name := ' ';
           sym_line_no:=0;
        end;
      strpcopy(st,'"'+name+':'+stabchar+numberstring+'=');
      strpcopy(strecopy(strend(st),ss),'",'+tostr(N_LSYM)+',0,'+tostr(sym_line_no)+',0');
      allstabstring := strnew(st);
      freemem(st,strlen(ss)+512);
      strdispose(ss);
      end;


    procedure tdef.concatstabto(asmlist : paasmoutput);
     var stab_str : pchar;
    begin
    if ((sym = nil) or sym^.isusedinstab or use_dbx)
      and not isstabwritten then
      begin
      If use_dbx then
        begin
           { otherwise you get two of each def }
           If assigned(sym) then
             begin
                sym^.isusedinstab:=true;
                if (sym^.owner = nil) or
                  ((sym^.owner^.symtabletype = unitsymtable) and
                 punitsymtable(sym^.owner)^.dbx_count_ok)  then
                begin
                   {with DBX we get the definition from the other objects }
                   isstabwritten := true;
                   exit;
                end;
             end;
        end;
      { to avoid infinite loops }
      isstabwritten := true;
      stab_str := allstabstring;
      if asmlist = debuglist then do_count_dbx := true;
      { count_dbx(stab_str); moved to GDB.PAS}
      asmlist^.concat(new(pai_stabs,init(stab_str)));
      end;
    end;

{$endif * GDB *}
    procedure tdef.deref;

      begin
      end;

    destructor tdef.done;
{$ifndef GDB}

{$else * GDB *}
      var pd : pdef;
      begin
      pd := firstglobaldef;
      if pd = @self then firstglobaldef := pd^.nextglobal
        else while assigned(pd) do
{$endif * GDB *}
      begin
{$ifdef GDB}
            if pd^.nextglobal = @Self then
               begin
               pd^.nextglobal := pd^.nextglobal^.nextglobal;
               if pd^.nextglobal = nil then lastglobaldef := pd;
               end;
            pd := pd^.nextglobal;
            end;
{$endif * GDB *}
      end;

{**************************************
              TSTRINGDEF
 **************************************}

    constructor tstringdef.init(l : byte);

      begin
         tdef.init;
         deftype:=stringdef;
         len:=l;
         savesize:=len+1;
      end;

    constructor tstringdef.load;

      begin
{$ifdef GDB}
         tdef.load;
         set_globalnb;
{$endif * GDB *}
         deftype:=stringdef;
         len:=readbyte;
         savesize:=len+1;
      end;

    procedure tstringdef.write;

      begin
         writebyte(ibstringdef);
         tdef.write;
         writebyte(len);
      end;

{$ifdef GDB}
    function tstringdef.stabstring : pchar;
      var bytest,charst : string;
      begin
      charst := typeglobalnumber('char');
      { this is what I found in stabs.texinfo but
      gdb 4.12 for go32 doesn't understand that !! }
      {$IfDef GDBknowsstrings}
      stabstring := strpnew('n'+charst+';'+tostr(len));
      {$else}
      bytest := typeglobalnumber('byte');
      stabstring := strpnew('s'+tostr(len+1)+'length:'+bytest
                    +',0,8;st:ar'+bytest
                    +';1;'+tostr(len)+';'+charst+',8,'+tostr(len*8)+';;');
      {$EndIf}
      end;

    procedure tstringdef.concatstabto(asmlist : paasmoutput);
      begin
        inherited concatstabto(asmlist);
      end;
{$endif * GDB *}

{**************************************
             TAUFZAEHLDEF
 **************************************}

    constructor taufzaehldef.init;

      begin
         tdef.init;
         deftype:=aufzaehldef;
         max:=0;
         savesize:=4;
{$ifdef GDB}
         first := Nil;
{$endif * GDB *}
      end;

    constructor taufzaehldef.load;

      begin
{$ifdef GDB}
         tdef.load;
         set_globalnb;
{$endif * GDB *}
         deftype:=aufzaehldef;
         max:=readlong;
         savesize:=4;
{$ifdef GDB}
         first := Nil;
      end;

    destructor taufzaehldef.done;
      begin
      inherited done;
{$endif * GDB *}
      end;

    procedure taufzaehldef.write;

      begin
         writebyte(ibaufzaehldef);
         tdef.write;
         writelong(max);
{$ifdef GDB}
      end;

    function taufzaehldef.stabstring : pchar;
      var st,st2 : pchar;
          p : paufzaehlsym;
          s : string;
          memsize : word;
      begin
      memsize := 2048;
      getmem(st,memsize);
      strpcopy(st,'e');
      p := first;
      while assigned(p) do
        begin
        s :=p^.name+':'+tostr(p^.value)+',';
        if (strlen(st)+length(s)<memsize) then
          strpcopy(strend(st),s)
          else
          begin
          getmem(st2,memsize+2048);
          strcopy(st2,st);
          freemem(st,memsize);
          st := st2;
          memsize := memsize+2048;
          strpcopy(strend(st),s);
          end;
        p := p^.next;
        end;
      strpcopy(strend(st),';');
      stabstring := strnew(st);
      freemem(st,memsize);
{$endif * GDB *}
      end;

{**************************************
               TORDDEF
 **************************************}

    constructor torddef.init(t : tbasetype;v,b : longint);

      begin
         tdef.init;
         deftype:=orddef;
         von:=v;
         bis:=b;
         typ:=t;
         setsize;
      end;

    constructor torddef.load;

      begin
{$ifdef GDB}
         tdef.load;
         set_globalnb;
{$endif * GDB *}
         deftype:=orddef;
         typ:=tbasetype(readbyte);
         von:=readlong;
         bis:=readlong;
         setsize;
      end;

    procedure torddef.setsize;

      begin
         if typ=uauto then
           begin
              if (von>=0) and (bis<=255) then
                begin
                   savesize:=1;
                   typ:=u8bit;
                end
              else if (von>=-128) and (bis<=127) then
                begin
                   savesize:=1;
                   typ:=s8bit;
                end
              else if (von>=0) and (bis<=65536) then
                begin
                   savesize:=2;
                   typ:=u16bit;
                end
              else if (von>=-32768) and (bis<=32767) then
                begin
                   savesize:=2;
                   typ:=s16bit;
                end
              else
                begin
                   savesize:=4;
                   typ:=s32bit;
                end;
           end
         else
           case typ of
              uchar,u8bit,bool8bit,s8bit : savesize:=1;
              u16bit,s16bit : savesize:=2;
              s32bit,u32bit : savesize:=4;
              else savesize:=0;
           end;

         { there are no entrys for range checking }
         rangenr:=0;
      end;

    procedure torddef.genrangecheck;

      var
         rangelabel : tlabel;

      begin
         if rangenr=0 then
           begin
              { generate two constant for bounds }
              getlabel(rangelabel);
              rangenr:=rangelabel;
              datasegment^.concat(new(pai_symbol,init('R_'+tostr(rangenr))));
              datasegment^.concat(new(pai_const,init_32bit(von)));
              datasegment^.concat(new(pai_const,init_32bit(bis)));
           end;
      end;

    procedure torddef.write;

      begin
         writebyte(iborddef);
         tdef.write;
         writebyte(byte(typ));
         writelong(von);
         writelong(bis);
      end;

{$ifdef GDB}
    function torddef.stabstring : pchar;

      begin
      case typ of
         uvoid : stabstring := strpnew(numberstring+';');
         {GDB 4.12 for go32 doesn't like boolean as range for 0 to 1 !!!}
         bool8bit : stabstring := strpnew('r'+numberstring+';0;255;');
         { for fixed real use longint instead to be able to }
         { debug something at least                         }
         u32bit : stabstring := strpnew('r'+
              s32bitdef^.numberstring+';0;-1;');
         else stabstring := strpnew('r'+s32bitdef^.numberstring+';'
                            +tostr(von)+';'+tostr(bis)+';');
         end;
      end;

{$endif * GDB *}

{**************************************
               TFLOATDEF
 **************************************}

    constructor tfloatdef.init(t : tfloattype);

      begin
         tdef.init;
         deftype:=floatdef;
         typ:=t;
         setsize;
      end;

    constructor tfloatdef.load;

      begin
{$ifdef GDB}
         tdef.load;
         set_globalnb;
{$endif * GDB *}
         deftype:=floatdef;
         typ:=tfloattype(readbyte);
         setsize;
      end;

    procedure tfloatdef.setsize;

      begin
         case typ of
            f32bit,s32real : savesize:=4;
            s64real,s64bit : savesize:=8;
            s80real : savesize:=10;
            else savesize:=0;
         end;
      end;

    procedure tfloatdef.write;

      begin
         writebyte(ibfloatdef);
         tdef.write;
         writebyte(byte(typ));
      end;

{$ifdef GDB}
    function tfloatdef.stabstring : pchar;

      begin
         case typ of
            s64real : stabstring := strpnew('r'+
               s32bitdef^.numberstring+';'+tostr(savesize)+';0;');
            f32bit : stabstring := s32bitdef^.stabstring;
         end;
      end;

{$endif * GDB *}

{**************************************
               TFILEDEF
 **************************************}

    constructor tfiledef.init(ft : tfiletype;tas : pdef);

      begin
         inherited init;
         deftype:=filedef;
         filetype:=ft;
         typed_as:=tas;
         setsize;
      end;

    constructor tfiledef.load;

      begin
{$ifdef GDB}
         tdef.load;
         set_globalnb;
{$endif * GDB *}
         deftype:=filedef;
         filetype:=tfiletype(readbyte);
         if filetype=ft_typed then
           typed_as:=readdefref
         else
           typed_as:=nil;
         setsize;
      end;

    procedure tfiledef.deref;

      begin
         if filetype=ft_typed then
           resolvedef(typed_as);
      end;

    procedure tfiledef.write;

      begin
         writebyte(ibfiledef);
         tdef.write;
         writebyte(byte(filetype));
         if filetype=ft_typed then
           writedefref(typed_as);
      end;

{$ifdef GDB}
    function tfiledef.stabstring : pchar;

      begin
      {$IfDef GDBknowsfiles}
      case filetyp of
        ft_typed : stabstring := strpnew('d'+typed_as^.numberstring{+';'});
        ft_untyped : stabstring := strpnew('d'+voiddef^.numberstring{+';'});
        ft_text : stabstring := strpnew('d'+cchardef^.numberstring{+';'});
        end;
      {$Else }
      {based on
       filerec = record
          handle : word;
          mode : word;
          recsize : word;
          _private : array[1..26] of byte;
          userdata : array[1..16] of byte;
          name : string[79];}

      stabstring := strpnew('s128HANDLE:'+typeglobalnumber('word')+',0,16;'+
                      'MODE:'+typeglobalnumber('word')+',16,16;'+
                      'RECSIZE:'+typeglobalnumber('word')+',32,16;'+
                      '_PRIVATE:ar'+typeglobalnumber('word')+';1;26;'+typeglobalnumber('byte')+',36,208;'+
                      'USERDATA:ar'+typeglobalnumber('word')+';1;16;'+typeglobalnumber('byte')+',256,128;'+
                      'NAME:s80'+
                        'length:'+typeglobalnumber('byte')+',0,8;'+
                        'st:ar'+typeglobalnumber('word')+';1;79;'+typeglobalnumber('char')+',8,632;;'+
                      ',384,640;;');
      {$EndIf}
      end;

    procedure tfiledef.concatstabto(asmlist : paasmoutput);

      begin
      { most file defs are unnamed !!! }
      if ((sym = nil) or sym^.isusedinstab or use_dbx) and not isstabwritten then
        begin
        if assigned(typed_as) then forcestabto(asmlist,typed_as);
        inherited concatstabto(asmlist);
        end;
      end;

{$endif * GDB *}
    procedure tfiledef.setsize;

      begin
         if target_info.target=target_LINUX then
           begin
              case filetype of
                 ft_text : savesize:=432;
                 ft_typed,ft_untyped : savesize:=304;
              end;
           end
         else
           begin
              case filetype of
                 ft_text : savesize:=256;
                 ft_typed,ft_untyped : savesize:=128;
              end;
           end;
      end;

{**************************************
               TPOINTERDEF
 **************************************}

    constructor tpointerdef.init(def : pdef);

      begin
         inherited init;
         deftype:=pointerdef;
         definition:=def;
         savesize:=4;
      end;

    constructor tpointerdef.load;

      begin
{$ifdef GDB}
         tdef.load;
         set_globalnb;
{$endif * GDB *}
         deftype:=pointerdef;
         { die Adressen werden spter berechnet }
         definition:=readdefref;
         savesize:=4;
      end;

    procedure tpointerdef.deref;

      begin
         resolvedef(definition);
      end;

    procedure tpointerdef.write;

      begin
         writebyte(ibpointerdef);
         tdef.write;
         writedefref(definition);
      end;

{$ifdef GDB}
    function tpointerdef.stabstring : pchar;

      begin
      stabstring := strpnew('*'+definition^.numberstring);
      end;

    procedure tpointerdef.concatstabto(asmlist : paasmoutput);
      var st,nb : string;
          sym_line_no : longint;
      begin
      if ( (sym=nil) or sym^.isusedinstab or use_dbx) and not isstabwritten then
        begin
        if assigned(definition) then
          if definition^.deftype in [recorddef,objectdef] then
            begin
            isstabwritten := true;
            {to avoid infinite recursion in record with next-like fields }
            nb := definition^.numberstring;
            isstabwritten := false;
            if not definition^.isstabwritten then
              begin
              if assigned(definition^.sym) then
                begin
                if assigned(sym) then
                  begin
                     st := sym^.name;
                     sym_line_no:=sym^.line_no;
                  end
                else
                  begin
                     st := ' ';
                     sym_line_no:=0;
                  end;
                st := '"'+st+':t'+numberstring+'=*'+definition^.numberstring
                      +'=xs'+definition^.sym^.name+':",'+tostr(N_LSYM)+',0,'+tostr(sym_line_no)+',0';
                if asmlist = debuglist then do_count_dbx := true;
                asmlist^.concat(new(pai_stabs,init(strpnew(st))));
                end;
              end else inherited concatstabto(asmlist);
            isstabwritten := true;
            end else
            begin
            forcestabto(asmlist,definition);
            inherited concatstabto(asmlist);
            end;
        end;
      end;

{$endif * GDB *}

{**************************************
               TSETDEF
 **************************************}

    constructor tsetdef.init(s : pdef;high : longint);

      begin
         inherited init;
         deftype:=setdef;
         setof:=s;
         {$ifdef testsmallset}
         if high<32 then
           begin
              settype:=smallset;
              savesize:=4;
           end
         else
         {$endif testsmallset}
         if high<256 then
           begin
              settype:=normset;
              savesize:=32;
           end
         else
         if high<$10000 then
           begin
              settype:=varset;
              savesize:=4*((high+31) div 32);
           end
         else
           error(illsettype);
      end;

    constructor tsetdef.load;

      begin
{$ifdef GDB}
         tdef.load;
         set_globalnb;
{$endif * GDB *}
         deftype:=setdef;
         setof:=readdefref;
         settype:=tsettype(readbyte);
         case settype of
            normset : savesize:=32;
            varset : savesize:=readlong;
            smallset : savesize:=4;
         end;
      end;

    procedure tsetdef.write;

      begin
         writebyte(ibsetdef);
         tdef.write;
         writedefref(setof);
         writebyte(byte(settype));
         if settype=varset then
           writelong(savesize);
      end;

{$ifdef GDB}
    function tsetdef.stabstring : pchar;

      begin
         stabstring := strpnew('S'+setof^.numberstring);
      end;

    procedure tsetdef.concatstabto(asmlist : paasmoutput);

      begin
      if ( not assigned(sym) or sym^.isusedinstab or use_dbx)
 and not isstabwritten then
        begin
        if assigned(setof) then forcestabto(asmlist,setof);
        inherited concatstabto(asmlist);
        end;
      end;

{$endif * GDB *}
    procedure tsetdef.deref;

      begin
         resolvedef(setof);
      end;

{**************************************
               TFORMALDEF
 **************************************}

    constructor tformaldef.init;

      begin
         inherited init;
         deftype:=formaldef;
         savesize:=4;
      end;

    constructor tformaldef.load;

      begin
{$ifdef GDB}
         tdef.load;
{$endif * GDB *}
         deftype:=formaldef;
         savesize:=4;
      end;

    procedure tformaldef.write;

      begin
         writebyte(ibformaldef);
         tdef.write;
      end;

{$ifdef GDB}
    function tformaldef.stabstring : pchar;

      begin
      stabstring := strpnew('formal'+numberstring+';');
      end;


    procedure tformaldef.concatstabto(asmlist : paasmoutput);

      begin
      { formaldef can't be stab'ed !}
      end;
{$endif * GDB *}

{**************************************
               TARRAYDEF
 **************************************}

    constructor tarraydef.init(l,h : longint;rd : pdef);

      begin
         tdef.init;
         deftype:=arraydef;
         lowrange:=l;
         highrange:=h;
         rangedef:=rd;
         rangenr:=0;
         definition:=nil;
      end;

    constructor tarraydef.load;

      begin
{$ifdef GDB}
         tdef.load;
         set_globalnb;
{$endif * GDB *}
         deftype:=arraydef;
         rangenr:=0;

         { die Adressen werden spter berechnet }
         definition:=readdefref;
         rangedef:=readdefref;
         lowrange:=readlong;
         highrange:=readlong;
      end;

    procedure tarraydef.genrangecheck;

      var
         rangelabel : tlabel;

      begin
         if rangenr=0 then
           begin
              { generates the data for range checking }

              { the following construction is stupid, but for future use }
              getlabel(rangelabel);
              rangenr:=rangelabel;
              datasegment^.concat(new(pai_symbol,init('R_'+tostr(rangenr))));
              datasegment^.concat(new(pai_const,init_32bit(lowrange)));
              datasegment^.concat(new(pai_const,init_32bit(highrange)));
           end;
      end;

    procedure tarraydef.deref;

      begin
         resolvedef(definition);
         resolvedef(rangedef);
      end;

    procedure tarraydef.write;

      begin
         writebyte(ibarraydef);
         tdef.write;
         writedefref(definition);
         writedefref(rangedef);
         writelong(lowrange);
         writelong(highrange);
      end;

{$ifdef GDB}
    function tarraydef.stabstring : pchar;
      begin
      stabstring := strpnew('ar'+rangedef^.numberstring+';'
                    +tostr(lowrange)+';'+tostr(highrange)+';'+definition^.numberstring);
      end;

    procedure tarraydef.concatstabto(asmlist : paasmoutput);

      begin
      if (not assigned(sym) or sym^.isusedinstab or use_dbx)
        and not isstabwritten then
        begin
        {when array are inserted they have no definition yet !!}
        if assigned(definition) then
          inherited concatstabto(asmlist);
        end;
      end;

{$endif * GDB *}
    function tarraydef.elesize : longint;

      begin
         elesize:=definition^.size;
      end;

    function tarraydef.size : longint;

      begin
         size:=(highrange-lowrange+1)*elesize;
      end;

{**************************************
               TRECDEF
 **************************************}

    constructor trecdef.init(p : psymtable);

      begin
         tdef.init;
         deftype:=recorddef;
         symtable:=p;
         savesize:=symtable^.datasize;
{$ifdef GDB}
         symtable^.defowner := @self;
{$endif * GDB *}
      end;

    constructor trecdef.load;

      var
         oldread_member : boolean;

      begin
{$ifdef GDB}
         tdef.load;
         set_globalnb;
{$endif * GDB *}
         deftype:=recorddef;
         savesize:=readlong;
         oldread_member:=read_member;
         read_member:=true;
         symtable:=new(psymtable,loadasstruct(recordsymtable));
         read_member:=oldread_member;
{$ifdef GDB}
         symtable^.defowner := @self;
{$endif * GDB *}
      end;

    destructor trecdef.done;

      begin
{$ifndef GDB}
         dispose(symtable);
{$else * GDB *}
         if assigned(symtable) then dispose(symtable,done);
         inherited done;
{$endif * GDB *}
      end;

    procedure derefsym(p : psym);far;

      begin
         p^.deref;
      end;

    procedure trecdef.deref;

      var
         hp : pdef;
         oldrecsyms : psymtable;

      begin
         oldrecsyms:=aktrecordsymtable;
         aktrecordsymtable:=symtable;
         { nun die Definitionen Dereferenzieren }
         hp:=symtable^.wurzeldef;
         while assigned(hp) do
           begin
              hp^.deref;

              {Besitzer setzten }
              hp^.owner:=symtable;

              hp:=hp^.next;
           end;
{$ifdef tp}
         symtable^.foreach(derefsym);
{$else}
         symtable^.foreach(@derefsym);
{$endif}
         aktrecordsymtable:=oldrecsyms;
      end;

    procedure trecdef.write;

      var
         oldread_member : boolean;

      begin
         oldread_member:=read_member;
         read_member:=true;
         writebyte(ibrecorddef);
         tdef.write;
         writelong(savesize);
         self.symtable^.writeasstruct;
         read_member:=oldread_member;
      end;

{$ifdef GDB}

      Const StabRecString : pchar = Nil;
          RecOffset : Longint = 0;

    procedure addname(p : psym);far;
    var newst,virtualind : string;
        savestab, newrec : pchar;
        pd,ipd : pprocdef;
        lindex : longint;
    begin
    If p^.typ = varsym then
       begin
       newrec := strpnew(p^.name+':'+pvarsym(p)^.definition^.numberstring
                     +','+tostr(pvarsym(p)^.adresse*8)+','
                     +tostr(pvarsym(p)^.definition^.size*8)+';');
       strcat(StabRecstring,newrec);
       strdispose(newrec);
       {This should be used for case !!}
       RecOffset := RecOffset + pvarsym(p)^.definition^.size;
       end;
    end;

    function trecdef.stabstring : pchar;
      Var oldrec : pchar;

      begin
      oldrec := stabrecstring;
      GetMem(stabrecstring,2048);
      strpcopy(stabRecString,'s'+tostr(savesize));
      RecOffset := 0;
{$ifdef tp}
         symtable^.foreach(addname);
{$else}
         symtable^.foreach(@addname);
{$endif}
      { fpk doesn't want to convert a char to a pchar}
      { is this a bug ? }
      strpcopy(strend(StabRecString),';');
      stabstring := strnew(StabRecString);
      Freemem(stabrecstring,2048);
      stabrecstring := oldrec;
      end;

    procedure trecdef.concatstabto(asmlist : paasmoutput);

      begin
      if ( not assigned(sym) or sym^.isusedinstab or use_dbx)
 and not isstabwritten then
        begin
        inherited concatstabto(asmlist);
        end;
      end;

{$endif * GDB *}

{**************************************
               TABSTRACTPROCDEF
 **************************************}

    constructor tabstractprocdef.init;

      begin
         inherited init;
         para1:=nil;
         options:=0;
         retdef:=voiddef;
         savesize:=4;
      end;

    destructor tabstractprocdef.done;

      var
         hp : pdefcoll;

      begin
         hp:=para1;
         while assigned(hp) do
           begin
              para1:=hp^.next;
              dispose(hp);
              hp:=para1;
           end;
         inherited done;
      end;

    procedure tabstractprocdef.concatdef(p : pdef;vsp : tvarspez);

      var
         hp : pdefcoll;

      begin
         new(hp);
         hp^.paratyp:=vsp;
         hp^.data:=p;
         hp^.next:=para1;
         para1:=hp;
      end;

    procedure tabstractprocdef.deref;

      var
         hp : pdefcoll;

      begin
         inherited deref;
         resolvedef(retdef);
         hp:=para1;
         while assigned(hp) do
           begin
              resolvedef(hp^.data);
              hp:=hp^.next;
           end;
      end;

    constructor tabstractprocdef.load;

      var
         last,hp : pdefcoll;
         count,i : word;

      begin
{$ifdef GDB}
         tdef.load;
{$endif * GDB *}
         retdef:=readdefref;
         options:=readword;
         count:=readword;
         para1:=nil;
         savesize:=4;
         for i:=1 to count do
           begin
              new(hp);
              hp^.paratyp:=tvarspez(readbyte);
              hp^.data:=readdefref;
              hp^.next:=nil;
              if para1=nil then
                para1:=hp
              else
                last^.next:=hp;
              last:=hp;
           end;
      end;

    procedure tabstractprocdef.write;

      var
         count : word;
         hp : pdefcoll;

      begin
         tdef.write;
         writedefref(retdef);
         writeword(options);
         hp:=para1;
         count:=0;
         while assigned(hp) do
           begin
              inc(count);
              hp:=hp^.next;
           end;
         writeword(count);
         hp:=para1;
         while assigned(hp) do
           begin
              writebyte(byte(hp^.paratyp));
              writedefref(hp^.data);
              hp:=hp^.next;
           end;
      end;

{$ifdef GDB}
    function tabstractprocdef.stabstring : pchar;
      begin
      stabstring := strpnew('abstractproc'+numberstring+';');
      end;

    procedure tabstractprocdef.concatstabto(asmlist : paasmoutput);

      begin
      if (not assigned(sym) or sym^.isusedinstab or use_dbx)
 and not isstabwritten then
        begin
        {if assigned(retdef) then forcestabto(asmlist,retdef);}
        inherited concatstabto(asmlist);
        end;
      end;

{$endif * GDB *}

{**************************************
               TPROCDEF
 **************************************}

    constructor tprocdef.init;

      begin
         inherited init;
         deftype:=procdef;
         _mangledname:=nil;
         nextoverloaded:=nil;
         extnumber:=-1;
{$ifndef GDB}
         parast:=new(psymtable,init(parasymtable));
{$endif * not GDB *}
         localst:=new(psymtable,init(localsymtable));
{$ifdef GDB}
         parast:=new(psymtable,init(parasymtable));
{$endif * GDB *}

         { first, we assume, that all registers are used }
{$ifdef i386}
         usedregisters:=$ff;
{$endif i386}
{$ifdef alpha}
         usedregisters_int:=$ffffffff;
         usedregisters_fpu:=$ffffffff;
{$endif alpha}
         forwarddef:=true;
{$ifdef GDB}
         _class := nil;
{$endif * GDB *}
      end;

    constructor tprocdef.load;

      var
         s : string;

      begin
         deftype:=procdef;
         inherited load;
{$ifdef i386}
         usedregisters:=readbyte;
{$endif i386}
{$ifdef alpha}
         usedregisters_int:=readlong;
         usedregisters_fpu:=readlong;
{$endif alpha}

         s:=readstring;
         setstring(_mangledname,s);

         { this symbol is external: }
         externals^.concat(new(pai_external,init(s)));

         extnumber:=readlong;
         nextoverloaded:=pprocdef(readdefref);
{$ifdef GDB}
         _class := pobjectdef(readdefref);
{$endif * GDB *}

         if gendeffile and ((options and poexports)<>0) then
           writeln(defdatei,#9+mangledname);

         parast:=nil;
         localst:=nil;
         forwarddef:=false;
      end;

    destructor tprocdef.done;

      var
         hp : pdefcoll;

      begin
         if assigned(parast) then
           dispose(parast,done);
         if assigned(localst) then
           dispose(localst,done);
         if
{$ifdef tp}
         not(use_big) and
{$endif}
         assigned(_mangledname) then
           strdispose(_mangledname);
         inherited done;
      end;

    procedure tprocdef.write;

      begin
         writebyte(ibprocdef);
         inherited write;
{$ifdef i386}
         writebyte(usedregisters);
{$endif i386}

{$ifdef alpha}
         writelong(usedregisters_int);
         writelong(usedregisters_fpu);
{$endif alpha}

         writestring(mangledname);
         writelong(extnumber);
         writedefref(nextoverloaded);
{$ifdef GDB}
         writedefref(_class);
{$endif GDB}
      end;

{$ifdef GDB}
    procedure addparaname(p : psym);far;
      var vs : char;

      begin
      if pvarsym(p)^.varspez = vs_value then vs := '1'
        else vs := '0';
      strpcopy(strend(StabRecString),p^.name+':'+pvarsym(p)^.definition^.numberstring+','+vs+';');
      end;

    function tprocdef.stabstring : pchar;
      var param : pdefcoll;
          i : word;
          vartyp : char;
          oldrec : pchar;
      begin
      oldrec := stabrecstring;
      getmem(StabRecString,1024);
      param := para1;
      i := 0;
      while assigned(param) do
        begin
        inc(i);
        param := param^.next;
        end;
      strpcopy(StabRecString,'f'+retdef^.numberstring);
      if i>0 then
        begin
        strpcopy(strend(StabRecString),','+tostr(i)+';');
        if assigned(parast) then
          {$IfDef TP}
          parast^.foreach(addparaname)
          {$Else}
          parast^.foreach(@addparaname)
          {$EndIf}
          else
          begin
          param := para1;
          i := 0;
          while assigned(param) do
            begin
            inc(i);
            if param^.paratyp = vs_value then vartyp := '1' else vartyp := '0';
            {Here we have lost the parameter names !!}
            {using lower case parameters }
            strpcopy(strend(stabrecstring),'p'+tostr(i)
               +':'+param^.data^.numberstring+','+vartyp+';');
            param := param^.next;
            end;
          end;
        {strpcopy(strend(StabRecString),';');}
        end;
      stabstring := strnew(stabrecstring);
      freemem(stabrecstring,1024);
      stabrecstring := oldrec;
      end;

    procedure tprocdef.concatstabto(asmlist : paasmoutput);

      begin
      end;
{$endif GDB}

    procedure tprocdef.deref;

      begin
         inherited deref;
         resolvedef(pdef(nextoverloaded));
{$ifdef GDB}
         resolvedef(pdef(_class));
{$endif GDB}
      end;

    function tprocdef.mangledname : string;

      var
         oldpos : longint;
         s : string;
         b : byte;

      begin
{ $ifdef tp
         if use_big then
           begin
              symbolstream.seek(longint(_mangledname));
              symbolstream.read(b,1);
              symbolstream.read(s[1],b);
              s[0]:=chr(b);
              mangledname:=s;
           end
         else
$endif}
           begin
              mangledname:=strpas(_mangledname);
           end;
      end;

{$IfDef GDB}
    function tprocdef.cplusplusmangledname : string;

      var
         s,s2 : string;
      var param : pdefcoll;

      begin
      s := sym^.name;
      if _class <> nil then
        begin
        s2 := _class^.name^;
        s := s+'__'+tostr(length(s2))+s2;
        end else s := s + '_';
      param := para1;
      while assigned(param) do
        begin
        s2 := param^.data^.sym^.name;
        s := s+tostr(length(s2))+s2;
        param := param^.next;
        end;
      cplusplusmangledname:=s;
      end;
{$EndIf GDB}

    procedure tprocdef.setmangledname(const s : string);

      begin
         if
{$ifdef tp}
         not(use_big) and
{$endif}
         (assigned(_mangledname)) then
           strdispose(_mangledname);
         setstring(_mangledname,s);
      end;

{**************************************
               TPROCVARDEF
 **************************************}

    constructor tprocvardef.init;

      begin
         inherited init;
         deftype:=procvardef;
      end;

    constructor tprocvardef.load;

      begin
{$ifndef GDB}
         deftype:=procvardef;
{$endif * not GDB *}
         inherited load;
{$ifdef GDB}
         deftype:=procvardef;
         set_globalnb;
{$endif * GDB *}
      end;

    procedure tprocvardef.write;

      begin
         writebyte(ibprocvardef);
         inherited write;
      end;

{$ifdef GDB}
    function tprocvardef.stabstring : pchar;

      var
         nss : pchar;
         i : word;
         vartyp : char;
         pst : pchar;
         param : pdefcoll;

      begin
      i := 0;
      param := para1;
      while assigned(param) do
        begin
        inc(i);
        param := param^.next;
        end;
      getmem(nss,1024);
      strpcopy(nss,'f'+retdef^.numberstring+','+tostr(i)+';');
      param := para1;
      i := 0;
      while assigned(param) do
        begin
        inc(i);
        if param^.paratyp = vs_value then vartyp := '1' else vartyp := '0';
        {Here we have lost the parameter names !!}
        pst := strpnew('p'+tostr(i)+':'+param^.data^.numberstring+','+vartyp+';');
        strcat(nss,pst);
        strdispose(pst);
        param := param^.next;
        end;
      {strpcopy(strend(nss),';');}
      stabstring := strnew(nss);
      freemem(nss,1024);
      end;

    procedure tprocvardef.concatstabto(asmlist : paasmoutput);

      begin
         if ( not assigned(sym) or sym^.isusedinstab or use_dbx)
           and not isstabwritten then
           inherited concatstabto(asmlist);
         isstabwritten:=true;
      end;
{$endif GDB}

{**************************************
               TOBJECTDEF
 **************************************}

{$ifdef GDB}
    const
       vtabletype : word = 0;
       vtableassigned : boolean = false;

{$endif * GDB *}
   constructor tobjectdef.init(const n : string;c : pobjectdef);

     begin
        tdef.init;
        deftype:=objectdef;
        childof:=c;
        options:=0;
        { privatesyms:=new(psymtable,init(objectsymtable));
          protectedsyms:=new(psymtable,init(objectsymtable)); }
        publicsyms:=new(psymtable,init(objectsymtable));
{$ifdef GDB}
        publicsyms^.name := stringdup(n);
{$endif GDB}
        { add the data of the anchestor class }
        if assigned(childof) then
          publicsyms^.datasize:=
            publicsyms^.datasize-4+childof^.publicsyms^.datasize;
        name:=stringdup(n);
        savesize := publicsyms^.datasize;
{$ifdef GDB}
        publicsyms^.defowner:=@self;
{$endif GDB}
     end;

    constructor tobjectdef.load;

      var
         oldread_member : boolean;

      begin
{$ifdef GDB}
         tdef.load;
         set_globalnb;
{$endif * GDB *}
         deftype:=objectdef;
         savesize:=readlong;
         name:=stringdup(readstring);

         childof:=pobjectdef(readdefref);
         options:=readword;
         oldread_member:=read_member;
         read_member:=true;
         publicsyms:=new(psymtable,loadasstruct(objectsymtable));
{$ifdef GDB}
         publicsyms^.defowner:=@self;
{$endif * GDB *}
         publicsyms^.datasize:=savesize;
{$ifdef GDB}
         publicsyms^.name := stringdup(name^);
{$endif * GDB *}
         read_member:=oldread_member;

         { handles the predefined class tobject  }
         { the last TOBJECT which is loaded gets }
         { it !                                  }
         if (name^='TOBJECT') and not(cs_compilesystem in aktswitches) and
           ( (options and oois_class)<>0 ) and (childof=pointer($ffffffff)) then
           class_tobject:=@self;
      end;

   procedure tobjectdef.check_forwards;

     begin
        publicsyms^.check_forwards;
     end;

   destructor tobjectdef.done;

     begin
{!!!!
        if assigned(privatesyms) then
          dispose(privatesyms,done);
        if assigned(protectedsyms) then
          dispose(protectedsyms,done); }
        if assigned(publicsyms) then
          dispose(publicsyms,done);
        stringdispose(name);
        tdef.done;
     end;

   function tobjectdef.isrelated(d : pobjectdef) : boolean;

     var
        hp : pobjectdef;

     begin
        isrelated:=false;
        hp:=@self;
        while assigned(hp) do
          begin
             if hp=d then
               begin
                  isrelated:=true;
                  exit;
               end;
             hp:=hp^.childof;
          end;
     end;

   function tobjectdef.size : longint;

     begin
        if (options and oois_class)<>0 then
          size:=4
        else
          size:=publicsyms^.datasize;
     end;

    procedure tobjectdef.deref;

      var
         hp : pdef;
         oldrecsyms : psymtable;

      begin
         resolvedef(pdef(childof));
         oldrecsyms:=aktrecordsymtable;
         aktrecordsymtable:=publicsyms;
         { nun die Definitionen dereferenzieren }
         hp:=publicsyms^.wurzeldef;
         while assigned(hp) do
           begin
              hp^.deref;

              {Besitzer setzen }
              hp^.owner:=publicsyms;

              hp:=hp^.next;
           end;
{$ifdef tp}
         publicsyms^.foreach(derefsym);
{$else}
         publicsyms^.foreach(@derefsym);
{$endif}
         aktrecordsymtable:=oldrecsyms;
      end;

    function tobjectdef.vmt_mangledname : string;
      begin
        vmt_mangledname:='VMT_'+owner^.name^+'$_'+name^;
      end;

    procedure tobjectdef.write;

      var
         oldread_member : boolean;

      begin
         oldread_member:=read_member;
         read_member:=true;
         writebyte(ibobjectdef);
         tdef.write;
         writelong(size);
         writestring(name^);
         writedefref(childof);
         writeword(options);
         publicsyms^.writeasstruct;
         read_member:=oldread_member;
      end;

{$ifdef GDB}
    procedure addprocname(p :psym);far;
    var newst,virtualind,argnames : string;
        savestab, newrec : pchar;
        pd,ipd : pprocdef;
        lindex : longint;
        para : pdefcoll;
        arglength : byte;
    begin
    If p^.typ = procsym then
       begin
                pd := pprocsym(p)^.definition;
                { this will be used for full implementation of object stabs
                not yet done }
                ipd := pd;
                while assigned(ipd^.nextoverloaded) do ipd := ipd^.nextoverloaded;
                if (pd^.options and povirtualmethod) <> 0 then
                   begin
                   lindex := pd^.extnumber;
                   {doesnt seem to be necessary
                   lindex := lindex or $80000000;}
                   virtualind := '*'+tostr(lindex)+';'+ipd^._class^.numberstring+';'
                   end else virtualind := '.';
                { arguments are not listed here }
                {we don't need another definition}
                 para := pd^.para1;
                 argnames := '';
                 while assigned(para) do
                   begin
                   if para^.data^.deftype = formaldef then
                     argnames := argnames+'3var'
                     else
                     begin
                     arglength := length(para^.data^.sym^.name);
                     argnames := argnames + tostr(arglength)+para^.data^.sym^.name;
                     end;
                   para := para^.next;
                   end;
                ipd^.isstabwritten := true;
                newrec := strpnew(p^.name+'::'+ipd^.numberstring
                     +'=##'+pd^.retdef^.numberstring+';:'+argnames+';2A'
                     +virtualind+';');
              {   getmem(newrec,2048);
                 strpcopy(newrec,p^.name+'::'+ipd^.numberstring+'=#'
                     in readstabs.c from gdb v4.16
                     first argument should be domain type
                     what is this ???
                     +pd^.retdef^.numberstring+',');
                 strpcopy(strend(newrec),','+pd^.retdef^.numberstring);
                 para := pd^.para1;
                 while assigned(para) do
                   begin
                   strpcopy(strend(newrec),','+para^.data^.numberstring);
                   para := para^.next;
                   end;
               strpcopy(strend(newrec),';:;2A'+virtualind+';');}

               strcat(StabRecstring,newrec);
               {freemem(newrec,2048);    }
               strdispose(newrec);
               {This should be used for case !!}
               RecOffset := RecOffset + pd^.size;
       end;
    end;

    function tobjectdef.stabstring : pchar;
      var anc : pobjectdef;
          oldohv : boolean;
          oldrec : pchar;
      begin
      oldrec := stabrecstring;
      GetMem(stabrecstring,2048);
      strpcopy(stabRecString,'s'+tostr(size));
      if assigned(childof) then
        {only one ancestor not virtual, public, at base offset 0 }
        {       !1           ,    0       2         0    ,       }
        strpcopy(strend(stabrecstring),'!1,020,'+childof^.numberstring+';');
      {virtual table to implement yet}
      RecOffset := 0;
{$ifdef tp}
         publicsyms^.foreach(addname);
         if (options and oo_hasvirtual) <> 0 then
           if not assigned(childof) or ((childof^.options and oo_hasvirtual) = 0) then
             strpcopy(strend(stabrecstring),'$vf'+numberstring+':'+typeglobalnumber('vtblarray')+',0;');
         publicsyms^.foreach(addprocname);
{$else}
         publicsyms^.foreach(@addname);
         if (options and oo_hasvirtual) <> 0  then
           if not assigned(childof) or ((childof^.options and oo_hasvirtual) = 0) then
             strpcopy(strend(stabrecstring),'$vf'+numberstring+':'+typeglobalnumber('vtblarray')+',0;');
         publicsyms^.foreach(@addprocname);
{$endif}
      if (options and oo_hasvirtual) <> 0  then
        begin
        anc := @self;
        while assigned(anc^.childof) and ((anc^.childof^.options and oo_hasvirtual) <> 0) do
          anc := anc^.childof;
        strpcopy(strend(stabRecString),';~%'+anc^.numberstring+';');
        end else
        strpcopy(strend(stabRecString),';');
      stabstring := strnew(StabRecString);
      freemem(stabrecstring,2048);
      stabrecstring := oldrec;
      end;

{$endif GDB}

{**************************************
               TERRORDEF
 **************************************}

   constructor terrordef.init;

     begin
        tdef.init;
        deftype:=errordef;
     end;

{$ifdef GDB}
    function terrordef.stabstring : pchar;

      begin
         stabstring:=strpnew('error'+numberstring);
      end;

{$endif GDB}

   procedure init_symtable;

     begin
        read_member:=false;
        generrorsym:=new(perrorsym,init);
        swurzel:=nil;
        { readunit_lastloaded:=nil; }
{$ifdef GDB}
        firstglobaldef:=nil;
        lastglobaldef:=nil;
{$endif GDB}
        commandlinedefines.init;
        globaltypecount:=1;
        pglobaltypecount:=@globaltypecount;
     end;

   procedure reset_gdb_info;
     var def : pdef;
     begin
{$ifdef GDB }
        def:=firstglobaldef;
        GlobalTypeCount:=1;
        pglobaltypecount:=@globaltypecount;
        while assigned(def) do
          begin
              if assigned(def^.sym) then
                def^.sym^.isusedinstab:=false;
              def^.isstabwritten:=false;
              def^.globalnb:=0;
              def:=def^.nextglobal;
          end;
{$endif GDB }
     end;

   procedure done_symtable;

      var
         p : psymtable;

      begin
        dispose(generrorsym,done);
        dispose_global:=true;
        while assigned(symtablestack) do dellexlevel;
{$ifndef GDB}
        dispose(generrordef,done);
        dispose(s32bitdef,done);
        dispose(cstringdef,done);
        dispose(cchardef,done);
        dispose(cs64realdef,done);
        { !!!!!! u32bit ?}

         { sonstige verwendete Definitionen: }
         {dispose(voiddef,done); belongs to system !}

        dispose(u8bitdef,done);
        dispose(u16bitdef,done);
        dispose(booldef,done);
        dispose(voidpointerdef,done);
{$endif GDB}
        commandlinedefines.done;
     end;

end.
