{****************************************************************************

                 Copyright (c) 1993,97 by Florian Klaempfl

 ****************************************************************************}

unit cgai386;

  interface

    uses
       objects,cobjects,errors,systems,globals,tree,symtable,types,strings,
       pass_1,hcodegen,aasm,i386,tgeni386,files;

    procedure floatload(t : tfloattype;const ref : treference);
    procedure floatstore(t : tfloattype;const ref : treference);
    procedure floatloadops(t : tfloattype;var op : tasmop;var s : topsize);
    procedure floatstoreops(t : tfloattype;var op : tasmop;var s : topsize);

    procedure firstcomplex(p : ptree);
    procedure secondfuncret(var p : ptree);

    { initialize respectively terminates the code generator }
    { for a new module or procedure                         }
    procedure codegen_doneprocedure;
    procedure codegen_donemodule;
    procedure codegen_newmodule;
    procedure codegen_newprocedure;

  implementation

    procedure floatloadops(t : tfloattype;var op : tasmop;var s : topsize);

      begin
         case t of
            s32real : begin
                         op:=A_FLD;
                         s:=S_S;
                      end;
            s64real : begin
                         op:=A_FLD;
                         s:=S_L;
                      end;
            s80real : begin
                         op:=A_FLD;
                         s:=S_Q;
                      end;
            s64bit : begin
                         op:=A_FILD;
                         s:=S_Q;
                      end;
            else internalerror(17);
         end;
      end;

    procedure floatload(t : tfloattype;const ref : treference);

      var
         op : tasmop;
         s : topsize;

      begin
         floatloadops(t,op,s);
         exprasmlist^.concat(new(pai386,op_ref(op,s,
           newreference(ref))));
      end;

    procedure floatstoreops(t : tfloattype;var op : tasmop;var s : topsize);

      begin
         case t of
            s32real : begin
                         op:=A_FSTP;
                         s:=S_S;
                      end;
            s64real : begin
                         op:=A_FSTP;
                         s:=S_L;
                      end;
            s80real : begin
                         op:=A_FSTP;
                         s:=S_Q;
                      end;
            s64bit : begin
                         op:=A_FISTP;
                         s:=S_Q;
                      end;
            else internalerror(17);
         end;
      end;

    procedure floatstore(t : tfloattype;const ref : treference);

      var
         op : tasmop;
         s : topsize;

      begin
         floatstoreops(t,op,s);
         exprasmlist^.concat(new(pai386,op_ref(op,s,
           newreference(ref))));
      end;

    procedure firstcomplex(p : ptree);

      var
         hp : ptree;

      begin
         { always calculate boolean AND and OR from left to right }
         if ((p^.treetype=orn) or (p^.treetype=andn)) and
           (p^.left^.resulttype^.deftype=orddef) and
           (porddef(p^.left^.resulttype)^.typ=bool8bit) then
           p^.swaped:=false
         else if (p^.left^.registers32<p^.right^.registers32)

           { the following check is appropriate, because all }
           { 4 registers are rarely used and it is thereby   }
           { achieved that the extra code is being dropped   }
           { by exchanging not commutative operators         }
           and (p^.right^.registers32<=4) then
           begin
              hp:=p^.left;
              p^.left:=p^.right;
              p^.right:=hp;
              p^.swaped:=true;
           end
         else p^.swaped:=false;
      end;

    procedure secondfuncret(var p : ptree);

      var
         hregister : tregister;

      begin
         clear_reference(p^.location.reference);
         p^.location.reference.base:=procinfo.framepointer;
         p^.location.reference.offset:=procinfo.retoffset;
         if (procinfo.retdef^.deftype=arraydef) or
            (procinfo.retdef^.deftype=stringdef) or
            (procinfo.retdef^.deftype=objectdef) or
            (procinfo.retdef^.deftype=recorddef) or
            (
             (procinfo.retdef^.deftype=setdef) and
             (psetdef(procinfo.retdef)^.settype<>smallset)
            ) then
           begin
              hregister:=getregister32;
              exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,newreference(p^.location.reference),hregister)));
              p^.location.reference.base:=hregister;
              p^.location.reference.offset:=0;
           end;
      end;

    procedure codegen_newprocedure;

      begin
         aktbreaklabel:=0;
         aktcontinuelabel:=0;
         { aktexitlabel:=0; is store in oldaktexitlabel
           so it must not be reset to zero before this storage !}

         { the type of this lists isn't important }
         { because the code of this lists is      }
         { copied to the code segment             }
         procinfo.aktentrycode:=new(paasmoutput,init);
         procinfo.aktexitcode:=new(paasmoutput,init);
         procinfo.aktproccode:=new(paasmoutput,init);
      end;

    procedure codegen_doneprocedure;

      begin
         dispose(procinfo.aktentrycode,done);
         dispose(procinfo.aktexitcode,done);
         dispose(procinfo.aktproccode,done);
      end;

    procedure codegen_newmodule;

      begin
         exprasmlist:=new(paasmoutput,init);
      end;

    procedure codegen_donemodule;

      begin
         dispose(exprasmlist,done);
         dispose(codesegment,done);
         dispose(bsssegment,done);
         dispose(datasegment,done);
         dispose(debuglist,done);
         dispose(externals,done);
         dispose(consts,done);
      end;

  end.
