{***************************************************************************

                     Copyright (c) 1996,97 by Florian Klaempfl

 ***************************************************************************}
{$ifndef FPK}
{$define TP}
{$endif FPK}
unit sysutils;

  interface

{$ifdef TP}
{$G+}
  uses
     objects;

  type
       exception = object(TObject)
{$else}
  type
       exception = class { always derived from tobject }
{$endif TP}
          public
             constructor create(const msg : string);
             destructor destroy;virtual; { must be overriden }
       end;

       tjmprec = record
{$ifdef TP}
          _ax,_bx,_cx,_dx,_si,_di,_bp,_sp,_ip,flags : word;
          _cs,_ds,_es,_ss : word;
{$else}
          eax,ebx,ecx,edx,esi,edi,ebp,esp,eip,flags : longint;
          cs,ds,es,fs,gs,ss : word;
{$endif TP}
          { we should also save the FPU state, if we use this for excpections }
          { and the compiler supports FPU register variables }
       end;

       pexception_handler = ^texception_handler;

       texception_handler = record
          e : texception;
          addr : longint;
          next : pexception_handler;
          handler : tjmprec;
       end;

{$ifdef TP}
    { used by raise and try }
    function setjmp(var rec : tjmprec) : integer;far;
    procedure longjmp(const rec : tjmprec;return_value : integer);far;
{$else}
    { used by raise and try }
    function setjmp(var rec : tjmprec) : longint;
    procedure longjmp(const rec : tjmprec;return_value : longint);
{$endif TP}

    var
       exception_handler : pexception_handler;

  implementation

    var
       last_handler : texception_handler;

    constructor exception.create(const msg : string);

      begin
{$ifdef TP}
        { FPKPascal has some problems with FAIL }
        if not inherited Init then
          Fail;
{$endif TP}
      end;

    destructor exception.destroy;

      begin
{$ifdef TP}
        { FPKPascal has some problems with TObject isn't defined }
        inherited Done;
{$endif TP}        
      end;

{$ifdef TP}
{$S-}
    function setjmp(var rec : tjmprec) : integer;

      begin
         asm
            push di
            push es
            les di,rec
            mov es:[di].tjmprec._ax,ax
            mov es:[di].tjmprec._bx,bx
            mov es:[di].tjmprec._cx,cx
            mov es:[di].tjmprec._dx,dx
            mov es:[di].tjmprec._si,si

            { load di }
            mov ax,[bp-4]

            { ... and store it }
            mov es:[di].tjmprec._di,ax

            { load es }
            mov ax,[bp-6]

            { ... and store it }
            mov es:[di].tjmprec._es,ax

            { bp ... }
            mov ax,[bp]
            mov es:[di].tjmprec._bp,ax

            { sp ... }
            mov ax,bp
            add ax,10
            mov es:[di].tjmprec._sp,ax

            { the return address }
            mov ax,[bp+2]
            mov es:[di].tjmprec._ip,ax
            mov ax,[bp+4]
            mov es:[di].tjmprec._cs,ax

            { flags ... }
            pushf
            pop word ptr es:[di].tjmprec.flags

            mov es:[di].tjmprec._ds,ds
            mov es:[di].tjmprec._ss,ss

            { restore es:di }
            pop es
            pop di

            { we come from the initial call }
            xor ax,ax
            leave
            retf 4
         end;
      end;

{$else}

    function setjmp(var rec : tjmprec) : longint;

      begin
         asm
            pushl %edi
            movl rec,%edi
            movl %eax,(%edi)
            movl %ebx,4(%edi)
            movl %ecx,8(%edi)
            movl %edx,12(%edi)
            movl %esi,16(%edi)

            { load edi }
            movl -4(%ebp),%eax

            { ... and store it }
            movl %eax,20(%edi)

            { ebp ... }
            movl (%ebp),%eax
            movl %eax,24(%edi)

            { esp ... }
            movl %esp,%eax
            addl $12,%eax
            movl %eax,28(%edi)

            { the return address }
            movl 4(%ebp),%eax
            movl %eax,32(%edi)

            { flags ... }
            pushfl
            popl 36(%edi)

            { !!!!! the segment registers, not yet needed
            movw %cs,40(%edi)
            movw %ds,42(%edi)
            movw %es,44(%edi)
            movw %fs,46(%edi)
            movw %gs,48(%edi)
            movw %ss,50(%edi)
            }

            { restore EDI }
            pop %edi

            { we come from the initial call }
            xorl %eax,%eax

            leave
            ret $4
         end;
      end;
{$endif TP}

{$ifdef TP}
    procedure longjmp(const rec : tjmprec;return_value : integer);

      begin
         asm

            { this is the address of rec }
            lds di,rec

            { save return value }
            mov ax,return_value
            mov ds:[di].tjmprec._ax,ax

            { restore compiler shit }
            pop bp

            { restore some registers }
            mov bx,ds:[di].tjmprec._bx
            mov cx,ds:[di].tjmprec._cx
            mov dx,ds:[di].tjmprec._dx
            mov bp,ds:[di].tjmprec._bp

            { create a stack frame for the return }
            mov es,ds:[di].tjmprec._ss
            mov si,ds:[di].tjmprec._sp

            sub si,12

            { store ds }
            mov ax,ds:[di].tjmprec._ds
            mov es:[si],ax

            { store di }
            mov ax,ds:[di].tjmprec._di
            mov es:[si+2],ax

            { store si }
            mov ax,ds:[di].tjmprec._si
            mov es:[si+4],ax

            { store flags }
            mov ax,ds:[di].tjmprec.flags
            mov es:[si+6],ax

            { store ip }
            mov ax,ds:[di].tjmprec._ip
            mov es:[si+8],ax

            { store cs }
            mov ax,ds:[di].tjmprec._cs
            mov es:[si+10],ax

            { load stack }
            mov ax,es
            mov ss,ax
            mov sp,si

            { load return value }
            mov ax,ds:[di].tjmprec._ax

            { load old ES }
            mov es,ds:[di].tjmprec._es

            pop ds
            pop di
            pop si

            popf
            retf
         end;
      end;
{$else}

    procedure longjmp(const rec : tjmprec;return_value : longint);

      begin
         asm
            { restore compiler shit }
            popl %ebp
            { this is the address of rec }
            movl 4(%esp),%edi

            { save return value }
            movl 8(%esp),%eax
            movl %eax,0(%edi)

            { !!!!! load segment registers
            movw 46(%edi),%fs
            movw 48(%edi),%gs
            }

            { ... and some other registers }
            movl 4(%edi),%ebx
            movl 8(%edi),%ecx
            movl 12(%edi),%edx
            movl 24(%edi),%ebp

            { !!!!! movw 50(%edi),%es }
            movl 28(%edi),%esi

            { create a stack frame for the return }
            subl $16,%esi

            {
            movzwl 42(%edi),%eax
            { !!!!! es }
            movl %eax,(%esi)
            }

            { edi }
            movl 20(%edi),%eax
            { !!!!! es }
            movl %eax,(%esi)

            { esi }
            movl 16(%edi),%eax
            { !!!!! es }
            movl %eax,4(%esi)

            { eip }
            movl 32(%edi),%eax
            { !!!!! es }
            movl %eax,12(%esi)

            { !!!!! cs
            movl 40(%edi),%eax
            es
            movl %eax,16(%esi)
            }

            { load and store flags }
            movl 36(%edi),%eax
            { !!!!!
            es
            }
            movl %eax,8(%esi)

            { load return value }
            movl 0(%edi),%eax

            { load old ES
            !!!!! movw 44(%edi),%es
            }

            { load stack
            !!!!! movw 50(%edi),%ss }
            movl %esi,%esp

            { !!!!
            popl %ds
            }
            popl %edi
            popl %esi

            popfl
            ret
         end;
      end;
{$endif TP}

{$ifndef not TP}
    function test_type(obj,cl : pointer) : boolean;[public,alias: 'DO_IS'];

      var
         vmt : pointer;

      begin
         if obj=nil then
           begin
              test_type:=false;
              exit;
           end;
         { get vmt of instance }
         vmt:=pointer(obj^);
         test_type:=true;
         while assigned(vmt) do
           begin
              if cl=vmt then
                exit;
              vmt:=pointer((vmt+8)^);
           end;
         test_type:=false;
      end;

    procedure test_as(obj,cl : pointer);[public,alias: 'DO_AS'];

      begin
         if obj=nil then
           exit;
         if not(test_type(obj,cl)) then
           raise tinvalidcast.create('');
      end;

    procedure do_raise(e : texception;addr : longint);[public,alias: 'DO_RAISE'];

      begin
         exception_handler^.e:=e;
         exception_handler^.addr:=addr;
         longjmp(exception^.handler,1);
      end;

    procedure do_reraise;[public,alias: 'DO_RERAISE'];

      var
         old_exception_handler : pexception_handler;

      begin
         exception_handler^.next^.e:=exception_handler^.e;
         exception_handler^.next^.addr:=exception_handler^.addr;
         old_exception_handler:=exception_handler;
         exception_handler:=exception_handler^.next;
         dispose(old_exception_handler);
         longjmp(exception^.handler,1);
      end;

    procedure default_exception_handler;

      begin
         if setjmp(last_handler.handler)<>0 then
           { this was an exception }
           begin
              writeln('Unhandled exception at ',last_handler.addr,': ',
                last_handler.e.message);
              last_handler.e.free;
              halt(1);
           end
      end;

begin
   { install default handler }
   last_handler.next:=0;
   default_exception_handler;
end.

{$endif not TP}
