{$ifdef tp}
{$E+,N+}
{$endif}
{****************************************************************************

                    Copyright (c) 1993,97 by Florian Klaempfl

 ****************************************************************************}

unit globals;

  interface

    uses
       objects,cobjects,dos,strings,verbose;

    type
       { later moved to system unit }
       aword = longint;

    const
       { version string }
       version_nr = '0';
       release_nr = '9';
       patch_nr = '2';
{$ifdef i386}
       target = 'i386';
{$endif}
{$ifdef m68k}
       target = 'M68k'
{$endif}
{$ifdef alpha}
       target = 'Alpha';
{$endif}

{$ifdef Splitheap}
       testsplit : boolean = false;
{$endif Splitheap}

       version_string = version_nr+'.'+release_nr+'.'+patch_nr
{$ifdef tp}
{$else}
       +' 386'
{$endif}
       +' for '+target;

       { max. significant length of strings }
       maxidlen = 64;

    type
{$ifdef NSCANNER}
    ttoken = (PLUS,MINUS,STAR,SLASH,EQUAL,GT,LT,LECKKLAMMER,RECKKLAMMER,
		 POINT,COMMA,LKLAMMER,RKLAMMER,COLON,SEMICOLON,CARET,
		 KLAMMERAFFE,ASSIGNMENT,UNEQUAL,LTE,GTE,POINTPOINT,
		 ID,REALNUMBER,_EOF,INTCONST,CSTRING,CCHAR,
    _ABSOLUTE,
    _AND,
    _ARRAY,
    _ASM,
    _ASSEMBLER,
    _BEGIN,
    _BREAK,
    _CASE,
    _CONST,
    _CONSTRUCTOR,
    _CONTINUE,
    _DESTRUCTOR,
    _DISPOSE,
    _DIV,
    _DO,
    _DOWNTO,
    _ELSE,
    _END,
    _EXIT,
    _EXPORT,
    _EXPORTS,
    _EXTERNAL,
    _FAIL,
    _FALSE,
    _FAR,
    _FILE,
    _FOR,
    _FORWARD,
    _FUNCTION,
    _GOTO,
    _IF,
    _INDEX,
    _IMPLEMENTATION,
    _IN,
    _INHERITED,
    _INLINE,
    _INTERFACE,
    _INTERRUPT,
    _LABEL,
    _LIBRARY,
    _MOD,
    _NAME,
    _NEAR,
    _NEW,
    _NIL,
    _NOT,
    _OBJECT,
    _OF,
    _OR,
    _OTHERWISE,
    _PACKED,
    _PRIVATE,
    _PROCEDURE,
    _PROGRAM,
    _PROTECTED,
    _PUBLIC,
    _RECORD,
    _REPEAT,
    _RESIDENT,
    _SELF,
    _SET,
    _SHL,
    _SHR,
    _STRING,
    _THEN,
    _TO,
    _TRUE,
    _TYPE,
    _UNIT,
    _UNTIL,
    _USES,
    _VAR,
    _VIRTUAL,
    _WHILE,
    _WITH,
    _XOR,


		 { since Delphi 2 }
		 _CLASS,_EXCEPT,_TRY,_ON,_AS,_IS,_ABSTRACT,
		 _INITIALIZATION,_FINALLY,_PROPERTY,
		 _RAISE,
		 { for operator overloading }
		 _OPERATOR,
		 { C like operators }
		 _PLUSASN,_MINUSASN,_ANDASN,_ORASN,_STARASN,_SLASHASN,
		 _MODASN,_DIVASN,_NOTASN,_XORASN
		 );
{$else}
       ttoken = (PLUS,MINUS,STAR,SLASH,EQUAL,GT,LT,LECKKLAMMER,RECKKLAMMER,
                 POINT,COMMA,LKLAMMER,RKLAMMER,COLON,SEMICOLON,CARET,
                 KLAMMERAFFE,ASSIGNMENT,UNEQUAL,LTE,GTE,POINTPOINT,
                 ID,REALNUMBER,_EOF,INTCONST,CSTRING,CCHAR,

                 _ABSOLUTE,_AND,_ARRAY,_ASM,_ASSEMBLER,_BEGIN,
                 _BREAK,_CASE,_CONST,_CONSTRUCTOR,_CONTINUE,
                 _DESTRUCTOR,_DISPOSE,_DIV,_DO,_DOWNTO,_ELSE,_END,
                 _EXIT,_EXPORT,_EXTERNAL,_FAIL,_FALSE,_FAR,_FILE,_FOR,
                 _FORWARD,_FUNCTION,_GOTO,_IF,_IMPLEMENTATION,_IN,
                 _INHERITED,_INLINE,_INTERFACE,_INTERRUPT,
                 _LABEL,_MOD,_NEAR,_NEW,_NIL,_NOT,_OBJECT,
                 _OF,_OTHERWISE,_OR,_PACKED,_PRIVATE,
                 _PROCEDURE,_PROGRAM,_PROTECTED,_PUBLIC,
                 _RECORD,_REPEAT,_SELF,
                 _SET,_SHL,_SHR,_STRING,_THEN,_TO,
                 _TRUE,_TYPE,_UNIT,_UNTIL,
                 _USES,_VAR,_VIRTUAL,_WHILE,_WITH,_XOR,
                 { since Delphi 2 }
                 _CLASS,_EXCEPT,_TRY,_ON,_AS,_IS,_ABSTRACT,
                 _LIBRARY,_INITIALIZATION,_FINALLY,_EXPORTS,_PROPERTY,
                 _RAISE,
                 { for operator overloading }
                 _OPERATOR,

                 { C like operators }
                 _PLUSASN,_MINUSASN,_ANDASN,_ORASN,_STARASN,_SLASHASN,
                 _MODASN,_DIVASN,_NOTASN,_XORASN
                 );
{$endif}

       tcswitch = (cs_check_overflow,cs_maxoptimieren,
         cs_omitstackframe,cs_littlesize,cs_optimize,cs_debuginfo,
         cs_compilesystem,cs_rangechecking,cs_support_goto,
         cs_check_unit_name,cs_iocheck,cs_checkconsname,
         cs_check_stack,cs_no_overloaded_procedures);

       tcswitches = set of tcswitch;

       pcswitches = ^tcswitches;

       stringid = string[maxidlen];

       pdouble = ^double;

       pbyte = ^byte;

       plongint = ^longint;

       tprocessors = (i386,i486,pentium,pentiumpro);

       tof = (of_o,of_obj,of_wasm,of_att,of_nasm);

       tcompilerstate = record
          switches : tcswitches;
          exprlevel : byte;
       end;

       { this type will be sent from the compiler to the IDE to make up a }
       { status window                                                    }
       tcompilestatus = record
          { filename }
          currentsource : string;

          { current line number }
          currentline : longint;

          { will implement a percentage bar         }

          { the number of lines which are compiled  }
          totalcompiledlines : longint;

          { Note:                                   }
          { it's possible that totallines is zero,  }
          { this means the compiler didn't know the }
          { total lines                             }
          totallines : longint;
       end;

       { such a procedure is called from the compiler, }
       { to put some informations to the ide etc.      }
       { if the function returns true, the compiler    }
       { stops                                         }
       tcompilestatusproc = function(const status : tcompilestatus) : boolean;

    var
       compilestatusproc : tcompilestatusproc;

       inputdir : string[80];
       inputfile : string;
       inputextension : extstr;
       linkresponse : text;

       { some flags for global compiler switches }
       do_build,do_make,writeasmfile,externasm,quiet,veryverbose : boolean;

       { path for searching units, different paths can be seperated by ; }
       unitsearchpath : string;

       initswitches : tcswitches;
       initexprlevel : byte;
       { alignement of records }
       initpackrecords : word;

       { current state state }
       aktswitches : tcswitches;
       aktexprlevel : byte;
       aktpackrecords : word;


       exepath : dirstr;           { Pfad zur PP.EXE um PPU-Dateien   }
                                   { in diesem Verzeichnis suchen zu  }
                                   { koennen                          }

       gcclibpath : dirstr;        { We need to link with gcc in Linux }
       linux_elf,linux_linktoc : boolean; { To control linking process (LINUX) }

       abslines : longint;         { number of lines which are compiled }
       first_local_use : longint;  { checks local variable use }
       Must_be_valid : boolean;    { should the variable already have a value }

       codegeneration : boolean;   { wird auf false gesetzt wenn einfacher   }
                                   { Fehler auftritt und damit keine Ausgabe }
                                   { erfolgen soll                           }
{$ifdef TP}
       use_big : boolean;          { true, wenn die "groe"-Compilerversion }
                                   { gewhlt werden soll, mit EMS-Nutzung   }
{$ifndef dpmi}
       symbolstream : temsstream;  { stream which is used to store some     }
                                   { informtions to use not much DOS memory }
{$else}
       symbolstream: tmemorystream;
{$endif}
                                   { die Symbole abgelegt werden              }
{$endif}
       gendeffile  : boolean;      { true, wenn eine DEF-Datei erzeugt werden soll }
       genpm : boolean;            { true, wenn in DEF-Datei WINDOWAPI angegeben werden soll }
       description : string;       { gibt die Beschreibung in der DEF-Datei an     }
       defdatei : text;            { Textdatei fr DEF-Datei }

       linkofiles : tstringcontainer;
       opt_processors : tprocessors;
       output_format : tof;

       { true, if C styled macros should be allowed  }
       { boolean and not a set element, because it's }
       { asked _very_ often                          }
       support_macros : boolean;

       { true, if inline like in C++ should be supported }
       support_inline : boolean;

       language : char;

       warnings : boolean;

       { use operators like in C (/=,*=, etc. }
       c_like_operators : boolean;

    function upper(const s : string) : string;
    procedure uppervar(var s : string);
    function tostr(i : longint) : string;
    function tostr_with_plus(i : longint) : string;
    procedure globalsinit;
    function ibm2ascii(const s : string) : string;
    function double2str(d : double) : string;
    procedure setstring(var p : pchar;const s : string);
    function bstoslash(s : string) : string;

    { FPK Pascal knows lowercase }
    function lowercase(s : string) : string;

    function min(a,b : longint) : longint;
    function max(a,b : longint) : longint;

    { sucht Datei mit Namen f in den in path angegebenen Verzeichnissen }
    function  filetimestring( t : longint) : string;
    function search(const f : string;path : string;var b : boolean) : string;

{$ifdef debug}
    { if the pointer don't point to the heap then write an error }
    function assigned(p : pointer) : boolean;
{$endif}
    function ispowerof2(value : longint;var power : longint) : boolean;

  implementation

    function double2str(d : double) : string;

      var
         hs : string;

      begin
         str(d,hs);
         { replace space with + }
         if (output_format=of_att) or (output_format=of_o) then
           begin
              if hs[1]=' ' then
                hs[1]:='+';
              double2str:='0d'+hs
           end
         else
           double2str:=hs;
      end;

    function ispowerof2(value : longint;var power : longint) : boolean;

      var
         hl : longint;
         i : longint;

      begin
         hl:=1;
         ispowerof2:=true;
         for i:=0 to 31 do
           begin
              if hl=value then
                begin
                   power:=i;
                   exit;
                end;
              hl:=hl shl 1;
           end;
         ispowerof2:=false;
      end;

    function lowercase(s : string) : string;

      var
         i : longint;

      begin
         for i := 1 to length (s) do
           s[i]:=cobjects.lowercase(s[i]);
         lowercase:=s;
      end;

    { used with the debugger option for the filename }
    { because AS.EXE doesnt like '\'                 }
    function bstoslash(s : string) : string;

      begin
         while pos('\',s)>0 do
           s[pos('\',s)]:='/';
         bstoslash:=s;
      end;

  {$ifdef debug}

    function assigned(p : pointer) : boolean;

      var
         lp : longint;

      begin
  {$ifdef FPK}
         lp:=longint(p);
  {$else}
    {$ifdef DPMI}
         assigned:=(p<>nil);
         exit;
    {$else DPMI}
         if p=nil then
           lp:=0
         else
           lp:=longint(ptrrec(p).seg)*16+longint(ptrrec(p).ofs);
         if (lp<>0) and
            ((lp<longint(seg(heaporg^))*16+longint(ofs(heaporg^))) or
            (lp>longint(seg(heapptr^))*16+longint(ofs(heapptr^)))) then
           runerror(230);
    {$endif DPMI}
  {$endif FPK}
         assigned:=lp<>0;
      end;

  {$endif}

    function min(a,b : longint) : longint;

      begin
         if a>b then
           min:=b
         else min:=a;
      end;

    function max(a,b : longint) : longint;

      begin
         if a<b then
           max:=b
         else max:=a;
      end;

    function ibm2ascii(const s : string) : string;

      var
         i : integer;
         hs : string;
         b : byte;

      begin
         hs:='';
         for i:=1 to length(s) do
           if ((ord(s[i])>127) or (ord(s[i])<32)) or (s[i]='"') then
             begin
                b:=ord(s[i]);
                hs:=hs+'\'+tostr(b div 64);
                b:=b mod 64;
                hs:=hs+tostr(b div 8);
                b:=b mod 8;
                hs:=hs+tostr(b);
                if (i<length(s)) and
                  (ord(s[i+1])>=48) and  (ord(s[i+1])<=57) then
                  hs:=hs+'","';
             end
           else if s[i]='\' then
             hs:=hs+'\\'
           else hs:=hs+s[i];
         ibm2ascii:=hs;
      end;

    function upper(const s : string) : string;

      var i : integer;
          hs : string;

      begin
         hs:='';
         for i:=1 to length(s) do
  	   hs:=hs+upcase(s[i]);
  	 upper:=hs;
      end;

    procedure uppervar(var s : string);

      var
         i : integer;

      begin
         for i:=1 to length(s) do
           s[i]:=upcase(s[i]);
      end;

   function tostr(i : longint) : string;

     var hs : string;

     begin
        str(i,hs);
        tostr:=hs;
     end;

   function tostr_with_plus(i : longint) : string;

     var hs : string;

     begin
        str(i,hs);
        if i>=0 then
          tostr_with_plus:='+'+hs
        else
          tostr_with_plus:=hs;
     end;

   procedure setstring(var p : pchar;const s : string);

     begin
{$ifdef TP}
        if use_big then
          begin
              p:=pchar(symbolstream.getsize);
              symbolstream.seek(longint(p));
             symbolstream.writestr(@s);
          end
        else
{$endif TP}
          p:=strpnew(s);
     end;

   function  filetimestring( t : longint) : string;
     var
         DT : DateTime;
     begin
        unpacktime(t,DT);
        filetimestring:=tostr(DT.Year)+'/'+tostr(DT.Month)+'/'+tostr(DT.Day)
                       +' '+tostr(DT.Hour)+':'+tostr(DT.min)+':'+tostr(DT.sec);
     end;

   function search(const f : string;path : string;var b : boolean) : string;

     var
        dirinfo : searchrec;
        singlepathstring : string;
        start,pos : byte;

     begin
        start:=1;
        b:=true;
        search:='';
        repeat
          pos:=system.pos(';',path);
          if pos=0 then
            pos:=length(path)+1;
          singlepathstring:=copy(path,start,pos-start);
          delete(path,start,pos-start+1);
{$ifndef LINUX}
          findfirst(singlepathstring+'\'+f,anyfile,dirinfo);
          comment (V_tried,'Searching : '+singlepathstring+'\'+f);
{$else}
          findfirst(singlepathstring+'/'+f,anyfile,dirinfo);
          comment (V_tried,'Searching : '+singlepathstring+'/'+f);
  {$endif}
          if doserror=0 then
            begin
{$ifndef LINUX}
               search:=singlepathstring+'\';
{$else}
               search:=singlepathstring+'/';
{$endif not LINUX}
               exit;
            end;
        until path='';
        b:=false;
     end;

   procedure globalsinit;

     begin
        { set global (for any file) compiler switches }
        opt_processors:=i386;
        output_format:=of_o;
        writeasmfile:=false;
        externasm:=false;
        quiet:=true;
        veryverbose:=false;
        warnings:=true;
        do_build:=false;
        do_make:=true;
        language:='E';
        gendeffile:=false;
        genpm:=false;
        description:='compiled by FPKPascal';

        { set the local switches informations }
        initswitches:=[cs_check_unit_name];
        initexprlevel:=1;
        initpackrecords:=2;

        { statistic value }
        abslines:=1;
{$ifdef tp}
        use_big:=false;
{$endif tp}
        { init container for files to link }
        linkofiles.init;
        linux_elf:=false;
        linux_linktoc:=false;
        linkofiles.doubles:=false;

        support_macros:=false;
        support_inline:=false;
        c_like_operators:=false;
        first_local_use:=0;
        must_be_valid:=true;
     end;

end.
