{$ifdef tp}
{$E+,N+,D+,L+,Y-}
{$ifdef usepmd}
{$D-}
{$endif usepmd}
{$endif}
{****************************************************************************

                  Copyright (c) 1993,97 by Florian Klaempfl

 ****************************************************************************}

{
  this unit generates i386 (or better) assembler from the parse tree

  + feature added
  - removed
  * bug fixed or changed

  History (started with version 0.9.0):
      23th october 1996:
         + some emit calls replaced
      24th october 1996:
         * for bug fixed
      26th october 1996:
         * english comments
       5th november 1996:
         * new init and terminate code
}

unit cgi386;

  interface

    uses
       objects,verbose,cobjects,errors,systems,globals,tree,
       symtable,types,strings,pass_1,hcodegen,
       aasm,i386,tgeni386,files,cgai386;

    { produces assembler for the expression in variable p }
    { and produces an assembler node at the end           }
    procedure generatecode(var p : ptree);

    { produces the actual code }
    function do_secondpass(var p : ptree) : boolean;

    { produces jumps to true respectively false labels using boolean expressions }
    procedure maketojumpbool(p : ptree);

    procedure concatcopy(source,dest : treference;size : longint;delsource : boolean);

    { see implementation }
    procedure maybe_loadesi;

  implementation

    procedure secondpass(var p : ptree);forward;

    procedure error(const t : terrorconst);

      begin
         if not(codegenerror) then
           errors.error(t);
         codegenerror:=true;
      end;

    type
       secondpassproc = procedure(var p : ptree);

    procedure emitl(op : tasmop;l : tlabel);

      begin
         if op=A_LABEL then
           exprasmlist^.concat(new(pai_label,init(l)))
         else
           exprasmlist^.concat(new(pai_labeled386,init(op,l)))
      end;

    procedure emit_reg_reg(i : tasmop;s : topsize;reg1,reg2 : tregister);

      begin
         if (reg1<>reg2) or (i<>A_MOV) then
           exprasmlist^.concat(new(pai386,op_reg_reg(i,s,reg1,reg2)));
      end;

    procedure maketojumpbool(p : ptree);

      begin
         if p^.error then
           exit;
         if (p^.resulttype^.deftype=orddef) and
            (porddef(p^.resulttype)^.typ=bool8bit) then
           begin
              if is_constboolnode(p) then
                begin
                   if p^.value<>0 then
                     emitl(A_JMP,truelabel)
                   else emitl(A_JMP,falselabel);
                end
              else
                begin
                   case p^.location.loc of
                      LOC_CREGISTER,LOC_REGISTER : begin
                                        exprasmlist^.concat(new(pai386,op_reg_reg(A_OR,S_B,p^.location.register,
                                          p^.location.register)));
                                        ungetregister32(reg8toreg32(p^.location.register));
                                        emitl(A_JNZ,truelabel);
                                        emitl(A_JMP,falselabel);
                                     end;
                      LOC_MEM,LOC_REFERENCE : begin
                                        exprasmlist^.concat(new(pai386,op_const_ref(
                                          A_CMP,S_B,0,newreference(p^.location.reference))));
                                        del_reference(p^.location.reference);
                                        emitl(A_JNZ,truelabel);
                                        emitl(A_JMP,falselabel);
                                     end;
                      LOC_FLAGS : begin
                                     emitl(flag_2_jmp[p^.location.resflags],truelabel);
                                     emitl(A_JMP,falselabel);
                                  end;
                   end;
                end;
           end
         else
           error(type_mismatch);
      end;

    procedure emitoverflowcheck;

      var
         hl : tlabel;

      begin
         if cs_check_overflow in aktswitches  then
           begin
              getlabel(hl);
              emitl(A_JNO,hl);
              exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol('RE_OVERFLOW',0))));
              emitl(A_LABEL,hl);
           end;
      end;

    procedure push_int(l : longint);

      begin
         if (opt_processors<>globals.i386) and not(cs_littlesize in aktswitches) then
           begin
              if l=0 then
                begin
                   exprasmlist^.concat(new(pai386,op_reg_reg(
                     A_XOR,S_L,R_EDI,R_EDI)));
                   exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,R_EDI)));
                end
              else
                exprasmlist^.concat(new(pai386,op_const(A_PUSH,S_L,l)));
           end
         else
            exprasmlist^.concat(new(pai386,op_const(A_PUSH,S_L,l)));
      end;

    procedure emit_push_mem(const ref : treference);

      begin
         if ref.isintvalue then
           push_int(ref.offset)
         else
           begin
              if (opt_processors<>globals.i386) and not(cs_littlesize in aktswitches) then
                begin
                   exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,newreference(ref),R_EDI)));
                   exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,R_EDI)));
                end
              else exprasmlist^.concat(new(pai386,op_ref(A_PUSH,S_L,newreference(ref))));
           end;
      end;

    procedure emitpushreferenceaddr(const ref : treference);

      begin
         if ref.isintvalue then
           push_int(ref.offset)
         else
           begin
              if (ref.base=R_NO) and (ref.index=R_NO) then
                exprasmlist^.concat(new(pai386,op_csymbol(A_PUSH,S_L,newcsymbol(ref.symbol^,ref.offset))))
              else if (ref.base=R_NO) and (ref.index<>R_NO) and
                 (ref.offset=0) and (ref.scalefactor=0) and (ref.symbol=nil) then
                exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,ref.index)))
              else if (ref.base<>R_NO) and (ref.index=R_NO) and
                 (ref.offset=0) and (ref.symbol=nil) then
                exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,ref.base)))
              else
                begin
                   exprasmlist^.concat(new(pai386,op_ref_reg(A_LEA,S_L,newreference(ref),R_EDI)));
                   exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,R_EDI)));
                end;
           end;
        end;

    { if necessary ESI is reloaded after a call}
    procedure maybe_loadesi;

      var
         hp : preference;

      begin
         if assigned(procinfo._class) then
           begin
              new(hp);
              reset_reference(hp^);
              hp^.offset:=procinfo.ESI_offset;
              hp^.base:=procinfo.framepointer;
              exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_NO,hp,R_ESI)));
           end;
      end;

    {
    procedure genconstadd(size : topsize;l : longint;const str : string);

      begin
         if l=0 then
         else if l=1 then
           exprasmlist^.concat(new(pai386,op_A_INC,size,str)
         else if l=-1 then
           exprasmlist^.concat(new(pai386,op_A_INC,size,str)
         else
           exprasmlist^.concat(new(pai386,op_ADD,size,'$'+tostr(l)+','+str);
      end;
    }
    procedure concatcopy(source,dest : treference;size : longint;delsource : boolean);

      var
         ecxpushed : boolean;
         helpsize : longint;
         i : byte;
         reg8,reg32 : tregister;
         swap : boolean;

      begin

         if delsource then
           del_reference(source);

         { from 12 bytes movs is beign used }
         if (size<=8) or (not(cs_littlesize in aktswitches ) and (size<=12)) then
           begin
              helpsize:=size div 4;
              for i:=1 to helpsize do
                begin
                   exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,newreference(source),R_EDI)));
                   exprasmlist^.concat(new(pai386,op_reg_ref(A_MOV,S_L,R_EDI,newreference(dest))));
                   inc(source.offset,4);
                   inc(dest.offset,4);
                   dec(size,4);
                end;
              if size>1 then
                begin
                   exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_W,newreference(source),R_DI)));
                   exprasmlist^.concat(new(pai386,op_reg_ref(A_MOV,S_W,R_DI,newreference(dest))));
                   inc(source.offset,2);
                   inc(dest.offset,2);
                   dec(size,2);
                end;
              if size>0 then
                begin

                   { and now look for an 8 bit register }
                   swap:=false;
                   if R_EAX in unused then reg8:=R_AL
                   else if R_EBX in unused then reg8:=R_BL
                   else if R_ECX in unused then reg8:=R_CL
                   else if R_EDX in unused then reg8:=R_DL
                   else
                      begin
                         swap:=true;

                         { we need only to check 3 registers, because }
                         { one is always not index or base            }
                         if (dest.base<>R_EAX) and (dest.index<>R_EAX) then
                           begin
                              reg8:=R_AL;
                              reg32:=R_EAX;
                           end
                         else if (dest.base<>R_EBX) and (dest.index<>R_EBX) then
                           begin
                              reg8:=R_BL;
                              reg32:=R_EBX;
                           end
                         else if (dest.base<>R_ECX) and (dest.index<>R_ECX) then
                           begin
                              reg8:=R_CL;
                              reg32:=R_ECX;
                           end;
                      end;
                   if swap then
                     { was earlier XCHG, of course nonsense }
                     emit_reg_reg(A_MOV,S_L,reg32,R_EDI);
                   exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_B,newreference(source),reg8)));
                   exprasmlist^.concat(new(pai386,op_reg_ref(A_MOV,S_B,reg8,newreference(dest))));
                   if swap then
                     emit_reg_reg(A_MOV,S_L,R_EDI,reg32);
                end;
           end
         else
           begin
              exprasmlist^.concat(new(pai386,op_ref_reg(A_LEA,S_L,newreference(source),R_ESI)));
              exprasmlist^.concat(new(pai386,op_ref_reg(A_LEA,S_L,newreference(dest),R_EDI)));
              if not(R_ECX in unused) then
                begin
                   exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,R_ECX)));
                   ecxpushed:=true;
                end
              else ecxpushed:=false;
              exprasmlist^.concat(new(pai386,op_none(A_CLD,S_NO)));
              if cs_littlesize in aktswitches  then
                begin

                   if size mod 4=0 then
                     begin
                        exprasmlist^.concat(new(pai386,op_const_reg(A_MOV,S_L,size div 4,R_ECX)));
                        exprasmlist^.concat(new(pai386,op_none(A_REP,S_NO)));
                        exprasmlist^.concat(new(pai386,op_none(A_MOVS,S_W)));
                     end
                   else if size mod 2=0 then
                     begin
                        exprasmlist^.concat(new(pai386,op_const_reg(A_MOV,S_L,size div 2,R_ECX)));
                        exprasmlist^.concat(new(pai386,op_none(A_REP,S_NO)));
                        exprasmlist^.concat(new(pai386,op_none(A_MOVS,S_W)));
                     end
                   else
                     begin
                        exprasmlist^.concat(new(pai386,op_const_reg(A_MOV,S_L,size,R_ECX)));
                        exprasmlist^.concat(new(pai386,op_none(A_REP,S_NO)));
                        exprasmlist^.concat(new(pai386,op_none(A_MOVS,S_B)));
                     end;
                end
              else
                begin
                   helpsize:=size-size mod 4;
                   size:=size mod 4;
                   exprasmlist^.concat(new(pai386,op_const_reg(A_MOV,S_L,helpsize div 4,R_ECX)));
                   exprasmlist^.concat(new(pai386,op_none(A_REP,S_NO)));
                   exprasmlist^.concat(new(pai386,op_none(A_MOVS,S_L)));
                   if size>1 then
                     begin
                        dec(size,2);
                        exprasmlist^.concat(new(pai386,op_none(A_MOVS,S_W)));
                     end;
                   if size=1 then
                     exprasmlist^.concat(new(pai386,op_none(A_MOVS,S_B)));
                end;
              if ecxpushed then
                exprasmlist^.concat(new(pai386,op_reg(A_POP,S_L,R_ECX)));

              { loading SELF-reference again }
              maybe_loadesi;

              if delsource then
                ungetiftemp(source);
           end;
      end;

    procedure copystring(const dref,sref : treference;len : byte);

      var
         pushed : tpushed;

      begin
         pushusedregisters(pushed,$ff);
         emitpushreferenceaddr(dref);
         emitpushreferenceaddr(sref);
         push_int(len);
         exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol('STRCOPY',0))));
         maybe_loadesi;
         popusedregisters(pushed);
      end;

    procedure restore(p : ptree);

      var
         hregister :  tregister;

      begin
         hregister:=getregister32;
         exprasmlist^.concat(new(pai386,op_reg(A_POP,S_L,hregister)));
         if (p^.location.loc=LOC_REGISTER) or (p^.location.loc=LOC_CREGISTER) then
           begin
              p^.location.register:=hregister;
           end
         else
           begin
              reset_reference(p^.location.reference);
              p^.location.reference.index:=hregister;
              set_location(p^.left^.location,p^.location);
           end;
      end;

    function maybe_push(needed : byte;p : ptree) : boolean;

      var
         pushed : boolean;
         hregister : tregister;

      begin
         if needed>usablereg32 then
           begin
              if (p^.location.loc=LOC_REGISTER) or
                 (p^.location.loc=LOC_CREGISTER) then
                begin
                   pushed:=true;
                   exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,p^.location.register)));
                   ungetregister32(p^.location.register);
                end
              else if ((p^.location.loc=LOC_MEM) or
                       (p^.location.loc=LOC_REFERENCE)
                      ) and
                      ((p^.location.reference.base<>R_NO) or
                       (p^.location.reference.index<>R_NO)
                      ) then
                  begin
                     del_reference(p^.location.reference);
                     exprasmlist^.concat(new(pai386,op_ref_reg(A_LEA,S_L,newreference(p^.location.reference),
                       R_EDI)));
                     exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,R_EDI)));
                     pushed:=true;
                  end
              else pushed:=false;
           end
         else pushed:=false;
         maybe_push:=pushed;
      end;

    procedure seconderror(var p : ptree);far;

      begin
         p^.error:=true;
         codegenerror:=true;
      end;

    procedure secondload(var p : ptree);far;

      var
         hregister : tregister;
         symtabletype,i : longint;
         hp : preference;

      begin
         simple_loadn:=true;
         reset_reference(p^.location.reference);
         case p^.symtableentry^.typ of
              varsym :
                 begin
                    hregister:=R_NO;
                    symtabletype:=p^.symtable^.symtabletype;
                    { in case it is a register variable: }
                    if pvarsym(p^.symtableentry)^.reg<>R_NO then
                      begin
                         p^.location.loc:=LOC_CREGISTER;
                         p^.location.register:=pvarsym(p^.symtableentry)^.reg;
                      end
                    else
                      begin
                         { first handle local and temporary variables }
                         if (symtabletype and (parasymtable or localsymtable))<>0 then
                           begin
                              p^.location.reference.base:=procinfo.framepointer;
                              p^.location.reference.offset:=pvarsym(p^.symtableentry)^.adresse;
                              if (symtabletype and localsymtable<>0) then
                                p^.location.reference.offset:=-p^.location.reference.offset;
                              if (symtabletype and parasymtable<>0) then
                                inc(p^.location.reference.offset,p^.symtable^.call_offset);
                              if (lexlevel>(p^.symtable^.symtabletype and locallevel)) then
                                begin
                                   hregister:=getregister32;

                                   { make a reference }
                                   new(hp);
                                   reset_reference(hp^);
                                   hp^.offset:=procinfo.framepointer_offset;
                                   hp^.base:=procinfo.framepointer;

                                   exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,hp,hregister)));

                                   simple_loadn:=false;
                                   i:=lexlevel-1;
                                   while i>(p^.symtable^.symtabletype and locallevel) do
                                     begin
                                        { make a reference }
                                        new(hp);
                                        reset_reference(hp^);
                                        hp^.offset:=8;
                                        hp^.base:=hregister;

                                        exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,hp,hregister)));
                                        dec(i);
                                     end;
                                   p^.location.reference.base:=hregister;
                                end;
                           end
                         else
                           case p^.symtable^.symtabletype of
                              unitsymtable,globalsymtable,
                              staticsymtable : begin
{$ifdef CleanUp}
                                                  stringdispose(p^.location.reference.symbol);
{$endif * CleanUp *}
                                                  p^.location.reference.symbol:=stringdup(p^.symtableentry^.mangledname);
                                               end;
                              objectsymtable : begin
                                                  p^.location.reference.base:=R_ESI;
                                                  p^.location.reference.offset:=pvarsym(p^.symtableentry)^.adresse;
                                               end;
                              withsymtable :   begin
                                                  hregister:=getregister32;
                                                  p^.location.reference.base:=hregister;
                                                  { make a reference }
                                                  new(hp);
                                                  reset_reference(hp^);
                                                  hp^.offset:=p^.symtable^.datasize;
                                                  hp^.base:=procinfo.framepointer;

                                                  exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,hp,hregister)));

                                                  p^.location.reference.offset:=
                                                    pvarsym(p^.symtableentry)^.adresse;
                                               end;
                           end;
                         { in case call by reference, then calculate: }
                         if (pvarsym(p^.symtableentry)^.varspez=vs_var) or
                            ((pvarsym(p^.symtableentry)^.varspez=vs_const) and
                             (
                               (pvarsym(p^.symtableentry)^.definition^.deftype=stringdef) or
                               (pvarsym(p^.symtableentry)^.definition^.deftype=arraydef) or
                               (pvarsym(p^.symtableentry)^.definition^.deftype=recorddef) or
                               (pvarsym(p^.symtableentry)^.definition^.deftype=objectdef) or
                               ((pvarsym(p^.symtableentry)^.definition^.deftype=setdef) and
                                (psetdef(pvarsym(p^.symtableentry)^.definition)^.settype<>smallset)))
                             ) then
                           begin
                              simple_loadn:=false;
                              if hregister=R_NO then
                                hregister:=getregister32;
                              exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,newreference(p^.location.reference),
                                hregister)));
                              clear_reference(p^.location.reference);
                              p^.location.reference.base:=hregister;
                          end;
                         if (pvarsym(p^.symtableentry)^.definition^.deftype=objectdef) and
                           ((pobjectdef(pvarsym(p^.symtableentry)^.definition)^.options and oois_class)<>0) then
                           begin
                              simple_loadn:=false;
                              if hregister=R_NO then
                                hregister:=getregister32;
                              exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,newreference(p^.location.reference),
                                hregister)));
                              clear_reference(p^.location.reference);
                              p^.location.reference.base:=hregister;
                           end;
                      end;
                 end;
              procsym:
                 begin
                    {!!!!! Be aware, work on virtual methods too }
{$ifdef CleanUp}
                    stringdispose(p^.location.reference.symbol);
{$endif * CleanUp *}
                    p^.location.reference.symbol:=
                      stringdup(pprocsym(p^.symtableentry)^.definition^.mangledname);
                 end;
              typedconstsym :
                 begin
{$ifdef CleanUp}
                    stringdispose(p^.location.reference.symbol);
{$endif * CleanUp *}
                    p^.location.reference.symbol:=stringdup(p^.symtableentry^.mangledname);
                 end;
              else internalerror(4);
         end;
      end;

    procedure secondadd(var p : ptree);far;

    { is also being used for xor, and "mul", "sub, or and comparative }
    { operators                                                       }

      var
         swapp : ptree;
         hregister : tregister;
         pushed,mboverflow,cmpop : boolean;
         op : tasmop;
{$ifndef CleanUp}
         swapl : tlocation;
{$endif * not CleanUp *}
         pushedregs : tpushed;
         flags : tresflags;
         otl,ofl,power : longint;
         href : treference;
         opsize : topsize;

         { true, if unsigned types are compared }
         unsigned : boolean;

         { true, if a small set is handled with the longint code }
         is_set : boolean;

         { true, if for sets subtractions the extra not should generated }
         extra_not : boolean;

      begin
         unsigned:=false;
         extra_not:=false;

         opsize:=S_L;

         { calculate the operator which is more difficult }
         firstcomplex(p);
         { handling boolean expressions extra: }
         if ((p^.left^.resulttype^.deftype=orddef) and
            (porddef(p^.left^.resulttype)^.typ=bool8bit)) then
{            ((p^.right^.resulttype^.deftype=orddef) and
            (porddef(p^.right^.resulttype)^.typ=bool8bit)) then }
           begin
              if (p^.treetype=andn) or (p^.treetype=orn) then
                begin
                   p^.location.loc:=LOC_JUMP;
                   cmpop:=false;
                   case p^.treetype of
                     andn : begin
                               otl:=truelabel;
                               getlabel(truelabel);
                               secondpass(p^.left);
                               maketojumpbool(p^.left);
                               emitl(A_LABEL,truelabel);
                               truelabel:=otl;
                            end;
                     orn : begin
                              ofl:=falselabel;
                              getlabel(falselabel);
                              secondpass(p^.left);
                              maketojumpbool(p^.left);
                              emitl(A_LABEL,falselabel);
                              falselabel:=ofl;
                           end;
                     else error(type_mismatch);
                   end;
                  secondpass(p^.right);
                  maketojumpbool(p^.right);
                end
{              else if (p^.treetype=unequaln) or (p^.treetype=equaln) then
                begin
                   opsize:=S_B;
                   if p^.left^.treetype=boolconstn then
                     begin
                        swapp:=p^.right;
                        p^.right:=p^.left;
                        p^.left:=swapp;
                        p^.swaped:=not(p^.swaped);
                     end;
                   secondpass(p^.left);
                   p^.location:=p^.left^.location;
                   (* sind zuwenig Register frei? *)
                   pushed:=maybe_push(p^.right^.registers32,p);
                   secondpass(p^.right);
                   if pushed then restore(p);
                   goto do_normal;
                end }
              else error(type_mismatch);
           end
         { also handle string operations seperately }
         else if (p^.left^.resulttype^.deftype=stringdef) then
           begin
              { string operations are not commutative }
              if p^.swaped then
                begin
                   swapp:=p^.left;
                   p^.left:=p^.right;
                   p^.right:=swapp;
                   { because of jump being produced at comparison below: }
                   p^.swaped:=not(p^.swaped);
                end;
              case p^.treetype of
                 addn : begin
                           cmpop:=false;
                           secondpass(p^.left);
                           if (p^.left^.treetype<>addn) then
                             begin
                                { can only reference be }
                                { string in register would be funny    }
                                { therefore produce a temporary string }

                                { release the registers }
                                del_reference(p^.left^.location.reference);

                                pushusedregisters(pushedregs,$ff);

                                gettempofsizereference(256,href);
                                emitpushreferenceaddr(href);
                                emitpushreferenceaddr(p^.left^.location.reference);

                                push_int(255);
                                exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol('STRCOPY',0))));

                                maybe_loadesi;
                                popusedregisters(pushedregs);

                                ungetiftemp(p^.left^.location.reference);

                                { does not hurt: }
                                p^.left^.location.loc:=LOC_MEM;
                                p^.left^.location.reference:=href;
                             end;

                           secondpass(p^.right);

                           { on the right we do not need the register anymore too }
                           del_reference(p^.right^.location.reference);
                           pushusedregisters(pushedregs,$ff);
                           emitpushreferenceaddr(p^.left^.location.reference);
                           emitpushreferenceaddr(p^.right^.location.reference);
                           exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol('STRCONCAT',0))));
{$ifndef CleanUp}
                           p^.location:=p^.left^.location;
{$else * CleanUp *}
                           set_location(p^.location,p^.left^.location);
{$endif * CleanUp *}
                           ungetiftemp(p^.right^.location.reference);
                           maybe_loadesi;
                           popusedregisters(pushedregs);
                        end;
              ltn,lten,gtn,gten,
                equaln,unequaln :
                        begin
                           secondpass(p^.left);
                           { are too few registers free? }
                           pushed:=maybe_push(p^.right^.registers32,p);
                           secondpass(p^.right);
                           if pushed then restore(p);
                           cmpop:=true;
                           del_reference(p^.right^.location.reference);
                           del_reference(p^.left^.location.reference);
                           pushusedregisters(pushedregs,$ff);
                           emitpushreferenceaddr(p^.left^.location.reference);
                           emitpushreferenceaddr(p^.right^.location.reference);
                           exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol('STRCMP',0))));
                           maybe_loadesi;
                           popusedregisters(pushedregs);
                           ungetiftemp(p^.left^.location.reference);
                           ungetiftemp(p^.right^.location.reference);
                        end;
                else error(type_mismatch);
              end;
           end
         else
           begin
              { in case of constant put it to the left }
              if p^.left^.treetype=ordconstn then
                begin
                   swapp:=p^.right;
                   p^.right:=p^.left;
                   p^.left:=swapp;
                   p^.swaped:=not(p^.swaped);
                end;
              secondpass(p^.left);
              set_location(p^.location,p^.left^.location);
              { are to few registers free? }
              pushed:=maybe_push(p^.right^.registers32,p);
              secondpass(p^.right);
              if pushed then restore(p);
              if (p^.left^.resulttype^.deftype=pointerdef) or

                 (p^.right^.resulttype^.deftype=pointerdef) or

                 (p^.left^.resulttype^.deftype=procvardef) or

                 (p^.left^.resulttype^.deftype=aufzaehldef) or

                 ((p^.left^.resulttype^.deftype=orddef) and
                 (porddef(p^.left^.resulttype)^.typ=s32bit)) or
                 ((p^.right^.resulttype^.deftype=orddef) and
                 (porddef(p^.right^.resulttype)^.typ=s32bit)) or

                ((p^.left^.resulttype^.deftype=orddef) and
                 (porddef(p^.left^.resulttype)^.typ=u32bit)) or
                 ((p^.right^.resulttype^.deftype=orddef) and
                 (porddef(p^.right^.resulttype)^.typ=u32bit)) or

                { as well as small sets }
                ((p^.left^.resulttype^.deftype=setdef) and
                 (psetdef(p^.left^.resulttype)^.settype=smallset)
                ) then
                begin
{           do_normal: }
                   mboverflow:=false;
                   cmpop:=false;
                   if (p^.left^.resulttype^.deftype=pointerdef) or
                      (p^.right^.resulttype^.deftype=pointerdef) or
                      ((p^.left^.resulttype^.deftype=orddef) and
                      (porddef(p^.left^.resulttype)^.typ=u32bit)) or
                      ((p^.right^.resulttype^.deftype=orddef) and
                      (porddef(p^.right^.resulttype)^.typ=u32bit)) then
                     unsigned:=true;
                   is_set:=p^.resulttype^.deftype=setdef;

                   case p^.treetype of
                      addn : begin
                                if is_set then
                                  begin
                                     op:=A_OR;
                                     mboverflow:=false;
                                     unsigned:=false;
                                  end
                                else
                                  begin
                                     op:=A_ADD;
                                     mboverflow:=true;
                                  end;
                             end;
                      muln : begin
                                if is_set then
                                  begin
                                     op:=A_AND;
                                     mboverflow:=false;
                                     unsigned:=false;
                                  end
                                else
                                  begin
                                     if unsigned then
                                       op:=A_MUL
                                     else
                                       op:=A_IMUL;
                                     mboverflow:=true;
                                  end;
                             end;
                      subn : begin
                                if is_set then
                                  begin
                                     op:=A_AND;
                                     mboverflow:=false;
                                     unsigned:=false;
                                     extra_not:=true;
                                  end
                                else
                                  begin
                                     op:=A_SUB;
                                     mboverflow:=true;
                                  end;
                             end;
                      ltn,lten,gtn,gten,
                      equaln,unequaln :
                             begin
                                op:=A_CMP;
                                cmpop:=true;
                             end;
                      xorn : op:=A_XOR;
                      orn : op:=A_OR;
                      andn : op:=A_AND;
                      else error(type_mismatch);
                   end;
                   { left and right no register?  }
                   { then one must be demanded    }
                   if (p^.location.loc<>LOC_REGISTER) and
                     (p^.right^.location.loc<>LOC_REGISTER) then
                     begin
                        { register variable ? }
                        if (p^.location.loc=LOC_CREGISTER) then
                          begin
                             if cmpop then
                               begin
                                  { do not disturb the register }
                                  hregister:=p^.location.register;
                               end
                             else
                               begin
                                  case opsize of
                                     S_L : hregister:=getregister32;
                                     S_B : hregister:=reg32toreg8(getregister32);
                                  end;
                                  emit_reg_reg(A_MOV,opsize,p^.location.register,
                                    hregister);
                               end

                          end
                        else
                          begin
                             del_reference(p^.location.reference);

                             { first give free, then demand new register }
                             case opsize of
                                S_L : hregister:=getregister32;
                                S_B : hregister:=reg32toreg8(getregister32);
                             end;
                             exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,opsize,newreference(p^.location.reference),
                               hregister)));
                          end;
{$ifdef CleanUp}

{$endif * CleanUp *}
                        p^.location.loc:=LOC_REGISTER;
                        p^.location.register:=hregister;

                     end
                   else
                     { if on the right the register then swap }
                     if (p^.right^.location.loc=LOC_REGISTER) then
                       begin
{$ifndef CleanUp}
                          swapl:=p^.location;
                          p^.location:=p^.right^.location;
                          p^.right^.location:=swapl;
{$else * CleanUp *}
                          swap_location(p^.location,p^.right^.location);
{$endif * CleanUp *}

                          { newly swapped also set swapped flag }
                          p^.swaped:=not(p^.swaped);
                       end;
                   if p^.right^.location.loc<>LOC_REGISTER then
                     begin
                        if (p^.treetype=subn) and p^.swaped then
                          begin
                             if p^.right^.location.loc=LOC_CREGISTER then
                               begin
                                  if extra_not then
                                    exprasmlist^.concat(new(pai386,op_reg(A_NOT,opsize,p^.location.register)));

                                  emit_reg_reg(A_MOV,opsize,p^.right^.location.register,R_EDI);
                                  emit_reg_reg(op,opsize,p^.location.register,R_EDI);
                                  emit_reg_reg(A_MOV,opsize,R_EDI,p^.location.register);
                               end
                             else
                               begin
                                  if extra_not then
                                    exprasmlist^.concat(new(pai386,op_reg(A_NOT,opsize,p^.location.register)));

                                  exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,opsize,
                                    newreference(p^.right^.location.reference),R_EDI)));
                                  exprasmlist^.concat(new(pai386,op_reg_reg(op,opsize,p^.location.register,R_EDI)));
                                  exprasmlist^.concat(new(pai386,op_reg_reg(A_MOV,opsize,R_EDI,p^.location.register)));
                                  del_reference(p^.right^.location.reference);
                               end;
                          end
                        else
                          begin
                             if (p^.right^.treetype=ordconstn) and
                                (op=A_CMP) and
                                (p^.right^.value=0) then
                               begin
                                  exprasmlist^.concat(new(pai386,op_reg_reg(A_TEST,opsize,p^.location.register,
                                    p^.location.register)));
                               end
                             else if (p^.right^.treetype=ordconstn) and
                                (op=A_ADD) and
                                (p^.right^.value=1) then
                               begin
                                  exprasmlist^.concat(new(pai386,op_reg(A_INC,opsize,
                                    p^.location.register)));
                               end
                             else if (p^.right^.treetype=ordconstn) and
                                (op=A_SUB) and
                                (p^.right^.value=1) then
                               begin
                                  exprasmlist^.concat(new(pai386,op_reg(A_DEC,opsize,
                                    p^.location.register)));
                               end
                             else if (p^.right^.treetype=ordconstn) and
                                (op=A_IMUL) and
                                (ispowerof2(p^.right^.value,power)) then
                               begin
                                  exprasmlist^.concat(new(pai386,op_const_reg(A_SHL,opsize,power,
                                    p^.location.register)));
                               end
                             else
                               begin
                                  if (p^.right^.location.loc=LOC_CREGISTER) then
                                    begin
                                       if extra_not then
                                         begin
                                            emit_reg_reg(A_MOV,S_L,p^.right^.location.register,R_EDI);
                                            exprasmlist^.concat(new(pai386,op_reg(A_NOT,S_L,R_EDI)));
                                            emit_reg_reg(A_AND,S_L,R_EDI,
                                              p^.location.register);
                                         end
                                       else
                                         begin
                                            emit_reg_reg(op,opsize,p^.right^.location.register,
                                              p^.location.register);
                                         end;
                                    end
                                  else
                                    begin
                                       if extra_not then
                                         begin
                                            exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,newreference(
                                              p^.right^.location.reference),R_EDI)));
                                            exprasmlist^.concat(new(pai386,op_reg(A_NOT,S_L,R_EDI)));
                                            emit_reg_reg(A_AND,S_L,R_EDI,
                                              p^.location.register);
                                         end
                                       else
                                         begin
                                            exprasmlist^.concat(new(pai386,op_ref_reg(op,opsize,newreference(
                                              p^.right^.location.reference),p^.location.register)));
                                         end;
                                       del_reference(p^.right^.location.reference);
                                    end;
                               end;
                          end;
                     end
                   else
                     begin
                        { when swapped another result register }
                        if (p^.treetype=subn) and p^.swaped then
                          begin
                             if extra_not then
                               exprasmlist^.concat(new(pai386,op_reg(A_NOT,S_L,p^.location.register)));

                             exprasmlist^.concat(new(pai386,op_reg_reg(op,opsize,
                               p^.location.register,p^.right^.location.register)));

{$ifndef CleanUp}
                               swapl:=p^.location;
                               p^.location:=p^.right^.location;
                               p^.right^.location:=swapl;
{$else * CleanUp *}
                               swap_location(p^.location,p^.right^.location);
{$endif * CleanUp *}

                               { newly swapped also set swapped flag }
                               { just to maintain ordering           }
                               p^.swaped:=not(p^.swaped);
                          end
                        else
                          begin
                             if extra_not then
                               exprasmlist^.concat(new(pai386,op_reg(A_NOT,S_L,p^.right^.location.register)));

                             exprasmlist^.concat(new(pai386,op_reg_reg(op,opsize,
                               p^.right^.location.register,
                               p^.location.register)));
                          end;
                        case opsize of
                           S_L : ungetregister32(p^.right^.location.register);
                           S_B : ungetregister32(reg8toreg32(p^.right^.location.register));
                        end;
                     end;

                   if cmpop then
                     case opsize of
                        S_L : ungetregister32(p^.location.register);
                        S_B : ungetregister32(reg8toreg32(p^.location.register));
                     end;

                   { only in case of overflow operations }
                   { produce overflow code }
                   if mboverflow then
                     emitoverflowcheck;
                end
              else if ((p^.left^.resulttype^.deftype=orddef) and
                 (porddef(p^.left^.resulttype)^.typ=uchar)) then
                begin
                   case p^.treetype of
                      ltn,lten,gtn,gten,
                      equaln,unequaln :
                                cmpop:=true;
                      else error(type_mismatch);
                   end;
                   unsigned:=true;
                   { left and right no register? }
                   { the one must be demanded    }
                   if (p^.location.loc<>LOC_REGISTER) and
                     (p^.right^.location.loc<>LOC_REGISTER) then
                     begin
                        if p^.location.loc=LOC_CREGISTER then
                          begin
                             if cmpop then
                               { do not disturb register }
                               hregister:=p^.location.register
                             else
                               begin
                                  hregister:=reg32toreg8(getregister32);
                                  emit_reg_reg(A_MOV,S_B,p^.location.register,
                                    hregister);
                               end;
                          end
                        else
                          begin
                             del_reference(p^.location.reference);

                             { first give free then demand new register }
                             hregister:=reg32toreg8(getregister32);
                             exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_B,newreference(p^.location.reference),
                               hregister)));
                          end;
                        p^.location.loc:=LOC_REGISTER;
                        p^.location.register:=hregister;
                     end;

                   { now p always a register }

                   if (p^.right^.location.loc=LOC_REGISTER) and
                      (p^.location.loc<>LOC_REGISTER) then
                     begin
{$ifndef CleanUp}
                        swapl:=p^.location;
                        p^.location:=p^.right^.location;
                        p^.right^.location:=swapl;
{$else * CleanUp *}
                       swap_location(p^.location,p^.right^.location);
{$endif * CleanUp *}

                        { newly swapped also set swapped flag }
                        p^.swaped:=not(p^.swaped);
                     end;
                   if p^.right^.location.loc<>LOC_REGISTER then
                     begin
                        if p^.right^.location.loc=LOC_CREGISTER then
                          begin
                             emit_reg_reg(A_CMP,S_B,
                                p^.right^.location.register,p^.location.register);
                          end
                        else
                          begin
                             exprasmlist^.concat(new(pai386,op_ref_reg(A_CMP,S_B,newreference(
                                p^.right^.location.reference),p^.location.register)));
                             del_reference(p^.right^.location.reference);
                          end;
                     end
                   else
                     begin
                        emit_reg_reg(A_CMP,S_L,p^.right^.location.register,
                          p^.location.register);
                        ungetregister32(reg8toreg32(p^.right^.location.register));
                     end;
                   ungetregister32(reg8toreg32(p^.location.register));
                end
              else if (p^.left^.resulttype^.deftype=floatdef) and
                  (pfloatdef(p^.left^.resulttype)^.typ<>f32bit) then
                 begin
                    { real constants to the left }
                    if p^.left^.treetype=realconstn then
                      begin
                         swapp:=p^.right;
                         p^.right:=p^.left;
                         p^.left:=swapp;
                         p^.swaped:=not(p^.swaped);
                      end;
                    cmpop:=false;
                    case p^.treetype of
                       addn : op:=A_FADDP;
                       muln : op:=A_FMULP;
                       subn : op:=A_FSUBP;
                       slashn : op:=A_FDIVP;
                       ltn,lten,gtn,gten,
                       equaln,unequaln : begin
                                            op:=A_FCOMPP;
                                            cmpop:=true;
                                         end;
                       else error(type_mismatch);
                    end;

                    if (p^.right^.location.loc<>LOC_FPUSTACK) then
                      begin
                         floatload(pfloatdef(p^.right^.resulttype)^.typ,p^.right^.location.reference);
                         if (p^.left^.location.loc<>LOC_FPUSTACK) then
                           floatload(pfloatdef(p^.left^.resulttype)^.typ,p^.left^.location.reference)
                         { left was on the stack => swap }
                         else
                           p^.swaped:=not(p^.swaped);

                         { releases the right reference }
                         del_reference(p^.right^.location.reference);
                      end
                    { the nominator in st0 }
                    else if (p^.left^.location.loc<>LOC_FPUSTACK) then
                      floatload(pfloatdef(p^.left^.resulttype)^.typ,p^.left^.location.reference)
                    { fpu operands are always in the wrong order on the stack }
                    else
                      p^.swaped:=not(p^.swaped);

                    { releases the left reference }
                    if (p^.left^.location.loc<>LOC_FPUSTACK) then
                      del_reference(p^.left^.location.reference);

                    { if we swaped the tree nodes, then use the reverse operator }
                    if p^.swaped then
                      begin
                         if (p^.treetype=slashn) then
                           op:=A_FDIVRP
                         else if (p^.treetype=subn) then
                           op:=A_FSUBRP;
                      end;
                    { to avoid the pentium bug
                    if (op=FDIVP) and (opt_processors=pentium) then
                      exprasmlist^.concat(new(pai386,op_CALL,S_NO,'EMUL_FDIVP')
                    else
                    }
                    { the Intel assemblers want operands }
                    if op<>A_FCOMPP then
                       exprasmlist^.concat(new(pai386,op_reg_reg(op,S_NO,R_ST,R_ST1)))
                    else
                      exprasmlist^.concat(new(pai386,op_none(op,S_NO)));
                    { on comparison load flags }
                    if cmpop then
                      begin
                         if not(R_EAX in unused) then
                           emit_reg_reg(A_MOV,S_L,R_EAX,R_EDI);
                         exprasmlist^.concat(new(pai386,op_reg(A_FNSTS,S_W,R_AX)));
                         exprasmlist^.concat(new(pai386,op_none(A_SAHF,S_NO)));
                         if not(R_EAX in unused) then
                           emit_reg_reg(A_MOV,S_L,R_EDI,R_EAX);
                         if p^.swaped then
                           case p^.treetype of
                              equaln : flags:=F_E;
                              unequaln : flags:=F_NE;
                              ltn : flags:=F_A;
                              lten : flags:=F_AE;
                              gtn : flags:=F_B;
                              gten : flags:=F_BE;
                           end
                         else
                           case p^.treetype of
                              equaln : flags:=F_E;
                              unequaln : flags:=F_NE;
                              ltn : flags:=F_B;
                              lten : flags:=F_BE;
                              gtn : flags:=F_A;
                              gten : flags:=F_AE;
                           end;
                         p^.location.loc:=LOC_FLAGS;
                         p^.location.resflags:=flags;
                         cmpop:=false;
                      end
                    else
                      p^.location.loc:=LOC_FPUSTACK;
                 end
              else if (p^.left^.resulttype^.deftype=setdef) then
                begin
                   { not commutative }
                   if p^.swaped then
                     begin
                        swapp:=p^.left;
                        p^.left:=p^.right;
                        p^.right:=swapp;
                        { because of jump being produced by comparison }
                        p^.swaped:=not(p^.swaped);
                     end;
                   case p^.treetype of
                      equaln,unequaln : begin
                                     cmpop:=true;
                                     del_reference(p^.left^.location.reference);
                                     del_reference(p^.right^.location.reference);
                                     pushusedregisters(pushedregs,$ff);
                                     emitpushreferenceaddr(p^.right^.location.reference);
                                     emitpushreferenceaddr(p^.left^.location.reference);
                                     exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,
                                         newcsymbol('SET_COMP_SETS',0))));
                                     maybe_loadesi;
                                     popusedregisters(pushedregs);
                                     ungetiftemp(p^.left^.location.reference);
                                     ungetiftemp(p^.right^.location.reference);
                                  end;

                      addn,subn,muln : begin
                                     cmpop:=false;
                                     del_reference(p^.left^.location.reference);
                                     del_reference(p^.right^.location.reference);
{$ifndef CleanUp}
                                     clear_reference(href);
                                     href.offset:=gettempofsize(32);
                                     href.base:=procinfo.framepointer;
{$else * CleanUp *}
                                     href.symbol:=nil;
                                     gettempofsizereference(32,href);
{$endif * CleanUp *}
                                     emitpushreferenceaddr(href);
                                     pushusedregisters(pushedregs,$ff);
                                     emitpushreferenceaddr(p^.right^.location.reference);
                                     emitpushreferenceaddr(p^.left^.location.reference);
                                     case p^.treetype of
                                       subn : exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,
                                         newcsymbol('SET_SUB_SETS',0))));
                                       addn : exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,
                                         newcsymbol('SET_ADD_SETS',0))));
                                       muln : exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,
                                         newcsymbol('SET_MUL_SETS',0))));
                                     end;
                                     maybe_loadesi;
                                     popusedregisters(pushedregs);
                                     ungetiftemp(p^.left^.location.reference);
                                     ungetiftemp(p^.right^.location.reference);
                                     p^.location.loc:=LOC_MEM;
{$ifdef CleanUp}
                                     stringdispose(p^.location.reference.symbol);
{$endif * CleanUp *}
                                     p^.location.reference:=href;
                                  end;
                      else error(type_mismatch);
                   end;
                end
              else error(type_mismatch);
           end;
         { in case of comparison operation the put result in the flags }
         if cmpop then
           begin
              if not(unsigned) then
                begin
                   if p^.swaped then
                     case p^.treetype of
                        equaln : flags:=F_E;
                        unequaln : flags:=F_NE;
                        ltn : flags:=F_G;
                        lten : flags:=F_GE;
                        gtn : flags:=F_L;
                        gten : flags:=F_LE;
                     end
                   else
                     case p^.treetype of
                        equaln : flags:=F_E;
                        unequaln : flags:=F_NE;
                        ltn : flags:=F_L;
                        lten : flags:=F_LE;
                        gtn : flags:=F_G;
                        gten : flags:=F_GE;
                     end;
                end
              else
                begin
                   if p^.swaped then
                     case p^.treetype of
                        equaln : flags:=F_E;
                        unequaln : flags:=F_NE;
                        ltn : flags:=F_A;
                        lten : flags:=F_AE;
                        gtn : flags:=F_B;
                        gten : flags:=F_BE;
                     end
                   else
                     case p^.treetype of
                        equaln : flags:=F_E;
                        unequaln : flags:=F_NE;
                        ltn : flags:=F_B;
                        lten : flags:=F_BE;
                        gtn : flags:=F_A;
                        gten : flags:=F_AE;
                     end;
                end;
              p^.location.loc:=LOC_FLAGS;
              p^.location.resflags:=flags;
           end;
      end;

    procedure secondmoddiv(var p : ptree);far;

      var
         hreg1 : tregister;
         pushed,popeax,popedx : boolean;
         power,hl : longint;

      begin
         secondpass(p^.left);
{$ifndef CleanUp}
         p^.location:=p^.left^.location;
{$else * CleanUp *}
         set_location(p^.location,p^.left^.location);
{$endif * CleanUp *}
         pushed:=maybe_push(p^.right^.registers32,p);
         secondpass(p^.right);
         if pushed then restore(p);

         { put numerator in register }
         if p^.left^.location.loc<>LOC_REGISTER then
           begin
              if p^.left^.location.loc=LOC_CREGISTER then
                begin
                  hreg1:=getregister32;
                  emit_reg_reg(A_MOV,S_L,p^.left^.location.register,hreg1);
                end
              else
                begin
                  del_reference(p^.left^.location.reference);
                  hreg1:=getregister32;
                  exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,newreference(p^.left^.location.reference),
                    hreg1)));
                end;
              p^.left^.location.loc:=LOC_REGISTER;
              p^.left^.location.register:=hreg1;
           end
         else hreg1:=p^.left^.location.register;

         if (p^.treetype=divn) and (p^.right^.treetype=ordconstn) and
            ispowerof2(p^.right^.value,power) then
           begin
              exprasmlist^.concat(new(pai386,op_reg_reg(A_OR,S_L,hreg1,hreg1)));
              getlabel(hl);
              emitl(A_JNS,hl);
              if power=1 then
                exprasmlist^.concat(new(pai386,op_reg(A_INC,S_L,hreg1)))
              else exprasmlist^.concat(new(pai386,op_const_reg(A_ADD,S_L,p^.right^.value-1,hreg1)));

              emitl(A_LABEL,hl);
              exprasmlist^.concat(new(pai386,op_const_reg(A_SAR,S_L,power,hreg1)));
           end
         else
           begin
              { bring denominator to EDI }
              { EDI is always free, it's }
              { only used for temporary  }
              { purposes                 }
              if (p^.right^.location.loc<>LOC_REGISTER) and
                 (p^.right^.location.loc<>LOC_CREGISTER) then
                begin
                   del_reference(p^.right^.location.reference);
                   p^.left^.location.loc:=LOC_REGISTER;
                   exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,newreference(p^.right^.location.reference),R_EDI)));
                end
              else
                begin
                   ungetregister32(p^.right^.location.register);
                   emit_reg_reg(A_MOV,S_L,p^.right^.location.register,R_EDI);
                end;
              popedx:=false;
              popeax:=false;
              if hreg1=R_EDX then
                begin
                   if not(R_EAX in unused) then
                     begin
                        exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,R_EAX)));
                        popeax:=true;
                     end;
                   emit_reg_reg(A_MOV,S_L,R_EDX,R_EAX);
                end
              else
                begin
                   if not(R_EDX in unused) then
                     begin
                        exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,R_EDX)));
                        popedx:=true;
                     end;
                   if hreg1<>R_EAX then
                     begin
                        if not(R_EAX in unused) then
                          begin
                             exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,R_EAX)));
                             popeax:=true;
                          end;
                        emit_reg_reg(A_MOV,S_L,hreg1,R_EAX);
                     end;
                end;
              exprasmlist^.concat(new(pai386,op_none(A_CLTD,S_NO)));
              exprasmlist^.concat(new(pai386,op_reg(A_IDIV,S_L,R_EDI)));
              if p^.treetype=divn then
                begin
                   { if result register is busy then copy }
                   if popeax then
                     begin
                        if hreg1=R_EAX then
                          internalerror(112);
                        emit_reg_reg(A_MOV,S_L,R_EAX,hreg1)
                     end
                   else
                     if hreg1<>R_EAX then
                       emit_reg_reg(A_MOV,S_L,R_EAX,hreg1);
                end
              else
                emit_reg_reg(A_MOV,S_L,R_EDX,hreg1);
              if popeax then
                exprasmlist^.concat(new(pai386,op_reg(A_POP,S_L,R_EAX)));
              if popedx then
                exprasmlist^.concat(new(pai386,op_reg(A_POP,S_L,R_EDX)));
           end;
         { this registers are always used when div/mod are present }
         usedinproc:=usedinproc or ($80 shr byte(R_EAX));
         usedinproc:=usedinproc or ($80 shr byte(R_EDX));
         p^.location.loc:=LOC_REGISTER;
         p^.location.register:=hreg1;
      end;

    procedure secondshlshr(var p : ptree);far;

      var
         hregister1,hregister2,hregister3 : tregister;
         pushed,popecx : boolean;
         op : tasmop;

      begin
         popecx:=false;

         secondpass(p^.left);
         pushed:=maybe_push(p^.right^.registers32,p);
         secondpass(p^.right);
         if pushed then restore(p);

         { load left operators in a register }
         if p^.left^.location.loc<>LOC_REGISTER then
           begin
              if p^.left^.location.loc=LOC_CREGISTER then
                begin
                   hregister1:=getregister32;
                   emit_reg_reg(A_MOV,S_L,p^.left^.location.register,
                     hregister1);
                end
              else
                begin
                   del_reference(p^.left^.location.reference);
                   hregister1:=getregister32;
                   exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,newreference(p^.left^.location.reference),
                     hregister1)));
                end;
           end
         else hregister1:=p^.left^.location.register;

         { determine operator }
         if p^.treetype=shln then
           op:=A_SHL
         else
           op:=A_SHR;

         { shifting by a constant directly decode: }
         if (p^.right^.treetype=ordconstn) then
           begin
              exprasmlist^.concat(new(pai386,op_const_reg(op,S_L,p^.right^.location.reference.offset mod 32,
                hregister1)));
              p^.location.loc:=LOC_REGISTER;
              p^.location.register:=hregister1;
           end
         else
           begin
              { load right operators in a register }
              if p^.right^.location.loc<>LOC_REGISTER then
                begin
                   if p^.right^.location.loc=LOC_CREGISTER then
                     begin
                        hregister2:=getregister32;
                        emit_reg_reg(A_MOV,S_L,p^.right^.location.register,
                          hregister2);
                     end
                   else
                     begin
                        del_reference(p^.right^.location.reference);
                        hregister2:=getregister32;
                        exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,newreference(p^.right^.location.reference),
                          hregister2)));
                     end;
                end
              else hregister2:=p^.right^.location.register;

              { left operator is already in a register }
              { hence are both in a register }
              { is it in the case ECX ? }
              if (hregister1=R_ECX) then
                begin
                   { then only swap }
                   emit_reg_reg(A_XCHG,S_L,hregister1,
                     hregister2);

                   hregister3:=hregister1;
                   hregister1:=hregister2;
                   hregister2:=hregister3;
                end
              { if second operator not in ECX ? }
              else if (hregister2<>R_ECX) then
                begin
                   { ECX not occupied then swap with right register }
                   if R_ECX in unused then
                     begin
                        emit_reg_reg(A_MOV,S_L,hregister2,R_ECX);
                        ungetregister32(hregister2);
                     end
                   else
                     begin
                        { else save ECX and then copy it }
                        popecx:=true;
                        exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,R_ECX)));
                        emit_reg_reg(A_MOV,S_L,hregister2,R_ECX);
                        ungetregister32(hregister2);
                     end;
                end;
              { right operand is in ECX }
              emit_reg_reg(op,S_L,R_CL,hregister1);
              { maybe ECX back }
              if popecx then
                exprasmlist^.concat(new(pai386,op_reg(A_POP,S_L,R_ECX)));
              p^.location.register:=hregister1;
           end;
         { this register is always used when shl/shr are present }
         usedinproc:=usedinproc or ($80 shr byte(R_ECX));
      end;

    procedure secondrealconst(var p : ptree);far;

      var
         hp1 : pai;
         lastlabel : tlabel;

      begin
         clear_reference(p^.location.reference);
         lastlabel:=-1;
         { const already used ? }
         if p^.labnumber=-1 then
           begin
              { tries to found an old entry }
              hp1:=pai(consts^.first);
              while assigned(hp1) do
                begin
                   if hp1^.typ=ait_label then
                     lastlabel:=pai_label(hp1)^.l
                   else
                     begin
                        if (hp1^.typ=ait_real_64bit) and (lastlabel<>-1) and
                          (pai_double(hp1)^.value=p^.valued) then
                          begin
                             { found! }
                             p^.labnumber:=lastlabel;
                             break;
                          end;
                        lastlabel:=-1;
                     end;
                   hp1:=pai(hp1^.next);
                end;
              { :-(, we must generate a new entry }
              if p^.labnumber=-1 then
                begin
                   getlabel(p^.labnumber);
                   consts^.insert(new(pai_double,init(p^.valued)));
                   consts^.insert(new(pai_label,init(p^.labnumber)));
                end;
           end;
         stringdispose(p^.location.reference.symbol);
         p^.location.reference.symbol:=stringdup(lab2str(p^.labnumber));
      end;

    procedure secondfixconst(var p : ptree);far;

      begin
         { an fix comma const. behaves as a memory reference }
         p^.location.loc:=LOC_MEM;
         p^.location.reference.isintvalue:=true;
         p^.location.reference.offset:=p^.valuef;
      end;

    procedure secondordconst(var p : ptree);far;

      begin
         { an integer const. behaves as a memory reference }
         p^.location.loc:=LOC_MEM;
         p^.location.reference.isintvalue:=true;
         p^.location.reference.offset:=p^.value;
      end;

    procedure secondniln(var p : ptree);far;

      begin
         p^.location.loc:=LOC_MEM;
         p^.location.reference.isintvalue:=true;
         p^.location.reference.offset:=0;
      end;

    procedure secondstringconst(var p : ptree);far;

      var
         l : longint;

      begin
         clear_reference(p^.location.reference);
         getlabel(l);
{$ifdef CleanUp}
         p^.location.loc := LOC_MEM;
         stringdispose(p^.location.reference.symbol);
{$endif * CleanUp *}
         p^.location.reference.symbol:=stringdup(lab2str(l));
         datasegment^.concat(new(pai_label,init(l)));
         generate_ascii(char(length(p^.values^))+p^.values^+#0);
      end;

    procedure secondumminus(var p : ptree);far;

      begin
         secondpass(p^.left);
         p^.location.loc:=LOC_REGISTER;
         case p^.left^.location.loc of
            LOC_REGISTER : begin
                              p^.location.register:=p^.left^.location.register;
                              exprasmlist^.concat(new(pai386,op_reg(A_NEG,S_L,p^.location.register)));
                           end;
            LOC_CREGISTER : begin
                               p^.location.register:=getregister32;
                               emit_reg_reg(A_MOV,S_L,p^.location.register,
                                 p^.location.register);
                               exprasmlist^.concat(new(pai386,op_reg(A_NEG,S_L,p^.location.register)));
                            end;
            LOC_REFERENCE,LOC_MEM :
                           begin
                              del_reference(p^.left^.location.reference);
                              if (p^.left^.resulttype^.deftype=floatdef) and
                                 (pfloatdef(p^.left^.resulttype)^.typ<>f32bit) then
                                begin
                                   p^.location.loc:=LOC_FPUSTACK;
                                   floatload(pfloatdef(p^.left^.resulttype)^.typ,
                                     p^.left^.location.reference);
                                   exprasmlist^.concat(new(pai386,op_none(A_FCHS,S_NO)));
                                end
                              else
                                begin
                                   p^.location.register:=getregister32;
                                   exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,
                                     newreference(p^.left^.location.reference),
                                     p^.location.register)));
                                   exprasmlist^.concat(new(pai386,op_reg(A_NEG,S_L,p^.location.register)));
                                end;
                           end;
            LOC_FPUSTACK : begin
                              p^.location.loc:=LOC_FPUSTACK;
                              exprasmlist^.concat(new(pai386,op_none(A_FCHS,S_NO)));
                           end;
         end;
         emitoverflowcheck;
      end;

    procedure secondaddr(var p : ptree);far;

      begin
         secondpass(p^.left);
         p^.location.loc:=LOC_REGISTER;
         del_reference(p^.left^.location.reference);
         p^.location.register:=getregister32;
         exprasmlist^.concat(new(pai386,op_ref_reg(A_LEA,S_L,newreference(p^.left^.location.reference),
           p^.location.register)));
      end;

    procedure secondnot(var p : ptree);far;

      const
         flagsinvers : array[F_E..F_BE] of tresflags =
            (F_NE,F_E,F_LE,F_GE,F_L,F_G,F_NC,F_C,
             F_A,F_AE,F_B,F_BE);

      var
         hl : longint;

      begin
         if (p^.resulttype^.deftype=orddef) and
            (porddef(p^.resulttype)^.typ=bool8bit) then
              begin
                 case p^.location.loc of
                    LOC_JUMP : begin
                                  hl:=truelabel;
                                  truelabel:=falselabel;
                                  falselabel:=hl;
                                  secondpass(p^.left);
                                  maketojumpbool(p^.left);
                                  hl:=truelabel;
                                  truelabel:=falselabel;
                                  falselabel:=hl;
                               end;
                    LOC_FLAGS : begin
                                   secondpass(p^.left);
                                   p^.location.resflags:=flagsinvers[p^.left^.location.resflags];
                                end;
                    LOC_REGISTER : begin
                                      secondpass(p^.left);
                                      p^.location.register:=p^.left^.location.register;
                                      exprasmlist^.concat(new(pai386,op_const_reg(A_XOR,S_B,1,p^.location.register)));
                                   end;
                    LOC_CREGISTER : begin
                                       secondpass(p^.left);
                                       p^.location.loc:=LOC_REGISTER;
                                       p^.location.register:=reg32toreg8(getregister32);
                                       emit_reg_reg(A_MOV,S_B,p^.left^.location.register,
                                         p^.location.register);
                                       exprasmlist^.concat(new(pai386,op_const_reg(A_XOR,S_B,1,p^.location.register)));
                                    end;
                    LOC_REFERENCE,LOC_MEM : begin
                                              secondpass(p^.left);
                                              del_reference(p^.left^.location.reference);
                                              p^.location.loc:=LOC_REGISTER;
                                              p^.location.register:=reg32toreg8(getregister32);
                                              exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_B,
                                                newreference(p^.left^.location.reference),
                                                p^.location.register)));
                                              exprasmlist^.concat(new(pai386,op_const_reg(A_XOR,S_B,1,p^.location.register)));
                                           end;
                 end;
              end
            else
              begin
                secondpass(p^.left);
                p^.location.loc:=LOC_REGISTER;
                case p^.left^.location.loc of
                   LOC_REGISTER : begin
                                     p^.location.register:=p^.left^.location.register;
                                     exprasmlist^.concat(new(pai386,op_reg(A_NOT,S_L,p^.location.register)));
                                  end;
                   LOC_CREGISTER : begin
                                     p^.location.register:=getregister32;
                                     emit_reg_reg(A_MOV,S_L,p^.left^.location.register,
                                       p^.location.register);
                                     exprasmlist^.concat(new(pai386,op_reg(A_NOT,S_L,p^.location.register)));
                                   end;
                   LOC_REFERENCE,LOC_MEM :
                                  begin
                                     del_reference(p^.left^.location.reference);
                                     p^.location.register:=getregister32;
                                     exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,
                                       newreference(p^.left^.location.reference),
                                       p^.location.register)));
                                     exprasmlist^.concat(new(pai386,op_reg(A_NOT,S_L,p^.location.register)));
                                  end;
                end;
             end;
      end;

    procedure secondnothing(var p : ptree);far;

      begin
      end;

    procedure secondassignment(var p : ptree);far;

      var
         opsize : topsize;
         pushed,withresult : boolean;
         otlabel,hlabel,oflabel : tlabel;
         hregister : tregister;
         loc : tloc;

      begin
         otlabel:=truelabel;
         oflabel:=falselabel;
         getlabel(truelabel);
         getlabel(falselabel);
         {  I dont understand what this is PM }
         withresult:=not(aktexprlevel<4);
         { calculate left sides }
         secondpass(p^.left);
         case p^.left^.location.loc of
            LOC_REFERENCE : begin
                              { in case left operator uses to register }
                              { but to few are free then LEA }
                              if (p^.left^.location.reference.base<>R_NO) and
                                 (p^.left^.location.reference.index<>R_NO) and
                                 (usablereg32<p^.right^.registers32) then
                                begin
                                   del_reference(p^.left^.location.reference);
                                   hregister:=getregister32;
                                   exprasmlist^.concat(new(pai386,op_ref_reg(A_LEA,S_L,newreference(
                                     p^.left^.location.reference),
                                     hregister)));
                                   clear_reference(p^.left^.location.reference);
                                   p^.left^.location.reference.base:=hregister;
                                   p^.left^.location.reference.index:=R_NO;
                                end;
                              loc:=LOC_REFERENCE;
                           end;
            LOC_CREGISTER : loc:=LOC_CREGISTER;
            else
               begin
                  error(error_in_expression);
                  exit;
               end;
         end;
         secondpass(p^.right);
         if p^.right^.resulttype^.deftype=stringdef then
           begin
              { we do not need destination anymore }
              del_reference(p^.left^.location.reference);
              { only source if withresult is set }
              if not(withresult) then
                del_reference(p^.right^.location.reference);
              copystring(p^.left^.location.reference,p^.right^.location.reference,
                min(pstringdef(p^.right^.resulttype)^.len,pstringdef(p^.left^.resulttype)^.len));

              ungetiftemp(p^.right^.location.reference);
           end
         else case p^.right^.location.loc of
            LOC_REFERENCE,
            LOC_MEM : begin
                         { handle ordinal constants trimmed }
                         if (p^.right^.treetype in [ordconstn,fixconstn]) or
                            (loc=LOC_CREGISTER) then
                           begin
                              case p^.left^.resulttype^.size of
                                 1 : opsize:=S_B;
                                 2 : opsize:=S_W;
                                 4 : opsize:=S_L;
                              end;
                              if loc=LOC_CREGISTER then
                                exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,opsize,
                                  newreference(p^.right^.location.reference),
                                  p^.left^.location.register)))
                              else
                                exprasmlist^.concat(new(pai386,op_const_ref(A_MOV,opsize,
                                  p^.right^.location.reference.offset,
                                  newreference(p^.left^.location.reference))));
                           end
                         else
                           begin
                              concatcopy(p^.right^.location.reference,
                                p^.left^.location.reference,p^.left^.resulttype^.size,
                                withresult);
                              ungetiftemp(p^.right^.location.reference);
                           end;
                      end;
            LOC_REGISTER,
            LOC_CREGISTER : begin
                              case p^.right^.resulttype^.size of
                                 1 : opsize:=S_B;
                                 2 : opsize:=S_W;
                                 4 : opsize:=S_L;
                              end;
                              if loc=LOC_CREGISTER then
                                exprasmlist^.concat(new(pai386,op_reg_reg(A_MOV,opsize,
                                  p^.right^.location.register,
                                  p^.left^.location.register)))
                              else
                                exprasmlist^.concat(new(pai386,op_reg_ref(A_MOV,opsize,
                                  p^.right^.location.register,
                                  newreference(p^.left^.location.reference))));
                           end;
            LOC_FPUSTACK : begin
                              if loc<>LOC_REFERENCE then
                                internalerror(10010)
                              else
                                floatstore(pfloatdef(p^.left^.resulttype)^.typ,
                                  p^.left^.location.reference);
                           end;
            LOC_JUMP     : begin
                              getlabel(hlabel);
                              emitl(A_LABEL,truelabel);
                              if loc=LOC_CREGISTER then
                                exprasmlist^.concat(new(pai386,op_const_reg(A_MOV,S_B,
                                  1,p^.left^.location.register)))
                              else
                                exprasmlist^.concat(new(pai386,op_const_ref(A_MOV,S_B,
                                  1,newreference(p^.left^.location.reference))));
                              emitl(A_JMP,hlabel);
                              emitl(A_LABEL,falselabel);
                              if loc=LOC_CREGISTER then
                                exprasmlist^.concat(new(pai386,op_reg_reg(A_XOR,S_B,
                                  p^.left^.location.register,
                                  p^.left^.location.register)))
                              else
                                exprasmlist^.concat(new(pai386,op_const_ref(A_MOV,S_B,
                                  0,newreference(p^.left^.location.reference))));
                              emitl(A_LABEL,hlabel);
                           end;
            LOC_FLAGS    : begin
                              if loc=LOC_CREGISTER then
                                exprasmlist^.concat(new(pai386,op_reg(flag_2_set[p^.right^.location.resflags],S_NO,
                                  p^.left^.location.register)))
                              else
                                exprasmlist^.concat(new(pai386,op_ref(flag_2_set[p^.right^.location.resflags],S_NO,
                                  newreference(p^.left^.location.reference))));
                           end;
         end;
         truelabel:=otlabel;
         falselabel:=oflabel;
      end;

    procedure secondderef(var p : ptree);far;

      var
         hr : tregister;

      begin
         secondpass(p^.left);
         clear_reference(p^.location.reference);
         case p^.left^.location.loc of
            LOC_REGISTER : p^.location.reference.base:=p^.left^.location.register;
            LOC_CREGISTER : begin
                               { ... and reserve one for the pointer }
                               hr:=getregister32;
                               emit_reg_reg(A_MOV,S_L,p^.left^.location.register,hr);
                               p^.location.reference.base:=hr;
                            end;
            else
              begin
                 { free register }
                 del_reference(p^.left^.location.reference);

                 { ...and reserve one for the pointer }
                 hr:=getregister32;
                 exprasmlist^.concat(new(pai386,op_ref_reg(
                   A_MOV,S_L,newreference(p^.left^.location.reference),
                   hr)));
                 p^.location.reference.base:=hr;
              end;
         end;
      end;

    procedure secondvecn(var p : ptree);far;

      var
         pushed : boolean;
         ind : tregister;
         _p : ptree;

      procedure calc_emit_mul;

        var
           l1,l2 : longint;

        begin
           l1:=p^.resulttype^.size;
           case l1 of
              1,2,4,8 : p^.location.reference.scalefactor:=l1;
           else
                begin
                   if ispowerof2(l1,l2) then
                     exprasmlist^.concat(new(pai386,op_const_reg(A_SHL,S_L,l2,ind)))
                   else
                     exprasmlist^.concat(new(pai386,op_const_reg(A_IMUL,S_L,l1,ind)));
                end;
           end;
        end;

      var
         extraoffset : longint;
         t : ptree;
         hp : preference;

      begin
         secondpass(p^.left);
{$ifndef CleanUp}
         p^.location:=p^.left^.location;
{$else * CleanUp *}
         set_location(p^.location,p^.left^.location);
{$endif * CleanUp *}

         { offset can only differ from 0 if arraydef }
         if p^.left^.resulttype^.deftype=arraydef then
           dec(p^.location.reference.offset,
             p^.resulttype^.size*
             parraydef(p^.left^.resulttype)^.lowrange);
         if p^.right^.treetype=ordconstn then
           begin

              { offset can only differ from 0 if arraydef }
              if p^.left^.resulttype^.deftype=arraydef then
                begin
                   if (p^.right^.value>parraydef(p^.left^.resulttype)^.highrange) or
                      (p^.right^.value<parraydef(p^.left^.resulttype)^.lowrange) then
                     error(range_check_error);

                   dec(p^.left^.location.reference.offset,
                      p^.resulttype^.size*parraydef(p^.left^.resulttype)^.lowrange);
                end;
              inc(p^.left^.location.reference.offset,
                 p^.right^.value*p^.resulttype^.size);
              p^.left^.resulttype:=p^.resulttype;
              disposetree(p^.right);
              _p:=p^.left;
              putnode(p);
              p:=_p;
           end
         else
           begin
              { quick hack, to overcome Delphi 2 }
              if (cs_maxoptimieren in aktswitches) and
                (p^.left^.resulttype^.deftype=arraydef) then
                begin
                   extraoffset:=0;
                   if (p^.right^.treetype=addn) then
                     begin
                        if p^.right^.right^.treetype=ordconstn then
                          begin
                             extraoffset:=p^.right^.right^.value;
                             t:=p^.right^.left;
                             putnode(p^.right);
                             putnode(p^.right^.right);
                             p^.right:=t
                          end
                        else if p^.right^.left^.treetype=ordconstn then
                          begin
                             extraoffset:=p^.right^.left^.value;
                             t:=p^.right^.right;
                             putnode(p^.right);
                             putnode(p^.right^.left);
                             p^.right:=t
                          end;
                     end
                   else if (p^.right^.treetype=subn) then
                     begin
                        if p^.right^.right^.treetype=ordconstn then
                          begin
                             extraoffset:=p^.right^.right^.value;
                             t:=p^.right^.left;
                             putnode(p^.right);
                             putnode(p^.right^.right);
                             p^.right:=t
                          end
                        else if p^.right^.left^.treetype=ordconstn then
                          begin
                             extraoffset:=p^.right^.left^.value;
                             t:=p^.right^.right;
                             putnode(p^.right);
                             putnode(p^.right^.left);
                             p^.right:=t
                          end;
                     end;
                   inc(p^.location.reference.offset,
                    p^.resulttype^.size*extraoffset);
                end;
              { calculate from left to right }
              if (p^.location.loc<>LOC_REFERENCE) and
                 (p^.location.loc<>LOC_MEM) then
                error(error_in_expression);
              pushed:=maybe_push(p^.right^.registers32,p);
              secondpass(p^.right);
              if pushed then restore(p);
              case p^.right^.location.loc of
                LOC_REGISTER : ind:=p^.right^.location.register;
                LOC_CREGISTER : begin
                                   ind:=getregister32;
                                   emit_reg_reg(A_MOV,S_L,p^.right^.location.register,ind);
                                end;
                else
                   begin
                      del_reference(p^.right^.location.reference);
                      ind:=getregister32;
                      exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,newreference(p^.right^.location.reference),
                        ind)));
                   end;
              end;
              { produce possible range check code: }
              if cs_rangechecking in aktswitches  then
                begin
                   if p^.left^.resulttype^.deftype=arraydef then
                     begin
                        new(hp);
                        reset_reference(hp^);
                        hp^.symbol:=stringdup('R_'+tostr(parraydef(p^.left^.resulttype)^.rangenr));
                        parraydef(p^.left^.resulttype)^.genrangecheck;
                        exprasmlist^.concat(new(pai386,op_reg_ref(A_BOUND,S_L,ind,hp)));
                     end;
                end;
              if p^.location.reference.index=R_NO then
                begin
                   p^.location.reference.index:=ind;
                   calc_emit_mul;
                end
              else
                begin
                   if p^.location.reference.base=R_NO then
                     begin
                        case p^.location.reference.scalefactor of
                           2 : exprasmlist^.concat(new(pai386,op_const_reg(A_SHL,S_L,1,p^.location.reference.index)));
                           4 : exprasmlist^.concat(new(pai386,op_const_reg(A_SHL,S_L,2,p^.location.reference.index)));
                           8 : exprasmlist^.concat(new(pai386,op_const_reg(A_SHL,S_L,3,p^.location.reference.index)));
                        end;
                        calc_emit_mul;
                        p^.location.reference.base:=p^.location.reference.index;

                        p^.location.reference.index:=ind;
                     end
                   else
                     begin
                        exprasmlist^.concat(new(pai386,op_ref_reg(
                          A_LEA,S_L,newreference(p^.location.reference),
                          p^.location.reference.index)));
                        ungetregister32(p^.location.reference.base);
                        { the symbol offset is loaded,               }
                        { so release the symbol name and set symbol  }
                        { to nil                                     }
                        stringdispose(p^.location.reference.symbol);
                        p^.location.reference.offset:=0;
                        calc_emit_mul;
                        p^.location.reference.base:=p^.location.reference.index;
                        p^.location.reference.index:=ind;
                     end;
                end;
           end;
      end;

    { *************** Converting Types **************** }

    { produces if necessary rangecheckcode }

    procedure maybe_rangechecking(p : ptree;p2,p1 : pdef);

      var
         hregister : tregister;
         hp : preference;

      begin
         if (cs_rangechecking in aktswitches)  and
           ((porddef(p1)^.von>porddef(p2)^.von) or
           (porddef(p1)^.bis<porddef(p2)^.bis)) then
           begin
              porddef(p1)^.genrangecheck;
              if porddef(p1)^.typ=u8bit then
                begin
                   if (p^.location.loc=LOC_REGISTER) or
                      (p^.location.loc=LOC_CREGISTER) then
                     exprasmlist^.concat(new(pai386,op_reg_reg(A_MOVZX,S_BL,p^.location.register,R_EDI)))
                   else
                     exprasmlist^.concat(new(pai386,op_ref_reg(A_MOVZX,S_BL,newreference(p^.location.reference),R_EDI)));
                   hregister:=R_EDI;
                end
              else if porddef(p1)^.typ=s8bit then
                begin
                   if (p^.location.loc=LOC_REGISTER) or
                      (p^.location.loc=LOC_CREGISTER) then
                     exprasmlist^.concat(new(pai386,op_reg_reg(A_MOVSX,S_BL,p^.location.register,R_EDI)))
                   else
                     exprasmlist^.concat(new(pai386,op_ref_reg(A_MOVSX,S_BL,newreference(p^.location.reference),R_EDI)));
                   hregister:=R_EDI;
                end
              else if porddef(p1)^.typ=s32bit then
                begin
                   if (p^.location.loc=LOC_REGISTER) or
                      (p^.location.loc=LOC_CREGISTER) then
                     hregister:=p^.location.register
                   else
                     begin
                        exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,newreference(p^.location.reference),R_EDI)));
                        hregister:=R_EDI;
                     end;
                end
              { rangechecking for u32bit ?? !!!!!!}
              else if porddef(p1)^.typ=u16bit then
                begin
                   if (p^.location.loc=LOC_REGISTER) or
                      (p^.location.loc=LOC_CREGISTER) then
                     exprasmlist^.concat(new(pai386,op_reg_reg(A_MOVZX,S_WL,p^.location.register,R_EDI)))
                   else
                     exprasmlist^.concat(new(pai386,op_ref_reg(A_MOVZX,S_WL,newreference(p^.location.reference),R_EDI)));
                   hregister:=R_EDI;
                end
              else if porddef(p1)^.typ=s16bit then
                begin
                   if (p^.location.loc=LOC_REGISTER) or
                      (p^.location.loc=LOC_CREGISTER) then
                     exprasmlist^.concat(new(pai386,op_reg_reg(A_MOVSX,S_WL,p^.location.register,R_EDI)))
                   else
                     exprasmlist^.concat(new(pai386,op_ref_reg(A_MOVSX,S_WL,newreference(p^.location.reference),R_EDI)));
                   hregister:=R_EDI;
                end
              else internalerror(6);
              new(hp);
              reset_reference(hp^);
              hp^.symbol:=stringdup('R_'+tostr(porddef(p1)^.rangenr));
              exprasmlist^.concat(new(pai386,op_reg_ref(A_BOUND,S_L,hregister,hp)));
           end;
      end;

    type
       tsecondconvproc = procedure(p,hp : ptree;convtyp : tconverttype);

    procedure second_only_rangecheck(p,hp : ptree;convtyp : tconverttype);far;

      begin
         maybe_rangechecking(p,hp^.resulttype,p^.resulttype);
      end;

    procedure second_bigger(p,hp : ptree;convtyp : tconverttype);far;

      var
         hregister : tregister;
         opsize : topsize;
         op : tasmop;
         is_register : boolean;

      begin
         is_register:=p^.left^.location.loc=LOC_REGISTER;
         if not(is_register) and (p^.left^.location.loc<>LOC_CREGISTER) then
           del_reference(p^.left^.location.reference);
         case convtyp of
            tc_u8bit_2_s32bit :
              begin
                 if is_register then
                   hregister:=reg8toreg32(p^.left^.location.register)
                 else hregister:=getregister32;
                 op:=A_MOVZX;
                 opsize:=S_BL;
              end;
            tc_s8bit_2_s32bit :
              begin
                 if is_register then
                   hregister:=reg8toreg32(p^.left^.location.register)
                 else hregister:=getregister32;
                 op:=A_MOVSX;
                 opsize:=S_BL;
              end;
            tc_u16bit_2_s32bit :
              begin
                 if is_register then
                   hregister:=reg16toreg32(p^.left^.location.register)
                 else hregister:=getregister32;
                 op:=A_MOVZX;
                 opsize:=S_WL;
              end;
            tc_s16bit_2_s32bit :
              begin
                 if is_register then
                   hregister:=reg16toreg32(p^.left^.location.register)
                 else hregister:=getregister32;
                 op:=A_MOVSX;
                 opsize:=S_WL;
              end;
            tc_s8bit_2_u16bit,
            tc_u8bit_2_s16bit,
            tc_u8bit_2_u16bit :
              begin
                 if is_register then
                   hregister:=reg8toreg16(p^.left^.location.register)
                 else hregister:=reg32toreg16(getregister32);
                 op:=A_MOVZX;
                 opsize:=S_BW;
              end;
            tc_s8bit_2_s16bit :
              begin
                 if is_register then
                   hregister:=reg8toreg16(p^.left^.location.register)
                 else hregister:=reg32toreg16(getregister32);
                 op:=A_MOVSX;
                 opsize:=S_BW;
              end;
         end;
         if is_register then
           begin
              emit_reg_reg(op,opsize,p^.left^.location.register,hregister);
           end
         else
           begin
              if p^.left^.location.loc=LOC_CREGISTER then
                emit_reg_reg(op,opsize,p^.left^.location.register,hregister)
              else exprasmlist^.concat(new(pai386,op_ref_reg(op,opsize,
                newreference(p^.left^.location.reference),hregister)));
           end;
         maybe_rangechecking(p,p^.left^.resulttype,p^.resulttype);
         p^.location.loc:=LOC_REGISTER;
         p^.location.register:=hregister;
      end;

    procedure second_string_string(p,hp : ptree;convtyp : tconverttype);far;

      var
         pushedregs : tpushed;

      begin
{$ifndef CleanUp}
         clear_reference(p^.location.reference);
         p^.location.reference.base:=procinfo.framepointer;
         p^.location.reference.offset:=gettempofsize(p^.resulttype^.size);
{$else * CleanUp *}
         {clear_reference(p^.location.reference);
         p^.location.reference.base:=R_EBP;
         p^.location.reference.offset:=gettempofsize(p^.resulttype^.size);}
         stringdispose(p^.location.reference.symbol);
         gettempofsizereference(p^.resulttype^.size,p^.location.reference);
         {This could be a problem for me temp unget !!}
{$endif * CleanUp *}
         del_reference(p^.left^.location.reference);
         pushusedregisters(pushedregs,$ff);
         emitpushreferenceaddr(p^.location.reference);
         emitpushreferenceaddr(p^.left^.location.reference);
         push_int(pstringdef(p^.resulttype)^.len);
         exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol('STRCOPY',0))));
         maybe_loadesi;
         popusedregisters(pushedregs);
      end;

    procedure second_cstring_charpointer(p,hp : ptree;convtyp : tconverttype);far;

      begin
         p^.location.loc:=LOC_REGISTER;
         p^.location.register:=getregister32;
         inc(p^.left^.location.reference.offset);
         exprasmlist^.concat(new(pai386,op_ref_reg(A_LEA,S_L,newreference(p^.left^.location.reference),
           p^.location.register)));
      end;

    procedure second_cchar_charpointer(p,hp : ptree;convtyp : tconverttype);far;

      begin
         {!!!!}
         p^.location.loc:=LOC_REGISTER;
         p^.location.register:=getregister32;
         inc(p^.left^.location.reference.offset);
         exprasmlist^.concat(new(pai386,op_ref_reg(A_LEA,S_L,newreference(p^.left^.location.reference),
           p^.location.register)));
      end;

    procedure second_string_chararray(p,hp : ptree;convtyp : tconverttype);far;

      begin
{$ifndef CleanUp}
         p^.location.reference:=p^.left^.location.reference;
{$else * CleanUp *}
         {this is dangerous for dispose : already done before
         in secondconv
         p^.location.reference:=p^.left^.location.reference;}
{$endif * CleanUp *}
         inc(p^.location.reference.offset);
      end;

    procedure second_array_to_pointer(p,hp : ptree;convtyp : tconverttype);far;

      begin
         del_reference(p^.left^.location.reference);
         p^.location.loc:=LOC_REGISTER;
         p^.location.register:=getregister32;
         exprasmlist^.concat(new(pai386,op_ref_reg(A_LEA,S_L,newreference(p^.left^.location.reference),
           p^.location.register)));
      end;

    procedure second_pointer_to_array(p,hp : ptree;convtyp : tconverttype);far;

      begin
         p^.location.loc:=LOC_REFERENCE;
         clear_reference(p^.location.reference);
         if p^.left^.location.loc=LOC_REGISTER then
           p^.location.reference.base:=p^.left^.location.register
         else
           begin
              if p^.left^.location.loc=LOC_CREGISTER then
                begin
                   p^.location.reference.base:=getregister32;
                   emit_reg_reg(A_MOV,S_L,p^.left^.location.register,
                     p^.location.reference.base);
                end
              else
                begin
                   del_reference(p^.left^.location.reference);
                   p^.location.reference.base:=getregister32;
                   exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,newreference(p^.left^.location.reference),
                     p^.location.reference.base)));
                end;
           end;
      end;

    { generates the code for the type conversation from an array of char }
    { to a string                                                        }
    procedure second_chararray_to_string(p,hp : ptree;convtyp : tconverttype);far;

      var
         l : longint;

      begin
         { this is a type conversation which copies the data, so we can't }
         { return a reference                                             }
         p^.location.loc:=LOC_MEM;

         { first get the memory for the string }
{$ifndef CleanUp}
         clear_reference(p^.location.reference);

         p^.location.reference.offset:=gettempofsize(256);
         p^.location.reference.base:=procinfo.framepointer;
{$else * CleanUp *}
         stringdispose(p^.location.reference.symbol);
         gettempofsizereference(256,p^.location.reference);
{$endif * CleanUp *}

         { calc the length of the array }
         l:=parraydef(p^.left^.resulttype)^.highrange-
           parraydef(p^.left^.resulttype)^.lowrange+1;

         if l>255 then
           error(type_mismatch);

         { write the length }
         exprasmlist^.concat(new(pai386,op_const_ref(A_MOV,S_B,l,
           newreference(p^.location.reference))));

         { copy to first char of string }
         inc(p^.location.reference.offset);

         { generates the copy code      }
         { and we need the source never }
         concatcopy(p^.left^.location.reference,p^.location.reference,l,true);

         { correct the string location }
         dec(p^.location.reference.offset);
      end;

    procedure second_char_to_string(p,hp : ptree;convtyp : tconverttype);far;

      begin
{$ifndef CleanUp}
         clear_reference(p^.location.reference);
         p^.location.reference.offset:=gettempofsize(256);
         p^.location.reference.base:=procinfo.framepointer;
{$else * CleanUp *}
         {clear_reference(p^.location.reference);
         p^.location.reference.offset:=gettempofsize(256);
         p^.location.reference.base:=R_EBP; }
         stringdispose(p^.location.reference.symbol);
         gettempofsizereference(256,p^.location.reference);
{$endif * CleanUp *}
         { is it a char const ? }
         if p^.left^.treetype=ordconstn then
           exprasmlist^.concat(new(pai386,op_const_ref(A_MOV,S_W,p^.left^.value*256+1,newreference(p^.location.reference))))
         else
           begin
              { not so elegant (goes better with extra register }
              if (p^.left^.location.loc=LOC_REGISTER) or
                 (p^.left^.location.loc=LOC_CREGISTER) then
                begin
                   exprasmlist^.concat(new(pai386,op_reg_reg(A_MOVZX,S_BW,p^.left^.location.register,R_DI)));
                   ungetregister32(reg8toreg32(p^.left^.location.register));
                end
              else
                begin
                   exprasmlist^.concat(new(pai386,op_ref_reg(A_MOVZX,S_BW,newreference(p^.left^.location.reference),R_DI)));
                   del_reference(p^.left^.location.reference);
                end;
              exprasmlist^.concat(new(pai386,op_const_reg(A_SHL,S_W,8,R_DI)));
              exprasmlist^.concat(new(pai386,op_const_reg(A_OR,S_W,1,R_DI)));
              exprasmlist^.concat(new(pai386,op_reg_ref(A_MOV,S_W,R_DI,newreference(p^.location.reference))));
           end;
      end;

    procedure second_int_real(p,hp : ptree;convtyp : tconverttype);far;

      var
         r : preference;

      begin
         if (p^.left^.location.loc=LOC_REGISTER) or
            (p^.left^.location.loc=LOC_CREGISTER) then
           begin
              case porddef(p^.left^.resulttype)^.typ of
                 s8bit : exprasmlist^.concat(new(pai386,op_reg_reg(A_MOVSX,S_BL,p^.left^.location.register,R_EDI)));
                 u8bit : exprasmlist^.concat(new(pai386,op_reg_reg(A_MOVZX,S_BL,p^.left^.location.register,R_EDI)));
                 s16bit : exprasmlist^.concat(new(pai386,op_reg_reg(A_MOVSX,S_WL,p^.left^.location.register,R_EDI)));
                 u16bit : exprasmlist^.concat(new(pai386,op_reg_reg(A_MOVZX,S_WL,p^.left^.location.register,R_EDI)));
                 s32bit : exprasmlist^.concat(new(pai386,op_reg_reg(A_MOV,S_L,p^.left^.location.register,R_EDI)));
                 {!!!! u32bit }
              end;
              ungetregister(p^.left^.location.register);
           end
         else
           begin
              r:=newreference(p^.left^.location.reference);
              case porddef(p^.left^.resulttype)^.typ of
                 s8bit : exprasmlist^.concat(new(pai386,op_ref_reg(A_MOVSX,S_BL,r,R_EDI)));
                 u8bit : exprasmlist^.concat(new(pai386,op_ref_reg(A_MOVZX,S_BL,r,R_EDI)));
                 s16bit : exprasmlist^.concat(new(pai386,op_ref_reg(A_MOVSX,S_WL,r,R_EDI)));
                 u16bit : exprasmlist^.concat(new(pai386,op_ref_reg(A_MOVZX,S_WL,r,R_EDI)));
                 s32bit : exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,r,R_EDI)));
                 {!!!! u32bit }
              end;
              del_reference(p^.left^.location.reference);
         end;
         exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,R_EDI)));
         new(r);
         reset_reference(r^);
         r^.base:=R_ESP;
         exprasmlist^.concat(new(pai386,op_ref(A_FILD,S_L,r)));

         { better than an add on all processors }
         exprasmlist^.concat(new(pai386,op_reg(A_POP,S_L,R_EDI)));

         p^.location.loc:=LOC_FPUSTACK;
      end;

    procedure second_real_fix(p,hp : ptree;convtyp : tconverttype);far;

      var
         hs : string;
         rreg : tregister;
         ref : treference;

      begin
         { real must be on fpu stack }
         if (p^.left^.location.loc<>LOC_FPUSTACK) then
           exprasmlist^.concat(new(pai386,op_ref(A_FLD,S_L,newreference(p^.left^.location.reference))));
         push_int($1f3f);
         push_int(65536);
         reset_reference(ref);
         ref.base:=R_ESP;

         exprasmlist^.concat(new(pai386,op_ref(A_FIMUL,S_L,newreference(ref))));

         ref.offset:=4;
         exprasmlist^.concat(new(pai386,op_ref(A_FSTCW,S_L,newreference(ref))));

         ref.offset:=6;
         exprasmlist^.concat(new(pai386,op_ref(A_FLDCW,S_L,newreference(ref))));

         ref.offset:=0;
         exprasmlist^.concat(new(pai386,op_ref(A_FISTP,S_L,newreference(ref))));

         ref.offset:=4;
         exprasmlist^.concat(new(pai386,op_ref(A_FLDCW,S_L,newreference(ref))));

         rreg:=getregister32;
         exprasmlist^.concat(new(pai386,op_reg(A_POP,S_L,rreg)));
         { better than an add on all processors }
         exprasmlist^.concat(new(pai386,op_reg(A_POP,S_L,R_EDI)));

         p^.location.loc:=LOC_REGISTER;
         p^.location.register:=rreg;
      end;

    procedure second_float_float(p,hp : ptree;convtyp : tconverttype);far;

      begin
         case p^.left^.location.loc of
            LOC_FPUSTACK : ;
            LOC_MEM,
            LOC_REFERENCE : floatload(pfloatdef(p^.left^.resulttype)^.typ,
                              p^.left^.location.reference);
         end;
         p^.location.loc:=LOC_FPUSTACK;
      end;

    procedure second_fix_real(p,hp : ptree;convtyp : tconverttype);far;

    var popeax,popebx,popecx,popedx : boolean;
        startreg : tregister;
        hl : longint;
        r : treference;

      begin
         if (p^.left^.location.loc=LOC_REGISTER) or
            (p^.left^.location.loc=LOC_CREGISTER) then
           begin
              startreg:=p^.left^.location.register;
              ungetregister(startreg);
              popeax:=(startreg<>R_EAX) and not (R_EAX in unused);
              if popeax then
                exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,R_EAX)));
              { mov eax,eax is removed by emit_reg_reg }
              emit_reg_reg(A_MOV,S_L,startreg,R_EAX);
           end
         else
           begin
              exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,newreference(
                p^.left^.location.reference),R_EAX)));
              del_reference(p^.left^.location.reference);
              startreg:=R_NO;
           end;

         popebx:=(startreg<>R_EBX) and not (R_EBX in unused);
         if popebx then
           exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,R_EBX)));

         popecx:=(startreg<>R_ECX) and not (R_ECX in unused);
         if popecx then
           exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,R_ECX)));

         popedx:=(startreg<>R_EDX) and not (R_EDX in unused);
         if popedx then
           exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,R_EDX)));

         exprasmlist^.concat(new(pai386,op_none(A_CDQ,S_NO)));
         emit_reg_reg(A_XOR,S_L,R_EDX,R_EAX);
         emit_reg_reg(A_MOV,S_L,R_EAX,R_EBX);
         emit_reg_reg(A_SUB,S_L,R_EDX,R_EAX);
         getlabel(hl);
         emitl(A_JZ,hl);
         exprasmlist^.concat(new(pai386,op_const_reg(A_RCL,S_L,1,R_EBX)));
         emit_reg_reg(A_BSR,S_L,R_EAX,R_EDX);
         exprasmlist^.concat(new(pai386,op_const_reg(A_MOV,S_B,32,R_CL)));
         emit_reg_reg(A_SUB,S_B,R_DL,R_CL);
         emit_reg_reg(A_SHL,S_L,R_CL,R_EAX);
         exprasmlist^.concat(new(pai386,op_const_reg(A_ADD,S_W,1007,R_DX)));
         exprasmlist^.concat(new(pai386,op_const_reg(A_SHL,S_W,5,R_DX)));
         exprasmlist^.concat(new(pai386,op_const_reg_reg(A_SHLD,S_W,11,R_DX,R_BX)));
         exprasmlist^.concat(new(pai386,op_const_reg_reg(A_SHLD,S_W,20,R_EAX,R_EBX)));

         exprasmlist^.concat(new(pai386,op_const_reg(A_SHL,S_L,20,R_EAX)));
         emitl(A_LABEL,hl);
         { better than an add on all processors }
         exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,R_EBX)));
         exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,R_EAX)));

         reset_reference(r);
         r.base:=R_ESP;
         exprasmlist^.concat(new(pai386,op_ref(A_FLD,S_L,newreference(r))));
         exprasmlist^.concat(new(pai386,op_const_reg(A_ADD,S_L,8,R_ESP)));
         if popedx then
           exprasmlist^.concat(new(pai386,op_reg(A_POP,S_L,R_EDX)));
         if popecx then
           exprasmlist^.concat(new(pai386,op_reg(A_POP,S_L,R_ECX)));
         if popebx then
           exprasmlist^.concat(new(pai386,op_reg(A_POP,S_L,R_EBX)));
         if popeax then
           exprasmlist^.concat(new(pai386,op_reg(A_POP,S_L,R_EAX)));

         p^.location.loc:=LOC_FPUSTACK;
      end;

    procedure second_int_fix(p,hp : ptree;convtyp : tconverttype);far;

      var
         hs : string;
         hregister : tregister;

      begin
         if (p^.left^.location.loc=LOC_REGISTER) then
           hregister:=p^.left^.location.register
         else if (p^.left^.location.loc=LOC_CREGISTER) then
           hregister:=getregister32
         else
           begin
              del_reference(p^.left^.location.reference);
              hregister:=getregister32;
              case porddef(p^.left^.resulttype)^.typ of
                s8bit : exprasmlist^.concat(new(pai386,op_ref_reg(A_MOVSX,S_BL,newreference(p^.left^.location.reference),
                  hregister)));
                u8bit : exprasmlist^.concat(new(pai386,op_ref_reg(A_MOVZX,S_BL,newreference(p^.left^.location.reference),
                  hregister)));
                s16bit : exprasmlist^.concat(new(pai386,op_ref_reg(A_MOVSX,S_WL,newreference(p^.left^.location.reference),
                  hregister)));
                u16bit : exprasmlist^.concat(new(pai386,op_ref_reg(A_MOVZX,S_WL,newreference(p^.left^.location.reference),
                  hregister)));
                s32bit : exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,newreference(p^.left^.location.reference),
                  hregister)));
                {!!!! u32bit }
              end;
           end;
         exprasmlist^.concat(new(pai386,op_const_reg(A_SHL,S_L,16,hregister)));

         p^.location.loc:=LOC_REGISTER;
         p^.location.register:=hregister;
      end;

    procedure second_smaller(p,hp : ptree;convtyp : tconverttype);far;

      var
         destregister : tregister;
         opsize : topsize;
         ref : boolean;

      begin
         { !!!!!!!! Rangechecking }
         ref:=false;
         if (p^.left^.location.loc=LOC_REGISTER) or
           (p^.left^.location.loc=LOC_CREGISTER) then
           begin
              destregister:=p^.location.register;
              case convtyp of
                 tc_s32bit_2_s8bit,
                 tc_s32bit_2_u8bit : destregister:=reg32toreg8(destregister);
                 tc_s32bit_2_s16bit,
                 tc_s32bit_2_u16bit : destregister:=reg32toreg16(destregister);
                 tc_s16bit_2_s8bit,
                 tc_s16bit_2_u8bit,
                 tc_u16bit_2_s8bit,
                 tc_u16bit_2_u8bit : destregister:=reg16toreg8(destregister);
              end;
              p^.location.register:=destregister;
           end;
      end;

    procedure secondtypeconv(var p : ptree);far;

      const
         secondconvert : array[tc_u8bit_2_s32bit..tc_chararray_2_string] of
           tsecondconvproc = (second_bigger,second_only_rangecheck,
                              second_bigger,second_bigger,second_bigger,
                              second_smaller,second_smaller,
                              second_smaller,second_string_string,
                              second_cstring_charpointer,second_string_chararray,
                              second_array_to_pointer,second_pointer_to_array,
                              second_char_to_string,second_bigger,
                              second_bigger,second_bigger,
                              second_smaller,second_smaller,
                              second_smaller,second_smaller,
                              second_bigger,second_smaller,
                              second_int_real,second_real_fix,
                              second_fix_real,second_int_fix,second_float_float,
                              second_chararray_to_string);{,second_cchar_charpointer); }

      begin
         secondpass(p^.left);
         set_location(p^.location,p^.left^.location);
         if p^.convtyp<>tc_equal then
           {the second argument only is for maybe_range_checking !}
           secondconvert[p^.convtyp](p,p^.left,p^.convtyp)
      end;

    { save the size of pushed parameter }
    var
       pushedparasize : longint;

    procedure secondcallparan(var p : ptree;defcoll : pdefcoll);

      var
         size : longint;
         stackref : treference;
         otlabel,hlabel,oflabel : longint;

         { temporary variables: }
         tempdeftype : tdeftype;
         tempreference : treference;
         r : preference;

      begin
         otlabel:=truelabel;
         oflabel:=falselabel;
         getlabel(truelabel);
         getlabel(falselabel);
         secondpass(p^.left);
         { in codegen.handleread.. defcoll^.data is set to nil }
         if assigned(defcoll^.data) and
           (defcoll^.data^.deftype=formaldef) then
           begin
              if (p^.left^.location.loc<>LOC_REFERENCE) and
                 (p^.left^.location.loc<>LOC_MEM) then
                error(type_mismatch);
              emitpushreferenceaddr(p^.left^.location.reference);
              del_reference(p^.left^.location.reference);
              inc(pushedparasize,4);
           end
         else if (defcoll^.paratyp=vs_var) then
           begin
              if (p^.left^.location.loc<>LOC_REFERENCE) then
                error(var_must_be_reference);
              emitpushreferenceaddr(p^.left^.location.reference);
              del_reference(p^.left^.location.reference);
              inc(pushedparasize,4);
           end
         else
           begin
              tempdeftype:=p^.resulttype^.deftype;
              if tempdeftype=filedef then
                error(file_must_call_by_reference);
              if (defcoll^.paratyp=vs_const) and
                 (
                   (tempdeftype=stringdef) or
                   (tempdeftype=arraydef) or
                   (tempdeftype=recorddef) or
                   (tempdeftype=objectdef) or
                   ((tempdeftype=setdef) and
                    (psetdef(p^.resulttype)^.settype<>smallset))
                 ) then
                begin
                   emitpushreferenceaddr(p^.left^.location.reference);
                   del_reference(p^.left^.location.reference);
                   inc(pushedparasize,4);
                end
              else
                case p^.left^.location.loc of
                   LOC_REGISTER,
                   LOC_CREGISTER : begin
                                     case p^.left^.location.register of
                                        R_EAX,R_EBX,R_ECX,R_EDX,R_ESI,
                                        R_EDI,R_ESP,R_EBP :
                                          begin
                                             exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,p^.left^.location.register)));
                                             inc(pushedparasize,4);
                                             ungetregister32(p^.left^.location.register);
                                          end;
                                        R_AX,R_BX,R_CX,R_DX,R_SI,R_DI : begin
                                              exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_W,p^.left^.location.register)));
                                              inc(pushedparasize,2);
                                              ungetregister32(reg16toreg32(p^.left^.location.register));
                                           end;
                                        R_AL,R_BL,R_CL,R_DL:
                                          begin
                                             { we must push always 16 bit }
                                             exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_W,
                                               reg8toreg16(p^.left^.location.register))));
                                             inc(pushedparasize,2);
                                             ungetregister32(reg8toreg32(p^.left^.location.register));
                                          end;
                                     end;
                                  end;
                   LOC_FPUSTACK : begin
                                        inc(pushedparasize,8);
                                        exprasmlist^.concat(new(pai386,op_const_reg(A_SUB,S_L,8,R_ESP)));
                                        new(r);
                                        reset_reference(r^);
                                        r^.base:=R_ESP;
                                        exprasmlist^.concat(new(pai386,op_ref(A_FSTP,S_L,r)));
                                     end;
                   LOC_REFERENCE,LOC_MEM :
                               begin
                                  tempreference:=p^.left^.location.reference;
                                  del_reference(p^.left^.location.reference);
                                  case p^.resulttype^.deftype of
                                     orddef : begin
                                                   case porddef(p^.resulttype)^.typ of
                                                      s32bit,u32bit :
                                                        begin
                                                           emit_push_mem(tempreference);
                                                           inc(pushedparasize,4);
                                                        end;
                                                      s8bit,u8bit,uchar,bool8bit,s16bit,u16bit : begin
                                                          exprasmlist^.concat(new(pai386,op_ref(A_PUSH,S_W,
                                                            newreference(tempreference))));
                                                          inc(pushedparasize,2);
                                                      end;
                                                    end;
                                              end;
                                     floatdef : begin
                                                   case pfloatdef(p^.resulttype)^.typ of
                                                      f32bit,
                                                      s32real :
                                                        begin
                                                           emit_push_mem(tempreference);
                                                           inc(pushedparasize,4);
                                                        end;
                                                      s64real,
                                                      s64bit : begin
                                                                   inc(tempreference.offset,4);
                                                                   emit_push_mem(tempreference);
                                                                   dec(tempreference.offset,4);
                                                                   emit_push_mem(tempreference);
                                                                   inc(pushedparasize,8);
                                                                end;
                                                      s80real : begin
                                                                   inc(tempreference.offset,6);
                                                                   emit_push_mem(tempreference);
                                                                   dec(tempreference.offset,4);
                                                                   emit_push_mem(tempreference);
                                                                   dec(tempreference.offset,2);
                                                                   exprasmlist^.concat(new(pai386,op_ref(A_PUSH,S_W,
                                                                     newreference(tempreference))));
                                                                   inc(pushedparasize,10);
                                                                end;
                                                   end;
                                                end;
                                     pointerdef,procvardef,aufzaehldef : begin
                                                      emit_push_mem(tempreference);
                                                      inc(pushedparasize,4);
                                                   end;
                                     arraydef,recorddef,stringdef,setdef,objectdef :
                                                begin
                                                   if ((p^.resulttype^.deftype=setdef) and
                                                     (psetdef(p^.resulttype)^.settype=smallset)) then
                                                     begin
                                                        emit_push_mem(tempreference);
                                                        inc(pushedparasize,4);
                                                     end
                                                   else
                                                     begin
                                                        size:=p^.resulttype^.size;

                                                        { Alignment }
                                                        {
                                                        if (size>=4) and ((size and 3)<>0) then
                                                          inc(size,4-(size and 3))
                                                        else if (size>=2) and ((size and 1)<>0) then
                                                          inc(size,2-(size and 1))
                                                        else
                                                        if size=1 then size:=2;
                                                        }
                                                        { create stack space }
                                                        exprasmlist^.concat(new(pai386,op_const_reg(A_SUB,S_L,size,R_ESP)));
                                                        inc(pushedparasize,size);
                                                        { create stack reference }
{$ifdef CleanUp}
                                                        stackref.symbol := nil;
{$endif * CleanUp *}
                                                        clear_reference(stackref);
                                                        stackref.base:=R_ESP;
                                                        { produce copy }
                                                        if p^.resulttype^.deftype=stringdef then
                                                          begin
                                                             copystring(stackref,p^.left^.location.reference,
                                                               pstringdef(p^.resulttype)^.len);
                                                          end
                                                        else
                                                          begin
                                                             concatcopy(p^.left^.location.reference,
                                                               stackref,p^.resulttype^.size,true);
                                                          end;
                                                     end;
                                                end;
                                     else error(error_in_expression);
                                  end;
                               end;
                 LOC_JUMP     : begin
                                   getlabel(hlabel);
                                   inc(pushedparasize,2);
                                   emitl(A_LABEL,truelabel);
                                   exprasmlist^.concat(new(pai386,op_const(A_PUSH,S_W,1)));
                                   emitl(A_JMP,hlabel);
                                   emitl(A_LABEL,falselabel);
                                   exprasmlist^.concat(new(pai386,op_const(A_PUSH,S_W,0)));
                                   emitl(A_LABEL,hlabel);
                                end;
                 LOC_FLAGS    : begin
                                   if not(R_EAX in unused) then
                                     exprasmlist^.concat(new(pai386,op_reg_reg(A_MOV,S_L,R_EAX,R_EDI)));

                                   { clear full EAX is faster }
                                   exprasmlist^.concat(new(pai386,op_reg_reg(A_XOR,S_L,R_EAX,R_EAX)));
                                   exprasmlist^.concat(new(pai386,op_reg(flag_2_set[p^.left^.location.resflags],S_NO,
                                     R_AL)));
                                   inc(pushedparasize,2);
                                   exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_W,R_AX)));
                                   if not(R_EAX in unused) then
                                     exprasmlist^.concat(new(pai386,op_reg_reg(A_MOV,S_L,R_EAX,R_EDI)));
                                end;
                end;
           end;
         truelabel:=otlabel;
         falselabel:=oflabel;
         { push from right to left }
         if assigned(p^.right) then
           secondcallparan(p^.right,defcoll^.next);
      end;

    procedure secondcalln(var p : ptree);far;

      var
         unusedregisters : tregisterset;
         pushed : tpushed;
         funcretref : treference;
         hregister : tregister;
         oldpushedparasize : longint;
         { true if ESI must be loaded again after the subroutine }
         loadesi : boolean;
         { true if a virtual method must be called directly }
         no_virtual_call : boolean;
         { true if we produce a con- or destrutor in a call }
         is_con_or_destructor : boolean;
         { true if a constructor is called again }
         extended_new : boolean;
         { adress returned from an I/O-error }
         iolabel : longint;

         { help reference pointer }
         r : preference;
         pp,params : ptree;

      label
         dont_call;

      begin
         extended_new:=false;
         loadesi:=true;
         no_virtual_call:=false;
         unusedregisters:=unused;
         { only if no proc var }
         if not(assigned(p^.right)) then
           is_con_or_destructor:=((p^.procdefinition^.options and poconstructor)<>0)
             or ((p^.procdefinition^.options and podestructor)<>0);
         { proc variables destroy all registers }
         if (p^.right=nil) and
         { virtual methods too }
          ((p^.procdefinition^.options and povirtualmethod)=0) then

           begin
              if ((p^.procdefinition^.options and poiocheck)<>0)
                and (cs_iocheck in aktswitches) then
                begin
                   getlabel(iolabel);
                   emitl(A_LABEL,iolabel);
                end
              else iolabel:=0;

              { save all used registers }
              pushusedregisters(pushed,p^.procdefinition^.usedregisters);

              { give used registers through }
              usedinproc:=usedinproc or p^.procdefinition^.usedregisters;
           end
         else
           begin
              pushusedregisters(pushed,$ff);
              usedinproc:=$ff;

              { no IO check for methods and procedure variables }
              iolabel:=0;
           end;

         { generate the code for the parameter and push them }
         oldpushedparasize:=pushedparasize;
         if (p^.resulttype<>pdef(voiddef)) and
            ((p^.resulttype^.deftype=arraydef) or
            (p^.resulttype^.deftype=stringdef) or
            (p^.resulttype^.deftype=objectdef) or
            (p^.resulttype^.deftype=recorddef) or
            (p^.resulttype^.deftype=setdef)) then
           begin
              funcretref.symbol:=nil;
              gettempofsizereference(p^.procdefinition^.retdef^.size,funcretref);
           end;
         if assigned(p^.left) then
           begin
              pushedparasize:=0;
              { in case of procedure variables the definitions will }
              { be found elsewhere }
              if assigned(p^.right) then
                secondcallparan(p^.left,pprocvardef(p^.right^.resulttype)^.para1)
              else
                secondcallparan(p^.left,p^.procdefinition^.para1);
           end;
{$ifdef CleanUp}
         params:=p^.left;
         p^.left:=nil;
{$endif * CleanUp *}
         if (p^.resulttype<>pdef(voiddef)) and
            ((p^.resulttype^.deftype=arraydef) or
            (p^.resulttype^.deftype=stringdef) or
            (p^.resulttype^.deftype=objectdef) or
            (p^.resulttype^.deftype=recorddef) or
            (
              (p^.resulttype^.deftype=setdef) and
              (psetdef(p^.resulttype)^.settype<>smallset)
            )) then
           begin
              emitpushreferenceaddr(funcretref);
              inc(pushedparasize,4);
           end;
         if (p^.right=nil) then
           begin
              { push self }
              if (p^.symtable^.symtabletype and $3fff)=objectsymtable then
                begin
                   if assigned(p^.methodpointer) then
                     begin
                        case p^.methodpointer^.treetype of
                           typen : begin
                                      { direct call to inherited method }
                                      if (p^.procdefinition^.options and poabstractmethod)<>0 then
                                        begin
                                           error(cant_call_abstract_method);
                                           goto dont_call;
                                        end;
                                      { generate no virtual call }
                                      no_virtual_call:=true;

                                      { this is a member call, so ESI isn't modfied }
                                      loadesi:=false;
                                      exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,R_ESI)));
                                      { if an inherited con- or destructor should be  }
                                      { called in a con- or destructor then a warning }
                                      { will be made                                  }
                                      if is_con_or_destructor and
                                        ((pobjectdef(p^.methodpointer^.resulttype)^.options and  oois_class)=0) and
                                        not(
                                        (((aktprocsym^.definition^.options and poconstructor)<>0) and
                                         ((p^.procdefinition^.options and poconstructor)<>0)) or
                                        (((aktprocsym^.definition^.options and podestructor)<>0) and
                                         ((p^.procdefinition^.options and podestructor)<>0))) then
                                        warning(member_cd_call_from_method);
                                      { con- and destructors need a pointer to the vmt }
                                      if is_con_or_destructor then
                                        begin
                                           { classes need the mem ! }
                                           if ((pobjectdef(p^.methodpointer^.resulttype)^.options and  oois_class)=0) then
                                             push_int(0)
                                           else
                                             exprasmlist^.concat(new(pai386,op_csymbol(A_PUSH,
                                               S_L,newcsymbol(pobjectdef(p^.methodpointer^.resulttype)^.vmt_mangledname,0))));
                                        end;
                                   end;
                           hnewn : begin
                                     { extended syntax of new }
                                     { ESI must be zero }
                                     exprasmlist^.concat(new(pai386,op_reg_reg(A_XOR,S_L,R_ESI,R_ESI)));
                                     exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,R_ESI)));
                                     { insert the vmt }
                                     exprasmlist^.concat(new(pai386,op_csymbol(A_PUSH,S_L,
                                       newcsymbol(pobjectdef(p^.methodpointer^.resulttype)^.vmt_mangledname,0))));
                                     extended_new:=true;
                                  end;
                           hdisposen : begin
                                          secondpass(p^.methodpointer);

                                          { destructor with extended syntax called from dispose }
                                          { hdisposen always deliver LOC_REFRENZ }
                                          exprasmlist^.concat(new(pai386,op_ref_reg(A_LEA,S_L,
                                            newreference(p^.methodpointer^.location.reference),R_ESI)));
                                          del_reference(p^.methodpointer^.location.reference);
                                          exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,R_ESI)));
                                          exprasmlist^.concat(new(pai386,op_csymbol(A_PUSH,S_L,
                                            newcsymbol(pobjectdef(p^.methodpointer^.resulttype)^.vmt_mangledname,0))));
                                       end;
                           else
                             begin
                                { call to a instance member }
                                secondpass(p^.methodpointer);

                                { load ESI for virtual methods }
                                case p^.methodpointer^.location.loc of
                                   LOC_REGISTER : begin
                                                     ungetregister32(p^.methodpointer^.location.register);
                                                     emit_reg_reg(A_MOV,S_L,p^.methodpointer^.location.register,R_ESI);
                                                  end;
                                   else begin
                                           exprasmlist^.concat(new(pai386,op_ref_reg(A_LEA,S_L,
                                             newreference(p^.methodpointer^.location.reference),R_ESI)));
                                           del_reference(p^.methodpointer^.location.reference);
                                        end;
                                end;
                                exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,R_ESI)));
                                if is_con_or_destructor then
                                  begin
                                     if ((p^.procdefinition^.options and poconstructor)<>0) then

                                       { it's no bad idea, to insert the VMT }
                                       exprasmlist^.concat(new(pai386,op_csymbol(A_PUSH,S_L,
                                         newcsymbol(pobjectdef(p^.methodpointer^.resulttype)^.vmt_mangledname,0))))

                                     { destructors haven't to dispose the instance, if this is }
                                     { a direct call                                           }
                                     else push_int(0);
                                  end;
                             end;
                        end;
                     end
                   else
                     begin
                        { member call, ESI isn't modified }
                        loadesi:=false;
                        exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,R_ESI)));
                        { but a con- or destructor here would probably almost }
                        { always be placed wrong }
                        if is_con_or_destructor then
                          begin
                             warning(member_cd_call_from_method);
                             { not insert VMT pointer }                             { VMT-Zeiger nicht eintragen }
                             push_int(0);
                          end;
                     end;
                end;

              { push base pointer ?}
              if (lexlevel>0) and assigned(pprocdef(p^.procdefinition)^.parast) and
                  ((p^.procdefinition^.parast^.symtabletype and $3fff)>1) then
                begin
                   { if we call a nested function in a method, we must }
                   { push also SELF!                                   }
                   if assigned(procinfo._class) then
                     begin
                        loadesi:=false;
                        exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,R_ESI)));
                     end;

                   if (lexlevel=(p^.procdefinition^.parast^.symtabletype and $3fff)) then
                     begin
                        new(r);
                        reset_reference(r^);
                        r^.offset:=procinfo.framepointer_offset;
                        r^.base:=procinfo.framepointer;
                        exprasmlist^.concat(new(pai386,op_ref(A_PUSH,S_L,r)))
                     end
                   else if lexlevel<(p^.procdefinition^.parast^.symtabletype and $3fff) then
                     exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,procinfo.framepointer)));
                end;

              { exported methods should be never called direct }
              if (p^.procdefinition^.options and poexports)<>0 then
                error(dont_call_exported_direct);

              if ((p^.procdefinition^.options and povirtualmethod)<>0) and
                 not(no_virtual_call) then
                begin
                   new(r);
                   reset_reference(r^);
                   r^.base:=R_ESI;
                   exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,r,R_EDI)));
                   new(r);
                   reset_reference(r^);
                   r^.base:=R_EDI;
                   r^.offset:=p^.procdefinition^.extnumber*4+12;
                   exprasmlist^.concat(new(pai386,op_ref(A_CALL,S_NO,r)));
                end
              else
                 exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol(p^.procdefinition^.mangledname,0))));
              if ((p^.procdefinition^.options and poclearstack)<>0) then
                begin
                   if pushedparasize=4 then
                     { better than an add on all processors }
                     exprasmlist^.concat(new(pai386,op_reg(A_POP,S_L,R_EDI)))
                   { the pentium has two pipes and pop reg is pairable }
                   { but the registers must be different!              }
                   else if (pushedparasize=8) and
                     not(cs_littlesize in aktswitches) and
                     (opt_processors=pentium) and
                     (procinfo._class=nil) then
                       begin
                          exprasmlist^.concat(new(pai386,op_reg(A_POP,S_L,R_EDI)));
                          exprasmlist^.concat(new(pai386,op_reg(A_POP,S_L,R_ESI)));
                       end
                   else exprasmlist^.concat(new(pai386,op_const_reg(A_ADD,S_L,pushedparasize,R_ESP)));
                end;
           end
         else
           begin
              secondpass(p^.right);
              case p^.right^.location.loc of
                 LOC_REGISTER,
                 LOC_CREGISTER : begin
                                   exprasmlist^.concat(new(pai386,op_reg(A_CALL,S_NO,p^.right^.location.register)));
                                   ungetregister32(p^.right^.location.register);
                                end
                 else
                    begin
                       exprasmlist^.concat(new(pai386,op_ref(A_CALL,S_NO,newreference(p^.right^.location.reference))));
                       del_reference(p^.right^.location.reference);
                    end;
              end;
           end;
      dont_call:
         pushedparasize:=oldpushedparasize;
         unused:=unusedregisters;

         { handle function results }
         if p^.resulttype<>pdef(voiddef) then
           begin

              { a contructor could be a function with boolean result }
              if (p^.right=nil) and
                 ((p^.procdefinition^.options and poconstructor)<>0) then
                begin
                   p^.location.loc:=LOC_FLAGS;
                   p^.location.resflags:=F_NE;
                   if extended_new then
                     begin
                        hregister:=getregister32;
                        emit_reg_reg(A_MOV,S_L,R_EAX,hregister);
                        p^.location.register:=hregister;
                     end;
                end
              { structed results are easy to handle.... }
              else if ((p^.resulttype^.deftype=arraydef) or
                  (p^.resulttype^.deftype=stringdef) or
                  (p^.resulttype^.deftype=objectdef) or
                  (p^.resulttype^.deftype=recorddef) or
                  (
                    (p^.resulttype^.deftype=setdef) and
                    (psetdef(p^.resulttype)^.settype<>smallset)
                  )) then
                begin
                   p^.location.loc:=LOC_MEM;
{$ifdef CleanUp}
                   stringdispose(p^.location.reference.symbol);
{$endif * CleanUp *}
                   p^.location.reference:=funcretref;
                end
              else
                begin
                   if (p^.resulttype^.deftype=orddef) then
                     begin
                        p^.location.loc:=LOC_REGISTER;
                        hregister:=getregister32;
                        case porddef(p^.resulttype)^.typ of
                           s32bit,u32bit : begin
                                       emit_reg_reg(A_MOV,S_L,R_EAX,hregister);
                                       p^.location.register:=hregister;
                                    end;
                           uchar,u8bit,bool8bit,s8bit : begin
                                       emit_reg_reg(A_MOV,S_B,R_AL,reg32toreg8(hregister));
                                       p^.location.register:=reg32toreg8(hregister);
                                    end;
                           s16bit,u16bit : begin
                                       emit_reg_reg(A_MOV,S_W,R_AX,reg32toreg16(hregister));
                                       p^.location.register:=reg32toreg16(hregister);
                                    end;
                           else internalerror(7);
                        end

                     end
                   else if (p^.resulttype^.deftype=floatdef) then
                      case pfloatdef(p^.resulttype)^.typ of
                           f32bit : begin
                                       p^.location.loc:=LOC_REGISTER;
                                      hregister:=getregister32;
                                     emit_reg_reg(A_MOV,S_L,R_EAX,hregister);
                                     p^.location.register:=hregister;
                                  end;
                           else
                              p^.location.loc:=LOC_FPUSTACK;
                      end
                   else
                     begin
                        p^.location.loc:=LOC_REGISTER;
                        hregister:=getregister32;
                        emit_reg_reg(A_MOV,S_L,R_EAX,hregister);
                        p^.location.register:=hregister;
                     end;
                end;
           end;

         { perhaps i/o check ? }
         if iolabel<>0 then
           begin
              exprasmlist^.concat(new(pai386,op_csymbol(A_PUSH,S_L,newcsymbol(lab2str(iolabel),0))));
              exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol('IOCHECK',0))));
           end;

         { restore registers }
         popusedregisters(pushed);

         { at last, restore instance pointer (SELF) }
         if loadesi then
           maybe_loadesi;
{$ifdef CleanUp}
         pp:=params;
         while assigned(pp) do
           begin
             if assigned(pp^.left) then
               if (pp^.left^.location.loc=LOC_REFERENCE) or
                 (pp^.left^.location.loc=LOC_MEM) then
                 ungetiftemp(pp^.left^.location.reference);
               pp:=pp^.right;
           end;
         disposetree(params);
{$endif * CleanUp *}
      end;

    procedure secondfuncret(var p : ptree);far;

      var
         hregister : tregister;

      begin
         clear_reference(p^.location.reference);
         p^.location.reference.base:=procinfo.framepointer;
         p^.location.reference.offset:=procinfo.retoffset;
         if (procinfo.retdef^.deftype=arraydef) or
            (procinfo.retdef^.deftype=stringdef) or
            (procinfo.retdef^.deftype=objectdef) or
            (procinfo.retdef^.deftype=recorddef) or
            (
             (procinfo.retdef^.deftype=setdef) and
             (psetdef(procinfo.retdef)^.settype<>smallset)
            ) then
           begin
              hregister:=getregister32;
              exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,newreference(p^.location.reference),hregister)));
              p^.location.reference.base:=hregister;
              p^.location.reference.offset:=0;
           end;
      end;

    { reverts the parameter list }
{$ifdef CleanUp}
    var nb_para : integer;
{$endif * CleanUp *}

    function reversparameter(p : ptree) : ptree;

      var
         hp1,hp2 : ptree;

      begin
         hp1:=nil;
{$ifdef CleanUp}
         nb_para := 0;
{$endif * CleanUp *}
         while assigned(p) do
           begin
              { pull out }
{$ifdef CleanUp}
              {p^.disposetyp := dt_leftright;}
{$endif * CleanUp *}
              hp2:=p;
              p:=p^.right;
{$ifndef CleanUp}

{$else * CleanUp *}
              inc(nb_para);
{$endif * CleanUp *}
              { pull in }
              hp2^.right:=hp1;
              hp1:=hp2;
           end;
         reversparameter:=hp1;
      end;

    procedure secondinline(var p : ptree);far;

      var
         aktfile : treference;
         ft : tfiletype;
         pushed : tpushed;
         dummycoll : tdefcoll;

      { produces code for READ(LN) and WRITE(LN) }

      procedure handlereadwrite(doread,callwriteln : boolean);

        procedure loadstream;

          var
             r : preference;

          begin
             if doread then
               begin
                  new(r);
                  reset_reference(r^);
                  r^.symbol:=stringdup('U_'+upper(target_info.system_unit)+'_INPUT');
                  exprasmlist^.concat(new(pai386,op_ref_reg(A_LEA,S_L,r,R_EDI)))
               end
             else
               begin
                  new(r);
                  reset_reference(r^);
                  r^.symbol:=stringdup('U_'+upper(target_info.system_unit)+'_OUTPUT');
                  exprasmlist^.concat(new(pai386,op_ref_reg(A_LEA,S_L,r,R_EDI)));
               end;
          end;

        var
           node,hp : ptree;
           typedtyp,pararesult : pdef;
           doflush : boolean;
           dummycoll : tdefcoll;
           iolabel : longint;
           npara : longint;

        begin
           { I/O check }
           if cs_iocheck in aktswitches then
             begin
                getlabel(iolabel);
                emitl(A_LABEL,iolabel);
             end
           else iolabel:=0;
           { no automatic call from flush }
           doflush:=false;
           hp:=nil;
           { reserve temporary pointer to data variable }
           aktfile.symbol:=nil;
           gettempofsizereference(4,aktfile);
           { first state text data }
           ft:=ft_text;
           { and state a parameter ? }
           if p^.left=nil then
             begin
                { state screen address}
                doflush:=true;
                { the following instructions are for "writeln;" }
                loadstream;
                { save @Dateivarible in temporary variable }
                exprasmlist^.concat(new(pai386,op_reg_ref(A_MOV,S_L,R_EDI,newreference(aktfile))));
             end
           else
             begin
                { revers paramters }
                node:=reversparameter(p^.left);
{$ifndef CleanUp}

{$else * CleanUp *}
                p^.left := node;
                npara := nb_para;
{$endif * CleanUp *}
                { calculate data variable }
                { is first parameter a file type ? }
                if node^.left^.resulttype^.deftype=filedef then
                  begin
                     ft:=pfiledef(node^.left^.resulttype)^.filetype;
                     if ft=ft_typed then
                       typedtyp:=pfiledef(node^.left^.resulttype)^.typed_as;

                     secondpass(node^.left);
                     if codegenerror then
                       exit;

                     { save reference in temporary variables }                     { reference in temporre Variable retten }
                     if node^.left^.location.loc<>LOC_REFERENCE then
                       begin
                          error(error_in_expression);
                          exit;
                       end;

                     exprasmlist^.concat(new(pai386,op_ref_reg(A_LEA,S_L,newreference(node^.left^.location.reference),R_EDI)));

                     { skip to the next parameter }
                     node:=node^.right;
                  end
                else
                  begin
                     { if we write to stdout/in then flush after the write(ln) }
                     doflush:=true;
                     loadstream;
                  end;

                { save @Dateivarible in temporary variable }
                exprasmlist^.concat(new(pai386,op_reg_ref(A_MOV,S_L,R_EDI,newreference(aktfile))));
                if doread then
                  { parameter by READ gives call by reference }
                  { Parameter an READ werden Call by reference bergeben }
                  dummycoll.paratyp:=vs_var
                  { an WRITE Call by "Const" }
                else dummycoll.paratyp:=vs_const;

                { because of secondcallparan, which otherwise attaches }
                if ft=ft_typed then
                  dummycoll.data:=typedtyp
                else
                dummycoll.data:=nil;

                while assigned(node) do
                  begin
                     pushusedregisters(pushed,$ff);
                     hp:=node;
                     node:=node^.right;
                     hp^.right:=nil;
                     if hp^.is_colon_para then
                       error(ill_colon_qualifier);
                     secondcallparan(hp,@dummycoll);
                     hp^.right:=node;
                     if codegenerror then
                       exit;

                     emit_push_mem(aktfile);
                     if (ft=ft_typed) then
                       begin
                          { OK let's try this }
                          { first we must only allow the right type }
                            { we have to call blockread or blockwrite }
                            { but the real problem is that            }
                            { reset and rewrite should have set       }
                            { the type size                           }
                            { as recordsize for that file !!!!        }
                            { how can we make that                    }
                            { I think that is only possible by adding }
                            { reset and rewrite to the inline list a call        }
                            { allways read only one record by element }
                            push_int(typedtyp^.size);
                            if doread then
                              exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,
                                newcsymbol('TYPED_READ',0))))
                            else
                              exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,
                                newcsymbol('TYPED_WRITE',0))));
                          {!!!!!!!}
                       end
                     else
                       begin
                          { save current position }
                          pararesult:=hp^.left^.resulttype;
                          { handle possible field width  }
                          { of course only for write(ln) }
                          if not doread then
                            begin
                               if assigned(node) and node^.is_colon_para then
                                 begin
                                    hp:=node;
                                    node:=node^.right;
                                    hp^.right:=nil;
                                    secondcallparan(hp,@dummycoll);
                                    hp^.right:=node;
                                    if codegenerror then
                                      exit;
                                 end
                               else
                                 push_int(0);
                              { a second colon para for a float ? }
                              if assigned(node) and node^.is_colon_para then
                                begin
                                    hp:=node;
                                    node:=node^.right;
                                    hp^.right:=nil;
                                    secondcallparan(hp,@dummycoll);
                                    hp^.right:=node;
                                    if pararesult^.deftype<>floatdef then
                                      error(ill_colon_qualifier);
                                    if codegenerror then
                                      exit;
                                end
                              else if hp^.left^.resulttype^.deftype=floatdef then
                                push_int(-1);
                            end;
                          case pararesult^.deftype of
                             stringdef : begin
                                            if doread then
                                              exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,
                                                newcsymbol('READ_TEXT_STRING',0))))
                                            else
                                              exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,
                                                newcsymbol('WRITE_TEXT_STRING',0))));
                                         end;
                             pointerdef : begin
                                             if (ppointerdef(pararesult)^.definition^.deftype=orddef)
                                               and (porddef(ppointerdef(pararesult)^.definition)^.typ=uchar) then
                                               begin
                                                  if doread then
                                                    exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,
                                                      newcsymbol('READ_TEXT_PCHAR_AS_POINTER',0))))
                                                  else
                                                    exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,
                                                      newcsymbol('WRITE_TEXT_PCHAR_AS_POINTER',0))));
                                               end
                                             else error(no_para_match);
                                          end;
                             arraydef : begin
                                           if (parraydef(pararesult)^.lowrange=0)
                                             and (parraydef(pararesult)^.definition^.deftype=orddef)
                                             and (porddef(parraydef(pararesult)^.definition)^.typ=uchar) then
                                             begin
                                                if doread then
                                                  exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,
                                                    newcsymbol('READ_TEXT_PCHAR_AS_ARRAY',0))))
                                                else
                                                  exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,
                                                    newcsymbol('WRITE_TEXT_PCHAR_AS_ARRAY',0))));
                                             end
                                           else error(no_para_match);
                                        end;
                             floatdef : case pfloatdef(pararesult)^.typ of
                                              s64real : if doread then
                                                         exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,
                                                           newcsymbol('READ_TEXT_REAL',0))))
                                                       else
                                                            exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,
                                                              newcsymbol('WRITE_TEXT_REAL',0))));
                                              else error(no_para_match);
                                        end;
                             orddef : begin
                                           case porddef(pararesult)^.typ of
                                              { !!!! read u32bit }
                                              u8bit : if doread then
                                                         exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,
                                                           newcsymbol('READ_TEXT_BYTE',0))));
                                              s8bit : if doread then
                                                         exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,
                                                           newcsymbol('READ_TEXT_SHORTINT',0))));
                                              u16bit : if doread then
                                                         exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,
                                                           newcsymbol('READ_TEXT_WORD',0))));
                                              s16bit : if doread then
                                                         exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,
                                                           newcsymbol('READ_TEXT_INTEGER',0))));
                                              s32bit : if doread then
                                                         exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,
                                                           newcsymbol('READ_TEXT_LONGINT',0))))
                                                       else
                                                         exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,
                                                           newcsymbol('WRITE_TEXT_LONGINT',0))));
                                              uchar : if doread then
                                                         exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,
                                                           newcsymbol('READ_TEXT_CHAR',0))))
                                                       else
                                                         exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,
                                                           newcsymbol('WRITE_TEXT_CHAR',0))));
                                              else error(no_para_match);
                                              end;
                                           end;
                             else error(no_para_match);
                          end;
                       end;
                     { load ESI in methods again }
                     popusedregisters(pushed);
                     maybe_loadesi;
                  end;
             end;
           if callwriteln then
             begin
                pushusedregisters(pushed,$ff);
                emit_push_mem(aktfile);
                { pushexceptlabel; }
                if ft<>ft_text then
                  error(no_para_match);
                exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol('WRITELN_TEXT',0))));
                popusedregisters(pushed);
                maybe_loadesi;
             end;
           if doflush and not(doread) then
             begin
               pushusedregisters(pushed,$ff);
               { pushexceptlabel; }
               exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol('FLUSH_STDOUT',0))));
               popusedregisters(pushed);
               maybe_loadesi;
             end;
           if iolabel<>0 then
             begin
                { registers are saved in the procedure }
                exprasmlist^.concat(new(pai386,op_csymbol(A_PUSH,S_L,newcsymbol(lab2str(iolabel),0))));
                exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol('IOCHECK',0))));
             end;
           ungetiftemp(aktfile);
{$ifdef CleanUp}
           if assigned(p^.left) then
             begin
                p^.left:=reversparameter(p^.left);
                if npara<>nb_para then
                  comment(v_error,'error in secondinline');
                hp:=p^.left;
                while assigned(hp) do
                  begin
                     if assigned(hp^.left) then
                       if (hp^.left^.location.loc=LOC_REFERENCE) or
                         (hp^.left^.location.loc=LOC_MEM) then
                         ungetiftemp(hp^.left^.location.reference);
                     hp:=hp^.right;
                  end;
            end;
{$endif * CleanUp *}
        end;

      procedure handle_str;

        var
           hp,node : ptree;
           dummycoll : tdefcoll;
           is_real : boolean;

        begin
           pushusedregisters(pushed,$ff);
           node:=p^.left;
           while assigned(node) do
             begin
                hp:=node;
                node:=node^.right;
                hp^.right:=nil;
                if hp^.left^.resulttype^.deftype=stringdef then
                  dummycoll.paratyp:=vs_var
                else
                  dummycoll.paratyp:=vs_const;

                { if a real parameter occurs somewhere then call REALSTR }
                if (hp^.left^.resulttype^.deftype=floatdef) then
                  is_real:=true;

                secondcallparan(hp,@dummycoll);
                if codegenerror then
                  exit;
             end;
           popusedregisters(pushed);
        end;

      var
         r : preference;

      begin
         case p^.inlinenumber of
            in_lo_word,
            in_hi_word : begin
                       secondpass(p^.left);
                       p^.location.loc:=LOC_REGISTER;
                       if p^.left^.location.loc<>LOC_REGISTER then
                         begin
                            if p^.left^.location.loc=LOC_CREGISTER then
                              begin
                                 p^.location.register:=reg32toreg16(getregister32);
                                 emit_reg_reg(A_MOV,S_W,p^.left^.location.register,
                                   p^.location.register);
                              end
                            else
                              begin
                                 del_reference(p^.left^.location.reference);
                                 p^.location.register:=reg32toreg16(getregister32);
                                 exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_W,newreference(p^.left^.location.reference),
                                   p^.location.register)));
                              end;
                         end
                       else p^.location.register:=p^.left^.location.register;
                       if p^.inlinenumber=in_hi_word then
                         exprasmlist^.concat(new(pai386,op_const_reg(A_SHR,S_W,8,p^.location.register)));
                       p^.location.register:=reg16toreg8(p^.location.register);
                    end;
            in_sizeof_x,
            in_typeof_x : begin
                             if p^.left^.treetype=typen then
                               begin
                                  internalerror(100);
                               end
                             else
                               begin
                                  secondpass(p^.left);
                                  del_reference(p^.left^.location.reference);
                                  p^.location.loc:=LOC_REGISTER;
                                  p^.location.register:=getregister32;
                                  { load VMT pointer }
                                  exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,
                                    newreference(p^.left^.location.reference),
                                    p^.location.register)));
                                  if p^.inlinenumber=in_sizeof_x then
                                    begin
                                       new(r);
                                       reset_reference(r^);
                                       r^.base:=p^.location.register;
                                       exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,r,
                                         p^.location.register)));
                                    end;
                               end;
                          end;
            in_lo_long,
            in_hi_long : begin
                       secondpass(p^.left);
                       p^.location.loc:=LOC_REGISTER;
                       if p^.left^.location.loc<>LOC_REGISTER then
                         begin
                            if p^.left^.location.loc=LOC_CREGISTER then
                              begin
                                 p^.location.register:=getregister32;
                                 emit_reg_reg(A_MOV,S_L,p^.left^.location.register,
                                   p^.location.register);
                              end
                            else
                              begin
                                 del_reference(p^.left^.location.reference);
                                 p^.location.register:=getregister32;
                                 exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,newreference(p^.left^.location.reference),
                                   p^.location.register)));
                              end;
                         end
                       else p^.location.register:=p^.left^.location.register;
                       if p^.inlinenumber=in_hi_long then
                         exprasmlist^.concat(new(pai386,op_const_reg(A_SHR,S_L,16,p^.location.register)));
                       p^.location.register:=reg32toreg16(p^.location.register);
                    end;
            in_ord_char,
            in_chr_byte,
            in_length_string : begin
                       secondpass(p^.left);
{$ifndef CleanUp}
                       p^.location:=p^.left^.location;
{$else * CleanUp *}
                       set_location(p^.location,p^.left^.location);
{$endif * CleanUp *}
                    end;
            in_inc_dword : begin
                              secondpass(p^.left);
                              exprasmlist^.concat(new(pai386,op_ref(A_INC,S_L,newreference(p^.left^.location.reference))));
                              emitoverflowcheck;
                           end;
            in_inc_word : begin
                              secondpass(p^.left);
                              exprasmlist^.concat(new(pai386,op_ref(A_INC,S_W,newreference(p^.left^.location.reference))));
                              emitoverflowcheck;
                           end;
            in_inc_byte : begin
                              secondpass(p^.left);
                              exprasmlist^.concat(new(pai386,op_ref(A_INC,S_B,newreference(p^.left^.location.reference))));
                              emitoverflowcheck;
                           end;
            in_dec_dword : begin
                              secondpass(p^.left);
                              exprasmlist^.concat(new(pai386,op_ref(A_DEC,S_L,newreference(p^.left^.location.reference))));
                              emitoverflowcheck;
                           end;
            in_dec_word : begin
                              secondpass(p^.left);
                              exprasmlist^.concat(new(pai386,op_ref(A_DEC,S_W,newreference(p^.left^.location.reference))));
                              emitoverflowcheck;
                           end;
            in_dec_byte : begin
                              secondpass(p^.left);
                              exprasmlist^.concat(new(pai386,op_ref(A_DEC,S_B,newreference(p^.left^.location.reference))));
                              emitoverflowcheck;
                           end;
            in_assigned_x : begin
                               secondpass(p^.left^.left);
                               p^.location.loc:=LOC_FLAGS;
                               if (p^.left^.left^.location.loc=LOC_REGISTER) or
                                  (p^.left^.left^.location.loc=LOC_CREGISTER) then
                                 begin
                                    exprasmlist^.concat(new(pai386,op_reg_reg(A_OR,S_L,
                                      p^.left^.left^.location.register,
                                      p^.left^.left^.location.register)));
                                    ungetregister32(p^.left^.left^.location.register);
                                 end
                               else
                                 begin
                                    exprasmlist^.concat(new(pai386,op_const_ref(A_CMP,S_L,0,
                                      newreference(p^.left^.left^.location.reference))));
                                    del_reference(p^.left^.left^.location.reference);
                                 end;
                               p^.location.resflags:=F_NE;
                            end;
            in_write_x : handlereadwrite(false,false);
            in_writeln_x : handlereadwrite(false,true);
            in_read_x : handlereadwrite(true,false);
            in_readln_x : begin
                              handlereadwrite(true,false);
                              pushusedregisters(pushed,$ff);
                              emit_push_mem(aktfile);
                              { pushexceptlabel; }
                              if ft<>ft_text then
                                error(no_para_match);
                              exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol('READLN_TEXT',0))));
                              popusedregisters(pushed);
                              maybe_loadesi;
                           end;
            in_str_x_string : begin
                                 handle_str;
                                 maybe_loadesi;
                              end;
            else internalerror(9);
         end;
      end;

    procedure secondsubscriptn(var p : ptree);far;

      begin
         secondpass(p^.left);

         if codegenerror then
           exit;

{$ifndef CleanUp}
         p^.location:=p^.left^.location;
{$else * CleanUp *}
         set_location(p^.location,p^.left^.location);
{$endif * CleanUp *}
         inc(p^.location.reference.offset,p^.vs^.adresse);
      end;

    procedure secondselfn(var p : ptree);far;

      begin
         clear_reference(p^.location.reference);
         p^.location.reference.base:=R_ESI;
      end;

    procedure secondhdisposen(var p : ptree);far;

      begin
         secondpass(p^.left);

         if codegenerror then
           exit;
         clear_reference(p^.location.reference);
         case p^.left^.location.loc of
            LOC_REGISTER,
            LOC_CREGISTER : begin
                               p^.location.reference.index:=getregister32;
                               exprasmlist^.concat(new(pai386,op_reg_reg(A_MOV,S_L,
                                 p^.left^.location.register,
                                 p^.location.reference.index)));
                            end;
            LOC_MEM,LOC_REFERENCE :
                            begin
                               del_reference(p^.left^.location.reference);
                               p^.location.reference.index:=getregister32;
                               exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,newreference(p^.left^.location.reference),
                                 p^.location.reference.index)));
                            end;
         end;
      end;

    procedure secondhnewn(var p : ptree);far;

      begin
      end;

    procedure secondnewn(var p : ptree);far;

      begin
         secondpass(p^.left);

         if codegenerror then
           exit;

         p^.location.register:=p^.left^.location.register;
      end;

    procedure secondsimplenewdispose(var p : ptree);far;

      begin
         secondpass(p^.left);
         if codegenerror then
           exit;

         { determines the size of the mem block }
         push_int(ppointerdef(p^.left^.resulttype)^.definition^.size);

         { push pointer adress }
         case p^.left^.location.loc of
            LOC_CREGISTER : exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,
              p^.left^.location.register)));
            LOC_REFERENCE : emitpushreferenceaddr(p^.left^.location.reference);
         end;

         { call the mem handling procedures }
         case p^.treetype of
            simpledisposen : exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol('FREEMEM',0))));
            simplenewn : exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol('GETMEM',0))));
         end;

         { may be load ESI }
         maybe_loadesi;
      end;

    { copies p a set element on the stack }

    procedure pushsetelement(var p : ptree);

      var
         hr : tregister;

      begin
         { copy the element on the stack, slightly complicated }
         case p^.location.loc of
            LOC_REGISTER,
            LOC_CREGISTER : begin
                              hr:=p^.location.register;
                              case hr of
                                 R_EAX,R_EBX,R_ECX,R_EDX,R_EDI,R_ESI,R_ESP :
                                   begin
                                      ungetregister32(hr);
                                      exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_W,reg32toreg16(hr))));
                                   end;
                                 R_AX,R_BX,R_CX,R_DX,R_DI,R_SI,R_SP :
                                   begin
                                      ungetregister32(reg16toreg32(hr));
                                      exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_W,hr)));
                                   end;
                                 R_AL,R_BL,R_CL,R_DL :
                                   begin
                                      ungetregister32(reg8toreg32(hr));
                                      exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_W,reg8toreg16(hr))));
                                   end;
                              end;
                           end;
            else
               begin
                  exprasmlist^.concat(new(pai386,op_ref(A_PUSH,S_W,newreference(p^.location.reference))));
                  del_reference(p^.location.reference);
               end;
         end;
      end;

    procedure secondsetcons(var p : ptree);far;

      var
         l,i : longint;
         hp : ptree;
         href,sref : treference;

      begin
         { produce constant part }
{$ifdef CleanUp}
         href.symbol := Nil;
{$endif * CleanUp *}
         clear_reference(href);
         getlabel(l);
         href.symbol:=stringdup(lab2str(l));
{$ifdef CleanUp}
         stringdispose(p^.location.reference.symbol);
{$endif * CleanUp *}
         datasegment^.concat(new(pai_label,init(l)));
         { big mistake here  !!!
         cs_support_goto was on the wrong place !!!}
         for i:=0 to 31 do
           datasegment^.concat(new(pai_const,init_8bit(p^.constset^[i])));
         hp:=p^.left;
         if assigned(hp) then
           begin
{$ifdef CleanUp}
              sref.symbol:=nil;
{$endif * CleanUp *}
              gettempofsizereference(32,sref);
              concatcopy(href,sref,32,false);
              while assigned(hp) do
                begin
                   secondpass(hp^.left);
                   if codegenerror then
                     exit;

                   pushsetelement(hp^.left);
                   emitpushreferenceaddr(sref);
                   { register is save in subroutine }
                   exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol('SET_SET_BYTE',0))));
                   hp:=hp^.right;
                end;
              p^.location.reference:=sref;
           end
         else p^.location.reference:=href;
      end;

    { could be built into secondadd but it }
    { should be easy to read }

    procedure secondin(var p : ptree);far;

      var
         pushed : boolean;
         swapp : ptree;
         hr : tregister;

      begin
         if psetdef(p^.right^.resulttype)^.settype=smallset then
           begin
              if p^.left^.treetype=ordconstn then
                begin
                   { only compulsory }
                   secondpass(p^.left);

                   secondpass(p^.right);
                   if codegenerror then
                     exit;
                   p^.location.resflags:=F_NE;

                   case p^.right^.location.loc of
                      LOC_REGISTER,LOC_CREGISTER : exprasmlist^.concat(new(pai386,op_const_reg(
                             A_TEST,S_L,1 shl (p^.left^.value mod 32),
                             p^.right^.location.register)));
                      else exprasmlist^.concat(new(pai386,op_const_ref(A_TEST,S_L,1 shl (p^.left^.value mod 32),
                        newreference(p^.right^.location.reference))));
                   end;
                   del_reference(p^.right^.location.reference);
                end
              else
                begin
                   { calculate both operators }
                   { the complex one first }
                   firstcomplex(p);
                   secondpass(p^.left);

                   { are too few registers free? }
                   pushed:=maybe_push(p^.right^.registers32,p^.left);
                   secondpass(p^.right);
                   if pushed then
                     restore(p^.left);

                   { of course not commutative }
                   if p^.swaped then
                     begin
                        swapp:=p^.left;
                        p^.left:=p^.right;
                        p^.right:=swapp;
                        p^.swaped:=not(p^.swaped);
                     end;
                   case p^.left^.location.loc of
                      LOC_REGISTER,
                      LOC_CREGISTER : begin
                                        hr:=p^.left^.location.register;
                                        case p^.left^.location.register of
                                           R_AX,R_BX,R_CX,R_DX,R_DI,R_SI,R_SP :
                                             begin
                                                hr:=reg16toreg32(p^.left^.location.register);
                                                ungetregister32(hr);
                                                exprasmlist^.concat(new(pai386,op_reg_reg(A_MOVZX,S_WL,
                                                  p^.left^.location.register,hr)));
                                             end;
                                           R_AL,R_BL,R_CL,R_DL :
                                             begin
                                                hr:=reg8toreg32(p^.left^.location.register);
                                                ungetregister32(hr);
                                                exprasmlist^.concat(new(pai386,op_reg_reg(A_MOVZX,S_BL,
                                                  p^.left^.location.register,hr)));
                                             end;
                                        end;
                                     end;
                      else
                         begin
                            { the set element isn't never samller than a byte  }
                            { and because it's a small set we need only 5 bits }
                            { but 8 bits are eaiser to load                    }
                            exprasmlist^.concat(new(pai386,op_ref_reg(A_MOVZX,S_BL,
                              newreference(p^.left^.location.reference),R_EDI)));

                            hr:=R_EDI;
                            del_reference(p^.left^.location.reference);
                         end;
                   end;
                   case p^.right^.location.loc of
                      LOC_REGISTER,
                      LOC_CREGISTER : exprasmlist^.concat(new(pai386,op_reg_reg(A_BT,S_L,hr,p^.right^.location.register)));
                      else
                         begin
                            exprasmlist^.concat(new(pai386,op_reg_ref(A_BT,S_L,hr,
                              newreference(p^.right^.location.reference))));

                            del_reference(p^.right^.location.reference);
                         end;
                   end;
                   p^.location.loc:=LOC_FLAGS;
                   p^.location.resflags:=F_C;
                end;
           end
         else
           begin
              if p^.left^.treetype=ordconstn then
                begin
                   { only compulsory }
                   secondpass(p^.left);

                   secondpass(p^.right);
                   if codegenerror then
                     exit;
                   p^.location.resflags:=F_NE;
                   inc(p^.right^.location.reference.offset,p^.left^.value div 8);
                   exprasmlist^.concat(new(pai386,op_const_ref(A_TEST,S_B,1 shl (p^.left^.value mod 8),
                     newreference(p^.right^.location.reference))));
                   del_reference(p^.right^.location.reference);
                end
              else
                begin
                   { calculate both operators }
                   { the complex one first }
                   firstcomplex(p);
                   secondpass(p^.left);
{$ifndef CleanUp}
                   p^.location:=p^.left^.location;
{$else * CleanUp *}
                   set_location(p^.location,p^.left^.location);
{$endif * CleanUp *}
                   { are too few registers free? }
                   pushed:=maybe_push(p^.right^.registers32,p);
                   secondpass(p^.right);
                   if pushed then restore(p);
                   { of course not commutative }
                   if p^.swaped then
                     begin
                        swapp:=p^.left;
                        p^.left:=p^.right;
                        p^.right:=swapp;
                        p^.swaped:=not(p^.swaped);
                     end;
                   pushsetelement(p^.left);
                   emitpushreferenceaddr(p^.right^.location.reference);
                   del_reference(p^.right^.location.reference);
                   { registers need not be save. that happens in SET_IN_BYTE }
                   { (EDI is changed) }
                   exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol('SET_IN_BYTE',0))));
                   p^.location.loc:=LOC_FLAGS;
                   p^.location.resflags:=F_C;
                end;
             end;
      end;

    procedure secondexpr(var p : ptree);far;

      begin
         secondpass(p^.left);
      end;

    procedure secondblockn(var p : ptree);far;

      var
         hp : ptree;

      begin
         hp:=p^.left;
         while assigned(hp) do
           begin
              { assignments could be distance optimized }
              if assigned(hp^.right) then
                begin
                   cleartempgen;
                   secondpass(hp^.right);
                end;

              hp:=hp^.left;
           end;
      end;

    procedure second_while_repeatn(var p : ptree);far;

      var
         l1,l2,l3,oldclabel,oldblabel : longint;

      begin
         getlabel(l1);
         getlabel(l2);
         { arrange continue and breaklabels: }
         oldclabel:=aktcontinuelabel;
         oldblabel:=aktbreaklabel;
         if p^.treetype=repeatn then
           begin
              aktcontinuelabel:=l1;
              aktbreaklabel:=l2;

              emitl(A_LABEL,l1);
              cleartempgen;
              if assigned(p^.right) then
                secondpass(p^.right);

              truelabel:=l2;
              falselabel:=l1;
              cleartempgen;
              secondpass(p^.left);
              maketojumpbool(p^.left);

              emitl(A_LABEL,l2);
           end
         else
           begin
              getlabel(l3);
              aktcontinuelabel:=l1;
              aktbreaklabel:=l3;
              { handling code at the end as it is much more efficient }
              emitl(A_JMP,l2);

              emitl(A_LABEL,l1);
              cleartempgen;

              if assigned(p^.right) then
                secondpass(p^.right);

              emitl(A_LABEL,l2);
              truelabel:=l1;
              falselabel:=l3;
              cleartempgen;
              secondpass(p^.left);
              maketojumpbool(p^.left);

              emitl(A_LABEL,l3);
           end;
         aktcontinuelabel:=oldclabel;
         aktbreaklabel:=oldblabel;
      end;

    procedure secondifn(var p : ptree);far;

      var
         l1,l2,hl : longint;

      begin
         getlabel(l1);
         getlabel(l2);
         truelabel:=l1;
         falselabel:=l2;
         cleartempgen;
         secondpass(p^.left);
         maketojumpbool(p^.left);
         if assigned(p^.right) then
           begin
              emitl(A_LABEL,l1);
              cleartempgen;
              secondpass(p^.right);
           end;
         if assigned(p^.t1) then
           begin
              if assigned(p^.right) then
                begin
                   getlabel(hl);
                   emitl(A_JMP,hl);
                end;
              emitl(A_LABEL,l2);
              cleartempgen;
              secondpass(p^.t1);
              if assigned(p^.right) then
                emitl(A_LABEL,hl);
           end
         else
           emitl(A_LABEL,l2);
         if not(assigned(p^.right)) then
           emitl(A_LABEL,l1);
      end;

    procedure secondbreakn(var p : ptree);far;

      begin
         if aktbreaklabel<>0 then
           emitl(A_JMP,aktbreaklabel)
         else
           error(break_not_allowed);
      end;

    procedure secondcontinuen(var p : ptree);far;

      begin
         if aktcontinuelabel<>0 then
           emitl(A_JMP,aktcontinuelabel)
         else
           error(continue_not_allowed);
      end;

    procedure secondfor(var p : ptree);far;

      var
         l1,l2,l3,oldclabel,oldblabel : longint;
         omitfirstcomp,temptovalue : boolean;
         hs : byte;
         temp1 : treference;
         hop : tasmop;
         cmpreg,cmp32 : tregister;
         opsize : topsize;
         count_var_is_signed : boolean;

      begin
         oldclabel:=aktcontinuelabel;
         oldblabel:=aktbreaklabel;
         getlabel(l1);
         getlabel(l2);
         getlabel(l3);
         aktbreaklabel:=l2;
         aktcontinuelabel:=l1;

         { could we spare the first comparison ? }
         omitfirstcomp:=false;
         if p^.right^.treetype=ordconstn then
           if p^.left^.right^.treetype=ordconstn then
             omitfirstcomp:=(p^.backward and (p^.left^.right^.value>=p^.right^.value))
               or (not(p^.backward) and (p^.left^.right^.value<=p^.right^.value));

         { only calculate reference }
         cleartempgen;
         secondpass(p^.t2);
         if not(simple_loadn) then
           error(invalid_for_var);

         { produce start assignment }
         cleartempgen;
         secondpass(p^.left);
         count_var_is_signed:=is_signed(porddef(p^.t2^.resulttype));
         hs:=p^.t2^.resulttype^.size;
         cmp32:=getregister32;
         case hs of
            1 : begin
                   opsize:=S_B;
                   cmpreg:=reg32toreg8(cmp32);
                end;
            2 : begin
                   opsize:=S_W;
                   cmpreg:=reg32toreg16(cmp32);
                end;
            4 : begin
                   opsize:=S_L;
                   cmpreg:=cmp32;
                end;
         end;
         cleartempgen;
         secondpass(p^.right);
         { calculate pointer value and check if changeable and if so }
         { load into temporary variable                              }
         if p^.right^.treetype<>ordconstn then
           begin
{$ifdef CleanUp}
              temp1.symbol:=nil;
{$endif * CleanUp *}
              gettempofsizereference(hs,temp1);
              temptovalue:=true;
              if (p^.right^.location.loc=LOC_REGISTER) or
                 (p^.right^.location.loc=LOC_CREGISTER) then
                begin
                   exprasmlist^.concat(new(pai386,op_reg_ref(A_MOV,opsize,p^.right^.location.register,
                      newreference(temp1))));
                 end
              else
                 concatcopy(p^.right^.location.reference,temp1,hs,false);
           end
         else temptovalue:=false;

         if temptovalue then
           begin
              if p^.t2^.location.loc=LOC_CREGISTER then
                begin
                   exprasmlist^.concat(new(pai386,op_ref_reg(A_CMP,opsize,newreference(temp1),
                     p^.t2^.location.register)));
                end
              else
                begin
                   exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,opsize,newreference(p^.t2^.location.reference),
                     cmpreg)));
                   exprasmlist^.concat(new(pai386,op_ref_reg(A_CMP,opsize,newreference(temp1),
                     cmpreg)));
                end;
           end
         else
           begin
              if not(omitfirstcomp) then
                begin
                   if p^.t2^.location.loc=LOC_CREGISTER then
                     exprasmlist^.concat(new(pai386,op_const_reg(A_CMP,opsize,p^.right^.value,
                       p^.t2^.location.register)))
                   else
                     exprasmlist^.concat(new(pai386,op_const_ref(A_CMP,opsize,p^.right^.value,
                       newreference(p^.t2^.location.reference))));
                end;
           end;
         if p^.backward then
           if count_var_is_signed then
             hop:=A_JL
           else hop:=A_JB
         else
           if count_var_is_signed then
             hop:=A_JG
            else hop:=A_JA;

         if not(omitfirstcomp) or temptovalue then
          emitl(hop,aktbreaklabel);

         emitl(A_LABEL,l3);

         { help register must not be in instruction block }
         cleartempgen;
         if assigned(p^.t1) then
           secondpass(p^.t1);

         emitl(A_LABEL,aktcontinuelabel);

         { makes no problems there }
         cleartempgen;

         { demand help register again }
         cmp32:=getregister32;
         case hs of
            1 : begin
                   opsize:=S_B;
                   cmpreg:=reg32toreg8(cmp32);
                end;
            2 : begin
                   opsize:=S_W;
                   cmpreg:=reg32toreg16(cmp32);
                end;
            4 : opsize:=S_L;
         end;

         { according to count direction DEC or INC... }
         if p^.backward then
           hop:=A_DEC
         else hop:=A_INC;

         if p^.t2^.location.loc=LOC_CREGISTER then
           exprasmlist^.concat(new(pai386,op_reg(hop,opsize,p^.t2^.location.register)))
         else
           exprasmlist^.concat(new(pai386,op_ref(hop,opsize,newreference(p^.t2^.location.reference))));

         { produce comparison and the corresponding }
         { jump                                     }
         if temptovalue then
           begin
              if p^.t2^.location.loc=LOC_CREGISTER then
                begin
                   exprasmlist^.concat(new(pai386,op_ref_reg(A_CMP,opsize,newreference(temp1),
                     p^.t2^.location.register)));
                end
              else
                begin
                   exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,opsize,newreference(p^.t2^.location.reference),
                     cmpreg)));
                   exprasmlist^.concat(new(pai386,op_ref_reg(A_CMP,opsize,newreference(temp1),
                     cmpreg)));
                end;
           end
         else
           begin
              if p^.t2^.location.loc=LOC_CREGISTER then
                exprasmlist^.concat(new(pai386,op_const_reg(A_CMP,opsize,p^.right^.value,
                  p^.t2^.location.register)))
              else
                exprasmlist^.concat(new(pai386,op_const_ref(A_CMP,opsize,p^.right^.value,
                  newreference(p^.t2^.location.reference))));
           end;
         if p^.backward then
           if count_var_is_signed then
             hop:=A_JGE
           else
             hop :=A_JAE
          else
            if count_var_is_signed then
              hop:=A_JLE
            else
              hop:=A_JBE;
         emitl(hop,l3);
         { this is the break label: }
         emitl(A_LABEL,aktbreaklabel);
         ungetregister32(cmp32);

         if temptovalue then
           ungetiftemp(temp1);

         aktcontinuelabel:=oldclabel;
         aktbreaklabel:=oldblabel;
      end;

    var
       hs : string;

    procedure secondexitn(var p : ptree);far;

      var
         is_mem : boolean;
         op : tasmop;
         s : topsize;

      label
         do_jmp;

      begin
         if assigned(p^.left) then
           begin
              getlabel(truelabel);
              getlabel(falselabel);
              secondpass(p^.left);
              case p^.left^.location.loc of
                 LOC_FPUSTACK : goto do_jmp;
                 LOC_MEM,LOC_REFERENCE : is_mem:=true;
                 LOC_CREGISTER,
                 LOC_REGISTER : is_mem:=false;
                 LOC_FLAGS : begin
                                exprasmlist^.concat(new(pai386,op_reg(flag_2_set[p^.right^.location.resflags],S_NO,R_AL)));
                                goto do_jmp;
                             end;
                 LOC_JUMP : begin
                               emitl(A_LABEL,truelabel);
                               exprasmlist^.concat(new(pai386,op_const_reg(A_MOV,S_B,1,R_AL)));
                               emitl(A_JMP,aktexit2label);
                               exprasmlist^.concat(new(pai386,op_reg_reg(A_XOR,S_B,R_AL,R_AL)));
                               goto do_jmp;
                            end;
                 else internalerror(2001);
              end;
              if (procinfo.retdef^.deftype=orddef) then
                begin
                   case porddef(procinfo.retdef)^.typ of
                      s32bit,u32bit : if is_mem then
                                        exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,
                                          newreference(p^.left^.location.reference),R_EAX)))
                                      else
                                        emit_reg_reg(A_MOV,S_L,
                                          p^.left^.location.register,R_EAX);
                      u8bit,s8bit,uchar,bool8bit : if is_mem then
                                        exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_B,
                                          newreference(p^.left^.location.reference),R_AL)))
                                      else
                                        emit_reg_reg(A_MOV,S_B,
                                          p^.left^.location.register,R_AL);
                      s16bit,u16bit : if is_mem then
                                        exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_W,
                                          newreference(p^.left^.location.reference),R_AX)))
                                      else
                                        emit_reg_reg(A_MOV,S_W,
                                          p^.left^.location.register,R_AX);
                   end;
                end
               else
                 if (procinfo.retdef^.deftype=pointerdef) or
                    (procinfo.retdef^.deftype=aufzaehldef) or
                    (procinfo.retdef^.deftype=procvardef) then
                   begin
                      if is_mem then
                        exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,
                          newreference(p^.left^.location.reference),R_EAX)))
                      else
                        exprasmlist^.concat(new(pai386,op_reg_reg(A_MOV,S_L,
                          p^.left^.location.register,R_EAX)));
                   end
              else
                if (procinfo.retdef^.deftype=floatdef) then
                  begin
                     if pfloatdef(procinfo.retdef)^.typ=f32bit then
                       begin
                          if is_mem then
                            exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,S_L,
                              newreference(p^.left^.location.reference),R_EAX)))
                          else
                            emit_reg_reg(A_MOV,S_L,
                              p^.left^.location.register,R_EAX);
                       end
                     else
                       if is_mem then
                         floatload(pfloatdef(procinfo.retdef)^.typ,p^.left^.location.reference);
                end;
do_jmp:
              emitl(A_JMP,aktexit2label);
           end
         else
           begin
              emitl(A_JMP,aktexitlabel);
           end;
      end;

    procedure secondgoto(var p : ptree);far;

      begin
         emitl(A_JMP,p^.labelnr);
      end;

    procedure secondlabel(var p : ptree);far;

      begin
         emitl(A_LABEL,p^.labelnr);
         cleartempgen;
         secondpass(p^.left);
      end;

    procedure secondasm(var p : ptree);far;

      begin
         exprasmlist^.concatlist(p^.p_asm);
      end;

    procedure secondcase(var p : ptree);far;

      var
         with_sign : boolean;
         opsize : topsize;
         jmp_gt,jmp_le,jmp_lee : tasmop;
         hp : ptree;
         { register with case expression }
         hregister : tregister;
         endlabel,elselabel : longint;

         { true, if we can omit the range check of the jump table }
         jumptable_no_range : boolean;

      procedure gentreejmp(p : pcaserecord);

        var
           lesslabel,greaterlabel : longint;

        begin
           emitl(A_LABEL,p^._at);

           { calculate labels for left and right }
           if (p^.less=nil) then
             lesslabel:=elselabel
           else
             lesslabel:=p^.less^._at;
           if (p^.greater=nil) then
             greaterlabel:=elselabel
           else
             greaterlabel:=p^.greater^._at;

           { no range label: }
           if p^._low=p^._high then
             begin
                exprasmlist^.concat(new(pai386,op_const_reg(A_CMP,opsize,p^._low,hregister)));
                if greaterlabel=lesslabel then
                  begin
                     emitl(A_JNE,lesslabel);
                  end
                else
                  begin
                     emitl(jmp_le,lesslabel);
                     emitl(jmp_gt,greaterlabel);
                  end;
                emitl(A_JMP,p^.statement);
             end
           else
           { range label }
             begin
                exprasmlist^.concat(new(pai386,op_const_reg(A_CMP,opsize,p^._low,hregister)));
                emitl(jmp_le,lesslabel);
                exprasmlist^.concat(new(pai386,op_const_reg(A_CMP,opsize,p^._high,hregister)));
                emitl(jmp_gt,greaterlabel);
                emitl(A_JMP,p^.statement);
             end;
           if assigned(p^.less) then
             gentreejmp(p^.less);
           if assigned(p^.greater) then
             gentreejmp(p^.greater);
        end;

      procedure genlinearlist(hp : pcaserecord);

        var
           first : boolean;
           last : longint;
           helplabel : longint;

        procedure genitem(t : pcaserecord);

          begin
             if assigned(t^.less) then
               genitem(t^.less);
             if t^._low=t^._high then
               begin
                  if t^._low-last=1 then
                    exprasmlist^.concat(new(pai386,op_reg(A_DEC,opsize,hregister)))
                  else if t^._low-last=0 then
                    exprasmlist^.concat(new(pai386,op_reg_reg(A_OR,opsize,hregister,hregister)))
                  else
                    exprasmlist^.concat(new(pai386,op_const_reg(A_SUB,opsize,t^._low-last,hregister)));
                  last:=t^._low;

                  emitl(A_JZ,t^.statement);
               end
             else
               begin
                  { it begins with the smallest label, if the value }
                  { is even smaller then jump immediately to the    }
                  { ELSE-label                                      }
                  if first then
                    begin
                       if t^._low-1=1 then
                         exprasmlist^.concat(new(pai386,op_reg(A_DEC,opsize,hregister)))
                       else if t^._low-1=0 then
                         exprasmlist^.concat(new(pai386,op_reg_reg(A_OR,opsize,hregister,hregister)))
                       else
                         exprasmlist^.concat(new(pai386,op_const_reg(A_SUB,opsize,t^._low-1,hregister)));
                       emitl(jmp_lee,elselabel);
                    end
                  { if there is no unused label between the last and the }
                  { present label then the lower limit can be checked    }
                  { immediately. else check the range in between:        }
                  else if (t^._low-last>1)then

                    begin
                       if t^._low-last-1=1 then
                         exprasmlist^.concat(new(pai386,op_reg(A_DEC,opsize,hregister)))
                       else
                         exprasmlist^.concat(new(pai386,op_const_reg(A_SUB,opsize,t^._low-last-1,hregister)));
                       emitl(jmp_lee,elselabel);
                    end;
                  exprasmlist^.concat(new(pai386,op_const_reg(A_SUB,opsize,t^._high-t^._low+1,hregister)));
                  emitl(jmp_lee,t^.statement);

                  last:=t^._high;
               end;
             first:=false;
             if assigned(t^.greater) then
               genitem(t^.greater);
          end;

        var
           hr : tregister;

        begin
           { case register is modified by the list evalution }
           if (p^.left^.location.loc=LOC_CREGISTER) then
             begin
                hr:=getregister32;
                case opsize of
                   S_B : hregister:=reg32toreg8(hr);
                   S_W : hregister:=reg32toreg16(hr);
                   S_L : hregister:=hr;
                end;
             end;
           last:=0;
           first:=true;
           genitem(hp);
           emitl(A_JMP,elselabel);
        end;

      procedure genjumptable(hp : pcaserecord;min_,max_ : longint);

        var
           table,last : longint;
           hr : preference;

        procedure genitem(t : pcaserecord);

          var
             i : longint;

          begin
             if assigned(t^.less) then
               genitem(t^.less);
             { fill possible hole }
             for i:=last+1 to t^._low-1 do
               datasegment^.concat(new(pai_const,init_symbol(strpnew(lab2str
                 (elselabel)))));
             for i:=t^._low to t^._high do
               datasegment^.concat(new(pai_const,init_symbol(strpnew(lab2str
                (t^.statement)))));
              last:=t^._high;
             if assigned(t^.greater) then
               genitem(t^.greater);
          end;

        begin
           if not(jumptable_no_range) then
             begin
                exprasmlist^.concat(new(pai386,op_const_reg(A_CMP,opsize,min_,hregister)));
                { case expr less than min_ => goto elselabel }
                emitl(jmp_le,elselabel);
                exprasmlist^.concat(new(pai386,op_const_reg(A_CMP,opsize,max_,hregister)));
                emitl(jmp_gt,elselabel);
             end;
           getlabel(table);
           { extend with sign }
           if opsize=S_W then
             begin
                exprasmlist^.concat(new(pai386,op_reg_reg(A_MOVZX,S_WL,hregister,
                  reg16toreg32(hregister))));
                hregister:=reg16toreg32(hregister);
             end
           else if opsize=S_B then
             begin
                exprasmlist^.concat(new(pai386,op_reg_reg(A_MOVZX,S_BL,hregister,
                  reg8toreg32(hregister))));
                hregister:=reg8toreg32(hregister);
             end;
           new(hr);
           reset_reference(hr^);
           hr^.symbol:=stringdup(lab2str(table));
           hr^.offset:=(-min_)*4;
           hr^.index:=hregister;
           hr^.scalefactor:=4;
           exprasmlist^.concat(new(pai386,op_ref(A_JMP,S_NO,hr)));
           { !!!!! generate tables
           if not(cs_littlesize in aktswitches ) then
             datasegment^.concat(new(pai386,op_const(A_ALIGN,S_NO,4)));
           }
           datasegment^.concat(new(pai_label,init(table)));
           last:=min_;
           genitem(hp);
           { !!!!!!!
           if not(cs_littlesize in aktswitches ) then
             exprasmlist^.concat(new(pai386,op_const(A_ALIGN,S_NO,4)));
           }
        end;

      var
         lv,hv,min_label,max_label,labels,max_linear_list : longint;

      begin
         getlabel(endlabel);
         getlabel(elselabel);
         with_sign:=is_signed(p^.left^.resulttype);
         if with_sign then
           begin
              jmp_gt:=A_JG;
              jmp_le:=A_JL;
              jmp_lee:=A_JLE;
           end
         else
           begin
              jmp_gt:=A_JA;
              jmp_le:=A_JB;
              jmp_lee:=A_JBE;
           end;
         cleartempgen;
         secondpass(p^.left);

         { determines the size of the operand }
         case p^.left^.resulttype^.size of
            1 : opsize:=S_B;
            2 : opsize:=S_W;
            4 : opsize:=S_L;
            else internalerror(2003);
         end;

         { copy the case expression to a register }
         case p^.left^.location.loc of
           LOC_REGISTER,
           LOC_CREGISTER : hregister:=p^.left^.location.register;
           LOC_MEM,LOC_REFERENCE : begin
                                     del_reference(p^.left^.location.reference);
                                     hregister:=getregister32;
                                     case opsize of
                                        S_B : hregister:=reg32toreg8(hregister);
                                        S_W : hregister:=reg32toreg16(hregister);
                                     end;
                                     exprasmlist^.concat(new(pai386,op_ref_reg(A_MOV,opsize,newreference(
                                       p^.left^.location.reference),hregister)));
                                  end;
           else internalerror(2002);
         end;
         { now generate the jumps }
         if cs_optimize in aktswitches  then
           begin
              { procedures are empirically passed on }
              { consumption can also be calculated   }
              { but does it pay on the different     }
              { processors?                          }
              { moreover can the size only be appro- }
              { ximated as it is not known if rel8,  }
              { rel16 or rel32 jumps are used        }
              min_label:=case_get_min(p^.nodes);
              max_label:=case_get_max(p^.nodes);
              labels:=case_count_labels(p^.nodes);
              { can we omit the range check of the jump table }
              getrange(p^.left^.resulttype,lv,hv);
              jumptable_no_range:=(lv=min_label) and (hv=max_label);

              { optimize for size ? }
              if cs_littlesize in aktswitches  then
                begin
                   if (labels<=2) or ((max_label-min_label)>3*labels) then

                   { a linear list is always smaller than a jump tree }
                     genlinearlist(p^.nodes)
                   else
                     { if the labels less or more a continuum then }
                     { generate a jump table                       }
                     genjumptable(p^.nodes,min_label,max_label);
                end
              else
                begin
                   if jumptable_no_range then
                     max_linear_list:=4
                   else
                     max_linear_list:=2;
                   { a jump table crashes the pipeline! }
                   if opt_processors=i486 then
                     inc(max_linear_list,3);
                   if opt_processors=pentium then
                     inc(max_linear_list,6);
                   if opt_processors=pentiumpro then
                     inc(max_linear_list,9);

                   if (labels<=max_linear_list) then
                     genlinearlist(p^.nodes)
                   else
                     begin
                        if ((max_label-min_label)>4*labels) then
                          begin
                             if labels>16 then
                               gentreejmp(p^.nodes)
                             else
                               genlinearlist(p^.nodes);
                          end
                        else
                          genjumptable(p^.nodes,min_label,max_label);
                     end;
                end;
           end
         else
           { it's always not bad }
           genlinearlist(p^.nodes);

         { now generate the instructions }
         hp:=p^.right;
         while assigned(hp) do
           begin
              cleartempgen;
              secondpass(hp^.right);
              emitl(A_JMP,endlabel);
              hp:=hp^.left;
           end;
         emitl(A_LABEL,elselabel);
         { ... and the else block }
         if assigned(p^.elseblock) then
           begin
              cleartempgen;
              secondpass(p^.elseblock);
           end;
         emitl(A_LABEL,endlabel);
      end;

    { generates the code for a raise statement }
    procedure secondraise(var p : ptree);far;

      var
         a : tlabel;

      begin
         if assigned(p^.left) then
           begin
              { generate the address }
              if assigned(p^.right) then
                begin
                   secondpass(p^.right);
                   if codegenerror then
                     exit;
                end
              else
                begin
                   getlabel(a);
                   emitl(A_LABEL,a);
                   exprasmlist^.concat(new(pai386,
                     op_csymbol(A_PUSH,S_L,newcsymbol(lab2str(a),0))));
                end;
              secondpass(p^.left);
              if codegenerror then
                exit;

              case p^.left^.location.loc of
                 LOC_MEM,LOC_REFERENCE : emitpushreferenceaddr(p^.left^.location.reference);
                 LOC_CREGISTER,LOC_REGISTER : exprasmlist^.concat(new(pai386,op_reg(A_PUSH,S_L,
                   p^.left^.location.register)));
                 else error(type_mismatch);
              end;
              exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol('DO_RAISE',0))));
           end
         else
           begin
              exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol('DO_RERAISE',0))));
           end;
      end;

    procedure secondtryexcept(var p : ptree);far;

      begin
      end;

    procedure secondtryfinally(var p : ptree);far;

      begin
      end;

    procedure secondas(var p : ptree);far;

      var
         pushed : tpushed;

      begin
         secondpass(p^.left);
{$ifndef CleanUp}
         p^.location:=p^.left^.location;
{$else CleanUp}
         set_location(p^.location,p^.left^.location);
{$endif CleanUp }
         { save all used registers }
         pushusedregisters(pushed,$ff);
         { push the vmt of the class }
         exprasmlist^.concat(new(pai386,op_csymbol(A_PUSH,
           S_L,newcsymbol(pobjectdef(p^.right^.resulttype)^.vmt_mangledname,0))));
         emitpushreferenceaddr(p^.location.reference);
         exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol('DO_AS',0))));
         popusedregisters(pushed);
      end;

    procedure secondis(var p : ptree);far;

      var
         pushed : tpushed;

      begin
         secondpass(p^.left);
         p^.location.loc:=LOC_FLAGS;
         p^.location.resflags:=F_NE;
         del_reference(p^.left^.location.reference);
         { save all used registers }
         pushusedregisters(pushed,$ff);
         { push the vmt of the class }
         exprasmlist^.concat(new(pai386,op_csymbol(A_PUSH,
           S_L,newcsymbol(pobjectdef(p^.right^.resulttype)^.vmt_mangledname,0))));
         emitpushreferenceaddr(p^.left^.location.reference);
         exprasmlist^.concat(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol('DO_IS',0))));
         exprasmlist^.concat(new(pai386,op_reg_reg(A_OR,S_B,R_AL,R_AL)));
         popusedregisters(pushed);
      end;

    procedure secondwith(var p : ptree);far;

       var
          ref : treference;

       begin
          if assigned(p^.left) then
           begin
              secondpass(p^.left);

              ref.symbol:=nil;

              gettempofsizereference(4,ref);

              exprasmlist^.concat(new(pai386,op_ref_reg(A_LEA,S_L,
                newreference(p^.left^.location.reference),R_EDI)));

              exprasmlist^.concat(new(pai386,op_reg_ref(A_MOV,S_L,
                R_EDI,newreference(ref))));

              del_reference(p^.left^.location.reference);

              { the offset relative to (%ebp) is only needed here! }
              p^.withsymtable^.datasize:=ref.offset;

              secondpass(p^.right);

              { clear some stuff }
              ungetiftemp(ref);
           end;
       end;

    procedure secondpass(var p : ptree);

      const
         procedures : array[ttreetyp] of secondpassproc =
            (secondadd,secondadd,secondadd,secondmoddiv,
             secondmoddiv,secondassignment,secondload,secondnothing,
             secondadd,secondadd,secondadd,secondadd,
             secondadd,secondadd,secondin,secondadd,
             secondadd,secondshlshr,secondshlshr,secondadd,
             secondadd,secondsubscriptn,secondderef,secondaddr,
             secondordconst,secondtypeconv,secondcalln,secondnothing,
             secondrealconst,secondfixconst,secondumminus,
             secondasm,secondvecn,
             secondstringconst,secondfuncret,secondselfn,
             secondnot,secondinline,secondniln,seconderror,
             secondnothing,secondhnewn,secondhdisposen,secondnewn,
             secondsimplenewdispose,secondnothing,secondsetcons,secondblockn,
             secondnothing,secondnothing,secondifn,secondbreakn,
             secondcontinuen,second_while_repeatn,second_while_repeatn,secondfor,
             secondexitn,secondwith,secondcase,secondlabel,
             secondgoto,secondsimplenewdispose,secondtryexcept,secondraise,
             secondnothing,secondtryfinally,secondis,secondas);
      var
         oldcodegenerror : boolean;

      begin
         oldcodegenerror:=codegenerror;
         codegenerror:=false;
         current_module^.current_inputfile:=p^.inputfile;
         current_module^.current_inputfile^.line_no:=p^.line;
         if assigned(p^.pragmas) then
           aktswitches:=p^.pragmas^;
         if not(p^.error) then
           begin
              procedures[p^.treetype](p);
              p^.error:=codegenerror;
              codegenerror:=codegenerror or oldcodegenerror;
           end
         else codegenerror:=true;
      end;

    function do_secondpass(var p : ptree) : boolean;

      var
         oldswitches : tcswitches;

      begin
         codegenerror:=false;
         oldswitches:=aktswitches;
         if not(p^.error) then
           secondpass(p);
         aktswitches:=oldswitches;
         do_secondpass:=codegenerror;
      end;

    var
       regvars : array[1..maxvarregs] of pvarsym;
       regvars_para : array[1..maxvarregs] of boolean;
       parasym : boolean;

    procedure searchregvars(p : psym);far;

      var
         i,j : longint;

      begin
         if (p^.typ=varsym) and (pvarsym(p)^.regable) then
           begin
              { walk through all momentary register variables }
              for i:=1 to maxvarregs do
                begin
                   { free register ? }
                   if regvars[i]=nil then
                     begin
                        regvars[i]:=pvarsym(p);
                        regvars_para[i]:=parasym;
                        break;
                     end;
                   { else throw out a variable ? }
                   j:=pvarsym(p)^.refs;
                   { parameter get a less value }
                   if parasym then
                     begin
                        if cs_littlesize in aktswitches  then
                          dec(j,1)
                        else
                          dec(j,100);
                     end;
                   if (j>regvars[i]^.refs) and (j>0) then
                     begin
                        for j:=maxvarregs-1 downto i do
                          begin
                             regvars[j+1]:=regvars[j];
                             regvars_para[j+1]:=regvars_para[j];
                          end;
                        { calc the new refs }
                        pvarsym(p)^.refs:=j;
                        regvars[i]:=pvarsym(p);
                        regvars_para[i]:=parasym;
                        break;
                     end;
                end;
           end;
      end;

    procedure generatecode(var p : ptree);

      var
         { *pass modifies with every node aktlinenr and current_module^.current_inputfile, }
         { to constantly contain the right line numbers             }
         oldis : pinputfile;
         oldnr,i : longint;
         regsize : topsize;
         regi : tregister;
         hr : preference;

      label
         nextreg;

      begin
         cleartempgen;
         oldis:=current_module^.current_inputfile;
         oldnr:=current_module^.current_inputfile^.line_no;

         { when size optimization only count occurrence }
         if cs_littlesize in aktswitches  then
           t_times:=1
         else
         { reference for repetition is 100 }
         { wenn speed optimizing           }
           t_times:=100;
         { clear register count }
         for regi:=R_EAX to R_EDI do
           reg_pushes[regi]:=0;

         if not(do_firstpass(p)) then
           begin
              { max. optimizations     }
              { only if no asm is used }
              if (cs_maxoptimieren in aktswitches) and
                ((procinfo.flags and pi_uses_asm)=0) then
                begin
                   { can we omit the stack frame ? }
                   { conditions:
                     1. procedure (not main block)
                     2. no constructor or destructor
                     3. no call to other procedures
                     4. no interrupt handler
                   }
                   if assigned(aktprocsym) and
                     ((aktprocsym^.definition^.options and poconstructor)=0) and
                     ((aktprocsym^.definition^.options and podestructor)=0) and
                     ((aktprocsym^.definition^.options and poinline)=0) and
                     ((aktprocsym^.definition^.options and pointerrupt)=0) and
                     ((procinfo.flags and pi_do_call)=0) then
                     begin
                        { use ESP as frame pointer }
                        procinfo.framepointer:=R_ESP;

                        { calc parameter distance new }
                        dec(procinfo.framepointer_offset,4);
                        dec(procinfo.ESI_offset,4);

                        dec(procinfo.retoffset,4);

                        dec(procinfo.call_offset,4);
                        aktprocsym^.definition^.parast^.call_offset:=procinfo.call_offset;
                     end;
                   { global (procedure wide) register allocation }
                   if (p^.registers32<4) then
                     begin
                        { search variables for registers }
                        for i:=1 to maxvarregs do
                          regvars[i]:=nil;
                        parasym:=false;
{$ifdef tp}
                        symtablestack^.foreach(searchregvars);
{$else}
                        symtablestack^.foreach(@searchregvars);
{$endif}
                        { copy parameter into a register ? }
                        parasym:=true;
{$ifdef tp}
                        symtablestack^.next^.foreach(searchregvars);
{$else}
                        symtablestack^.next^.foreach(@searchregvars);
{$endif}

                        { hold needed registers free }
                        for i:=maxvarregs downto maxvarregs-p^.registers32+1 do
                          regvars[i]:=nil;
                        { now assign register }
                        for i:=1 to maxvarregs do
                          begin
                             if assigned(regvars[i]) then
                               begin
                                  { it is nonsens, to copy the variable to }
                                  { a register because we need then much   }
                                  { pushes ?                               }
                                  if reg_pushes[varregs[i]]>=regvars[i]^.refs then
                                    begin
                                       regvars[i]:=nil;
                                       goto nextreg;
                                    end;

                                  { register is no longer available for }
                                  { expressions                         }
                                  { search the register which is the most }
                                  { unused                                }
                                  usableregs:=usableregs-[varregs[i]];
                                  dec(c_usableregs);

                                  { possibly no 32 bit register are needed }
                                  if  (regvars[i]^.definition^.deftype=orddef) and
                                      (
                                       (porddef(regvars[i]^.definition)^.typ=bool8bit) or
                                       (porddef(regvars[i]^.definition)^.typ=uchar) or
                                       (porddef(regvars[i]^.definition)^.typ=u8bit) or
                                       (porddef(regvars[i]^.definition)^.typ=s8bit)
                                      ) then
                                    begin
                                       regvars[i]^.reg:=reg32toreg8(varregs[i]);
                                       regsize:=S_B;
                                    end
                                  else if  (regvars[i]^.definition^.deftype=orddef) and
                                      (
                                       (porddef(regvars[i]^.definition)^.typ=u16bit) or
                                       (porddef(regvars[i]^.definition)^.typ=s16bit)
                                      ) then
                                    begin
                                       regvars[i]^.reg:=reg32toreg16(varregs[i]);
                                       regsize:=S_W;
                                    end
                                  else
                                    begin
                                       regvars[i]^.reg:=varregs[i];
                                       regsize:=S_L;
                                    end;
                                  { parameter must be load }
                                  if regvars_para[i] then
                                    begin
                                       { procinfo is there actual,      }
                                       { because we can't never be in a }
                                       { nested procedure               }
                                       { when loading parameter to reg  }
                                       new(hr);
                                       reset_reference(hr^);
                                       hr^.offset:=pvarsym(regvars[i])^.adresse+procinfo.call_offset;
                                       hr^.base:=procinfo.framepointer;
                                       procinfo.aktentrycode^.concat(new(pai386,op_ref_reg(A_MOV,regsize,
                                         hr,regvars[i]^.reg)));
                                    end;
                                  { procedure uses this register }
                                  usedinproc:=usedinproc or ($80 shr byte(varregs[i]));
                               end;
                             nextreg:
                               { dummy }
                               regsize:=S_W;
                          end;
                        if (verbosity and v_debug)=v_debug then
                          begin
                             for i:=1 to maxvarregs do
                               begin
                                  if assigned(regvars[i]) then
                                    comment(v_debug,'  register '+reg2str(regvars[i]^.reg)+': '+
                                      '  weight: '+tostr(regvars[i]^.refs));
                               end;
                          end;
                     end;
                end;
              do_secondpass(p);

              { all registers can be used again }
              usableregs:=[R_EAX,R_EBX,R_ECX,R_EDX];
              c_usableregs:=4;
           end;
         procinfo.aktproccode^.concatlist(exprasmlist);

         current_module^.current_inputfile:=oldis;
         current_module^.current_inputfile^.line_no:=oldnr;
      end;

end.

