Unit catch;

{

  Unit to catch segmentation faults and exit gracefully - thus we
  eliminate stupid core dumps in Linux ...
  (c) 1997 Michael Van Canneyt
}
interface

uses linux,errors;

Var NewSigSegm,OldSigSegm : PSignalHandler;


Implementation

Procedure CatchSegmentationFault (Sig : Integer);

begin
  if Sig=SIGSEGV then
     begin
     { Temporary message - until we get an error number... }
     writeln ('Panic : Internal compiler error, exiting.');
     internalerror(9999);
     end;
end;

begin
  NewSigSegm:=PSignalHandler(@CatchSegmentationFault);
  OldSigSegm:=Signal (SIGSEGV,NewSigSegm);
end.
