{****************************************************************************

                   Copyright (c) 1995,96 by Florian Klaempfl

 ****************************************************************************}

{
  This unit contains informations about the systems supported by FPKPascal
  (not processor specific)

  History:
      15th october 1996:
         + ttargetinfo.newline added
}
unit systems;

  interface

    type
       { Zielbetriebssysteme }
       ttarget = (target_DOS,target_OS2,target_LINUX,target_WIN32,target_PMODE,target_GO32V2);

       ttargetinfo = record
          target : ttarget;
          target_name : string[20];
          short_name : string[8];
          unit_env : string[20];
          system_unit : string[8];
          objext : string[4];
          unitext : string[4];
          asmext : string[4];
          sourceext : string[4];
          newline : string[3];
          labelprefix : string[2];
          use_function_relative_addresses : boolean;
       end;

    var
       target_info : ttargetinfo;

    function set_string_target(const s : string) : boolean;

  implementation

    const
       target_infos : array[ttarget] of ttargetinfo = (
          (
            target : target_DOS;
            target_name : 'GO32 V1 DOS extender';
            short_name : 'DOS';
            unit_env : 'DOSUNITS';
            system_unit : 'SYSTEM';
            objext : '.o';
            unitext : '.PPU';
            asmext : '.S';
            sourceext : '.PP';
            newline : #13#10;
            labelprefix : 'L';
            use_function_relative_addresses : false
          ),
          (
            target : target_OS2;
            target_name : 'OS/2 (32 bit)';
            short_name : 'OS2';
            unit_env : 'OS2UNITS';
            system_unit : 'SYSOS2';
            objext : '.obj';
            unitext : '.ppu';
            asmext : '.s';
            sourceext : '.pp';
            newline : #13#10;
            labelprefix : 'L';
            use_function_relative_addresses : false {????}
          ),
          (
            target : target_LINUX;
            target_name : 'Linux';
            short_name : 'LINUX';
            unit_env : 'LINUXUNITS';
            system_unit : 'syslinux';
            objext : '.o';
            unitext : '.ppu';
            asmext : '.s';
            sourceext : '.pp';
            newline : #10;
            labelprefix : '.L';
            use_function_relative_addresses : true
          ),
          (
            target : target_WIN32;
            target_name : 'Win32';
            short_name : 'WIN32';
            unit_env : 'WIN32UNITS';
            system_unit : 'SYSWIN32';
            objext : '.o';
            unitext : '.PPU';
            asmext : '.S';
            sourceext : '.PP';
            newline : #13#10;
            labelprefix : '.L';
            use_function_relative_addresses : true {????}
          ),
          (
            target : target_PMODE;
            target_name : 'PMODE DOS extender';
            short_name : 'PMODE';
            unit_env : 'DOSUNITS\PMODE';
            system_unit : 'SYSTEM';
            objext : '.o';
            unitext : '.PPU';
            asmext : '.S';
            sourceext : '.PP';
            newline : #13#10;
            labelprefix : '.L';
            use_function_relative_addresses : false
          ),
          (
            target : target_DOS;
            target_name : 'GO32 V2.0 DOS extender';
            short_name : 'GO32V2';
            unit_env : 'DOSUNITS\GO32V2';
            system_unit : 'SYSTEM';
            objext : '.o';
            unitext : '.PPU';
            asmext : '.S';
            sourceext : '.PP';
            newline : #13#10;
            labelprefix : '.L';
            use_function_relative_addresses : true
          )
       );

    procedure set_target(t : ttarget);

      begin
         target_info:=target_infos[t];
      end;

    function set_string_target(const s : string) : boolean;

      var
         t : ttarget;

      begin
         set_string_target:=false;
         for t:=target_DOS to target_GO32V2 do
           if target_infos[t].short_name=s then
             begin
                set_string_target:=true;
                set_target(t);
             end;
      end;

    begin
{$ifdef tp}
       set_target(target_DOS);
{$else}
{$ifdef DOS}
       set_target(target_DOS);
{$endif}
{$ifdef GO32V2}
       set_target(target_GO32V2);
{$endif}
{$ifdef OS2}
       set_target(target_OS2);
{$endif}
{$ifdef LINUX}
       set_target(target_LINUX);
{$endif}
{$ifdef WIN32}
       set_target(target_WIN32);
{$endif}
{$endif}
    end.



