Unit verbose;
{
  Unit for a unified error reporting interface for FPK pascal.
  Under linux, defining INFO_TO_STDERR allows to send all info
  to standard error output.
  (C) 1997, Michael Van Canneyt
}

{$IFNDEF LINUX}
  { Not under linux : make sure INFO_TO_STDERR is off.}
{$IFDEF INFO_TO_STDERR}
  {$UNDEF INFO_TO_STDERR}
{$ENDIF}
{$ENDIF}


Interface

{$IFDEF INFO_TO_STDERR}
uses Linux;
{$ENDIF}

Const
  V_Error       = 0;
  V_Info        = 1;
  V_Warning     = 1 shl 1;
  V_Linenrs     = 1 shl 2;
  V_Used        = 1 shl 3;
  V_Tried       = 1 shl 4;
  V_Procedure   = 1 shl 5;
  V_Conditional = 1 shl 6;
  V_Debug       = 1 shl 7;
  V_Macro       = 1 shl 8;


var Verbosity : Longint;
{$IFDEF INFO_TO_STDERR}
    To_StdErr : boolean;
{$ENDIF}


Procedure Comment (Level : Longint;const what : string);
{ returns false, if the option was unkown }
function SetVerbosity(const s : string) : boolean;

Implementation

Procedure Comment (Level : Longint;const what : string);

begin
  If (verbosity and Level)=Level then
{$IFDEF INFO_TO_STDERR}
    if To_StdErr then
      writeln (stderr,what)
    else
{$ENDIF}
      writeln (what);
end;

function SetVerbosity(const s : string) : boolean;

var m : Longint;
    c : Word;

begin
  setverbosity:=false;
  val(s,m,c);
  if c=0 then
    verbosity:=m
  else
    begin
       for c:=1 to length(s) do
         case s[c] of
            'e','E' : Verbosity:=Verbosity or V_Error;
            'i','I' : Verbosity:=Verbosity or V_Info;
            'w','W' : Verbosity:=Verbosity or V_Warning;
            'l','L' : Verbosity:=Verbosity or V_Linenrs;
            'u','U' : Verbosity:=Verbosity or V_Used;
            't','T' : Verbosity:=Verbosity or V_Tried;
            'p','P' : Verbosity:=Verbosity or V_Procedure;
            'c','C' : Verbosity:=Verbosity or V_Conditional;
            'd','D' : Verbosity:=Verbosity or V_Debug;
            'm','M' : Verbosity:=Verbosity or V_Macro;
            else exit;
          end; { Case}
    end;
    setverbosity:=true;
end;

begin
   verbosity:=0;
{$ifdef INFO_TO_STDERR}
   to_stderr:=false;
{$endif INFO_TO_STDERR}
end.