{****************************************************************************

                      Copyright (c) 1996 by Florian Klaempfl

 ****************************************************************************}

{
  this unit reads inline assembler for the i386 (intel styled)

  History:
      19th october 1996:
         + created from old asmbl.pas
       3th december 1996:
         + first implementation
         + keyword scan

  What's to do:
    o local labels
    o instructions with operands
    o pascal labels
    o data
    o expressions
}
unit rai386;

  interface

     uses
        cobjects,globals,errors,aasm,symtable,scanner,tree,i386,rasm386,
        intasmi3;

     function assemble : ptree;

  implementation

    procedure read_data;

      begin
         case actasmtoken of
            A_DB : ;
            A_DW : ;
            A_DD : ;
            A_DT : ;
            A_DF : ;
            A_DP : ;
            A_DQ : ;
            else error(_asm_syntax_error);
         end;
      end;

    const
       _count_asmkeywords = 8;

       _asmkeywords : array[1.._count_asmkeywords] of tasmkeyword = (
                 'DB','DD','DF','DP','DQ','DT','DW','END');

       _asmkeyword_token : array[1.._count_asmkeywords] of tasmtoken = (
                 A_DB,A_DD,A_DF,A_DP,A_DQ,A_DT,A_DW,A_END);


    function is_register(s :string) : boolean;

      var i :  tregister;
      begin
         is_register:=false;
         for i:=R_EAX to R_ST7 do
           if upper(intasmi3._reg2str[i])=upper(s) then
             begin
                is_register:=true;
             end;

      end;

    function assemble : ptree;

      var
         id : string;
         instruc : tasmop;
         p : paasmoutput;

         { true, if the current instruction fits to any template }
         fits : boolean;

         { true, if the operands are swaped }
         do_swap : boolean;
         i,opcount : longint;

         { type of the operands }
         optyp1,optyp2,optyp3 : longint;

      begin
         { setup the scanner }
         { for Intel assembler }
         count_asmkeywords:=_count_asmkeywords;

         { the pointer don't match, because the generic array has }
         { 255 elements                                           }
         asmkeywords:=pointer(@_asmkeywords);
         asmkeyword_token:=pointer(@_asmkeyword_token);

         p:=new(paasmoutput,init);
         c:=asmgetchar;
         actasmtoken:=gettoken;
         while actasmtoken<>A_END do
           begin
              case actasmtoken of
                 A_KLAMMERAFFE : begin
                                  { local label }
                                 end;
                 A_ID : begin
                           id:=actasmpattern;

                           { check for asm instruction }
                           for instruc:=intasmi3.firstop to intasmi3.lastop do
                             if id=upper(intasmi3.op2str[instruc]) then
                               begin
                                  consume(A_ID);
                                  if actasmtoken<>A_SEPERATOR then
                                    begin
                                       {!!!!!!}
                                    end
                                  else
                                    begin
                                       { assembler instruction with no operand }
                                       opcount:=0;
                                    end;
                                  { after reading the operands }
                                  { search the instruction     }
                                  { setup startvalue from cache }
                                  if ins_cache[instruc]<>-1 then
                                    i:=ins_cache[instruc]
                                  else i:=0;
                                  fits:=false;
                                  while not(fits) do
                                    begin
                                       { set the instruction cache, if the instruction }
                                       { occurs the first time                         }
                                       if (it[i].i=instruc) and (ins_cache[instruc]=-1) then
                                         ins_cache[instruc]:=i;

                                       if (it[i].i=instruc) and (opcount=it[i].ops) then
                                         begin
                                            do_swap:=false;
                                            { first fit }
                                            case opcount of
                                               0 : begin
                                                      fits:=true;
                                                      p^.concat(new(pai386,op_none(instruc,S_NO)));
                                                   end;
                                               1 : if (optyp1 and it[i].o1)<>0 then
                                                     fits:=true;
                                               2 : if ((optyp1 and it[i].o1)<>0) and
                                                      ((optyp2 and it[i].o2)<>0) then
                                                     fits:=true
                                                   { if the operands can be swaped }
                                                   { then swap them                }
                                                   else if ((it[i].m and af_d)<>0) and
                                                      ((optyp1 and it[i].o2)<>0) and
                                                      ((optyp2 and it[i].o1)<>0) then
                                                      begin
                                                         do_swap:=true;
                                                         fits:=true;
                                                      end;
                                               3 : if ((optyp1 and it[i].o1)<>0) and
                                                      ((optyp2 and it[i].o2)<>0) and
                                                      ((optyp3 and it[i].o3)<>0) then
                                                     fits:=true;
                                            end;
                                         end;
                                       if it[i].i=A_NONE then
                                         begin
                                            { this is an label }
                                            { !!!!! }
                                         end;
                                       inc(i);
                                    end;
                                  break;
                               end;
                           consume(A_SEPERATOR);
                        end;
                 A_DB,A_DW,A_DD,A_DT,A_DF,A_DP,A_DQ : read_data;
                 A_SEPERATOR : consume(A_SEPERATOR);
                 else consume(A_ID);
              end;
           end;
         assemble:=genasmnode(p);
      end;

end.
