{****************************************************************************

                      Copyright (c) 1996 by Florian Klaempfl

 ****************************************************************************}

{
  this unit reads inline assembler and writes the lines direct to the
  output

  History:
      19th october 1996:
         + created from old asmbl.pas
      13th october 1996:
         + renamed to radi386
}
unit radi386;

  interface

     uses
        i386,attasmi3,errors,hcodegen,globals,scanner,aasm,cobjects,tree,symtable;

     function assemble : ptree;

  implementation

    function assemble : ptree;

{$ifdef GDB}
    function is_not_empty(const s : string) : boolean;
      var i : byte;
      begin
      is_not_empty := true;
      for i :=1 to length(s) do
        if (s[i] <> ' ') and (s[i] <> #9) then exit;
      is_not_empty := false;
      end;

{$endif GDB}
      var
         s,hs : string;
         c : char;
         ende : boolean;
         sym : psym;
         code : paasmoutput;
         l : longint;
{$ifdef GDB}
         commentpos : integer;
{$endif GDB}

      begin
         ende:=false;
         s:='';
         c:=asmgetchar;
         code:=new(paasmoutput,init);
         while not(ende) do
           begin
              case c of
                 'A'..'Z','a'..'z','_' : begin
                      hs:='';
                      while ((ord(c)>=ord('A')) and (ord(c)<=ord('Z')))
                         or ((ord(c)>=ord('a')) and (ord(c)<=ord('z')))
                         or ((ord(c)>=ord('0')) and (ord(c)<=ord('9')))
                         or (c='_') do
                        begin
                           inc(byte(hs[0]));
                           hs[length(hs)]:=c;
                           c:=asmgetchar;
                        end;
                      if upper(hs)='END' then ende:=true
                      else
                         begin
                            { access to local variables }
                            if assigned(aktprocsym) then
                              begin
                                 { is the last written character an special }
                                 { char ?                                   }
                                 if (s[length(s)]<>'%') and
                                   (s[length(s)]<>'$') then
                                   begin
                                      sym:=aktprocsym^.definition^.localst^.search(upper(hs));
                                      if assigned(sym) then
                                        begin
                                           if sym^.typ=varsym then
                                             begin
                                             hs:='-'+tostr(pvarsym(sym)^.adresse)+'('+_reg2str[procinfo.framepointer]+')';
                                             {variables set are after a comma }
                                             {like in movl %eax,I }
                                             if pos(',',s) > 0 then
                                               pvarsym(sym)^.is_valid:=true;
                                             end
                                           else
                                           { call to local function }
                                           if (sym^.typ=procsym) and (pos('CALL',upper(s))>0) then
                                             hs:=pprocsym(sym)^.definition^.mangledname;
                                        end
                                      else
                                        begin
                                           sym:=aktprocsym^.definition^.parast^.search(upper(hs));
                                           if assigned(sym) then
                                             begin
                                                if sym^.typ=varsym then
                                                  begin
                                                     l:=pvarsym(sym)^.adresse;
                                                     { set offset }
                                                     inc(l,aktprocsym^.definition^.parast^.call_offset);
                                                     hs:=tostr(l)+'('+_reg2str[procinfo.framepointer]+')';
                                                     if pos(',',s) > 0 then
                                                       pvarsym(sym)^.is_valid:=true;
                                                  end;
                                             end
                                      { I added that but it creates a problem in line.ppi
                                      because there is a local label wbuffer and
                                      a static variable WBUFFER ...
                                      what would you decide, florian ?
                                      else

                                        begin
                                           getsym(upper(hs),false);
                                           sym:=srsym;
                                           if assigned(sym) and (sym^.typ = varsym) then
                                             begin
                                             if  (sym^.owner^.symtabletype = unitsymtable) or
                                                 (sym^.owner^.symtabletype = globalsymtable) then
                                               hs:='U_'+sym^.owner^.name^+'_'+sym^.name
                                             else if (sym^.owner^.symtabletype = staticsymtable) then
                                               hs := '_'+sym^.name;
                                             if pos(',',s) > 0 then
                                                       pvarsym(sym)^.is_valid:=true;
                                             end              }
                                           else if upper(hs)='__SELF' then
                                             begin
                                                if assigned(procinfo._class) then
                                                  hs:=tostr(procinfo.ESI_offset)+'('+_reg2str[procinfo.framepointer]+')';
                                             end
                                           else if upper(hs)='__RESULT' then
                                             begin
                                                if assigned(procinfo.retdef) then
                                                  begin
                                                  hs:=tostr(procinfo.retoffset)+'('+_reg2str[procinfo.framepointer]+')';
                                                  if pos(',',s) > 0 then
                                                    procinfo.funcret_is_valid:=true;
                                                  end;
                                             end
                                           else if upper(hs)='__OLDEBP' then
                                             begin
                                                { complicate to check there }
                                                { we do it: }
                                                hs:=tostr(procinfo.framepointer_offset)
                                                    +'('+_reg2str[procinfo.framepointer]+')';
                                             end;
                                           end;
                                       { end;}
                                   end;
                              end;
                            s:=s+hs;
                         end;
                   end;
                 ';' : begin
                           while c<>#10 do
                             c:=asmgetchar;
                       end;
                 #10 : begin
{$ifdef GDB}
                          commentpos := pos('//',s);
                          if commentpos > 0 then
                            s := copy(s,1,commentpos-1)+' # '+copy(s,commentpos,255);
                          if is_not_empty(s) then
{$endif GDB}
                          code^.concat(new(pai_direct,init(strpnew(s))));
                          s:='';
                          c:=asmgetchar;
                          write_line;
                       end;
                 #13,'{' : c:=asmgetchar;
                 #26 : fatalerror(endoffile);
                 else
                   begin
                      inc(byte(s[0]));
                      s[length(s)]:=c;
                      c:=asmgetchar;
                   end;
              end;
           end;
{$ifndef GDB}
         code^.insert(new(pai_direct,init(strpnew(s))));
{$else GDB}
         commentpos := pos('//',s);
         if commentpos > 0 then
           s := copy(s,1,commentpos-1)+' # '+copy(s,commentpos,255);

         if is_not_empty(s) then
           code^.concat(new(pai_direct,init(strpnew(s))));
{$endif GDB}
         assemble:=genasmnode(code);
      end;

end.
