{****************************************************************************

                       Copyright (c) 1996,97 by Florian Klaempfl

 ****************************************************************************}

unit hcodegen;

{
  This unit exports some help routines for the code generation
}
  interface

     uses
        cobjects,systems,globals,tree,symtable,types,strings
{$ifdef i386}
       ,i386
       ,aasm
{$endif}
       ;

    const
       { set, if the procedure uses asm }
       pi_uses_asm = $1;
       { set, if the procedure is exported by an unit }
       pi_is_global = $2;
       { set, if the procedure does a call }
       { this is for the optimizer         }
       pi_do_call = $4;

    type
       tprocinfo = record
          { current class, if we are in a method }
          _class : pobjectdef;
          { return type }
          retdef : pdef;
          { frame pointer offset }
          framepointer_offset : longint;
          { self pointer offset }
          ESI_offset : longint;
          { result value offset }
          retoffset : longint;

          { firsttemp position }
          firsttemp : longint;

          funcret_is_valid : boolean;

            { address of the vmt (only for con- and destructors }
          { parameter offset }
          call_offset : longint;

          { address of the vmt (only for con- and destructors }
          vmt_table : longint;

          { some collected informations about the procedure }
          { see pi_xxxx above                               }
          flags : longint;

          { register used as frame pointer }
          framepointer : tregister;

{$ifdef GDB}
          { true, if the procedure is exported by an unit }
          globalsymbol : boolean;
{$endif * GDB *}

          { true, if the procedure should be exported (only OS/2) }
          exported : boolean;

          { code for the current procedure }
          aktproccode,aktentrycode,aktexitcode : paasmoutput;
       end;

    var
       { info about the current sub routine }
       procinfo : tprocinfo;

       { Die Nummer der Label die bei BREAK bzw CONTINUE }
       { angesprungen werden sollen }
       aktbreaklabel,aktcontinuelabel : longint;

       { truelabel wird angesprungen, wenn ein Ausdruck true ist, falselabel }
       { entsprechend                                                        }
       truelabel,falselabel : longint;

       { Nr des Labels welches zum Verlassen eines Unterprogramm }
       { angesprungen wird                                       }
       aktexitlabel : longint;

       { also an exit label, only used we need to clear only the }
       { stack                                                   }
       aktexit2label : longint;

       { this asm list contains the debug info }
       {debuginfos : paasmoutput;  debuglist is enough }

       { Boolean, wenn eine loadn kein Assembler erzeugt hat }
       simple_loadn : boolean;

       { enthlt die geschtzte Durchlaufanzahl*100 fr den }
       { momentan bearbeiteten Baum                         }
       t_times : longint;

       { true, if an error while code generation occurs }
       codegenerror : boolean;

    { some support routines for the case instruction }

    { counts the labels }
    function case_count_labels(root : pcaserecord) : longint;

    { searches the highest label }
    function case_get_max(root : pcaserecord) : longint;

    { searches the lowest label }
    function case_get_min(root : pcaserecord) : longint;

    { concates the ASCII string to the const segment }
    procedure generate_ascii(hs : string);

    { inserts the ASCII string to the const segment }
    procedure generate_ascii_insert(hs : string);

    procedure generate_interrupt_stackframe_entry;
    procedure generate_interrupt_stackframe_exit;

  implementation

    procedure generate_interrupt_stackframe_entry;

      begin
         { save the registers of an interrupt procedure }
         procinfo.aktentrycode^.insert(new(pai386,op_reg(A_PUSH,S_L,R_EAX)));
         procinfo.aktentrycode^.insert(new(pai386,op_reg(A_PUSH,S_L,R_EBX)));
         procinfo.aktentrycode^.insert(new(pai386,op_reg(A_PUSH,S_L,R_ECX)));
         procinfo.aktentrycode^.insert(new(pai386,op_reg(A_PUSH,S_L,R_EDX)));
         procinfo.aktentrycode^.insert(new(pai386,op_reg(A_PUSH,S_L,R_ESI)));
         procinfo.aktentrycode^.insert(new(pai386,op_reg(A_PUSH,S_L,R_EDI)));

         { .... also the segment registers }
         procinfo.aktentrycode^.insert(new(pai386,op_reg(A_PUSH,S_W,R_DS)));
         procinfo.aktentrycode^.insert(new(pai386,op_reg(A_PUSH,S_W,R_ES)));
         procinfo.aktentrycode^.insert(new(pai386,op_reg(A_PUSH,S_W,R_FS)));
         procinfo.aktentrycode^.insert(new(pai386,op_reg(A_PUSH,S_W,R_GS)));
      end;

    procedure generate_interrupt_stackframe_exit;

      begin
         { restore the registers of an interrupt procedure }
         procinfo.aktentrycode^.concat(new(pai386,op_reg(A_POP,S_L,R_EAX)));
         procinfo.aktentrycode^.concat(new(pai386,op_reg(A_POP,S_L,R_EBX)));
         procinfo.aktentrycode^.concat(new(pai386,op_reg(A_POP,S_L,R_ECX)));
         procinfo.aktentrycode^.concat(new(pai386,op_reg(A_POP,S_L,R_EDX)));
         procinfo.aktentrycode^.concat(new(pai386,op_reg(A_POP,S_L,R_ESI)));
         procinfo.aktentrycode^.concat(new(pai386,op_reg(A_POP,S_L,R_EDI)));

         { .... also the segment registers }
         procinfo.aktentrycode^.concat(new(pai386,op_reg(A_POP,S_W,R_DS)));
         procinfo.aktentrycode^.concat(new(pai386,op_reg(A_POP,S_W,R_ES)));
         procinfo.aktentrycode^.concat(new(pai386,op_reg(A_POP,S_W,R_FS)));
         procinfo.aktentrycode^.concat(new(pai386,op_reg(A_POP,S_W,R_GS)));

        { this restores the flags }
         procinfo.aktexitcode^.concat(new(pai386,op_none(A_IRET,S_NO)));
      end;

    procedure generate_ascii(hs : string);

      begin
         while length(hs)>32 do
           begin
              datasegment^.concat(new(pai_string,init(copy(hs,1,32))));
              delete(hs,1,32);
           end;
         datasegment^.concat(new(pai_string,init(hs)))
      end;

    procedure generate_ascii_insert(hs : string);

      begin
         while length(hs)>32 do
           begin
              datasegment^.insert(new(pai_string,init(copy(hs,length(hs)-32+1,length(hs)))));
              delete(hs,length(hs)-32+1,length(hs));
           end;
         datasegment^.insert(new(pai_string,init(hs)));
      end;

    function case_count_labels(root : pcaserecord) : longint;

      var
         _l : longint;

      procedure count(p : pcaserecord);

        begin
           inc(_l);
           if assigned(p^.less) then
             count(p^.less);
           if assigned(p^.greater) then
             count(p^.greater);
        end;

      begin
         _l:=0;
         count(root);
         case_count_labels:=_l;
      end;

    function case_get_max(root : pcaserecord) : longint;

      var
         hp : pcaserecord;

      begin
         hp:=root;
         while assigned(hp^.greater) do
           hp:=hp^.greater;
         case_get_max:=hp^._high;
      end;

    function case_get_min(root : pcaserecord) : longint;

      var
         hp : pcaserecord;

      begin
         hp:=root;
         while assigned(hp^.less) do
           hp:=hp^.less;
         case_get_min:=hp^._low;
      end;

end.

