{****************************************************************************

                   Copyright (c) 1993,97 by Florian Klaempfl

 ****************************************************************************}

{$ifdef TP}
  {$ifdef GDB}
    {$M 65000,16384,400000}
  {$else GDB }
    {$M 38000,16384,400000}
  {$endif GDB}
{E+,N+}
{$endif TP}

program pp;

  uses
     cobjects,errors,globals,systems,parser,dos,scanner,symtable,
{$ifdef tp}
     objects,
  {$ifdef MULLER}
    {$ifndef DPMI}
       Overlay,GInstOverlay,
    {$endif DPMI}
    {$ifdef usepmd}
       usepmd,
    {$endif usepmd}
  {$endif MULLER}
{$endif TP}
{$ifdef LINUX}
     catch,
{$endif LINUX}
     tree,verbose;

{$IfDef Cleanup}
var    EntryMemAvail : longint;
{$EndIf}
  const
     copyright = 'Copyright (c) 1993,97 by Florian Klaempfl';

{$ifdef inc_date}
     released = {$I C:\PASDATE.INC}; { released sollte ein String mit     }
                                     { dem aktuellen Datum sein,          }
                                     { bei mir wird PASDATE.INC jeden Tag }
                                     { neu in der AUTOEXEC.BAT erzeugt    }
{$endif}

var temp : string; { Used for conversion from number to string. }
   
  procedure error(const s : string);

    begin
       case language of
          'D' : Comment (V_Error,'Fehler: '+s);
          'E' : Comment (V_Error,'error: '+s);
       end;
       halt(1);
    end;

  procedure init;

    var
       s,opts : string;
       p : pathstr;
       d : dirstr;
       n : namestr;
       i,j : integer;
       resf,configfile : text;
       res,endofparas,read_configfile : boolean;

    procedure illparas;

      begin
         case language of
            'D' : begin
                     Comment (V_Error,'Illegaler Parameter: '+opts);
                     Comment (V_Error,'  Aufruf mit -? gibt Liste der Optionen aus');
                  end;
            'E' : begin
                     Comment (V_Error,'illegal parameter: '+opts);
                     Comment (V_Error,'  -? writes help pages');
                  end;
         end;
         halt(1);
      end;

    procedure printhilfe_d;

      var
         s : string;

      begin
{$ifdef tp}
         writeln('PPC [Optionen] <inputfile> [Optionen]');
{$else}
         writeln('PPC386 [Optionen] <inputfile> [Optionen]');
{$endif}
         writeln('  + schaltet eine Option ein, - ab');
         writeln('  mit * markierte Optionen haben momentan keine Wirkung');
         writeln('  mit ! markierte Optionen nur teilweise implementiert');
         writeln('  -A    Format der Ausgabe');
         writeln('             -Aatt  AT&T Assembler');
         writeln('             -Ao    Unix Object Datei');
         writeln('             -Aobj  OMF Datei');
         writeln('             -Awasm Assembler fr den Watcomassembler');
         writeln('  -a+   erzwingt die Benutzung eines externen Assemblers');
{$ifdef tp}
         writeln('  -b+   Der Compiler benutzt EMS => geringere Geschwindigkeit');
{$endif}
         writeln('  -B    recompiliert alle bentigten Units');
         writeln('  -C     Codegeneratoroptionen');
         writeln('           * -Ca automatischer Aufruf von Kon- und Destruktoren');
         writeln('           * -Ce es werden keine Laufzeit-Fehler generiert,');
         writeln('                 sondern stattdessen Exceptions erzeugt');
         writeln('             -Chxxxx  xxxx gibt die maximale Heapgre in Bytes an ');
         writeln('                 (mu kleiner 67107840 und grer 1023 sein; 4000000 Default)');
         writeln('             -Ci Ein-,Ausgabeberprfung');
         writeln('             -Co testet auf berlufe bei Integer-Operationen');
         writeln('             -Cr Test auf Bereichsberschreitungen');
         writeln('             -Csxxxx gibt die maximale Stackgre in Bytes an (nur OS/2)');
         writeln('                 (mu kleiner 67107840 und grer 1023 sein; 8096 Default)');
         writeln('  -dxxx  definiert das Symbol xxx');
         writeln;
         writeln;
         writeln;
         writeln;
         writeln;
{$ifdef tp}
{$else}
         writeln;
{$endif}
         write('*** Weiter mit Return. ***');
         readln(s);

         writeln('  -D     steuert die Erzeugung einer DEF-Datei unter OS/2');
         writeln('             -Ddxxxx xxxx ist Beschreibung');
         writeln('             -Do erzeuge DEF-Datei');
         writeln('             -Dw PM-Anwendung');
         writeln('  -exxxx Pfad zu den asufhrbaren Dateien (nur LINUX)');
         writeln('  -g     es werden Debuggerinformationen erzeugt');
         writeln('  -F     setzt Dateinamen und Pfade');
         writeln('             -Fexxxx leitet Fehlermeldungen nach xxxx um');
         writeln('             -Fgxxxx Pfad zur GNU C Library (nur LINUX');
         writeln('             -Frxxxx Pfad zur Fehlermeldungsdatei (nur LINUX');
         writeln('  -L     Sprache');
         writeln('             -LD Deutsch');
         writeln('             -LE Englisch');
         writeln('  -l     Ausgabe des Programmlogos');
         writeln('  -i     Programminformation');
         writeln;
         writeln('  -O     Optimiereroptionen');
         writeln('             -Oa einfache Optimierungen');
         writeln('             -Og Optimierung auf Gre');
         writeln('             -OG Optimierung auf Geschwindigkeit');
         writeln('             -Ox maximale Optimierung');
         writeln('             -O3 Optimierung fr i386');
         writeln('             -O4 Optimierung fr i486');
         writeln('             -O5 Optimierung fr Pentium (tm)');
         write('*** Weiter mit Return. ***');
         readln(s);
         writeln('             -O6 Optimierung fr PentiumPro (tm)');
         writeln('  -q-    Der Compiler zeigt die Fortschritte beim bersetzen an');
         writeln('  -S     Syntaxoptionen');
         writeln('             -Sa Einstellung der Ausdruckbehandlung');
         writeln('                 eine hheres Level schliet die unteren ein');
         writeln('                 -Sa0 nur ANSI-Pascalausdrcke erlaubt');
         writeln('                 -Sa1 Funktionsresultate muessen nicht zugewiesen werden');
         writeln('                 -Sa2 @-Operator liefert einen typisierten Pointer');
         writeln('                 -Sa4 typisierte Zuweisungsrckgabewerte');
         writeln('                 -Sa9 auch seiteneffektlose Ausdrcke erlaubt');
         writeln('             -Sc Operatoren wie in C (/=,*=,+= und -=)');
         writeln('             -Sg die Verwendung von LABEL und GOTO ist erlaubt');
         writeln('             -Sm Makros wie in C werden untersttzt');
         writeln;
         writeln('             -Ss der Name von Konstruktoren mu immer init sein');
         writeln('                 der Name von Destruktoren mu immer done sein');
         writeln('  -s     es werden weder Assembler noch Linker aufgerufen (zusammen mit -a');
         writeln('  -T     Zielbetriebssystem');
         writeln('             -TDOS DOS-Extender von DJ Delorie');
         writeln('             -TOS2 OS/2');
         writeln('             -TLINUX Linux');
         writeln('          !  -TWin32 Windows 32 Bit');
         writeln('             -TGO32V2 version 2 von DJ Delorie DOS-Extender');
         writeln;
         writeln;
         writeln;
         write('*** Weiter mit Return. ***');
         readln(s);
         writeln('  -U     Unit-Optionen');
         writeln('             -Un der Name der Unit wird nicht berprft');
         writeln('             -Us eine System-Unit wird bersetzt');
         writeln('             -Upxxxx setzt xxxx als zustzliches Unitverzeichnis');
         writeln('  -w-    Compiler gibt keine Warnungen aus');
         writeln('  -h,-?  zeigt diesen Hilfebildschirm');
{$ifdef linux}
         writeln('  -X     ausfhrbare Datei (LINUX)');
         writeln('             -Xc mit C Library linken');
         writeln('             -Xe erzeuge ELF-Datei');
{$endif}
{$ifndef muller}
         halt(1);
{$else * muller *}
         runerror(190);
{$endif * muller *}
      end;

    procedure printhilfe_e;

      var
         s : string;

      begin
{$ifdef tp}
         writeln('PPC [options] <inputfile> [options]');
{$else}
         writeln('PPC386 [options] <inputfile> [options]');
{$endif}
         writeln('  + switch option on, - off');
         writeln('  with * marked options have no effect');
         writeln('  with ! marked options are only partial implemented');
         writeln('  -A     output format');
         writeln('             -Aatt  AT&T assembler');
         writeln('             -Ao    unix o-file');
         writeln('             -Aobj  OMF file');
         writeln('             -Awasm assembler for the Watcom assembler');
         writeln('  -a     the compiler doesn''t delete the generated assembler file');
{$ifdef tp}
         writeln('  -b+    use EMS');
{$endif}
         writeln('  -B     build');
         writeln('  -C     code generation options');
         writeln('           * -Ca ');
         writeln('           * -Ce ');
         writeln('                 ');
         writeln('             -Chxxxx  xxxx bytes heap ');
         writeln('                 (must be less than 67107840 und greater than 1023');
         writeln('             -Ci IO-checking');
         writeln('             -Co check overflow of integer operations');
         writeln('             -Cr range checking');
         writeln('             -Csxxxx stack size (only OS/2)');
         writeln('             ');
         writeln('  -dxxx  defines the symbol xxx');
{$ifdef tp}
{$else}
         writeln;
{$endif}
         write('*** press return ***');
         readln(s);
         writeln('  -D     controlls the generation of DEF file (only OS/2)');
         writeln('             -Ddxxxx xxxx is the description');
         writeln('             -Do generate DEF file');
         writeln('             -Dw PM application');
         writeln('  -exxxx xxxx path to executables (only LINUX)');
         writeln('  -g     generate debugger informations');
         writeln('  -F     set file names and pathes');
         writeln('             -Fexxxx redirect error output to xxxx');
         writeln('             -Fgxxxx xxxxx search path for the GNU C lib (LINUX only)');
         writeln('             -Frxxxx xxxxx search path for the error message file (only LINUX)');
         writeln('  -L     set language');
         writeln('             -LD german');
         writeln('             -LE english');
         writeln('  -l     write logo');
         writeln('  -i     information');
         writeln;
         writeln('  -O     optimizations');
         writeln('             -Oa simple optimizations');
         writeln('             -Og optimize for size');
         writeln('             -OG optimize for time');
         writeln('             -Ox optimize maximum');
         writeln('             -O3 optimize for i386');
         writeln('             -O4 optimize for i486');
         writeln;
         write('*** press return ***');
         readln(s);
         writeln('             -O5 optimize for Pentium (tm)');
         writeln('             -O6 optimizations for PentiumPro (tm)');
         writeln('  -q-    write information when compiling  (obsolete, see -v)');
         writeln('  -S     syntax options');
         writeln('             -Sa semantic check of expressions');
         writeln('                 a higher level includes the lower');
         writeln('                 -Sa0 only ANSI pascal expressions are allowed');
         writeln('                 -Sa1 functions results havn''t to be assigned to variables');
         writeln('                 -Sa2 @-operator returns typed pointer');
         writeln('                 -Sa4 assigment results are typed (allows a:=b:=0)');
         writeln('                 -Sa9 allows expressions with no side effect');
         writeln('             -Sc supports operators like C (*=,+=,/= and -=)');
         writeln('             -Sg allows LABEL and GOTO');
         writeln('             -Si support C++ stlyed INLINE');
         writeln('             -Sm support macros like C (global)');
         writeln('             -So turns function oferloading off');
         writeln;
         writeln('             -Ss the name of constructors must be init');
         writeln('                 the name of destructors must be done');
         writeln('  -s     don''t call assembler and linker (only with -a)');
         writeln('  -T     target operating system');
         writeln('             -TDOS DOS extender by DJ Delorie');
         writeln('             -TOS2 OS/2 2.x');
         writeln('             -TLINUX Linux');
         write('*** press return ***');
         readln(s);
         writeln('          !  -TWin32 Windows 32 Bit');
         writeln('             -TGO32V2 version 2 of DJ Delorie DOS extender');
         writeln('  -U     unit options');
         writeln('             -Un don''t check the unit name');
         writeln('             -Us compile a system unit');
         writeln('             -Upxxxx adds xxxx to the unit path');
         writeln('  -vxxx  Be verbose. xxx is a combination of the following letters :');
         writeln('          e : Show errors (default)       i : Show general info');
         writeln('          w : Show warnings               l : Show linenumbers');
         writeln('          u : Show used files             t : Show tried files');
         writeln('          p : Show compiled procedures    c : Show conditionals');
         writeln('          d : Show debug info             m : Show defined macros');
         writeln('  -w-    turns warnings off (Obsolete, see -v) ');
{$ifdef linux}
         writeln('  -X     executable options (LINUX)');
         writeln('             -Xc link with the c library');
         writeln('             -Xe create ELF executable');
{$endif}
         writeln('  -h,-?  shows this help');
         halt(1);
      end;

    const
       read_options : boolean = true;

{ I-}
    procedure getparastring;

      procedure nextopt;

        begin
           endofparas:=false;
           opts:='';
           if read_configfile then
             begin
                readln(configfile,opts);
{$ifdef EXTDEBUG}
                writeln('config file line parameter   is #',opts,'#');
{$endif EXTDEBUG}
                if eof(configfile) then
                  begin
                     close(configfile);
                     read_options:=true;
                     read_configfile:=false;
                  end
             end
           else if res then
             begin
                readln(resf,opts);
{$ifdef EXTDEBUG}
                writeln(' @ config file line parameter   is #',opts,'#');
{$endif EXTDEBUG}
                if eof(resf) then
                  begin
                     close(resf);
                     read_options:=true;
                     res:=false;
                  end
             end
           else
             begin
                if i<paramcount then
                  begin
                     inc(i);
                     if i=paramcount then
                       endofparas:=true;
                     opts:=paramstr(i);
{$ifdef EXTDEBUG}
                     writeln('command line parameter  ',i,' is #',opts,'#');
{$endif EXTDEBUG}
                     if opts[1]='@' then
                       begin
                          res:=true;
                          assign(resf,copy(opts,2,length(opts)-1));
                          comment(v_info,'Reading further options from : '+copy(opts,2,length(opts)-1));
                          reset(resf);
                          getparastring;
                       end;
                  end;
             end;
        end;

      var
         hp : pstring_item;

      begin
         while true do
           begin
              nextopt;
              if endofparas then
                exit;
              if upper(copy(opts,1,9))='#SECTION ' then
                begin
                   { cut off trailing spaces }
                   while (opts[length(opts)]=#9) or (opts[length(opts)]=' ') do
                     dec(byte(opts[0]));
                   if upper(copy(opts,10,length(opts)-9))='COMMON' then
                     read_options:=true
                   else
                     begin
                        read_options:=false;
                        hp:=pstring_item(commandlinedefines.first);
                        while assigned(hp) do
                          begin
                             if upper(copy(opts,10,length(opts)-9))=hp^.str^ then
                               begin
                                  read_options:=true;
                                  break;
                               end;
                             hp:=pstring_item(hp^.next);
                          end;
                     end;
                   { now we must start the loop, one time more to read the
                     next option
                   }
                end
              else
                { no directive }
                if read_options then
                  break;
           end;
      end;

    procedure info_d;

      begin
         writeln('FPKPascal  Version ',version_string,'    ',copyright);
{$ifdef inc_date}
         writeln('Freigegeben am: ',released);
{$endif}
         writeln('Dieses Programm darf verwenden, verndert und weiter-');
         writeln('gegebenwerden, solange daraus niemand finanzielle Vorteile');
         writeln('entstehen. Beim Weitergeben darf eine Kopiergebhr');
         writeln('von maximal 15 DM verlangt werden (inkl. aller dazu-');
         writeln('gehrigen Leistungen wie Datentrger...)');
         writeln('Sollte das Programm kommerziell eingesetzt werden,');
         writeln('so ist mit mir zwecks Lizenzgebhren Verbindung');
         writeln('aufzunehmen. Adresse siehe unten');
         writeln('Wenn Sie im Programm einen Fehler entdecken oder ');
         writeln('Verbesserungsvorschlge haben, so informieren Sie');
         writeln('bitte mich (Fehler bitte mit Angabe der Compiler-');
         writeln('version und problematischem Quelltext):');
         writeln;
         writeln;
         writeln('	  EMail: klaempfl@haegar.cip.mw.tu-muenchen.de');
          halt(1);
      end;

    procedure info_e;

      begin
         writeln('FPKPascal  Version ',version_string,'    ',copyright);
         writeln;
         writeln('FPKPascal comes without any warranty.');
         writeln('This program can be modified, used and distributed');
         writeln('if noboby gets money. A donation for copying of');
         writeln('$10 is allowed.');
         writeln;
         writeln('Report bugs,suggestions etc to:');
         writeln('      klaempfl@haegar.cip.mw.tu-muenchen.de');
         halt(1);
      end;

    procedure setbool(var b : boolean);

      begin
         if length(opts)=2 then b:=true
         { -q-- is possible, so we have to change this... }
         else if (length(opts)=3) or (opts[2]='q') then
            begin
               if opts[3]='+' then b:=true
               else if opts[3]='-' then b:=false
               else illparas;
            end
         else illparas;
      end;

    procedure def_symbol(const s : string);

      begin
         commandlinedefines.concat(new(pstring_item,init(upper(s))));
      end;

    var
       code : word;
       configpath,hs : string;

    begin
       veryverbose:=false;
       res:=false;
       i:=0;
       p:='';
       if paramcount=0 then
         case language of
            'D' : printhilfe_d;
            'E' : printhilfe_e;
         end;

       { search config file: }
       { first current path ... }
       def_symbol(target_info.short_name);
       def_symbol('FPK');
       def_symbol('VER'+version_nr);
       def_symbol('VER'+version_nr+'_'+release_nr);
       def_symbol('VER'+version_nr+'_'+release_nr+'_'+patch_nr);

{$ifndef linux}
       configpath:=inputdir;
       errorfilename:=exepath+'\ERROR'+language+'.MSG';
{$else}
       configpath:=dos.getenv('PPC_CONFIG_PATH');
       if configpath='' then
         configpath:='/etc/'
       else if configpath[length(configpath)]<>'/' then
         configpath:=configpath+'/';
       gcclibpath:=dos.getenv('PPC_GCCLIB_PATH');
       errorfilename:=dos.getenv('PPC_ERROR_FILE');
       { we need some default... }
       if errorfilename='' then
          errorfilename:='/usr/lib/ppc/errorE.msg';
{$endif}
       { lower case for LINUX etc. }
       assign(configfile,configpath+'ppc386.cfg');
{$I-}
       reset(configfile);
       if ioresult<>0 then
         begin
            { ... second the compiler path }
            assign(configfile,exepath+'ppc386.cfg');
            reset(configfile);
{$I+}
            if ioresult<>0 then
              read_configfile:=false
            else
              read_configfile:=true;
         end
       else
         read_configfile:=true;

       endofparas:=false;
       while not(endofparas) do
         begin
            getparastring;
{$ifdef EXTDEBUG}
            writeln('Parameter : ',opts);
{$endif EXTDEBUG}
            if opts='' then
              continue;
            if (opts[1]='-') then
              begin
                 case opts[2] of
                    'h','?' : if length(opts)=2 then
                                case language of
                                   'D' : printhilfe_d;
                                   'E' : printhilfe_e;
                                end;
                    'a'     : writeasmfile:=true;
                    'A'     : begin
                                 if copy(opts,3,length(opts)-2)='o' then
                                   output_format:=of_o
                                 else if copy(opts,3,length(opts)-2)='wasm' then
                                   output_format:=of_wasm
                                 else if copy(opts,3,length(opts)-2)='att' then
                                   output_format:=of_att
                                 else if copy(opts,3,length(opts)-2)='obj' then
                                   output_format:=of_obj
                                 else if copy(opts,3,length(opts)-2)='nasm' then
                                   output_format:=of_nasm
                                 else illparas;
                              end;
{$ifdef tp}
                    'b'     : setbool(use_big);
{$endif}
                    'B'     : if length(opts)=2 then
                                do_build:=true
                              else illparas;
                    'C'     : begin
                                 for j:=3 to length(opts) do
                                 case opts[j] of
                                     'a' : ;
                                     'e' : ;
                                     'h' : begin
                                              val(copy(opts,j+1,length(opts)-j),heapsize,code);
                                              if (code<>0) or (heapsize>=67107840) or
                                                (heapsize<1024) then
                                                illparas;
                                              break;
                                           end;
                                     'i' : initswitches:=initswitches+[cs_iocheck];
                                     'o' : initswitches:=initswitches+[cs_check_overflow];
                                     'r' : initswitches:=initswitches+[cs_rangechecking];
                                     's' : begin
                                              val(copy(opts,j+1,length(opts)-j),stacksize,code);
                                              if (code<>0) or (stacksize>=67107840) or
                                                (stacksize<1024) then
                                                illparas;
                                              break;
                                           end;
                                     { this is not a very good choice for that }
                                     't' : initswitches:=initswitches+[cs_check_stack];
                                     else illparas;
                                 end;
                              end;
                    'd'     : def_symbol(copy(opts,3,255));
                    'D'     : begin
                                 for j:=3 to length(opts) do
                                 case opts[j] of
                                     'd' : begin
                                              description:=copy(opts,j+1,length(opts)-j);
                                              break;
                                           end;
                                     'o' : gendeffile:=true;
                                     'w' : genpm:=true;
                                     else illparas;
                                 end;
                              end;
{$ifdef linux}
                    'e'     : if length(opts)>2 then
                                begin
                                   exepath:=copy(opts,3,length(opts)-2);
                                   if exepath[length(exepath)]<>'/' then
                                     exepath:=exepath+'/'
                                end;
{$endif}
                    'F'     : begin
                                   case opts[3] of
                                      'e' : begin
                                               errortext:=true;
                                               assign(errorfile,
                                                 copy(opts,4,length(opts)-3));
                                               {$I-}
                                               rewrite(errorfile);
{$ifdef TP}
                                               {$I+}
{$endif}
                                               if ioresult<>0 then
                                                 case language of
                                                    'D' : error('Fehlerlogdatei kann nicht geffnet werden');
                                                    'E' : error('Can''t open error log file');
                                                 end;
                                               break;
                                            end;
                                      'g' : gcclibpath:=copy(opts,4,length(opts)-3);
                                      'r' : errorfilename:=copy(opts,4,length(opts)-3);
                                    else illparas;
                                 end;
                              end;
                    'g'     : begin
                              initswitches:=initswitches+[cs_debuginfo];
                              if length(opts)>2 then
                                 for j:=3 to length(opts) do
                                 case opts[j] of
{$ifdef GDB}
                                     'g' : use_gsym:=true;
                                     'd' : use_dbx:=true;
{$else GDB}
                                     'g' : ;
{$endif GDB}
                                     else illparas;
                                 end;
                              end;
                    'i'     : case language of
                                 'D' : info_d;
                                 'E' : info_e;
                              end;

                    'l'     : begin
                                 if length(opts)<>2 then
                                   illparas;
                                 write('FPKPascal  Version ',version_string);
{$ifdef inc_date}
                                 case language of
                                    'D' : write(' vom ',released);
                                    'E' : write(' of ',released);
                                 end;
{$endif}
                                 writeln;
                                 writeln(copyright);
                              end;
                    'L'     : begin
                                 if length(opts)<>3 then
                                   illparas;
                                 case opts[3] of
                                    'E' : language:='E';
                                    'D' : language:='D';
                                    else illparas;
                                 end
                              end;
{$ifdef Splitheap}
                    'p'     : testsplit:=true;
{$endif Splitheap}
                    'q'     : begin
                                 setbool(quiet);
                                 verbosity:=verbosity or V_Info;
                                 if length(opts)=4 then
                                   if (opts[4]='-') then
                                     begin
                                     verbosity:=verbosity or V_Used;
                                     verbosity:=verbosity or V_Tried;
                              end;
                              end;
                    'O'     : begin
                                 for j:=3 to length(opts) do
                                 case opts[j] of
                                    'a' : initswitches:=initswitches+[cs_optimize];
                                    'g' : initswitches:=initswitches+[cs_littlesize];
                                    'G' : initswitches:=initswitches-[cs_littlesize];
                                    'x' : initswitches:=initswitches+[cs_optimize,
                                           cs_maxoptimieren];
                                    '3' : opt_processors:=globals.i386;
                                    '4' : opt_processors:=i486;
                                    '5' : opt_processors:=pentium;
                                    '6' : opt_processors:=pentiumpro;
                                    else illparas;
                                 end;
                              end;
                    's'     : setbool(externasm);
                    'S'     : begin
                                 for j:=3 to length(opts) do
                                   case opts[j] of
                                     'a' : begin
                                              if j<length(opts) then inc(j)
                                                else illparas;
                                              val(opts[j],initexprlevel,code);
                                              if code<>0 then
                                                illparas;
                                           end;
{$ifdef BPscan}
                                     {$IfDef TP_Comp}
                                     'b' : TP_Comp := True;
                                     {$EndIf TP_Comp}
{$endif * BPscan *}
                                     'c' : c_like_operators:=true;
                                     'g' : initswitches:=initswitches+[cs_support_goto];
                                     'i' : support_inline:=true;
                                     'm' : begin
                                              { init macro buffer }
                                              if not(support_macros) then
                                                new(macrobuffer);
                                              support_macros:=true;
                                           end;
                                     'o' : initswitches:=initswitches+[cs_no_overloaded_procedures];
                                     {
                                     'n' : initswitches:=initswitches-[cs_genexceptcode];
                                     }
                                     's' : initswitches:=initswitches+[cs_checkconsname];
                                     else illparas;
                                   end;
                              end;
                    'T'     : begin
                                 hs:='';
                                 hs:=copy(opts,3,length(opts)-2);
                                 if not(set_string_target(hs)) then
                                   illparas;
                              end;
                    'U'     : begin
                                 for j:=3 to length(opts) do
                                   case opts[j] of
                                     's' : initswitches:=initswitches+[cs_compilesystem];
                                     'n' : initswitches:=initswitches+[cs_check_unit_name];
                                     'p' : begin
                                              if (length(unitsearchpath)>0) and
                                                (unitsearchpath[length(unitsearchpath)]<>';') then
                                                unitsearchpath:=unitsearchpath+';';
                                              unitsearchpath:=unitsearchpath+
                                                copy(opts,j+1,length(opts)-j);
                                              break;
                                           end;
                                     else illparas;
                                   end;
                              end;
                    'v' : if not(setverbosity(copy(opts,3,length(opts)-2))) then
                            illparas;
                    'w'     : begin
                                 setbool(warnings);
                                 Verbosity:=Verbosity or V_Warning;
                              end;

                    { Control the type of executable (Linux only) }
{$ifdef linux}
                    'X'     : begin
                                 linux_elf:=false;
                                 linux_Linktoc:=false;
                                 for j:=3 to length(opts) do
                                   case opts[j] of
                                     'c' : linux_linktoc:=true;
                                     'e' : linux_elf:=true
                                     else illparas;
                                   end;
                             end;
{$endif}
                    else illparas;
                 end
              end
            else if opts[1]='@' then
              begin
                 case language of
                    'D' : writeln('Response-Dateiangaben in Response-Dateien werden nicht untersttzt');
                    'E' : writeln('nested response files are not supported');
                 end;
{$ifndef muller}
                 halt(1);
{$else * muller *}
                 runerror(190);
{$endif * muller *}
              end
            else
              begin
                 if length(p)<>0 then
                   case language of
                      'D' : error('Es kann nur eine Quelldatei angegeben werden');
                      'E' : error('Only one source file supported');
                   end;
                 p:=opts;
              end;
         end;
       if p='' then
         case language of
            'D' : error('Keine Quelldatei angegeben');
            'E' : error('No source file name in command line');
         end;
{$ifndef linux}
       p:=upper(p);
{$endif}
       fsplit(p,d,n,inputextension);
       if inputextension='' then
       inputextension:=target_info.sourceext;

       inputfile:=n;
       inputdir:=d;
       if gendeffile then
         begin
            if target_info.target<>target_OS2 then
              case language of
                 'D' : error('DEF-Datei kann nur fr OS/2 erzeugt werden');
                 'E' : error('DEF file can be created only for OS/2');
              end;
            assign(defdatei,inputdir+inputfile+'.DEF');
            {$I-}
            rewrite(defdatei);
{$ifdef TP}
            {$I+}
{$endif}
            if ioresult<>0 then
              case language of
                 'D' : error('DEF-Datei kann nicht erzeugt werden');
                 'E' : error('DEF file can''t be created');
              end;
            write(defdatei,'NAME '+inputfile);
            if genpm then
              write(defdatei,' WINDOWAPI');
            writeln(defdatei,#13#10#13#10'PROTMODE'#13#10);
            writeln(defdatei,'DESCRIPTION '+''''+description+''''#13#10);
            writeln(defdatei,'DATA'#9'MULTIPLE'#13#10);
            writeln(defdatei,'STACKSIZE'#9+tostr(stacksize));
            writeln(defdatei,'HEAPSIZE'#9+tostr(heapsize)+#13#10);
            write(defdatei,'EXPORTS');
         end;
    end;

  function print_status(const status : tcompilestatus) : boolean;far;

    var temp1,temp2 : string;

    begin
       print_status:=false;
            if (abslines=1) then
         begin
              str (memavail div 1024,temp1);
              case language of
                 'E' : Comment (V_Info,temp1+' kB free');
                 'D' : Comment (V_Info,temp1+' kB frei');
              end;
              end;
            if (status.currentline mod 100=0) then
               begin
                  { ESC stops the compiler
                  if keypressed then
                    begin
                       if readkey=#27 then
                         print_status:=false;
                    end;
                  }
                  str (status.currentline,temp1);
                  str (memavail div 1024,temp2);
                  case language of
                     'E' : Comment (V_Linenrs, temp1+' lines  '+temp2+' kB free');
                     'D' : Comment (V_Linenrs, temp1+' Zeilen  '+temp2+' kB frei');
                  end;
{$ifdef tp}
                  if (use_big) then
                    begin
                    str (symbolstream.getsize div 1024,temp1);
                    case language of
                       'E' : Comment (V_Info,' '+temp1+' kB EMS used');
                       'D' : Comment (V_Info,' '+temp1+' kB EMS benutzt');
                    end;
                    end;
{$endif}
               end;
         end;

  function getrealtime : real;

    var
       h,m,s,s100 : word;

    begin
       dos.gettime(h,m,s,s100);
       getrealtime:=h*3600.0+m*60.0+s+s100/100.0;
    end;

  var
     starttime : single;
     data_size : longint;
     hs1 : namestr;
     hs2 : extstr;
     start : real;
     oldexit : pointer;

{$ifdef GDB}
{$S-}
{$endif * GDB *}
  procedure myexit;far;

    begin
{$ifdef GDB}
       {this must be at the beginning otherwise if there is an error
       inside the exit proc you cycle endlessly !!!}
       exitproc:=oldexit;
{$endif * GDB *}
       if gendeffile then
         close(defdatei);
       { Fehlerdatei schlieen }
       if errortext then
         close(errorfile);
{$ifdef tp}
       if use_big then
         symbolstream.done;
       if (erroraddr<>nil) then
         case exitcode of
            203 : begin
{$ifndef GDB}
                     erroraddr:=nil;
{$else GDB}
                     {erroraddr:=nil;}
{$endif GDB}
                     case language of
                        'D' : Comment (V_Error, 'Nicht gengend Speicher');
                        'E' : Comment (V_Error, 'Out of memory');
                     end;
                  end;
            202 : begin
{$ifndef GDB}
                     erroraddr:=nil;
{$else GDB}
                     { erroraddr:=nil; }
{$endif GDB}
                     case language of
                        'D' : Comment (V_Error, 'Stackberlauf');
                        'E' : Comment (V_Error, 'Stack overflow');
                     end;
                  end;
         end;
{$endif}
{$ifndef GDB}
       exitproc:=oldexit;
{$endif not GDB}
    end;

{$ifdef tp}
  procedure do_streamerror;far;

     var temp : string;
    
    begin
       if symbolstream.status=-2 then
         case language of
            'D' : Comment (V_Error,'Nicht gengend EMS-Speicher');
            'E' : Comment (V_error,'Not enough EMS memory');
         end
       else
         begin
         str (symbolstream.status,temp);
         case language of
            'D' : writeln('Fehler '+temp+' bei der Nutzung von EMS');
            'E' : writeln('error '+temp+' when using EMS');
         end;
         end;
  {$ifndef MULLER}
       halt(1);
  {$else MULLER}
       runerror(190);
  {$endif MULLER}
    end;
{$endif}

  var
    hs3 : string;
    i : longint;
    r : real;

begin
   start:=getrealtime;
{$ifdef MULLER}
  {$ifdef DPMI}
   HeapBlock:=$ff00;
{$endif DPMI}
{$endif MULLER}

{$ifdef CLEANUP}
   EntryMemAvail := MemAvail;
{$endif}
   hs3:=paramstr(0);

{$ifdef DOS}
{$ifdef FPK}
   for i:=1 to length(hs3) do
     if hs3[i]='/' then
       hs3[i]:='\';
{$endif}
{$endif}

   { get the path to the PPC386.EXE }
   fsplit(hs3,exepath,hs1,hs2);

{$ifdef LINUX}
   if dos.getenv('PPC_EXEC_PATH')<>'' then
     begin
        exepath:=dos.getenv('PPC_EXEC_PATH');
        if exepath[length(exepath)]<>'/' then
          exepath:=exepath+'/'
     end
   else
     exepath:='/usr/bin/';
{$endif}

   getdir(0,unitsearchpath);

   { set unit search path }
   if exepath<>'' then
     unitsearchpath:=unitsearchpath+';'+exepath+';'+dos.getenv(target_info.unit_env)
   else
     unitsearchpath:=unitsearchpath+';'+dos.getenv(target_info.unit_env);

{$ifdef FPK}
   compilestatusproc:=@print_status;
{$else}
   compilestatusproc:=print_status;
{$endif}

   { init some units }
   { inits only node management }
   init_tree;

   globalsinit;
   init_symtable;

   { call  *** after ***  init_symtable because macro }
   { symtable must be inited...                       }
   init;
{$ifdef tp}
{$Ifndef dpmi}
   if use_big then
     begin
        streamerror:=@do_streamerror;
        {
        symbolstream.init('TMPFILE',stcreate,16000);
        }
        symbolstream.init(10000,4000000);
        if symbolstream.errorinfo=stiniterror then
          do_streamerror;
        { write something, because pos 0 means nil pointer }
        symbolstream.writestr(@inputfile);
     end;
{$endif not dpmi}
{$endif tp}
   oldexit:=exitproc;
   exitproc:=@myexit;
   comment (V_Info, 'Compiler: '+hs3);
   comment (V_Info, 'Units are searched in: '+unitsearchpath);
   comment (V_Used, 'Using error file: '+errorfilename);
   comment (V_Used, 'Using executable path: '+exepath);
   comment (V_Info, 'Target OS: '+target_info.target_name);
{$ifdef linux}
   comment (V_Used, 'GCC library is in: '+gcclibpath);
{$endif}

   { do some definitions which are done only once }
   initparser;

   compile(inputdir,inputfile,inputextension,false);

   if codegeneration then
     begin
        r:=getrealtime-start;
        { str(r:0:1,temp) won't work }
        temp:=tostr(trunc(r))+'.'+tostr(trunc(frac(r)*10))+' sec';
        case language of
           'D' : Comment (V_Info,tostr(abslines)+' Zeilen bersetzt, '+temp);
           'E' : Comment (V_Info,tostr(abslines)+' lines compiled, '+temp);
        end;
     end;

   clearnodes;
   done_symtable;
   erase_errorlist;
{$ifdef EXTDEBUG}
   str (EntryMemAvail-MemAvail,temp);
   Comment (V_Info,'Memory lost = '+temp);
   {$ifdef fpk}
   { writeln('lowest stack = ',loweststack,' stack bottom = ',stackbottom); }
   {$endif fpk}
{$endif EXTDEBUG}
   halt(0);
end.
