{$ifdef tp}
{$E+}
{$N+}
{$D+}
{$endif}
{****************************************************************************

                 Copyright (c) 1993,97 by Florian Klaempfl

 ****************************************************************************}

{
  this unit does the parsing process for FPK-Pascal

  + feature added
  - removed
  * bug fixed or changed

  History (started with version 0.9.0):
       5th november 1996:
         * adapted to 0.9.0
      25th november 1996:
         * more stuff adapted
       9th december 1996:
         * support for different inline assemblers added
}

unit parser;

  interface

    uses
       dos,objects,cobjects,globals,errors,scanner,systems,symtable,tree,aasm,
       types,strings,pass_1,hcodegen,files
{$ifdef i386}
       ,i386
       ,cgi386
       ,cgai386
       { inline Assembler }
       ,rai386
       ,ratti386
       ,radi386
       ,rasm386
       ,tgeni386
       ,aopt386
       ,attasmi3
       ,intasmi3
{$endif i386}
{$IfDef GDB}
       ,gdb
{$endif GDB}
       ;

    procedure compile(const path,filename,ext : string;compile_system : boolean);
    procedure initparser;

    const
       heapsize : longint = 4000000;
       stacksize : longint = 8192;
       compile_level : word = 0;

  implementation

    {$I innr.inc}

    var
       asmres : text;
       token : ttoken;
       datasize : longint; { Gre des Datensegmentes, wird von proc_unit }
                           { oder proc_program gesetzt                    }

       refsymtable : psymtable; { Symboltabelle in welcher die          }
                                { Unitreferenzen abgelegt werden sollen }

       parse_only : boolean; { wird auf true gesetzt, wenn              }
                             { nur Funktionskpfe geparst werden sollen }

       { contains the units which must be initilizied or linked }
       usedunits : tlinkedlist;

    const
       { forward types should only be possible inside  }
       { a TYPE statement, this crashed the compiler   }
       { when trying to dispose local symbols          }
       typecanbeforward : boolean = false;

    function befehlsblock : ptree;forward;
    function statement : ptree;forward;
    function typ(const name : stringid) : pdef;forward;
    function expr : ptree;forward;
    function block : ptree;forward;
    function assembler_block : ptree;forward;
    procedure proc_head;forward;
    procedure formal_parameter_list;forward;

    { versucht das Token i zu consumieren, pat }
    { das Token nicht, so wird ein Syntaxfehler }
    { ausgegeben                                }

    procedure consume(i : ttoken);

      { generates a syntax error message }

      procedure syntaxerror(const s : string);

        begin
           case language of
              'D' : exterror:=strpnew(s+' erwartet. ');
              'E' : exterror:=strpnew(s+' expected. ');
           end;
           error(syntax_error);
        end;

      const tokens : array[PLUS..CCHAR] of string[12] = (
                 '+','-','*','/','=','>','<','[',']',
                 '.',',','(',')',':',';','^',
                 '@',':=','<>','>=','<=','..',
                 'identifier','const real.','end of file',
                 'ord const','const string','const char');

      var
         j : integer;

      begin
         if token<>i then
           begin
              if i<_ABSOLUTE then
                syntaxerror(tokens[i])
              else
                begin

                   { um die Programmgre klein zu halten, }
                   { wird fr ein Schlsselwort-Token der  }
                   { "Text" in der Schlsselworttabelle    }
                   { des Scanners nachgeschaut             }

                   for j:=1 to anz_keywords do
                     if keyword_token[j]=i then
                       syntaxerror(keyword[j])
                end;
           end
         else
           token:=yylex;
      end;

    { reads a list of identifiers in a string container }

    function idlist : pstringcontainer;

      var
         sc : pstringcontainer;

      begin
         sc:=new(pstringcontainer,init);
         repeat
           sc^.insert(pattern);
           consume(ID);
           if token=COMMA then consume(COMMA)
             else break
         until false;
         idlist:=sc;
      end;

    procedure label_dec;

      var
         hl : tlabel;

      begin
         consume(_LABEL);
         if not(cs_support_goto in aktswitches)
           then error(goto_label_not_support);
         repeat
           if (token<>ID) and (token<>INTCONST) then
             consume(ID)
           else
             begin
                getlabel(hl);
                symtablestack^.insert(new(plabelsym,init(pattern,hl)));
                consume(token);
             end;
           if token<>SEMICOLON then consume(COMMA);
         until (token<>ID) and (token<>INTCONST);
         consume(SEMICOLON);
      end;

    { fgt die Symbole aus sc mit def in st ein  }
    { entfernt sc!                               }

    procedure insert_syms(st : psymtable;sc : pstringcontainer;def : pdef);

      var
         s : string;

      begin
         s:=sc^.get;
         while s<>'' do
           begin
              st^.insert(new(pvarsym,init(s,def)));
              s:=sc^.get;
           end;
         dispose(sc,done);
      end;

    { liest einen einzelnen Stringtyp mit optionaler }
    { Lngenangabe und gibt einen Pointer auf die    }
    { Definition zurck                              }

    function stringtyp : pdef;

      var
         p : ptree;
         d : pdef;

      begin
         consume(_STRING);
         if token=LECKKLAMMER then
           begin
              consume(LECKKLAMMER);
              p:=expr;
              do_firstpass(p);
              if not is_constintnode(p) then
                error(error_in_expression);
              if (p^.value<1) or (p^.value>255) then
                begin
                   error(string_too_long);
                   p^.value:=255;
                end;
              consume(RECKKLAMMER);
              d:=new(pstringdef,init(p^.value));
{$ifdef CleanUp}
              disposetree(p);
{$endif * CleanUp *}
           end
{$ifndef GDB}
         else d:=new(pstringdef,init(255));
{$else * GDB *}
         else d:=globaldef('SYSTEM.STRING');
{$endif * GDB *}
         stringtyp:=d;
      end;

    var
       { Zeiger auf das zuletzt gelesene Typsymbol }
       { (fr "forward"-Typen)                     }
       lasttypesym : ptypesym;
       { "Krcken"konstruktion um das Problem zu beheben, da     }
       { der Typ der momentan geparst werdenden Objektdeklaration }
       { als Funktionsparameter verwendet werden kann             }
       testaktobject : byte;
       aktobjectname : stringid;
       aktobjectdef : pdef;


    { liest einen Typbezeichner und gibt einen }
    { Pointer auf die Definition zurck        }
    { s ist der Name des Typs                  }

    function id_type(var s : string) : pdef;

      begin
         s:=pattern;
         consume(ID);
         if (testaktobject=2) and (aktobjectname=pattern) then
           begin
              id_type:=aktobjectdef;
              exit;
           end;
         getsym(s,true);
         if assigned(srsym) then
           begin
              if srsym^.typ=unitsym then
                begin
                   consume(POINT);
                   getsymonlyin(punitsym(srsym)^.unitsymtable,pattern);
                   s:=pattern;
                   consume(ID);
                end;
              if srsym^.typ<>typesym then
                begin
                   error(type_id_expect);
                   lasttypesym:=ptypesym(srsym);
                   id_type:=generrordef;
                   exit;
                end;
           end;
         lasttypesym:=ptypesym(srsym);
         id_type:=ptypesym(srsym)^.definition;
      end;

    { liest einen String oder Typbezeichner }
    { und gibt einen Pointer auf die        }
    { Definition zurck                     }

    function single_type(var s : string) : pdef;

      var
         hs : string;

      begin
         case token of
            _STRING : begin
                         single_type:=stringtyp;
                         s:='STRING';
                         lasttypesym:=nil;
                      end;
            _FILE : begin
                       consume(_FILE);
                       if token=_OF then
                         begin
                            consume(_OF);
                            single_type:=new(pfiledef,init(ft_typed,single_type(hs)));
                            s:='FILE$OF$'+hs;
                            lasttypesym:=nil;
                         end
                       else
                         begin
                            single_type:=new(pfiledef,init(ft_untyped,nil));
                            s:='FILE';
                         end;
                       lasttypesym:=nil;
                    end;
            else single_type:=id_type(s);
         end;
      end;

    { liest die Feldliste eines Records in }
    { symtablestack ein                    }
    { wenn record=false, dann knnen auch  }
    { Klassenfelder eingelesen werden, da  }
    { variante Recordkonstruktionen igno-  }
    { riert werden                         }
    { do_absolute, gibt an, ob ABSOLUTE,   }
    { sowie Dateitypen erlaubt sind        }

    procedure feldliste(is_record : boolean;do_absolute : boolean);

      var
         sc : pstringcontainer;
         s : stringid;
         p,casedef : pdef;
         hs : string;
         { maxsize enthlt maximale Gre eines varianten Astes }
         { startvarrec die Startaddresse des varianten Teiles }
         maxsize,startvarrec : longint;
         pt : ptree;
         old_parse_types : boolean;
         { to handle absolute }
         abssym : pabsolutesym;
      begin
         old_parse_types:=parse_types;
         parse_types:=true;
         while token=ID do
           begin
              sc:=idlist;
              consume(COLON);
              p:=typ('');
              if do_absolute and (token=_ABSOLUTE) then
                begin
                   s:=sc^.get;
                   while s<>'' do
                     begin
                        if sc^.get<>'' then
                          begin
                             exterror:=strpnew(' absolute can only be associated to ONE variable !!');
                             error(user_defined);
                          end;
                     end;
                   dispose(sc,done);
                   consume(_ABSOLUTE);
                   if token=id then
                     begin
                        getsym(pattern,true);
                        { we should check the result type of srsym }
                        if not (srsym^.typ in [varsym,typedconstsym]) then
                          begin
                             exterror:=strpnew(' absolute can only be associated a var or const !!');
                             error(user_defined);
                          end;
                        abssym:=new(pabsolutesym,init(s,p));
                        abssym^.typ:=absolutesym;
                        abssym^.ref:=srsym;
                        symtablestack^.insert(abssym);
                     end;
                end
              else
                begin
                   insert_syms(symtablestack,sc,p);
                end;
              if token<>SEMICOLON then
                break
              else
                consume(SEMICOLON);
              while token=SEMICOLON do
                consume(SEMICOLON);
           end;
         if (token=_CASE) and is_record then
           begin
              maxsize:=0;
              consume(_CASE);
              s:=pattern;
              getsym(s,false);
              { may be only a type: }
              if assigned(srsym) and ((srsym^.typ=typesym) or
              { and with unit qualifier: }
                (srsym^.typ=unitsym)) then
                begin
                   casedef:=single_type(hs);
                end
              else
                begin
                   consume(ID);
                   consume(COLON);

                   casedef:=single_type(hs);
                   symtablestack^.insert(new(pvarsym,init(s,casedef)));
                end;
              if not is_ordinal(casedef) then
                error(ordinal_expect);

              consume(_OF);
              startvarrec:=symtablestack^.datasize;
              repeat
                repeat
                  pt:=expr;
                  do_firstpass(pt);
                  if not(pt^.treetype=ordconstn) then
                    error(error_in_expression);
{$ifdef CleanUp}
                  disposetree(pt);
{$endif * CleanUp *}
                  if token=COMMA then consume(COMMA)
                    else break;
                until false;
                consume(COLON);
                consume(LKLAMMER);
                if token<>RKLAMMER then
                  feldliste(true,false);

                { calculates maximal variant size }
                maxsize:=max(maxsize,symtablestack^.datasize);

                { the items of the next variant are overlayed }
                symtablestack^.datasize:=startvarrec;
                consume(RKLAMMER);
                if token<>SEMICOLON then
                  break
                else
                  consume(SEMICOLON);
                while token=SEMICOLON do
                  consume(SEMICOLON);
              until (token=_END) or (token=RKLAMMER);

              { at last set the record size to that of the biggest variant }
              symtablestack^.datasize:=maxsize;
           end;
         parse_types:=old_parse_types;
      end;

    procedure _proc_head(options : word);forward;

    { this function parses an object or class declaration }
    function object_dec(const n : stringid) : pdef;

      type
         tzugriffsmode = (priv,prot,pub);

      var
         aktzugriffsmode : tzugriffsmode;
         there_are_a_destructor : boolean;
         is_a_class : boolean;
         childof : pobjectdef;
         aktclass : pobjectdef;

      procedure constructor_head;

        begin
           consume(_CONSTRUCTOR);
           _proc_head(poconstructor);

           if cs_checkconsname in aktswitches then
             if aktprocsym^.name<>'INIT' then
               error(konstrucname_init);

           consume(SEMICOLON);
{$ifndef CleanUp}
           {
           if is_a_class then
             begin
                aktprocsym^.definition^.retdef:=aktclass
             end
           else
           }
{$endif * not CleanUp *}
             begin
                { the return type is bool for OBJECTs }
              {$IfDef GDB}
              {GDB doesn't like unnamed types !}
              aktprocsym^.definition^.retdef:=
                globaldef('SYSTEM.BOOLEAN');
              {$Else * GDB *}
              aktprocsym^.definition^.retdef:=
                new(porddef,init(bool8bit,0,1));
              {$Endif * GDB *}

             end;
        end;

      procedure destructor_head;

        begin
           consume(_DESTRUCTOR);
           if cs_checkconsname in aktswitches then
             if aktprocsym^.name<>'DONE' then
               error(destrucname_done);
           _proc_head(podestructor);
           consume(SEMICOLON);
           if assigned(aktprocsym^.definition^.para1) then
             error(no_paras_2_destructor);
           { kein Rckgabetyp }
           aktprocsym^.definition^.retdef:=voiddef;
        end;

      procedure object_komponenten;

        var
           oldparse_only : boolean;

        begin
           testaktobject:=1;
           aktobjectname:=n;
           repeat
             case token of
                ID : feldliste(false,false);
                _PROCEDURE,_FUNCTION : begin
                               oldparse_only:=parse_only;
                               parse_only:=true;
                               proc_head;
                               parse_only:=oldparse_only;
                               if token=_VIRTUAL then
                                 begin
                                    if aktzugriffsmode=priv then
                                      error(priv_meth_not_virtual);
                                    consume(_VIRTUAL);
                                    consume(SEMICOLON);
                                    aktprocsym^.definition^.options:=
                                      aktprocsym^.definition^.options or povirtualmethod;

                                 end;
                               { Delphi II extension }
                               if (token=ID) and (pattern='ABSTRACT') then
                                 begin
                                    consume(ID);
                                    consume(SEMICOLON);
                                    if (aktprocsym^.definition^.options and povirtualmethod)<>0 then
                                      begin
                                         aktprocsym^.definition^.options:=
                                          aktprocsym^.definition^.options or
                                            poabstractmethod;
                                      end
                                    else
                                      error(only_virtual_methods_abstract);
                                    { the method is defined }
                                    aktprocsym^.definition^.forwarddef:=false;
                                 end
                            end;
                _CONSTRUCTOR : begin
                                  if aktzugriffsmode<>pub then
                                    error(const_cannot_priv);
                                  oldparse_only:=parse_only;
                                  parse_only:=true;
                                  constructor_head;
                                  parse_only:=oldparse_only;
                               end;
                _DESTRUCTOR : begin
                               if there_are_a_destructor then
                                 warning(only_one_destructor);
                               there_are_a_destructor:=true;
                               if aktzugriffsmode<>pub then
                                 error(dest_cannot_priv);
                               oldparse_only:=parse_only;
                               parse_only:=true;
                               destructor_head;
                               parse_only:=oldparse_only;
                               if token=_VIRTUAL then
                                 begin
                                    consume(_VIRTUAL);
                                    consume(SEMICOLON);
                                    aktprocsym^.definition^.options:=
                                      aktprocsym^.definition^.options or povirtualmethod;
                                 end;
                            end;
                _END,_PROTECTED,_PRIVATE,_PUBLIC : exit;
                else error(syntax_error);
             end;
           until false;
           testaktobject:=0;
        end;

      begin
         there_are_a_destructor:=false;
         aktzugriffsmode:=pub;

         { objects and class types can't be declared local }
         if (symtablestack^.symtabletype and $3fff<>globalsymtable) and
           (symtablestack^.symtabletype and $3fff<>staticsymtable) then
           error(no_local_objects);

         { also anonym objects aren't allow (o : object a : longint; end;) }
         if n='' then error(no_anonym_objects);

         { distinguish classes and objects }
         if token=_OBJECT then
           begin
              is_a_class:=false;
              consume(_OBJECT)
           end
         else
           begin
              is_a_class:=true;
              consume(_CLASS);
           end;

         { read the parent class }
         if token=LKLAMMER then
           begin
              consume(LKLAMMER);
              if token<>ID then
                consume(ID);
              getsym(pattern,true);
              if (srsym^.typ<>typesym) and
                 (ptypesym(srsym)^.definition^.deftype<>objectdef) then
                 begin
                    error(class_type_expect);
                    childof:=nil;
                 end
              else
                begin
                   childof:=pobjectdef(ptypesym(srsym)^.definition);

                   { a mix of class and object isn't allowed }
                   if (((childof^.options and oois_class)<>0) and not is_a_class) or
                      (((childof^.options and oois_class)=0) and is_a_class) then
                     error(mix_of_classes_and_objects);
                end;
              consume(ID);
              consume(RKLAMMER);
              aktclass:=new(pobjectdef,init(n,childof));
           end
         { if no parent class, then a class get tobject as parent }
         else if is_a_class then
           begin
              { is the current class tobject?        }
              { so you could define your own tobject }
              if n='TOBJECT' then
                begin
                   aktclass:=new(pobjectdef,init(n,nil));
                   class_tobject:=aktclass;
                end
              else
                begin
                   childof:=class_tobject;
                   aktclass:=new(pobjectdef,init(n,childof));
                end;
              { set the class attribute }
              aktclass^.options:=aktclass^.options or oois_class;
           end
         else aktclass:=new(pobjectdef,init(n,nil));

         aktobjectdef:=aktclass;

         { default access is public }
         aktzugriffsmode:=pub;
         aktclass^.publicsyms^.next:=symtablestack;
         symtablestack:=aktclass^.publicsyms;
         procinfo._class:=aktclass;

         while token<>_END do
           begin
              if token=_PRIVATE then
                begin
                   consume(_PRIVATE);
                   {
                   symtablestack:=symtablestack^.next;
                   _class^.privatesyms^.next:=symtablestack;
                   symtablestack:=_class^.privatesyms;
                   aktzugriffsmode:=priv;
                   }
                end;
              if token=_PROTECTED then
                begin
                   consume(_PROTECTED);
                   {
                   symtablestack:=symtablestack^.next;
                   _class^.protectedsyms^.next:=symtablestack;
                   symtablestack:=_class^.protectedsyms;
                   aktzugriffsmode:=prot;
                   }
                end;
              if token=_PUBLIC then
                begin
                   consume(_PUBLIC);
                   symtablestack:=symtablestack^.next;
                   aktclass^.publicsyms^.next:=symtablestack;
                   symtablestack:=aktclass^.publicsyms;
                   aktzugriffsmode:=pub;
                end;
              object_komponenten;
           end;
         consume(_END);


{$ifdef GDB}
         { generate the VMT }
         if cs_debuginfo in aktswitches then
           begin
              do_count_dbx:=true;
              debuglist^.concat(new(pai_stabs,init(strpnew('"vmt_'+aktclass^.owner^.name^+n+':S'+
                typeglobalnumber('__vtbl_ptr_type')+'",'+tostr(N_STSYM)+',0,0,'+aktclass^.vmt_mangledname))));
           end;
         datasegment^.concat(new(pai_symbol,init_global(aktclass^.vmt_mangledname)));
{$endif * GDB *}

         { determine the size with publicsyms^.datasize, because }
         { size gives back 4 for CLASSes                         }
         datasegment^.concat(new(pai_const,init_32bit(aktclass^.publicsyms^.datasize)));
         datasegment^.concat(new(pai_const,init_32bit(-aktclass^.publicsyms^.datasize)));

         { write pointer to parent VMT, this isn't implemented in TP }
         if assigned(aktclass^.childof) then
           datasegment^.concat(new(pai_const,init_symbol(strpnew('VMT_'+aktclass^.childof^.owner^.name^+'$_'+
           aktclass^.childof^.name^))))
         else
           datasegment^.concat(new(pai_const,init_32bit(0)));

         { this generates the entries }
         genvmt(aktclass);

         { restore old state }
         symtablestack:=symtablestack^.next;
         procinfo._class:=nil;

         object_dec:=aktclass;
      end;

    { liest eine Recorddefinition und gibt }
    { einen Pointer darauf zurck          }

    function record_dec : pdef;

      var
         symtable : psymtable;

      begin
         symtable:=new(psymtable,init(recordsymtable));
         symtable^.next:=symtablestack;
         symtablestack:=symtable;
         consume(_RECORD);
         feldliste(true,false);

         { may be scale record size to a size of n*4 ? }
         if ((symtablestack^.datasize mod aktpackrecords)<>0) then
           inc(symtablestack^.datasize,aktpackrecords-(symtablestack^.datasize mod aktpackrecords));

         consume(_END);
         symtablestack:=symtable^.next;
         record_dec:=new(precdef,init(symtable));
      end;

    { reads a type definition and returns a pointer to it }

    function typ(const name : stringid) : pdef;

      var
         procvardef : pprocvardef;

      procedure handle_procvar;

        var
           sc : pstringcontainer;
           s : string;
           p : pdef;
           varspez : tvarspez;

        begin
           procvardef:=new(pprocvardef,init);
           if token=LKLAMMER then
             begin
                consume(LKLAMMER);
                inc(testaktobject);
                repeat
                  if token=_VAR then
                    begin
                       consume(_VAR);
                       varspez:=vs_var;
                    end
                  else if token=_CONST then
                    begin
                       consume(_CONST);
                       varspez:=vs_const;
                    end
                  else varspez:=vs_value;
                  sc:=idlist;
                  if token=COLON then
                    begin
                       consume(COLON);
                       p:=single_type(s);
                    end
                  else
                    p:=new(pformaldef,init);
                  s:=sc^.get;
                  while s<>'' do
                    begin
                       procvardef^.concatdef(p,varspez);
                       s:=sc^.get;
                    end;
                  dispose(sc,done);
                  if token=SEMICOLON then consume(SEMICOLON)
                    else break;
                until false;
                dec(testaktobject);
                consume(RKLAMMER);
             end;
        end;

      var
         hp1,p : pdef;
         pt : ptree;
         aufdef : paufzaehldef;
{$ifdef GDB}
         aufsym : paufzaehlsym;
{$endif * GDB *}
         ap : parraydef;
         s : stringid;
         l : longint;
         hs : string;

      begin
         case token of
            ID,_STRING,_FILE : p:=single_type(hs);
            LKLAMMER :
                  begin
                     consume(LKLAMMER);
                     l:=-1;
{$ifdef GDB}
                     aufsym := Nil;
{$endif * GDB *}
                     aufdef:=new(paufzaehldef,init);
                     repeat
                       s:=pattern;
                       consume(ID);
                       if token=ASSIGNMENT then
                         begin
                            consume(ASSIGNMENT);
                            pt:=expr;
                            do_firstpass(pt);
                            if not is_constintnode(pt) then
                              error(error_in_expression)
                            else l:=pt^.value;
                            if pt^.value<=l then
                              error(dup_enum);
                            disposetree(pt);
                         end
                       else
                         inc(l);
                       constsymtable^.insert(new(paufzaehlsym,init(s,aufdef,l)));
                       if token=COMMA then consume(COMMA)
                         else break;
                     until false;
                     aufdef^.max:=l;
                     p:=aufdef;
                     consume(RKLAMMER);
                  end;
            _ARRAY :
                  begin
                     consume(_ARRAY);
                     consume(LECKKLAMMER);
                     p:=nil;
                     repeat
                       { read the expression and check it }
                       pt:=expr;
                       if pt^.treetype=typen then
                         begin
                            if pt^.resulttype^.deftype=aufzaehldef then
                              begin
                                 if p=nil then
                                   begin
                                      ap:=new(parraydef,
                                        init(0,paufzaehldef(pt^.resulttype)^.max,pt^.resulttype));
                                      p:=ap;
                                   end
                                 else
                                   begin
                                      ap^.definition:=new(parraydef,
                                        init(0,paufzaehldef(pt^.resulttype)^.max,pt^.resulttype));
                                      ap:=parraydef(ap^.definition);
                                   end;
                              end
                            else if pt^.resulttype^.deftype=orddef then
                              begin
                                 case porddef(pt^.resulttype)^.typ of
                                    s8bit,u8bit,s16bit,u16bit,s32bit :
                                      begin
                                         if p=nil then
                                           begin
                                              ap:=new(parraydef,init(porddef(pt^.resulttype)^.von,
                                                porddef(pt^.resulttype)^.bis,pt^.resulttype));
                                              p:=ap;
                                           end
                                         else
                                           begin
                                              ap^.definition:=new(parraydef,init(porddef(pt^.resulttype)^.von,
                                                porddef(pt^.resulttype)^.bis,pt^.resulttype));
                                              ap:=parraydef(ap^.definition);
                                           end;
                                      end;
                                    uchar : begin
                                               if p=nil then
                                                 begin
                                                    ap:=new(parraydef,init(0,255,pt^.resulttype));
                                                    p:=ap;
                                                 end
                                               else
                                                 begin
                                                    ap^.definition:=new(parraydef,init(0,255,pt^.resulttype));
                                                    ap:=parraydef(ap^.definition);
                                                 end;
                                            end;
                                    else error(error_in_type);
                                 end;
                              end
                            else error(error_in_type);
                         end
                       else
                         begin
                            do_firstpass(pt);

                            if (pt^.treetype<>rangen) or
                               (pt^.left^.treetype<>ordconstn) then
                              error(error_in_type);
                            { Registrierung der Grenzen erzwingen: }
                            {$IfNdef GDB}
                            if pt^.right^.resulttype=pdef(s32bitdef) then
                              pt^.right^.resulttype:=new(porddef,init(
                                s32bit,$80000000,$7fffffff));
                            {$EndIf GDB}
                            if p=nil then
                              begin
                                 ap:=new(parraydef,init(pt^.left^.value,pt^.right^.value,pt^.right^.resulttype));
                                 p:=ap;
                              end
                            else
                              begin
                                 ap^.definition:=new(parraydef,init(pt^.left^.value,pt^.right^.value,pt^.right^.resulttype));
                                 ap:=parraydef(ap^.definition);
                              end;
                         end;
{$ifdef CleanUp}
                       disposetree(pt);

{$endif * CleanUp *}
                       if token=COMMA then consume(COMMA)
                         else break;
                     until false;
                     consume(RECKKLAMMER);
                     consume(_OF);
                     ap^.definition:=typ('');
                  end;
            _SET : begin
                      consume(_SET);
                      consume(_OF);
                      hp1:=typ('');
                      case hp1^.deftype of
                         aufzaehldef : p:=new(psetdef,init(hp1,paufzaehldef(hp1)^.max));
                         orddef : begin
                                       case porddef(hp1)^.typ of
                                          uchar : p:=new(psetdef,init(hp1,255));
                                          u8bit,s8bit,u16bit,s16bit,s32bit :
                                            begin
                                               if (porddef(hp1)^.von>=0) then
                                                 p:=new(psetdef,init(hp1,porddef(hp1)^.bis))
                                               else error(illsettype);
                                            end;
                                       else error(illsettype);
                                       end;
                                    end;
                         else error(illsettype);
                      end;
                   end;
            CARET : begin
                       consume(CARET);
                       { forwards allowed only inside TYPE statements }
                       if typecanbeforward then
                          forwardsallowed:=true;
                       hp1:=single_type(hs);
                       p:=new(ppointerdef,init(hp1));
{$ifndef GDB}
                       if lasttypesym<>nil then
                         save_forward(ppointerdef(p),lasttypesym);
{$else * GDB *}
                       {I add big troubles here
                       with var p : ^byte in graph.putimage
                       because a save_forward was called and
                       no resolve forward
                       => so the definition was rewritten after
                       having been disposed !!
                       Strange problems appeared !!!!}
                       {Anyhow forwards should only be allowed
                       inside a type statement ??
                       don't you think so }
                       if (lasttypesym<>nil)
                         and (lasttypesym^.forwarddef) then
                           lasttypesym^.forwardpointer:=ppointerdef(p);
{$endif * GDB *}
                       forwardsallowed:=false;
                    end;
            _RECORD : begin
                         p:=record_dec;
                      end;
            _CLASS,
            _OBJECT : begin
                         p:=object_dec(name);
                      end;
            _PROCEDURE : begin
                            consume(_PROCEDURE);
                            handle_procvar;
                            p:=procvardef;
                         end;
            _FUNCTION : begin
                           consume(_FUNCTION);
                           handle_procvar;
                           if token<>COLON then
                             begin
                                consume(COLON);
                                while token<>SEMICOLON do
                                  consume(token);
                             end
                           else
                             begin
                                consume(COLON);
                                procvardef^.retdef:=single_type(hs);
                                p:=procvardef;
                             end;
                        end;
            else
               begin
                  { it can be only a range type }
                  pt:=expr;
                  do_firstpass(pt);

                  { valid expression ? }
                  if (pt^.treetype<>rangen) or
                     (pt^.left^.treetype<>ordconstn) then
                    error(error_in_type);
                  p:=new(porddef,init(uauto,pt^.left^.value,pt^.right^.value));
                  disposetree(pt);
               end;
         end;
         typ:=p;
      end;

    { sucht in symtablestack nach zwar daklarierten }
    { aber nicht definierten Typen                  }

    procedure testforward_types(p : psym);far;

      begin
         if (p^.typ=typesym) and (p^.forwarddef) then
           error(type_id_not_defined);
      end;

    { reads a type declaration to the symbol table }
    procedure type_dec;

      var
         typename : stringid;
{$ifdef GDB}

         newdef,olddef : pdef;
{$endif GDB}
      begin
         parse_types:=true;
         consume(_TYPE);
         typecanbeforward:=true;
         repeat
           typename:=pattern;
           consume(ID);
           consume(EQUAL);
{$ifdef GDB}
             { here you loose the strictness of pascal
             for which a redefinition like
               childtype = parenttype;
               child2type = parenttype;
             does not make the two child types equal !!
             here all vars from childtype and child2type
             get the definition of parenttype !!
           if token = ID then
             begin
             olddef := id_type(s);
             make a clone of olddef
             getmem(newdef,SizeOf(olddef);
             move(olddef^,newdef^,SizeOf(olddef));
             is that ok ??? }
             symtablestack^.insert(new(ptypesym,init(typename,typ(typename))));
{$else GDB}
           symtablestack^.insert(new(ptypesym,init(typename,typ(typename))));
{$endif * not GDB *}
           consume(SEMICOLON);
         until token<>ID;
         typecanbeforward:=false;
{$ifdef tp}
         symtablestack^.foreach(testforward_types);
{$else}
         symtablestack^.foreach(@testforward_types);
{$endif}
         resolve_forwards;
         parse_types:=false;
      end;

    { parses varaible declarations and inserts them in }
    { the top symbol table of symtablestack            }
    procedure var_dec;

      var
         p : pdef;
         sc : pstringcontainer;

      begin
         consume(_VAR);
         feldliste(false,true);
      end;

    { this procedure reads typed constants }
    procedure readtypedconst(def : pdef);

      var
         p : ptree;
         i,l : longint;
         s : string;
         ca : pchar;
         aktpos : longint;
         pd : pprocdef;
         hp1,hp2 : pdefcoll;

      procedure check_range;

        begin
           if (cs_rangechecking in aktswitches) and
              ((p^.value>porddef(def)^.bis) or
               (p^.value<porddef(def)^.von)) then
             error(range_check_error);
        end;

{$ifdef TP}
{$R-}  {Range check creates problem with init_8bit(-1) !!}
{$endif TP}
      begin
         case def^.deftype of
            orddef : begin
                          p:=expr;
                          do_firstpass(p);
                          case porddef(def)^.typ of
                             s8bit,
                             u8bit : begin
                                        if not is_constintnode(p) then
                                        { is't an int expected }
                                          error(error_in_expression)
                                        else
                                          begin
                                             datasegment^.concat(new(pai_const,init_8bit(p^.value)));
                                             check_range;
                                          end;
                                     end;
                             s32bit : begin
                                         if not is_constintnode(p) then
                                           error(error_in_expression)
                                         else
                                           begin
                                              datasegment^.concat(new(pai_const,init_32bit(p^.value)));
                                              check_range;
                                           end;
                                     end;
                             u32bit : begin
                                         if not is_constintnode(p) then
                                           error(error_in_expression)
                                         else
                                            datasegment^.concat(new(pai_const,init_32bit(p^.value)));
                                      end;
                             bool8bit : begin
                                           if not is_constboolnode(p) then
                                             error(error_in_expression);
                                           datasegment^.concat(new(pai_const,init_8bit(p^.value)));
                                        end;
                             uchar : begin
                                         if not is_constcharnode(p) then
                                           error(error_in_expression);
                                         datasegment^.concat(new(pai_const,init_8bit(p^.value)));
                                     end;
                             u16bit,
                             s16bit : begin
                                         if not is_constintnode(p) then
                                           error(error_in_expression);
                                         datasegment^.concat(new(pai_const,init_16bit(p^.value)));
                                         check_range;
                                     end;
                          end;
                          disposetree(p);
                       end;
         floatdef : begin
                       p:=expr;
                       do_firstpass(p);
                       if not is_constrealnode(p) then
		       error(error_in_expression);
                       case pfloatdef(def)^.typ of
                          s64real : datasegment^.concat(new(pai_double,init(p^.valued)));
                          f32bit : datasegment^.concat(new(pai_const,init_32bit(trunc(p^.valued*65536))));
                       else internalerror(18);
                       end;
                       disposetree(p);
                    end;
         pointerdef : begin
                         p:=expr;
                         do_firstpass(p);
                         { nil pointer ? }
                         if p^.treetype=niln then
                           datasegment^.concat(new(pai_const,init_32bit(0)))
                         { maybe pchar ? }
                         else if (ppointerdef(def)^.definition^.deftype=orddef) and
                              (porddef(ppointerdef(def)^.definition)^.typ=uchar) then
                           begin
                              getlabel(l);
                              { insert string at the begin }
                              if p^.treetype=stringconstn then
                                generate_ascii_insert((p^.values^)+#0)
                              else if is_constcharnode(p) then
                                datasegment^.insert(new(pai_string,init(char(byte(p^.value))+#0)))
                              else error(error_in_expression);
                              datasegment^.insert(new(pai_label,init(l)));
                              { insert label }
                              datasegment^.concat(new(pai_const,init_symbol(strpnew(lab2str(l)))));
                           end
                         else error(error_in_expression);
                         disposetree(p);
                     end;
         setdef : begin
                     p:=expr;
                     do_firstpass(p);
                     if p^.treetype=setconstrn then
                       begin
                          { we only allow const sets }
                          if assigned(p^.left) then
                            error(error_in_expression)
                          else
                            begin
                               for l:=0 to def^.savesize-1 do
                                 datasegment^.concat(
                                   new(pai_const,init_8bit(p^.constset^[l])));
                            end;
                       end
                     else
                       error(error_in_expression);
                     disposetree(p);
                  end;
         aufzaehldef : begin
                          p:=expr;
                          do_firstpass(p);
                          if p^.treetype=ordconstn then
                            begin
                               if is_equal(p^.resulttype,def) then
                                 begin
                                    datasegment^.concat(new(pai_const,init_32bit(p^.value)));
                                 end
                               else
                                 error(error_in_expression);
                            end
                          else
                            error(error_in_expression);
                          disposetree(p);
                       end;
         stringdef : begin
                        p:=expr;
                        do_firstpass(p);
                        if p^.treetype=stringconstn then
                          begin
                             s:=p^.values^;
                             if length(s)+1>def^.size then
                               s[0]:=chr(def^.size-1);
                             generate_ascii(char(length(s))+s);
                          end
                        else if is_constcharnode(p) then
                          begin
                             datasegment^.concat(new(pai_string,init(#1+char(byte(p^.value)))));
                             s:=char(byte(p^.value));
                          end
                        else error(error_in_expression);
                        if def^.size>length(s) then
                          begin
                             getmem(ca,def^.size-length(s));
                             fillchar(ca[0],def^.size-length(s)-1,' ');
                             ca[def^.size-length(s)-1]:=#0;
                             datasegment^.concat(new(pai_string,init_pchar(ca)));
                             disposetree(p);
                          end;
                     end;
         arraydef : begin
                       consume(LKLAMMER);
                       for l:=parraydef(def)^.lowrange to parraydef(def)^.highrange-1 do
                         begin
                            readtypedconst(parraydef(def)^.definition);
                            consume(COMMA);
                         end;
                       readtypedconst(parraydef(def)^.definition);
                       consume(RKLAMMER);
                    end;
         procvardef : begin
                         if token=KLAMMERAFFE then
                           consume(KLAMMERAFFE);
                         getsym(pattern,true);
                         consume(ID);
                         if srsym^.typ=unitsym then
                           begin
                              consume(POINT);
                              getsymonlyin(punitsym(srsym)^.unitsymtable,pattern);
                              consume(ID);
                           end;
                         if srsym^.typ<>procsym then
                           error(error_in_expression)
                         else
                           begin
                              pd:=pprocsym(srsym)^.definition;
                              if assigned(pd^.nextoverloaded) then
                                error(no_overloaded_procvars);
                              if not((pprocvardef(def)^.options=pd^.options)) or
                                not(is_equal(pprocvardef(def)^.retdef,pd^.retdef)) then
                                error(type_mismatch)
                                else
                                   begin
                                      hp1:=pprocvardef(def)^.para1;
                                      hp2:=pd^.para1;
                                      while assigned(hp1) and assigned(hp2) do
                                        begin
                                           if not(is_equal(hp1^.data,hp2^.data)) or
                                              not(hp1^.paratyp=hp2^.paratyp) then
                                             begin
                                                error(type_mismatch);
                                                break;
                                             end;
                                           hp1:=hp1^.next;
                                           hp2:=hp2^.next;
                                        end;
                                      if not((hp1=nil) and (hp2=nil)) then
                                        error(type_mismatch);
                                   end;
                              datasegment^.concat(new(pai_const,init_symbol(strpnew(pd^.mangledname))));
                           end;
                      end;
                     { reads a typed constant record }
         recorddef : begin
                        consume(LKLAMMER);
                        aktpos:=0;
                        while token<>RKLAMMER do
                          begin
                             s:=pattern;
                             consume(ID);
                             consume(COLON);
                             srsym:=precdef(def)^.symtable^.search(s);
                             if srsym=nil then
                               begin
                                  error(id_not_found);
                                  while token<>SEMICOLON do
                                    consume(token);
                               end
                             else
                               begin
                                  { check position }
                                  if pvarsym(srsym)^.adresse<aktpos then
                                    error(invalid_record_const);

                                  { if needed fill }
                                  if pvarsym(srsym)^.adresse>aktpos then
                                    for i:=1 to pvarsym(srsym)^.adresse-aktpos do
                                      datasegment^.concat(new(pai_const,init_8bit(0)));

                                  { new position }
                                  aktpos:=pvarsym(srsym)^.adresse+pvarsym(srsym)^.definition^.size;

                                  { read the data }
                                  readtypedconst(pvarsym(srsym)^.definition);

                                  if token=SEMICOLON then
                                    consume(SEMICOLON)
                                  else break;
                               end;
                          end;
                        for i:=1 to def^.size-aktpos do
                          datasegment^.concat(new(pai_const,init_8bit(0)));
                        consume(RKLAMMER);
                     end;
         else error(type_const_not_possible);
         end;
      end;

    procedure const_dec;

      var
         name : stringid;
         p : ptree;
         def : pdef;
         pd : pdouble;

      begin
         consume(_CONST);
         repeat
           name:=pattern;
           consume(ID);
           case token of
              EQUAL : begin
                          consume(EQUAL);
                          p:=expr;
                          do_firstpass(p);
                          case p^.treetype of
                             ordconstn : begin
                                            if is_constintnode(p) then
                                              symtablestack^.insert(new(pconstsym,init(name,constint,p^.value,nil)))
                                            else if is_constcharnode(p) then
                                              symtablestack^.insert(new(pconstsym,init(name,constchar,p^.value,nil)))
                                            else if is_constboolnode(p) then
                                              symtablestack^.insert(new(pconstsym,init(name,constbool,p^.value,nil)))
                                            else if p^.resulttype^.deftype=aufzaehldef then
                                              symtablestack^.insert(new(pconstsym,init(name,constord,p^.value,p^.resulttype)))
                                            else internalerror(111);
                                         end;
                             stringconstn :
{$ifndef GDB}
                               symtablestack^.insert(new(pconstsym,init(name,conststring,longint(p^.values),nil)));
{$else * GDB *}
                             {values is disposed with p so I need a copy !}
                               symtablestack^.insert(new(pconstsym,init(name,conststring,longint(stringdup(p^.values^)),nil)));
{$endif * GDB *}
                             realconstn : begin
                                             new(pd);
                                             pd^:=p^.valued;
                                             symtablestack^.insert(new(pconstsym,init(name,constreal,longint(pd),nil)));
                                          end;
                             else error(error_in_expression);
                          end;
{ Florian you can delete all this }
{$ifdef CleanUp}
 { this is a big mistake : because putnode assume that
  the node is in the stack !!!}
 {                       putnode(p); }
{$endif * CleanUp *}
                          consume(SEMICOLON);
                       end;
              COLON : begin
                          consume(COLON);
                          def:=typ('');
                          symtablestack^.insert(new(ptypedconstsym,init(name,def)));
                          consume(EQUAL);
                          readtypedconst(def);
                          consume(SEMICOLON);
                       end;
              else consume(EQUAL);
           end;
         until token<>ID;
      end;

    function if_statement : ptree;

      var
         ex,if_a,else_a : ptree;
         l1,l2,hl : longint;

      begin
         consume(_IF);
         ex:=expr;
         consume(_THEN);
         if token<>_ELSE then
           if_a:=statement
         else if_a:=nil;

         if token=_ELSE then
           begin
              consume(_ELSE);
              else_a:=statement;
           end
         else
           else_a:=nil;
         if_statement:=genloopnode(ifn,ex,if_a,else_a,false);
      end;

    function case_statement : ptree;

      var
         { contains the label number of currently parsed case block }
         aktcaselabel : longint;
         wurzel : pcaserecord;

         { the typ of the case expression }
         casedef : pdef;

      procedure newcaselabel(l,h : longint);

        var
           hcaselabel : pcaserecord;

        procedure insertlabel(var p : pcaserecord);

          begin
             if p=nil then p:=hcaselabel
             else
                if (p^._low>hcaselabel^._low) and
                   (p^._low>hcaselabel^._high) then
                  insertlabel(p^.less)
                else if (p^._high<hcaselabel^._low) and
                   (p^._high<hcaselabel^._high) then
                  insertlabel(p^.greater)
                else error(double_caselabel);
          end;

        begin
           new(hcaselabel);
           hcaselabel^.less:=nil;
           hcaselabel^.greater:=nil;
           hcaselabel^.statement:=aktcaselabel;
           getlabel(hcaselabel^._at);
           hcaselabel^._low:=l;
           hcaselabel^._high:=h;
           insertlabel(wurzel);
        end;

      var
         code,caseexpr,p,instruc,elseblock : ptree;
         hl1,hl2 : longint;
         ranges : boolean;

      begin
         consume(_CASE);
         caseexpr:=expr;
         { determines result type }
         cleartempgen;
         do_firstpass(caseexpr);
         casedef:=caseexpr^.resulttype;

         if not(is_ordinal(casedef)) then
           error(ordinal_expect);

         consume(_OF);
         wurzel:=nil;
         ranges:=false;
         instruc:=nil;
         repeat
           getlabel(aktcaselabel);

           { an instruction has may be more case labels }
           repeat
             p:=expr;
             cleartempgen;
             do_firstpass(p);

             if (p^.treetype=rangen) then
               begin
                  hl1:=get_ordinal_value(p^.left);
                  hl2:=get_ordinal_value(p^.right);
                  testrange(casedef,hl1);
                  testrange(casedef,hl2);
                  newcaselabel(hl1,hl2);
                  ranges:=true;
               end
             else
               begin
                  hl1:=get_ordinal_value(p);
                  testrange(casedef,hl1);
                  newcaselabel(hl1,hl1);
               end;
             disposetree(p);
             if token=COMMA then consume(COMMA)
               else break;
           until false;
           consume(COLON);

           { handles instruction block }
           p:=gensinglenode(labeln,statement);
           p^.labelnr:=aktcaselabel;

           { concats instruction }
           instruc:=gennode(anwein,instruc,p);

           if not((token=_ELSE) or (token=_OTHERWISE) or (token=_END)) then
             consume(SEMICOLON);
         until (token=_ELSE) or (token=_OTHERWISE) or (token=_END);

         if (token=_ELSE) or (token=_OTHERWISE) then
           begin
              if token=_ELSE then consume(_ELSE)
                else consume(_OTHERWISE);
              elseblock:=statement;
              if token=SEMICOLON then consume(SEMICOLON);
           end
         else
           elseblock:=nil;

         consume(_END);
         code:=gencasenode(caseexpr,instruc,wurzel);

         code^.elseblock:=elseblock;

         { true, if any case label uses ranges }
         code^.ranges:=ranges;

         case_statement:=code;
      end;

    function repeat_statement : ptree;

      var
         first,last,p_e : ptree;

      begin
         consume(_REPEAT);
         first:=nil;
         while token<>_UNTIL do
           begin
              if first=nil then
                begin
                   last:=gennode(anwein,nil,statement);
                   first:=last;
                end
              else
                begin
                   last^.left:=gennode(anwein,nil,statement);
                   last:=last^.left;
                end;
              if token<>SEMICOLON then
                break
              else
                consume(SEMICOLON);
              while token=SEMICOLON do
                consume(SEMICOLON);
           end;
         consume(_UNTIL);
         first:=gensinglenode(blockn,first);
         p_e:=expr;
         repeat_statement:=genloopnode(repeatn,p_e,first,nil,false);
      end;

    function while_statement : ptree;

      var
         p_e,p_a : ptree;

      begin
         consume(_WHILE);
         p_e:=expr;
         consume(_DO);
         if token<>SEMICOLON then
           p_a:=statement
         else
           p_a:=nil;
         while_statement:=genloopnode(whilen,p_e,p_a,nil,false);
      end;

    function for_statement : ptree;

      var
         p_e,tovalue,p_a : ptree;
         backward : boolean;

      begin
         { parse loop header }
         consume(_FOR);
         p_e:=expr;
         if token=_DOWNTO then
           begin
              consume(_DOWNTO);
              backward:=true;
           end
         else
           begin
              consume(_TO);
              backward:=false;
           end;
         tovalue:=expr;
         consume(_DO);

         { ... now the instruction }
         if token<>SEMICOLON then
           p_a:=statement
         else
           p_a:=nil;
         for_statement:=genloopnode(forn,p_e,tovalue,p_a,backward);
      end;

    function _with_statement : ptree;

      var
         right,hp,p : ptree;
         withsymtable,symtab : psymtable;

      begin
         p:=expr;
         do_firstpass(p);
         right:=nil;
         case p^.resulttype^.deftype of
            objectdef : begin
                          symtab:=pobjectdef(p^.resulttype)^.publicsyms;
                       end;
            recorddef : begin
                           symtab:=precdef(p^.resulttype)^.symtable;
                        end;
            else begin
                    error(false_with_expr);
                    { try to recover from error }
                    if token=COMMA then
                      begin
                         consume(COMMA);
{$ifdef tp}
                         hp:=_with_statement;
{$else}
                         hp:=_with_statement();
{$endif}
                      end
                    else
                      begin
                         consume(_DO);
                         { ignore all }
                         if token<>SEMICOLON then
                           statement;
                      end;
                    _with_statement:=nil;
                    exit;
                 end;

         end;
         withsymtable:=new(psymtable,init(symtable.withsymtable));
         withsymtable^.wurzel:=symtab^.wurzel;
         withsymtable^.next:=symtablestack;

         symtablestack:=withsymtable;
         if token=COMMA then
           begin
              consume(COMMA);
{$ifdef tp}
              right:=_with_statement;
{$else}
              right:=_with_statement();
{$endif}
           end
         else
           begin
              consume(_DO);
              if token<>SEMICOLON then
                right:=statement
              else
                right:=nil;
           end;
         symtablestack:=symtablestack^.next;
         withsymtable^.wurzel:=nil;
         withsymtable^.next:=nil;
{$ifndef GDB}

{$endif * not GDB *}
         _with_statement:=genwithnode(withsymtable,p,right);
      end;

    function with_statement : ptree;

      begin
         consume(_WITH);
         with_statement:=_with_statement;
      end;

    var
       in_except_block : boolean;

    function raise_statement : ptree;

      var
         p1,p2 : ptree;

      begin
         p1:=nil;
         p2:=nil;
         consume(_RAISE);
         if token<>SEMICOLON then
           begin
              p1:=expr;
              if (token=ID) and (pattern='AT') then
                begin
                   consume(ID);
                   p2:=expr;
                end;
           end
         else
           begin
              if not(in_except_block) then
                error(no_reraise_possible);
           end;
         raise_statement:=gennode(raisen,p1,p2);
      end;

    { creates a block (list) of statements, til the next END token }
    function statements_til_end : ptree;

      var
         first,last : ptree;

      begin
         first:=nil;
         while token<>_END do
           begin
              if first=nil then
                begin
                   last:=gennode(anwein,nil,statement);
                   first:=last;
                end
              else
                begin
                   last^.left:=gennode(anwein,nil,statement);
                   last:=last^.left;
                end;
              if token<>SEMICOLON then
                break
              else
                consume(SEMICOLON);
              while token=SEMICOLON do
                consume(SEMICOLON);

           end;
         consume(_END);
         statements_til_end:=gensinglenode(blockn,first);
      end;

    function try_statement : ptree;

      var
         p_try_block,p_finally_block,first,last,
         p_default,e1,e2,p_specific : ptree;

         old_in_except_block : boolean;

      begin
         p_default:=nil;
         p_specific:=nil;

         { read statements to try }
         consume(_TRY);
         first:=nil;
         while (token<>_FINALLY) and (token<>_EXCEPT) do
           begin
              if first=nil then
                begin
                   last:=gennode(anwein,nil,statement);
                   first:=last;
                end
              else
                begin
                   last^.left:=gennode(anwein,nil,statement);
                   last:=last^.left;
                end;
              if token<>SEMICOLON then
                break
              else
                consume(SEMICOLON);
              while token=SEMICOLON do
                consume(SEMICOLON);
           end;
         p_try_block:=gensinglenode(blockn,first);

         if token=_FINALLY then
           begin
              consume(_FINALLY);
              p_finally_block:=statements_til_end;
              try_statement:=gennode(tryfinallyn,p_try_block,p_finally_block);
           end
         else
           begin
              consume(_EXCEPT);
              old_in_except_block:=in_except_block;
              in_except_block:=true;

              if token=_ON then
                { catch specific exceptions }
                begin
                   repeat
                     consume(_ON);
                     e1:=expr;
                     if token=COLON then
                       begin
                          consume(COLON);
                          e2:=expr;
                          { !!!!! }
                       end
                     else
                       begin
                          { !!!!! }
                       end;
                     consume(_DO);
                     statement;
                     if token<>SEMICOLON then
                       break;
                     while token=SEMICOLON do
                       consume(SEMICOLON);
                   until false;
                   if token=_ELSE then
                     { catch the other exceptions }
                     begin
                        consume(_ELSE);
                        p_default:=statements_til_end;
                     end;
                end
              else
                { catch all exceptions }
                begin
                   p_default:=statements_til_end;
                end;
              in_except_block:=old_in_except_block;
              try_statement:=genloopnode(tryexceptn,p_try_block,p_specific,p_default,false);
           end;
      end;

    function exit_statement : ptree;

      var
         p : ptree;

      begin
         consume(_EXIT);
         if token=LKLAMMER then
           begin
              consume(LKLAMMER);
              p:=expr;
              consume(RKLAMMER);
              if procinfo.retdef=pdef(voiddef) then
                error(void_function);
           end
         else
           p:=nil;
         exit_statement:=gensinglenode(exitn,p);
      end;


    function _asm_statement : ptree;

      begin
         case aktasmmode of
            I386_ATT : _asm_statement:=ratti386.assemble;
            I386_INTEL : _asm_statement:=rai386.assemble;
            I386_DIRECT : _asm_statement:=radi386.assemble;
            else internalerror(30004);
         end;

         { Erst am Ende _ASM konsumieren, da der Scanner sonst die }
         { erste Assemblerstatement zu lesen versucht! }
         consume(_ASM);

         { (END is read) }
         if token=LECKKLAMMER then
           begin
              { it's possible to specify the modified registers }
              consume(LECKKLAMMER);
              if token<>RECKKLAMMER then
                repeat
                  pattern:=upper(pattern);
                  if pattern='EAX' then
                    usedinproc:=usedinproc or ($80 shr byte(R_EAX))
                  else if pattern='EBX' then
                    usedinproc:=usedinproc or ($80 shr byte(R_EBX))
                  else if pattern='ECX' then
                    usedinproc:=usedinproc or ($80 shr byte(R_ECX))
                  else if pattern='EDX' then
                    usedinproc:=usedinproc or ($80 shr byte(R_EDX))
                  else if pattern='ESI' then
                    usedinproc:=usedinproc or ($80 shr byte(R_ESI))
                  else if pattern='EDI' then
                    usedinproc:=usedinproc or ($80 shr byte(R_EDI))
                  else consume(RECKKLAMMER);
                  consume(CSTRING);
                  if token=COMMA then consume(COMMA)
                    else break;
                until false;
              consume(RECKKLAMMER);
           end
         else usedinproc:=$ff;
      end;

    function parse_paras(_colon : boolean) : ptree;

      var
         p1,p2 : ptree;

      begin
         if token=RKLAMMER then
           begin
              parse_paras:=nil;
              exit;
           end;
         p2:=nil;
         while true do
           begin
              p1:=expr;
              p2:=gencallparanode(p1,p2);

              { it's for the str(l:5,s); }
              if _colon and (token=COLON) then
                begin
                   consume(COLON);
                   p1:=expr;
                   p2:=gencallparanode(p1,p2);
                   p2^.is_colon_para:=true;
                   if token=COLON then
                     begin
                        consume(COLON);
                        p1:=expr;
                        p2:=gencallparanode(p1,p2);
                        p2^.is_colon_para:=true;
                     end
                end;
              if token=COMMA then
                consume(COMMA)
              else
                break;
           end;
         parse_paras:=p2;
      end;

    function statement_syssym(l : longint;var pd : pdef) : ptree;

      var
         p1,p2 : ptree;
         paras : ptree;


      begin
         case l of
            in_typeof_x : begin
                             consume(LKLAMMER);
                             p1:=expr;
                             consume(RKLAMMER);
                             pd:=voidpointerdef;
                             if p1^.treetype=typen then
                               begin
                                  if p1^.resulttype^.deftype=objectdef then
                                    statement_syssym:=geninlinenode(in_typeof_x,p1)
                                  else
                                    error(type_mismatch);
                               end
                             else
                               begin
                                  do_firstpass(p1);
                                  if p1^.resulttype^.deftype=objectdef then
                                    statement_syssym:=geninlinenode(in_typeof_x,p1)
                                  else
                                    error(type_mismatch);
                               end;
                          end;
            in_sizeof_x : begin
                             consume(LKLAMMER);
                             p1:=expr;
                             consume(RKLAMMER);
                             pd:=s32bitdef;
                             if p1^.treetype=typen then
                               begin
                                  statement_syssym:=genordinalconstnode(
                                    p1^.resulttype^.size,pd);
                                  { p1 not needed !}
                                  disposetree(p1);
                               end
                             else
                               begin
                                  do_firstpass(p1);
                                  if p1^.resulttype^.deftype<>objectdef then
                                    begin
                                       statement_syssym:=genordinalconstnode(
                                         p1^.resulttype^.size,pd);
                                       { p1 not needed !}
                                       disposetree(p1);
                                    end
                                  else
                                    begin
                                       statement_syssym:=geninlinenode(in_sizeof_x,p1);
                                    end;
                               end;
                          end;
            in_assigned_x : begin
                               consume(LKLAMMER);
                               p1:=expr;
                               do_firstpass(p1);
                               case p1^.resulttype^.deftype of
                                 pointerdef,procvardef : ;
                                 else error(no_para_match);
                               end;
                               p2:=gencallparanode(p1,nil);
                               p2:=geninlinenode(in_assigned_x,p2);
                               consume(RKLAMMER);
                               pd:=booldef;
                               statement_syssym:=p2;
                            end;
            in_ofs_x : begin
                          consume(RKLAMMER);
                          p1:=expr;
                          p1:=gensinglenode(addrn,p1);
                          do_firstpass(p1);
                          pd:=p1^.resulttype;
                          consume(LKLAMMER);
                          statement_syssym:=p1;
                       end;
            in_concat_x : begin
                             consume(LKLAMMER);
                             p2:=nil;
                             while true do
                               begin
                                  p1:=expr;
                                  do_firstpass(p1);
                                  if not((p1^.resulttype^.deftype=stringdef) or
                                         ((p1^.resulttype^.deftype=orddef) and
                                          (porddef(p1^.resulttype)^.typ=uchar)
                                         )
                                    ) then error(no_para_match);
                                  if p2<>nil then
                                    p2:=gennode(addn,p2,p1)
                                  else p2:=p1;
                                  if token=COMMA then
                                    consume(COMMA)
                                  else break;
                               end;
                             consume(RKLAMMER);
                             pd:=cstringdef;
                             statement_syssym:=p2;
                          end;
            in_read_x,
            in_readln_x : begin
                             if token=LKLAMMER then
                               begin
                                  consume(LKLAMMER);
                                  paras:=parse_paras(false);
                                  consume(RKLAMMER);
                               end
                             else
                               paras:=nil;
                             pd:=voiddef;
                             p1:=geninlinenode(l,paras);
                             do_firstpass(p1);
                             statement_syssym := p1;
                          end;
            in_write_x,
            in_writeln_x : begin
                             if token=LKLAMMER then
                               begin
                                  consume(LKLAMMER);
                                  paras:=parse_paras(true);
                                  consume(RKLAMMER);
                               end
                             else
                               paras:=nil;
                             pd:=voiddef;
                             p1 := geninlinenode(l,paras);
                             do_firstpass(p1);
                             statement_syssym := p1;
                          end;
            in_str_x_string : begin
                                 consume(LKLAMMER);
                                 paras:=parse_paras(true);
                                 consume(RKLAMMER);
                                 p1 := geninlinenode(l,paras);
                                 do_firstpass(p1);
                                 statement_syssym := p1;
                                 pd:=voiddef;
                              end;
            {in_val_x :        begin
                                 consume(LKLAMMER);
                                 paras:=parse_paras(false);
                                 consume(RKLAMMER);
                                 p1 := geninlinenode(l,paras);
                                 do_firstpass(p1);
                                 statement_syssym := p1;
                                 pd:=voiddef;
                              end;    }
            else internalerror(15);
         end;
      end;

    function factor(getaddr : boolean) : ptree;forward;

    function new_dispose_statement : ptree;

      var
         p,p2 : ptree;
         ht : ttoken;
         destrukname : stringid;
         sym : psym;
         classh : pobjectdef;
         pd : pdef;
         store_valid : boolean;

      begin
         ht:=token;
         if token=_NEW then consume(_NEW)
           else consume(_DISPOSE);
         consume(LKLAMMER);
         p:=expr;

         { calc return type }
         cleartempgen;
         Store_valid := Must_be_valid;
         Must_be_valid := False;
         do_firstpass(p);
         Must_be_valid := Store_valid;

         if (token=COMMA) and (ht=_DISPOSE) then
           begin
              { extended syntax of dispose }
              { new is handled in factor }
              consume(COMMA);
              { destructors have no parameters }
              destrukname:=pattern;
              consume(ID);

              pd:=p^.resulttype;
              if pd^.deftype<>pointerdef then
                begin
                   error(pointer_expect);
                   p:=factor(false);
                   consume(RKLAMMER);
                   exit;
                end;
              { first parameter must be an object or class }
              if ppointerdef(pd)^.definition^.deftype<>objectdef then
                begin
                   error(pointer_to_class_expect);
                   new_dispose_statement:=factor(false);
                   while token<>RKLAMMER do
                     consume(token);
                   consume(RKLAMMER);
                   exit;
                end;
              { check, if the first parameter is a pointer to a _class_ }
              classh:=pobjectdef(ppointerdef(pd)^.definition);
              if (classh^.options and oois_class)<>0 then
                begin
                   error(no_new_or_dispose_for_classes);
                   new_dispose_statement:=factor(false);
                   while token<>RKLAMMER do
                     consume(token);
                   consume(RKLAMMER);
                   exit;
                end;
              { search destructor, also in parent classes }
              sym:=nil;
              while assigned(classh) do
                begin
                   sym:=classh^.publicsyms^.search(pattern);
                   srsymtable:=classh^.publicsyms;
                   if assigned(sym) then
                     break;
                   classh:=classh^.childof;
                end;
              { the second parameter of dispose must be a call }
              { to a destructor                                }
              if (sym^.typ<>procsym) then
                begin
                   error(expr_have_to_be_destructor_call);
                   new_dispose_statement:=genzeronode(errorn);
                end
              else
                begin
                   p2:=gensinglenode(hdisposen,p);
                   p2:=genmethodcallnode(pprocsym(sym),srsymtable,p2);

                   { we need the real called method }
                   cleartempgen;
                   do_firstpass(p2);

                   if (p2^.procdefinition^.options and podestructor)=0 then
                     error(expr_have_to_be_destructor_call);

                   new_dispose_statement:=p2;
                end;
           end
         else
           begin
              if ppointerdef(p^.resulttype)^.definition^.deftype=objectdef then
                warning(take_extended_syntax);

              case ht of
                 _NEW : new_dispose_statement:=gensinglenode(simplenewn,p);
                 _DISPOSE : new_dispose_statement:=gensinglenode(
                   simpledisposen,p);
              end;
           end;
         consume(RKLAMMER);
      end;

    function statement : ptree;

      var
         p : ptree;
         code : ptree;
         labelnr : longint;

      label
         ready;

      begin
         case token of
            _GOTO : begin
                       if not(cs_support_goto in aktswitches)then
                         error(goto_label_not_support);
                       consume(_GOTO);
                       if (token<>INTCONST) and (token<>ID) then
                         begin
                            error(label_not_found);
                            code:=genzeronode(errorn);
                         end
                       else
                         begin
                            getsym(pattern,true);
                            consume(token);
                            if srsym^.typ<>labelsym then
                              begin
                                 error(id_is_no_label_id);
                                 code:=genzeronode(errorn);
                              end
                            else
                              code:=genlabelnode(goton,
                                plabelsym(srsym)^.number);
                         end;
                    end;
            _BEGIN : code:=befehlsblock;
            _IF    : code:=if_statement;
            _CASE  : code:=case_statement;
            _REPEAT : code:=repeat_statement;
            _WHILE : code:=while_statement;
            _FOR : code:=for_statement;
            _NEW,_DISPOSE : code:=new_dispose_statement;

            _WITH : code:=with_statement;
            _TRY : code:=try_statement;
            _RAISE : code:=raise_statement;
            SEMICOLON : code:=genzeronode(niln);
            _CONTINUE : begin
                           consume(_CONTINUE);
                           code:=genzeronode(continuen);
                        end;
{!!!!!
            _FAIL : begin
                       internalerror(100);
                       if (aktprocsym^.definition^.options and poconstructor)=0 then
                         error(fail_only_in_constructor);
                       consume(_FAIL);
                       if procinfo.exceptions then
                         aktproccode.concat(gennasmrec(CALL,S_NO,'HELP_DESTRUCTOR_E'))
                       else
                         aktproccode.concat(gennasmrec(CALL,S_NO,'HELP_DESTRUCTOR_NE'));
                       aktproccode.concat(genlasmrec(JMP,aktexitlabel));
                    end;
}
            _BREAK : begin
                           consume(_BREAK);
                           code:=genzeronode(breakn);
                        end;
            _EXIT : code:=exit_statement;
            _ASM : code:=_asm_statement;
            else
               begin
                  if (token=INTCONST) or (token=ID) then
                    begin
                       getsym(pattern,true);
                       if srsym^.typ=labelsym then
                         begin
                            consume(token);
                            consume(COLON);
                            if plabelsym(srsym)^.defined then
                              error(label_already_defined);
                            plabelsym(srsym)^.defined:=true;

                            { statement modifies srsym }
                            labelnr:=plabelsym(srsym)^.number;

                            { the pointer to the following instruction }
                            { isn't a very clean way                   }
{$ifdef tp}

                            code:=gensinglenode(labeln,statement);
{$else}
                            { else FPKPascal thinks this is the return value }
                            {                                   |            }
                            {                                   v            }
                            code:=gensinglenode(labeln,statement());
{$endif}
                            code^.labelnr:=labelnr;
                            { sorry, but there is a jump the easiest way }
                            goto ready;
                         end;
                    end;
                  p:=expr;
                  if (aktexprlevel<9) and (p^.treetype<>calln)
                     and (p^.treetype<>assignn) and (p^.treetype<>inlinen) then
                    error(error_in_expression);
                  code:=p;
               end;
         end;
      ready:
         statement:=code;
      end;

    function befehlsblock : ptree;

      var
         first,last : ptree;

      begin
         first:=nil;
         consume(_BEGIN);
         while token<>_END do
           begin
              if first=nil then
                begin
                   last:=gennode(anwein,nil,statement);
                   first:=last;
                end
              else
                begin
                   last^.left:=gennode(anwein,nil,statement);
                   last:=last^.left;
                end;
              if token=_END then
                break
              else
                begin
                   { if no semicolon, then error and go on }
                   if token<>SEMICOLON then
                     begin
                        consume(SEMICOLON);
                        while token<>SEMICOLON do
                          consume(token);
                     end;
                   consume(SEMICOLON);
                end;
              while token=SEMICOLON do
                consume(SEMICOLON);
           end;
         consume(_END);
         first:=gensinglenode(blockn,first);
         befehlsblock:=first;
      end;

    procedure formal_parameter_list;

      { hier durchgefhrte nderungen mssen meist auch in }
      { handle_procvar druchgefhrt werden                 }

      var
         sc : pstringcontainer;
         s : string;
         p : pdef;
         ref : boolean;
         vs : pvarsym;
         hs1,hs2 : string;
         varspez : tvarspez;

      begin
         consume(LKLAMMER);
         inc(testaktobject);
         repeat
           if token=_VAR then
             begin
                consume(_VAR);
                varspez:=vs_var;
             end
           else if token=_CONST then
             begin
                consume(_CONST);
                varspez:=vs_const;
             end
           else varspez:=vs_value;
           sc:=idlist;
           if token=COLON then
             begin
                consume(COLON);
                p:=single_type(hs1);
             end
           else
             begin
                hs1:='$$$';
                p:=new(pformaldef,init);
             end;
           s:=sc^.get;
           hs2:=aktprocsym^.definition^.mangledname;
           while s<>'' do
             begin
                aktprocsym^.definition^.concatdef(p,varspez);
                hs2:=hs2+'$'+hs1;
                vs:=new(pvarsym,init(s,p));
                vs^.varspez:=varspez;
                aktprocsym^.definition^.parast^.insert(vs);
                s:=sc^.get;
             end;
           dispose(sc,done);
           aktprocsym^.definition^.setmangledname(hs2);
           if token=SEMICOLON then consume(SEMICOLON)
             else break;
         until false;
         dec(testaktobject);
         consume(RKLAMMER);
      end;

    { contains the real name of a procedure as it's typed }
    { (the pattern isn't upper cased)                     }
    var
       realname : stringid;

    procedure _proc_head(options : word);

      var
         sp : stringid;
         pd : pprocdef;
         paramoffset : longint;
         hsymtab : psymtable;
         sym : psym;
         hs : string;

      begin
         sp:=pattern;
         realname:=orgpattern;
         consume(ID);

         { method ? }
         if (token=POINT) and not(parse_only) then
           begin
              consume(POINT);
              getsym(sp,true);
              sym:=srsym;
              { qualifier is class name ? }
              if (sym^.typ<>typesym) or
                 (ptypesym(sym)^.definition^.deftype<>objectdef) then
                fatalerror(object_type_expect);
              sp:=pattern;
              realname:=orgpattern;
              consume(ID);
              procinfo._class:=pobjectdef(ptypesym(sym)^.definition);
              aktprocsym:=pprocsym(procinfo._class^.publicsyms^.search(sp));

              { we solve this below }
              if aktprocsym=nil then
                error(method_id_expect);
           end
         else
           begin
              if not(parse_only) and
                ((options and (poconstructor or podestructor))<>0) then
                error(cons_always_obj);

              aktprocsym:=pprocsym(symtablestack^.search(sp));
              hs:=procprefix+'_'+sp;
              if not(parse_only) then
                begin
                   { this is no only a header }
                   hsymtab:=symtablestack;
                   if (aktprocsym=nil) then
                     begin
                        while (assigned(hsymtab)) and (hsymtab^.symtabletype<>globalsymtable) do
                          hsymtab:=hsymtab^.next;
                        if assigned(hsymtab) and (hsymtab^.symtabletype=globalsymtable) then
                          begin
                             aktprocsym:=pprocsym(hsymtab^.search(sp));
                             { if symbol found => is global }
                             if assigned(aktprocsym) then
                               procinfo.flags:=procinfo.flags or pi_is_global;
                          end;
                     end;
                end;
           end;
         { problem with procedures inside methods }
         if assigned(procinfo._class) and (pos('_$$_',procprefix)=0) then
           hs:=procprefix+'_$$_'+procinfo._class^.name^+'_'+sp;

         if aktprocsym=nil then
           begin
              aktprocsym:=new(pprocsym,init(sp));
              symtablestack^.insert(aktprocsym);
           end
         else
           begin
              if not(aktprocsym^.definition^.forwarddef) and
                (cs_no_overloaded_procedures in aktswitches) then
                error(procedure_overloading_is_off);
           end;

         if aktprocsym^.typ<>procsym then
           fatalerror(overloaded_no_proc);

         pd:=new(pprocdef,init);
{$ifdef GDB}
         {this is just used for the name }
         pd^.sym := ptypesym(aktprocsym);
         if procinfo._class<>nil then
            pd^._class := procinfo._class;
{$endif * GDB *}

         { set the options from the caller (podestructor or poconstructor) }
         pd^.options:=pd^.options or options;

         { calculate the offset of the parameters }
         paramoffset:=8;

         { calculate frame pointer offset }
         if lexlevel>0 then
           begin
              procinfo.framepointer_offset:=paramoffset;
              inc(paramoffset,4);
           end;

         if ((pd^.options and poconstructor)<>0) or
            ((pd^.options and podestructor)<>0) then
           begin
              procinfo.VMT_table:=paramoffset;
              inc(paramoffset,4);
           end;

         { self pointer offset }
         if assigned(procinfo._class) then
           begin
              procinfo.ESI_offset:=paramoffset;
              inc(paramoffset,4);
           end;

         procinfo.call_offset:=paramoffset;

         pd^.parast^.datasize:=0;

         pd^.nextoverloaded:=aktprocsym^.definition;
         aktprocsym^.definition:=pd;
         aktprocsym^.definition^.setmangledname(hs);
         if not(parse_only) then
           procprefix:=hs;
         if token=LKLAMMER then formal_parameter_list;
      end;

    procedure proc_head;

      var
         { Nur ein Hilfsstring, der den Namen des Rckgabetypes einer }
         { Funktion aufnimmt                                          }
         hs : string;

      begin
         if token=_FUNCTION then
           begin
              consume(_FUNCTION);
              _proc_head(0);
              if token<>COLON then
                begin
                   consume(COLON);
                   while token<>SEMICOLON do
                     consume(token);
                end
              else
                begin
                   consume(COLON);
                   aktprocsym^.definition^.retdef:=single_type(hs);
                end;
           end
         else if token=_PROCEDURE then
           begin
              consume(_PROCEDURE);
              _proc_head(0);
              aktprocsym^.definition^.retdef:=voiddef;
           end
         else if token=_CONSTRUCTOR then
           begin
              consume(_CONSTRUCTOR);
              _proc_head(poconstructor);
              { a contructor could be also a boolean function }

{$ifdef GDB}
              { GDB doesn't like unnamed types !}
              aktprocsym^.definition^.retdef:=
                globaldef('SYSTEM.BOOLEAN');

{$else GDB}
              aktprocsym^.definition^.retdef:=
                new(porddef,init(bool8bit,0,1));
{$endif GDB}
           end
         else if token=_DESTRUCTOR then
           begin
              consume(_DESTRUCTOR);
              _proc_head(podestructor);
              aktprocsym^.definition^.retdef:=voiddef;
           end
         else if token=_OPERATOR then
           begin
              internalerror(110);
              consume(_OPERATOR);
              if not(token in [PLUS]) then
                begin
                   error(operator_not_overloaded);
                   {!!!!!!!}
                end;
              consume(token);
              if token<>COLON then
                begin
                   consume(COLON);
                   while token<>SEMICOLON do
                     consume(token);
                end
              else
                begin
                   consume(COLON);

                   {!!!!!!!}
                   aktprocsym^.definition^.retdef:=single_type(hs);
                end;
           end;
         consume(SEMICOLON);
      end;

    procedure unter_dec;

      var
         oldprocsym : pprocsym;
         oldexceptlabel,oldexitlabel,oldexit2label : longint;
         _class : pobjectdef;
         oldprocinfo : tprocinfo;

         oldconstsymtable : psymtable;

         { fr geschachtelte Unterprogramme eindeutige Namen erzeugen }
         oldprefix,hs : string;

         { Gre des lokalen Stackframes }
         stackframe : longint;

         { Anzahl der Bytes die mit RET entfernt werden mssen }
         parasize : longint;

         { true wenn kein Stackframe erforderlich ist }
         nostackframe : boolean;

         hd,pd : pprocdef;
         names : tstringcontainer;

         { wird auf true gesetzt, wenn Symbole exportiert werden sollen }
         make_global : boolean;

         { wird auf true gesetzt, wenn ein Unterprogramm schon          }
         { "forward" deklariert wurde                                   }
         was_forward : boolean;

         { wird nur in Konstruktoren angesprungen, wenn eine Speicheran- }
         { forderung fr die Instanz fehlschlgt                         }
         quickexitlabel : longint;

         hl : longint;

         p : ptree;

         { code for the subroutine as tree }
         code : ptree;

         { this is for functions resultes }
         hr : preference;

         op : tasmop;
         s : topsize;

{$ifdef GDB}
         entrystack,exitstack, storestack  : pinputfile;
         entryline, exitline, storeline : longint;
         stab_function_name : pai_stab_function_name;
{$endif GDB}
      label
         restore;

      begin
         oldprocsym:=aktprocsym;
         oldprefix:=procprefix;
         oldconstsymtable:=constsymtable;
         oldprocinfo:=procinfo;
         codegen_newprocedure;

         { clear flags }
         procinfo.flags:=0;

         { standard frame pointer }
         procinfo.framepointer:=R_EBP;
{$ifdef GDB}
         procinfo.funcret_is_valid := false;
{$endif GDB}
         { is this a nested function of a method ? }
         procinfo._class:=oldprocinfo._class;

         proc_head;

         { set return type }
         procinfo.retdef:=aktprocsym^.definition^.retdef;

         { pointer to the return value ? }
         if (procinfo.retdef^.deftype=arraydef) or
            (procinfo.retdef^.deftype=stringdef) or
            (procinfo.retdef^.deftype=objectdef) or
            (procinfo.retdef^.deftype=recorddef) or
            ((procinfo.retdef^.deftype=setdef) and
             (psetdef(procinfo.retdef)^.settype<>smallset)) then
           begin
              procinfo.retoffset:=procinfo.call_offset;
              inc(procinfo.call_offset,4);
           end;

         { allows to access the parameters of main functions in nested functions }
         aktprocsym^.definition^.parast^.call_offset := procinfo.call_offset;

         { parse only a header ? }
         if parse_only then
           goto restore;

         { EXPORT needs this }
         names.init;
         make_global:=false;
         procinfo.exported:=false;
         case token of
            _FAR : begin
                      consume(_FAR);
                      warning(far_ignored);
                      consume(SEMICOLON);
                   end;
            _NEAR : begin
                       consume(_NEAR);
                       warning(near_ignored);
                       consume(SEMICOLON);
                    end;
            _INTERRUPT : begin
                            consume(_INTERRUPT);
                            { this is implemented since 0.6.6
                            warning(interrupt_ignored);
                            }
                            consume(SEMICOLON);
                            aktprocsym^.definition^.options:=
                              aktprocsym^.definition^.options or pointerrupt;
                         end;
            _EXPORT : begin
                            consume(_EXPORT);
                            names.insert(realname);
                            make_global:=true;
                            procinfo.exported:=true;
                            consume(SEMICOLON);
                            if gendeffile then
                              writeln(defdatei,#9+aktprocsym^.definition^.mangledname);
                            aktprocsym^.definition^.options:=
                              aktprocsym^.definition^.options or poexports;
                            if assigned(procinfo._class) then
                              error(methods_dont_be_export);
                            if lexlevel<>0 then
                              error(dont_nest_export);
                         end;
            _INLINE : begin
                         if support_inline then
                           begin
                              { this makes it very hairy }
                              aktprocsym^.definition^.options:=
                                aktprocsym^.definition^.options or poinline;
                           end
                         else
                            error(inline_not_supported);
                         consume(_INLINE);
                         consume(SEMICOLON);
                      end;
         end;
         case token of
            _FORWARD : begin
                          consume(_FORWARD);
                          consume(SEMICOLON);
                       end;
            else
               begin
                  { searchs idendical definitions }
                  { if there is a forward, then kill this }
                  was_forward:=false;
                  pd:=aktprocsym^.definition;
                  while (assigned(pd)) and (assigned(pd^.nextoverloaded)) do
                    begin
                       if (cs_no_overloaded_procedures in aktswitches) or
                         equal_paras(aktprocsym^.definition^.para1,pd^.nextoverloaded^.para1) then
                         begin
                            if pd^.nextoverloaded^.forwarddef then
                              { remove the forward definition }
                              { but don't delete it,          }
                              { the symtable is the owner !!  }
                              begin
                                 { and not(virtual), because virtual isn't needed }
                                 if ((pd^.nextoverloaded^.options and not(povirtualmethod or poabstractmethod))
                                    <>aktprocsym^.definition^.options) or
                                   not(is_equal(pd^.nextoverloaded^.retdef,aktprocsym^.definition^.retdef)) then
                                   error(header_dont_match);
                                 hd:=pd^.nextoverloaded;

                                 { change the name }
                                 { this should have been set already, no ? }
                                 if  hd^.mangledname<>aktprocsym^.definition^.mangledname then
                                   begin
                                      exterror:=strpnew('interface and implementation names are different !');
                                      warning(user_defined);
                                      hd^.setmangledname(aktprocsym^.definition^.mangledname);
                                   end;

                                 { also the call_offset }
                                 hd^.parast^.call_offset:=aktprocsym^.definition^.parast^.call_offset;

                                 { pd^.nextoverloaded aus der Liste an den Anfang }
                                 { und aktprocsym^.definition aushaengen }
                                 pd^.nextoverloaded:=pd^.nextoverloaded^.nextoverloaded;
                                 hd^.nextoverloaded:=aktprocsym^.definition^.nextoverloaded;
                                 aktprocsym^.definition:=hd;
                                 was_forward:=true;
                              end
                            else
                              begin
                                 { abstract methods aren't forward defined, but this }
                                 { needs another error message                       }
                                 if (pd^.nextoverloaded^.options and poabstractmethod)=0 then
                                   error(same_parameters)
                                 else error(abstract_no_definition);
                              end;
                            break;
                         end;
                       pd:=pd^.nextoverloaded;
                    end;

                  { a method must be forward defined }
                  if assigned(procinfo._class) and
                    not(assigned(oldprocinfo._class)) then
                    begin
                       if not(was_forward) then
                         error(header_dont_match_any_member);
                    end;
                  if not(was_forward) and ((procinfo.flags and pi_is_global)<>0) then
                    error(overloaded_must_be_all_global);

                 { write some informations }
                 if veryverbose then
                    writeln('procedure/function: ',aktprocsym^.name,' (',
                    aktprocsym^.definition^.mangledname,') at line ',
                    current_module^.current_inputfile^.line_no);

                  { read function attributes }
                  if token=LECKKLAMMER then
                    begin
                       consume(LECKKLAMMER);
                       repeat
                         if token=_PUBLIC then
                           begin
                              consume(_PUBLIC);
                              make_global:=true;
                           end
                         else if token=ID then
                           begin
                              if pattern='ALIAS' then
                                begin
                                   consume(ID);
                                   consume(COLON);
                                   names.insert(pattern);
                                   if token=CCHAR then consume(CCHAR)
                                     else consume(CSTRING);
                                end
                              else if pattern='INTERNPROC' then
                                begin
                                   consume(ID);
                                   consume(COLON);
                                   p:=expr;
                                   do_firstpass(p);
                                   if p^.treetype<>ordconstn then
                                     fatalerror(error_in_expression);
                                   aktprocsym^.definition^.extnumber:=p^.value;
                                   aktprocsym^.definition^.options:=
                                     aktprocsym^.definition^.options or pointernproc;
                                   disposetree(p);
                                   consume(RECKKLAMMER);
                                   consume(SEMICOLON);

                                   { the procedure is now defined }
                                   aktprocsym^.definition^.forwarddef:=false;
                                   goto restore;
                                end
                              else if pattern='SYSTEM' then
                                begin
                                   consume(ID);
                                   aktprocsym^.definition^.options:=
                                     aktprocsym^.definition^.options or poclearstack;

                                   { aktprocsym^.definition^.usedregisters:=$ff; }

                                   aktprocsym^.definition^.forwarddef:=false;
                                   aktprocsym^.definition^.setmangledname(realname);
                                   consume(RECKKLAMMER);
                                   consume(SEMICOLON);
                                   goto restore;
                                end
                              { it does currently the same as 'SYSTEM'     }
                              { but all currently used registers are saved }
                              else if pattern='C' then
                                begin
                                   consume(ID);
                                   aktprocsym^.definition^.options:=
                                     aktprocsym^.definition^.options or poclearstack;

                                   { this is the difference to SYSTEM }
                                   aktprocsym^.definition^.usedregisters:=$ff;
                                   aktprocsym^.definition^.forwarddef:=false;
                                   aktprocsym^.definition^.setmangledname(realname);
                                   consume(RECKKLAMMER);
                                   consume(SEMICOLON);
                                   goto restore;
                                end
                              else if pattern='IOCHECK' then
                                begin
                                   consume(ID);
                                   aktprocsym^.definition^.options:=
                                     aktprocsym^.definition^.options or poiocheck;
                                end
                           end;
                         if token=COMMA then consume(COMMA)
                           else break;
                       until false;
                       consume(RECKKLAMMER);
                       consume(SEMICOLON);
                    end
                  else if token=_EXTERNAL then
                    begin
                       consume(_EXTERNAL);
                       aktprocsym^.definition^.forwarddef:=false;
                       if token=SEMICOLON then
                         consume(SEMICOLON)
                       else
                         begin
                            { function from DLL }
                            {!!!!!!!!!!!}
                         end;
                       goto restore;
                    end
                   else if token=_ASSEMBLER then
                     begin
                        consume(_ASSEMBLER);
                        { should this be accepted if there are other options }
                        { like poconstructor ?                               }
                        aktprocsym^.definition^.options:=
                          aktprocsym^.definition^.options or poassembler;
                        consume(SEMICOLON);
                     end ;
                  if procinfo.exported then
                    aktprocsym^.definition^.options:=aktprocsym^.definition^.options or
                      poclearstack;
                  oldexitlabel:=aktexitlabel;
                  oldexit2label:=aktexit2label;

                  getlabel(aktexitlabel);
                  getlabel(aktexit2label);

                  { calculate the lexical level }
                  inc(lexlevel);

                  { enter allows only (?) 31 levels }
                  { I think we don't need more      }
                  if lexlevel>31 then
                    error(too_much_lexlevel);

                  { reset break and continue labels }
                  in_except_block:=false;
                  aktbreaklabel:=0;
                  aktcontinuelabel:=0;

                  { insert symtables for the class, by only if it is no }
                  { nested function                                     }
                  if assigned(procinfo._class) and
                    not(assigned(oldprocinfo._class)) then
                    begin
                       _class:=procinfo._class;
                       while assigned(_class) do
                         begin
                            _class^.publicsyms^.next:=symtablestack;
                            symtablestack:=_class^.publicsyms;
                            _class:=_class^.childof;
                         end;
                    end;

                  { insert symbol tables }
                  { and set the lexical level }
                  aktprocsym^.definition^.parast^.next:=symtablestack;
                  symtablestack:=aktprocsym^.definition^.parast;
                  inc(symtablestack^.symtabletype,lexlevel);

                  aktprocsym^.definition^.localst^.next:=symtablestack;
                  symtablestack:=aktprocsym^.definition^.localst;
                  inc(symtablestack^.symtabletype,lexlevel);

                  { constant symbols are inserted in this symboltable }
                  constsymtable:=symtablestack;

                  { reset the temporary memory }
                  cleartempgen;

                  { no registers are used }
                  usedinproc:=0;
{$ifdef GDB}
                  entrystack:=current_module^.current_inputfile;
                  entryline:=current_module^.current_inputfile^.line_no;
{$endif * GDB *}

                  { parse the code ... }
                  if (aktprocsym^.definition^.options and poassembler)<> 0 then
                    code:=assembler_block
                  else
                    code:=block;
                  { set the framepointer to esp for assembler functions }
                  { but only if the are no local variables              }
                  if ((aktprocsym^.definition^.options and poassembler)<>0) and
                    (aktprocsym^.definition^.localst^.datasize=0) then
                    begin
                    procinfo.framepointer:=R_ESP;
                    { set the right value for parameters }
                    dec(aktprocsym^.definition^.parast^.call_offset,4);
                    end;
{$ifdef GDB}
                  exitstack := current_module^.current_inputfile;
                  exitline := current_module^.current_inputfile^.line_no;
                  setfirsttemp(procinfo.firsttemp);
{$endif * GDB *}

                  { ... and generate assembler }
                  generatecode(code);

                  { inline procedure ?? }
                  if (aktprocsym^.definition^.options and poinline)=0 then
                  { ...no, the code isn't needed }
                    disposetree(code)
                  else
                    aktprocsym^.definition^.code:=code;

                  dec(lexlevel);
{$ifdef GDB}
                  storeline := entrystack^.line_no;
                  entrystack^.line_no := entryline;
                  storestack := current_module^.current_inputfile;
                  current_module^.current_inputfile := entrystack;
{$endif * GDB *}

                  { the procedure is no defined }
                  aktprocsym^.definition^.forwarddef:=false;

                  aktprocsym^.definition^.usedregisters:=usedinproc;

                  stackframe:=gettempsize;
{$ifdef GDB}
                  { only now we can remove the temps }
                  resettempgen;
{$endif * GDB *}

                  quickexitlabel:=0;

                  { *************************************** }
                  { *     start entry code generation     * }
                  { *************************************** }

                  { a constructor needs a help procedure }
                  if (aktprocsym^.definition^.options and poconstructor)<>0 then
                    begin
                       getlabel(quickexitlabel);
                       procinfo.aktentrycode^.insert(new(pai_labeled386,init(A_JZ,quickexitlabel)));
                       procinfo.aktentrycode^.insert(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol('HELP_CONSTRUCTOR',0))));
                    end;

                  { don't load ESI, does the caller }

                  { omit stack frame ? }
                  if procinfo.framepointer=R_ESP then
                    begin
                       if veryverbose then
                         writeln('stack frame is omited');
                       nostackframe:=true;
                       parasize:=aktprocsym^.definition^.parast^.datasize+procinfo.call_offset-4;
                    end
                  else
                    begin
                       parasize:=aktprocsym^.definition^.parast^.datasize+procinfo.call_offset-8;
                       nostackframe:=false;
                       if stackframe<>0 then
                         begin
                            if cs_littlesize in aktswitches  then
                              procinfo.aktentrycode^.insert(new(pai386,op_const_const(A_ENTER,S_NO,stackframe,0)))
                            else
                              begin
                                 procinfo.aktentrycode^.insert(new(pai386,op_const_reg(A_SUB,S_L,stackframe,R_ESP)));
                                 procinfo.aktentrycode^.insert(new(pai386,op_reg_reg(A_MOV,S_L,R_ESP,R_EBP)));
                                 procinfo.aktentrycode^.insert(new(pai386,op_reg(A_PUSH,S_L,R_EBP)));
                              end;
                            if cs_check_stack in aktswitches then
                              begin
                                 procinfo.aktentrycode^.insert(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol('STACKCHECK',0))));
                                 procinfo.aktentrycode^.insert(new(pai386,op_const(A_PUSH,S_L,stackframe)));
                              end;
                         end
                       else
                         begin
                            procinfo.aktentrycode^.insert(new(pai386,op_reg_reg(A_MOV,S_L,R_ESP,R_EBP)));
                            procinfo.aktentrycode^.insert(new(pai386,op_reg(A_PUSH,S_L,R_EBP)));
                         end;
                    end;

                  if (aktprocsym^.definition^.options and pointerrupt)<>0 then
                    generate_interrupt_stackframe_entry;

                  names.insert(aktprocsym^.definition^.mangledname);
                  if (aktprocsym^.definition^.owner^.symtabletype=globalsymtable) or
                     ((procinfo._class<>nil) and
                     (procinfo._class^.owner^.symtabletype=globalsymtable)) then
                    make_global:=true;
                  hs:=names.get;
{$IfDef GDB}
                  if (cs_debuginfo in aktswitches) and
                     target_info.use_function_relative_addresses then
                         stab_function_name := new(pai_stab_function_name,init(strpnew(hs)));
{$EndIf GDB}
                  while hs<>'' do
                    begin
{$ifdef GDB}
                       if (cs_debuginfo in aktswitches) and
                         target_info.use_function_relative_addresses then
                         procinfo.aktentrycode^.insert(new(pai_stab_function_name,init(strpnew(hs))));
{$endif GDB}
                       if make_global then
                         procinfo.aktentrycode^.insert(new(pai_symbol,init_global(hs)))
                       else
                         procinfo.aktentrycode^.insert(new(pai_symbol,init(hs)));
                       hs:=names.get;
                    end;
{$ifdef GDB}

                  if (cs_debuginfo in aktswitches) then
                    begin
                       if target_info.use_function_relative_addresses then
                         procinfo.aktentrycode^.insert(stab_function_name);
                       if make_global or ((procinfo.flags and pi_is_global) <> 0) then
                         aktprocsym^.is_global := True;
                       if (lexlevel > 0) and (oldprocsym^.definition^.localst^.name = nil) then
                         if oldprocsym^.owner^.symtabletype = objectsymtable then
                           oldprocsym^.definition^.localst^.name := stringdup(oldprocsym^.owner^.name^+'_'+oldprocsym^.name)
                         else
                           oldprocsym^.definition^.localst^.name := stringdup(oldprocsym^.name);
                       procinfo.aktentrycode^.insert(new(pai_stabs,init(aktprocsym^.stabstring)));
                       aktprocsym^.isstabwritten:=true;
                    end;
                  { !!!!!!
                  if not(cs_littlesize in aktswitches ) then
                    aktentrycode.insert(gennasmrec(A_ALIGN,S_NO,'4,0x90'));
                  }
                  { !!!!!!! is this needed ? }
                  parasize:=aktprocsym^.definition^.parast^.datasize+procinfo.call_offset-8;
                  entrystack^.line_no := storeline;
                  storeline := exitstack^.line_no;
                  exitstack^.line_no := exitline;
                  current_module^.current_inputfile := exitstack;
{$endif * GDB *}

                  { ************************************** }
                  { *     start exit code generation     * }
                  { ************************************** }

                  { !!!! insert there automatic destructors }

                  procinfo.aktexitcode^.insert(new(pai_label,init(aktexitlabel)));

                  { call the destructor help procedure }
                  if (aktprocsym^.definition^.options and podestructor)<>0 then
                    procinfo.aktexitcode^.insert(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol('HELP_DESTRUCTOR',0))));

                  { handle return value }
                  if (aktprocsym^.definition^.options and poassembler)=0 then
                    if (aktprocsym^.definition^.options and poconstructor)=0 then
                      begin
                         if procinfo.retdef<>pdef(voiddef) then
                           begin
                              new(hr);
                              reset_reference(hr^);
                              hr^.offset:=procinfo.retoffset;
                              hr^.base:=procinfo.framepointer;
                              if (procinfo.retdef^.deftype=orddef) then
                                begin
                                   case porddef(procinfo.retdef)^.typ of
                                      s32bit,u32bit :
                                        procinfo.aktexitcode^.concat(new(pai386,op_ref_reg(A_MOV,S_L,
                                          hr,R_EAX)));
                                      u8bit,s8bit,uchar,bool8bit :
                                        procinfo.aktexitcode^.concat(new(pai386,op_ref_reg(A_MOV,S_B,
                                          hr,R_AL)));
                                      s16bit,u16bit :
                                        procinfo.aktexitcode^.concat(new(pai386,op_ref_reg(A_MOV,S_W,
                                          hr,R_AX)));
                                   end;
                                end
                               else
                                 if (procinfo.retdef^.deftype=pointerdef) or
                                   (procinfo.retdef^.deftype=aufzaehldef) or
                                   (procinfo.retdef^.deftype=procvardef) or
                                   ((procinfo.retdef^.deftype=setdef) and
                                    (psetdef(procinfo.retdef)^.settype=smallset)) then
                                   procinfo.aktexitcode^.concat(new(pai386,op_ref_reg(A_MOV,S_L,
                                     hr,R_EAX)))
                               else
                                 if (procinfo.retdef^.deftype=floatdef) then
                                   begin
                                      if pfloatdef(procinfo.retdef)^.typ=f32bit then
                                        begin
                                        end
                                      else
                                        begin
                                           floatloadops(pfloatdef(procinfo.retdef)^.typ,op,s);
                                           procinfo.aktexitcode^.concat(new(pai386,op_ref(op,s,hr)))
                                        end
                                   end
                               else dispose(hr);
                           end
                      end
                    else
                      begin
                         { successful constructor deletes the zero flag }
                         { and returns self in eax                      }
                         procinfo.aktexitcode^.concat(new(pai386,op_reg_reg(A_MOV,S_L,R_ESI,R_EAX)));
                         procinfo.aktexitcode^.concat(new(pai386,op_reg_reg(A_OR,S_L,R_EAX,R_EAX)));
                         procinfo.aktexitcode^.concat(new(pai_label,init(quickexitlabel)));
                      end;
                  procinfo.aktexitcode^.concat(new(pai_label,init(aktexit2label)));
                  if not(nostackframe) then
                    procinfo.aktexitcode^.concat(new(pai386,op_none(A_LEAVE,S_NO)));

                  { parameters are limited to 65535 bytes because }
                  { ret allows only imm16                         }
                  if parasize>65535 then
                    error(para_too_big);

                  { at last, the return is generated }

                  if (aktprocsym^.definition^.options and pointerrupt)<>0 then
                    generate_interrupt_stackframe_exit
                  { exported routines (OS/2) use only a ret }
                  { also routines with parasize=0           }
                  else if (parasize=0) or procinfo.exported then
                    procinfo.aktexitcode^.concat(new(pai386,op_none(A_RET,S_NO)))
                  else procinfo.aktexitcode^.concat(new(pai386,op_const(
                      A_RET,S_NO,parasize)));

{$ifdef GDB}
                  {if cs_debuginfo in aktswitches  then
                    Begin
                       aktexitcode.concat(new(pai_stabs,init(strpnew('"'+
                       aktprocsym^.name+'",'+tostr(N_function)+',0,0,'+
                       aktprocsym^.definition^.mangledname));
                    end;}
                  if cs_debuginfo in aktswitches  then
                    begin
                       aktprocsym^.concatstabto(procinfo.aktexitcode);
                       if assigned(procinfo._class) then
                         procinfo.aktexitcode^.concat(new(pai_stabs,init(strpnew(
                          '"$t:v'+procinfo._class^.numberstring+'",'+
                          tostr(N_PSYM)+',0,0,'+tostr(procinfo.esi_offset)))));

                       if (porddef(aktprocsym^.definition^.retdef) <> voiddef) then
                         procinfo.aktexitcode^.concat(new(pai_stabs,init(strpnew(
                          '"'+aktprocsym^.name+':X'+aktprocsym^.definition^.retdef^.numberstring+'",'+
                          tostr(N_PSYM)+',0,0,'+tostr(procinfo.retoffset)))));

                       procinfo.aktexitcode^.concat(new(pai_stabn,init(strpnew('192,0,0,'
                         +aktprocsym^.definition^.mangledname))));

                       procinfo.aktexitcode^.concat(new(pai_stabn,init(strpnew('224,0,0,'
                         +target_info.labelprefix+tostr(aktexit2label)))));
                   end;
{$endif * GDB *}

                  procinfo.aktproccode^.insertlist(procinfo.aktentrycode);
                  procinfo.aktproccode^.concatlist(procinfo.aktexitcode);

                  if cs_optimize in aktswitches then
                    peepholeopt(procinfo.aktproccode);

                  codesegment^.concatlist(procinfo.aktproccode);

                  { ... remove symbol tables }
                  symtablestack:=symtablestack^.next^.next;

                  { ... check for unused symbols      }
                  { but only if there is no asm block }
                  if not((procinfo.flags and pi_uses_asm)<>0) then
                    begin
                       aktprocsym^.definition^.localst^.allsymbolsused;
                       aktprocsym^.definition^.parast^.allsymbolsused;
                    end;

                  { die lokalen Symboltabellen drfen gelscht werden,    }
                  { nur auf die Parametersymboltablellen und insbesonders }
                  { auf die Definitionen wird noch zugegriffen            }
                  dispose(aktprocsym^.definition^.localst,done);
                  aktprocsym^.definition^.localst:=nil;

                  { remove class member symbol tables }
                  while symtablestack^.symtabletype=objectsymtable do
                    symtablestack:=symtablestack^.next;

                  { aktexitlabel:=oldexit2label;!!!!!
                  aktexit2label:=oldexitlabel; !!!!! }
                  aktexitlabel:=oldexitlabel;
                  aktexit2label:=oldexit2label;

                  names.done;

{$ifdef GDB}
                  current_module^.current_inputfile := storestack;
                  exitstack^.line_no := storeline;
{$endif GDB}
                  consume(SEMICOLON);
               end;
         end;
      restore:
         constsymtable:=oldconstsymtable;
         aktprocsym:=oldprocsym;
         procprefix:=oldprefix;
         codegen_doneprocedure;
         procinfo:=oldprocinfo;
      end;

    function block : ptree;

      begin
         repeat
           case token of
              _LABEL : label_dec;
              _CONST : const_dec;
              _TYPE : type_dec;
              _VAR : var_dec;
              _CONSTRUCTOR,_DESTRUCTOR,
              _FUNCTION,_PROCEDURE,_OPERATOR : unter_dec;
              else break;
           end;
         until false;

         { temporary space is set, while the BEGIN of the procedure }
         if (symtablestack^.symtabletype and $8000)=localsymtable then
           procinfo.firsttemp := -symtablestack^.datasize
         else procinfo.firsttemp := 0;

         { space for the return value }
         if procinfo.retdef<>pdef(voiddef) then
           begin
              if (procinfo.retdef^.deftype=orddef) or
                 (procinfo.retdef^.deftype=pointerdef) or
                 (procinfo.retdef^.deftype=aufzaehldef) or
                 (procinfo.retdef^.deftype=procvardef) or
                 (procinfo.retdef^.deftype=floatdef) or
                 (
                   (procinfo.retdef^.deftype=setdef) and
                   (psetdef(procinfo.retdef)^.settype=smallset)
                 ) then
                begin
                   procinfo.retoffset:=procinfo.firsttemp-procinfo.retdef^.size;
                   procinfo.firsttemp:=procinfo.retoffset;

                   { eax is modified by a function }
                   usedinproc:=usedinproc or ($80 shr byte(R_EAX))
                end;
           end;

         block:=befehlsblock;
      end;

    function assembler_block : ptree;

      begin
         repeat
           case token of
              _LABEL : label_dec;
              _CONST : const_dec;
              _TYPE : type_dec;
              _VAR : var_dec;
              _CONSTRUCTOR,_DESTRUCTOR,
              _FUNCTION,_PROCEDURE,_OPERATOR : unter_dec;
              else break;
           end;
         until false;

         { temporary space is set, while the BEGIN of the procedure }
         if (symtablestack^.symtabletype and $8000)=localsymtable then
           procinfo.firsttemp := -symtablestack^.datasize
         else procinfo.firsttemp := 0;

         { assembler code does not allocate }
         { space for the return value       }
          if procinfo.retdef<>pdef(voiddef) then
           begin
              if (procinfo.retdef^.deftype=orddef) or
                 (procinfo.retdef^.deftype=pointerdef) or
                 (procinfo.retdef^.deftype=aufzaehldef) or
                 (procinfo.retdef^.deftype=procvardef) or
                 (
                   (procinfo.retdef^.deftype=setdef) and
                   (psetdef(procinfo.retdef)^.settype=smallset)
                 ) then
                begin
                   { in assembler code the result should be directly in %eax
                   procinfo.retoffset:=procinfo.firsttemp-procinfo.retdef^.size;
                   procinfo.firsttemp:=procinfo.retoffset;                   }

                   { eax is modified by a function }
                   usedinproc:=usedinproc or ($80 shr byte(R_EAX))
                end
              else
                begin
                { should we allow assembler functions of big elements ? }
                exterror:=strpnew('assembler incompatible with function return value');
                fatalerror(user_defined);
                end;
           end;

         assembler_block:=_asm_statement;
      end;

{****************************************************************************
                            Programs and units
 ****************************************************************************}

    procedure insertinternsyms(p : psymtable);

      begin
         p^.insert(new(psyssym,init('CONCAT',in_concat_x)));
         p^.insert(new(psyssym,init('WRITE',in_write_x)));
         p^.insert(new(psyssym,init('WRITELN',in_writeln_x)));
         p^.insert(new(psyssym,init('ASSIGNED',in_assigned_x)));
         p^.insert(new(psyssym,init('READ',in_read_x)));
         p^.insert(new(psyssym,init('READLN',in_readln_x)));
         p^.insert(new(psyssym,init('OFS',in_ofs_x)));
         p^.insert(new(psyssym,init('SIZEOF',in_sizeof_x)));
         p^.insert(new(psyssym,init('TYPEOF',in_typeof_x)));
         { symtablestack^.insert(new(psyssym,init('STR',in_str_x_string))); }
      end;

    function loadunit(const s : string;compile_system : boolean) : pmodule;

      var
         st : punitsymtable;
         old_current_module,hp,loaded_unit : pmodule;
         pu : pused_unit;
         checksum : longint;
         b : byte;
         count : longint;
         hs : string;
         nextmapentry : longint;
         p : dirstr;
         n : namestr;
         e : extstr;

      label
         ready;

      begin
         old_current_module:=current_module;
         nextmapentry:=1;
         { unit not found }
         st:=nil;
         { search all loaded units }
         hp:=pmodule(loaded_units.first);
         while assigned(hp) do
           begin
              if upper(hp^.name^)=s then
                begin
                   { the unit is already registered   }
                   { and this means that the unit     }
                   { is already compiled              }
                   { else there is a cyclic unit use  }
                   if (current_module^.in_implementation
                     and not hp^.in_implementation) then
                     begin
                        { in this case we simply recompile the unit completely  }
                        break;
                     end
                   else
                     if not(assigned(hp^.symtable)) then
                       error(rec_unit_def)
                   else
                     st:=punitsymtable(hp^.symtable);
                   break;
                end;
              { the next unit }
              hp:=pmodule(hp^.next);
           end;
         { no error and the unit isn't loaded }
         if not(assigned(hp)) and (st=nil) then
           begin
              { generates a new unit info record }
              hp:=new(pmodule,init_unit(s));
              { now we can register the unit }
              loaded_units.insert(hp);

              current_module:=hp;
              { force build ? }
              if (hp^.do_compile) or (hp^.sources_avail and do_build) then
                begin
                   { we needn't the ppufile }
                   if assigned(hp^.ppufile) then
                     begin
                        dispose(hp^.ppufile,done);
                        hp^.ppufile:=nil;
                     end;
                   if not(hp^.sources_avail) then
                     begin
                        exterror:=strpnew(hp^.name^);
                        fatalerror(cant_compile_unit);
                     end
                   else
                     begin
                        hs:=hp^.msource^;
                        fsplit(hs,p,n,e);
                        compile(p,n,e,compile_system);
                     end;
                end
              else
                begin
                   { we should know there the PPU file             }
                   { else it's an error and we can't load the unit }
                   if hp^.ppufile^.name^<>'' then
                     begin
                        { init the map }
                        new(hp^.map);
                        { load the used units }
                        hp^.ppufile^.read_data(b,1,count);
                        while (b<>ibend) and (b=ibloadunit) do
                          begin
                             { read unit name }
                             hp^.ppufile^.read_data(hs[0],1,count);
                             hp^.ppufile^.read_data(hs[1],ord(hs[0]),count);
                             hp^.ppufile^.read_data(checksum,4,count);
                             loaded_unit:=loadunit(hs,false);
                             { if the crc of a used unit is the same as }
                             { written to the PPU file, we needn't to   }
                             { recompile the current unit               }
                             if (loaded_unit^.crc<>checksum) or
                                (hp^.sources_avail and do_build) then
                               begin
                                  { we have to compile the current unit }
                                  { remove stuff which isn't needed     }
                                  { forget the map }
                                  dispose(hp^.map);
                                  hp^.map:=nil;
                                  hp^.ppufile^.close;
                                  dispose(hp^.ppufile,done);
                                  hp^.ppufile:=nil;

                                  hs:=hp^.msource^;
                                  fsplit(hs,p,n,e);
                                  compile(p,n,e,compile_system);
                                  usedunits.concat(new(pused_unit,init(hp,0)));
                                  goto ready;
                               end;
                             { setup the map entry for deref }
                             hp^.map^[nextmapentry]:=loaded_unit^.symtable;
                             inc(nextmapentry);

                             if nextmapentry>maxunits then
                               fatalerror(too_much_units);

                             { read until ibend }
                             hp^.ppufile^.read_data(b,1,count);
                          end;

                        { ok, now load the unit }
                        hp^.symtable:=new(punitsymtable,load(s));

                        { if this is the system unit insert the intern }
                        { symbols                                      }
                        if compile_system then
                          insertinternsyms(psymtable(hp^.symtable));

                        { now only read the implementation part }
                        { load the used units }
                        hp^.ppufile^.read_data(b,1,count);
                        while (b<>ibend) and (b=ibloadunit) do
                          begin
                             { read unit name }
                             hp^.ppufile^.read_data(hs[0],1,count);
                             hp^.ppufile^.read_data(hs[1],ord(hs[0]),count);
                             hp^.ppufile^.read_data(checksum,4,count);
                             loaded_unit:=loadunit(hs,false);
                             { if the crc of a used unit is the same as }
                             { written to the PPU file, we needn't to   }
                             { recompile the current unit               }
                             { but for the implementation part          }
                             { the written crc is false, because        }
                             { not defined when writing the ppufile !!  }
                             if (hp^.sources_avail and do_build) then
                               begin
                                  { we have to compile the current unit }
                                  { remove stuff which isn't needed     }
                                  { forget the map }
                                  dispose(hp^.map);
                                  hp^.map:=nil;
                                  hp^.ppufile^.close;
                                  dispose(hp^.ppufile,done);
                                  hp^.ppufile:=nil;

                                  hs:=hp^.msource^;
                                  fsplit(hs,p,n,e);
                                  compile(p,n,e,compile_system);
                                  usedunits.concat(new(pused_unit,init(hp,0)));
                                  goto ready;
                               end;

                             { read until ibend }
                             hp^.ppufile^.read_data(b,1,count);
                          end;

                        dispose(hp^.map);
                        hp^.map:=nil;

                        hp^.ppufile^.close;
                     end;
                end;
              { register the unit _once_ }
              usedunits.concat(new(pused_unit,init(hp,0)));
              { the unit is written, so we can set the symtable type }
              { to unitsymtable, else we get some dupid errors       }
              { this is not the right place because of the           }
              { ready label                                          }
              { psymtable(hp^.symtable)^.symtabletype:=unitsymtable; }
              { placed at this end of proc_unit                      }
              psymtable(hp^.symtable)^.unitid:=0;
              { reset the unitnumbers for the other units }
              pu:=pused_unit(old_current_module^.used_units.first);
              while assigned(pu) do
                begin
                   psymtable(pu^.u^.symtable)^.unitid:=pu^.unitid;
                   pu:=pused_unit(pu^.next);
                end;
           end
         else
           if assigned(hp) and (st=nil) then
             begin
                { we have to compile the unit again, but it is already inserted !!}
                { we may have problem with the lost symtable !!
                }
                current_module:=hp;
                hs:=hp^.msource^;
                { we have to cleanup a little }
                hp^.special_done;
                hp^.init_unit(n);
                fsplit(hs,p,n,e);
                if veryverbose then
                  begin
                     writeln('Compiling ',hs,' for the second time ');
                     readln;
                  end;
                compile(p,n,e,compile_system);
                current_module^.compiled:=true;
             end;
      ready:
         { set the old module }
         current_module:=old_current_module;
         { the current module uses the unit hp }
         current_module^.used_units.concat(new(pused_unit,init(hp,0)));
         if not current_module^.in_implementation then
           pused_unit(current_module^.used_units.last)^.in_interface:=true;
         loadunit:=hp;
      end;

    procedure loadunits;

      var
         s : stringid;
         hp : pused_unit;
         hp2 : pmodule;
         hp3 : psymtable;

      begin
         consume(_USES);
         repeat
           s:=pattern;
           consume(ID);
           hp2:=loadunit(s,false);
           hp2^.in_uses := true;
           if current_module^.compiled then
             exit;
           refsymtable^.insert(new(punitsym,init(s,hp2^.symtable)));

           if token=COMMA then consume(COMMA)
             else break;
         until false;
         consume(SEMICOLON);

         { now insert the units in the symtablestack }
         hp:=pused_unit(current_module^.used_units.first);
         while assigned(hp) do
           begin
{$IfDef GDB }
              if (cs_debuginfo in aktswitches) and
                not punitsymtable(hp^.u^.symtable)^.is_stab_written then
                begin
                   punitsymtable(hp^.u^.symtable)^.concattypestabto(debuglist);
                   hp^.unitid:=psymtable(hp^.u^.symtable)^.unitid;
                end;
{$EndIf GDB }
              if hp^.u^.in_uses then
                begin
                   hp3:=symtablestack;
                   while assigned(hp3) do
                     begin
                        { insert units only once ! }
                        if hp^.u^.symtable=hp3 then
                          break;
                        hp3:=hp3^.next;
                        { unit isn't inserted }
                        if hp3=nil then
                          begin
                             psymtable(hp^.u^.symtable)^.next:=symtablestack;
                             symtablestack:=psymtable(hp^.u^.symtable);
                          end;
                     end;
                end;
              hp:=pused_unit(hp^.next);
           end;
      end;

    procedure readconstdefs;

      begin
         s32bitdef:=porddef(globaldef('longint'));
         cstringdef:=pstringdef(globaldef('string'));
         cchardef:=porddef(globaldef('char'));
         c64floatdef:=pfloatdef(globaldef('s64real'));
         s80floatdef:=pfloatdef(globaldef('s80real'));
         s32fixeddef:=pfloatdef(globaldef('cs32fixed'));
         voiddef:=porddef(globaldef('void'));
         u8bitdef:=porddef(globaldef('byte'));
         u16bitdef:=porddef(globaldef('word'));
         booldef:=porddef(globaldef('boolean'));
         voidpointerdef:=ppointerdef(globaldef('void_pointer'));
      end;

    procedure proc_unit;

      var
         unitname : stringid;
{$ifdef GDB}
         stringd : stringid;
         { several defs to simulate more or less C++ objects for GDB }
         vmtdef : precdef;
         pvmtdef : ppointerdef;
         vmtarraydef : parraydef;
         vmtsymtable : psymtable;
{$endif GDB}
         code : ptree;
         p : psymtable;
         unitst : punitsymtable;
         pu : pused_unit;
{$ifdef GDB}
         entrystack,exitstack,storestack  : pinputfile;
         entryline, exitline,storeline : longint;
{$endif GDB}
         { the output ppufile is written to this path }
         outputname : string;

      begin
         if gendeffile then
           error(def_only_in_program);

         outputname:=current_module^.current_inputfile^.path^+current_module^.current_inputfile^.name^+
           target_info.unitext;

         consume(_UNIT);
         if (cs_compilesystem in aktswitches) and
            (
              not(upper(pattern)=upper(target_info.system_unit)) or
              (length(pattern)>8) or
              (upper(pattern)<>upper(current_module^.current_inputfile^.name^))
            )
            and (cs_check_unit_name in aktswitches) then
           error(ill_unit_name);

         unitname:=pattern;

         { this is a direct compiled unit           }
         { (unit file is given by the command line)
         if not(assigned(current_module^.ppufile)) then
           begin
              current_module^.ppufile:=new(pextfile,init(current,,target_info.unitext));
           end;
         }
         consume(ID);
         consume(SEMICOLON);
         consume(_INTERFACE);

         { this should be placed after uses !!}
         procprefix:='_'+unitname+'$$';
         parse_only:=true;

         { generate now the global symboltable }
         p:=new(punitsymtable,init(globalsymtable,unitname));
         refsymtable:=p;
         unitst:=punitsymtable(p);

         { set the symbol table for the current unit }
         current_module^.symtable:=psymtable(p);

         { insert qualifier for the system unit (allows system.writeln) }
         if not(cs_compilesystem in aktswitches) then
           begin
              { insert the system unit }
              systemunit^.next:=symtablestack;
              symtablestack:=systemunit;
              refsymtable^.insert(new(punitsym,init('SYSTEM',systemunit)));

              if token=_USES then
                begin
                   unitst^.symtabletype:=unitsymtable;
                   loadunits;
                   { has it been compiled at a higher level ?}
                   if current_module^.compiled then
                     exit;
                   unitst^.symtabletype:=globalsymtable;
                end;

              { ... but insert the symbol table later }
              p^.next:=symtablestack;
              symtablestack:=p;
           end
         else
         { while compiling a system unit, some types are directly inserted }
           begin
              p^.next:=symtablestack;
              symtablestack:=p;
              p^.insert(new(ptypesym,init('longint',s32bitdef)));
              p^.insert(new(ptypesym,init('void',voiddef)));
              p^.insert(new(ptypesym,init('char',cchardef)));
              p^.insert(new(ptypesym,init('s64real',c64floatdef)));
              p^.insert(new(ptypesym,init('s80real',s80floatdef)));
              p^.insert(new(ptypesym,init('cs32fixed',s32fixeddef)));
              p^.insert(new(ptypesym,init('byte',u8bitdef)));
              p^.insert(new(ptypesym,init('string',cstringdef)));
              p^.insert(new(ptypesym,init('word',u16bitdef)));
              p^.insert(new(ptypesym,init('boolean',booldef)));
              p^.insert(new(ptypesym,init('void_pointer',voidpointerdef)));

              p^.insert(new(ptypesym,init('REAL',new(pfloatdef,init(s64real)))));
              p^.insert(new(ptypesym,init('COMP',new(pfloatdef,init(s64bit)))));
              p^.insert(new(ptypesym,init('EXTENDED',new(pfloatdef,init(s80real)))));
              p^.insert(new(ptypesym,init('SINGLE',new(pfloatdef,init(s32real)))));

              p^.insert(new(ptypesym,init('POINTER',new(ppointerdef,init(voiddef)))));
              p^.insert(new(ptypesym,init('STRING',cstringdef)));
              p^.insert(new(ptypesym,init('BOOLEAN',new(porddef,init(bool8bit,0,1)))));
              p^.insert(new(ptypesym,init('CHAR',new(porddef,init(uchar,0,255)))));
              p^.insert(new(ptypesym,init('TEXT',new(pfiledef,init(ft_text,nil)))));
              p^.insert(new(ptypesym,init('CARDINAL',new(porddef,init(u32bit,0,0)))));
	      p^.insert(new(ptypesym,init('FIXED',new(pfloatdef,init(f32bit)))));
{$ifdef typedfile }
              p^.insert(new(ptypesym,init('TYPEDFILE',new(pfiledef,init(ft_typed,voiddef)))));
{$endif typedfile }
              { !!!!!
              p^.insert(new(ptypesym,init('COMP',new(porddef,init(s64bit,0,0)))));
              p^.insert(new(ptypesym,init('SINGLE',new(porddef,init(s32real,0,0)))));
              p^.insert(new(ptypesym,init('EXTENDED',new(porddef,init(s80real,0,0)))));
              p^.insert(new(ptypesym,init('FILE',new(pfiledef,init(ft_untyped,nil)))));
              }
              { Add a type for virtual method tables in lowercase }
              { so it isn't reachable!                            }
{$ifdef GDB}
              vmtsymtable:=new(psymtable,init(recordsymtable));
              vmtdef:=new(precdef,init(vmtsymtable));
              pvmtdef:=new(ppointerdef,init(vmtdef));
              vmtsymtable^.insert(new(pvarsym,init('parent',pvmtdef)));
              vmtsymtable^.insert(new(pvarsym,init('length',globaldef('longint'))));
              vmtsymtable^.insert(new(pvarsym,init('mlength',globaldef('longint'))));
              vmtarraydef:=new(parraydef,init(0,1,s32bitdef));
              vmtarraydef^.definition := voidpointerdef;
              vmtsymtable^.insert(new(pvarsym,init('__pfn',vmtarraydef)));
              p^.insert(new(ptypesym,init('__vtbl_ptr_type',vmtdef)));
              p^.insert(new(ptypesym,init('pvmt',pvmtdef)));
              vmtarraydef:=new(parraydef,init(0,1,s32bitdef));
              vmtarraydef^.definition := pvmtdef;
              p^.insert(new(ptypesym,init('vtblarray',vmtarraydef)));
              insertinternsyms(p);
{$endif GDB}
           end;

         { duplicated here to be sure }
         procprefix:='_'+unitname+'$$';
         constsymtable:=symtablestack;

         { ... parse the declarations }
         repeat
           case token of
              _CONST : const_dec;
              _TYPE : type_dec;
              _VAR : var_dec;
              _FUNCTION,_PROCEDURE : unter_dec;
              else
                begin
                   consume(_IMPLEMENTATION);
                   break;
                end;
           end;
         until false;
         parse_only:=false;
         refsymtable^.number_defs;

{$ifdef GDB}
         { add all used definitions even for implementation}
         if (cs_debuginfo in aktswitches) then
           begin
              { all types }
              punitsymtable(refsymtable)^.concattypestabto(debuglist);
              { and all local symbols}
              refsymtable^.concatstabto(debuglist);
           end;
{$endif GDB}
         { for interdependent units
         the crc is included in the ppufile
         but it is not known when writing the first ppufile
         so I tried to add a fake writing of the ppu
         just to get the CRC
         but the result is different for the real CRC
         it calculates after, I don't know why

         Answer:
         -------
         When reading the interface part, the compiler assumes
         that all registers are modified by a procedure
         usedinproc:=$ff !
         If the definition is read, the compiler determines
         the used registers and write the correct value
         to usedinproc

         only_calculate_crc:=true;
         writeunitas(current_module^.current_inputfile^.path^+current_module^.current_inputfile^.name^+
                     +'.PPS',punitsymtable(symtablestack));
         only_calculate_crc:=false;
         }
         { generates static symbol table }
         p:=new(punitsymtable,init(staticsymtable,unitname));
         refsymtable:=p;

         { testing !!!!!!!!! }
         { we set the interface part as a unitsymtable  }
         { for the case we need to compile another unit }
         if token=_USES then
           begin
              current_module^.in_implementation:=true;
              unitst^.symtabletype:=unitsymtable;
              loadunits;
              unitst^.symtabletype:=globalsymtable;
              current_module^.in_implementation:=false;
           end;

         { duplicated here to be sure }
         procprefix:='_'+unitname+'$$';

         { but insert later }
         p^.next:=symtablestack;
         symtablestack:=p;

         constsymtable:=symtablestack;

{$ifdef Splitheap}
         if testsplit then
           begin
              Split_Heap;
              allow_special:=true;
              Switch_to_temp_heap;
           end;
{$endif Splitheap}
         { setup codegenerator }
         codegen_newprocedure;

{$ifdef Splitheap}
        { it will report all crossings }
         allow_special:=false;
{$endif Splitheap}
         { set some informations }
         procinfo.retdef:=voiddef;
         procinfo._class:=nil;

         { for temporary values }
         procinfo.framepointer:=R_EBP;

         { clear flags }
         procinfo.flags:=0;

         repeat
           case token of
              _CONST : const_dec;
              _TYPE : type_dec;
              _VAR : var_dec;
              _FUNCTION,_PROCEDURE,
              _CONSTRUCTOR,_DESTRUCTOR : unter_dec;
              else break;
           end;
         until false;

         { reset temporary space }
         cleartempgen;

         { some other initialisations }
         getlabel(aktexitlabel);
         getlabel(aktexit2label);

         in_except_block:=false;
         aktbreaklabel:=0;
         aktcontinuelabel:=0;

         if token=_BEGIN then
           begin
              current_module^.flags:=current_module^.flags or uf_init;
              if veryverbose then
                writeln('Processing unit initialisation part');

              { usedunits^.insert(unitname); }
{$ifdef GDB}
              if (cs_debuginfo in aktswitches) then
                begin
                   codesegment^.concat(new(pai_stabs,init(strpnew(' "INIT$$'+unitname+':F'+voiddef^.numberstring+'",'
                      +'36,0,'+tostr(current_module^.current_inputfile^.line_no)+',INIT$$'+unitname))));
                if target_info.use_function_relative_addresses then
                  codesegment^.concat(new(pai_stab_function_name,init(strpnew('INIT$$'+unitname))));
                end;
              codesegment^.concat(new(pai_symbol,init_global('INIT$$'+unitname)));
{$endif GDB}
{$ifndef GDB}
              code:=befehlsblock;
{$else * GDB *}
              entrystack:=current_module^.current_inputfile;
              entryline:=current_module^.current_inputfile^.line_no;
              code:=block;
              exitstack:=current_module^.current_inputfile;
              exitline:=current_module^.current_inputfile^.line_no;
              setfirsttemp(procinfo.firsttemp);
{$endif * GDB *}
              generatecode(code);

              { the code isn't never needed }
              disposetree(code);
{$ifdef GDB}
              storeline:=entrystack^.line_no;
              entrystack^.line_no:=entryline;
              storestack:=current_module^.current_inputfile;
              current_module^.current_inputfile:=entrystack;
{$endif GDB}
              if gettempsize<>0 then
                procinfo.aktentrycode^.insert(new(pai386,op_const_reg(A_SUB,S_L,gettempsize,R_ESP)));
{$ifdef GDB}
              resettempgen;
{$endif GDB}
              procinfo.aktentrycode^.insert(new(pai386,op_reg_reg(A_MOV,S_L,R_ESP,R_EBP)));
              procinfo.aktentrycode^.insert(new(pai386,op_reg(A_PUSH,S_L,R_EBP)));
{$ifdef GDB}
              entrystack^.line_no := storeline;
              storeline := exitstack^.line_no;
              exitstack^.line_no := exitline;
              current_module^.current_inputfile := exitstack;
{$endif GDB}
              procinfo.aktexitcode^.concat(new(pai_label,init(aktexitlabel)));
              procinfo.aktexitcode^.concat(new(pai_label,init(aktexit2label)));
              procinfo.aktexitcode^.concat(new(pai386,op_none(A_LEAVE,S_NO)));
              procinfo.aktexitcode^.concat(new(pai386,op_none(A_RET,S_NO)));

{$ifdef GDB}
              if cs_debuginfo in aktswitches  then
                begin
                  procinfo.aktexitcode^.concat(new(pai_stabn,init(strpnew('192,0,0,INIT$$'+unitname))));
                  procinfo.aktexitcode^.concat(new(pai_stabn,init(strpnew('224,0,0,'
                    +target_info.labelprefix+tostr(aktexit2label)))));
                end;
{$endif GDB}

              procinfo.aktproccode^.insertlist(procinfo.aktentrycode);
              procinfo.aktproccode^.concatlist(procinfo.aktexitcode);

              if cs_optimize in aktswitches then
                peepholeopt(procinfo.aktproccode);

              codesegment^.concatlist(procinfo.aktproccode);
           end
         else
           begin
              consume(_END);

              { ~ signs, that the unit is initilisized anywhere }
              { usedunits^.insert('~'+unitname); }
           end;

         codegen_doneprocedure;


         consume(POINT);

         { size of the static data }
         datasize:=symtablestack^.datasize;

         { unsed static symbols ? }
         symtablestack^.allsymbolsused;

{$ifdef GDB}
         { add all used definitions even for implementation}
         if (cs_debuginfo in aktswitches) then
           begin
              { all types }
              punitsymtable(symtablestack)^.concattypestabto(debuglist);
              { and all local symbols}
              symtablestack^.concatstabto(debuglist);
           end;
{$endif GDB}

         { dels static symbols }
         dellexlevel;

         { deletes all symtables generated in the implementation part }
         while symtablestack^.symtabletype<>globalsymtable do
           dellexlevel;

         { tests, if all forwards are resolved }
         symtablestack^.check_forwards;
         symtablestack^.symtabletype:=unitsymtable;
         punitsymtable(symtablestack)^.is_stab_written:=false;
         if codegeneration then
           writeunitas(outputname,punitsymtable(symtablestack));

         pu:=pused_unit(usedunits.first);
         while assigned(pu) do
           begin
              punitsymtable(pu^.u^.symtable)^.is_stab_written:=false;
              pu:=pused_unit(pu^.next);
           end;
         inc(datasize,symtablestack^.datasize);
{$IfNDef CleanUp}
         dellexlevel;
{$EndIf Not CleanUp}
      end;

    function findfile(const s : string) : string;

      var
         found : boolean;
         dirinfo : searchrec;
         envstring : string;
         f : file;

      begin
         findfirst(s+target_info.objext,anyfile,dirinfo);
         if doserror=0 then
           begin
              findfile:='';
              exit;
           end;
         findfirst(exepath+s+target_info.objext,anyfile,dirinfo);
         if doserror=0 then
           begin
              findfile:=exepath;
              exit;
           end;
         findfile:=search(s+target_info.objext,unitsearchpath,found);
         if found then
           exit;
         {
         lib_env never exits (since 0.6.3)
         findfile:=search(s+target_info.objext,getenv(target_info.lib_env),found);
         if found then
           exit;
         }
         findfile:='';
      end;

    procedure proc_program;

      var
         st : psymtable;
         programname : stringid;
         unitinits : taasmoutput;
         code : ptree;
         hp : pused_unit;
{$ifdef GDB}
         entrystack,exitstack, storestack  : pinputfile;
         entryline, exitline, storeline : longint;
{$endif GDB}

      begin
         { -Us gives an error }
         if cs_compilesystem in aktswitches then
           consume(_UNIT);

         parse_only:=false;
         programname:='';

         { is there an program head ? }
         if token=_PROGRAM then
           begin
              consume(_PROGRAM);
              programname:=pattern;
              consume(ID);
              if token=LKLAMMER then
                begin
                   consume(LKLAMMER);
                   idlist;
                   consume(RKLAMMER);
                end;
              consume(SEMICOLON);
           end;

         { insert after the unit symbol tables the static symbol table }
         { of the program                                              }
         st:=new(punitsymtable,init(staticsymtable,programname));

         refsymtable:=st;
         { insert the system unit }
         symtablestack:=systemunit;
         systemunit^.next:=nil;
         refsymtable^.insert(new(punitsym,init('SYSTEM',systemunit)));
         if token=_USES then loadunits;

         st^.next:=symtablestack;
         symtablestack:=st;
         if programname<>'' then
           symtablestack^.insert(new(pprogramsym,init(programname)));

         { ...is also constsymtable, this is the symtable where }
         { the elements of enumeration types are inserted       }
         constsymtable:=st;

         codegen_newprocedure;

         { set some informations about the main program }
         procinfo.retdef:=voiddef;
         procinfo._class:=nil;

         { for temporary values }
         procinfo.framepointer:=R_EBP;

         { clear flags }
         procinfo.flags:=0;

         procprefix:='';
         in_except_block:=false;
         aktbreaklabel:=0;
         aktcontinuelabel:=0;

         getlabel(aktexitlabel);
         getlabel(aktexit2label);

         { reset temporary variables }
         cleartempgen;

         assign(linkresponse,inputdir+'link.res');
         rewrite(linkresponse);
         { this has to be in first position to enable go32-v2
           to recognize a V1 application from a V2 }

         if target_info.target=target_DOS then
           writeln(linkresponse,findfile('prt0')+'PRT0.o');

         if target_info.target=target_LINUX then
           begin
              { This MUST be first in LINUX. The stub MUST be placed first. }
                if linux_linktoc then
              writeln(linkresponse,'SEARCH_DIR ('+gcclibpath +')');

              writeln(linkresponse,'INPUT (');
              if linux_linktoc then
                { link to c run-time library }
                writeln(linkresponse,'/usr/lib/crt0.o')
              else
                { Link to native pascal run-time library }
{$ifdef tp}
                writeln(linkresponse,globals.lowercase(findfile('prt0')+'prt0.o'));
{$else}
                writeln(linkresponse,lowercase(findfile('prt0')+'prt0.o'));
{$endif}
              writeln(linkresponse,inputdir+inputfile+'.o');
           end;

         unitinits.init;
         hp:=pused_unit(usedunits.first);
         while assigned(hp) do
           begin
              { call the unit init code and make it external }
              if (hp^.u^.flags and uf_init)<>0 then
                begin
                   unitinits.concat(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol('INIT$$'+hp^.u^.name^,0))));
                   externals^.concat(new(pai_external,init('INIT$$'+hp^.u^.name^)));
                end;

              if ((target_info.target=target_DOS) or
                 (target_info.target=target_OS2)) then
                writeln(linkresponse,findfile(hp^.u^.name^)+hp^.u^.name^+target_info.objext);

              if (target_info.target=target_LINUX) then
{$ifdef tp}
                writeln(linkresponse,globals.lowercase(findfile(globals.lowercase(hp^.u^.name^))+hp^.u^.name^)+
                  target_info.objext);
{$else}
                writeln(linkresponse,lowercase(findfile(lowercase(hp^.u^.name^))+hp^.u^.name^)+target_info.objext);
{$endif}

              hp:=pused_unit(hp^.next);
           end;

         { some extra stuff for different operating systems }
         if target_info.target=target_DOS then
           begin
              if target_info.short_name='GO32V2' then
                begin
                   writeln(linkresponse,'-o '+inputdir+inputfile+'.exe');
                   { We use now the COFF exe format }
                   writeln(linkresponse,'-oformat coff-go32-exe');
                end
              else
                begin
                   writeln(linkresponse,'-oformat coff-go32');
                   writeln(linkresponse,'-o '+inputdir+inputfile);
                end;
              { to use DBX stabs we need to put the main file object at last }
              writeln(linkresponse,inputdir+inputfile+'.o');
           end;

         if target_info.target=target_OS2 then
           begin
              writeln(linkresponse,'-o '+inputdir+inputfile);
              { writeln(linkresponse,inputdir+inputfile+'.obj');}
              if gendeffile then
                writeln(linkresponse,inputdir+inputfile+'.def');
           end;


{$ifdef GDB}
         entrystack:=current_module^.current_inputfile;
         entryline:=current_module^.current_inputfile^.line_no;
{$endif GDB}
         if veryverbose then
           writeln('Processing main program.');
         code:=block;
{$ifdef GDB}

         exitstack:=current_module^.current_inputfile;
         exitline:=current_module^.current_inputfile^.line_no;
{$endif * GDB *}
{$ifdef GDB}
         setfirsttemp(procinfo.firsttemp);
{$endif * GDB *}
         generatecode(code);
{$ifdef GDB}
         { the code isn't needed }
         disposetree(code);
{$endif * GDB *}

{$ifdef GDB}
         storeline := entrystack^.line_no;
         entrystack^.line_no := entryline;
         storestack := current_module^.current_inputfile;
         current_module^.current_inputfile := entrystack;
{$endif * GDB *}
         procinfo.aktentrycode^.insertlist(@unitinits);
         if gettempsize<>0 then
           procinfo.aktentrycode^.insert(new(pai386,op_const_reg(A_SUB,S_L,gettempsize,R_ESP)));
{$ifdef GDB}
         resettempgen;
{$endif * GDB *}
         procinfo.aktentrycode^.insert(new(pai386,op_reg_reg(A_MOV,S_L,R_ESP,R_EBP)));
         procinfo.aktentrycode^.insert(new(pai386,op_reg(A_PUSH,S_L,R_EBP)));

         if (target_info.target=target_OS2) then
           procinfo.aktentrycode^.insert(new(pai_symbol,init_global('_main')))
         else if (target_info.target=target_DOS) then
           begin
              procinfo.aktentrycode^.insert(new(pai_symbol,init_global('_main')));
              procinfo.aktentrycode^.insert(new(pai_symbol,init_global('PASCALMAIN')));
           end
         else
           procinfo.aktentrycode^.insert(new(pai_symbol,init_global('PASCALMAIN')));

{$ifdef GDB}
         if (cs_debuginfo in aktswitches) and
            target_info.use_function_relative_addresses then
              begin
                 procinfo.aktentrycode^.insert(new(pai_stab_function_name,init(strpnew('PASCALMAIN'))));
                 procinfo.aktentrycode^.concat(new(pai_stabs,init(strpnew(' "PASCALMAIN:F'+voiddef^.numberstring+'",'
                   +'36,0,'+tostr(current_module^.current_inputfile^.line_no)+',PASCALMAIN'))));
              end;
{$endif GDB}
         procinfo.aktexitcode^.concat(new(pai_label,init(aktexitlabel)));
         procinfo.aktexitcode^.concat(new(pai_label,init(aktexit2label)));

         procinfo.aktexitcode^.concat(new(pai386,op_csymbol(A_CALL,S_NO,newcsymbol('__EXIT',0))));
         externals^.concat(new(pai_external,init('__EXIT')));
         procinfo.aktexitcode^.concat(new(pai386,op_none(A_LEAVE,S_NO)));
         procinfo.aktexitcode^.concat(new(pai386,op_none(A_RET,S_NO)));

{$ifdef GDB}
         if cs_debuginfo in aktswitches  then
            begin
               procinfo.aktexitcode^.concat(new(pai_stabn,init(strpnew('192,0,0,PASCALMAIN'))));
               procinfo.aktexitcode^.concat(new(pai_stabn,init(strpnew('224,0,0,'
                 +target_info.labelprefix+tostr(aktexit2label)))));
            end;
         if (cs_debuginfo in aktswitches) and
            assigned(symtablestack) then
            begin
               punitsymtable(symtablestack)^.concattypestabto(debuglist);
               symtablestack^.concatstabto(debuglist);
            end;
{$endif GDB}
         procinfo.aktproccode^.insertlist(procinfo.aktentrycode);
         procinfo.aktproccode^.concatlist(procinfo.aktexitcode);

         if cs_optimize in aktswitches then
           peepholeopt(procinfo.aktproccode);

         codesegment^.concatlist(procinfo.aktproccode);

         codegen_doneprocedure;

         { generate heap }
         if (target_info.target=target_DOS) or
            (target_info.target=target_LINUX) then
           begin
              { heap of DOS and LINUX are in the data segment }
              bsssegment^.concat(new(pai_datablock,init_global(
                'HEAP',heapsize)));
           end;
         if (target_info.short_name='GO32V2') then
           begin
              { stacksize can be specified }
              datasegment^.concat(new(pai_symbol,init_global('__stklen')));
              datasegment^.concat(new(pai_const,init_32bit(stacksize)));
           end;
         datasegment^.concat(new(pai_symbol,init_global('HEAPSIZE')));
         datasegment^.concat(new(pai_const,init_32bit(heapsize)));

         datasize:=symtablestack^.datasize;
         symtablestack^.check_forwards;
         symtablestack^.allsymbolsused;

{$ifndef CleanUp}
         while assigned(symtablestack) do
           dellexlevel;
{$endif not CleanUp}

         consume(POINT);
      end;

    function factor(getaddr : boolean) : ptree;

      var
         l : longint;
         p1,p2,p3 : ptree;
         code : word;
         pd,pd2 : pdef;
         nochmal : boolean;
         sym : pvarsym;
         classh : pobjectdef;
         d : double;
         constset : pconstset;

      { reads the parameter for a subroutine call }
      procedure do_proc_call;

        var local_use : longint;

        begin
           local_use := first_local_use;
           first_local_use := 0;
           { want we only determine the address of }
           { a subroutine                          }
           if not(getaddr) then
             begin
                if token=LKLAMMER then
                  begin
                     consume(LKLAMMER);
                     p1^.left:=parse_paras(false);
                     consume(RKLAMMER);
                  end
                else p1^.left:=nil;

                { do firstpass because we need the  }
                { result type                       }
                do_firstpass(p1);
                if first_local_use <> 0 then
                  begin
                  exterror:=strpnew('Problem with first_local_use in do_proc_call '+tostr(first_local_use));
                  warning(user_defined);
                  first_local_use := 0;
                  end;
                pd:=p1^.resulttype;
             end
           else
             begin
                { address operator @: }
                p1^.left:=nil;

                { forget pd }
                pd:=nil;

                { no postfix operators }
                nochmal:=false;
             end;
        first_local_use := first_local_use + local_use;
        end;

      { erzeugt den Knoten fr ein Klassenelement,  }
      { wobei sym auf das Symbol und srsymtable     }
      { auf die entsprechende Symboltabelle zeigen  }
      { mssen und p1 mu ein Knoten auf die Klasse }
      { sein                                        }
      { eigentlich ein Makro                        }

      procedure do_member_read;
        var Store_valid : Boolean;
        begin
           consume(ID);
           if sym=nil then
             begin
                error(id_no_member);
                disposetree(p1);
                p1:=genzeronode(errorn);
             end
           else
             begin
                { nimmt an, das nur procsym's und varsym's in }
                { Symboltabellen von Klassen vorkommen        }
                case sym^.typ of
                   procsym : begin
                                If first_local_use > 0 then
                                  Begin
                                  Store_valid := Must_be_valid;
                                  if (pprocsym(sym)^.definition^.options and poconstructor) <> 0 then
                                    Must_be_valid := False;
                                  {p1 should contain the object ? }
                                  do_firstpass(p1);
                                  Must_be_valid := Store_valid;
                                  end;
                                p1:=genmethodcallnode(pprocsym(sym),
                                  srsymtable,p1);
                                do_proc_call;
                             end;
                   varsym : begin
                               p1:=gensubscriptnode(sym,p1);
                               pd:=sym^.definition;
                            end;
                   else internalerror(16);
                end;
             end;
        end;

      { handles the post fix operators      }
      { p1 and p2 must contain valid values }
      procedure postfixoperators;

        begin
           while nochmal do
             begin
                case token of
                   CARET : begin
                              consume(CARET);
                              if pd^.deftype<>pointerdef then
                                begin
                                   error(invalid_qualifizier);
                                   disposetree(p1);
                                   p1:=genzeronode(errorn);
                                end
                              else
                                begin
                                   p1:=gensinglenode(derefn,p1);
                                   pd:=ppointerdef(pd)^.definition;
                                end;
                           end;
                   LECKKLAMMER : begin
                                    consume(LECKKLAMMER);
                                    repeat
                                      if (pd^.deftype<>arraydef) and
                                         (pd^.deftype<>stringdef) and
                                         (pd^.deftype<>pointerdef) then
                                        begin
                                           error(invalid_qualifizier);
                                           disposetree(p1);
                                           p1:=genzeronode(errorn);
                                        end
                                      else if (pd^.deftype=pointerdef) then
                                        begin
                                           p2:=expr;
                                           p1:=gennode(vecn,p1,p2);
                                           pd:=ppointerdef(pd)^.definition;
                                        end
                                      else
                                        begin
                                           p2:=expr;
                                           p1:=gennode(vecn,p1,p2);
                                           if pd^.deftype=stringdef then
                                             pd:=cchardef
                                           else pd:=parraydef(pd)^.definition;
                                        end;
                                      if token=COMMA then consume(COMMA)
                                        else break;
                                    until false;
                                    consume(RECKKLAMMER);
                                 end;
                   POINT       : begin
                                    consume(POINT);
                                    case pd^.deftype of
                                       recorddef :
                                             begin
                                                sym:=pvarsym(precdef(pd)^.symtable^.search(pattern));
                                                consume(ID);
                                                if sym=nil then
                                                  begin
                                                     error(ill_field);
                                                     disposetree(p1);
                                                     p1:=genzeronode(errorn);
                                                  end
                                                else
                                                  begin
                                                     p1:=gensubscriptnode(sym,p1);
                                                     pd:=sym^.definition;
                                                  end;
                                             end;
                                       objectdef :
                                             begin
                                                classh:=pobjectdef(pd);
                                                sym:=nil;
                                                while assigned(classh) do
                                                  begin
                                                     sym:=pvarsym(classh^.publicsyms^.search(pattern));
                                                     srsymtable:=classh^.publicsyms;
                                                     if assigned(sym) then
                                                       break;
                                                     classh:=classh^.childof;
                                                  end;
                                                do_member_read;
                                             end
                                          else
                                             begin
                                                error(invalid_qualifizier);
                                                disposetree(p1);
                                                p1:=genzeronode(errorn);
                                             end;
                                    end;
                                 end;
                   else
                     begin
                        { is this a procedure variable ? }
                        if pd^.deftype=procvardef then
                          begin
                             if token=LKLAMMER then
                               begin
                                  { do this in a strange way  }
                                  { it's not a clean solution }
                                  p2:=p1;
                                  p1:=gencallnode(nil,
                                    nil);
                                  p1^.right:=p2;
                                  consume(LKLAMMER);
                                  p1^.left:=parse_paras(false);
                                  consume(RKLAMMER);
                                  pd:=pprocvardef(pd)^.retdef;
                                  p1^.resulttype:=pd;
                               end
                             else nochmal:=false;
                          end
                        else nochmal:=false;
                     end;
                end;
           end;
      end;

    procedure do_set(p : pconstset;pos : longint);

      var
         l : longint;

      begin
         if (pos>255) or
            (pos<0) then
           error(illsetexpr);
         l:=pos div 8;
         p^[l]:=p^[l] or (1 shl (pos mod 8));
      end;

      begin
         case token of
            ID       : begin
                          { allow post fix operators }
                          nochmal:=true;
                          getsym(pattern,true);
                          consume(ID);
                          { is this an access to a function result ? }
                          if assigned(aktprocsym) and
                             (srsym^.name=aktprocsym^.name) and
                              (procinfo.retdef<>pdef(voiddef)) and
                              (token<>LKLAMMER) then
                           begin
                              p1:=genzeronode(funcretn);
                              pd:=procinfo.retdef;
                           end
                          else
                            { else it's a normal symbol }
                            begin
                               if srsym^.typ=unitsym then
                                 begin
                                    consume(POINT);
                                    getsymonlyin(punitsym(srsym)^.unitsymtable,pattern);
                                    consume(ID);
                                 end;
                               case srsym^.typ of
                                  varsym  : begin
                                               p1:=genloadnode(pvarsym(srsym),srsymtable);
                                               if not pvarsym(srsym)^.is_valid  and warnings then
                                                 begin
                                                 p1^.is_first := true;
                                                 inc(first_local_use);
                                                 end;
                                               pd:=pvarsym(srsym)^.definition;
                                            end;
                                  typedconstsym :
                                            begin
                                               p1:=gentypedconstloadnode(ptypedconstsym(srsym),srsymtable);
                                               pd:=ptypedconstsym(srsym)^.definition;
                                            end;
                                  syssym :  begin
                                               p1:=statement_syssym(psyssym(srsym)^.number,pd);
                                            end;
                                  typesym : begin
                                               pd:=ptypesym(srsym)^.definition;
                                               if token=LKLAMMER then
                                                 begin
                                                    consume(LKLAMMER);
                                                    p1:=expr;
                                                    consume(RKLAMMER);
                                                    p1:=gentypeconvnode(p1,pd);
                                                    p1^.explizit:=true;
                                                 end
                                               else if token=POINT then
                                                 begin
                                                    consume(POINT);
                                                    if pd^.deftype=objectdef then
                                                      begin
                                                         if assigned(procinfo._class) then
                                                           begin
                                                              if procinfo._class^.isrelated(pobjectdef(pd)) then
                                                                begin
                                                                   p1:=genzeronode(typen);
                                                                   p1^.resulttype:=pd;
                                                                   srsymtable:=pobjectdef(pd)^.publicsyms;
                                                                   sym:=pvarsym(srsymtable^.search(pattern));
                                                                   do_member_read;
                                                                end
                                                              else
                                                                error(no_super_class);
                                                           end
                                                         else error(generic_methods_only_in_methods);
                                                      end
                                                    else
                                                      error(class_expected);
                                                 end
                                               else
                                                 begin
                                                    { generate a type node }
                                                    { (for typeof etc)     }
                                                    p1:=genzeronode(typen);
                                                    p1^.resulttype:=pd;
                                                    pd:=voiddef;
                                                 end;
                                            end;
                                  aufzaehlsym : begin
                                                  p1:=genaufzaehlnode(paufzaehlsym(srsym));
                                                  pd:=p1^.resulttype;
                                               end;
                                  constsym : begin
                                                case pconstsym(srsym)^.consttype of
                                                   constint : p1:=genordinalconstnode(pconstsym(srsym)^.value,s32bitdef);
                                                   conststring : p1:=genstringconstnode(pstring(pconstsym(srsym)^.value)^);
                                                   constchar : p1:=genordinalconstnode(pconstsym(srsym)^.value,cchardef);
                                                   constreal : p1:=genrealconstnode(pdouble(pconstsym(srsym)^.value)^);
                                                   constbool : p1:=genordinalconstnode(pconstsym(srsym)^.value,booldef);
                                                   constord : p1:=genordinalconstnode(pconstsym(srsym)^.value,
                                                     pconstsym(srsym)^.definition);
                                                end;
                                                pd:=p1^.resulttype;
                                             end;
                                  procsym : begin
                                               p1:=gencallnode(pprocsym(srsym),srsymtable);
                                               do_proc_call;
                                            end;
                                  errorsym : begin
                                                p1:=genzeronode(errorn);
                                                pd:=generrordef;
                                                if token=LKLAMMER then
                                                  begin
                                                     consume(LKLAMMER);
                                                     parse_paras(false);
                                                     consume(RKLAMMER);
                                                  end;
                                             end;
                                  else
                                    begin
                                       p1:=genzeronode(errorn);
                                       pd:=generrordef;
                                       error(error_in_expression);
                                    end;
                               end;
                            end;

                          { handle post fix operators }
                          postfixoperators;
                       end;
            _NEW : begin
                      consume(_NEW);
                      consume(LKLAMMER);
                      p1:=factor(false);
                      if p1^.treetype<>typen then
                        error(type_id_expect);
                      pd:=p1^.resulttype;
                      pd2:=pd;
                      if (pd^.deftype<>pointerdef) or
                         (ppointerdef(pd)^.definition^.deftype<>objectdef) then
                        begin
                           error(pointer_to_class_expect);

                           { if an error occurs, read til the end of the new }
                           { statement                                       }
                           p1:=genzeronode(errorn);
                           l:=1;
                           while true do
                             begin
                                case token of
                                   LKLAMMER : inc(l);
                                   RKLAMMER : dec(l);
                                end;
                                consume(token);
                                if l=0 then
                                  break;
                             end;
                        end
                      else
                        begin
                           disposetree(p1);
                           p1:=genzeronode(hnewn);
                           p1^.resulttype:=ppointerdef(pd)^.definition;
                           consume(COMMA);

                           { determines the current object defintion }
                           classh:=pobjectdef(ppointerdef(pd)^.definition);

                           { check for an abstract class }
                           if (classh^.options and oois_abstract)<>0 then
                             error(no_instance_of_abstract_object);

                           { search the constructor also in the symbol tables of }
                           { the parents                                          }

                           { no constructor found }
                           sym:=nil;
                           while assigned(classh) do
                             begin
                                sym:=pvarsym(classh^.publicsyms^.search(pattern));
                                srsymtable:=classh^.publicsyms;
                                if assigned(sym) then
                                  break;
                                classh:=classh^.childof;
                             end;

                           do_member_read;
                           if (p1^.treetype<>calln) or
                             ((p1^.procdefinition^.options and poconstructor)=0) then
                             error(expr_have_to_be_constructor_call);
                           p1:=gensinglenode(newn,p1);

                           { set the resulttype }
                           p1^.resulttype:=pd2;
                           consume(RKLAMMER);
                        end;
                   end;
            _SELF     : begin
                           nochmal:=true;
                           consume(_SELF);
                           if not assigned(procinfo._class) then
                             begin
                                p1:=genzeronode(errorn);
                                error(self_not_in_method);
                             end
                           else
                             begin
                                p1:=genselfnode(procinfo._class);
                                p1^.resulttype:=procinfo._class;
                                pd:=p1^.resulttype;
                             end;
                           postfixoperators;
                        end;
            _INHERITED : begin
                            nochmal:=true;
                            consume(_INHERITED);
                            if assigned(procinfo._class) then
                              begin
                                 classh:=procinfo._class^.childof;
                                 while assigned(classh) do
                                   begin
                                      srsymtable:=pobjectdef(classh)^.publicsyms;
                                      sym:=pvarsym(srsymtable^.search(pattern));
                                      if assigned(sym) then
                                        begin
                                           p1:=genzeronode(typen);
                                           p1^.resulttype:=classh;
                                           pd:=p1^.resulttype;
                                           do_member_read;
                                           break;
                                        end;
                                      classh:=classh^.childof;
                                   end;
                                 if classh=nil then
                                   error(id_no_member);
                              end
                            else
                              error(generic_methods_only_in_methods);
                            postfixoperators;
                         end;
            INTCONST : begin
                          val(pattern,l,code);
                          if code<>0 then
                            begin
                               error(error_in_integer);
                               l:=1;
                            end;
                          consume(INTCONST);
                          p1:=genordinalconstnode(l,s32bitdef);
                       end;
            REALNUMBER : begin
                          val(pattern,d,code);
                          if code<>0 then
                            begin
                               error(error_in_real);
                               d:=1.0;
                            end;
                          consume(REALNUMBER);
                          p1:=genrealconstnode(d);
                        end;
            { STRING can be also a type cast }
            _STRING : begin
                         pd:=stringtyp;
                         consume(LKLAMMER);
                         p1:=expr;
                         consume(RKLAMMER);
                         p1:=gentypeconvnode(p1,pd);
                         p1^.explizit:=true;
                         { handle postfix operators here e.g. string(a)[10] }
                         nochmal:=true;
                         postfixoperators;
                      end;
            CSTRING : begin
                         p1:=genstringconstnode(pattern);
                         consume(CSTRING);
                      end;
            CCHAR : begin
                         p1:=genordinalconstnode(ord(pattern[1]),cchardef);
                         consume(CCHAR);
                      end;
            KLAMMERAFFE : begin
                             consume(KLAMMERAFFE);
                             p1:=factor(true);
                             p1:=gensinglenode(addrn,p1);
                          end;
            LKLAMMER : begin
                          consume(LKLAMMER);
                          p1:=expr;
                          consume(RKLAMMER);
                          { it's not a good solution        }
                          { but (a+b)^ makes some problems  }
                          case token of
                             CARET,POINT,LECKKLAMMER : begin
                                                          { we need the resulttype  }
                                                          { of the expression in pd }
                                                          do_firstpass(p1);
                                                          pd:=p1^.resulttype;

                                                          nochmal:=true;
                                                          postfixoperators;
                                                       end;
                          end;
                       end;
            LECKKLAMMER : begin
                             consume(LECKKLAMMER);
                             new(constset);
                             for l:=0 to 31 do
                               constset^[l]:=0;
                             p2:=nil;
                             pd:=nil;
                             if token<>RECKKLAMMER then
                               while true do
                                 begin
                                    p1:=expr;
                                    do_firstpass(p1);
                                    case p1^.treetype of
                                       ordconstn : begin
                                                      if pd=nil then
                                                        pd:=p1^.resulttype;
                                                     if not(is_equal(pd,p1^.resulttype)) then
                                                       error(typeconflict_in_set)
                                                     else
                                                       do_set(constset,p1^.value);
                                                     disposetree(p1);
                                                   end;
                                       rangen : begin
                                                   if pd=nil then
                                                     pd:=p1^.left^.resulttype;
                                                   if not(is_equal(pd,p1^.left^.resulttype)) then
                                                     error(typeconflict_in_set)
                                                   else
                                                     for l:=p1^.left^.value to p1^.right^.value do
                                                       do_set(constset,l);
                                                   disposetree(p1);
                                                end;
                                       else
                                          begin
                                             if pd=nil then
                                               pd:=p1^.resulttype;
                                             if not(is_equal(pd,p1^.resulttype)) then
                                               error(typeconflict_in_set);
                                             p2:=gennode(setelen,p1,p2);
                                          end;
                                    end;
                                    if token=COMMA then
                                      consume(COMMA)
                                    else break;
                                 end;
                             consume(RECKKLAMMER);
                             p1:=gensinglenode(setconstrn,p2);
                             p1^.resulttype:=new(psetdef,init(pd,255));
                             p1^.constset:=constset;
                          end;
            PLUS     : begin
                          consume(PLUS);
                          p1:=factor(false);
                       end;
            MINUS    : begin
                          consume(MINUS);
                          p1:=factor(false);
                          p1:=gensinglenode(umminusn,p1);
                       end;
            _NOT     : begin
                          consume(_NOT);
                          p1:=factor(false);
                          p1:=gensinglenode(notn,p1);
                       end;
            _TRUE    : begin
                          consume(_TRUE);
                          p1:=genordinalconstnode(1,booldef);
                       end;
            _FALSE    : begin
                          consume(_FALSE);
                          p1:=genordinalconstnode(0,booldef);
                       end;
            _NIL      : begin
                           consume(_NIL);
                           p1:=genzeronode(niln);
                        end;
            else
              begin
                 p1:=genzeronode(errorn);
                 consume(token);
                 error(error_in_expression);
              end;
         end;
         factor:=p1;
      end;

    function term : ptree;

      var
         p1,p2 : ptree;

      begin
         p1:=factor(false);
         repeat
           case token of
              STAR : begin
                        consume(STAR);
                        p2:=factor(false);
                        p1:=gennode(muln,p1,p2);
                     end;
              SLASH : begin
                        consume(SLASH);
                        p2:=factor(false);
                        p1:=gennode(slashn,p1,p2);
                      end;
              _DIV : begin
                        consume(_DIV);
                        p2:=factor(false);
                        p1:=gennode(divn,p1,p2);
                     end;
              _MOD : begin
                        consume(_MOD);
                        p2:=factor(false);
                        p1:=gennode(modn,p1,p2);
                     end;
              _AND : begin
                        consume(_AND);
                        p2:=factor(false);
                        p1:=gennode(andn,p1,p2);
                     end;
              _SHL : begin
                        consume(_SHL);
                        p2:=factor(false);
                        p1:=gennode(shln,p1,p2);
                     end;
              _SHR : begin
                        consume(_SHR);
                        p2:=factor(false);
                        p1:=gennode(shrn,p1,p2);
                     end;
              _AS : begin
                      consume(_AS);
                      p2:=factor(false);
                      p1:=gennode(asn,p1,p2);
                   end;
              else break;
           end;
         until false;
         term:=p1;
      end;

    function simpl_expr : ptree;

      var
         p1,p2 : ptree;

      begin
         p1:=term;
         repeat
           case token of
              PLUS : begin
                        consume(PLUS);
                        p2:=term;
                        p1:=gennode(addn,p1,p2);
                     end;
              MINUS : begin
                        consume(MINUS);
                        p2:=term;
                        p1:=gennode(subn,p1,p2);
                     end;
              _OR : begin
                        consume(_OR);
                        p2:=term;
                        p1:=gennode(orn,p1,p2);
                     end;
              _XOR : begin
                        consume(_XOR);
                        p2:=term;
                        p1:=gennode(xorn,p1,p2);
                     end;
              else break;
           end;
         until false;
         simpl_expr:=p1;
      end;

    function simpl2_expr : ptree;

      var
         p1,p2 : ptree;

      begin
         p1:=simpl_expr;
         repeat
           case token of
              LT : begin
                      consume(LT);
                      p2:=simpl_expr;
                      p1:=gennode(ltn,p1,p2);
                   end;
              LTE : begin
                      consume(LTE);
                      p2:=simpl_expr;
                      p1:=gennode(lten,p1,p2);
                   end;
              GT : begin
                      consume(GT);
                      p2:=simpl_expr;
                      p1:=gennode(gtn,p1,p2);
                   end;
              GTE : begin
                      consume(GTE);
                      p2:=simpl_expr;
                      p1:=gennode(gten,p1,p2);
                   end;
              EQUAL : begin
                      consume(EQUAL);
                      p2:=simpl_expr;
                      p1:=gennode(equaln,p1,p2);
                   end;
              UNEQUAL : begin
                      consume(UNEQUAL);
                      p2:=simpl_expr;
                      p1:=gennode(unequaln,p1,p2);
                   end;
              _IN : begin
                      consume(_IN);
                      p2:=simpl_expr;
                      p1:=gennode(inn,p1,p2);
                   end;
              _IS : begin
                      consume(_IS);
                      p2:=simpl_expr;
                      p1:=gennode(isn,p1,p2);
                   end;
              else break;
           end;
         until false;
         {if (p1^.treetype in [inn,equaln,unequaln,ltn,lten,gtn,gten])
           and (first_local_use > 0) then
           begin
           do_firstpass(p1);
           if first_local_use <> 0 then
             begin
             exterror := strpnew('Problem with first_local_use  in simple2_exp '+tostr(first_local_use));
             warning(user_defined);
             first_local_use := 0;
             end;
           end;}
         simpl2_expr:=p1;
      end;

    function expr : ptree;

      var
         p1,p2 : ptree;
         local_use : longint;
      begin
         p1:=simpl2_expr;
         if token in [ASSIGNMENT,_PLUSASN,_MINUSASN,_STARASN,_SLASHASN] then
           begin
           local_use := first_local_use;
           first_local_use := 0;
           end else local_use := 0;
         case token of
            POINTPOINT : begin
                            consume(POINTPOINT);
                            p2:=simpl2_expr;
                            p1:=gennode(rangen,p1,p2);
                         end;
            ASSIGNMENT : begin
                            consume(ASSIGNMENT);
{$ifdef tp}
                            p2:=expr;
{$else}
                            { FPKPascal needs this to recognices the call }
                            { because the function name can be used like  }
                            { an simple variable                          }
                            p2:=expr();
{$endif}
                            p1:=gennode(assignn,p1,p2);
                         end;
                         { this is the code for C like assignements }
                         { from an improvement of Peter Schaefer    }
            _PLUSASN   : begin
                            consume(_PLUSASN  );
{$ifdef tp}
                            p2:=expr;
{$else}
                            p2:=expr();
{$endif}

                            p1:=gennode(assignn,p1,gennode(addn,getcopy(p1),p2));
                            { was first
                              p1:=gennode(assignn,p1,gennode(addn,p1,p2));
                              but disposetree assumes that we have a real
                              *** tree *** }
                         end;

            _MINUSASN   : begin
                            consume(_MINUSASN  );
{$ifdef tp}
                            p2:=expr;
{$else}
                            p2:=expr();
{$endif}
                            p1:=gennode(assignn,p1,gennode(subn,getcopy(p1),p2));
                         end;
            _STARASN   : begin
                            consume(_STARASN  );
{$ifdef tp}
                            p2:=expr;
{$else}
                            p2:=expr();
{$endif}
                            p1:=gennode(assignn,p1,gennode(muln,getcopy(p1),p2));
                         end;
            _SLASHASN   : begin
                            consume(_SLASHASN  );
{$ifdef tp}
                            p2:=expr;
{$else}
                            p2:=expr();
{$endif}
                            p1:=gennode(assignn,p1,gennode(slashn,getcopy(p1),p2));
                         end;

         end;
         first_local_use := first_local_use + local_use;
         if (p1^.treetype = assignn) and (first_local_use > 0) then
           begin
           do_firstpass(p1);
           if first_local_use <> 0 then
             begin
             exterror := strpnew('Problem with first_local_use in expr '+tostr(first_local_use));
             warning(user_defined);
             first_local_use := 0;
             end;
           end;
         expr:=p1;
      end;

    procedure initparser;

      begin
         forwardsallowed:=false;

         { ^M means a string or a char, because we don't parse a }
         { type declaration                                      }
         parse_types:=false;

         { we didn't parse a object or class declaration }
         { and no function header                        }
         testaktobject:=0;

         { create error defintion }
         generrordef:=new(perrordef,init);

         symtablestack:=nil;

         { a long time, this was forgotten }
         aktprocsym:=nil;

         current_module:=nil;

         loaded_units.init;

         usedunits.init;
      end;


    procedure compile(const path,filename,ext : string;compile_system : boolean);

      var
         p : porddef;
         hp : pmodule;
         pd : pdef;
         hs : string;
         i : ttoken;
         comp_unit : boolean;

         { some variables to save the compiler state }
         oldtoken : ttoken;
         oldpattern : stringid;

         oldpreprocstack : ppreprocstack;
         oldorgpattern,oldprocprefix : string;
         oldparse_types : boolean;
         oldinputbuffer : pchar;
         oldinputpointer : longint;
         olds_point,oldparse_only : boolean;
         oldc : char;
         oldkommentarebene : word;

         oldbsssegment,olddatasegment,oldcodesegment,
         oldexprasmlist,olddebuglist,oldexternals,oldconsts : paasmoutput;

         old_module : pmodule;
         oldnextlabelnr : longint;

         oldswitches : tcswitches;
         oldmacros,oldrefsymtable,oldsymtablestack : psymtable;


      procedure def_symbol(const s : string);

        var
          mac : pmacrosym;

        begin
           mac:=new(pmacrosym,init(s));
           mac^.defined:=true;
           if veryverbose then
             writeln('Macro defined: ',mac^.name);
           macros^.insert(mac);
        end;

      procedure define_macros;

        var
           mac : pmacrosym;
           hp : pstring_item;

        begin
           hp:=pstring_item(commandlinedefines.first);
           while assigned(hp) do
             begin
                mac:=pmacrosym(macros^.search(hp^.str^));
                if not(assigned(mac)) then
                  begin
                     mac:=new(pmacrosym,init(hp^.str^));
                     macros^.insert(mac);
                  end;
                mac^.defined:=true;
                if veryverbose then
                  writeln('Macro defined: ',mac^.name);
                hp:=pstring_item(hp^.next);
             end;

           { some stuff for TP compatibility }
           def_symbol('CPU86');
           def_symbol('CPU87');

           if (target_info.target=target_DOS) or
              (target_info.target=target_PMODE) then
             begin
                def_symbol('MSDOS');
                def_symbol('DPMI');
             end;
        end;

      procedure gen_external(const s : string);

        begin
           externals^.concat(new(pai_external,init(s)));
        end;

      var
         outfile : pbufferedfile;
         asmfile : file;
      label
         done;

      begin
      inc(compile_level);
      if (compile_level = 1) and ((output_format = of_att)  or
         ((output_format = of_o) and externasm)) then
        begin
           assign(asmres,'ppas.bat');
           rewrite(asmres);
        end;
         { save old state }

         { save symtable state }
         oldsymtablestack:=symtablestack;
         symtablestack:=nil;
         outfile:=nil;
         oldrefsymtable:=refsymtable;
         refsymtable:=nil;
         oldprocprefix:=procprefix;

         old_module:=current_module;

         { first, we assume a program }
         if not(assigned(current_module)) then
           begin
              current_module:=new(pmodule,init_program);
              main_module:=current_module;
           end;
         { reset flags }
         current_module^.flags:=0;

         { save scanner state }
         oldmacros:=macros;
         oldpattern:=pattern;
         oldtoken:=token;
         oldorgpattern:=orgpattern;
         oldparse_types:=parse_types;
         oldpreprocstack:=preprocstack;

         oldinputbuffer:=inputbuffer;
         oldinputpointer:=inputpointer;
         olds_point:=s_point;
         oldc:=c;
         oldkommentarebene:=kommentarebene;

         oldparse_only:=parse_only;

         { save assembler lists }
         olddatasegment:=datasegment;
         oldbsssegment:=bsssegment;
         oldcodesegment:=codesegment;
         olddebuglist:=debuglist;
         oldexternals:=externals;
         oldconsts:=consts;
         oldexprasmlist:=exprasmlist;

         oldswitches:=aktswitches;
         oldnextlabelnr:=nextlabelnr;

         if not quiet then
           writeln('Compiling '+path+filename+ext);

         initscanner(path,filename,ext);

         { copy command line options }
         aktswitches:=initswitches;

         { we need this to make the system unit }
         if compile_system then
           aktswitches:=aktswitches+[cs_compilesystem];

         aktexprlevel:=initexprlevel;
         aktpackrecords:=initpackrecords;

         { init code generator for a new module }
         codegen_newmodule;
         macros:=new(psymtable,init(macrosymtable));

         define_macros;

         { makes new assembler output }
         case output_format of
            of_att,of_o : attasmi3.asmoutlists_init;
            of_wasm,of_obj,of_nasm : intasmi3.asmoutlists_init;
            else internalerror(30000);
         end;

         { defines the help routines as external }

         { object help routines }
         gen_external('HELP_CONSTRUCTOR');
         gen_external('HELP_DESTRUCTOR');

         { I/O }
         gen_external('WRITELN_TEXT');
         gen_external('WRITE_TEXT_STRING');
         gen_external('WRITE_TEXT_LONGINT');
         gen_external('WRITE_TEXT_REAL');
         gen_external('U_'+upper(target_info.system_unit)+'_OUTPUT');
         gen_external('U_'+upper(target_info.system_unit)+'_INPUT');
         gen_external('FLUSH_STDOUT');
{$ifdef typedfile}
         gen_external('TYPED_READ');
         gen_external('TYPED_WRITE');
{$endif typedfile}
         { string functions }
         gen_external('STRCAT');
         gen_external('STRCOPY');

         { set functions }
         gen_external('SET_ADD_SETS');
         gen_external('SET_IN_BYTE');
         gen_external('SET_COMP_SETS');
         gen_external('SET_MUL_SETS');
         gen_external('SET_SET_BYTE');
         gen_external('SET_SUB_SETS');
         { startup scanner }
         token:=yylex;

         { no operator is overloaded }
         {!!!!!!
         for i:=PLUS to last_overloaded do
           overloaded_operators[i]:=nil;
         }
         { if the current file isn't a system unit  }
         { the the system unit will be loaded       }

         if not(cs_compilesystem in aktswitches) then
           begin
              { should be done in unit system (changing the field system_unit)
                                                                      FK
              }
              hp:=loadunit(upper(target_info.system_unit),true);
              systemunit:=psymtable(hp^.symtable);
              readconstdefs;
           end
         else
           begin
              { create defintions for constants }
              registerdef:=false;
              s32bitdef:=new(porddef,init(s32bit,$80000000,$7fffffff));
              cstringdef:=new(pstringdef,init(255));
              cchardef:=new(porddef,init(uchar,0,255));
              c64floatdef:=new(pfloatdef,init(s64real));
              s80floatdef:=new(pfloatdef,init(s80real));
              s32fixeddef:=new(pfloatdef,init(f32bit));

              { !!!!!! u32bit ?}

              { some other definitions }
              voiddef:=new(porddef,init(uvoid,0,0));
              u8bitdef:=new(porddef,init(u8bit,0,255));
              u16bitdef:=new(porddef,init(u16bit,0,65535));
              booldef:=new(porddef,init(bool8bit,0,1));
              voidpointerdef:=new(ppointerdef,init(voiddef));
              systemunit:=nil;
           end;
         registerdef:=true;

         { current return type is void }
         procinfo.retdef:=voiddef;

         { reset lexical level }
         lexlevel:=0;

         { parse source }
         if token=_UNIT then
           begin
              proc_unit;
              if current_module^.compiled then
                goto done;
              comp_unit:=true;
           end

         { a main module needn't to start with program }
         else
           begin
              proc_program;
              comp_unit:=false;
           end;
         consume(_EOF);
         if codegeneration then
           begin
              outfile:=new(pbufferedfile,init(path+filename+target_info.asmext,10000));
              outfile^.rewrite;
              case output_format of
                 { if we generate AT&T generate a response file for the GNU AS }
                 of_att : begin
                             attasmi3.writeasmlists(outfile);
                             dispose(outfile,done);
                             if veryverbose then
                               writeln ('Writing assembler response file: ',inputdir+'as.res');
                               { this is not very usefull }
                               { for multiple compile     }
                             {assign(asmres,path+'as.res');
                             rewrite(asmres);
                             writeln(asmres,'-o '+path+filename+target_info.objext+' '+path+filename+target_info.asmext);
                             close(asmres);}
                             writeln(asmres,'as.exe -D -o '+path+filename+
                                  target_info.objext+' '+path+filename+target_info.asmext);
                          end;
                 of_o : begin
                           attasmi3.writeasmlists(outfile);
                           { close to force a flush }
                           dispose(outfile,done);
                           { calls extern assembler }
{$ifndef linux}
                           if externasm then
                             begin
                                writeln(asmres,'as.exe -D -o '+path+filename+
                                  target_info.objext+' '+path+filename+target_info.asmext);
                             end
                           else
                             begin
                                if not(quiet) then
                                  writeln('Calling assembler...');

                                swapvectors;

                                if target_info.short_name='DOS' then
                                  exec(exepath+'as.exe','-o '+path+filename+
                                    target_info.objext+' '+path+filename+target_info.asmext)
                                else
                                  exec(exepath+'as.exe','-o '+path+filename+
                                    target_info.objext+' '+path+filename+target_info.asmext);
                                swapvectors;

                                { delete assembler file }
                                if not(writeasmfile) then
                                  begin
                                     assign(asmfile,path+filename+target_info.asmext);
                                     erase(asmfile);
                                  end;
{$ifndef tp}
                                if (dosexitcode<>0) or (dosError<>0) then
                                  fatalerror(cant_call_as);
{$else}
                                if (dosexitcode<>0) or (dosError<>0) then
                                  warning(cant_call_as);
{$endif}
                                if not(quiet) then
                                  writeln('Assembled...');

                             end;

                           { for PMODE,                       }
                           { we need an o to omf conversation }
                           if (target_info.target=target_PMODE) then
                             begin
                                if not(quiet) then
                                  writeln('Calling object file converter...');
                                swapvectors;
                                exec(exepath+'o2obj',path+filename+'.o');
                                swapvectors;
                                if (dosexitcode<>0) or (dosError<>0) then
                                  fatalerror(cant_call_o2obj);
                             end;
{$else}
                           if not(quiet) then
                             writeln('Calling assembler...');
                           swapvectors;
                           exec(exepath+'as','-o '+path+filename+target_info.objext+' '+
                             path+filename+target_info.asmext);
                           swapvectors;
                           if (dosexitcode<>0) or (dosError<>0) then
                             halt(100);
                           if not(quiet) then
                             writeln('Assembled...');
{$endif}
                     end;

                 of_wasm : begin
                             intasmi3.writeasmlists(outfile);
                             dispose(outfile,done);
                             if veryverbose then
                               writeln ('Writing assembler response file: ',inputdir+'as.res');
                             assign(asmres,path+'as.res');
                             rewrite(asmres);
                             writeln(asmres,path+filename+target_info.asmext);
                             close(asmres);
                          end;
                 of_obj,
                 of_nasm : begin
                             intasmi3.writeasmlists(outfile);
                             dispose(outfile,done);
                             if veryverbose then
                               writeln ('Writing assembler response file: ',inputdir+'as.res');
                             assign(asmres,path+'as.res');
                             rewrite(asmres);
                             writeln(asmres,path+filename+target_info.asmext);
                             close(asmres);
                          end;
                 else internalerror(30000);
              end;
              { does linking }
              if not(comp_unit) and ((target_info.target=target_DOS) or
                (target_info.target=target_PMODE) or
                (target_info.target=target_OS2) or
                (target_info.target=target_LINUX)) then
                begin
                   if target_info.target=target_LINUX then
                     begin
                        { We must link against the c run-time library stub here}
                        if linux_linktoc then
                          writeln(linkresponse,findfile('lprt')+'lprt.o');
                        writeln(linkresponse,')');
                        if linux_linktoc then
                        { this should be GROUP instead of INPUT ? }
                          writeln(linkresponse,'INPUT ( libc.a libgcc.a libc.a )');
                     end;
                   hs:=linkofiles.get;
                   while hs<>'' do
                     begin
                        if (target_info.target=target_PMODE) then
                          begin
                             { we need an extra handling for wlink }
                          end;
                        writeln(linkresponse,hs);
                        hs:=linkofiles.get;
                     end;
                   close(linkresponse);
                   if externasm then
                     begin
                        writeln(asmres,'ld @'+inputdir+'link.res');
                     end
                   else
                     begin
                        if not(quiet) then
                          writeln('Calling linker...');
                        swapvectors;
{$ifndef linux}
                        if target_info.short_name='DOS' then
                          exec(exepath+'ld','-o '+path+filename+' @link.res')
                        else
                          exec(exepath+'ld','-o '+path+filename+' @link.res');
                        swapvectors;
{$else}
                        exec(exepath+'ld','-o '+path+filename+' @link.res');
{$endif}
                        swapvectors;
                        if (dosexitcode<>0) or (dosError<>0) then
                          halt(100);
                        erase(linkresponse);
                     end;
                end;
           end
         else
           begin
              case language of
                 'D' : write(errorcount,' Fehler');
                 'E' : write(errorcount,' errors');
              end;
              writeln;
           end;
         { clear memory }
         dispose(macros,done);

         codegen_donemodule;
{$ifdef Splitheap}
         if testsplit then
           begin
           allow_special:=true;
           { temp heap should be empty after that !!!}

           Releasetempheap;
           end;
{$endif Splitheap}
         { restore old state }
         { if already compiled jumps directly here }
done:
         { restore symtable state }
         refsymtable:=oldrefsymtable;
         symtablestack:=oldsymtablestack;

         procprefix:=oldprocprefix;

         { close the inputfiles }
         current_module^.sourcefiles.done;
         current_module:=old_module;

         { restore scanner state }
         macros:=oldmacros;
         pattern:=oldpattern;
         token:=oldtoken;
         orgpattern:=oldorgpattern;
         parse_types:=oldparse_types;

         { call donescanner before restoring preprocstack, because }
         { donescanner tests for a empty preprocstack              }
         donescanner;

         preprocstack:=oldpreprocstack;

         aktswitches:=oldswitches;
         inputbuffer:=oldinputbuffer;
         inputpointer:=oldinputpointer;
         s_point:=olds_point;
         c:=oldc;
         kommentarebene:=oldkommentarebene;

         parse_only:=oldparse_only;

         { restore asmlists }
         datasegment:=olddatasegment;
         bsssegment:=oldbsssegment;
         codesegment:=oldcodesegment;
         debuglist:=olddebuglist;
         externals:=oldexternals;
         exprasmlist:=oldexprasmlist;
         consts:=oldconsts;

         nextlabelnr:=oldnextlabelnr;

         reset_gdb_info;
         if (compile_level=1) and ((output_format=of_att)  or
           ((output_format=of_o) and externasm)) then
           begin
              close(asmres);
              { this file has stored all the assembling
                and the linking needed }
              { should be changed to work under linux }
              writeln('closing file ppas.bat');
           end;
         dec(compile_level);
      end;

end.
