{****************************************************************************

                      Copyright (c) 1996,97 by Florian Klaempfl

 ****************************************************************************}

{
  This unit implements an asmoutput class for Intel syntax with
  Intel i386+.

  What's to do:
    o generate extern entries for typed constants and variables
    o generate extern entries for the internal used functions
    o complete op2str array
    o write lines numbers and file names to output file
    o comments
}
unit intasmi3;

  interface

    uses
       globals,systems,errors,cobjects,aasm,i386,strings;

    type
       pi386intelasmoutput = ^ti386intelasmoutput;

       ti386intelasmoutput = object(taasmoutput)
          procedure write_to_file(outfile : pbufferedfile);virtual;
       end;

    { inits the datasegment etc with the output specific list types }
    procedure asmoutlists_init;

    { writes the asmlists to an output file }
    procedure writeasmlists(outfile : pbufferedfile);

    const
       _reg2str : array[R_NO..R_ST7] of string[5] =
          ('','eax','ecx','edx','ebx','esp','ebp','esi','edi',
           'ax','cx','dx','bx','sp','bp','si','di',
           'al','cl','dl','bl','ah','ch','bh','dh',
           '','cs','ds','es','fs','gs','ss',
           'st','st(0)','st(1)','st(2)','st(3)','st(4)',
           'st(5)','st(6)','st(7)');

       _nasmreg2str : array[R_NO..R_ST7] of string[5] =
          ('','eax','ecx','edx','ebx','esp','ebp','esi','edi',
           'ax','cx','dx','bx','sp','bp','si','di',
           'al','cl','dl','bl','ah','ch','bh','dh',
           '','cs','ds','es','fs','gs','ss',
           'st0','st0','st1','st2','st3','st4',
           'st5','st6','st7');

       firstop = A_MOV;
       lastop = A_LAHF;

       op2str : array[firstop..lastop] of string[7] =
         ('mov','movzx','movsx','','add',
          'call','idiv','imul','jmp','lea','mul','neg','not',
          'pop','popad','push','pushad','ret','sub','xchg','xor',
          'fild','cmp','jz','inc','dec','sete','setne','setl',
          'setg','setle','setge','je','jne','jl','jg','jle','jge',
          'or','fld','fadd','fmul','fsub','fdiv','fchs','fld1',
          'fidiv','cdq','jnz','fstp','and','jno','','',
          'enter','leave','cld','movs','rep','shl','shr','bound',
          'jns','js','jo','sar','test',
          'fcom','fcomp','fcompp','fxch','faddp','fmulp','fsubrp','fdivp',
          'fnsts','sahf','fdivp','fsubp','setc','setnc','jc','jnc',
          'ja','jae','jb','jbe','seta','setae','setb','setbe',
          'aaa','aad','aam','aas','cbw','cdq','clc','cli',
          'clts','cmc','cwd','cwde','daa','das','hlt','iret','lahf');

  implementation

    function getreferencestring(const ref : treference) : string;

      var
         s : string;
         first : boolean;

      begin
         if ref.isintvalue then
           s:='$'+tostr(ref.offset)
         else
{$ifdef ver0_6}             
             begin
                first:=true;
                { have we a segment prefix ? }
                if ref.segment<>R_DEFAULT_SEG then
                  s:=_reg2str[ref.segment]+':['
                else s:='[';

                if assigned(ref.symbol) then
                  begin
                     s:=s+ref.symbol^;
                     first:=false;
                  end;
                if (ref.base<>R_NO) then
                  begin
                     if not(first) then
                       s:=s+'+'
                     else
                       first:=false;
                     s:=s+_reg2str[ref.base];
                  end;
                if (ref.index<>R_NO) then
                  begin
                     if not(first) then
                       s:=s+'+'
                     else
                       first:=false;
                     s:=s+_reg2str[ref.index];
                     if ref.scalefactor<>0 then
                       s:=s+'*'+tostr(ref.scalefactor);
                  end;
                if ref.offset<0 then
                  s:=s+tostr(ref.offset)
                else if (ref.offset>0) then
                  s:=s+'+'+tostr(ref.offset);
                s:=s+']';
             end;
{$else}                
           with ref do
             begin
                first:=true;
                { have we a segment prefix ? }
                if segment<>R_DEFAULT_SEG then
                  s:=_reg2str[segment]+':['
                else s:='[';

                if assigned(symbol) then
                  begin
                     s:=s+symbol^;
                     first:=false;
                  end;
                if (base<>R_NO) then
                  begin
                     if not(first) then
                       s:=s+'+'
                     else
                       first:=false;
                     s:=s+_reg2str[base];
                  end;
                if (index<>R_NO) then
                  begin
                     if not(first) then
                       s:=s+'+'
                     else
                       first:=false;
                     s:=s+_reg2str[index];
                     if scalefactor<>0 then
                       s:=s+'*'+tostr(scalefactor);
                  end;
                if offset<0 then
                  s:=s+tostr(offset)
                else if (offset>0) then
                  s:=s+'+'+tostr(offset);
                s:=s+']';
             end;
{$endif}                
         getreferencestring:=s;
      end;

    function getopstr(t : byte;o : pointer;s : topsize;dest : boolean) : string;

      var
         hs : string;

      begin
         case t of
            top_reg : { a floating point register can be only a register operand }
                      if output_format=of_nasm then
                        getopstr:=_nasmreg2str[tregister(o)]
                      else
                        getopstr:=_reg2str[tregister(o)];
            top_const,
            top_ref : begin
                         if t=top_const then
                           hs:=tostr(longint(o))
                         else
                           hs:=getreferencestring(preference(o)^);
                         if output_format=of_nasm then
                           case s of
                              S_B : hs:='byte '+hs;
                              S_W : hs:='word '+hs;
                              S_L : hs:='dword '+hs;
                              S_BW : if dest then
                                       hs:='word '+hs
                                     else
                                       hs:='byte '+hs;
                              S_BL : if dest then
                                       hs:='dword '+hs
                                     else
                                       hs:='byte '+hs;
                              S_WL : if dest then
                                       hs:='dword '+hs
                                     else
                                       hs:='word '+hs;
                           end
                         else
                           case s of
                              S_B : hs:='byte ptr '+hs;
                              S_W : hs:='word ptr '+hs;
                              S_L : hs:='dword ptr '+hs;
                              S_BW : if dest then
                                       hs:='word ptr '+hs
                                     else
                                       hs:='byte ptr '+hs;
                              S_BL : if dest then
                                       hs:='dword ptr '+hs
                                     else
                                       hs:='byte ptr '+hs;
                              S_WL : if dest then
                                       hs:='dword ptr '+hs
                                     else
                                       hs:='word ptr '+hs;
                           end;
                         getopstr:=hs;
                      end;
            top_symbol : begin
                            hs[0]:=chr(strlen(pchar(pcsymbol(o)^.symbol)));
                            move(pchar(pcsymbol(o)^.symbol)^,hs[1],byte(hs[0]));
                            if output_format<>of_nasm then
                              hs:='offset '+hs
                            else
                              hs:='dword '+hs;

                            if pcsymbol(o)^.offset>0 then
                              hs:=hs+'+'+tostr(pcsymbol(o)^.offset)
                            else if pcsymbol(o)^.offset<0 then
                              hs:=hs+tostr(pcsymbol(o)^.offset);
                            getopstr:=hs;
                         end;
            else internalerror(10001);
         end;
      end;

    function getopstr_jmp(t : byte;o : pointer) : string;

      var
         hs : string;

      begin
         case t of
            top_reg : getopstr_jmp:=_reg2str[tregister(o)];
            top_ref : getopstr_jmp:=getreferencestring(preference(o)^);
            top_const : getopstr_jmp:=tostr(longint(o));
            top_symbol : begin
                            hs[0]:=chr(strlen(pchar(pcsymbol(o)^.symbol)));
                            move(pchar(pcsymbol(o)^.symbol)^,hs[1],byte(hs[0]));
                            if pcsymbol(o)^.offset>0 then
                              hs:=hs+'+'+tostr(pcsymbol(o)^.offset)
                            else if pcsymbol(o)^.offset<0 then
                              hs:=hs+tostr(pcsymbol(o)^.offset);
                            getopstr_jmp:=hs;
                         end;
            else internalerror(10001);
         end;
      end;

{****************************************************************************
                             TI386ATTASMOUTPUT
 ****************************************************************************}

    procedure ti386intelasmoutput.write_to_file(outfile : pbufferedfile);

      var
         hp : pai;
         s : string;
         i : longint;
         quoted : boolean;

      begin
         hp:=pai(first);
         while assigned(hp) do
           begin
              case hp^.typ of
                 ait_external : begin
                                      if output_format=of_nasm then
                                        begin
                                           outfile^.write_string('[EXTERN ');
                                           outfile^.write_pchar(pai_external(hp)^.name);
                                           outfile^.write_string(']');
                                        end
                                      else
                                        begin
                                           outfile^.write_string(#9#9'EXTRN'#9);
                                           outfile^.write_pchar(pai_external(hp)^.name);
                                           outfile^.write_string(' :BYTE');
                                        end;
                                end;
                 ait_datablock : begin
                                    if output_format=of_nasm then
                                      begin
                                         if pai_datablock(hp)^.is_global then
                                           begin
                                              outfile^.write_string('[GLOBAL ');
                                              outfile^.write_pchar(pai_datablock(hp)^.name);
                                              outfile^.write_string(']'+target_info.newline);
                                           end;
                                         outfile^.write_pchar(pai_datablock(hp)^.name);

                                         outfile^.write_string(':'#9'RESB '+tostr(pai_datablock(hp)^.size));
                                      end
                                    else
                                      begin
                                         if pai_datablock(hp)^.is_global then
                                           begin
                                              outfile^.write_string(#9#9'PUBLIC'#9);
                                              outfile^.write_pchar(pai_datablock(hp)^.name);
                                              outfile^.write_string(target_info.newline);
                                           end;
                                         outfile^.write_pchar(pai_datablock(hp)^.name);
                                         outfile^.write_string(#9#9'DB '+tostr(pai_datablock(hp)^.size)+' DUP(?)');
                                      end;
                                 end;
                 ait_const_32bit : outfile^.write_string(#9#9'DD'#9+tostr(pai_const(hp)^.value));
                 ait_const_16bit : outfile^.write_string(#9#9'DW'#9+tostr(pai_const(hp)^.value));
                 ait_const_8bit : outfile^.write_string(#9#9'DB'#9+tostr(pai_const(hp)^.value));
                 ait_const_symbol : begin
                                       if output_format<>of_nasm then
                                         outfile^.write_string(#9#9+'DD '#9'offset ')
                                       else
                                         outfile^.write_string(#9#9+'DD '#9);
                                       outfile^.write_pchar(pchar(pai_const(hp)^.value));
                                    end;
                 ait_real_64bit : outfile^.write_string(#9#9'DQ'#9+double2str(pai_double(hp)^.value));
                 ait_string : begin
                                 if length(pai_string(hp)^.str^)>0 then
                                   begin
                                      outfile^.write_string(#9#9'DB'#9);
                                      quoted:=false;
                                      for i:=0 to pai_string(hp)^.len-1 do
                                        begin
                                           if (ord(pai_string(hp)^.str[i])>31) and
                                             (ord(pai_string(hp)^.str[i])<128) then
                                             begin
                                                if not(quoted) then
                                                  begin
                                                     if i>1 then
                                                       outfile^.write_string(',');
                                                     outfile^.write_string('"');
                                                  end;
                                                outfile^.write_string(pai_string(hp)^.str[i]);
                                                quoted:=true;
                                             end
                                           else
                                             begin
                                                if quoted then
                                                  outfile^.write_string('"');
                                                if i>1 then
                                                  outfile^.write_string(',');
                                                quoted:=false;
                                                outfile^.write_string(tostr(ord(pai_string(hp)^.str[i])));
                                             end;
                                        end;
                                   end
                                 else
                                   begin
                                      internalerror(30003);
                                   end;
                              end;
                 ait_label : begin
                                outfile^.write_string(lab2str(pai_label(hp)^.l));
                                if output_format=of_nasm then
                                  outfile^.write_string(':')
                                else if assigned(hp^.next) and not(pai(hp^.next)^.typ in
                                   [ait_const_32bit,ait_const_16bit,ait_const_8bit,ait_const_symbol,
                                    ait_real_64bit,ait_string]) then
                                   outfile^.write_string(':');
                             end;
                 ait_direct : outfile^.write_pchar(pai_direct(hp)^.str);
                 ait_labeled_instruction : outfile^.write_string(#9#9+op2str[pai_labeled386(hp)^._operator]+#9+
                                             lab2str(pai_labeled386(hp)^.lab));
                 ait_comment : {!!!!!};
                 ait_symbol : begin
                                 if pai_symbol(hp)^.is_global then
                                   begin
                                      if output_format=of_nasm then
                                        begin
                                           outfile^.write_string('[GLOBAL ');
                                           outfile^.write_pchar(pai_symbol(hp)^.name);
                                           outfile^.write_string(']'+target_info.newline);
                                        end
                                      else
                                        begin
                                           outfile^.write_string(#9#9'PUBLIC'#9);
                                           outfile^.write_pchar(pai_symbol(hp)^.name);
                                           outfile^.write_string(target_info.newline);
                                        end;
                                   end;
                                 outfile^.write_pchar(pai_symbol(hp)^.name);
                                 if assigned(hp^.next) and not(pai(hp^.next)^.typ in
                                   [ait_const_32bit,ait_const_16bit,ait_const_8bit,ait_const_symbol,
                                    ait_real_64bit,ait_string]) then
                                   outfile^.write_string(':');
                              end;
                 { writes an instruction, highly table driven }
                 ait_instruction : begin
                                      if pai386(hp)^.op1t<>top_none then
                                        begin
                                           if pai386(hp)^._operator in [A_CALL] then
                                             begin
                                                if output_format=of_nasm then
                                                  s:=getopstr_jmp(pai386(hp)^.op1t,pai386(hp)^.op1)
                                                else
                                                  s:='near ptr '+getopstr_jmp(pai386(hp)^.op1t,pai386(hp)^.op1);
                                             end
                                           else
                                             begin
                                                s:=getopstr(pai386(hp)^.op1t,pai386(hp)^.op1,pai386(hp)^.size,false);
                                                if pai386(hp)^.op2t<>top_none then
                                                  begin
                                                     s:=getopstr(pai386(hp)^.op2t,pai386(hp)^.op2,pai386(hp)^.size,true)+','+s;
                                                     if pai386(hp)^.op3t<>top_none then
                                                       s:=getopstr(pai386(hp)^.op3t,pai386(hp)^.op3,pai386(hp)^.size,false)+
                                                         ','+s;
                                                  end;
                                             end;
                                           s:=#9+s;
                                        end
                                      else
                                        s:='';
                                      s:=#9#9+op2str[pai386(hp)^._operator]+s;
                                      outfile^.write_string(s);
                                   end;
{$ifdef GDB}
          ait_stabn,
          ait_stabs,
          ait_stab_function_name : ;
{$endif GDB}
                 else internalerror(10000);
              end;
              if ((hp^.typ<>ait_label) and (hp^.typ<>ait_symbol)) or (assigned(hp^.next) and not(pai(hp^.next)^.typ in
                [ait_const_32bit,ait_const_16bit,ait_const_8bit,ait_const_symbol,
                 ait_real_64bit,ait_string])) then
              outfile^.write_string(target_info.newline);
              hp:=pai(hp^.next);
           end;
      end;

    procedure asmoutlists_init;

      begin
         datasegment:=new(pi386intelasmoutput,init);
         codesegment:=new(pi386intelasmoutput,init);
         bsssegment:=new(pi386intelasmoutput,init);
         debuglist:=new(pi386intelasmoutput,init);
         externals:=new(pi386intelasmoutput,init);
         consts:=new(pi386intelasmoutput,init);
      end;

    procedure writeasmlists(outfile : pbufferedfile);

      begin
         if output_format=of_nasm then
           begin
              externals^.write_to_file(outfile);
              { INTEL ASM doesn't support stabs
              debuglist^.write_to_file(outfile);}

              outfile^.write_string('[BITS 32]');
              outfile^.write_string(target_info.newline);

              outfile^.write_string('[GROUP DGROUP _BSS _DATA]');
              outfile^.write_string(target_info.newline);

              outfile^.write_string('[SEGMENT _TEXT ALIGN 16 PUBLIC USE32 CLASS=CODE]');
              outfile^.write_string(target_info.newline);
              {
              outfile^.write_string(#9#9'ASSUME'#9'CS:_TEXT,ES:DGROUP,DS:DGROUP,SS:DGROUP');
              outfile^.write_string(target_info.newline);
              }
              codesegment^.write_to_file(outfile);
              outfile^.write_string(target_info.newline);

              outfile^.write_string('[SEGMENT _DATA ALIGN 16 PUBLIC USE32 CLASS=DATA]');
              outfile^.write_string(target_info.newline);

              { write a signature to the file }
              outfile^.write_string(#9#9'DB'#9'"compiled by FPKPascal '+version_string+'\0"');
              outfile^.write_string(target_info.newline);
              outfile^.write_string(#9#9'DB'#9'"target: '+target_info.target_name+'\0"');
              outfile^.write_string(target_info.newline);

              datasegment^.write_to_file(outfile);
              consts^.write_to_file(outfile);
              outfile^.write_string(target_info.newline);

              outfile^.write_string('[SEGMENT _BSS ALIGN 16 PUBLIC USE32 CLASS=BSS]');
              outfile^.write_string(target_info.newline);

              bsssegment^.write_to_file(outfile);
           end
         else
           begin
              outfile^.write_string('.386p');
              outfile^.write_string(target_info.newline);

              externals^.write_to_file(outfile);
              { INTEL ASM doesn't support stabs
              debuglist^.write_to_file(outfile);}

              outfile^.write_string(target_info.newline);
              outfile^.write_string('DGROUP'#9#9'GROUP'#9'_BSS,_DATA');
              outfile^.write_string(target_info.newline);
              outfile^.write_string('_TEXT'#9#9'SEGMENT'#9'BYTE PUBLIC USE32 ''CODE''');
              outfile^.write_string(target_info.newline);
              outfile^.write_string(#9#9'ASSUME'#9'CS:_TEXT,ES:DGROUP,DS:DGROUP,SS:DGROUP');
              outfile^.write_string(target_info.newline);
              codesegment^.write_to_file(outfile);
              outfile^.write_string('_TEXT'#9#9'ENDS');
              outfile^.write_string(target_info.newline);
              outfile^.write_string(target_info.newline);

              outfile^.write_string('_DATA'#9#9'SEGMENT'#9'DWORD PUBLIC USE32 ''DATA''');
              outfile^.write_string(target_info.newline);

              { write a signature to the file }
              outfile^.write_string(#9#9'DB'#9'"compiled by FPKPascal '+version_string+'\0"');
              outfile^.write_string(target_info.newline);
              outfile^.write_string(#9#9'DB'#9'"target: '+target_info.target_name+'\0"');
              outfile^.write_string(target_info.newline);

              datasegment^.write_to_file(outfile);
              consts^.write_to_file(outfile);
              outfile^.write_string('_DATA'#9#9'ENDS');
              outfile^.write_string(target_info.newline);
              outfile^.write_string(target_info.newline);

              outfile^.write_string('_BSS'#9#9'SEGMENT'#9'DWORD PUBLIC USE32 ''BSS''');
              outfile^.write_string(target_info.newline);
              bsssegment^.write_to_file(outfile);
              outfile^.write_string('_BSS'#9#9'ENDS');
              outfile^.write_string(target_info.newline);
              outfile^.write_string(target_info.newline);

              outfile^.write_string(#9#9'END');
              outfile^.write_string(target_info.newline);
           end;
      end;

end.
