{****************************************************************************

                     Copyright (c) 1996,97 by Florian Klaempfl

 ****************************************************************************}
{$D+}
{
  this unit handles the error management

  History:
      23th october 1996:
         + unit started
       5th november 1996:
         * new error handling started
}

unit errors;

  interface

    uses
       strings,dos,cobjects,systems,globals,files,verbose;

    type
       { error constants }
       terrorconst = (endoffile,
                     dupid,
                     syntax_error,
                     out_of_mem,
                     unknown_id,
                     ill_character,
                     too_long_source,
                     inline_not_supported,
                     near_ignored,
                     far_ignored,
                     interrupt_ignored,
                     priv_meth_not_virtual,
                     const_cannot_priv,
                     dest_cannot_priv,
                     id_not_found,
                     no_local_objects,
                     no_anonym_objects,
                     type_id_expect,
                     id_already_type,
                     type_id_not_defined,
                     error_in_type,
                     statement_expect,
                     error_in_integer,
                     error_in_expression,
                     type_mismatch,
                     too_complex_expr,
                     continue_not_allowed,
                     break_not_allowed,
                     exceptions_not_allowed,
                     invalid_qualifizier,
                     invalid_for_var,
                     ordinal_expect,
                     upper_l_lower,
                     ill_unit_name,
                     malformed_unit,
                     error_reading_unit,
                     rec_unit_def,
                     too_much_units,
                     ill_char_const,
                     overloaded_no_proc,
                     same_parameters,
                     no_para_match,
                     too_much_matches,
                     proc_must_handleexceptions,
                     forward_not_resolved,
                     cannot_open_input,
                     header_dont_match,
                     ill_field,
                     para_too_big,
                     too_much_lexlevel,
                     ill_switch,
                     cannot_open_incfile,
                     type_must_be_rec_or_class,
                     unit_not_found,
                     dup_enum,
                     pointer_expect,
                     not_same_target,
                     type_const_not_possible,
                     double_caselabel,
                     range_check_error,
                     ill_type_cast,
                     class_type_expect,
                     no_overloaded_procvars,
                     cannot_open_asmfile,
                     string_too_long,
                     object_type_expect,
                     method_id_expect,
                     header_dont_match_any_member,
                     take_extended_syntax,
                     file_must_call_by_reference,
                     string_exceed_line,
                     ill_unit_version,
                     error_in_real,
                     no_paras_2_destructor,
                     fail_only_in_constructor,
                     only_pack_records_,
                     too_much_endifs,
                     endif_expect,
                     var_must_be_reference,
                     def_only_in_program,
                     overloaded_are_not_both_virtual,
                     ol_meths_not_same_ret,
                     overloaded_support_exceptions_false,
                     dont_call_exported_direct,
                     dont_nest_export,
                     methods_dont_be_export,
                     self_not_in_method,
                     call_by_ref_without_typeconv,
                     typeid_here_not_allowed,
                     class_expected,
                     no_super_class,
                     generic_methods_only_in_methods,
                     there_is_no_super_class,
                     pointer_to_class_expect,
                     member_cd_call_from_method,
                     only_one_destructor,
                     expr_have_to_be_constructor_call,
                     id_no_member,
                     expr_have_to_be_destructor_call,
                     a_error_const,
                     illsettype,
                     illsetexpr,
                     typeconflict_in_set,
                     ill_colon_qualifier,
                     false_with_expr,
                     use_int_div_int_op,
                     cannot_write_unitfile,
                     invalid_record_const,
                     konstrucname_init,
                     destrucname_done,
                     set_element_are_not_comp,
                     ill_label_pos,
                     label_not_found,
                     goto_label_not_support,
                     set_expected,
                     id_is_no_label_id,
                     label_already_defined,
                     label_not_defined,
                     cons_always_obj,
                     asmerror,
                     symbol_not_used,
                     void_function,
                     inefficient_code,
                     unreachable_code,
                     overloaded_must_be_all_global,
                     operator_not_overloaded,
                     cant_call_abstract_method,
                     mix_of_classes_and_objects,
                     macro_buffer_overflow,
                     keyword_cant_be_a_macro,
                     macro_deep_ten,
                     preprocerror,
                     user_defined,
                     linker_dup_symbol,
                     linker_file_read_error,
                     linker_file_not_found,
                     linker_illegal_magic,
                     no_new_or_dispose_for_classes,
                     no_instance_of_abstract_object,
                     only_virtual_methods_abstract,
                     abstract_no_definition,
                     cant_call_as,
                     cant_call_o2obj,
                     _asm_syntax_error,
                     register_name_expected,
                     _asm_size_mismatch,
                     _no_instr_match,
                     cant_compile_unit,
                     no_reraise_possible,
                     convert_real_2_comp,
                     procedure_overloading_is_off,
                     wrong_styled_switch);

    var
       errortext : boolean;
       errorfile : text;
       errorfilename : pathstr;

       { number of generated errors }
       errorcount : word;

       { extended informations about an error }
       exterror : pchar;

    { an internal error is only called with a number and without }
    { a message                                                  }
    procedure internalerror(i : integer);

    procedure erase_errorlist;

    procedure warning(w : terrorconst);
    procedure error(w : terrorconst);
    procedure fatalerror(w : terrorconst);

  type
     terrorfunction = function(w : terrorconst) : boolean;

     tstopprocedure = procedure;

     tinternalerrorfunction = function(i : integer) : boolean;

  var
     { if the following functions return true, the compiler }
     { calls the procedure do_stop which does per default   }
     { a halt(1)                                            }
     do_warning,do_error,do_fatalerror : terrorfunction;

     { this procedure is called to stop the compiler                 }
     { e.g. this procedure has to restore the state before compiling }
     do_stop : tstopprocedure;

     { only for compatibility }
     do_internalerror : tinternalerrorfunction;

  implementation

    type
       perrorrec = ^terrorrec;

       terrorrec = record
          data : pstring;
          next : perrorrec;
       end;

    var
       errorlist : perrorrec;

    function geterrormsg(i : integer) : string;

      var
         t : text;
         s : string;
         hp : perrorrec;
         last : perrorrec;
         errnr : integer;

      begin
         if errorlist=nil then
           begin
              if (target_info.target=target_LINUX) then
                assign(t,errorfilename)
              else
                assign(t,exepath+'ERROR'+language+'.MSG');
              {$i-}
              reset(t);
              {$i+}
              errnr:=ioresult;
              if errnr<>0 then
                begin
                   case language of
                      'D' : begin
                               if errortext then
                                 begin
                                    writeln(errorfile,'Fehler ',i);
                                    writeln(errorfile,'**** Fehlertextdatei ERRORD.MSG nicht gefunden (Fehler ',
                                      errnr,'). *****');
                                 end
                               else
                                 begin
                                    str (i,s);
                                    comment (V_Error,'Fehler '+s);
                                    str (errnr,s);
                                    comment (V_Error,'**** Fehlertextdatei ERRORD.MSG nicht gefunden (Fehler '+s+'). *****');
                                 end;
                            end;
                      'E' : begin
                               if errortext then
                                 begin
                                    writeln(errorfile,'error ',i);
                                    writeln(errorfile,'**** error file ERRORE.MSG not found (error ',errnr,'). *****');
                                 end
                               else
                                 begin
                                    str (i,s);
                                    comment (V_Error,'error '+s);
                                    str (errnr,s);
                                    comment (V_Error,'**** error file ERRORE.MSG not found (error '+s+'). *****');
                                 end;
                            end;
                   end;
                   halt(1);
                end;
              while not(eof(t)) do
                begin
                   new(hp);
                   hp^.next:=nil;
                   readln(t,s);
                   hp^.data:=stringdup(s);
                   if errorlist=nil then
                     errorlist:=hp
                   else last^.next:=hp;
                   last:=hp;
                end;
              close(t);
           end;
         { in the of a wrong ERROR message file }
         geterrormsg:='nr. '+tostr(i);
         hp:=errorlist;
         str(i,s);
         for i:=i downto 1 do
           if assigned(hp) then
             hp:=hp^.next;
         if hp<>nil then
           if assigned(hp^.data) then
             geterrormsg:=hp^.data^;
      end;

   { predefined handler to stop the compiler }
   procedure _stop;far;

     begin
        halt(1);
     end;

{$ifdef GDB}
   procedure gdb_stop;far;

      begin
         runerror(190);
      end;
{$endif GDB}

   { predefined handler for warnings }
   function _warning(w : terrorconst) : boolean;far;

    var temp : string;
  
     begin
         temp:=' Warning: '+geterrormsg(longint(w));
         if assigned(exterror) then
           begin
           temp:=temp+strpas(exterror);
           strdispose(exterror);
           exterror:=nil;
           end;
        if errortext then
          begin
             if assigned(current_module^.current_inputfile) then
               current_module^.current_inputfile^.write_file_line(errorfile);
             write(errorfile,temp)
          end
        else
          begin
             if assigned(current_module^.current_inputfile) then
               temp:=current_module^.current_inputfile^.get_file_line+temp;
             comment (V_Warning, temp)
          end;
        { per default a warning never stops }
        _warning:=false;
     end;

    procedure warning(w : terrorconst);

      begin
         if warnings then
           begin
              if do_warning(w) then
{$ifdef FPK}
                do_stop();
{$else}
                do_stop;
{$endif}
           end;
      end;

    function _error(w : terrorconst) : boolean;far;

      var temp : string;

       begin
          inc(errorcount);
          temp:=' Error: '+geterrormsg(longint(w));
          if exterror<>nil then
            begin
            temp:=temp+' '+strpas(exterror);
            strdispose(exterror);
            exterror:=nil;
            end;
         if errortext then
           begin
              if assigned(current_module^.current_inputfile) then
                current_module^.current_inputfile^.write_file_line(errorfile);
            writeln(errorfile,temp);
           end
         else
           begin
              if assigned(current_module^.current_inputfile) then
               temp:=current_module^.current_inputfile^.get_file_line+temp;
            comment (V_Error,temp);
           end;

         { view only 50 errors }
         if errorcount>50 then
           _error:=false
         else
           _error:=true;
      end;
 
    procedure error(w : terrorconst);

      begin
         if do_error(w) then
{$ifdef FPK}
           do_stop();
{$else}
           do_stop;
{$endif}
         codegeneration:=false;
      end;
 
    function _fatalerror(w : terrorconst) : boolean;far;

      var temp : string;
      
      begin
         temp:=' Fatal error: '+geterrormsg(longint(w));
         if exterror<>nil then
           begin
              temp:=temp+' '+strpas(exterror);
              strdispose(exterror);
              exterror:=nil;
           end;
         if errortext then
           begin
              if assigned(current_module^.current_inputfile) then
                current_module^.current_inputfile^.write_file_line(errorfile);
           writeln(errorfile,temp)
           end
         else
           begin
              if assigned(current_module^.current_inputfile) then
             temp:=current_module^.current_inputfile^.get_file_line+temp;
           comment (V_Error,temp)
           end;
           end;

    procedure fatalerror(w : terrorconst);

      begin
         { a fatal error stops every time }
         do_fatalerror(w);
{$ifdef FPK}
         do_stop();
{$else}
         do_stop;
{$endif}
      end;

    function _internalerror(i : integer) : boolean;far;

     var temp,temp2 : string;

      begin
         if not(quiet) then writeln;
         if errortext then
           begin
              if assigned(current_module^.current_inputfile) then
                current_module^.current_inputfile^.write_file_line(errorfile);
              writeln(errorfile,': Internal error ',i);
           end
         else
           begin
              str (i,temp);  
              if assigned(current_module^.current_inputfile) then
                temp2:=current_module^.current_inputfile^.get_file_line
              else temp2:='';
              comment(V_Error,temp2+': Internal error '+temp);
           end;
      end;

    procedure internalerror(i : integer);

      begin
         do_internalerror(i);
{$ifdef FPK}
         do_stop();
{$else}
         do_stop;
{$endif}
      end;

    procedure erase_errorlist;

      var
         p : perrorrec;

      begin
          while assigned(errorlist) do
            begin
               p:=errorlist;
               errorlist:=p^.next;
               if assigned(p^.data) then
                 stringdispose(p^.data);
               dispose(p);
            end;
      end;

begin
   { true, if no compiler error }
   codegeneration:=true;
   errortext:=false;

   { error management }
   { pointer to error msgs }
   errorlist:=nil;
   { extended error description }
   exterror:=nil;
   { count of errors }
   errorcount:=0;

   { install default error handlers }
{$ifdef tp}
   do_stop:=_stop;
   do_warning:=_warning;
   do_error:=_error;
   do_fatalerror:=_fatalerror;
   do_internalerror:=_internalerror;
{$else}
   do_stop:=@_stop;
   do_warning:=@_warning;
   do_error:=@_error;
   do_fatalerror:=@_fatalerror;
   do_internalerror:=@_internalerror;
{$endif}
end.

