{****************************************************************************

                   Copyright (c) 1993,97 by Florian Klaempfl

 ****************************************************************************}


{
  this unit does optimizations on the assembler code

  + feature added
  - removed
  * bug fixed or changed

  History (started with version 0.9.0):
       5th november 1996:
         * adapted to 0.9.0
      30th december 1996:
         * runs with 0.9.1
}

unit aopt386;

  interface

    uses
       cobjects,globals,aasm,symtable,strings
{$ifdef i386}
       ,i386
       ,cgi386
{$else}
{$endif}
       ;

    { does simple optimizations like jumps and remove pop/pushes }
    procedure peepholeopt(asml : paasmoutput);

  implementation

    procedure peepholeopt(asml : paasmoutput);

      var
         p,hp1,hp2 : pai;

      begin
         p:=pai(asml^.first);
         while assigned(p) do
           begin
              if (p^.typ=ait_labeled_instruction) then
                begin
                   if (assigned(p^.next)) then
                     begin
                        if (pai(p^.next)^.typ=ait_labeled_instruction) and
                          (pai_labeled386(p^.next)^._operator=A_JMP) and
                          assigned(p^.next^.next) and
                          (pai(p^.next^.next)^.typ=ait_label) and
                          (pai_label(p^.next^.next)^.l=pai_labeled386(p)^.lab) then
                          begin
                             case pai_labeled386(p)^._operator of
                                A_JE : pai_labeled386(p)^._operator:=A_JNE;
                                A_JNE : pai_labeled386(p)^._operator:=A_JE;
                                A_JL : pai_labeled386(p)^._operator:=A_JGE;
                                A_JG : pai_labeled386(p)^._operator:=A_JLE;
                                A_JLE : pai_labeled386(p)^._operator:=A_JG;
                                A_JGE : pai_labeled386(p)^._operator:=A_JL;
                                A_JNZ : pai_labeled386(p)^._operator:=A_JZ;
                                A_JNO : pai_labeled386(p)^._operator:=A_JO;
                                A_JZ : pai_labeled386(p)^._operator:=A_JNZ;
                                A_JS : pai_labeled386(p)^._operator:=A_JNS;
                                A_JNS : pai_labeled386(p)^._operator:=A_JS;
                                A_JO : pai_labeled386(p)^._operator:=A_JNO;
                                A_JC : pai_labeled386(p)^._operator:=A_JNC;
                                A_JNC : pai_labeled386(p)^._operator:=A_JC;
                                A_JA : pai_labeled386(p)^._operator:=A_JBE;
                                A_JAE : pai_labeled386(p)^._operator:=A_JB;
                                A_JB : pai_labeled386(p)^._operator:=A_JAE;
                                A_JBE : pai_labeled386(p)^._operator:=A_JA;
                                else
                                  begin
                                     p:=pai(p^.next);
                                     continue;
                                  end;
                             end;
                             pai_labeled386(p)^.lab:=pai_labeled386(p^.next)^.lab;
                             hp2:=pai(p^.next^.next);
                             hp1:=pai(p^.next);
                             asml^.remove(hp1);
                             dispose(hp1,done);
                             p:=hp2;
                             continue;
                         end
                       else if (pai(p^.next)^.typ=ait_label) and
                         (pai_label(p^.next)^.l=pai_labeled386(p)^.lab) then
                         begin
                            hp2:=pai(p^.next);
                            asml^.remove(p);
                            dispose(p,done);
                            p:=hp2;
                            continue;
                         end;
                   end;
                end
              else
                if (p^.typ=ait_instruction) and
                  (pai386(p)^._operator=A_POP) then
                  begin
                     if (assigned(p^.next)) and
                       (pai(p^.next)^.typ=ait_instruction) and
                       (pai386(p^.next)^._operator=A_PUSH) and
                       (pai386(p^.next)^.op1=pai386(p)^.op1) then
                       begin
                          hp2:=pai(p^.next^.next);
                          hp1:=pai(p^.next);
                          asml^.remove(p);
                          asml^.remove(hp1);
                          dispose(p,done);
                          dispose(hp1,done);
                          p:=hp2;
                          continue;
                        end;
                  end;
         p:=pai(p^.next);
      end;
    end;

{$ifdef dummy}
{***ASMOPT}
	procedure Tasmlist.optimize;

{***>>>}
	{Procedure to optimize the asmlist. At the moment it removes unnecessary
	 reloads of variabeles. This is easy to do this way, but very hard to
	 achieve in the second pass.}

    procedure remove_loads;

    var	p,p2,p3:Pasmrec;
	    a:byte;
	    lastreg,i:Tregister;
	    lastref:string;
	    opr,opr2:string;

    label cntwhile;

    begin
	    p2:=nil;
	    p:=wurzel;
	    while p<>nil do
    cntwhile:
		    begin
			    case p^.instruc of
				    MOV:
					    begin
						    opr:=strpas(p^.t);
						    a:=pos(',',opr);
						    opr2:=copy(opr,a+1,255);
						    delete(opr,a,255);
						    for i:=R_NO to R_BL do
							    if regid2str[i]=opr then
								    begin
									    if pos('%',opr2)=0 then
										    begin
											    lastreg:=i;
											    lastref:=opr2;
											    break;
										    end
								    end
							    else
								    if (regid2str[i]=opr2) and (opr=lastref) and
								     (i=lastreg) then
									    begin
										    p3:=p;
										    if p2=nil then
											    wurzel:=p^.next
										    else
											    p2^.next:=p^.next;
										    if p^.next=nil then
											    last:=p2;
										    p:=p^.next;
										    dispose(p3);
										    goto cntwhile;
									    end;
					    end;
				    else
					    lastreg:=R_NO;
			    end;
			    p2:=p;
			    p:=p^.next;
		    end;
    end;

    procedure remove_writes;

    begin
    end;

begin
    remove_loads;
    remove_writes;
end;
{***}
{$endif dummy}
end.
