
{ **************************************************************************
  *                                                                        *
  *                          FileRead Test Program                         *
  *                          =====================                         *
  *                                                                        *
  *  Description:                                                          *
  *                                                                        *
  *       This program will show you the various functions of the          *
  *  TFread object.  With the TFread object, you create an instance        *
  *  of the object, passing it a file name and the size of the records     *
  *  in which you will be reading from and writing to the data file.       *
  *  This program takes a record called InfoRec, initializes the           *
  *  data, then writes 100 records to the file.  With the sequential       *
  *  procedures (ReadNext and ReadPrevious) built into the TFread          *
  *  object, this program will then seek the first record and read         *
  *  until the last record is read, displaying the physical record         *
  *  number and the name field of the record.  The program will then       *
  *  read the file backwards starting from the last record and             *
  *  stopping when the first record has been read and displayed.  The      *
  *  program will then close the file and dispose of the object.           *
  *                                                                        *
  ************************************************************************** }

Program Test_FileRead;

uses
  Crt,FileRead;

Type
  { The information record we'll use for our data file. }
  InfoRec = Record
    Name : String[20];
    Address : String[50];
    City : String[25];
    State : String[2];
    Zip  : String[5];
  End;

Procedure Main;
var
  Info   : InfoRec;    { variable of type inforec }
  MyFile : TFreadPtr;  { an instance of the TFread object }
  i      : integer;    { loop variable }
  temp   : string;     { temp string for processing integers }
  f      : file;       { temp file for deleting old version of TOM.GAG }
Begin
  { Prepare record for writing. }
  FillChar(Info,SizeOf(Info),#0);
  with Info do
  begin
    Address := '5861 Horseshoe Drive';
    City:='Bethel Park';
    State := 'PA';
    Zip := '15102';
  end;

  { Let's initialize a file object and create a new file. }
  New(MyFile,Init('INFO.DAT',Create,SizeOf(InfoRec)));

  { Let's do some stuff with our new file. }
  with Myfile^ do
  begin
    for i:=1 to 100 do
    begin
      { Modify name with the number of the logical record. }
      Str(i,temp);
      Info.Name:='Tom Clancy'+'  '+temp;
      { Append record to end of file (or just add records in this case) }
      AppendRec(Info);
    end;
    { Try to rename the file. }
    if not RenameFile('TOM.GAG') then
    begin
      { If we cannot, then delete previous version of TOM.GAG. }
      Assign(f,'TOM.GAG');
      erase(f);
      { And try one more time. }
      if not RenameFile('TOM.GAG') then
      begin
        { if we cannot rename this time, then just give up. }
        Writeln('Still having trouble renaming file!');
        halt(1);
      end;
    end;
    { If we can rename the file, then read the first record. }
    ReadRec(Info,0);
    if ReadError then
      { if a read error occured, then just close and quit. }
      writeln('Oops, dude, and error hath occurred!')
    else
    begin
      { go through the file sequentially forward, printing the name
        field of the particular record. }
      while not ReadError do
      begin
        Writeln(GetCurrent:4,':  ',Info.Name);
        ReadNext(Info);
      end;
      writeln;
      write('Press a key to go backwards!');
      readln;
      writeln;
      { Let's go backward now, starting with the last record which is
        also the current record! }
      ReadCurrent(Info);
      while not ReadError do
      begin
        Writeln(GetCurrent:4,':  ',Info.Name);
        ReadPrevious(Info);
      end;
    end;
  end;
  { Okay, close file and clean house. }
  Dispose(Myfile,Done);
End;

Begin
  Main;
End.