program Tutorial2; {to get the basics take a look at TUT1.PAS}
{Cube Rotation
 Made by fh94.3 (C) 12/23/1995
 Mail: fh@viktoria.drp.fmph.uniba.sk

 Based on explanation by Synergist (rhr0982@grace.rit.edu).
}
uses tutunit,crt;

const cube: array[0..23] of real = {8 points * 3 coords(X,Y,Z) = 24 numbers}
    (-1,-1,-1,-1,-1,1,-1,1,-1,
    -1,1,1,1,-1,-1,1,-1,1,
    1,1,-1,1,1,1); {coords of the objects (like point1_x, point1_y, point1_z,
                    point2_x, point2_y, ...)}
const lindex: array[0..23] of integer = {12 lines * 2 points per line = }
    (0,1,0,4,0,2,1,3,1,5,2,3, {24 numbers}
     2,6,3,7,4,5,4,6,5,7,6,7); {index of the lines, it sets
           how the points are connected together (point #0 to point #1, ...)}
var    xt,yt,zt:real; {temp points}
    xan,yan,zan:real; {angles for axis X,Y,Z}
    sx,sy,sx1,sy1,p,zoom: integer; {Screen coords X,Y}

procedure draw(color:byte); {procedure to draw a cube}
begin
 for p:=0 to 11 do begin {loops for all 12 lines}
  sx:=round(zoom*cube[lindex[p*2]*3])+160; {x coord for point #1}
  sy:=round(zoom*cube[lindex[p*2]*3+1])+100; {y coord for point #1}
  sx1:=round(zoom*cube[lindex[p*2+1]*3])+160; {x coord for point #2}
  sy1:=round(zoom*cube[lindex[p*2+1]*3+1])+100; {y coord for point #2}
  drawline(SX,SY,sx1,sy1,color); {draw it in current color}
 end;
end;

procedure calc; {calculates new values after rotate step}
begin
for p:=0 to 7 do begin {repeats for all 8 points}
Yt := cube[p*3+1] * COS(Xan) - cube[p*3+2] * SIN(Xan); {read old values from the table of coord,}
Zt := cube[p*3+1] * SIN(Xan) + cube[p*3+2] * COS(Xan); {rotating about x axis}
cube[p*3+1] := Yt; {writes the new values back to the table}
cube[p*3+2] := Zt;

Xt := cube[p*3] * COS(Yan) - cube[p*3+2] * SIN(Yan); {same as above, for Y axis}
Zt := cube[p*3] * SIN(Yan) + cube[p*3+2] * COS(Yan);
cube[p*3] := Xt;
cube[p*3+2] := Zt;

Xt := cube[p*3] * COS(Zan) - cube[p*3+1] * SIN(Zan); {about Z axis}
Yt := cube[p*3] * SIN(Zan) + cube[p*3+1] * COS(Zan);
cube[p*3] := Xt;
cube[p*3+1] := Yt;
end;
end;

begin
Mcgaon;       {sets the 13h (320x200x256) mode}
Zan :=  0.1;  {rotation about Z axis by this angle}
Yan :=  0.02; {rotation about Y axis by this angle}
Xan :=  0.02; {rotation about X axis by this angle}
zoom:=30;     {size of the cube}

draw(15);     {draws the cube}
repeat        {loops ...}
draw(0);      {undraws the cube}
calc;        {calculates the new coords}
draw(15);     {draws it again}
delay(30);    {wait a sec!}
until keypressed; {... 'till you press something}
mcgaoff;      {jump back to text mode}
end.