{ Copyright (C) 1997 by Cristi Streng }

{$A+,B-,D+,E+,F-,G+,I+,L+,N+,O-,P-,Q-,R-,S+,T-,V+,X+,Y+}
{$M 65520,0,655360}
program Example_1;
uses
   crt,dos70;
var
   VI:TVolInfo;
   Data:TFindData;
   SwapInfo:TSwapInfo;
   OldDir,s:string;
   c,CurDrive:char;
   x:integer;
   i,d,rd:word;
   f:LFNFile;
   buf:array [1..100] of char;
   major,minor:byte;
begin
  ClrScr;
  TextColor (LightGray);
  if not IsDOS70 then
  begin
    Writeln ('Sorry, you must run DOS 7.x (Windows 95).');
    Halt
  end;
  GetVer (major, minor);
  Writeln ('DOS Version: ', major, '.', minor);
  GetWinVer (major, minor);
  Writeln ('Windows Version: ', major, '.', minor);
  Writeln;
  Writeln ('Press any key to continue...');
  ReadKey;
  GetDir (0,s); { Get Current Dir }
  CurDrive:=s[1];
  GetVolumeInformation (Copy (s,1,3), VI); { if this doesn't work, then you are in MS-DOS mode }
  if VI.FSName='' then
  begin
    Writeln ('Sorry, you are in MS-DOS mode. Type ''EXIT'' or ''WIN'' to restart');
    Writeln ('Windows 95');
    Halt
  end;
  repeat
    ClrScr;
    if Length (s)<3 then
      s:=s[1]+':\';
    GetVolumeInformation (Copy (s,1,3), VI);
    if DOS7Error<>0 then
      Writeln ('Dos reported error ',DOS7Error)
    else
    begin
      TextColor (Yellow);
      Writeln ('Volume Info : ',Copy (s,1,2));
      TextColor (LightGray);
      Writeln;
      Writeln ('   File System              : ',VI.FSName);
      Writeln ('   Maximum File Name Length : ',VI.MaxFileName);
      Writeln ('   Maximum Path Length      : ',VI.MaxPath);
      Writeln ('   Flags : ');
      if (VI.Flags and FS_COMPRESSED)<>0 then
        Writeln ('   - Is compressed');
      if (VI.Flags and FS_LFN_APIS)<>0 then
        Writeln ('   - Supports long filename functions');
      if (VI.Flags and FS_UNICODE_USED)<>0 then
        Writeln ('   - Uses UNICODE characters in file names');
      if (VI.Flags and FS_CASE_PRESERVED)<>0 then
        Writeln ('   - Case is preserved in directory entries');
      if (VI.Flags and FS_CASE_SENSITIVE)<>0 then
        Writeln ('   - Searches are case sensitive');
      Writeln
    end;
    Writeln;
    TextColor (LightCyan);
    Write ('Other volume ? Enter a path or <ENTER> to continue : ');
    Readln (s)
  until s='';

  Writeln;
  TextColor (Yellow);
  Writeln ('Swap File Info:');
  TextColor (LightGray);
  GetSwapFileInfo (SwapInfo);
  Writeln;
  Writeln ('File Name  : ', SwapInfo.FileName);
  Writeln ('Size       : ', SwapInfo.FileSize:1:0, ' bytes');
  Write ('Pager Type : ');
  case SwapInfo.Pager of
    SW_NOPAGER: Writeln ('No Pager');
    SW_DOSPAGER: Writeln ('Paging through MS-DOS');
    SW_IOSPAGER: Writeln ('Paging through Protected-Mode I/O Supervisor');
    else Writeln ('Unknown')
  end;
  Writeln;
  TextColor (LightCyan);
  Writeln ('Press any key to continue...');
  Writeln;
  Readkey;

  ClrScr;
  TextColor (Yellow);
  Writeln ('Directory Info:');
  Writeln;
  TextColor (LightGray);
  Writeln ('Your current directory is :', GetLongPathName (LFNGetDir (0), NO_SUBST_EXPAND));
  Writeln ('                 DOS Name :', GetFullPathName (LFNGetDir (0), NO_SUBST_EXPAND));
  s:=LFNGetDir (0);
  if s[Length(s)]<>'\' then { not in root dir }
  begin
    Writeln ('Your parent directory is :', GetLongPathName ('..', NO_SUBST_EXPAND));
    Writeln ('                DOS Name :', GetFullPathName ('..', NO_SUBST_EXPAND))
  end;
  Writeln;
  TextColor (LightCyan);
  Writeln ('Press any key to continue...');
  Writeln;
  Readkey;

  TextColor (Yellow);
  Writeln ('Executable files in current directory:');
  TextColor (LightGray);
  Writeln;
  x:=LFNFindFirst ('*.exe', FA_NORMAL, FA_ANY, Data);
  while DOS7Error=0 do { found }
  begin
    Writeln ('   ',Data.Name);
    LFNFindNext (x, Data)
  end;
  LFNFindClose (x);
  Writeln;
  TextColor (LightCyan);
  Writeln ('Press any key to continue...');
  ReadKey;

  ClrScr;
  TextColor (Yellow);
  Writeln ('Directory Operations:');
  TextColor (LightGray);
  Writeln;

  OldDir:=LFNGetDir (0);
  Write ('Create Directory (absolute or relative path) (<ENTER> to skip) : ');
  Readln (s);
  if s<>'' then
  begin
    LFNMkDir (s);
    if DOS7Error<>0 then
      Writeln ('    --- Error: Could not create the specified directory ---')
  end;

  Writeln ('Current Directory : ', GetLongPathName (LFNGetDir (0), NO_SUBST_EXPAND));
  Writeln ('Changing to ',s);
  LFNChDir (s);
  d:=DOS7Error;
  if d<>0 then
    Writeln ('    --- Error: Could not change directory ---');
  Writeln ('Current Directory : ', GetLongPathName (LFNGetDir (0), NO_SUBST_EXPAND));

  if d=0 then
  begin
    Writeln ('Changing to ..');
    LFNChDir ('..');
    if DOS7Error<>0 then
      Writeln ('    --- Error: Could not change directory ---');
    Writeln ('Current Directory : ', GetLongPathName (LFNGetDir (0), NO_SUBST_EXPAND))
  end;
  Write ('Remove Directory (<ENTER> to skip) : ');
  Readln (s);
  if s<>'' then
  begin
    LFNRmDir (s);
    if DOS7Error<>0 then
      Writeln ('    --- Error: Could not remove directory ---')
  end;
  Writeln;
  TextColor (LightCyan);
  Writeln ('Press any key to continue...');
  ReadKey;

  ClrScr;
  TextColor (Yellow);
  Writeln ('File operations and info:');
  LFNChDir (OldDir);
  Writeln;
  TextColor (LightGray);
  Write ('Does the test file exist ? ');
  f:=LFNOpenFile ('Test file for Example 1.txt', 0, OPEN_RDONLY, 0);
  if DOS7Error<>0 then { no }
  begin
    Writeln ('No.');
    Write ('Creating the test file ... ');
    f:=LFNCreateFile ('Test file for Example 1.txt', FA_ARC, OPEN_WRONLY, 0);
    if DOS7Error<>0 then
      Writeln (' * Error *')
    else
    begin
      Writeln ('Done.');
      Write ('Writing something in the file ... ');
      s:='Text to be written in ''Test file for Example 1.txt''.';
      LFNBlockWrite (f, s[1], Length (s));
      if DOS7Error<>0 then
        Writeln (' * Error * ')
      else
        Writeln ('Done.');
      Write ('Closing the file ... ');
      LFNCloseFile (f);
      if DOS7Error<>0 then
        Writeln (' * Error * ')
      else
        Writeln ('Done.');
    end;
    Write ('Opening file for Read ... ');
    f:=LFNOpenFile ('Test file for Example 1.txt', 0, OPEN_RDONLY, 0);
    if DOS7Error=0 then
      Writeln ('Done.')
  end
  else
    Writeln ('Yes.');
  if DOS7Error<>0 then
  begin
    Writeln ('* Error *');
    Halt
  end;
  Write ('Reading file ... ');
  rd:=LFNBlockRead (f, buf, 100); { rd = bytes read }
  if DOS7Error<>0 then
    Writeln (' * Error * ')
  else
    Writeln ('Done.');
  Writeln ('The test file contains the following text:');
  Write (' --- ');
  TextColor (LightRed);
  for i:=1 to rd do
    Write (buf[i]);
  TextColor (LightGray);
  Write (' --- ');
  Writeln;
  Write ('Closing file ... ');
  LFNCloseFile (f);
  if DOS7Error<>0 then
    Writeln (' * Error * ')
  else
    Writeln ('Done.');
  Write ('Delete test file ? ');
  Readln (c);
  if (c='Y') or (c='y') then
    LFNErase ('Test file for Example 1.txt', FA_NORMAL, FA_ANY, NO_WILDCARDS);
  Writeln;
  Writeln;
  TextColor (LightCyan);
  Writeln ('Press any key to exit.');

  ReadKey
end.