UNIT PCX256;
{
  PCX256
  - by Bjarke Viksoe

  Converts a ZSoft PCX 320x200 pixels picture in 256 colours to
  a raw picture.
  Little IO checking. No size checking.
}

INTERFACE

USES
	DEMOINIT, PICTURE;


Procedure ConvertPCX(p : pScreen; v : pBuffer; filesize : longint);
Procedure LoadPix(buffer : pScreen; filename : string);


(*--------------------------------------*)


IMPLEMENTATION

{$I-}

TYPE
	pHeader = ^HeaderType;
	HeaderType = RECORD
		id : byte;
		ver : byte;
		compressed : boolean;
		bitpixel : byte;
		minx,miny,maxx,maxy : word;
		hdpi,vdpi : word;
		palette : array[1..48] of byte;
		reserved : byte;
		depth : byte;
		width : word;
		palette_type : word;
		hscr,vscr : integer;
		filler : array [74..127] of byte;
	end;


Procedure ExtractCMAP(v : pBuffer; filesize : longint);
Var
	i,j : word;
Begin
	i:=filesize-(256*3)+1;
	for j:=1 to 256*3 do begin
		CMAP[j]:=v^[i] DIV 4;
		inc(i);
	end;
End;


Procedure DecompressPCX(p : pScreen; v : pBuffer; h : pHeader);
Var
	xsize,ysize : integer;
Begin
	xsize:=h^.maxx-h^.minx+1;
	for ysize:=1 to h^.maxy-h^.miny+1 do asm
		push	ds
		lds	si,[v]
		les	di,[p]
@bigloop:
		xor	bx,bx
		xor	cx,cx
		mov	dl,$C0
		mov	dh,$3F
@loop:
		lodsb
		mov	cl,1
		mov	ah,al
		and	ah,dl
		cmp	ah,dl
		jne	@copy
		and	al,dh
		mov	cl,al
		lodsb
@copy:
		add	bx,cx
		rep stosb
		cmp	bx,[xsize]
		jb		@loop
		pop	ds
		mov	WORD PTR [v],si
		mov	ax,[xsize]
		add	WORD PTR [p],ax
	end;
End;

Procedure ConvertPCX(p : pScreen; v : pBuffer; filesize : longint);
Var
	h : pHeader;
	i : longint;
Begin
	h := pHeader(v);
	with h^ do begin
		if (id<>$0A) then exit;
		if (NOT compressed) OR (bitpixel<>8) OR (depth<>$01) then exit;
	end;
	ExtractCMAP(v, filesize);
	if (h^.ver=$05) then DecompressPCX(p,@v^[129],h);
End;


Procedure LoadPix(buffer : pScreen; filename : string);
Var
	pFileMem: pBuffer;
	FileHandle : file;
	size : longint;
Begin
	Assign(FileHandle, filename);
	Reset(FileHandle, 1);
	size := FileSize(FileHandle);
	if size > MaxAvail then exit;
	if size > 65535 then exit;
	GetMem(pFileMem, size);
	BlockRead(FileHandle, pFileMem^, size);
	Close(FileHandle);
	if IOResult=0 then begin
		ConvertPCX(buffer, pFileMem, size);
	end;
	FreeMem(pFileMem, size);
End;

{$I+}

end.
