UNIT FLIPLAY;
{
  AUTODESK FLI/FLC ANIMATION PLAYER by Bjarke Viksoe
  Begun: Dec 1995
  Last Revised: Dec 1995

  - gee, it plays FLCs too
  -- and it's utterly fast! Almost pure assembly!!
  --- Still need to work on the disk-buffering, though...
}

INTERFACE

USES
	PICTURE;

Function FliInit(const filename : string) : Boolean;
Function FliDone : Boolean;
Function FliReadFrame : Boolean;
Function FliDisplayFrame( screen : pointer ) : Boolean;

Type
	FLIHEADER = RECORD
	  size   : longint;
	  magic  : word;
	  frames : word;
	  width  : word;
	  height : word;
	  depth  : word;
	  flags  : word;
	  speed  : word;
	  next   : longint;
	  frit   : longint;
	  pad    : array[1..102] of byte;
	end;

VAR
	header : FLIHEADER;
	cmap_changed : Boolean;


IMPLEMENTATION

Type
	FLIFRAME = RECORD
	  size   : longint;
	  magic  : word;
	  chunks : word;
	  pad1, pad2 : longint;
	end;
	FLICHUNK = RECORD
		size  : longint;
		id    : word;
	end;
	pChunk = ^FLICHUNK;
	FliBuffer = array[0..65534] of byte;

VAR
	f : FILE;
	frame : FLIFRAME;
	buffer : ^FliBuffer;
	bFrameRead : Boolean; {sanity check}

{$I-}

(*========================================================*)


Function FliReadHeader : Boolean;
var
 Result : word;
Begin
	FliReadHeader:=FALSE;
	BlockRead(f, header, SizeOf(FLIHEADER), Result );
	if IOResult<>0 then exit;
	with header do begin
		if (magic<>$AF11) AND (magic<>$AF12) then exit;  {sanity check}
		if (width > 320) OR (height > 240) OR (depth <> 8) then exit;
	end;
	FliReadHeader:=TRUE;
end;

Function FliInit(const filename : string) : Boolean;
Var
	Result : word;
Begin
	FliInit:=FALSE;
	buffer:=NIL;
	Result:=IOResult; {Clear IOResult}
	Assign(F, filename);
	Reset(F,1);
	if IOResult<>0 then exit;
	if NOT FliReadHeader then exit;
	if MaxAvail<SizeOf(FliBuffer) then exit;
	New( buffer );
	if Ofs(buffer^)<>0 then exit; {FliBuffer must be at segment-border!}
	bFrameRead:=FALSE;
	FliInit:=TRUE;
End;

Function FliDone : Boolean;
Begin
	FliDone:=FALSE;
	if Assigned(buffer) then Dispose( buffer );
	buffer:=NIL;
	Close(f);
	if IOResult<>0 then exit;
	FliDone:=TRUE;
End;

(*========================================================*)


Function FliReadFrame : Boolean;
Begin
	FliReadFrame:=FALSE;

	BlockRead(f, frame, SizeOf(FLIFRAME) );
	if IOResult<>0 then exit;
	if frame.magic<>$F1FA then	exit; {sanity check}

	{read complete frame}
	BlockRead(f, buffer^, frame.size - SizeOf(FLIFRAME) );
	if IOResult<>0 then exit;

	cmap_changed:=FALSE;
	bFrameRead:=TRUE;
	FliReadFrame:=TRUE;
end;

(*========================================================*)

Procedure Fli_color(src : pointer);
Begin
	cmap_changed:=TRUE;
	asm
	  push	 ds
	  mov		 ax,ds
	  mov		 es,ax
	  lds     si,src
	  lea		 di,CMAP
	  cld
	  lodsw         {get number of colour-chunks}
	  mov		 bx,ax
	  or		 bx,bx
	  jz		 @end
@outerloop:
	  xor		 ax,ax {get palette indexes to skip}
	  lodsb
	  add     di,ax {*3}
	  add     di,ax
	  add     di,ax
	  xor		 ax,ax {get number of colours to paste}
	  lodsb
	  mov		 cx,ax
	  or		 cx,cx
	  jnz		 @no0
	  mov		 cx,256
@no0:mov		 ax,cx {*3}
	  add		 ax,ax
	  add		 cx,ax
	  rep movsb
	  dec		 bx
@end:jnz		 @outerloop
	  pop     ds
	end;
End;

Procedure Fli_color256(src : pointer);
Begin
	cmap_changed:=TRUE;
	asm
	  push	 ds
	  mov		 ax,ds
	  mov		 es,ax
	  lds     si,src
	  lea		 di,CMAP
	  cld
	  lodsw         {get number of colour-chunks}
	  mov		 bx,ax
	  or		 bx,bx
	  jz		 @end
@outerloop:
	  xor		 ax,ax {get palette index}
	  lodsb
	  add     di,ax {*3}
	  add     di,ax
	  add     di,ax
	  xor		 ax,ax {get number of colours in chunk}
	  lodsb
	  mov		 cx,ax
	  or		 cx,cx
	  jnz		 @innerloop
	  mov		 cx,256
@innerloop:
	  lodsb
	  sar		 al,2
	  stosb
	  lodsb
	  sar		 al,2
	  stosb
	  lodsb
	  sar		 al,2
	  stosb
	  loop    @innerloop
	  dec		 bx
@end:jnz		 @outerloop
	  pop     ds
	end;
End;


Procedure Fli_black( dst : pointer ); assembler;
Asm
	LES     DI,DST
	XOR     AX,AX
	MOV     CX,32000
	CLD
	REP     STOSW
End;

Procedure Fli_lc( src : pointer; dst : pointer ); assembler;
Var
	LineCt : word;
Asm
	PUSH    DS
	LDS	  SI,SRC
	LES     DI,DST
	CLD
	LODSW
	MOV     DX,320
	MUL     DX
	ADD     DI,AX
	LODSW
	MOV     LINECT,AX
	MOV     DX,DI
	XOR     AH,AH
@LINELP2:
	MOV     DI,DX
	LODSB
	MOV     BL,AL
	OR      BL,BL
	JMP     @ENDULCLOOP2
@ULCLOOP2:
	LODSB
	ADD     DI,AX
	LODSB
	OR      AL,AL
	JS      @ULCRUN2
	MOV     CX,AX
	SHR     CX,1
	REP     MOVSW
	ADC     CX,0
	REP     MOVSB
	DEC     BL
	JNZ     @ULCLOOP2
	JMP     @ULCOUT2
@ULCRUN2:
	NEG     AL
	MOV     CX,AX
	LODSB
	REP     STOSB
	DEC     BL
@ENDULCLOOP2:
	JNZ     @ULCLOOP2
@ULCOUT2:
	ADD     DX,320
	DEC     LINECT
	JNZ     @LINELP2
	POP     DS
End;

Procedure Fli_delta( src : pointer; dst : pointer ); assembler;
Var
	LineCt : word;
Asm
	PUSH    DS
	LDS	  SI,SRC
	LES     DI,DST
	CLD
	LODSW
	MOV     LINECT,AX
	MOV     DX,DI
@LINELP:
	MOV     DI,DX
	LODSW
	OR		  AX,AX
	JNS     @NOSKIPLINE
	NEG	  AX
	DEC     AX
	PUSH    DX
	MOV     DX,320
	MUL     DX
	POP	  DX
	ADD     DX,AX
	JMP     @ULCOUT
@NOSKIPLINE:
	MOV     BX,AX
	OR      BX,BX
	JMP     @ENDULCLOOP
@ULCLOOP:
	XOR     AH,AH
	LODSB
	ADD     DI,AX
	LODSB
	OR      AL,AL
	JS      @ULCRUN
	MOV     CX,AX
	REP     MOVSW
	DEC     BX
	JNZ     @ULCLOOP
	JMP     @ULCOUT
@ULCRUN:
	NEG     AL
	MOV     CX,AX
	LODSW
	REP     STOSW
	DEC     BX
@ENDULCLOOP:
	JNZ     @ULCLOOP
@ULCOUT:
	ADD     DX,320
	DEC     LINECT
	JNZ     @LINELP
	POP     DS
End;

Procedure Fli_brun( src : pointer; dst : pointer );
Var
	LineCt : word;
Begin
	LineCt:=header.height;
	asm
	  PUSH    DS
	  LDS		 SI,SRC
	  LES     DI,DST
	  MOV     DX,DI
	  XOR     AH,AH
	  CLD
@LINELP:
	  MOV     DI,DX
	  LODSB
	  MOV     BL,AL
	  OR      BL,BL
	  JMP     @ENDULCLOOP
@ULCLOOP:
	  LODSB
	  OR      AL,AL
	  JS      @UCOPY
	  MOV     CX,AX
	  LODSB
	  REP     STOSB
	  DEC     BL
	  JNZ     @ULCLOOP
	  JMP     @ULCOUT
@UCOPY:
	  NEG     AL
	  MOV     CX,AX
	  SHR     CX,1
	  REP     MOVSW
	  ADC     CX,0
	  REP     MOVSB
	  DEC     BL
@ENDULCLOOP:
	  JNZ     @ULCLOOP
@ULCOUT:
	  ADD     DX,320
	  DEC     LINECT
	  JNZ     @LINELP
	  POP     DS
	end;
End;

Procedure Fli_copy( src : pointer; dst : pointer ); assembler;
Asm
	PUSH    DS
	LES     DI,DST
	LDS     SI,SRC
	MOV     CX,32000
	CLD
	REP     MOVSW
	POP     DS
End;

Function FliDisplayFrame( screen : pointer ) : Boolean;
var
	i : integer;
	pos, size : word;
	chunk : pChunk;
Begin
	FliDisplayFrame:=FALSE;
	if NOT bFrameRead then exit;

	{parse chunks}
	pos:=0;
	for i:=1 to frame.chunks do begin
		chunk:=@buffer^[pos];
		Inc( pos, SizeOf(FLICHUNK) );
		case (chunk^.id) of
		 4  : Fli_color256(@buffer^[pos]);
		 7  : Fli_delta(@buffer^[pos],screen);
		 11 : Fli_color(@buffer^[pos]);
		 12 : Fli_lc(@buffer^[pos],screen);
		 13 : Fli_black(screen);
		 15 : Fli_brun(@buffer^[pos],screen);
		 16 : Fli_copy(@buffer^[pos],screen);
		end;
		Inc( pos, chunk^.size - SizeOf(FLICHUNK) );
	end;

	bFrameRead:=FALSE;
	FliDisplayFrame:=TRUE;
End;


end.
