UNIT DEMOINIT;
{
  DEMOINIT
  - unit programmed by Bjarke Viksoe

  Started at: mar 1994
  Last revised: 27. jan 1996
}

INTERFACE

{$S-,F-,B-,R-,G+}
{$IFDEF DPMI}
{$C FIXED PRELOAD PERMANENT}
{$ENDIF}

Uses
	DOS;

Const
	{screen constants}
	WIDTH = 80;
	HEIGHT = 200;
	SCRSIZE = 65528;
	{assmebler '386 opcodes/prefixes}
	FS = $64;
	GS = $65;
	LONG = $66;
	PUSHA = $60;
	POPA = $61;
	{screen modes}
	MODE320x200x256 = $13;
	MODE320x200x16 = $D;
	TEXTMODE = $3;

Type
	pScreen = ^tScreen;
	tScreen = array[0..SCRSIZE] of byte;


Function  IsVGA : boolean;
Procedure SetScreenMode(x : word);
Procedure OpenScreen;
Procedure Get400Lines;
Procedure InModeX;
Procedure CloseScreen;
Procedure ClearWholeScreen;
Function  GetFont : pointer;
Function  GetAdjMem(p : pointer; Size : word) : pointer;
Procedure VBLANK;
Procedure VBLANK_QUICK;
Procedure HBLANK;
Procedure Screen_On;
Procedure Screen_Off;
Procedure SetAddress(a : pointer);
Procedure SetRGB(colour : integer; r,g,b : byte);
Procedure GetRGB(colour : integer; var r,g,b : byte);

Procedure SetDisplayWidth(count : byte);
Procedure SetPelPan(count : byte);
Procedure SetReadMap(value : byte);
Procedure SetBitplanes(planes : byte);
inline(
	$BA/$C4/$03/	{mov	dx,$3C4}
	$58/				{pop	ax}
	$88/$C4/			{mov	ah,al}
	$B0/$02/			{mov	al,$02}
	$EF);				{out	dx,ax}
Procedure SetWriteMode(const m : byte);
Procedure SetDataRotateRegister(f,r : byte);
Procedure SetLineRepeat(const nr : Byte);
Procedure SetSetReset(x : byte);
inline(
	$BA/$CE/$03/	{mov	dx,$3CE}
	$58/				{pop	ax}
	$88/$C4/			{mov	ah,al}
	$B0/$00/			{mov	al,$00}
	$EF);				{out	dx,ax}
Procedure SetESetReset(x : byte);
inline(
	$BA/$CE/$03/	{mov	dx,$3CE}
	$58/				{pop	ax}
	$88/$C4/			{mov	ah,al}
	$B0/$01/			{mov	al,$01}
	$EF);				{out	dx,ax}
Procedure SetBitMaskRegister(x : byte);
inline(
	$BA/$CE/$03/	{mov	dx,$3CE}
	$58/				{pop	ax}
	$88/$C4/			{mov	ah,al}
	$B0/$08/			{mov	al,$08}
	$EF);				{out	dx,ax}

Procedure CLI; inline($FA);
Procedure STI; inline($FB);

Procedure SetAllInterrupts;
Procedure RestoreAllInterrupts;
Procedure SetKbdInterrupt;
Procedure RestoreKbdInterrupt;
Procedure SetTimerInterrupt;
Procedure RestoreTimerInterrupt;

Function  KeyPressed : boolean;
Function  ReadTimer : integer;

Function LongDiv(x : longint; y : integer) : integer;
inline($59/$58/$5A/$F7/$F9);
Function LongMul(x, y : integer) : longint;
inline($5A/$58/$F7/$EA);

Function maxi(a,b:integer):integer;
inline(
	$58/        {pop   ax}
	$5b/        {pop   bx}
	$3b/$c3/    {cmp   ax,bx}
	$7f/$01/    {jg    $+1}
	$93);       {xchg  ax,bx}
Function mini(a,b:integer):integer;
inline(
	$58/        {pop   ax}
	$5b/        {pop   bx}
	$3b/$c3/    {cmp   ax,bx}
	$7c/$01/    {jl    $+1}
	$93);       {xchg  ax,bx}
Function rangei(value,min,max:integer):integer;
inline(
	$59/        {pop   cx (max)}
	$5B/        {pop   bx (min)}
	$58/        {pop   ax (val)}
	$3B/$C3/    {cmp   ax,bx}
	$7F/$03/    {jg    $+3}
	$93/        {xchg  ax,bx}
	$Eb/$05/    {jmp   $+5}
	$3B/$C1/    {cmp   ax,cx}
	$7C/$01/    {jl    $+1}
	$91);       {xchg  ax,cx}

Const
	{Vertival Retrace Timer setup...
	 Set timeout to 0 to auto-sync to vblank
	 Another value will make n interrupts per frame. Use TIMESLACK to
	 give interrupt some time to process. Eg. TIMEOUT=1, TIMESLACE=-300}
	TIMEOUT : word = 0;			 {number of interrupts pr frame}
	TIMESLACK : integer = -300; {interrupt timer slack}
	EXECBIOSTIMER : boolean = TRUE; {still execute bios timer interrupt?}
	{$IFNDEF VER70}
		SEGA000 : word = $A000; {emulate BP7.0 SEGA000 variabel for real-mode}
	{$ENDIF}

Var
	Key : char;
	ytabel : array[0..240] of word; {ytabel with mul #80}
	KeyHit : array[0..127] of boolean; {array of hit keys}
	{vertical retrace counter}
	retraces : word;
	total_retraces : word;
	{pointer to user-interrupt hook}
	timerproc : Procedure;
	{store old interrupt-pointers}
	Int08Save : Procedure;
	Int09Save : Procedure;

(*-----------------------------------------*)

IMPLEMENTATION

Const
	keymap : string =
' e1234567890-=  QWERTYUIOP[]  ASDFGHJKL;`\  ZXCVBNM,./                                                                      ';

Var
	OldScreenMode : byte;
	OldExitProc : pointer;

	SpecialKeys : byte;
	TimeSet : word;
	timercount : integer;
	bioscount : word;

	KeyInstalled : boolean;
	TimerInstalled : boolean;

(*-----------------------------------------*)

{$F+}
Procedure ScreenExitProc;
{$F-}
Begin
	ExitProc:=OldExitProc;
	if (ExitCode<>0) then CloseScreen; {if runtime error, restore screen}
End;

Function IsVGA : boolean; assembler;
Asm
	mov	ax,$1A00
	int	$10
	cmp	al,$1A
	je		@ok
	mov	ax,FALSE
	jmp	@done
@ok:
	mov	ax,TRUE
@done:
End;

Procedure SetScreenMode(x : word); assembler;
Asm
	mov	ax,x
	xor	ah,ah
	int	$10
End;

Procedure OpenScreen;
{Setup Tweak-VGA screen}
Var
	i : integer;
Begin
	for i:=0 to 240 do ytabel[i]:=i*WIDTH;

	asm
		mov	ah,$0F					{ Fetch the current videomode }
		int	$10						{ and save it }
		mov	[OldScreenMode],al
	end;

	SetScreenMode($13);

	{Setup tweaked vga mode - or unchained mode 320x200x256}
	CLI;
	PortW[$3C4]:=$0604; {turn off chain-4}
	ClearWholeScreen;
	PortW[$3D4]:=$0014; {turn off doubleword mode}
	PortW[$3D4]:=$E317; {turn off word-mode}
	STI;

	OldExitProc:=ExitProc;
	ExitProc:=@ScreenExitProc;
End;

Procedure Get400Lines;
{After calling OpenScreen, you can call this to get 320x400x256}
Begin
	PortW[$3D4]:=$4009;
end;

Procedure InModeX;
{Put screen in tweaked 320x240x256, also called ModeX.
 OpenScreen must be called previously}
begin
	CLI;
	Port[$3C2]:=$E3;
	PortW[$3D4]:=$2C11;
	PortW[$3D4]:=$0D06;
	PortW[$3D4]:=$3E07;
	PortW[$3D4]:=$EA10;
	PortW[$3D4]:=$AC11;
	PortW[$3D4]:=$DF12;
	PortW[$3D4]:=$E715;
	PortW[$3D4]:=$0616;
	STI;
End;


Procedure CloseScreen;
Begin
{	SetScreenMode(OldScreenMode);}
	SetScreenMode(TEXTMODE);
End;


Function GetFont : pointer; assembler;
Asm
	push	bp
	mov 	ax,1130h
	mov 	bh,1
	int	10h
	mov	dx,es
	mov	ax,bp
	pop	bp
End;

(*-----------------------------------------*)

Function GetAdjMem(p : pointer; Size : word) : pointer;
Begin
	if Word(Size+15)>Size then Inc(Size,15) else Size:=65535;
	GetMem(P,Size);
{$IFNDEF DPMI}
	if Ofs(P^)<>0 then P:=Ptr(Seg(P^)+1,0);
{$ENDIF}
	GetAdjMem:=p;
End;

Procedure VBLANK; assembler;
{Wait for the next vertical retrace}
Asm
	cmp	[TimerInstalled],TRUE
	je		@timerinstalled
	mov	dx,$3DA
@wait1: {if we are in retrace, wait 'till we are not...}
	in		al,dx
	test	al,8
	jnz	@wait1
@wait2: {wait for a new retrace}
	in		al,dx
	test	al,8
	jz		@wait2
	jmp	NEAR PTR @done

@timerinstalled:
	mov	ax,[total_retraces]
@wait3:
	cmp	ax,[total_retraces]
	je		@wait3
@done:
End;

Procedure VBLANK_QUICK; assembler;
{Wait 'till we are in a vertical retrace}
Asm
	cmp	[TimerInstalled],TRUE
	je		@timerinstalled
	mov	dx,$3DA
@wait1: {wait for a new retrace}
	in		al,dx
	test	al,8
	jz		@wait1
	jmp	NEAR PTR @done

@timerinstalled:
	mov	ax,[total_retraces]
@wait2:
	cmp	ax,[total_retraces]
	je		@wait2
@done:
End;

Procedure HBLANK; Assembler;
{Wait 'till next horizontal retrace}
Asm
	mov dx,$3DA
@1:
	in al,dx
	test al,1
	jnz @1
@2:
	in al,dx
	test al,1
	jz @2
END;

Procedure SCREEN_OFF; assembler;
{Turn screen off. Give maximum bandwith to CPU!}
Asm
	cli
	mov	dx,$3C4
	mov	al,$01
	out	dx,al
	inc	dx
	in		al,dx
	or		al,$20
	out	dx,al
	sti
End;

Procedure SCREEN_ON; assembler;
{Turn screen on again after a "SCREEN_OFF"}
Asm
	cli
	mov	dx,$3C4
	mov	al,$01
	out	dx,al
	inc	dx
	in		al,dx
	and	al,NOT $20
	out	dx,al
	sti
End;

Procedure SetAddress(a : pointer); assembler;
{Set the start offset for VGA display.
 Segment in "a" discarded. Only offset is used!}
Asm
	mov	ax,WORD PTR [a]
	mov	dx,$3D4
	mov	bh,al
	mov	al,$C
	mov	bl,$D
	out	dx,ax
	mov	ax,bx
	out	dx,ax
End;

Procedure SetPelPan(count : byte);
{Set pel panning register}
Var
	i : byte;
Begin
	i:=Port[$3DA]; {reset ATC addressing, dummy input}
	Port[$3C0]:=$33; {palette address source=1; index=$13}
	Port[$3C0]:=count;
End;

Procedure SetDisplayWidth(count : byte);
{Set number of bytes pr. virtual display row}
Begin
	Port[$3D4]:=$13;
	Port[$3D5]:=count;
End;

Procedure SetReadMap(value : byte);
{Set the "read map selector" register}
Begin
	Port[$3CE]:=$04;
	Port[$3CF]:=value;
End;

Procedure SetRGB(colour : integer; r,g,b : byte); assembler;
{Set a colour's RGB values. Colour is [0..255], r,g and b is [0..63]!}
Asm
	mov	dx,$3C8
	mov	ax,[colour]
	out	dx,al
	inc	dx
	mov	al,[r]
	out	dx,al
	mov	al,[g]
	out	dx,al
	mov	al,[b]
	out	dx,al
End;

Procedure GetRGB(colour : integer; VAR r,g,b : byte);
Begin
	Port[$3C7]:=colour;
	r:=Port[$3C9];
	g:=Port[$3C9];
	b:=Port[$3C9];
End;

Procedure SetLineRepeat(const nr : Byte);
{Set VGA scan-line repeat}
Begin
	Port[$3D4]:=9;
	Port[$3D5]:=Port[$3D5] AND $F0+nr;
End;

Procedure SetWriteMode(const m : byte);
Begin
	Port[$3CE]:=$05;
	Port[$3CF]:=(Port[$3CF] AND $FC) OR (m AND 3);
End;

Procedure SetDataRotateRegister(f,r : byte);
{Set the Data Rotate Register}
Begin
	Port[$3CE]:=$03;
	Port[$3CF]:=(f SHL 3) OR r;
End;


(*-----------------------------------------*)


Procedure ClearWholeScreen; assembler;  { clear video memory }
Asm
	mov	dx,$3C4
	mov	ax,$0F02
	out	dx,ax

	mov	es,[SEGA000]
	xor	di,di
	xor	ax,ax
	mov	cx,$10000/2
	cld
	rep stosw
End;

Procedure SetTimer(x : word); assembler;
Asm
	cli
	mov	al,$36
	out	$43,al
	jmp	@1
@1:mov	ax,[x]
	out	$40,al
	jmp	@2
@2:mov	al,ah
	out	$40,al
	jmp	@3
@3:sti
End;

Function ReadTimer : integer; assembler;
Asm
	cli
	xor	al,al
	out	$43,al
	in		al,$40
	mov	ah,al
	in		al,$40
	xchg	al,ah
	neg	ax
	sti
End;


(*-----------------------------------------*)

{$F+,S-}
Procedure KbdHandler; interrupt; assembler;
{$F-}
Asm
	in		al,$60
	mov	bl,al

	in		al,$61
	or		al,$80
	out	$61,al
	and	al,$7F
	out	$61,al

	mov	al,$20
	out	$20,al

	cmp	bl,$E0
	jne	@notE0
	add	[SpecialKeys],0 {next char is real one}
	jmp   NEAR PTR @done
@notE0:
	cmp	bl,$E1
	jne	@notE1
	add	[SpecialKeys],2 {next is bogus char, then control char (skipped)}
	jmp	NEAR PTR @done
@notE1:
	cmp	[SpecialKeys],0
	jz		@nospeckey
	dec	[SpecialKeys]
	jmp	NEAR PTR @done
@nospeckey:

	mov	al,bl
	and	bx,$7F	{remove hitstatus bit and clear BH}
	inc	bx			{skip string-length byte}
	and	al,al
	jns	@pressing
	mov	BYTE PTR [bx+OFFSET keyhit],FALSE
	mov	al,[bx+OFFSET keymap]
	mov	[Key],al
	jmp	NEAR PTR @done
@pressing:
	mov	BYTE PTR [bx+OFFSET keyhit],TRUE
@done:
End;

{$F+,S-}
Procedure TimerHandler; interrupt; assembler;
{$F-}
Asm
	cli
	inc	[timercount]
	mov	ax,[TIMEOUT]
	cmp	[timercount],ax
	jb		@noretrace
	mov	[timercount],0

	{wait for a vertical retrace}
	mov	dx,$3DA
@vblank:
	in		al,dx
	test	al,8
	jz		@vblank

	{set timer again}
	mov	al,$36
	out	$43,al
	jmp	@1
@1:mov	ax,[TimeSet]
	out	$40,al
	jmp	@2
@2:mov	al,ah
	out	$40,al

	{increase timer counters}
	inc	[retraces]
	inc	[total_retraces]

	{should we call user-defined hook?}
	mov	ax,WORD PTR [TimerProc]
	or		ax,WORD PTR [TimerProc+2]
	jz		@nouserproc
	sti
	call	DWORD PTR [TimerProc]
	cli
@nouserproc:

	cmp	[execbiostimer],FALSE
	je		@nobiostimer
	mov	ax,[TimeSet]
	add	[bioscount],ax
	jno	@nobiostimer
	sti
	pushf
	call	DWORD PTR [Int08Save]
	jmp	NEAR PTR @xit
@nobiostimer:

@noretrace:
	mov	al,$20
	out	$20,al
	sti
@xit:
End;


Function GetVBLANKTime : word; assembler;
{Find time between two vertical retraces...}
Asm
	mov	dx,$3DA   {wait for a vertical retrace to begin}
@wait1a:
	in		al,dx
	test	al,8
	jnz	@wait1a
@wait1b:
	in		al,dx
	test	al,8
	jz		@wait1b

	mov	al,$36
	out	$43,al
	nop
	xor	al,al		{ reset the timer }
	out	$40,al
	nop
	out	$40,al

	mov	dx,$3DA   {wait for a new vertical retrace to begin}
@wait2a:
	in		al,dx
	test	al,8
	jnz	@wait2a
@wait2b:
	in		al,dx
	test	al,8
	jz		@wait2b

	xor	al,al
	out	$43,al
	in		al,$40
	mov	ah,al
	in		al,$40		{ read timer count - time between }
	xchg	al,ah       { two Vertical Retraces }
	neg	ax
End;


Function SyncTimerToVBLANK : word; assembler;
Const
	FRAMEPERCENT = 975; {returned time will be 97.5% of measured value}
Asm
	xor	bx,bx
@GetFrameTime:
	push	bx
	cli									{ Don't bother us while timing things }
	call	GetVBLANKTime
	push	ax
	call	GetVBLANKTime
	pop	dx
	sti
	pop	bx
	inc	bx                      { make sure we don't loop endlessly }
	cmp	bx,10
	ja    @urgh
	sub	dx,ax
	cmp  	dx,5                    { If the difference between the two }
	jg		@GetFrameTime           { values read was >5, read again }
	cmp	dx,-5
	jl		@GetFrameTime
@urgh:
	mov	bx,FRAMEPERCENT
	mul	bx
	mov	bx,1000
	div	bx
	shr	ax,1
End;


Procedure SetTimerInterrupt;
Begin
	retraces:=0; total_retraces:=0; timercount:=0;
	TimeSet:=$FFFF;
	GetIntVec($08,@Int08Save);
	SetIntVec($08,addr(TimerHandler));
	if (TIMEOUT<>0) then
		TimeSet := ($1234DD DIV 70 DIV TIMEOUT)+TIMESLACK
	else
		TimeSet:=SyncTimerToVBLANK;
	SetTimer(TimeSet);
	TimerInstalled:=TRUE;
end;

Procedure RestoreTimerInterrupt;
Begin
	if NOT TimerInstalled then exit;
	SetIntVec($08,@Int08Save);
	SetTimer(0);
	TimerInstalled:=FALSE;
End;

Procedure SetKbdInterrupt;
Var
	i : integer;
Begin
	Key:=#0;
	SpecialKeys:=0;
	for i:=1 to sizeof(KeyHit) do KeyHit[i]:=FALSE;
	GetIntVec($09,@Int09Save);
	SetIntVec($09,addr(KbdHandler));
	KeyInstalled:=TRUE;
End;

Procedure RestoreKbdInterrupt;
Begin
	if NOT KeyInstalled then exit;
	SetIntVec($09,@Int09Save);
	KeyInstalled:=FALSE;
End;

Procedure SetAllInterrupts;
Begin
	SetTimerInterrupt;
	SetKbdInterrupt;
(*	Port[$21]:=$5C; {Turns off IRQ 2,3,4, and 6}*)
End;

Procedure RestoreAllInterrupts;
Begin
	RestoreTimerInterrupt;
	RestoreKbdInterrupt;
(*	Port[$21]:=0; {Give life back to IRQs}*)
End;

Function KeyPressed : boolean;
{Test if a key has been struck}
Begin
	if (KeyInstalled) then KeyPressed:=Key<>#0
	else asm
		mov	ah,1
		int	$16
		jnz	@yes
		mov	[@result],FALSE
		jmp	NEAR PTR @done
@yes:	mov	[@result],TRUE
@done:
	end;
End;


(*-----------------------------------------*)


Begin
	TimerProc:=NIL;
	TimerInstalled:=FALSE;
	KeyInstalled:=FALSE;
End.

