UNIT PICTURE;
{
	Unit PICTURE
	- by Bjarke Viksoe
	aug 1994

	An unit with various picture handling routines.
	Mostly called by the ILBM256, PCX256 and the likes to handle
	common screen and CMAP routines.
	Also picture copying.
}

INTERFACE

USES
	DEMOINIT;

CONST
	BUFFERBASE = 1;
TYPE
	pBuffer = ^tBuffer;
	tBuffer = array[BUFFERBASE..64000] of byte;

VAR
	CMAP : array[1..256*3] of byte;


Procedure SetCMAP;
Procedure FadeCMAP(faktor : integer);
Procedure LoadCMAP(filename : string);

Procedure Copy2Screen(v : pointer; s : pointer);
Procedure Copy2TweakScreen(v : pScreen; s : pScreen);
Procedure MakeTweak(source : pointer; dest : pointer);


(*----------------------------------------*)


IMPLEMENTATION

Procedure SetCMAP; assembler;
{Set all colours from CMAP to VGA palette quickly}
Asm
	cli
	lea	si,CMAP
	xor	al,al
	mov	dx,$3C8
	out	dx,al
	inc	dx
	mov	cx,256*3
	cld
	rep outsb
	sti
End;

Procedure LoadCMAP(filename : string);
{Loads a .COL file into current CMAP array. Use SetCMAP to make actual change}
Var
	f : file;
Begin
{$I-}
	Assign(f, filename);
	Reset(f,1);
	BlockRead(f, CMAP, SizeOf(CMAP));
	if IOResult<>0 then FillChar(CMAP, SizeOf(CMAP), 0);
{$I+}
End;

Procedure FadeCMAP(faktor : integer);
{Fade CMAP. Factor = [0..255]. If factor is 0 then colours are black!}
Var
	i : integer;
	newCMAP : array[1..256*3] of byte;
Begin
	for i:=1 to 256*3 do
		newCMAP[i]:=LongMul(CMAP[i],faktor) SHR 8;

	VBLANK_QUICK;
	asm
		cli
		push	ds
		push	ss {make SS new DS}
		pop	ds
		lea	si,newCMAP
		xor	al,al
		mov	dx,$3C8
		out	dx,al
		inc	dx
		mov	cx,256*3
		rep outsb
		pop	ds
		sti
	end;
End;


(*----------------------------------------*)

Procedure Copy2Screen(v : pointer; s : pointer); assembler;
{Copy picture buffer to another (might be the screen). Not tweaked, though}
Asm
	push	ds
	lds	si,v
	les	di,s
	cld
	mov	cx,320*200/2
	rep movsw
	pop	ds
End;

Procedure Copy2TweakScreen(v : pScreen; s : pScreen);
{Copy picture buffer to a tweaked screen display}
	Procedure CopyPlane(v : pScreen; s : pScreen); assembler;
	Asm
		push	ds
		lds	si,v
		les	di,s
		cld
		mov	cx,80*200/2
		rep movsw
		pop	ds
	End;
Const
	SIZE = 80*200;
Begin
	SetBitplanes(1);
	CopyPlane(@v^[0],s);
	SetBitplanes(2);
	CopyPlane(@v^[SIZE+0],s);
	SetBitplanes(4);
	CopyPlane(@v^[SIZE*2+0],s);
	SetBitplanes(8);
	CopyPlane(@v^[SIZE*3+0],s);
End;


Procedure MakeTweak(source : pointer; dest : pointer);
{Copy memory buffer to another, but make new buffer bonus-tweaked}
Var
	i,scroffset : integer;
Begin
	scroffset:=0;
	for i:=0 to 3 do begin
		asm
			push	ds
			lds	si,source
			les	di,dest
			add	si,i
			add	di,scroffset
			mov	cx,80*200
			mov	dx,4-1
			cld
@loop:	movsb
			add	si,dx
			loop	@loop
			pop	ds
		end;
		Inc(scroffset,80*200);
	end;
End;


(*----------------------------------------*)

End.
