UNIT TGA256;
{
	TGA256
	- by Bjarke Viksoe

	Converts Truevision TARGA image files in format 320x200 in 256 colours
	to a raw image.
	Little IO checking. Little picturesize checking.
	Picture must be uncompressed or RLE compressed.
}

INTERFACE

USES
	DEMOINIT, PICTURE;


Procedure LoadPix(buffer : pScreen; filename : string);
Procedure ConvertTGA(p : pScreen; v : pBuffer);


(*--------------------------------------*)

IMPLEMENTATION

{$I-}

TYPE
	pHeader = ^HeaderType;
	HeaderType = RECORD
		ImageIDSize    : byte;
		ColorMapType   : byte;
		ImageTypeCode  : byte;
		ColorMapOrigin : word;
		ColorMapLength : word;
		ColorMapESize  : byte;
		pad            : array[1..2] of word;
		Width, Height  : word;
		Depth          : byte;
		ImageDescrip   : byte;
	end;


Procedure ExtractCMAP(h : pHeader; v : pBuffer; pos : word);
Var
	i,j,k : word;
Begin
	with h^ do begin
		if ColorMapLength = 0 then exit;
		i:=(ColorMapOrigin*3)+Low(CMAP);
		j:=pos + (ColorMapOrigin*(ColorMapESize SHR 3));
		for k:=1 to ColorMapLength do begin
			CMAP[i]:=v^[j+2] SHR 2;
			CMAP[i+1]:=v^[j+1] SHR 2;
			CMAP[i+2]:=v^[j] SHR 2;
			Inc(i,3);
			Inc(j,ColorMapESize SHR 3);
		end;
	end;
End;

Procedure DecompressTGA(h : pHeader; src : pointer; dst : pointer);
Var
	ImageSize : word;
Begin
	ImageSize := h^.Width * h^.Height;
	if ImageSize=0 then exit;

	asm
		push	ds
		les	di,[dst]
		lds	si,[src]
		xor	dx,dx
		cld
@TGA_loop:
		xor	ah,ah
		lodsb
		or		al,al
		js		@TGA_lower
		inc	ax
		add	dx,ax
		mov	cx,ax
		rep movsb
		cmp	dx,[ImageSize]
		jb		@TGA_loop
		jmp	NEAR PTR @TGA_done
@TGA_lower:
		and	al,127
		inc	ax
		add	dx,ax
		mov	cx,ax
		lodsb
		rep stosb
		cmp	dx,[ImageSize]
		jb		@TGA_loop
@TGA_done:
		pop	ds
	end;
End;

Procedure ConvertTGA(p : pScreen; v : pBuffer);
{Parse tga file}
Var
	pos : word;
	h : pHeader;
Begin
	pos:=Low(tBuffer);
	h := pHeader(@v^[ pos ]);
	with h^ do begin
		{safety check for correct targa file}
		if (h^.Width > 320) OR (h^.Height > 240) OR (h^.Depth <> 8) then exit;
		{get past header and ImageID string}
		Inc( pos, SizeOf(HeaderType) + v^[1] );
		if (ColorMapType=1) then begin
			ExtractCMAP(h, v, pos);
			{get past colormap}
			Inc( pos, ColorMapLength*(ColorMapESize SHR 3) );
		end;
		case (ImageTypeCode) of
		 1: Move( v^[ pos ], p^, Width*Height );
		 9: DecompressTGA(h,@v^[pos],p);
		end;
	end;
End;


Procedure LoadPix(buffer : pScreen; filename : string);
Var
	pFileMem: pBuffer;
	FileHandle : file;
	size : longint;
Begin
	Assign(FileHandle, filename);
	Reset(FileHandle, 1);
	size := FileSize(FileHandle);
	if (size > 65535) then exit;
	if (size > MaxAvail) then exit;
	GetMem(pFileMem, size);
	BlockRead(FileHandle, pFileMem^, size);
	Close(FileHandle);
	if IOResult=0 then
		ConvertTGA(buffer, pFileMem);
	FreeMem(pFileMem, size);
End;

{$I+}

End.
