(****************************************************)
(*   Programming:  Bob Dalton                       *)
(*   Demonstration Program for using Turbo Vision   *)
(*    as a game configuration and setup program     *)
(*    for BBS Doors                                 *)
(****************************************************)

PROGRAM SETUP;    (* Initialization Program -- sets/resets player file *)
{$R-}
{$S+}
{$I+}
{$N-}
{$M 65520,16384,655360}

Uses
 Crt,
 DOS,
 WorldVar,
 App,
 Drivers,
 Objects, {Objects has TRect}
 Views,   {Views has cmXXXX constants}
 Menus,   {Menus has TStatusLine}
 SDialogs;

TYPE
  pCodeLine = ^TCodeLine;
  TCodeLine = object(TStatusLine)
    function Hint(AHelpCtx: Word): string; virtual;
   end;

  TMain = object(TApplication)
   procedure InitStatusLine; virtual;
   procedure InitMenuBar; virtual;
   procedure HandleEvent(var Event: TEvent); virtual;
   procedure Idle; virtual;
  end;

VAR
  Main           : TMain;

{The below function assigns strings to help (hint) commands}
function TCodeLine.Hint(AHelpCtx: Word): String;
begin
   If AHelpCtx < hcExitSave  then Hint := '' {hcExitSave = First item in case list}
   else case AHelpCtx of
      hcExitSave           : Hint := 'Save game configuration settings - Do first!';
      hcNoSave             : Hint := 'Exit program - Be sure to save first!';
      hcFirst              : Hint := 'First Sub-Menu Choice';
      hcSecond             : Hint := 'Second Sub-Menu Choice';
      hcThird              : Hint := 'Third Sub-Menu Choice';
      hcHowManySoldiers    : Hint := 'Starting number of soldiers';
      hcHowManyTanks       : Hint := 'Starting number of tanks';
      hcHowMuchMoney       : Hint := 'Starting amount of money for each player';
      hcHowManyGenerals    : Hint := 'Starting number of generals';
      else Hint := 'Sorry, no help available for this item.'
      end;
   end;

{The below procedure checks for the presence of a
 three line key.dat file and then reads it. If the
 "RegisterNumber" variable matches "ZULUTRIBE" then
 the variable called "Registered" is returned as
 true, if not then it is returned as false}

Procedure CheckReg(VAR Registered:Boolean);
 VAR DelFile:Text;S:PathStr;X,Z:Integer;
 Begin
   Registered:=False;
   Assign(DelFile,'KEY.DAT');
   Reset(DelFile);
   IF NOT EOF(DelFile) THEN BEGIN
    Readln(DelFile,Buyer);
    Readln(DelFile,NameOfBoard);
    Readln(DelFile,RegisterNumber);
    Close(DelFile);
   If RegisterNumber='ZULUTRIBE' Then REGISTERED:=TRUE;
   End;
End;

{This procedure reads the Month, Day and Year
 from the system and returns the values in the
 variables called "Month", "Day" and "Year"}

Procedure GetDate1(VAR Month:Word;
                   VAR day:Word;
                   VAR year:Word);
 VAR MyRegs:Registers;

 Begin
  MyRegs.AH:=$2A;
  MSDOS(MyRegs);
  Month:=MyRegs.DH;
  Day:=MyRegs.DL;
  Year:=MyRegs.CX;
 End;

{The below function is similar to a string case unit.
 This provides one line "hints" in the turbo vision
 status bar portion of the screen whenever the cursor
 is moved to that portion of the menu which calls the
 hint.}

{This procedure shows the listed items always on the Status line}
procedure TMain.InitStatusLine;
var R: TRect;
begin
   R.Assign(0,24,80,25);
   StatusLine := New(PCodeLine, Init(R,
      NewStatusDef(0, 999,
         StdStatusKeys(
         NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
         nil)),
      nil))); {More stauts definitions here}
   end;

{Shows choices on menu bar and in sub-menu boxes}
procedure TMain.InitMenuBar;
var R   : TRect;
begin
   R.Assign(0,0,80,1); {I suggest you do NOT change this}
   MenuBar := New(PMenuBar, Init(R, NewMenu(
   {Each NewSubMenu Item is another menu choice}
   NewSubMenu('~F~irst ', hcFirst, NewMenu(
      {Each NewItem is another sub-menu choice}
      {Item between ~ ~ are highlighted in color}
      {kbNoKey means no hot key assigned. To assign a key
       would look like this "kbF1"}
      {Items beginning with "cm" are commands}
      {Items beginning with "hc" are hint lines}
      NewItem('~S~ave Settings', 'F1', kbF1, cmExitSave, hcExitSave,
      NewItem('E~x~it Program', 'F2', kbF2, cmQuit, hcNoSave,
      nil))),  {Add a ")" for each additional NewItem you add}
   NewSubMenu('~S~econd  ', hcSecond, NewMenu(
      NewItem('~S~oldiers', '', kbNoKey, cmHowManySoldiers, hcHowManySoldiers,
      NewItem('~T~anks', '', kbNoKey, cmHowManyTanks, hcHowManyTanks,
      nil))), {add on extra ")" for each additional NewItem you add}
   NewSubMenu('~T~hird  ', hcThird, NewMenu(
      NewItem('~M~oney', '', kbNoKey, cmHowMuchMoney, hcHowMuchMoney,
      NewItem('~G~enerals', '', kbNoKey, cmHowManyGenerals, hcHowManyGenerals,
      nil))), {add on extra ")" for each additional NewItem you add}
   nil)))))); {Add an extra ")" for each additional NewSubMenu line}
   end;

Procedure SetupGlob(VAR Glob:GlobRec); {Initialize your record variables}

  Begin
   Glob.Soldiers:=250;{Your default settings per the button setting you made}
   Glob.Tanks   :=3;
   Glob.Money   :=2000;
   Glob.Generals:=1;
  End;

Procedure SaveExit;
 Begin
  Assign(Globfile,'GLOB.DAT');
  ReWrite(Globfile);
  Write(GlobFile,Glob);
  Close(GlobFile);
 End;

procedure TMain.HandleEvent;
begin
   If (Event.What and evCommand)<>0 then
   begin
    case Event.Command of
      {When a submenu item is selected it will call the following case statements}
      {Command}          {Calls this function or procedure}
      cmExitSave       : SaveExit;
      cmHowManySoldiers: HowManySoldiers;
      cmHowManyTanks   : HowManyTanks;
      cmHowMuchMoney   : HowMuchMoney;
      cmHowManyGenerals: HowManyGenerals;
     end;
    end;
   inherited HandleEvent(Event);
   end;

procedure TMain.Idle; {Handles situation when nothing happens}
begin
   inherited Idle;
   end;

Begin
  GetDate1(Month,Day,Year); {Gets the Month, Day and Year from the system}
  Registered:=False;      {Initializes the register variable}
  CheckReg(Registered); {Checks registration}
  SetupGlob(glob); {Initializes the record variables}
  {The next three lines MUST be present or the program will NOT work}
  Main.Init;  {Initializes Turbo Vision}
  Main.Run;   {Runs Turbo Vision}
  Main.Done;  {Closes Turbo Vision}
End.

