/*This is the first example program in EASYX.DOC.  The program is written
for Microsoft C.  The program should be linked with EASYX.LIB.  Borland C
users must change the second line below to:  #include <easyxb.h>, and should
link with EASYXB.LIB.*/

#include <stdio.h>
#include <easyx.h>

long buffer[1024];              /*4k buffer*/

void main(void)
{
  unsigned long errcode, nobytes, xaddress, xsize, xhandle, bufferaddress;

  errcode = INITXLIB();         /*Initialize XLIB*/
  if(errcode != 0)
  {
    printf("Library initialization error:  %lX\n",errcode);
    return;
  }

  nobytes = 0x10000;            /*Allocate 64k of extended memory*/
  errcode = XMALLOC(nobytes, &xaddress, &xsize, &xhandle);
  if(errcode != 0)
  {
    printf("Memory allocation error:  %lX\n",errcode);
    return;
  }

  bufferaddress = LINADR(buffer);          /*Get linear address of buffer*/
  MOVMEM(xaddress, bufferaddress, 4096);   /*Transfer buffer to extended*/
  MOVMEM(bufferaddress, xaddress, 4096);   /*Transfer extended to buffer*/

  errcode = XFREE(xhandle);     /*Release the extended memory*/
  if(errcode != 0)
    printf("Memory release error:  %lX\n",errcode);
}
